;;; Snd tests
;;;
;;;  test 0: constants                           [620]
;;;  test 1: defaults                            [1165]
;;;  test 2: headers                             [1367]
;;;  test 3: variables                           [1682]
;;;  test 4: sndlib                              [2306]
;;;  test 5: simple overall checks               [5034]
;;;  test 6: vcts                                [14049]
;;;  test 7: colors                              [14459]
;;;  test 8: clm                                 [14966]
;;;  test 9: mix                                 [26812]
;;;  test 10: marks                              [29041]
;;;  test 11: dialogs                            [30014]
;;;  test 12: extensions                         [30225]
;;;  test 13: menus, edit lists, hooks, etc      [30494]
;;;  test 14: all together now                   [32091]
;;;  test 15: chan-local vars                    [32988]
;;;  test 16: regularized funcs                  [34788]
;;;  test 17: dialogs and graphics               [39737]
;;;  test 18: enved                              [39829]
;;;  test 19: save and restore                   [39848]
;;;  test 20: transforms                         [41622]
;;;  test 21: new stuff                          [43809]
;;;  test 22: run                                [45805]
;;;  test 23: with-sound                         [52699]
;;;  test 25: X/Xt/Xm                            [57203]
;;;  test 26: Gtk                                [60921]
;;;  test 27: GL                                 [64397]
;;;  test 28: errors                             [64521]
;;;  test all done                               [66987]
;;;  test the end                                [67172]

(define tests 1)
(define keep-going #f)
(define all-args #f)
(define test-at-random 0)
					;(show-ptree 1)
(define profiling #f)

					;(set! *load-hook* (lambda (name) (format #t "load ~S~%" name)))
(if (<= tests 0) (set! tests 1))

(set! *#readers* 
      (cons (cons #\_ (lambda (str)
			(if (string=? str "__line__")
			    (port-line-number)
			    #f)))
            *#readers*))

(if (defined? 'run-clear-counts) (run-clear-counts))

(define O_RDWR 2)
(define O_APPEND 1024)
(define O_RDONLY 0)

(define (copy-file src dest) (system (string-append "cp " src " " dest)))

(define (procedure-property func prop)
  (if (eq? prop 'arity)
      (procedure-arity func)
      (procedure-documentation func)))

(define (string-downcase str)
  (let* ((len (string-length str))
	 (newstr (make-string len)))
    (do ((i 0 (+ 1 i)))
	((= i len))
      (string-set! newstr i (char-downcase (string-ref str i))))
    newstr))

(define (sort lst . opt) (sort! lst (if (null? opt) < (car opt))))

(define* (cfft! data n (dir 1))
  (if (not n) (set! n (length data)))
  (do ((i 0 (+ i 1))
       (j 0))
      ((= i n))
    (if (> j i)
	(let ((temp (data j)))
	  (set! (data j) (data i))
	  (set! (data i) temp)))
    (let ((m (/ n 2)))
      (do () 
	  ((or (< m 2) (< j m)))
	(set! j (- j m))
	(set! m (/ m 2)))
      (set! j (+ j m))))
  (let ((ipow (floor (log n 2)))
	(prev 1))
    (do ((lg 0 (+ lg 1))
	 (mmax 2 (* mmax 2))
	 (pow (/ n 2) (/ pow 2))
	 (theta (make-rectangular 0.0 (* pi dir)) (* theta 0.5)))
	((= lg ipow))
      (let ((wpc (exp theta))
	    (wc 1.0))
	(do ((ii 0 (+ ii 1)))
	    ((= ii prev))
	  (do ((jj 0 (+ jj 1))
	       (i ii (+ i mmax))
	       (j (+ ii prev) (+ j mmax)))
	      ((>= jj pow))
	    (let ((tc (* wc (data j))))
	      (set! (data j) (- (data i) tc))
	      (set! (data i) (+ (data i) tc))))
	  (set! wc (* wc wpc)))
	(set! prev mmax))))
  data)

(define* (fft! rl im n (dir 1))
  (if (not im)
      (let ((clear (copy rl)))
	(fill! clear 0.0)
	(set! im clear)))
  (if (not n)
      (set! n (length rl)))
  (do ((i 0 (+ i 1))
       (j 0))
      ((= i n))
    (if (> j i)
	(let ((tempr (rl j))
	      (tempi (im j)))
	  (set! (rl j) (rl i))
	  (set! (im j) (im i))
	  (set! (rl i) tempr)
	  (set! (im i) tempi)))
    (let ((m (/ n 2)))
      (do () 
	  ((or (< m 2) (< j m)))
	(set! j (- j m))
	(set! m (/ m 2)))
      (set! j (+ j m))))
  (let ((ipow (floor (log n 2)))
	(prev 1))
    (do ((lg 0 (+ lg 1))
	 (mmax 2 (* mmax 2))
	 (pow (/ n 2) (/ pow 2))
	 (theta (* pi dir) (* theta 0.5)))
	((= lg ipow))
      (let ((wpr (cos theta))
	    (wpi (sin theta))
	    (wr 1.0)
	    (wi 0.0))
	(do ((ii 0 (+ ii 1)))
	    ((= ii prev))
	  (do ((jj 0 (+ jj 1))
	       (i ii (+ i mmax))
	       (j (+ ii prev) (+ j mmax)))
	      ((>= jj pow))
	    (let ((tempr (- (* wr (rl j)) (* wi (im j))))
		  (tempi (+ (* wr (im j)) (* wi (rl j)))))
	      (set! (rl j) (- (rl i) tempr))
	      (set! (im j) (- (im i) tempi))
	      (set! (rl i) (+ (rl i) tempr))
	      (set! (im i) (+ (im i) tempi))))
	  (let ((wtemp wr))
	    (set! wr (- (* wr wpr) (* wi wpi)))
	    (set! wi (+ (* wi wpr) (* wtemp wpi)))))
	(set! prev mmax))))
  rl)

(if (not (defined? 'snd-test)) (define snd-test -1))
(define full-test (< snd-test 0))
(define total-tests 28)
(if (not (defined? 'with-exit)) (define with-exit (< snd-test 0)))
(define test-number -1)

(define (snd-display line . args)
  (let ((str (if (null? (cdr args))
		 (car args)
		 (apply format #f args))))
    (format #t "~%~A: ~8T~A" line str)
    (if (not (provided? 'snd-nogui))
	(snd-print (format #f "~%~A: ~A" line str)))))

(define with-big-file #f)
(define big-file-name "/home/bil/zap/sounds/bigger.snd")
(if (and with-big-file 
	 (not (string=? (version) "1.8.0")))
    (begin
      (set! with-big-file (file-exists? big-file-name))
      (if (not with-big-file) (snd-display #__line__ ";no big file"))))
(define big-file-frames 0)

(define original-save-dir (or (save-dir) "~/zap/snd"))
(define original-temp-dir (or (temp-dir) "~/zap/tmp"))
(define original-sound-file-extensions (sound-file-extensions))

(unbind-key #\c 4 #t)
;;; clear out old junk!
(if (file-exists? original-save-dir) 
    (system (format #f "rm ~A/snd_*" original-save-dir)))
(if (file-exists? original-temp-dir) 
    (system (format #f "rm ~A/snd_*" original-temp-dir)))
(if (file-exists? "/tmp")
    (begin ; -noinit possibly
      (system "rm /tmp/snd_*")
      (system "rm /tmp/*.snd")))
(if (file-exists? "/var/tmp")
    (begin ; -noinit possibly
      (system "rm /var/tmp/snd_*")
      (system "rm /var/tmp/*.snd")))
(system "rm core*")

(define home-dir "/home/bil")
(define sf-dir "/sf1")

(if (not (file-exists? (string-append home-dir "/cl/oboe.snd")))
    (if (file-exists? "/export/home/bil/cl/oboe.snd")
	(set! home-dir "/export/home/bil")
	(if (file-exists? "/Users/bil/cl/oboe.snd")
	    (set! home-dir "/Users/bil")
	    (if (file-exists? "/users/b/bil/cl/oboe.snd")
		(set! home-dir "/users/b/bil")))))
(define cwd (string-append (getcwd) "/"))

(define sf-dir1 (string-append home-dir sf-dir "/"))
(if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
    (begin
      (set! sf-dir "/sf")
      (set! sf-dir1 (string-append home-dir sf-dir "/"))
      (if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
	  (begin
	    (snd-display #__line__ ";;;can't find sf directory!")
	    (set! sf-dir1 #f)))))
(set! sf-dir sf-dir1)

(if (not (string=? (getcwd) (string-append home-dir "/cl")))
    (for-each
     (lambda (file)
       (if (not (file-exists? file))
	   (begin
	     (display (format #f "copying ~A~%" file))
	     (copy-file (string-append home-dir "/cl/" file) (string-append (getcwd) "/" file)))))
     (list "4.aiff" "2.snd" "obtest.snd" "oboe.snd" "pistol.snd" "1a.snd" "now.snd" "fyow.snd"
	   "storm.snd" "z.snd" "1.snd" "cardinal.snd" "now.snd.scm" "2a.snd" "4a.snd" "zero.snd"
	   "loop.scm" "cmn-glyphs.lisp" "bullet.xpm" "mb.snd" "funcs.cl" "trumpet.snd")))


;;(setlocale LC_ALL "de_DE")
(set! (with-background-processes) #f)
(define max-optimization 6)
(define sampler-tests 300)

;; try to get a different random number sequence on each run
(set! (mus-rand-seed) (current-time))

(reset-hook! bad-header-hook)
(add-hook! bad-header-hook (lambda (n) #t))

(define with-gui (or (provided? 'snd-gtk)
		     (provided? 'snd-motif)))

(if (not with-gui)
    (define y-bounds (make-procedure-with-setter
		      (lambda args (list -1.0 1.0))
		      (lambda args (list -1.0 1.0)))))

(if (not with-gui)
    (define x-bounds (make-procedure-with-setter
		      (lambda args (list 0.0 0.1))
		      (lambda args (list 0.0 0.1)))))

(if (file-exists? "optimizer.log")
    (delete-file "optimizer.log"))
(define optimizer-log (open-output-file "optimizer.log"))
(define optimizer-test -1)

(reset-hook! optimization-hook)
(define *opt* #f)
(add-hook! optimization-hook 
	   (lambda (msg)
	     (set! *opt* #f)
	     (if (= (optimization) max-optimization)
		 (begin
		   (if (not (= test-number optimizer-test))
		       (begin
			 (display (format #f "-------- test ~A --------~%" test-number) optimizer-log)
			 (set! optimizer-test test-number)))
		   (display msg optimizer-log)
		   (newline optimizer-log)))))

(define (real-time) (exact->inexact (/ (get-internal-real-time) internal-time-units-per-second)))
(define (hundred n) (round (* 100 n)))
(define times '())
(defmacro time (a) 
  `(let ((start (real-time))) 
     ,a 
     (let ((val (hundred (- (real-time) start))))
       (set! times (cons (list ',a val) times)))))

(define original-prompt (listener-prompt))
(set! (show-listener) #t)
(set! (window-x) 600)
(set! (window-y) 10)

(define test14-file #f)

(define (fneq a b) 
  "float equal within .001"
  (> (abs (- a b)) .001))

(define (ffneq a b)
  "float equal within .01"
  (> (abs (- a b)) .01))

(define (fffneq a b) 
  "float equal within .1"
  (> (abs (- a b)) .1))

(define (cneq a b)
  "complex equal within .001"
  (or (> (abs (- (real-part a) (real-part b))) .001)
      (> (abs (- (imag-part a) (imag-part b))) .001)))

(define (feql a b)
  "list equal with fneq"
  (if (null? a)
      (null? b)
      (if (null? b)
	  #f
	  (if (list? (car a))
	      (and (list? (car b))
		   (feql (car a) (car b)))
	      (if (fneq (car a) (car b))
		  #f
		  (feql (cdr a) (cdr b)))))))

(define (ffeql a b)
  "list equal with fffneq"
  (if (null? a)
      (null? b)
      (if (null? b)
	  #f
	  (if (list? (car a))
	      (and (list? (car b))
		   (ffeql (car a) (car b)))
	      (if (fffneq (car a) (car b))
		  #f
		  (ffeql (cdr a) (cdr b)))))))

(define (fveql a b i)
  "vct equal with fneq"
  (if (null? b)
      #t
      (if (fneq (car b) (vct-ref a i))
	  #f
	  (fveql a (cdr b) (+ i 1)))))

(define (vequal v0 v1)
  "general equal with .001"
  (let ((old-fudge (mus-float-equal-fudge-factor)))
    (set! (mus-float-equal-fudge-factor) .001)
    (let ((result (equal? v0 v1)))
      (set! (mus-float-equal-fudge-factor) old-fudge)
      result)))

(define (vequal1 v0 v1)
  "general equal with .01"
  (let ((old-fudge (mus-float-equal-fudge-factor)))
    (set! (mus-float-equal-fudge-factor) .01)
    (let ((result (equal? v0 v1)))
      (set! (mus-float-equal-fudge-factor) old-fudge)
      result)))

(define (vvequal v0 v1)
  "general equal with .00002"
  (let ((old-fudge (mus-float-equal-fudge-factor)))
    (set! (mus-float-equal-fudge-factor) .00002)
    (let ((result (equal? v0 v1)))
      (set! (mus-float-equal-fudge-factor) old-fudge)
      result)))

(define (vmaxdiff v0 v1)
  (vct-peak (vct-subtract! (vct-copy v0) v1)))

(define (sd-equal v0 v1)
  "sound-data equal within .001"
  (let ((old-fudge (mus-float-equal-fudge-factor)))
    (set! (mus-float-equal-fudge-factor) .001)
    (let ((result (equal? v0 v1)))
      (set! (mus-float-equal-fudge-factor) old-fudge)
      result)))

(define* (my-substring str start end)
  "substring with end"
  (substring str start (or end (string-length str))))

(define (string-=? a b)
  "string=? but ignore -0.0"
  (or (string=? a b)
      (let* ((alen (string-length a))
	     (blen (string-length b))
	     (j 0)
	     (happy #t))
	(do ((i 0 (+ 1 i)))
	    ((or (not happy) 
		 (= i alen))
	     (and happy 
		  (= j blen)))
	  (let ((ac (string-ref a i))
		(bc (string-ref b j)))
	    (if (char=? ac bc)
		(set! j (+ 1 j))
		(if (not (and (char=? ac #\-)	
			      (<= i (- alen 7))
			      (string=? (substring a i (+ i 6)) "-0.000")))
		    (if (and (char=? bc #\-)
			     (<= j (- blen 7))
			     (string=? (substring b j (+ j 6)) "-0.000"))
			(begin
			  (set! j (+ 1 j))
			  (if (not (char=? ac (string-ref b j)))
			      (set! happy #f)
			      (set! j (+ 1 j))))
			(set! happy #f)))))))))

(define (dismiss-all-dialogs)
  "(dismiss-all-dialogs) hides all dialogs"
  (if (or (provided? 'xm)
	  (provided? 'xg))
      (for-each
       (lambda (dialog)
	 (if dialog
	     (if (symbol? (car dialog))
		 (if (provided? 'snd-motif)
		     (if (XtIsManaged dialog)
			 (XtUnmanageChild dialog))
		     (if (provided? 'snd-gtk)
			 (gtk_widget_hide dialog)))
		 (for-each
		  (lambda (d)
		    (if (symbol? (car d))
			(if (provided? 'snd-motif)
			    (if (XtIsManaged d)
				(XtUnmanageChild d))
			    (if (provided? 'snd-gtk)
				(gtk_widget_hide d)))))
		  dialog))))
       (dialog-widgets))))

(define safe-color (make-color 1 0 0))
(define (make-color-with-catch c1 c2 c3)
  "make-color but catch 'no-such-color"
  (catch 'no-such-color
	 (lambda () (make-color c1 c2 c3))
	 (lambda args safe-color)))

(define* (safe-display-edits snd chn edpos (with-source #t))
  "display-edits but catch all errors"
  (catch #t
	 (lambda () (display-edits snd chn edpos with-source))
	 (lambda args (snd-display #__line__ ";display-edits error: ~A" args))))

(define (safe-divide a b)
  "divide but check for 0 denom"
  (if (zero? b)
      a
      (/ a b)))

(define timings (make-vector (+ total-tests 1) 0))
(define default-srate (mus-srate))

(snd-display #__line__ ";;~A" (snd-version))
(if (not (defined? 'before-test-hook)) (define before-test-hook (make-hook 1)))
(if (not (defined? 'after-test-hook)) (define after-test-hook (make-hook 1)))
(reset-hook! before-test-hook)
(add-hook! before-test-hook (lambda (n)
			      (set! (mus-srate) default-srate)
			      (dismiss-all-dialogs)
			      (set! (clipping) #f)
			      (set! (mus-clipping) #f) ; this cost me a morning of confusion!
			      (set! test-number n)
			      (vector-set! timings n (real-time))
			      (snd-display #__line__ ";test ~D" n)
			      
			      ))


(define (clear-save-state-files)
  "forget regions and whatnot"
  (let ((regs (regions)))
    (for-each
     (lambda (n)
       (forget-region n))
     regs))
  
  (system (format #f "rm -f ~A/snd_*" (or (save-dir) original-save-dir)))
  (if (file-exists? "/var/tmp") 
      (system (format #f "rm -f /var/tmp/snd_save_*")))
  (if (file-exists? "/tmp") 
      (system (format #f "rm -f /tmp/snd_save_*")))
  (mus-sound-prune))

(reset-hook! after-test-hook)
(add-hook! after-test-hook
	   (lambda (n)
	     (clear-save-state-files)
	     (clear-listener)
	     
	     (if (not (null? (sounds)))
		 (begin
		   (snd-display #__line__ ";end test ~D: open sounds: ~A" n (map short-file-name (sounds)))
		   (for-each close-sound (sounds))))
	     (if (number? (vector-ref timings n))
		 (vector-set! timings n (hundred (- (real-time) (vector-ref timings n)))))))

(define overall-start-time (real-time))
(snd-display #__line__ ";~A~%" (strftime "%d-%b %H:%M %Z" (localtime (current-time))))

(define (log-mem tst) 
  (if (> tests 1) (begin (snd-display #__line__ ";test ~D:~D " test-number (+ 1 tst)) )))

(defmacro without-errors (func)
  `(catch #t 
	  (lambda ()
	    ,func)
	  (lambda args 
	    (car args))))

(if (not (provided? 'snd-hooks.scm)) (load "hooks.scm"))
(if (not (provided? 'snd-ws.scm)) (load "ws.scm"))

(define (reset-almost-all-hooks)
  (with-local-hook optimization-hook '() reset-all-hooks))


(define (list-p val)
  "list? and not a null list!"
  (and (list? val)
       (not (null? val))))

(define (arity-ok func args)
  "func accepts args"
  (let ((arity (procedure-arity func)))
    (and (list-p arity)
	 (>= args (car arity))
	 (or (and (list-p (cddr arity))
		  (caddr arity))
	     (<= args (+ (car arity) (cadr arity)))))))

(define (set-arity-ok func args)
  "set proc accepts args"
  (let ((arity (if (procedure-with-setter? func)
		   (cdddr (procedure-arity func))
		   (procedure-arity func))))
    (and (list-p arity)
	 (>= args (car arity))
	 (or (and (list-p (cddr arity))
		  (caddr arity))
	     (<= args (+ (car arity) (cadr arity)))))))

(define* (scale-sound-by scl beg dur snd chn edpos)
  "(scale-sound-by scl beg dur snd chn edpos) is an old form of scale-sound"
  (if (integer? chn)
      (scale-channel scl beg dur snd chn edpos)
      (do ((i 0 (+ 1 i)))
	  ((= i (channels snd)))
	(scale-channel scl beg dur snd i))))

(define* (scale-sound-to norm beg dur snd chn)
  "(scale-sound-to norm beg dur snd chn) is an old form of normalize-sound"
  (if (integer? chn)
      (let ((mx (maxamp snd chn)))
	(if (and (not (= mx 0.0))
		 (not (= mx norm)))
	    (scale-channel (/ norm mx) beg dur snd chn)))
      (let ((mx (apply max (maxamp snd #t))))
	(if (and (not (= mx 0.0))
		 (not (= mx norm)))
	    (do ((i 0 (+ 1 i)))
		((= i (channels snd)))
	      (scale-channel (/ norm mx) beg dur snd i))))))

(if (and (> (length (script-args)) 0)
	 (> (script-arg) 0))
    (let ((arg (script-arg))
	  (args (script-args)))
      (if (not (string=? (list-ref args (- arg 1)) "-l")) 
	  (snd-display #__line__ ";script-args[~A]: ~A (~A)?" (- arg 1) (list-ref args (- arg 1)) args))
      (if (not (string=? (list-ref args arg) "snd-test")) 
	  (snd-display #__line__ ";script-args[~A]: ~A (~A)?" arg (list-ref args arg) args))
      (if (> (length args) (+ 1 arg))
	  (begin
	    ;; test-number tests
	    (set! snd-test (string->number (list-ref args (+ 1 arg))))
	    (set! test-at-random 0)
	    (set! full-test (< snd-test 0))
	    (set! with-exit #t)
	    (set! (script-arg) (+ 1 arg))
	    (if (> (length (script-args)) (+ arg 2))
		(begin
		  (set! tests (string->number (list-ref args (+ arg 2))))
		  (set! (script-arg) (+ arg 2))))))))

(if (and (provided? 'snd-motif)
	 (provided? 'xm))
    (begin
      (if (not (provided? 'snd-snd-motif.scm)) (load "snd-motif.scm"))
      (if (not (provided? 'snd-popup.scm)) (load "popup.scm")))
    (if (and (provided? 'snd-gtk)
	     (provided? 'xg))
	(begin
	  (if (not (provided? 'snd-snd-gtk.scm)) (load "snd-gtk.scm"))
	  (if (not (provided? 'snd-gtk-popup.scm)) (load "gtk-popup.scm")))))


(if (not (provided? 'snd-snd9.scm)) (load "snd9.scm")) ; make-ppolar|zpolar, various generators later moved to generators.scm

(define default-file-buffer-size 65536)
(set! (mus-file-buffer-size) default-file-buffer-size)

(if (not (defined? 'pi)) 
    (snd-display #__line__ ";pi is not defined!")
    (if (fneq pi 3.14159)
	(snd-display #__line__ ";pi is ~A" pi)))


;;; ---------------- test 0: constants ----------------

(define (snd_test_0)
  (letrec ((test-constants 
	    (lambda (lst)
	      (if (not (null? lst))
		  (begin
		    (if (not (= (cadr lst) (caddr lst)))
			(snd-display #__line__ ";~A /= ~A (~A)~%"
				     (car lst) (cadr lst) (caddr lst)))
		    (test-constants (cdddr lst)))))))
    
    (if (or (not (null? (sounds)))
	    (not (null? (mixes)))
	    (not (null? (marks)))
	    (not (null? (regions))))
	(snd-display #__line__ ";start up: ~A ~A ~A ~A" (sounds) (mixes) (marks) (regions)))
    (test-constants
     (list
      'enved-amplitude enved-amplitude 0 
      'bartlett-window bartlett-window 4 
      'bartlett-hann-window bartlett-hann-window 21
      'blackman2-window blackman2-window 6 
      'blackman3-window blackman3-window 7 
      'blackman4-window blackman4-window 8
      'blackman5-window blackman5-window 24
      'blackman6-window blackman6-window 25
      'blackman7-window blackman7-window 26
      'blackman8-window blackman8-window 27
      'blackman9-window blackman9-window 28
      'blackman10-window blackman10-window 29
      'bohman-window bohman-window 22
      'cauchy-window cauchy-window 12 
      'mlt-sine-window mlt-sine-window 33
      'papoulis-window papoulis-window 34
      'dpss-window dpss-window 35
      'sinc-window sinc-window 36
      'channels-combined channels-combined 1 
      'channels-separate channels-separate 0 
      'channels-superimposed channels-superimposed 2
      'connes-window connes-window 18
      'cursor-in-middle cursor-in-middle 3
      'cursor-in-view cursor-in-view 0 
      'cursor-on-left cursor-on-left 1 
      'cursor-on-right cursor-on-right 2 
      'dolph-chebyshev-window dolph-chebyshev-window 16
      'exponential-window exponential-window 9 
      'flat-top-window flat-top-window 23
      'zoom-focus-active zoom-focus-active 2
      'zoom-focus-left zoom-focus-left 0
      'zoom-focus-middle zoom-focus-middle 3
      'zoom-focus-right zoom-focus-right 1 
      'gaussian-window gaussian-window 14 
      'graph-dots graph-dots 1
      'graph-dots-and-lines graph-dots-and-lines 3 
      'graph-filled graph-filled 2 
      'graph-lines graph-lines 0 
      'graph-lollipops graph-lollipops 4
      'hamming-window hamming-window 5
      'hann-window hann-window 1
      'hann-poisson-window hann-poisson-window 17
      'kaiser-window kaiser-window 11 
      'keyboard-no-action keyboard-no-action 4
      'graph-once graph-once 0 
      'parzen-window parzen-window 3
      'poisson-window poisson-window 13
      'rectangular-window rectangular-window 0 
      'riemann-window riemann-window 10 
      'rv2-window rv2-window 30
      'rv3-window rv3-window 31
      'rv4-window rv4-window 32
      'samaraki-window samaraki-window 19
      'ultraspherical-window ultraspherical-window 20
      'graph-as-sonogram graph-as-sonogram 1
      'graph-as-spectrogram graph-as-spectrogram 2 
      'graph-once graph-once 0
      'graph-as-wavogram graph-as-wavogram 3
      'enved-spectrum enved-spectrum 1
      'speed-control-as-float speed-control-as-float 0 
      'speed-control-as-ratio speed-control-as-ratio 1 
      'speed-control-as-semitone speed-control-as-semitone 2 
      'enved-srate enved-srate 2 
      'tukey-window tukey-window 15 
      'welch-window welch-window 2 
      'cursor-cross cursor-cross 0
      'cursor-line cursor-line 1
      'dont-normalize dont-normalize 0
      'envelope-linear envelope-linear 0
      'envelope-exponential envelope-exponential 1
      'normalize-by-channel normalize-by-channel 1
      'normalize-by-sound normalize-by-sound 2
      'normalize-globally normalize-globally 3
      'x-axis-in-samples x-axis-in-samples 1 
      'x-axis-in-beats x-axis-in-beats 3
      'x-axis-in-measures x-axis-in-measures 4
      'x-axis-in-seconds x-axis-in-seconds 0 
      'x-axis-as-clock x-axis-as-clock 5
      'x-axis-as-percentage x-axis-as-percentage 2
      'enved-add-point enved-add-point 0
      'enved-delete-point enved-delete-point 1
      'enved-move-point enved-move-point 2
      'time-graph time-graph 0
      'transform-graph transform-graph 1
      'lisp-graph lisp-graph 2
      'copy-context copy-context 0
      'cursor-context cursor-context 3
      'selection-context selection-context 2
      'mark-context mark-context 4
      'show-no-axes show-no-axes 0
      'show-all-axes show-all-axes 1
      'show-x-axis show-x-axis 2
      'show-all-axes-unlabelled show-all-axes-unlabelled 3
      'show-x-axis-unlabelled show-x-axis-unlabelled 4
      'show-bare-x-axis show-bare-x-axis 5
      
      ;; sndlib constants
      'mus-unsupported mus-unsupported 0
      'mus-next mus-next 1
      'mus-aifc mus-aifc 2
      'mus-riff mus-riff 3
      'mus-nist mus-nist 6
      'mus-raw mus-raw 12
      'mus-ircam mus-ircam 15
      'mus-aiff mus-aiff 49
      'mus-bicsf mus-bicsf 5
      'mus-voc mus-voc 10
      'mus-svx mus-svx 9
      'mus-soundfont mus-soundfont 26
      'mus-rf64 mus-rf64 4
      'mus-caff mus-caff 60
      
      'mus-interp-none mus-interp-none 0
      'mus-interp-linear mus-interp-linear 1
      'mus-interp-sinusoidal mus-interp-sinusoidal 2
      'mus-interp-all-pass mus-interp-all-pass 3
      'mus-interp-lagrange mus-interp-lagrange 4
      'mus-interp-bezier mus-interp-bezier 5
      'mus-interp-hermite mus-interp-hermite 6
      
      'mus-chebyshev-first-kind mus-chebyshev-first-kind 1
      'mus-chebyshev-second-kind mus-chebyshev-second-kind 2
      
      'mus-unknown mus-unknown 0
      'mus-bshort mus-bshort 1
      'mus-lshort mus-lshort 10
      'mus-mulaw mus-mulaw 2
      'mus-alaw mus-alaw 6
      'mus-byte mus-byte 3
      'mus-ubyte mus-ubyte 7
      'mus-bfloat mus-bfloat 4
      'mus-lfloat mus-lfloat 12
      'mus-bint mus-bint 5
      'mus-lint mus-lint 11
      'mus-bintn mus-bintn 17
      'mus-lintn mus-lintn 18
      'mus-b24int mus-b24int 8
      'mus-l24int mus-l24int 16
      'mus-bdouble mus-bdouble 9
      'mus-ldouble mus-ldouble 13
      'mus-ubshort mus-ubshort 14
      'mus-ulshort mus-ulshort 15
      'mus-bfloat-unscaled mus-bfloat-unscaled 19
      'mus-lfloat-unscaled mus-lfloat-unscaled 20
      'mus-bdouble-unscaled mus-bdouble-unscaled 21
      'mus-ldouble-unscaled mus-ldouble-unscaled 22
      ))
    
    (set! (region-graph-style) (region-graph-style))
    (if (not (equal? (region-graph-style) graph-lines))
	(snd-display #__line__ ";region-graph-style set def: ~A" (region-graph-style)))
    (set! (ask-before-overwrite) (ask-before-overwrite)) 
    (if (not (equal? (ask-before-overwrite) #f)) 
	(snd-display #__line__ ";ask-before-overwrite set def: ~A" (ask-before-overwrite)))
    (set! (audio-output-device) (audio-output-device))
    (if (not (equal? (audio-output-device)  0)) 
	(snd-display #__line__ ";audio-output-device set def: ~A" (audio-output-device)))
    (set! (auto-resize) (auto-resize))
    (if (not (equal? (auto-resize)  #t )) 
	(snd-display #__line__ ";auto-resize set def: ~A" (auto-resize)))
    (set! (auto-update) (auto-update))
    (if (not (equal? (auto-update)  #f)) 
	(snd-display #__line__ ";auto-update set def: ~A" (auto-update)))
    (set! (channel-style) (channel-style))
    (if (not (equal? (channel-style)  1 )) 
	(snd-display #__line__ ";channel-style set def: ~A" (channel-style)))
    (set! (color-cutoff) (color-cutoff))
    (if (fneq (color-cutoff)  0.003 )
	(snd-display #__line__ ";color-cutoff set def: ~A" (color-cutoff)))
    (set! (color-inverted) (color-inverted))
    (if (not (equal? (color-inverted)  #t)) 
	(snd-display #__line__ ";color-inverted set def: ~A" (color-inverted)))
    (set! (color-scale) (color-scale))
    (if (fneq (color-scale)  1.0 )
	(snd-display #__line__ ";color-scale set def: ~A" (color-scale)))
    (set! (auto-update-interval) (auto-update-interval))
    (if (fneq (auto-update-interval)  60.0 )
	(snd-display #__line__ ";auto-update-interval set def: ~A" (auto-update-interval)))
    (set! (cursor-update-interval) (cursor-update-interval))
    (if (fneq (cursor-update-interval)  0.05 )
	(snd-display #__line__ ";cursor-update-interval set def: ~A" (cursor-update-interval)))
    (set! (cursor-location-offset) (cursor-location-offset))
    (if (not (= (cursor-location-offset)  0))
	(snd-display #__line__ ";cursor-location-offset set def: ~A" (cursor-location-offset)))
    (set! (dac-combines-channels) (dac-combines-channels))
    (if (not (equal? (dac-combines-channels)  #t)) 
	(snd-display #__line__ ";dac-combines-channels set def: ~A" (dac-combines-channels)))
    (set! (dac-size) (dac-size))
    (if (not (equal? (dac-size)  256 )) 
	(snd-display #__line__ ";dac-size set def: ~A" (dac-size)))
    (set! (minibuffer-history-length) (minibuffer-history-length))
    (if (not (equal? (minibuffer-history-length)  8)) 
	(snd-display #__line__ ";minibuffer-history-length set def: ~A" (minibuffer-history-length)))
    (set! (clipping) (clipping))
    (if (not (equal? (clipping)  #f )) 
	(snd-display #__line__ ";clipping set def: ~A" (clipping)))
    (set! (default-output-chans) (default-output-chans))
    (if (not (equal? (default-output-chans)  1 )) 
	(snd-display #__line__ ";default-output-chans set def: ~A" (default-output-chans)))
    (set! (default-output-data-format) (default-output-data-format))
    (if (and (not (equal? (default-output-data-format) mus-bfloat))
	     (not (equal? (default-output-data-format) mus-lfloat)))
	(snd-display #__line__ ";default-output-data-format set def: ~A" (default-output-data-format)))
    (set! (default-output-srate) (default-output-srate))
    (if (not (equal? (default-output-srate)  44100 )) 
	(snd-display #__line__ ";default-output-srate set def: ~A" (default-output-srate)))
    (set! (default-output-header-type) (default-output-header-type))
    (if (not (equal? (default-output-header-type)  mus-next)) 
	(snd-display #__line__ ";default-output-header-type set def: ~A" (default-output-header-type)))
    (set! (dot-size) (dot-size))
    (if (not (equal? (dot-size)  1 )) 
	(snd-display #__line__ ";dot-size set def: ~A" (dot-size)))
    (set! (cursor-size) (cursor-size))
    (if (not (equal? (cursor-size)  15 )) 
	(snd-display #__line__ ";cursor-size set def: ~A" (cursor-size)))
    (set! (cursor-style) (cursor-style))
    (if (not (equal? (cursor-style)  cursor-cross )) 
	(snd-display #__line__ ";cursor-style set def: ~A" (cursor-style)))
    (set! (tracking-cursor-style) (tracking-cursor-style))
    (if (not (equal? (tracking-cursor-style)  cursor-cross )) 
	(snd-display #__line__ ";tracking-cursor-style set def: ~A" (tracking-cursor-style)))
    (set! (enved-base) (enved-base))
    (if (fneq (enved-base)  1.0 )
	(snd-display #__line__ ";enved-base set def: ~A" (enved-base)))
    (set! (enved-clip?) (enved-clip?))
    (if (not (equal? (enved-clip?)  #t )) 
	(snd-display #__line__ ";enved-clip? set def: ~A" (enved-clip?)))
    (set! (enved-filter) (enved-filter))
    (if (not (equal? (enved-filter) #t)) 
	(snd-display #__line__ ";enved-filter set def: ~A" (enved-filter)))
    (set! (enved-filter-order) (enved-filter-order))
    (if (not (equal? (enved-filter-order)  40)) 
	(snd-display #__line__ ";enved-filter-order set def: ~A" (enved-filter-order)))
    (set! (enved-in-dB) (enved-in-dB))
    (if (not (equal? (enved-in-dB)  #f )) 
	(snd-display #__line__ ";enved-in-dB set def: ~A" (enved-in-dB)))
    (set! (enved-style) (enved-style))
    (if (not (equal? (enved-style)  envelope-linear )) 
	(snd-display #__line__ ";enved-style set def: ~A" (enved-style)))
    (set! (enved-power) (enved-power))
    (if (fneq (enved-power)  3.0)
	(snd-display #__line__ ";enved-power set def: ~A" (enved-power)))
    (set! (enved-target) (enved-target))
    (if (not (equal? (enved-target)  0 )) 
	(snd-display #__line__ ";enved-target set def: ~A" (enved-target)))
    (set! (enved-wave?) (enved-wave?))
    (if (not (equal? (enved-wave?)  #f )) 
	(snd-display #__line__ ";enved-wave? set def: ~A" (enved-wave?)))
    (if with-gui
	(begin
	  (set! (enved-envelope) (enved-envelope))
	  (if (not (equal? (enved-envelope)  '())) 
	      (snd-display #__line__ ";enved-envelope set def: ~A" (enved-envelope)))))
    (set! (eps-file) (eps-file))
    (if (not (equal? (eps-file)  "snd.eps" )) 
	(snd-display #__line__ ";eps-file set def: ~A" (eps-file)))
    (set! (eps-bottom-margin) (eps-bottom-margin))
    (if (fneq (eps-bottom-margin)  0.0)
	(snd-display #__line__ ";eps-bottom-margin set def: ~A" (eps-bottom-margin)))
    (set! (eps-left-margin) (eps-left-margin))
    (if (fneq (eps-left-margin)  0.0)
	(snd-display #__line__ ";eps-left-margin set def: ~A" (eps-left-margin)))
    (set! (eps-size) (eps-size))
    (if (fneq (eps-size)  1.0)
	(snd-display #__line__ ";eps-size set def: ~A" (eps-size)))
    (set! (fft-window-alpha) (fft-window-alpha))
    (if (fneq (fft-window-alpha)  0.0 )
	(snd-display #__line__ ";fft-window-alpha set def: ~A" (fft-window-alpha)))
    (set! (fft-window-beta) (fft-window-beta))
    (if (fneq (fft-window-beta)  0.0 )
	(snd-display #__line__ ";fft-window-beta set def: ~A" (fft-window-beta)))
    (set! (fft-log-frequency) (fft-log-frequency))
    (if (not (equal? (fft-log-frequency)  #f )) 
	(snd-display #__line__ ";fft-log-frequency set def: ~A" (fft-log-frequency)))
    (set! (fft-log-magnitude) (fft-log-magnitude))
    (if (not (equal? (fft-log-magnitude)  #f )) 
	(snd-display #__line__ ";fft-log-magnitude set def: ~A" (fft-log-magnitude)))
    (set! (fft-with-phases) (fft-with-phases))
    (if (not (equal? (fft-with-phases)  #f )) 
	(snd-display #__line__ ";fft-with-phases set def: ~A" (fft-with-phases)))
    (set! (transform-size) (transform-size))
    (if (not (equal? (transform-size)  512 )) 
	(snd-display #__line__ ";transform-size set def: ~A" (transform-size)))
    (set! (transform-graph-type) (transform-graph-type))
    (if (not (equal? (transform-graph-type) graph-once))
	(snd-display #__line__ ";transform-graph-type set def: ~A" (transform-graph-type)))
    (set! (fft-window) (fft-window))
    (if (not (equal? (fft-window)  6 )) 
	(snd-display #__line__ ";fft-window set def: ~A" (fft-window)))
    (set! (graph-cursor) (graph-cursor))
    (if (not (equal? (graph-cursor)  34)) 
	(snd-display #__line__ ";graph-cursor set def: ~A" (graph-cursor)))
    (set! (graph-style) (graph-style))
    (if (not (equal? (graph-style)  graph-lines )) 
	(snd-display #__line__ ";graph-style set def: ~A" (graph-style)))
    (set! (graphs-horizontal) (graphs-horizontal))
    (if (not (equal? (graphs-horizontal)  #t)) 
	(snd-display #__line__ ";graphs-horizontal set def: ~A" (graphs-horizontal)))
    (set! (html-dir) (html-dir))
    (if (not (equal? (html-dir)  ".")) 
	(snd-display #__line__ ";html-dir set def: ~A" (html-dir)))
    (set! (html-program) (html-program))
    (if (not (equal? (html-program)  "firefox")) 
	(snd-display #__line__ ";html-program set def: ~A" (html-program)))
    (set! (just-sounds) (just-sounds))
    (if (not (equal? (just-sounds)  #f)) 
	(snd-display #__line__ ";just-sounds set def: ~A" (just-sounds)))
    (set! (listener-prompt) (listener-prompt))
    (if (not (equal? (listener-prompt)  ">" )) 
	(snd-display #__line__ ";listener-prompt set def: ~A" (listener-prompt)))
    (set! (max-transform-peaks) (max-transform-peaks))
    (if (not (equal? (max-transform-peaks)  100)) 
	(snd-display #__line__ ";max-transform-peaks set def: ~A" (max-transform-peaks)))
    (set! (max-transform-peaks) -123)
    (if (not (equal? (max-transform-peaks) 100)) 
	(snd-display #__line__ ";max-transform-peaks set -123: ~A" (max-transform-peaks)))
    (set! (max-regions) (max-regions))
    (if (not (equal? (max-regions)  16 )) 
	(snd-display #__line__ ";max-regions set def: ~A" (max-regions)))
    (set! (max-virtual-ptrees) (max-virtual-ptrees))
    (if (not (equal? (max-virtual-ptrees)  32 )) 
	(snd-display #__line__ ";max-virtual-ptrees set def: ~A" (max-virtual-ptrees)))
    (set! (min-dB) (min-dB))
    (if (fneq (min-dB)  -60.0 )
	(snd-display #__line__ ";min-dB set def: ~A" (min-dB)))
    (set! (log-freq-start) (log-freq-start))
    (if (fneq (log-freq-start)  32.0 )
	(snd-display #__line__ ";log-freq-start set def: ~A" (log-freq-start)))
    (set! (selection-creates-region) (selection-creates-region))
    (if (not (equal? (selection-creates-region)  #t )) 
	(snd-display #__line__ ";selection-creates-region set def: ~A" (selection-creates-region)))
    (set! (transform-normalization) (transform-normalization))
    (if (not (equal? (transform-normalization)  normalize-by-channel)) 
	(snd-display #__line__ ";transform-normalization set def: ~A" (transform-normalization)))
    (set! (view-files-sort) (view-files-sort))
    (if (not (equal? (view-files-sort)  0 )) 
	(snd-display #__line__ ";view-files-sort set def: ~A" (view-files-sort)))
    (set! (print-length) (print-length))
    (if (not (equal? (print-length)  12 )) 
	(snd-display #__line__ ";print-length set def: ~A" (print-length)))
    (set! (save-state-file) (save-state-file))
    (if (not (equal? (save-state-file)  "saved-snd.scm" )) 
	(snd-display #__line__ ";save-state-file set def: ~A" (save-state-file)))
    (set! (show-axes) (show-axes))
    (if (not (equal? (show-axes)  1)) 
	(snd-display #__line__ ";show-axes set def: ~A" (show-axes)))
    (set! (show-transform-peaks) (show-transform-peaks))
    (if (not (equal? (show-transform-peaks)  #f )) 
	(snd-display #__line__ ";show-transform-peaks set def: ~A" (show-transform-peaks)))
    (set! (show-indices) (show-indices))
    (if (not (equal? (show-indices)  #f)) 
	(snd-display #__line__ ";show-indices set def: ~A" (show-indices)))
    (set! (show-marks) (show-marks))
    (if (not (equal? (show-marks)  #t )) 
	(snd-display #__line__ ";show-marks set def: ~A" (show-marks)))
    (set! (show-mix-waveforms) (show-mix-waveforms))
    (if (not (equal? (show-mix-waveforms)  #t)) 
	(snd-display #__line__ ";show-mix-waveforms set def: ~A" (show-mix-waveforms)))
    (set! (show-selection-transform) (show-selection-transform))
    (if (not (equal? (show-selection-transform)  #f )) 
	(snd-display #__line__ ";show-selection-transform set def: ~A" (show-selection-transform)))
    (set! (show-y-zero) (show-y-zero))
    (if (not (equal? (show-y-zero)  #f )) 
	(snd-display #__line__ ";show-y-zero set def: ~A" (show-y-zero)))
    (set! (show-grid) (show-grid))
    (if (not (equal? (show-grid)  #f )) 
	(snd-display #__line__ ";show-grid set def: ~A" (show-grid)))
    (set! (grid-density) (grid-density))
    (if (fneq (grid-density) 1.0)
	(snd-display #__line__ ";grid-density set def: ~A" (grid-density)))
    (set! (show-sonogram-cursor) (show-sonogram-cursor))
    (if (not (equal? (show-sonogram-cursor)  #f )) 
	(snd-display #__line__ ";show-sonogram-cursor set def: ~A" (show-sonogram-cursor)))
    (set! (sinc-width) (sinc-width))
    (if (not (equal? (sinc-width)  10 )) 
	(snd-display #__line__ ";sinc-width set def: ~A" (sinc-width)))
    (set! (spectrum-end) (spectrum-end))
    (if (fneq (spectrum-end)  1.0)
	(snd-display #__line__ ";spectrum-end set def: ~A" (spectrum-end)))
    (set! (spectro-hop) (spectro-hop))
    (if (not (equal? (spectro-hop)  4 )) 
	(snd-display #__line__ ";spectro-hop set def: ~A" (spectro-hop)))
    (set! (spectrum-start) (spectrum-start))
    (if (fneq (spectrum-start)  0.0 )
	(snd-display #__line__ ";spectrum-start set def: ~A" (spectrum-start)))
    (set! (spectro-x-angle) (spectro-x-angle))
    (if (fneq (spectro-x-angle)  (if (provided? 'gl) 300.0 90.0))
	(snd-display #__line__ ";spectro-x-angle set def: ~A" (spectro-x-angle)))
    (set! (spectro-x-scale) (spectro-x-scale))
    (if (fneq (spectro-x-scale) (if (provided? 'gl) 1.5 1.0))
	(snd-display #__line__ ";spectro-x-scale set def: ~A" (spectro-x-scale)))
    (set! (spectro-y-angle) (spectro-y-angle))
    (if (fneq (spectro-y-angle) (if (provided? 'gl) 320.0 0.0))
	(snd-display #__line__ ";spectro-y-angle set def: ~A" (spectro-y-angle)))
    (set! (spectro-y-scale) (spectro-y-scale))
    (if (fneq (spectro-y-scale)  1.0 )
	(snd-display #__line__ ";spectro-y-scale set def: ~A" (spectro-y-scale)))
    (set! (spectro-z-angle) (spectro-z-angle))
    (if (fneq (spectro-z-angle) (if (provided? 'gl) 0.0 358.0))
	(snd-display #__line__ ";spectro-z-angle set def: ~A" (spectro-z-angle)))
    (set! (spectro-z-scale) (spectro-z-scale))
    (if (fneq (spectro-z-scale) (if (provided? 'gl) 1.0 0.1))
	(snd-display #__line__ ";spectro-z-scale set def: ~A" (spectro-z-scale)))
    (set! (temp-dir) (temp-dir))
    (if (not (equal? (temp-dir)  #f )) 
	(snd-display #__line__ ";temp-dir set def: ~A" (temp-dir)))
    (set! (ladspa-dir) (ladspa-dir))
    (if (not (equal? (ladspa-dir)  #f )) 
	(snd-display #__line__ ";ladspa-dir set def: ~A" (ladspa-dir)))
    (set! (peak-env-dir) (peak-env-dir))
    (if (not (equal? (peak-env-dir)  #f )) 
	(snd-display #__line__ ";peak-env-dir set def: ~A" (peak-env-dir)))
    (set! (tiny-font) (tiny-font))
    (if (and (not (equal? (tiny-font) "6x12"))
	     (not (equal? (tiny-font) "Sans 8")))
	(snd-display #__line__ ";tiny-font set def: ~A" (tiny-font)))
    (set! (transform-type) (transform-type))
    (if (not (equal? (transform-type)  fourier-transform )) 
	(snd-display #__line__ ";transform-type set def: ~A" (transform-type)))
    (set! (trap-segfault) (trap-segfault))
    (if (not (equal? (trap-segfault)  #t)) 
	(snd-display #__line__ ";trap-segfault set def: ~A" (trap-segfault)))
    (set! (with-file-monitor) (with-file-monitor))
    (if (not (equal? (with-file-monitor)  #t)) 
	(snd-display #__line__ ";with-file-monitor set def: ~A" (with-file-monitor)))
    (set! (optimization) (optimization))
    (if (not (equal? (optimization) 6)) 
	(snd-display #__line__ ";optimization set def: ~A" (optimization)))
    (set! (clm-table-size) (clm-table-size))
    (if (not (equal? (clm-table-size) 512)) 
	(snd-display #__line__ ";clm-table-size set def: ~A" (clm-table-size)))
    (set! (clm-default-frequency) (clm-default-frequency))
    (if (fneq (clm-default-frequency) 0.0)
	(snd-display #__line__ ";clm-default-frequency set def: ~A" (clm-default-frequency)))
    (set! (with-verbose-cursor) (with-verbose-cursor))
    (if (not (equal? (with-verbose-cursor)  #f)) 
	(snd-display #__line__ ";with-verbose-cursor set def: ~A" (with-verbose-cursor)))
    (set! (with-inset-graph) (with-inset-graph))
    (if (not (equal? (with-inset-graph)  #f)) 
	(snd-display #__line__ ";with-inset-graph set def: ~A" (with-inset-graph)))
    (set! (with-pointer-focus) (with-pointer-focus))
    (if (not (equal? (with-pointer-focus)  #f)) 
	(snd-display #__line__ ";with-pointer-focus set def: ~A" (with-pointer-focus)))
    (set! (wavelet-type) (wavelet-type))
    (if (not (equal? (wavelet-type)  0 )) 
	(snd-display #__line__ ";wavelet-type set def: ~A" (wavelet-type)))
    (set! (time-graph-type) (time-graph-type))
    (if (not (equal? (time-graph-type)  graph-once)) 
	(snd-display #__line__ ";time-graph-type set def: ~A" (time-graph-type)))
    (set! (wavo-hop) (wavo-hop))
    (if (not (equal? (wavo-hop)  3 )) 
	(snd-display #__line__ ";wavo-hop set def: ~A" (wavo-hop)))
    (set! (wavo-trace) (wavo-trace))
    (if (not (equal? (wavo-trace)  64 )) 
	(snd-display #__line__ ";wavo-trace set def: ~A" (wavo-trace)))
    (set! (x-axis-style) (x-axis-style))
    (if (not (equal? (x-axis-style)  0 )) 
	(snd-display #__line__ ";x-axis-style set def: ~A" (x-axis-style)))
    (set! (beats-per-minute) (beats-per-minute))
    (if (fneq (beats-per-minute)  60.0 )
	(snd-display #__line__ ";beats-per-minute set def: ~A" (beats-per-minute)))
    (set! (beats-per-measure) (beats-per-measure))
    (if (not (= (beats-per-measure)  4))
	(snd-display #__line__ ";beats-per-measure set def: ~A" (beats-per-measure)))
    (set! (zero-pad) (zero-pad))
    (if (not (equal? (zero-pad)  0)) 
	(snd-display #__line__ ";zero-pad set def: ~A" (zero-pad)))
    (set! (zero-pad) -123)
    (if (not (equal? (zero-pad)  0)) 
	(snd-display #__line__ ";zero-pad set -123: ~A" (zero-pad)))
    (if (not (equal? (zero-pad #t #t) '()))
	(snd-display #__line__ ";zero-pad #t: ~A" (zero-pad #t #t)))
    (set! (zoom-focus-style) (zoom-focus-style))
    (if (not (equal? (zoom-focus-style)  2 )) 
	(snd-display #__line__ ";zoom-focus-style set def: ~A" (zoom-focus-style)))
    (set! (mix-waveform-height) (mix-waveform-height))
    (if (not (equal? (mix-waveform-height)  20 )) 
	(snd-display #__line__ ";mix-waveform-height set def: ~A" (mix-waveform-height)))
    (set! (mix-tag-width) (mix-tag-width))
    (if (not (equal? (mix-tag-width)  6)) 
	(snd-display #__line__ ";mix-tag-width set def: ~A" (mix-tag-width)))
    (set! (mix-tag-height) (mix-tag-height))
    (if (not (equal? (mix-tag-height)  14)) 
	(snd-display #__line__ ";mix-tag-height set def: ~A" (mix-tag-height)))
    (set! (mark-tag-width) (mark-tag-width))
    (if (not (equal? (mark-tag-width)  10)) 
	(snd-display #__line__ ";mark-tag-width set def: ~A" (mark-tag-width)))
    (set! (mark-tag-height) (mark-tag-height))
    (if (not (equal? (mark-tag-height)  4)) 
	(snd-display #__line__ ";mark-tag-height set def: ~A" (mark-tag-height)))
    (set! (audio-output-device) (audio-output-device))
    (if (not (equal? (audio-output-device)  0 )) 
	(snd-display #__line__ ";audio-output-device set def: ~A" (audio-output-device)))
    (set! (view-files-sort) (view-files-sort))
    (if (not (= (view-files-sort) 0))
	(snd-display #__line__ ";view-files-sort def: ~A" (view-files-sort)))
    
    (if (and (defined? 'most-positive-fixnum)
	     (> most-positive-fixnum (expt 2 36)))
	(begin
	  (let ((old-max-malloc (mus-max-malloc)))
	    (set! (mus-max-malloc) (expt 2 36))
	    (if (not (= (mus-max-malloc) (expt 2 36)))
		(snd-display #__line__ ";mus-max-malloc as bignum: ~A" (mus-max-malloc)))
	    (set! (mus-max-malloc) old-max-malloc))
	  
	  (let ((old-max-table-size (mus-max-table-size)))
	    (set! (mus-max-table-size) (expt 2 36))
	    (if (not (= (mus-max-table-size) (expt 2 36)))
		(snd-display #__line__ ";mus-max-table-size as bignum: ~A" (mus-max-table-size)))
	    (set! (mus-max-table-size) old-max-table-size))))
    
    (if (not (provided? 'snd-gtk))
	(for-each
	 (lambda (func name)
	   (let ((val (func)))
	     (set! (func) "8x123")
	     (if (or (not (string? (func)))
		     (not (string=? val (func))))
		 (snd-display #__line__ ";set ~A to bogus value: ~A ~A" name val (func)))))
	 (list axis-label-font axis-numbers-font tiny-font peaks-font bold-peaks-font)
	 (list 'axis-label-font 'axis-numbers-font 'tiny-font 'peaks-font 'bold-peaks-font)))
    ))



;;; ---------------- test 1: defaults ----------------

(define good-colormap (if (provided? 'gl) hot-colormap black-and-white-colormap))
(define better-colormap black-and-white-colormap)
(if with-gui
    (if (not (colormap? good-colormap))
	(set! good-colormap
	      (call-with-exit
	       (lambda (return)
		 (do ((i 1 (+ 1 i)))
		     ((= i 20))
		   (if (colormap? (integer->colormap i))
		       (return (integer->colormap i)))))))))
(if with-gui
    (if (not (colormap? better-colormap))
	(set! better-colormap
	      (call-with-exit
	       (lambda (return)
		 (do ((i good-colormap (+ 1 i)))
		     ((= i 20))
		   (if (colormap? (integer->colormap i))
		       (return (integer->colormap i)))))))))

(define (snd_test_1)
  (letrec ((test-defaults
	    (lambda (lst)
	      (if (not (null? lst))
		  (begin
		    (if (not (equal? (cadr lst)  (caddr lst)))
			(if (and (number? (caddr lst))
				 (not (rational? (caddr lst))))
			    (if (fneq (cadr lst) (caddr lst))
				(snd-display #__line__ ";~A /= ~A (~A)" (car lst) (caddr lst) (cadr lst)))
			    (snd-display #__line__ ";~A /= ~A (~A)" (car lst) (caddr lst) (cadr lst))))
		    (test-defaults (cdddr lst)))))))
    
    (for-each close-sound (sounds)) ; in case others opened elsewhere
    (test-defaults
     (list
      'amp-control (without-errors (amp-control)) 'no-such-sound
      'amp-control-bounds (cadr (amp-control-bounds)) 8.0
      'ask-before-overwrite (ask-before-overwrite) #f 
      'audio-output-device (audio-output-device) 0
      'audio-output-device (audio-output-device) 0 
      'auto-resize (auto-resize) #t 
      'auto-update (auto-update) #f
      'auto-update-interval (auto-update-interval) 60.0 
      'beats-per-measure (beats-per-measure) 4
      'beats-per-minute (beats-per-minute) 60.0
      'channel-style (channel-style) 1
      'clipping (clipping) #f 
      'clm-table-size (clm-table-size) 512
      'clm-default-frequency (clm-default-frequency) 0.0
      'color-cutoff (color-cutoff) 0.003 
      'color-inverted (color-inverted) #t
      'color-scale (color-scale) 1.0 
      'colormap (colormap) good-colormap
      'contrast-control (without-errors (contrast-control)) 'no-such-sound
      'contrast-control-amp (contrast-control-amp) 1.0
      'contrast-control-bounds (cadr (contrast-control-bounds)) 10.0
      'contrast-control? (without-errors (contrast-control?)) 'no-such-sound
      'cursor-follows-play (cursor-follows-play) #f
      'cursor-location-offset (cursor-location-offset) 0
      'cursor-size (cursor-size) 15
      'cursor-style (cursor-style) cursor-cross
      'cursor-update-interval (cursor-update-interval) 0.05
      'dac-combines-channels (dac-combines-channels) #t
      'dac-size (dac-size) 256 
      'default-output-chans (default-output-chans) 1 
      'default-output-data-format (default-output-data-format) mus-lfloat
      'default-output-header-type (default-output-header-type) mus-next
      'default-output-srate (default-output-srate) 44100
      'dot-size (dot-size) 1 
      'enved-base (enved-base) 1.0 
      'enved-clip? (enved-clip?) #t
      'enved-envelope (enved-envelope) '()
      'enved-filter (enved-filter) #t
      'enved-filter-order (enved-filter-order) 40
      'enved-in-dB (enved-in-dB) #f 
      'enved-power (enved-power) 3.0
      'enved-style (enved-style) envelope-linear
      'enved-target (enved-target) 0 
      'enved-wave? (enved-wave?) #f 
      'eps-bottom-margin (eps-bottom-margin) 0.0
      'eps-file (eps-file) "snd.eps" 
      'eps-left-margin (eps-left-margin) 0.0
      'eps-size (eps-size) 1.0
      'expand-control (without-errors (expand-control)) 'no-such-sound
      'expand-control-bounds (cadr (expand-control-bounds)) 20.0
      'expand-control-hop (expand-control-hop) 0.05
      'expand-control-jitter (expand-control-jitter) 0.1
      'expand-control-length (expand-control-length) 0.15
      'expand-control-ramp (expand-control-ramp) 0.4
      'expand-control? (without-errors (expand-control?)) 'no-such-sound
      'fft-log-frequency (fft-log-frequency) #f 
      'fft-log-magnitude (fft-log-magnitude) #f 
      'fft-with-phases (fft-with-phases) #f 
      'fft-window (fft-window) 6 
      'fft-window-alpha (fft-window-alpha) 0.0 
      'fft-window-beta (fft-window-beta) 0.0 
      'filter-control-coeffs (without-errors (filter-control-coeffs)) 'no-such-sound
      'filter-control-envelope (without-errors (filter-control-envelope)) 'no-such-sound
      'filter-control-in-dB (filter-control-in-dB) #f
      'filter-control-in-hz (filter-control-in-hz) #f
      'filter-control-order (filter-control-order) 20
      'filter-control? (without-errors (filter-control?)) 'no-such-sound
      'graph-cursor (graph-cursor) 34
      'graph-style (graph-style) graph-lines
      'graphs-horizontal (graphs-horizontal) #t
      'grid-density (grid-density) 1.0
      'html-dir (html-dir) "."
      'html-program (html-program) "firefox"
      'just-sounds (just-sounds) #f
      'ladspa-dir (ladspa-dir) #f 
      'peak-env-dir (peak-env-dir) #f 
      'lisp-graph? (without-errors (lisp-graph?)) 'no-such-sound
      'listener-prompt (listener-prompt) ">" 
      'log-freq-start (log-freq-start) 32.0	
      'mark-tag-height (mark-tag-height) 4
      'mark-tag-width (mark-tag-width) 10
      'max-regions (max-regions) 16 
      'max-virtual-ptrees (max-virtual-ptrees) 32
      'max-transform-peaks (max-transform-peaks) 100
      'min-dB (min-dB) -60.0 
      'minibuffer-history-length (minibuffer-history-length) 8
      'mix-tag-height (mix-tag-height) 14
      'mix-tag-width (mix-tag-width) 6
      'mix-waveform-height (mix-waveform-height) 20 
      'mus-array-print-length (mus-array-print-length) 8
      'mus-clipping (mus-clipping) #f
      'mus-float-equal-fudge-factor (mus-float-equal-fudge-factor) .0000001
      'mus-prescaler (mus-prescaler) 1.0
      'optimization (optimization) 6
      'print-length (print-length) 12 
      'read-only (without-errors (read-only)) 'no-such-sound
      'region-graph-style (region-graph-style) graph-lines
      'reverb-control-feedback (reverb-control-feedback) 1.09
      'reverb-control-length (without-errors (reverb-control-length)) 'no-such-sound
      'reverb-control-length-bounds (cadr (reverb-control-length-bounds)) 5.0
      'reverb-control-lowpass (reverb-control-lowpass) 0.7
      'reverb-control-scale (without-errors (reverb-control-scale)) 'no-such-sound
      'reverb-control-scale-bounds (cadr (reverb-control-scale-bounds)) 4.0
      'reverb-control? (without-errors (reverb-control?)) 'no-such-sound
      'save-state-file (save-state-file) "saved-snd.scm" 
      'selection-creates-region (selection-creates-region) #t 
      'show-axes (show-axes) 1
      'show-controls (show-controls) #f
      'show-grid (show-grid) #f 
      'show-indices (show-indices) #f
      'show-marks (show-marks) #t 
      'show-mix-waveforms (show-mix-waveforms) #t
      'show-selection-transform (show-selection-transform) #f 
      'show-sonogram-cursor (show-sonogram-cursor) #f 
      'show-transform-peaks (show-transform-peaks) #f 
      'show-y-zero (show-y-zero) #f 
      'sinc-width (sinc-width) 10 
      'spectrum-end (spectrum-end) 1.0
      'spectro-hop (spectro-hop) 4 
      'spectrum-start (spectrum-start) 0.0 
      'spectro-x-angle (spectro-x-angle) (if (provided? 'gl) 300.0 90.0)
      'spectro-x-scale (spectro-x-scale) (if (provided? 'gl) 1.5 1.0)
      'spectro-y-angle (spectro-y-angle) (if (provided? 'gl) 320.0 0.0)
      'spectro-y-scale (spectro-y-scale) 1.0 
      'spectro-z-angle (spectro-z-angle) (if (provided? 'gl) 0.0 358.0)
      'spectro-z-scale (spectro-z-scale) (if (provided? 'gl) 1.0 0.1)
      'speed-control (without-errors (speed-control)) 'no-such-sound
      'speed-control-bounds (cadr (speed-control-bounds)) 20.0
      'sync (without-errors (sync)) 'no-such-sound
      'temp-dir (temp-dir) #f 
      'time-graph-type (time-graph-type) graph-once
      'time-graph? (without-errors (time-graph?)) 'no-such-sound
      'tiny-font (tiny-font) (if (provided? 'snd-motif) "6x12" "Sans 8")
      'tracking-cursor-style (tracking-cursor-style) cursor-cross
      'transform-graph-type (transform-graph-type) graph-once
      'transform-graph? (without-errors (transform-graph?)) 'no-such-sound
      'transform-normalization (transform-normalization) normalize-by-channel
      'transform-size (transform-size) 512
      'transform-type (transform-type) fourier-transform
      'view-files-sort (view-files-sort) 0
      'view-files-sort (view-files-sort) 0 
      'wavelet-type (wavelet-type) 0 
      'wavo-hop (wavo-hop) 3 
      'wavo-trace (wavo-trace) 64 
      'with-mix-tags (with-mix-tags) #t
      'with-relative-panes (with-relative-panes) #t
      'with-tracking-cursor (with-tracking-cursor) #f
      'with-verbose-cursor (with-verbose-cursor) #f
      'with-inset-graph (with-inset-graph) #f
      'with-pointer-focus (with-pointer-focus) #f
      'x-axis-style (x-axis-style) 0 
      'zero-pad (zero-pad) 0
      'zoom-focus-style (zoom-focus-style) 2 
      ))
    (if *snd-opened-sound* (snd-display #__line__ ";*snd-opened-sound*: ~A" *snd-opened-sound*))
    ))


(if (and (not (= (default-output-data-format) mus-bfloat))
	 (not (= (default-output-data-format) mus-lfloat)))
    (set! (default-output-data-format) mus-lfloat))


;;; ---------------- test 2: headers ----------------
(define (snd_test_2)
  (if (string? sf-dir)
      (letrec ((test-headers
		(lambda (base-files)
		  (if (not (null? base-files))
		      (let ((testf (car base-files)))
			(let ((file (string-append sf-dir (list-ref testf 0))))
			  (if (file-exists? file)
			      (begin
				(if (not (equal? (mus-sound-chans file) (list-ref testf 1)))
				    (snd-display #__line__ ";~A: chans ~A /= ~A" 
						 (list-ref testf 0) 
						 (mus-sound-chans file) 
						 (list-ref testf 1)))
				(if (not (equal? (mus-sound-srate file) (list-ref testf 2)))
				    (snd-display #__line__ ";~A: srate ~A /= ~A" 
						 (list-ref testf 0) 
						 (mus-sound-srate file) 
						 (list-ref testf 2)))
				(if (fneq (mus-sound-duration file) (list-ref testf 3))
				    (snd-display #__line__ ";~A: duration ~A /= ~A" 
						 (list-ref testf 0)
						 (mus-sound-duration file) 
						 (list-ref testf 3)))
				(if (and (not (= (mus-sound-data-format file) mus-unknown))
					 (not (= (mus-sound-header-type file) 27)) ; bogus header on test case (comdisco)
					 (< (+ (mus-sound-length file) 1)
					    (* (mus-sound-datum-size file) (mus-sound-duration file)
					       (mus-sound-srate file) (mus-sound-chans file))))
				    (snd-display #__line__ ";mus-sound-length ~A: ~A (~A)" file
						 (mus-sound-length file)
						 (* (mus-sound-duration file) (mus-sound-srate file) 
						    (mus-sound-chans file) (mus-sound-datum-size file))))
				(if (fneq (/ (mus-sound-frames file) (mus-sound-srate file)) (mus-sound-duration file))
				    (snd-display #__line__ ";mus-sound-frames ~A: ~A (~A ~A)" file
						 (mus-sound-frames file)
						 (mus-sound-duration file)
						 (/ (mus-sound-frames file) (mus-sound-srate file))))
				(if (> (abs (- (mus-sound-frames file) (/ (mus-sound-samples file) (mus-sound-chans file)))) 1)
				    (snd-display #__line__ ";mus-sound-samples ~A: ~A ~A" file
						 (mus-sound-samples file)
						 (* (mus-sound-frames file) (mus-sound-chans file))))
				(if (not (equal? (mus-header-type-name (mus-sound-header-type file)) (list-ref testf 4)))
				    (snd-display #__line__ ";~A: type ~A /= ~A" 
						 (list-ref testf 0) 
						 (mus-header-type-name (mus-sound-header-type file))
						 (list-ref testf 4)))
				(if (not (equal? (mus-data-format-name (mus-sound-data-format file)) (list-ref testf 5)))
				    (snd-display #__line__ ";~A: type ~A /= ~A"
						 (list-ref testf 0) 
						 (mus-data-format-name (mus-sound-data-format file)) 
						 (list-ref testf 5)))
				(let ((lst (mus-sound-loop-info file)))
				  (if (> (length testf) 6)
				      (begin
					(if (not (equal? (car lst) (list-ref testf 6))) 
					    (snd-display #__line__ ";~A: loop start: ~A" (car lst) (list-ref testf 6)))
					(if (not (equal? (cadr lst) (list-ref testf 7))) 
					    (snd-display #__line__ ";~A: loop end: ~A" (cadr lst) (list-ref testf 7))))
				      (if (not (null? lst))
					  (snd-display #__line__ ";~A thinks it has loop info: ~A" file lst))))
				(mus-sound-forget file))
			      (snd-display #__line__ ";~A missing?" file))
			  (test-headers (cdr base-files))))))))
	
	;; need to make sure raw defaults are consistent with following tests
	(let ((ind (open-raw-sound :file (string-append sf-dir "addf8.nh") :channels 2 :srate 44100 :data-format mus-bshort)))
	  (if (sound? ind) (close-sound ind)))
	(catch #t
	       (lambda ()
		 (if (not (= (mus-sound-header-type (string-append sf-dir "midi60.mid")) -1)) (snd-display #__line__ ";midi60?")))
	       (lambda args args))
	(test-headers
	 (list
	  (list "5_secs.aiff" 1 44100 5.303107 "AIFF" "big endian short (16 bits)")
	  (list "8svx-8.snd" 1 22050 1.88766443729401 "SVX8" "signed byte (8 bits)")
	  (list "Fnonull.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Pmiscck.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Pmiscck.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
					;	    (list "Pnossnd.aif" 1 8000 0.0 "AIFC" "mulaw (8 bits)")
	  (list "Poffset.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Porder.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Ptjunk.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	  (list "Ptjunk.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
	  (list "SINE24-S.WAV" 2 44100 2.0 "RIFF" "little endian int (24 bits)")
	  (list "a1.asf" 1 16000 3.73656249046326 "asf" "unknown")
	  (list "a2.asf" 1 8000 4.63062477111816 "asf" "unknown")
	  (list "addf8.afsp" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	  (list "addf8.d" 1 8000 2.9760000705719 "SPPACK" "big endian short (16 bits)")
	  (list "addf8.dwd" 1 8000 2.9760000705719 "DiamondWare" "little endian short (16 bits)")
	  (list "addf8.nh" 2 44100 0.269931972026825 "raw (no header)" "big endian short (16 bits)")
	  (list "addf8.sd" 1 8000 2.9760000705719 "ESPS" "big endian short (16 bits)")
	  (list "addf8.sf_mipseb" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.sf_sun" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.sf_vax_b" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	  (list "addf8.wav" 1 8000 2.9760000705719 "RIFF" "little endian short (16 bits)")
	  (list "aebass.krz" 1 44100 3.0 "Kurzweil 2000" "big endian short (16 bits)")
	  (list "aiff-16.snd" 2 44100 0.746666669845581 "AIFF" "big endian short (16 bits)")
	  (list "aiff-8.snd" 2 44100 0.746666669845581 "AIFF" "signed byte (8 bits)")
	  (list "alaw.aifc" 1 44100 0.0367800444364548 "AIFC" "alaw (8 bits)")
	  (list "alaw.wav" 1 11025 8.70666694641113 "RIFF" "alaw (8 bits)")
	  (list "astor_basia.mp2" 2 44100 1.02179133892059 "raw (no header)" "big endian short (16 bits)")
	  (list "c.asf" 1 8000 21.3681259155273 "asf" "unknown")
	  (list "ce-c3.w02" 1 33000 3.88848495483398 "TX-16W" "unknown")
	  (list "ce-c4.w03" 1 33000 2.91618180274963 "TX-16W" "unknown")
	  (list "ce-d2.w01" 1 33000 3.46439385414124 "TX-16W" "unknown")
	  (list "clbonef.wav" 1 22050 2.57832193374634 "RIFF" "little endian float (32 bits)")
	  (list "cranker.krz" 1 44100 3.48267579078674 "Kurzweil 2000" "big endian short (16 bits)")
	  (list "d40130.aif" 1 10000 0.100000001490116 "AIFF" "big endian short (16 bits)")
	  (list "d40130.au" 1 10000 0.100000001490116 "Sun/Next" "big endian short (16 bits)")
	  (list "d40130.dsf" 1 8000 0.125 "Delusion" "little endian short (16 bits)")
	  (list "d40130.fsm" 1 8000 0.125249996781349 "Farandole" "little endian short (16 bits)")
	  (list "d40130.iff" 1 10000 0.100000001490116 "SVX8" "signed byte (8 bits)")
	  (list "d40130.pat" 1 10000 0.100000001490116 "Gravis Ultrasound patch" "little endian short (16 bits)")
	  (list "d40130.sds" 1 10000 0.100000001490116 "MIDI sample dump" "unknown")
	  (list "d40130.sdx" 1 10000 0.100000001490116 "Sample dump" "unsigned little endian short (16 bits)")
	  (list "d40130.sf" 1 10000 0.100000001490116 "IRCAM" "little endian short (16 bits)")
	  (list "d40130.smp" 1 8000 0.125 "SMP" "little endian short (16 bits)")
	  (list "d40130.sou" 1 8000 0.125 "SBStudioII" "little endian short (16 bits)")
	  (list "d40130.st3" 1 8000 0.125 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	  (list "d40130.uwf" 1 8000 0.125249996781349 "Ultratracker" "little endian short (16 bits)")
	  (list "d40130.voc" 1 10000 0.100100003182888 "VOC" "unsigned byte (8 bits)")
	  (list "d40130.w00" 1 16000 0.0625 "TX-16W" "unknown")
	  (list "d40130.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	  (list "d43.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	  (list "digit0v0.aiff" 1 8000 0.560000002384186 "AIFC" "big endian short (16 bits)")
	  (list "esps-16.snd" 1 8000 3.09737491607666 "ESPS" "big endian short (16 bits)")
	  (list "forest.aiff" 2 44100 3.907143 "AIFF" "big endian short (16 bits)" 24981 144332)
	  (list "g721.au" 1 11025 4.35328817367554 "Sun/Next" "unknown")
	  (list "g722.aifc" 1 44100 0.0184353739023209 "AIFC" "unknown")
	  (list "gong.wve" 1 8000 3.96799993515015 "PSION" "alaw (8 bits)")
	  (list "gsm610.wav" 1 11025 1.7687075138092 "RIFF" "unknown")
	  (list "inrs-16.snd" 1 8000 2.46399998664856 "INRS" "little endian short (16 bits)")
	  (list "kirk.wve" 1 8000 1.40799999237061 "PSION" "alaw (8 bits)")
	  (list "loop.aiff" 1 44100 0.0367120169103146 "AIFC" "big endian short (16 bits)" 12 23)
	  (list "m.asf" 1 8000 64.9646224975586 "asf" "unknown")
	  (list "mary-sun4.sig" 1 8000 4.47612476348877 "Comdisco SPW signal" "big endian double (64 bits)")
	  (list "mocksong.wav" 1 11025 7.86956930160522 "RIFF" "little endian short (16 bits)")
	  (list "mono24.wav" 1 22050 1.98997735977173 "RIFF" "little endian int (24 bits)")
	  (list "msadpcm.wav" 1 11025 4.43501138687134 "RIFF" "unknown")
	  (list "n8.snd" 1 44100 0.0367800444364548 "Sun/Next" "signed byte (8 bits)")
	  (list "nasahal.aif" 1 11025 9.89841270446777 "AIFF" "signed byte (8 bits)")
	  (list "nasahal.avi" 1 11025 10.4327440261841 "AVI" "little endian short (16 bits)")
	  (list "nasahal.dig" 1 11025 9.89841270446777 "Sound Designer 1" "big endian short (16 bits)")
	  (list "nasahal.ivc" 2 44100 0.449002265930176 "raw (no header)" "big endian short (16 bits)")
	  (list "nasahal.pat" 1 11025 3.95410442352295 "Gravis Ultrasound patch" "unsigned byte (8 bits)")
	  (list "nasahal.snd" 1 11025 9.89841270446777 "SNDT" "unsigned byte (8 bits)")
	  (list "nasahal.svx" 1 11025 9.89841270446777 "SVX8" "signed byte (8 bits)")
	  (list "nasahal.v8" 1 8000 13.6412496566772 "Covox V8" "unsigned byte (8 bits)")
	  (list "nasahal.voc" 1 11025 9.89941024780273 "VOC" "unsigned byte (8 bits)")
	  (list "nasahal.vox" 2 44100 0.224444448947906 "raw (no header)" "big endian short (16 bits)")
	  (list "nasahal8.wav" 1 11025 9.89841270446777 "RIFF" "unsigned byte (8 bits)")
	  (list "nasahalad.smp" 1 11025 4.94920635223389 "Goldwave sample" "little endian short (16 bits)")
	  (list "next-16.snd" 1 22050 1.00004529953003 "Sun/Next" "big endian short (16 bits)")
	  (list "next-8.snd" 1 22050 0.226757362484932 "Sun/Next" "signed byte (8 bits)")
	  (list "next-dbl.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian double (64 bits)")
	  (list "oboe.ldbl" 1 22050 2.30512475967407 "RIFF" "little endian double (64 bits)")
	  (list "next-flt.snd" 1 22050 0.226757362484932 "Sun/Next" "big endian float (32 bits)")
	  (list "aifc-float.snd" 1 22050 0.226757362484932 "AIFC" "big endian float (32 bits)")
	  (list "next-mulaw.snd" 1 8012 2.03295063972473 "Sun/Next" "mulaw (8 bits)")
	  (list "next24.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian int (24 bits)")
	  (list "nist-01.wav" 1 16000 2.26912498474121 "NIST" "little endian short (16 bits)")
	  (list "nist-10.wav" 1 16000 2.26912498474121 "NIST" "big endian short (16 bits)")
	  (list "nist-16.snd" 1 16000 1.02400004863739 "NIST" "big endian short (16 bits)")
	  (list "nist-shortpack.wav" 1 16000 4.53824996948242 "NIST" "unknown")
	  (list "none.aifc" 1 44100 0.0367800444364548 "AIFC" "big endian short (16 bits)")
	  (list "nylon2.wav" 2 22050 1.14376413822174 "RIFF" "unknown")
	  (list "o2.adf" 1 44100 0.036780 "CSRE adf" "little endian short (16 bits)")
	  (list "o2.avr" 1 44100 0.0183900222182274 "AVR" "big endian short (16 bits)")
	  (list "o2.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	  (list "o2.mpeg1" 2 44100 0.00709750549867749 "raw (no header)" "big endian short (16 bits)")
	  (list "o2.sd2" 2 44100 0.0183900222182274 "raw (no header)" "big endian short (16 bits)")
	  (list "o2.sf2" 1 44100 0.0367800444364548 "SoundFont" "little endian short (16 bits)")
	  (list "o2.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	  (list "o2.voc" 1 44100 0.0368934236466885 "VOC" "little endian short (16 bits)")
	  (list "o2.wave" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "o2_12bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "o2_18bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	  (list "o2_711u.wave" 1 44100 0.0367800444364548 "RIFF" "mulaw (8 bits)")
	  (list "o2_722.snd" 1 44100 0.0183900222182274 "Sun/Next" "unknown")
	  (list "o2_726.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	  (list "o2_726.snd" 1 44100 0.0230158735066652 "Sun/Next" "unknown")
	  (list "o2_728.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	  (list "o2_8.iff" 1 44100 0.0367800444364548 "SVX8" "signed byte (8 bits)")
	  (list "o2_8.voc" 1 44100 0.0370294786989689 "VOC" "unsigned byte (8 bits)")
	  (list "o2_dvi.wave" 1 44100 0.0232199542224407 "RIFF" "unknown")
	  (list "o2_float.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian float (32 bits)")
	  (list "o2_gsm.aiff" 1 8000 0.0367499999701977 "AIFC" "unknown")
	  (list "o2_u8.avr" 1 44100 0.0367800444364548 "AVR" "unsigned byte (8 bits)")
	  (list "o2_u8.wave" 1 44100 0.0367800444364548 "RIFF" "unsigned byte (8 bits)")
	  (list "o28.mpc" 1 44100 0.036780 "AKAI 4" "little endian short (16 bits)")
	  (list "oboe.g721" 1 22050 1.15287983417511 "Sun/Next" "unknown")
	  (list "oboe.g723_24" 1 22050 0.864761888980865 "Sun/Next" "unknown")
	  (list "oboe.g723_40" 1 22050 1.44126987457275 "Sun/Next" "unknown")
	  (list "oboe.kts" 1 22050 2.305125 "Korg" "big endian short (16 bits)")
	  (list "oboe.its" 1 22050 2.305125 "Impulse Tracker" "little endian short (16 bits)")
	  (list "oboe.sf2" 1 22050 2.30512475967407 "SoundFont" "little endian short (16 bits)")
	  (list "oboe.paf" 1 22050 2.305125 "Ensoniq Paris" "big endian short (16 bits)")
	  (list "oboe.pf1" 1 22050 2.305125 "Ensoniq Paris" "little endian short (16 bits)")
	  (list "oboe.smp" 1 22050 2.305125 "snack SMP" "little endian short (16 bits)")
	  (list "oboe.rf64" 1 22050 2.305125 "rf64" "little endian short (16 bits)")
	  (list "oboe-be32.caf" 1 22050 2.305125 "caff" "normalized big endian int (32 bits)")
	  (list "oboe-bf64.caf" 1 22050 2.305125 "caff" "big endian double (64 bits)")
	  (list "oboe-lf32.caf" 1 22050 2.305125 "caff" "little endian float (32 bits)")
	  (list "oboe-ulaw.caf" 1 22050 2.305125 "caff" "mulaw (8 bits)")
	  (list "oboe.nsp" 1 22050 2.305125 "CSL" "little endian short (16 bits)")
	  (list "oboe.nvf" 1 8000 6.353500 "Creative NVF" "unknown")
	  (list "oboe-ulaw.voc" 1 22050 2.305669 "VOC" "mulaw (8 bits)")
	  (list "oboe-lf32.sf" 1 22050 2.305669 "IRCAM" "little endian float (32 bits)")
	  (list "oboe.wfp" 1 22050 2.305125 "Turtle Beach" "little endian short (16 bits)")
	  (list "oboe.sox" 1 22050 2.305125 "Sox" "normalized little endian int (32 bits)")
	  (list "oki.snd" 2 44100 0.0041950112208724 "raw (no header)" "big endian short (16 bits)")
	  (list "oki.wav" 1 44100 0.016780 "RIFF" "unknown")
	  (list "orv-dvi-adpcm.wav" 1 44100 1.92725622653961 "RIFF" "unknown")
	  (list "riff-16.snd" 1 22050 1.88766443729401 "RIFF" "little endian short (16 bits)")
	  (list "riff-8-u.snd" 1 11025 0.506848096847534 "RIFF" "unsigned byte (8 bits)")
	  (list "rooster.wve" 1 8000 2.04800009727478 "PSION" "alaw (8 bits)")
	  (list "sd1-16.snd" 1 44100 0.400544226169586 "Sound Designer 1" "big endian short (16 bits)")
					;	    (list "segfault.snd" 16777216 576061440 1.24986669902682e-7 "Sun/Next" "unknown")
	  (list "sf-16.snd" 1 22050 1.88766443729401 "IRCAM" "big endian short (16 bits)")
	  (list "si654.adc" 1 16000 6.71362495422363 "ADC/OGI" "big endian short (16 bits)")
	  (list "smp-16.snd" 1 8000 5.2028751373291 "SMP" "little endian short (16 bits)")
	  (list "sound.pat" 1 8000 1.95050001144409 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	  (list "sound.sap" 1 8000 1.95050001144409 "Goldwave sample" "little endian short (16 bits)")
	  (list "sound.sds" 1 8000 1.95050001144409 "MIDI sample dump" "unknown")
	  (list "sound.sfr" 1 8000 1.95050001144409 "SRFS" "little endian short (16 bits)")
	  (list "sound.v8" 1 8000 1.95050001144409 "Covox V8" "unsigned byte (8 bits)")
	  (list "sound.vox" 2 44100 0.044217687100172 "raw (no header)" "big endian short (16 bits)")
	  (list "step.omf" 1 11025 8.70666694641113 "OMF" "signed byte (8 bits)")
	  (list "step.qt" 1 11025 8.70630359649658 "Quicktime" "unsigned byte (8 bits)")
	  (list "sun-16-afsp.snd" 1 8000 2.9760000705719 "Sun/Next" "big endian short (16 bits)")
	  (list "sun-mulaw.snd" 1 8000 4.61950016021729 "Sun/Next" "mulaw (8 bits)")
	  (list "sw1038t_short.wav" 2 8000 6.0 "NIST" "mulaw (8 bits)")
	  (list "swirl.pat" 1 22050 1.0619500875473 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	  (list "sy85.snd" 1 8000 5.05600023269653 "Sy-85" "big endian short (16 bits)")
	  (list "sy99.snd" 1 8000 4.54400014877319 "Sy-99" "big endian short (16 bits)")
	  (list "telephone.wav" 1 16000 2.27881240844727 "NIST" "little endian short (16 bits)")
	  (list "trumps22.adp" 1 22050 3.092880 "RIFF" "unknown")
	  (list "truspech.wav" 1 8000 1.1599999666214 "RIFF" "unknown")
	  (list "ulaw.aifc" 1 44100 0.0367800444364548 "AIFC" "mulaw (8 bits)")
	  (list "voc-8-u.snd" 1 8000 1.49937498569489 "VOC" "unsigned byte (8 bits)")
	  (list "o28.voc" 1 44100 0.036893 "VOC" "little endian short (16 bits)")
	  (list "voxware.wav" 1 8000 0.324000000953674 "RIFF" "unknown")
	  (list "wd.w00" 1 8000 0.202749997377396 "Sy-99" "big endian short (16 bits)")
	  (list "wd1.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	  (list "wd1.wav" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wheel.mat" 2 44100 0.145646259188652 "raw (no header)" "big endian short (16 bits)")
	  (list "b8.pvf" 1 44100 0.036803 "Portable Voice Format" "signed byte (8 bits)")
	  (list "b16.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian short (16 bits)")
	  (list "b32.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian int (32 bits)")
	  (list "water.voc" 2 32000 42.3463897705078 "VOC" "little endian short (16 bits)")
	  (list "wood.dsf" 1 8000 0.202749997377396 "Delusion" "little endian short (16 bits)")
	  (list "wood.dvi" 1 22100 0.0278733037412167 "RIFF" "unknown")
	  (list "wood.dwd" 1 22100 0.0733936652541161 "DiamondWare" "signed byte (8 bits)")
	  (list "wood.fsm" 1 8000 0.202999994158745 "Farandole" "little endian short (16 bits)")
	  (list "wood.mad" 1 22100 0.0372398197650909 "RIFF" "unknown")
	  (list "wood.maud" 1 44100 0.0183900222182274 "MAUD" "big endian short (16 bits)")
	  (list "wood.pat" 1 22100 0.0733936652541161 "Gravis Ultrasound patch" "little endian short (16 bits)")
	  (list "wood.riff" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wood.rifx" 1 44100 0.0367800444364548 "RIFF" "big endian short (16 bits)")
	  (list "wood.sds" 1 22100 0.0733936652541161 "MIDI sample dump" "unknown")
	  (list "wood.sdx" 1 22100 0.0733936652541161 "Sample dump" "unsigned little endian short (16 bits)")
	  (list "wood.sf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	  (list "wood.sndr" 2 44100 0.0092290248721838 "raw (no header)" "big endian short (16 bits)")
	  (list "wood.sndt" 1 44100 0.0367800444364548 "SNDT" "unsigned byte (8 bits)")
	  (list "wood.st3" 1 8000 0.202749997377396 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	  (list "wood.uwf" 1 8000 0.202999994158745 "Ultratracker" "little endian short (16 bits)")
	  (list "wood.w00" 1 16000 0.101374998688698 "TX-16W" "unknown")
	  (list "wood12.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "wood16.dwd" 2 44100 0.0367800444364548 "DiamondWare" "little endian short (16 bits)")
	  (list "wood16.wav" 2 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	  (list "wood16.nsp" 2 44100 0.0367800444364548 "CSL" "little endian short (16 bits)")
	  (list "wood16.smp" 2 44100 0.0367800444364548 "snack SMP" "little endian short (16 bits)")
	  (list "wood24.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	  (list "woodblock.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	  (list "woodflt.snd" 1 44100 0.0367800444364548 "Sun/Next" "big endian float (32 bits)")
	  (list "RealDrums.sf2" 1 44100 6.39725637435913 "SoundFont" "little endian short (16 bits)")
	  (list "32bit.sf" 1 44100 4.6 "IRCAM" "little endian float (32 bits, unscaled)")
	  (list "PCM_48_8bit_m.w64" 1 48000 0.375 "SoundForge" "unsigned byte (8 bits)")
	  (list "oboe.sf6" 1 22050 2.305125 "SoundForge" "little endian short (16 bits)")
	  (list "addf8.24we" 1 8000 2.976000 "RIFF" "little endian int (24 bits)")
	  (list "hybrid.snd" 1 44100 4.600000 "BICSF" "big endian float (32 bits)")
	  (list "litmanna.sf" 1 44100 .533 "IRCAM" "little endian short (16 bits)")
	  (list "M1F1-float64C-AFsp.aif" 2 8000 2.9366 "AIFC" "big endian double (64 bits)")
	  (list "MacBoing.wav" 1 11127 0.696 "RIFF" "unsigned byte (8 bits)")
	  (list "t15.aiff" 2 44100 135.00 "AIFC" "little endian short (16 bits)")
	  (list "tomf8.aud" 1 8000 2.016000 "INRS" "little endian short (16 bits)")
	  (list "Xhs001x.nsp" 1 10000 6.017400 "CSL" "little endian short (16 bits)")
	  (list "zulu_a4.w11" 1 33000 1.21987879276276 "TX-16W" "unknown" 23342 40042)))
	
	(for-each (lambda (in-name real-name)
		    (if (not (string=? (mus-expand-filename in-name) real-name))
			(snd-display #__line__ ";mus-expand-filename ~A -> ~A" in-name (mus-expand-filename in-name)))
		    (if (file-exists? "/home/bil/./sf1/o2.voc")
			(let ((ind (open-sound in-name)))
			  (if (not (sound? ind))
			      (snd-display #__line__ ";can't open ~A" in-name)
			      (begin
				(if (not (string=? (file-name ind) real-name))
				    (snd-display #__line__ ";expand file name ~A: ~A" in-name (file-name ind)))
				(close-sound ind))))))
		  (list "/home/bil/./sf1/o2.voc" "~/./sf1/o2.voc" "~/cl/../sf1/o2.voc" "/home/bil/cl/../sf1/o2.voc")
		  (list "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc" "/home/bil/sf1/o2.voc"))
	
	(let ((lst (mus-sound-mark-info (string-append sf-dir "forest.aiff"))))
	  (if (not (equal? lst '((4 0) (3 0) (2 144332) (1 24981))))
	      (snd-display #__line__ ";mus-sound-mark-info forest: ~A" lst)))
	(let ((lst (mus-sound-mark-info (string-append sf-dir "traffic.aiff"))))
	  (if (not (equal? lst '((4 1) (3 0) (2 171931) (1 99461))))
	      (snd-display #__line__ ";mus-sound-mark-info traffic: ~A" lst)))
	)))



;;; ---------------- test 3: variables ----------------

(define (snd_test_3)
  (let ((ind #f))
    
    (set! ind (open-sound "oboe.snd"))
    (if (and (file-exists? "funcs.cl") 
	     (not (defined? 'swellf)))
	(load "funcs.cl"))
    (let ((td (temp-dir)))
      (catch #t
	     (lambda ()
	       (set! (temp-dir) (string-append home-dir "/test"))
	       (if (not (string=? (temp-dir) (string-append home-dir "/test")))
		   (snd-display #__line__ ";set temp-dir: ~A?" (temp-dir))))
	     (lambda args args))
      (if td 
	  (set! (temp-dir) td)
	  (set! (temp-dir) "")))
    (if (fneq (sample 1000) 0.0328) (snd-display #__line__ ";sample: ~A?" (sample 1000)))
    (if (or (not (hook? output-name-hook)) (not (hook-empty? output-name-hook)))
	(snd-display #__line__ ";output-name-hook: ~A?" output-name-hook))
    (if (or (not (hook? output-comment-hook)) (not (hook-empty? output-comment-hook)))
	(snd-display #__line__ ";output-comment-hook: ~A?" output-comment-hook))
    (if (or (not (hook? peak-env-hook)) (not (hook-empty? peak-env-hook)))
	(snd-display #__line__ ";peak-env-hook: ~A?" peak-env-hook))
    (if (or (not (hook? help-hook)) (not (hook-empty? help-hook)))
	(snd-display #__line__ ";help-hook: ~A?" help-hook))
    (if (or (not (hook? mark-drag-hook)) (not (hook-empty? mark-drag-hook)))
	(snd-display #__line__ ";mark-drag-hook: ~A?" mark-drag-hook))
    (if (or (not (hook? mark-drag-triangle-hook)) (not (hook-empty? mark-drag-triangle-hook)))
	(snd-display #__line__ ";mark-drag-triangle-hook: ~A?" mark-drag-triangle-hook))
    (if (or (not (hook? mix-drag-hook)) (not (hook-empty? mix-drag-hook)))
	(snd-display #__line__ ";mix-drag-hook: ~A?" mix-drag-hook))
    (if (or (not (hook? mouse-drag-hook)) (not (hook-empty? mouse-drag-hook)))
	(snd-display #__line__ ";mouse-drag-hook: ~A?" mouse-drag-hook))
    (if (or (not (hook? mouse-click-hook)) (not (hook-empty? mouse-click-hook)))
	(snd-display #__line__ ";mouse-click-hook: ~A?" mouse-click-hook))
    (if (or (not (hook? mouse-press-hook)) (not (hook-empty? mouse-press-hook)))
	(snd-display #__line__ ";mouse-press-hook: ~A?" mouse-press-hook))
    (if (or (not (hook? start-playing-hook)) (not (hook-empty? start-playing-hook)))
	(snd-display #__line__ ";start-playing-hook: ~A?" start-playing-hook))
    (if (or (not (hook? start-playing-selection-hook)) (not (hook-empty? start-playing-selection-hook)))
	(snd-display #__line__ ";start-playing-selection-hook: ~A?" start-playing-selection-hook))
    (if (not (hook? stop-playing-hook))
	(snd-display #__line__ ";stop-playing-hook: ~A?" stop-playing-hook))
    (if (or (not (hook? key-press-hook)) (not (hook-empty? key-press-hook)))
	(snd-display #__line__ ";key-press-hook: ~A?" key-press-hook))
    (if (or (not (hook? snd-error-hook)) (not (hook-empty? snd-error-hook)))
	(snd-display #__line__ ";snd-error-hook: ~A?" snd-error-hook))
    (if (or (not (hook? snd-warning-hook)) (not (hook-empty? snd-warning-hook)))
	(snd-display #__line__ ";snd-warning-hook: ~A?" snd-warning-hook))
    (if (or (not (hook? name-click-hook)) (not (hook-empty? name-click-hook)))
	(snd-display #__line__ ";name-click-hook: ~A?" name-click-hook))
    (if (or (not (hook? after-apply-controls-hook)) (not (hook-empty? after-apply-controls-hook)))
	(snd-display #__line__ ";after-apply-controls-hook: ~A?" after-apply-controls-hook))
    (if (or (not (hook? enved-hook)) (not (hook-empty? enved-hook)))
	(snd-display #__line__ ";enved-hook: ~A?" enved-hook))
    (if (or (not (hook? mouse-enter-label-hook)) (not (hook-empty? mouse-enter-label-hook)))
	(snd-display #__line__ ";mouse-enter-label-hook: ~A?" mouse-enter-label-hook))
    (if (or (not (hook? mouse-enter-graph-hook)) (not (hook-empty? mouse-enter-graph-hook)))
	(snd-display #__line__ ";mouse-enter-graph-hook: ~A?" mouse-enter-graph-hook))
    (if (or (not (hook? mouse-enter-listener-hook)) (not (hook-empty? mouse-enter-listener-hook)))
	(snd-display #__line__ ";mouse-enter-listener-hook: ~A?" mouse-enter-listener-hook))
    (if (or (not (hook? mouse-leave-label-hook)) (not (hook-empty? mouse-leave-label-hook)))
	(snd-display #__line__ ";mouse-leave-label-hook: ~A?" mouse-leave-label-hook))
    (if (or (not (hook? mouse-leave-graph-hook)) (not (hook-empty? mouse-leave-graph-hook)))
	(snd-display #__line__ ";mouse-leave-graph-hook: ~A?" mouse-leave-graph-hook))
    (if (or (not (hook? mouse-leave-listener-hook)) (not (hook-empty? mouse-leave-listener-hook)))
	(snd-display #__line__ ";mouse-leave-listener-hook: ~A?" mouse-leave-listener-hook))
    (if (or (not (hook? initial-graph-hook)) (not (hook-empty? initial-graph-hook)))
	(snd-display #__line__ ";initial-graph-hook: ~A?" initial-graph-hook))
    (if (or (not (hook? after-graph-hook)) (not (hook-empty? after-graph-hook)))
	(snd-display #__line__ ";after-graph-hook: ~A?" after-graph-hook))
    (if (or (not (hook? graph-hook)) (not (hook-empty? graph-hook)))
	(snd-display #__line__ ";graph-hook: ~A?" graph-hook))
    
    (set! (show-controls) #t)
    (if with-gui
	(begin
	  (let ((wid (enved-dialog) ))
	    (if (not (equal? wid (list-ref (dialog-widgets) 2)))
		(snd-display #__line__ ";enved-dialog -> ~A ~A" wid (list-ref (dialog-widgets) 2))))
					;(if (not (list-ref (dialog-widgets) 2)) (snd-display #__line__ ";enved-dialog?"))
	  (set! (enved-envelope) '(0.0 0.0 1.0 1.0 2.0 0.0))
	  (if (not (equal? (enved-envelope) (list 0.0 0.0 1.0 1.0 2.0 0.0)))
	      (snd-display #__line__ ";set enved-envelope: ~A?" (enved-envelope)))
	  (set! (enved-envelope) (enved-envelope))
	  (if (not (equal? (enved-envelope) (list 0.0 0.0 1.0 1.0 2.0 0.0)))
	      (snd-display #__line__ ";set enved-envelope to self: ~A?" (enved-envelope)))))
    
    (letrec ((test-vars
	      (lambda (lst)
		(if (not (null? lst))
		    (let* ((name (list-ref (car lst) 0))
			   (getfnc (list-ref (car lst) 1))
			   (setfnc (lambda (val) (set! (getfnc) val)))
			   (initval (list-ref (car lst) 2))
			   (newval (list-ref (car lst) 3)))
		      
		      (setfnc newval)
		      (let ((nowval (getfnc)))
			(if (and (not (equal? newval nowval))
				 (or (not (list? newval))
				     (not (feql newval nowval))))
			    (if (and (number? newval) (not (rational? newval)))
				(if (> (abs (- newval nowval)) .01)
				    (snd-display #__line__ ";~A /= ~A (~A)" name newval nowval))
				(snd-display #__line__ ";~A /= ~A (~A)" name newval nowval)))
			(setfnc initval)
			(set! (getfnc) newval)
			(let ((nowval (getfnc)))
			  (if (and (not (equal? newval nowval))
				   (or (not (list? newval))
				       (not (feql newval nowval))))
			      (if (and (number? newval) (not (rational? newval)))
				  (if (> (abs (- newval nowval)) .01)
				      (snd-display #__line__ ";set! ~A /= ~A (~A)" name newval nowval))
				  (snd-display #__line__ ";set! ~A /= ~A (~A)" name newval nowval)))
			  (setfnc initval))
			(test-vars (cdr lst))))))))
      (test-vars 
       (list
	(list 'amp-control amp-control 1.0 0.5)
	(list 'amp-control-bounds amp-control-bounds (list 0.0 8.0) (list 1.0 5.0))
	(list 'ask-before-overwrite ask-before-overwrite #f #t)
	(list 'audio-input-device audio-input-device 0 1)
	(list 'audio-output-device audio-output-device 0 1)
	(list 'auto-resize auto-resize #t #f)
	(list 'auto-update auto-update #f #t)
	(list 'channel-style channel-style 0 1)
	(list 'colormap colormap good-colormap better-colormap)
	(list 'color-cutoff color-cutoff 0.003 0.01)
	(list 'color-inverted color-inverted #t #f)
	(list 'color-scale color-scale 1.0 0.5)
	(list 'contrast-control contrast-control 0.0 0.5)
	(list 'contrast-control-bounds contrast-control-bounds (list 0.0 10.0) (list 1.0 5.0))
	(list 'contrast-control-amp contrast-control-amp 1.0 0.5)
	(list 'contrast-control? contrast-control? #f #t)
	(list 'auto-update-interval auto-update-interval 60.0 120.0)
	(list 'cursor-update-interval cursor-update-interval 0.05 0.10)
	(list 'cursor-location-offset cursor-location-offset 0 32768)
	(list 'with-tracking-cursor with-tracking-cursor #f #t)
	(list 'cursor-size cursor-size 15 30)
	(list 'cursor-style cursor-style cursor-cross cursor-line)
	(list 'tracking-cursor-style tracking-cursor-style cursor-cross cursor-line)
	(list 'dac-combines-channels dac-combines-channels #t #f)
	(list 'dac-size dac-size 256 512)
	(list 'minibuffer-history-length minibuffer-history-length 8 16)
	(list 'clipping clipping #f #t)
	(list 'default-output-chans default-output-chans 1 2)
	(list 'default-output-data-format default-output-data-format 1 1)
	(list 'default-output-srate default-output-srate 22050 44100)
	(list 'default-output-header-type default-output-header-type mus-next mus-aifc)
	(list 'dot-size dot-size 1 4)
	(list 'enved-base enved-base 1.0  1.5)
	(list 'enved-clip? enved-clip? #f #t)
	(list 'enved-in-dB enved-in-dB #f #t)
	(list 'enved-style enved-style envelope-linear envelope-exponential)
	(list 'enved-power enved-power 3.0 3.5)
	(list 'enved-target enved-target 0 1)
	(list 'enved-wave? enved-wave? #f #t)
	(list 'eps-file eps-file "snd.eps" "snd-1.eps")
	(list 'eps-left-margin eps-left-margin 0.0 72.0)
	(list 'eps-size eps-size 1.0 2.0)
	(list 'eps-bottom-margin eps-bottom-margin 0.0 36.0)
	(list 'expand-control expand-control 1.0 2.0)
	(list 'expand-control-bounds expand-control-bounds (list .001 20.0) (list 1.0 2.0))
	(list 'expand-control-hop expand-control-hop 0.05 0.1)
	(list 'expand-control-jitter expand-control-jitter 0.1 0.2)
	(list 'expand-control-length expand-control-length 0.15 0.2)
	(list 'expand-control-ramp expand-control-ramp 0.4 0.2)
	(list 'expand-control? expand-control? #f #t)
	(list 'fft-window-alpha fft-window-alpha 0.0  1.0)
	(list 'fft-window-beta fft-window-beta 0.0  0.5)
	(list 'fft-log-frequency fft-log-frequency #f #t)
	(list 'fft-log-magnitude fft-log-magnitude #f #t)
	(list 'fft-with-phases fft-with-phases #f #t)
	(list 'transform-size transform-size 512 1024)
	(list 'transform-graph-type transform-graph-type graph-once graph-as-sonogram)
	(list 'fft-window fft-window 6 5)
	(list 'transform-graph? transform-graph? #f #t)
	(list 'filter-control-in-dB filter-control-in-dB #f #t)
	(list 'filter-control-envelope filter-control-envelope (list 0.0 1.0 1.0 1.0) (list 0.0 1.0 1.0 0.0))
	(list 'enved-filter enved-filter #t #f)
	(list 'enved-filter-order enved-filter-order 40 20)
	(list 'filter-control-in-hz filter-control-in-hz #f #t)
	(list 'filter-control-order filter-control-order 20 40)
	(list 'filter-control? filter-control? #f #t)
	(list 'graph-cursor graph-cursor 34 33)
	(list 'graph-style graph-style 0 1)
	(list 'just-sounds just-sounds #f #t)
	(list 'listener-prompt listener-prompt ">" ":")
	(list 'max-transform-peaks max-transform-peaks 100 10)
	(list 'max-regions max-regions 16 6)
	(list 'min-dB min-dB -60.0 -90.0)
	(list 'log-freq-start log-freq-start 32.0 10.0)
	(list 'mix-waveform-height mix-waveform-height 20 40)
	(list 'mix-tag-height mix-tag-height 14 20)
	(list 'mix-tag-width mix-tag-width 6 20)
	(list 'mark-tag-height mark-tag-height 4 20)
	(list 'mark-tag-width mark-tag-width 10 20)
	(list 'mus-prescaler mus-prescaler 1.0 100.0)
	(list 'mus-clipping mus-clipping #f #t)
	(list 'selection-creates-region selection-creates-region #t #f)
	(list 'transform-normalization transform-normalization normalize-by-channel dont-normalize)
	(list 'view-files-sort view-files-sort 0 1)
	(list 'print-length print-length 12 16)
	(list 'region-graph-style region-graph-style graph-lines graph-lollipops)
	(list 'reverb-control-decay reverb-control-decay 1.0 2.0)
	(list 'reverb-control-feedback reverb-control-feedback 1.09 1.6)
	(list 'reverb-control-length reverb-control-length 1.0 2.0)
	(list 'reverb-control-length-bounds reverb-control-length-bounds (list 0.0 5.0) (list 1.0 2.0))
	(list 'reverb-control-lowpass reverb-control-lowpass 0.7 0.9)
	(list 'reverb-control-scale reverb-control-scale 0.0 0.2)
	(list 'reverb-control-scale-bounds reverb-control-scale-bounds (list 0.0 4.0) (list 0.0 0.2))
	(list 'reverb-control? reverb-control? #f #t)
	(list 'show-axes show-axes 1 0)
	(list 'show-transform-peaks show-transform-peaks #f #t)
	(list 'show-indices show-indices #f #t)
	(list 'show-marks show-marks #t #f)
	(list 'show-mix-waveforms show-mix-waveforms #t #f)
	(list 'show-selection-transform show-selection-transform #f #t)
	(list 'show-y-zero show-y-zero #f #t)
	(list 'show-grid show-grid #f #t)
	(list 'grid-density grid-density 1.0 0.5)
	(list 'show-sonogram-cursor show-sonogram-cursor #f #t)
	(list 'sinc-width sinc-width 10 40)
	(list 'spectrum-end spectrum-end 1.0 0.7)
	(list 'spectro-hop spectro-hop 4 10)
	(list 'spectrum-start spectrum-start 0.0 0.1)
	(list 'spectro-x-angle spectro-x-angle (if (provided? 'gl) 300.0 90.0) 60.0)
	(list 'spectro-x-scale spectro-x-scale (if (provided? 'gl) 1.5 1.0) 2.0)
	(list 'spectro-y-angle spectro-y-angle (if (provided? 'gl) 320.0 0.0) 60.0)
	(list 'spectro-y-scale spectro-y-scale 1.0 2.0)
	(list 'spectro-z-angle spectro-z-angle (if (provided? 'gl) 0.0 358.0) 60.0)
	(list 'spectro-z-scale spectro-z-scale (if (provided? 'gl) 1.0 0.1) 0.2)
	(list 'speed-control speed-control 1.0 0.5)
	(list 'speed-control-bounds speed-control-bounds (list 0.05 20.0) (list 1.0 5.0))
	(list 'speed-control-style speed-control-style 0 1)
	(list 'speed-control-tones speed-control-tones 12 18)
	(list 'sync sync 0 1)
	(list 'tiny-font tiny-font (if (provided? 'snd-gtk) "Sans 8" "6x12") (if (provided? 'snd-gtk) "Monospace 10" "9x15"))
	(list 'transform-type transform-type fourier-transform autocorrelation)
	(list 'with-verbose-cursor with-verbose-cursor #f #t)
	(list 'wavelet-type wavelet-type 0 1)
	(list 'time-graph? time-graph? #f #t)
	(list 'time-graph-type time-graph-type graph-once graph-as-wavogram)
	(list 'wavo-hop wavo-hop 3 6)
	(list 'wavo-trace wavo-trace 64 128)
	(list 'with-mix-tags with-mix-tags #t #f)
	(list 'with-relative-panes with-relative-panes #t #f)
	(list 'with-gl with-gl (provided? 'gl) #f)
	(list 'x-axis-style x-axis-style 0 1)
	(list 'beats-per-minute beats-per-minute 30.0 120.0)
	(list 'beats-per-measure beats-per-measure 1 120)
	(list 'zero-pad zero-pad 0 1)
	(list 'zoom-focus-style zoom-focus-style 2 1))))
    
    (letrec ((test-bad-args
	      (lambda (lst)
		(if (not (null? lst))
		    (let* ((name (list-ref (car lst) 0))
			   (getfnc (list-ref (car lst) 1))
			   (setfnc (lambda (val) (set! (getfnc) val)))
			   (initval (list-ref (car lst) 2))
			   (newvals (list-ref (car lst) 3)))
		      (for-each
		       (lambda (n)
			 (catch #t 
				(lambda ()
				  (setfnc n))
				(lambda args (car args)))
			 (let ((nowval (getfnc)))
			   (if (equal? n nowval)
			       (snd-display #__line__ ";(bad set) ~A = ~A (~A)" name n initval))
			   (setfnc initval)))
		       newvals)
		      (test-bad-args (cdr lst)))))))
      (test-bad-args
       (list
	(list 'amp-control amp-control 1.0 '(-1.0 123.123))
	(list 'amp-control-bounds amp-control-bounds (list 0.0 8.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	(list 'channel-style channel-style 0 '(32 -1 1.0))
	(list 'colormap colormap good-colormap '(321 -123))
	(list 'color-cutoff color-cutoff 0.003 '(-1.0 123.123))
	(list 'color-scale color-scale 1.0 '(-32.0 2000.0))
	(list 'contrast-control contrast-control 0.0 '(-123.123 123.123))
	(list 'contrast-control-bounds contrast-control-bounds (list 0.0 10.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	(list 'cursor-size cursor-size 15 '(1.123 -2.5))
	(list 'dac-size dac-size 256 '(-1 0 -123))
	(list 'dot-size dot-size 1 '(0 -1 -123))
	(list 'enved-target enved-target 0 '(123 -321))
	(list 'expand-control expand-control 1.0 '(-1.0 0.0))
	(list 'expand-control-bounds expand-control-bounds (list 0.001 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	(list 'expand-control-hop expand-control-hop 0.05 '(-1.0))
	(list 'expand-control-length expand-control-length 0.15 '(-1.0 0.0))
	(list 'expand-control-ramp expand-control-ramp 0.4 '(-1.0 1.0 123.123))
	(list 'fft-window-alpha fft-window-alpha 0.0  '(-1.0 123.123))
	(list 'fft-window-beta fft-window-beta 0.0  '(-1.0 123.123))
	(list 'transform-size transform-size 512 '(-1 0))
	(list 'zero-pad zero-pad 0 '(-1 -123))
	(list 'cursor-style cursor-style cursor-cross '(-1))
	(list 'cursor-style cursor-style cursor-line '(2 123))
	(list 'tracking-cursor-style tracking-cursor-style cursor-cross '(-1))
	(list 'tracking-cursor-style tracking-cursor-style cursor-line '(2 123))
	(list 'transform-graph-type transform-graph-type graph-once '(-1 123))
	(list 'fft-window fft-window 6 '(-1 123))
	(list 'enved-filter-order enved-filter-order 40 '(-1 0))
	(list 'filter-control-order filter-control-order 20 '(-10 -1 0))
	(list 'max-transform-peaks max-transform-peaks 100 '(-1))
	(list 'max-regions max-regions 16 '(-1 -123))
	(list 'view-files-sort view-files-sort 0 '(-1 123))
	(list 'reverb-control-length reverb-control-length 1.0 '(-1.0))
	(list 'show-axes show-axes 1 '(-1 123))
	(list 'sinc-width sinc-width 10 '(-10))
	(list 'spectrum-end spectrum-end 1.0 '(-1.0))
	(list 'spectro-hop spectro-hop 4 '(-10 -1 0))
	(list 'spectrum-start spectrum-start 0.0 '(-1.0))
	(list 'speed-control speed-control 1.0 '(0.0))
	(list 'speed-control-bounds speed-control-bounds (list 0.05 20.0) (list #f (list 0.0) (list 1.0 0.0) 2.0))
	(list 'speed-control-style speed-control-style 0 '(-1 10))
	(list 'transform-type transform-type fourier-transform (list (integer->transform -1) (integer->transform 123)))
	(list 'wavelet-type wavelet-type 0 '(-1 123))
	(list 'wavo-hop wavo-hop 1 '(0 -123))
	(list 'wavo-trace wavo-trace 1 '(0 -123))
	(list 'x-axis-style x-axis-style 0 '(-1 123))
	(list 'zoom-focus-style zoom-focus-style 2 '(-1 123)))))
    
    (set! (window-width) 300)
    (set! (window-height) 300)
    (if (not (equal? (window-width) 300))
	(snd-display #__line__ ";window width: ~A /= 300?" (window-width)))
    (if (not (equal? (window-height) 300))
	(snd-display #__line__ ";window height: ~A /= 300?" (window-height)))
    (set! (window-x) 123)
    (set! (window-y) 321)
    (if (not (equal? (window-x) 123))
	(snd-display #__line__ ";window x: ~A /= 123?" (window-x)))
    (if (not (equal? (window-y) 321))
	(snd-display #__line__ ";window y: ~A /= 321?" (window-y)))
    (set! (window-y) 10) ; get it back out of harm's way
    (set! (color-scale) 100.0)
    (if (fneq (color-scale) 100.0) (snd-display #__line__ ";color-scale to 100: ~A" (color-scale)))
    
    (if (procedure? (search-procedure))
	(snd-display #__line__ ";global search procedure: ~A?" (search-procedure)))
    (set! (search-procedure) (lambda (y) (> y .1)))
    (if (not (procedure? (search-procedure)))
	(snd-display #__line__ ";set global search procedure: ~A?" (search-procedure)))
    (if (not ((search-procedure) .2))
	(snd-display #__line__ ";search > .1 .2"))
    (if ((search-procedure) .02)
	(snd-display #__line__ ";search > .1 .02"))
    (set! (search-procedure) (lambda (y) (< y 0.0)))
    (if ((search-procedure) .02)
	(snd-display #__line__ ";search < 0.0 .02"))
    (set! (search-procedure) #f)
    (if (procedure? (search-procedure))
	(snd-display #__line__ ";global search procedure after reset: ~A?" (search-procedure)))
    (set! (search-procedure) (lambda (y) (> y .1)))
    (if (not (procedure? (search-procedure)))
	(snd-display #__line__ ";set global search procedure: ~A?" (search-procedure)))
    
    (set! (enved-filter-order) 5)
    (if (not (= (enved-filter-order) 6)) (snd-display #__line__ ";set enved-filter-order 5: ~A" (enved-filter-order)))
    (if with-gui
	(begin
	  (set! (enved-envelope) 'zero_to_one) ; funcs.cl above
	  (if (not (feql (enved-envelope) zero_to_one)) (snd-display #__line__ ";set symbol enved-envelope: ~A ~A" (enved-envelope) zero_to_one))
	  (set! (enved-envelope) "mod_down")
	  (if (not (feql (enved-envelope) mod_down)) (snd-display #__line__ ";set string enved-envelope: ~A ~A" (enved-envelope) mod_down))))
    
    (close-sound ind) 
    (dismiss-all-dialogs)
    
    (let ((undef '())
	  (names (list '*snd-opened-sound* 'abort 'add-clm-field 'add-colormap 
		       'add-directory-to-view-files-list 'add-file-filter 'add-file-sorter 'add-file-to-view-files-list 'add-mark
		       'add-player 'add-sound-file-extension 'add-source-file-extension 'add-to-main-menu 'add-to-menu
		       'add-transform 'add-watcher 'after-apply-controls-hook 'after-edit-hook 'after-graph-hook 'after-lisp-graph-hook
		       'after-open-hook 'after-save-as-hook 'after-save-state-hook 'after-transform-hook 'all-pass
		       'all-pass? 'amp-control 'amp-control-bounds 'amplitude-modulate 'analyse-ladspa
		       'apply-controls 'apply-ladspa 'array->file 'array-interp 'as-one-edit
		       'ask-before-overwrite 'asymmetric-fm 'asymmetric-fm? 'audio-input-device 'audio-output-device
		       'auto-resize 'auto-update 'auto-update-interval 'autocorrelate 'autocorrelation
		       'moving-average 'moving-average? 'axis-color 'axis-info 'axis-label-font 'axis-numbers-font
		       'bad-header-hook 'bartlett-window 'bartlett-hann-window 'basic-color 'beats-per-measure 'beats-per-minute
		       'before-close-hook 'before-exit-hook 'before-save-as-hook 'before-save-state-hook 'before-transform-hook
		       'bind-key 'blackman2-window 'blackman3-window 'blackman4-window 
		       'blackman5-window 'blackman6-window 'blackman7-window 'blackman8-window 'blackman9-window 'blackman10-window 
		       'bohman-window 'bold-peaks-font 'bomb 'c-g! 'c-g? 'cauchy-window 'mlt-sine-window
		       'cepstrum 'change-samples-with-origin 'channel->vct 'channel-amp-envs 'channel-data
		       'channel-properties 'channel-property 'channel-style 'channel-widgets 'channels 'channels-combined
		       'channels-separate 'channels-superimposed 'chans 'clear-array 'clear-listener
		       'clear-minibuffer 'clear-sincs 'clip-hook 'clipping 'clm-channel 'clm-print
		       'clm-table-size 'clm-default-frequency 'close-hook 'close-sound 'color->list
		       'color-cutoff 'color-orientation-dialog 'color-hook 'color-inverted 'color-scale
		       'color? 'colormap 'colormap-name 'colormap-ref 'colormap-size
		       'colormap? 'comb 'comb? 'comment 'connes-window
		       'continue-frame->file 'continue-sample->file 'contrast-control 'contrast-control-amp 'contrast-control-bounds
		       'contrast-control? 'contrast-enhancement 'controls->channel 'convolution 'convolve
		       'convolve-files 'convolve-selection-with 'convolve-with 'convolve? 'copy-context
		       'copy-sampler 'count-matches 'current-edit-position
		       'current-font 'cursor 'cursor-color 'cursor-context 'cursor-cross
		       'cursor-in-middle 'cursor-in-view 'cursor-line 'cursor-location-offset 'cursor-on-left
		       'cursor-on-right 'cursor-position 'cursor-size 'cursor-style 'cursor-update-interval
		       'dac-combines-channels 'dac-hook 'dac-size 'data-color 'data-format
		       'data-location 'data-size 'db->linear 'default-output-chans 'default-output-data-format
		       'default-output-header-type 'default-output-srate 'define-envelope 'degrees->radians 'delay
		       'delay-tick 'delay? 'delete-colormap 'delete-file-filter 'delete-file-sorter
		       'delete-mark 'delete-marks 'delete-sample 'delete-samples
		       'delete-selection 'delete-transform 'delete-watcher 'dialog-widgets 'disk-kspace
		       'display-edits 'doit-again-button-color 'doit-button-color 'dolph-chebyshev-window 'dont-normalize
		       'dot-product 'dot-size 'draw-axes 'draw-dot 'draw-dots
		       'draw-line 'draw-lines 'draw-mark-hook 'draw-mix-hook 'draw-string 'drop-hook
		       'during-open-hook 'edit-fragment 'edit-header-dialog 'edit-hook 'edit-list->function
		       'edit-position 'edit-tree 'edits 'edot-product 'env
		       'env-channel 'env-channel-with-base 'env-interp 'env-selection 'env-sound
		       'env? 'enved-add-point 'enved-amplitude 'enved-base 'enved-clip?
		       'enved-delete-point 'enved-dialog 'enved-envelope 'enved-filter 'enved-filter-order
		       'enved-hook 'enved-in-dB 'enved-move-point 'enved-power 'enved-spectrum
		       'enved-srate 'enved-style 'enved-target 'enved-wave? 'enved-waveform-color
		       'envelope-exponential 'envelope-linear 'eps-bottom-margin 'eps-file
		       'eps-left-margin 'eps-size 'exit 'exit-hook
		       'expand-control 'expand-control-bounds 'expand-control-hop 'expand-control-jitter 'expand-control-length
		       'expand-control-ramp 'expand-control? 'exponential-window 'fft 'fft-log-frequency
		       'fft-log-magnitude 'fft-window 'fft-window-alpha 'fft-window-beta 'fft-with-phases 'file->array
		       'file->frame 'file->frame? 'file->sample 'file->sample? 'file->string
		       'file-name 'file-write-date 'fill-polygon 'fill-rectangle 'filter
		       'filtered-comb 'filtered-comb?
		       'filter-channel 'filter-control-coeffs 'filter-control-envelope 'filter-control-in-dB 'filter-control-in-hz
		       'filter-control-order 'filter-control-waveform-color 'filter-control? 'filter-selection 'filter-sound
		       'filter? 'find-channel 'find-dialog 'find-mark 'find-sound
		       'finish-progress-report 'fir-filter 'fir-filter? 'flat-top-window 'focus-widget 'foreground-color
		       'forget-region 'formant 'formant-bank 'formant? 'firmant 'firmant? 
		       'fourier-transform
		       'frame 'frame* 'frame+ 'frame->file 'frame->file?
		       'frame->frame 'frame->list 'frame->sample 'frame-ref 'frame-set!
		       'frame? 'frames 'free-player
		       'free-sampler 'gaussian-window 'gc-off 'gc-on
		       'gl-graph->ps 'glSpectrogram 'goto-listener-end 'granulate 'granulate?
		       'graph 'graph->ps 'graph-as-sonogram 'graph-as-spectrogram 'graph-as-wavogram
		       'graph-color 'graph-cursor 'graph-data 'graph-dots 'graph-dots-and-lines
		       'graph-filled 'graph-hook 'graph-lines 'graph-lollipops 'graph-once
		       'graph-style 'graphs-horizontal 'grid-density 'haar-transform 'hamming-window
		       'hann-poisson-window 'hann-window 'header-type 'help-button-color 'help-dialog
		       'help-hook 'hide-widget 'highlight-color 'html-dir 'html-program
		       'hz->radians 'iir-filter 'iir-filter? 'in 'in-any
		       'ina 'inb 'info-dialog 'init-ladspa 'initial-graph-hook
		       'insert-file-dialog 'insert-region 'insert-sample 'insert-samples 'insert-samples-with-origin
		       'insert-selection 'insert-silence 'insert-sound 'just-sounds 'kaiser-window
		       'key 'key-binding 'key-press-hook 'keyboard-no-action 'ladspa-activate
		       'ladspa-cleanup 'ladspa-connect-port 'ladspa-deactivate 'ladspa-descriptor 'ladspa-dir 'peak-env-dir
		       'ladspa-instantiate 'ladspa-run 'ladspa-run-adding 'ladspa-set-run-adding-gain 'left-sample
		       'linear->db 'lisp-graph 'lisp-graph-hook 'lisp-graph-style 'lisp-graph?
		       'list->vct 'list-ladspa 'listener-click-hook 'listener-color 'listener-font
		       'listener-prompt 'listener-selection 'listener-text-color 'little-endian? 'locsig
		       'locsig-ref 'locsig-reverb-ref 'locsig-reverb-set! 'locsig-set! 'locsig-type
		       'locsig? 'log-freq-start 'main-menu 'main-widgets 'make-all-pass
		       'make-asymmetric-fm 'make-moving-average 'make-bezier 'make-color 'make-comb 'make-filtered-comb
		       'make-convolve 'make-delay 'make-env 'make-fft-window 'make-file->frame
		       'make-file->sample 'make-filter 'make-fir-coeffs 'make-fir-filter 'make-formant 'make-firmant
		       'make-frame 'make-frame->file 'make-granulate 'make-graph-data 'make-iir-filter
		       'make-locsig 'make-mix-sampler 'make-mixer 'make-move-sound 'make-notch 'make-one-pole
		       'make-one-zero 'make-oscil 'make-phase-vocoder 'make-player 'make-polyshape 'make-polywave
		       'make-pulse-train 'make-rand 'make-rand-interp 'make-readin
		       'make-region 'make-region-sampler 'make-sample->file 'make-sampler 'make-sawtooth-wave
		       'make-scalar-mixer 'make-nrxysin 'make-nrxycos 'make-snd->sample 'make-sound-data 'make-square-wave
		       'make-src 'make-ssb-am 'make-ncos 'make-nsin 'make-table-lookup
		       'make-triangle-wave 'make-two-pole 'make-two-zero
		       'make-variable-graph 'make-vct 'make-wave-train 
		       'map-chan 'map-channel 'mark-click-hook 'mark-color 'mark-context
		       'mark-drag-hook 'mark-drag-triangle-hook 'mark-home 'mark-hook 'mark-name 'mark-properties 'mark-property
		       'mark-sample 'mark-sync 'mark-sync-max 'mark-tag-height 'mark-tag-width
		       'mark? 'marks 'max-regions 'max-transform-peaks 'max-virtual-ptrees 'maxamp
		       'maxamp-position 'menu-widgets 'min-dB 'minibuffer-history-length 'mix
		       'mix-amp 'mix-amp-env 'mix-click-hook 'mix-color
		       'mix-dialog-mix 'mix-drag-hook 'mix-file-dialog 'mix-length 'mix-home
		       'mix-name 'mix-position 'mix-properties 'mix-property 'mix-region 'mix-release-hook 'mix-sync 'mix-sync-max
		       'mix-sampler? 'mix-selection 'mix-speed 'mix-tag-height
		       'mix-tag-width 'mix-tag-y
		       'mix-vct 'mix-waveform-height 'mix? 'mixer 'mixer*
		       'mixer+ 'mixer-ref 'mixer-set! 'mixer?
		       'mixes 'mouse-click-hook 'mouse-drag-hook 'mouse-enter-graph-hook
		       'mouse-enter-label-hook 'mouse-enter-listener-hook 'mouse-enter-text-hook 'mouse-leave-graph-hook 'mouse-leave-label-hook
		       'mouse-leave-listener-hook 'mouse-leave-text-hook 'mouse-press-hook 'move-locsig 'move-sound 'move-sound? 'multiply-arrays
		       'mus-aifc 'mus-aiff 'mus-alaw 'mus-alsa-buffer-size 'mus-alsa-buffers
		       'mus-alsa-capture-device 'mus-alsa-device 'mus-alsa-playback-device 'mus-alsa-squelch-warning 'mus-apply
		       'mus-array-print-length 'mus-float-equal-fudge-factor 
		       
		       'mus-b24int 'mus-bdouble 'mus-bdouble-unscaled
		       'mus-bfloat 'mus-bfloat-unscaled 'mus-bicsf 'mus-bint 'mus-bintn
		       'mus-bshort 'mus-byte 'mus-bytes-per-sample 'mus-caff 'mus-channel 'mus-channels
		       'mus-chebyshev-first-kind 'mus-chebyshev-second-kind 'mus-clipping 'mus-close
		       'mus-data 'mus-data-format->string 'mus-data-format-name 'mus-describe 'mus-error-hook
		       'mus-error-type->string 'mus-expand-filename 'mus-feedback 'mus-feedforward 'mus-fft
		       'mus-file-buffer-size 'mus-file-clipping 'mus-file-name 'mus-file-prescaler
		       'mus-frequency 'mus-generator? 'mus-header-raw-defaults 'mus-header-type->string 'mus-header-type-name
		       'mus-hop 'mus-increment 'mus-input? 'mus-interp-all-pass 'mus-interp-bezier
		       'mus-interp-hermite 'mus-interp-lagrange 'mus-interp-linear 'mus-interp-none 'mus-interp-sinusoidal
		       'mus-interp-type 'mus-interpolate 'mus-ircam 'mus-l24int 'mus-ldouble
		       'mus-ldouble-unscaled 'mus-length 'mus-lfloat 'mus-lfloat-unscaled 'mus-lint
		       'mus-lintn 'mus-location 'mus-lshort 'mus-max-malloc 'mus-max-table-size
		       'mus-mix 'mus-mulaw 'mus-name 
		       'mus-next 'mus-nist 'mus-offset 'mus-order 'mus-oss-set-buffers
		       'mus-out-format 'mus-output? 'mus-phase 'mus-prescaler 'mus-ramp
		       'mus-rand-seed 'mus-random 'mus-raw 'mus-reset 'mus-riff
		       'mus-run 'mus-scaler 'mus-set-formant-radius-and-frequency 'mus-sound-chans 'mus-sound-close-input
		       'mus-sound-close-output 'mus-sound-comment 'mus-sound-data-format 'mus-sound-data-location 'mus-sound-datum-size
		       'mus-sound-duration 'mus-sound-forget 'mus-sound-frames 'mus-sound-header-type 'mus-sound-length
		       'mus-sound-loop-info 'mus-sound-mark-info 'mus-sound-maxamp 'mus-sound-maxamp-exists? 'mus-sound-open-input 'mus-sound-open-output
		       'mus-sound-prune 'mus-sound-read 'mus-sound-reopen-output 'mus-sound-report-cache 'mus-sound-samples
		       'mus-sound-seek-frame 'mus-sound-srate 'mus-sound-type-specifier 'mus-sound-write 'mus-sound-write-date
		       'mus-soundfont 'mus-srate 'mus-svx 'mus-ubshort
		       'mus-ubyte 'mus-ulshort 'mus-unknown 'mus-unsupported 'mus-voc
		       'mus-width 'mus-xcoeff 'mus-xcoeffs 'mus-ycoeff 'mus-ycoeffs
		       'name-click-hook 'new-sound 'new-sound-dialog 'new-sound-hook 'new-widget-hook
		       'next-sample 'normalize-by-channel 'normalize-by-sound 'normalize-channel 'normalize-globally
		       'notch 'notch? 'one-pole 'one-pole? 'one-zero
		       'one-zero? 'open-file-dialog 'open-file-dialog-directory 'open-hook 'open-raw-sound 'open-raw-sound-hook
		       'open-sound 'optimization 'optimization-hook 
		       'orientation-hook 'oscil 'oscil? 'out-any 'outa
		       'outb 'outc 'outd 'output-comment-hook 'output-name-hook 
		       'override-samples-with-origin 'pad-channel 'partials->polynomial 'partials->wave
		       'parzen-window 'pausing 'peak-env-hook 'peaks 'peaks-font
		       'phase-partials->wave 'phase-vocoder 'phase-vocoder-amp-increments 'phase-vocoder-amps 'phase-vocoder-freqs
		       'phase-vocoder-phase-increments 'phase-vocoder-phases 'phase-vocoder? 'play
		       'play-hook 'player-home 'player? 'players
		       'playing 'poisson-window 'polar->rectangular 'polynomial 'polyshape 'polywave
		       'polyshape? 'polywave? 'position->x 'position->y 'position-color 'preferences-dialog
		       'previous-sample 'print-dialog 'print-hook 'print-length 'progress-report
		       'prompt-in-minibuffer 'ptree-channel 'pulse-train
		       'pulse-train? 'pushed-button-color 'quit-button-color 'radians->degrees 'radians->hz
		       'ramp-channel 'rand 'rand-interp 'rand-interp? 'rand?
		       'read-hook 'read-mix-sample 'read-only 'read-region-sample
		       'read-sample 'readin 'readin? 
		       'rectangular->magnitudes 'rectangular->polar 'rectangular-window 'redo 'redo-edit
		       'region->vct 'region-chans 'region-home 'region-frames 'region-graph-style 'region-maxamp
		       'region-maxamp-position 'region-position 'region-sample 'region-sampler? 'region-srate
		       'region? 'regions 'remove-from-menu 'report-in-minibuffer 'reset-button-color
		       'reset-controls 'reset-listener-cursor 'restore-controls 'restore-region
		       'reverb-control-decay 'reverb-control-feedback 'reverb-control-length 'reverb-control-length-bounds 'reverb-control-lowpass
		       'reverb-control-scale 'reverb-control-scale-bounds 'reverb-control? 'reverse-channel 'reverse-selection
		       'reverse-sound 'revert-sound 'riemann-window 'right-sample 'ring-modulate
		       'run 'rv2-window 'rv3-window 'rv4-window 
		       'samaraki-window 'sample 'sample->file
		       'sample->file? 'sample->frame 'sampler-at-end? 'sampler-home 'sampler-position
		       'sampler? 'samples 'samples->seconds 'sash-color
		       'save-controls 'save-dir 'save-edit-history 'save-envelopes 'save-hook
		       'save-listener 'save-macros 'save-marks 'save-region 'save-region-dialog
		       'save-selection 'save-selection-dialog 'save-sound 'save-sound-as 'save-sound-dialog
		       'save-state 'save-state-file 'save-state-hook 'sawtooth-wave 'sawtooth-wave?
		       'scale-by 'scale-channel 'scale-selection-by 'scale-selection-to 'scale-to
		       'scan-chan 'scan-channel 'script-arg 'script-args 'search-procedure
		       'seconds->samples 'select-all 'select-channel 'select-channel-hook 'select-sound
		       'select-sound-hook 'selected-channel 'selected-data-color 'selected-graph-color 'selected-sound
		       'selection-chans 'selection-color 'selection-context 'selection-creates-region
		       'selection-frames 'selection-maxamp 'selection-maxamp-position 'selection-member? 'selection-position
		       'selection-srate 'selection?
		       'short-file-name 'show-all-axes 'show-all-axes-unlabelled 'show-bare-x-axis
		       'show-axes 'show-controls 'show-grid 'show-indices
		       'show-listener 'show-marks 'show-mix-waveforms 'show-no-axes 'show-selection-transform
		       'show-sonogram-cursor 'show-transform-peaks 'show-widget 'show-x-axis 'show-x-axis-unlabelled
		       'show-y-zero 'sinc-width 'nrxysin 'nrxysin? 'nrxycos 'nrxycos?
		       'smooth-channel 'smooth-selection 'smooth-sound 'snd->sample 'snd->sample?
		       'snd-error 'snd-error-hook 'snd-gcs 'snd-help 'snd-font 'snd-color
		       'snd-print 'snd-simulate-keystroke 'snd-spectrum 'snd-tempnam 'snd-url
		       'snd-urls 'snd-version 'snd-warning 'snd-warning-hook 'sound-data->sound-data
		       'sound-data->vct 'sound-data-chans 'sound-data-length 'sound-data-maxamp 'sound-data-ref 'sound-data-peak
		       'sound-data-set! 'sound-data-scale! 'sound-data-fill! 'sound-data? 
		       'sound-data-multiply! 'sound-data-add! 'sound-data-offset! 'sound-data* 'sound-data+ 'sound-data-copy 'sound-data-reverse!
		       'sound-file-extensions 'sound-file? 'sound-files-in-directory
		       'sound-loop-info 'sound-properties 'sound-property 'sound-widgets 'sound? 'soundfont-info
		       'sounds 'spectrum-end 'spectro-hop 'spectrum-start 'spectro-x-angle
		       'spectro-x-scale 'spectro-y-angle 'spectro-y-scale 'spectro-z-angle 'spectro-z-scale
		       'spectrum 'speed-control 'speed-control-as-float 'speed-control-as-ratio 'speed-control-as-semitone
		       'speed-control-bounds 'speed-control-style 'speed-control-tones 'square-wave 'square-wave?
		       'squelch-update 'srate 'src 'src-channel 'src-selection
		       'src-sound 'src? 'ssb-am 'ssb-am? 'start-hook
		       'start-playing 'start-playing-hook 'start-playing-selection-hook 'start-progress-report 'stop-dac-hook
		       'stop-player 'stop-playing 'stop-playing-hook 'stop-playing-selection-hook 'ncos
		       'ncos? 'nsin 'nsin? 'swap-channels 'sync
		       'sync-max 'syncd-marks 'table-lookup 'table-lookup? 'tap
		       'temp-dir 'text-focus-color 'time-graph 'time-graph-hook 'time-graph-style
		       'time-graph-type 'time-graph? 'tiny-font 
		       'tracking-cursor-style 'transform->vct
		       'transform-dialog 'transform-frames 'transform-graph 'transform-graph-style 'transform-graph-type
		       'transform-graph? 'transform-normalization 'transform-sample 'transform-size 'transform-type
		       'transform? 'trap-segfault 'triangle-wave 'triangle-wave? 'tukey-window
		       'two-pole 'two-pole? 'two-zero 'two-zero? 'ultraspherical-window
		       'unbind-key  'undo 'undo-edit 'undo-hook 'update-hook 'update-lisp-graph
		       'update-sound 'update-time-graph 'update-transform-graph 'variable-graph? 'vct
		       'vct* 'vct+ 'vct->channel 'vct->list 'vct->sound-data
		       'vct->string 'vct->vector 'vct-add! 'vct-copy
		       'vct-fill! 'vct-length 'vct-map! 'vct-move!
		       'vct-multiply! 'vct-offset! 'vct-peak 'vct-ref 'vct-reverse!
		       'vct-scale! 'vct-set! 'vct-subseq 'vct-subtract! 'vct?
		       'vector->vct 'view-files-amp 'view-files-amp-env
		       'view-files-dialog 'view-files-files 'view-files-select-hook 'view-files-selected-files 'view-files-sort
		       'view-files-speed 'view-files-speed-style 'view-mixes-dialog 'view-regions-dialog 'view-sound
		       'walsh-transform
		       'wave-train 'wave-train? 'wavelet-transform 'wavelet-type
		       'wavo-hop 'wavo-trace 'welch-window 'widget-position
		       'widget-size 'widget-text 'window-height
		       'window-width 'window-x 'window-y 'with-background-processes 'with-file-monitor 'with-gl
		       'with-mix-tags 'with-relative-panes 'with-tracking-cursor 'with-verbose-cursor 'with-inset-graph 'with-pointer-focus
		       'x->position 'x-axis-as-clock 'x-axis-as-percentage 'x-axis-in-beats 'x-axis-in-measures
		       'x-axis-in-samples 'x-axis-in-seconds 'x-axis-label 'x-axis-style 'x-bounds
		       'x-position-slider 'x-zoom-slider 'xramp-channel 'y->position 'y-axis-label
		       'y-bounds 'y-position-slider 'y-zoom-slider 'zero-pad 'zoom-color
		       'zoom-focus-active 'zoom-focus-left 'zoom-focus-middle 'zoom-focus-right 'zoom-focus-style)))
      (for-each
       (lambda (n)
	 (if (not (defined? n))
	     (set! undef (cons n undef))))
       names)
      (if (not (null? undef))
	  (snd-display #__line__ ";undefined: ~A" undef)))
    
    ))

;;; ---------------- test 4: sndlib ----------------

(define buffer-menu #f) ; needed by examp.scm

(if (or (not (provided? 'snd-examp.scm))
	(and (defined? 'ramp) ; why this? protection against funcs?
	     (list? ramp)))
    (load "examp.scm"))

(if (not (provided? 'snd-mix.scm)) (load "mix.scm"))
(if (not (provided? 'snd-env.scm)) (load "env.scm"))

(define (play-sound-1 file)
  "play test func"
  (let* ((sound-fd (mus-sound-open-input file))
	 (chans (mus-sound-chans file))
	 (frames (mus-sound-frames file))
	 (bufsize 256)
	 (data (make-sound-data chans bufsize))
	 (bytes (* bufsize chans 2)))
    (mus-sound-read sound-fd 0 (- bufsize 1) chans data)
    (catch #t
	   (lambda ()
	     (let ((audio-fd (mus-audio-open-output 0 (mus-sound-srate file) chans mus-lshort bytes)))
	       (if (= audio-fd -1)
		   (set! audio-fd (mus-audio-open-output 0 (mus-sound-srate file) chans mus-bshort bytes)))
	       (if (= audio-fd -1)
		   (snd-display #__line__ ";can't play ~A" file)
		   (begin
		     (catch #t
			    (lambda ()
			      (do ((i 0 (+ i bufsize)))
				  ((>= i frames))
				(mus-audio-write audio-fd data bufsize)
				(mus-sound-read sound-fd 0 (- bufsize 1) chans data)))
			    (lambda args (snd-display #__line__ ";play-sound-1: can play audio: ~A" args)))
		     (mus-audio-close audio-fd)))))
	   (lambda args (snd-display #__line__ ";play-sound-1: can't open audio: ~A" args)))
    (mus-sound-close-input sound-fd)))

(definstrument (out-samps beg chan data)
  (let ((len (vct-length data)))
    (run
     (do ((i 0 (+ 1 i)))
	 ((= i len))
       (out-any (+ beg i) (vct-ref data i) chan)))))

(definstrument (out-samps-invert beg chan data)
  (let ((len (vct-length data)))
    (run
     (do ((i 0 (+ 1 i)))
	 ((= i len))
       (out-any (+ beg i) (- (vct-ref data i)) chan)))))

(define (snd_test_4)
  
  (define (frame->byte file frame)
    (+ (mus-sound-data-location file)
       (* (mus-sound-chans file)
	  (mus-sound-datum-size file)
	  frame)))
  
  (define (show-input-1 . arg)
    ;; from rtio.scm
    (define (card+device card device)
      (logior (ash card 16) device))
    (let* ((our-short (if (little-endian?) mus-lshort mus-bshort))
	   (our-srate 22050)
	   (our-dac-buffer-size-in-bytes 512)
	   (our-dac-buffer-size-in-shorts 256)
	   (our-chans 1)
	   (our-chan 0)
	   (our-default-card-number 0)
	   (in-sys (if (not (null? arg)) 
		       (car arg) 
		       our-default-card-number))
	   (in-port (catch 'mus-error
			   (lambda ()
			     (mus-audio-open-input 
			      (card+device in-sys 0) 
			      our-srate our-chans our-short our-dac-buffer-size-in-bytes))
			   (lambda args -1)))
	   (data (make-sound-data our-chans our-dac-buffer-size-in-shorts))
	   (vobj (make-vct our-dac-buffer-size-in-shorts)))
      (if (= in-port -1)
	  (snd-display #__line__ ";can't open audio input port!")
	  (begin
	    (do ((i 0 (+ 1 i)))
		((= i 10))
	      (mus-audio-read in-port data our-dac-buffer-size-in-shorts)
	      (graph (sound-data->vct data our-chan vobj)))
	    (mus-audio-close in-port)))))
  
  (begin
    
    (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
      (log-mem clmtest)
      (clear-listener)
      (let ((chns (mus-sound-chans "oboe.snd"))
	    (dl (mus-sound-data-location "oboe.snd"))
	    (fr (mus-sound-frames "oboe.snd"))
	    (smps (mus-sound-samples "oboe.snd"))
	    (len (mus-sound-length "oboe.snd"))
	    (size (mus-sound-datum-size "oboe.snd"))
	    (com (mus-sound-comment "oboe.snd"))
	    (sr (mus-sound-srate "oboe.snd"))
	    (m1 (mus-sound-maxamp-exists? "oboe.snd"))
	    (mal (mus-sound-maxamp "oboe.snd"))
	    (mz (mus-sound-maxamp "z.snd"))
	    (bytes (mus-bytes-per-sample (mus-sound-data-format "oboe.snd"))))
	(if (or (not (= (car mz) 0))
		(fneq (cadr mz) 0.0))
	    (snd-display #__line__ ";mus-sound-maxamp z.snd: ~A (~A ~A)" mz (not (= (car mz) 0)) (fneq (cadr mz) 0.0)))
	(let ((formats (list mus-bshort mus-lshort mus-mulaw mus-alaw mus-byte mus-ubyte mus-bfloat mus-lfloat
			     mus-bint mus-lint mus-bintn mus-lintn mus-b24int mus-l24int mus-bdouble mus-ldouble
			     mus-ubshort mus-ulshort mus-bdouble-unscaled mus-ldouble-unscaled mus-bfloat-unscaled 
			     mus-lfloat-unscaled))
	      (sizes (list 2 2 1 1 1 1 4 4 
			   4 4 4 4 3 3 8 8
			   2 2 8 8 4
			   4)))
	  (for-each
	   (lambda (frm siz)
	     (if (not (= (mus-bytes-per-sample frm) siz))
		 (snd-display #__line__ ";mus-bytes-per-sample ~A: ~A" (mus-data-format-name frm) siz)))
	   formats
	   sizes))
	(if (not (string=? (mus-data-format->string mus-bshort) "mus-bshort"))
	    (snd-display #__line__ ";mus-data-format->string: ~A" (mus-data-format->string mus-bshort)))
	(if (not (string=? (mus-header-type->string mus-aifc) "mus-aifc"))
	    (snd-display #__line__ ";mus-header-type->string: ~A" (mus-header-type->string mus-aifc)))
	(mus-sound-report-cache "hiho.tmp")
	(if (defined? 'read-line)
	    (let ((p (open-input-file "hiho.tmp")))
	      (if (not p)
		  (snd-display #__line__ ";mus-sound-report-cache->hiho.tmp failed?")
		  (let ((line (read-line p)))
		    (if (or (not (string? line))
			    (and (not (string=? line "sound table:"))
				 (not (string=? line (string-append "sound table:" (string #\newline))))))
			(snd-display #__line__ ";print-cache 1: ~A?" line))
		    (close-input-port p)
		    (delete-file "hiho.tmp")))))
	(if (< (string-length (mus-audio-describe)) 10)
	    (snd-display #__line__ ";mus-audio-describe: ~A" (mus-audio-describe)))
	(if (not (= chns 1)) (snd-display #__line__ ";oboe: mus-sound-chans ~D?" chns))
	(if (not (= dl 28)) (snd-display #__line__ ";oboe: mus-sound-data-location ~D (~A)?" dl (= dl 28)))
	(if (not (= fr 50828)) (snd-display #__line__ ";oboe: mus-sound-frames ~D?" fr))
	(if (not (= smps 50828)) (snd-display #__line__ ";oboe: mus-sound-samples ~D?" smps))
	(if (not (= len (+ 28 (* 2 50828)))) (snd-display #__line__ ";oboe: mus-sound-length ~D?" len))
	(if (not (= size 2)) (snd-display #__line__ ";oboe: mus-sound-datum-size ~D?" size))
	(if (not (= bytes 2)) (snd-display #__line__ ";oboe: sound-bytes ~D?" bytes))
	(if (not (= sr 22050)) (snd-display #__line__ ";oboe: mus-sound-srate ~D?" sr))
	(if (and m1 (= clmtest 0)) (snd-display #__line__ ";oboe: mus-sound-maxamp-exists before maxamp: ~A" m1))
	(if (not (mus-sound-maxamp-exists? "oboe.snd")) 
	    (snd-display #__line__ ";oboe: not mus-sound-maxamp-exists after maxamp: ~A" (mus-sound-maxamp-exists? "oboe.snd")))
	
	(if (= clmtest 0)
	    (let ((vals (mus-header-raw-defaults)))
	      (if (or (not (list? vals))
		      (not (= (length vals) 3)))
		  (snd-display #__line__ ";mus-header-raw-defaults: ~A" vals)
		  (let ((sr (car vals))
			(chns (cadr vals))
			(frm (caddr vals)))
		    (if (not (= sr 44100)) (snd-display #__line__ ";mus-header-raw-defaults srate: ~A" sr))
		    (if (not (= chns 2)) (snd-display #__line__ ";mus-header-raw-defaults chns: ~A" chns))
		    (if (not (= frm mus-bshort)) (snd-display #__line__ ";mus-header-raw-defaults format: ~A: ~A" frm (mus-data-format-name frm)))))))
	(set! (mus-header-raw-defaults) (list 12345 3 mus-bdouble-unscaled))
	(let ((vals (mus-header-raw-defaults)))
	  (if (or (not (list? vals))
		  (not (= (length vals) 3)))
	      (snd-display #__line__ ";set mus-header-raw-defaults: ~A" vals)
	      (let ((sr (car vals))
		    (chns (cadr vals))
		    (frm (caddr vals)))
		(if (not (= sr 12345)) (snd-display #__line__ ";set mus-header-raw-defaults srate: ~A" sr))
		(if (not (= chns 3)) (snd-display #__line__ ";set mus-header-raw-defaults chns: ~A" chns))
		(if (not (= frm mus-bdouble-unscaled)) (snd-display #__line__ ";set mus-header-raw-defaults format: ~A: ~A" frm (mus-data-format-name frm))))))
	(set! (mus-header-raw-defaults) (list 44100 2 mus-bshort))
	
	(let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "oboe.snd")))))
	  (if (not (string=? str "15-Oct 04:34 PDT"))
	      (snd-display #__line__ ";mus-sound-write-date oboe.snd: ~A?" str)))
	(let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "pistol.snd")))))
	  (if (not (string-=? str "01-Jul 13:06 PDT"))
	      (snd-display #__line__ ";mus-sound-write-date pistol.snd: ~A?" str)))
	
	(let ((index (open-sound "oboe.snd"))
	      (long-file-name (let ((name "test"))
				(do ((i 0 (+ 1 i)))
				    ((= i 10)) ; 40 is about the limit in Linux (256 char limit here from OS, not Snd)
				  (set! name (string-append name "-test")))
				(string-append name ".snd"))))
	  (if (variable-graph? index) (snd-display #__line__ ";variable-graph thinks anything is a graph..."))
	  (if (player? index) (snd-display #__line__ ";player? thinks anything is a player..."))
	  (if (not (sound? index)) (snd-display #__line__ ";~A is not a sound?" index))
	  (if (sound? #f) (snd-display #__line__ ";sound? #f -> #t?"))
	  (if (sound? #t) (snd-display #__line__ ";sound? #t -> #t?"))
	  (save-sound-as long-file-name index)
	  (close-sound index)
	  (set! index (open-sound long-file-name))
	  (if (not (sound? index)) (snd-display #__line__ ";can't find test...snd"))
	  (if (or (not (>= (string-length (file-name index)) (string-length long-file-name)))
		  (not (>= (string-length (short-file-name index)) (string-length long-file-name))))
	      (snd-display #__line__ ";file-name lengths: ~A ~A ~A"
			   (string-length (file-name index))
			   (string-length (short-file-name index))
			   (string-length long-file-name)))
	  (close-sound index)
	  (mus-sound-forget long-file-name)
	  (delete-file long-file-name))
	
	(let* ((fsnd (string-append sf-dir "forest.aiff")))
	  (if (file-exists? fsnd)
	      (begin
		(system (format #f "cp ~A fmv.snd" fsnd))
		(let ((index (open-sound "fmv.snd")))
		  (if (not (equal? (sound-loop-info index) (mus-sound-loop-info fsnd)))
		      (snd-display #__line__ ";loop-info: ~A ~A" (sound-loop-info index) (mus-sound-loop-info fsnd)))
		  (set! (sound-loop-info index) (list 12000 14000 1 2 3 4))
		  (if (not (equal? (sound-loop-info index) (list 12000 14000 1 2 3 4 1 1)))
		      (snd-display #__line__ ";set loop-info: ~A" (sound-loop-info index)))
		  (save-sound-as "fmv1.snd" index mus-aifc)
		  (close-sound index)
		  (if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 12000 14000 1 2 3 4 1 1)))
		      (snd-display #__line__ ";saved loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))))
	  (let ((index (open-sound "oboe.snd")))
	    (save-sound-as "fmv.snd" index mus-aifc)
	    (close-sound index))
	  (let ((index (open-sound "fmv.snd")))
	    (if (not (equal? (sound-loop-info index) '()))
		(snd-display #__line__ ";null loop-info: ~A" (sound-loop-info index)))
	    (set! (sound-loop-info index) (list 1200 1400 4 3 2 1))
	    (if (not (equal? (sound-loop-info index) (list 1200 1400 4 3 2 1 1 1)))
		(snd-display #__line__ ";set null loop-info: ~A" (sound-loop-info index)))
	    (save-sound-as "fmv1.snd" :sound index :header-type mus-aifc)
	    (close-sound index)
	    (if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 1200 1400 4 3 2 1 1 1)))
		(snd-display #__line__ ";saved null loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))
	  (let ((index (open-sound "fmv.snd")))
	    (set! (sound-loop-info) (list 1200 1400 4 3 2 1 1 0))
	    (if (not (equal? (sound-loop-info index) (list 1200 1400 0 0 2 1 1 0)))
		(snd-display #__line__ ";set null loop-info (no mode1): ~A" (sound-loop-info index)))
	    (save-sound-as "fmv1.snd" index mus-aifc)
	    (close-sound index)
	    (if (not (equal? (mus-sound-loop-info "fmv1.snd") (list 1200 1400 0 0 2 1 1 0)))
		(snd-display #__line__ ";saved null loop-info (no mode1): ~A" (mus-sound-loop-info "fmv1.snd")))))
	
	(if com (snd-display #__line__ ";oboe: mus-sound-comment ~A?" com))
	(let ((fsnd (string-append sf-dir "nasahal8.wav")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com 
							    (string-append "ICRD: 1997-02-22" 
									   (string #\newline)
									   "IENG: Paul R. Roger"
									   (string #\newline)
									   "ISFT: Sound Forge 4.0"
									   (string #\newline)))))
		    (snd-display #__line__ ";mus-sound-comment \"nasahal8.wav\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "8svx-8.snd")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "File created by Sound Exchange  ")))
		    (snd-display #__line__ ";mus-sound-comment \"8svx-8.snd\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "sun-16-afsp.snd")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "AFspdate:1981/02/11 23:03:34 UTC")))
		    (snd-display #__line__ ";mus-sound-comment \"sun-16-afsp.snd\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "smp-16.snd")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "Converted using Sox.                                        ")))
		    (snd-display #__line__ ";mus-sound-comment \"smp-16.snd\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "d40130.au")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "1994 Jesus Villena")))
		    (snd-display #__line__ ";mus-sound-comment \"d40130.au\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "wood.maud")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "file written by SOX MAUD-export ")))
		    (snd-display #__line__ ";mus-sound-comment \"wood.maud\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "addf8.sf_mipseb")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) 
			(not (string-=? com "date=\"Feb 11 18:03:34 1981\" info=\"Original recorded at 20 kHz, 15-bit D/A, digitally filtered and resampled\" speaker=\"AMK female\" text=\"Add the sum to the product of these three.\" ")))
		    (snd-display #__line__ ";mus-sound-comment \"addf8.sf_mipseb\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "mary-sun4.sig")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com (string-append "MARY HAD A LITTLE LAMB" (string #\newline)))))
		    (snd-display #__line__ ";mus-sound-comment \"mary-sun4.sig\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "nasahal.pat")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "This patch saved with Sound Forge 3.0.")))
		    (snd-display #__line__ ";mus-sound-comment \"nasahal.pat\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "next-16.snd")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) 
			(not (string-=? com ";Written on Mon 1-Jul-91 at 12:10 PDT  at localhost (NeXT) using Allegro CL and clm of 25-June-91")))
		    (snd-display #__line__ ";mus-sound-comment \"next-16.snd\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "wood16.nsp")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "Created by Snack   ")))
		    (snd-display #__line__ ";mus-sound-comment \"wood16.nsp\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "wood.sdx")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "1994 Jesus Villena")))
		    (snd-display #__line__ ";mus-sound-comment \"wood.sdx\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "clmcom.aif")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com "this is a comment")))
		    (snd-display #__line__ ";mus-sound-comment \"clmcom.aif\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "anno.aif")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) (not (string-=? com (string-append "1994 Jesus Villena" (string #\newline)))))
		    (snd-display #__line__ ";mus-sound-comment \"anno.aif\") -> ~A?" com)))))
	(let ((fsnd (string-append sf-dir "telephone.wav")))
	  (if (file-exists? fsnd)
	      (begin
		(set! com (mus-sound-comment fsnd))
		(if (or (not (string? com)) 
			(not (string-=? com (string-append "sample_byte_format -s2 01"
							   (string #\newline)
							   "channel_count -i 1"
							   (string #\newline)
							   "sample_count -i 36461"
							   (string #\newline)
							   "sample_rate -i 16000"
							   (string #\newline)
							   "sample_n_bytes -i 2"
							   (string #\newline)
							   "sample_sig_bits -i 16"
							   (string #\newline)))))
		    (snd-display #__line__ ";mus-sound-comment \"telephone.wav\") -> ~A?" com)))))
	
	(if (not (string? (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
	    (snd-display #__line__ ";mus-sound-comment traffic: ~A" (mus-sound-comment (string-append sf-dir "traffic.aiff"))))
	
	(if (= clmtest 0)
	    (begin
	      (if (fneq (cadr mal) .14724) (snd-display #__line__ ";oboe: mus-sound-maxamp ~F?" (cadr mal)))
	      (if (not (= (car mal) 24971)) (snd-display #__line__ ";oboe: mus-sound-maxamp at ~D?" (car mal)))))
	(set! (mus-sound-maxamp "oboe.snd") (list 1234 .5))
	(set! mal (mus-sound-maxamp "oboe.snd"))
	(if (fneq (cadr mal) .5) (snd-display #__line__ ";oboe: set! mus-sound-maxamp ~F?" (cadr mal)))
	(if (not (= (car mal) 1234)) (snd-display #__line__ ";oboe: set! mus-sound-maxamp at ~D?" (car mal)))
	(set! mal (mus-sound-maxamp "4.aiff"))
	(if (= clmtest 0)
	    (if (not (feql mal (list 810071 0.245 810071 0.490 810071 0.735 810071 0.980)))
		(snd-display #__line__ ";mus-sound-maxamp 4.aiff: ~A?" mal)))
	(set! (mus-sound-maxamp "4.aiff") (list 12345 .5 54321 .2 0 .1 9999 .01))
	(set! mal (mus-sound-maxamp "4.aiff"))
	(if (not (feql mal (list 12345 .5 54321 .2 0 .1 9999 .01)))
	    (snd-display #__line__ ";set! mus-sound-maxamp 4.aiff: ~A?" mal))
	(let ((var (catch #t (lambda () (set! (mus-sound-maxamp "oboe.snd") (list 1234))) (lambda args args))))
	  (if (not (eq? (car var) 'wrong-type-arg))
	      (snd-display #__line__ ";set! mus-sound-maxamp bad arg: ~A" var)))
	(if (and (not (= (mus-sound-type-specifier "oboe.snd") #x646e732e))  ;little endian reader
		 (not (= (mus-sound-type-specifier "oboe.snd") #x2e736e64))) ;big endian reader
	    (snd-display #__line__ ";oboe: mus-sound-type-specifier: ~X?" (mus-sound-type-specifier "oboe.snd")))
	(if (not (string-=? (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd"))) "15-Oct-2006 04:34"))
	    (snd-display #__line__ ";oboe: file-write-date: ~A?" (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd")))))
	(play-sound-1 "oboe.snd")
	(mus-sound-forget "oboe.snd")
	
	(let ((lasth (do ((i 1 (+ 1 i)))
			 ((string-=? (mus-header-type-name i) "unsupported") i))))
	  (if (< lasth 50) (snd-display #__line__ ";header-type[~A] = ~A" lasth (mus-header-type-name lasth))))
	(let ((lasth (do ((i 1 (+ 1 i)))
			 ((string-=? (mus-data-format-name i) "unknown") i))))
	  (if (< lasth 10) (snd-display #__line__ ";data-format[~A] = ~A" lasth (mus-data-format-name lasth))))
	
	(set! (transform-normalization) dont-normalize)
	(if (not (= (transform-normalization) dont-normalize))
	    (snd-display #__line__ ";set-transform-normalization none -> ~A" (transform-normalization)))
	(set! (transform-normalization) normalize-globally)
	(if (not (= (transform-normalization) normalize-globally))
	    (snd-display #__line__ ";set-transform-normalization globally -> ~A" (transform-normalization)))
	(set! (transform-normalization) normalize-by-channel)
	(if (not (= (transform-normalization) normalize-by-channel))
	    (snd-display #__line__ ";set-transform-normalization channel -> ~A" (transform-normalization)))
	
	(let ((ind (new-sound "fmv.snd" mus-next mus-bshort 22050 1 "set-samples test" 100)))
	  (set! (samples 10 3) (make-vct 3 .1))
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct 0 0 0 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";1 set samples 0 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (set! (samples 20 3 ind 0) (make-vct 3 .1))
	  (if (not (vequal (channel->vct 10 20 ind 0) (vct .1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";2 set samples 10 for .1: ~A" (channel->vct 10 20 ind 0)))
	  (set! (samples 30 3 ind 0 #f "a name") (make-vct 3 .1))
	  (if (not (vequal (channel->vct 20 20 ind 0) (vct .1 .1 .1 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";3 set samples 20 for .1: ~A" (channel->vct 20 20 ind 0)))
	  (set! (samples 0 3 ind 0 #f "a name" 0 1) (make-vct 3 .2))
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct .2 .2 .2 0 0 0 0 0 0 0 .1 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";4 set samples 0 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (if (not (vequal (channel->vct 20 20 ind 0) (make-vct 20 0.0)))
	      (snd-display #__line__ ";5 set samples 20 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (let ((nd (new-sound "fmv1.snd" :channels 2)))
	    (vct->channel (make-vct 10 .5) 0 10 nd 0)
	    (vct->channel (make-vct 10 .3) 0 10 nd 1)
	    (save-sound-as "fmv1.snd" nd)
	    (close-sound nd))
	  (if (not (file-exists? "fmv1.snd")) (snd-display #__line__ ";fmv1 not saved??"))
	  (set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd")
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .1 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";6 set samples 0 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (set! (samples 5 6 ind 0 #f "another name 7" 0) "fmv1.snd")
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct .3 .3 .3 .3 .3 .5 .5 .5 .5 .5 .5 .1 .1 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";7 set samples 0 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (revert-sound ind)
	  (set! (samples 0 10 ind 0 #f "another name 8" 1 0 #f) "fmv1.snd")
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 0 0 0 0 0 0 0 0 0 0)))
	      (snd-display #__line__ ";8 set samples 0 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (set! (samples 10 10 ind 0 #f "another name 9" 0 0) "fmv1.snd")
	  (if (not (vequal (channel->vct 0 20 ind 0) (vct 0 0 0 0 0 0 0 0 0 0 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5)))
	      (snd-display #__line__ ";9 set samples 0 at 1 for .1: ~A" (channel->vct 0 20 ind 0)))
	  (set! (samples 20 10) "fmv1.snd")
	  (if (not (vequal (channel->vct 10 20 ind 0) (make-vct 20 .5)))
	      (snd-display #__line__ ";10 set samples 0 at 1 for .1: ~A" (channel->vct 10 20 ind 0)))
	  (revert-sound ind)
	  (set! (samples 0 10 ind 0 #t "another name" 1 0 #f) "fmv1.snd")
	  (if (not (= (frames ind 0) 10)) (snd-display #__line__ ";11 set-samples truncate to ~A" (frames ind 0)))
	  (revert-sound ind)
	  (delete-file "fmv1.snd")
	  
	  ;; now try to confuse it
	  (let ((tag (catch #t 
			    (lambda () (set! (samples 0 10 ind 0) "fmv1.snd"))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-file)) (snd-display #__line__ ";set-samples, no such file: ~A" tag)))
	  (let ((nd (new-sound "fmv1.snd" :channels 1)))
	    (vct->channel (make-vct 10 .5) 0 10 nd 0)
	    (save-sound-as "fmv1.snd" nd)
	    (close-sound nd))
	  (let ((tag (catch #t
			    (lambda () (set! (samples 0 10 ind 0 #f "another name" 1) "fmv1.snd")) ; chan 1 does not exist
			    (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";set-samples no such channel: ~A" tag)))
	  (let ((tag (catch #t
			    (lambda () (set! (samples 0 10 ind 0 #f "another name" -1) "fmv1.snd"))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";set-samples no such channel (-1): ~A" tag)))
	  (let ((tag (catch #t
			    (lambda () (set! (samples 0 -10) "fmv1.snd"))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-samples (-10): ~A" tag)))
	  (let ((tag (catch #t
			    (lambda () (set! (samples -10 10) "fmv1.snd"))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-sample)) (snd-display #__line__ ";set-samples (beg -10): ~A" tag)))
	  (close-sound ind))
	
	(let ((len 100))
	  (for-each
	   (lambda (type allowed-diff)
	     (let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1))
		   (v (make-vct len))
		   (maxdiff 0.0)
		   (maxpos #f))
	       (vct-set! v 0 0.999)
	       (vct-set! v 1 -1.0)
	       (vct-set! v 2 .1)
	       (vct-set! v 3 -.1)
	       (vct-set! v 4 .01)
	       (vct-set! v 5 -.01)
	       (vct-set! v 4 .001)
	       (vct-set! v 5 -.001)
	       (vct-set! v 6 0.0)
	       (do ((i 7 (+ 1 i)))
		   ((= i len))
		 (let ((val (random 1.9999)))
		   (if (or (> val 2.0)
			   (< val 0.0))
		       (snd-display #__line__ ";random 2.0 -> ~A?" val))
		   (vct-set! v i (- 1.0 val))))
	       (vct->channel v 0 len ind 0)
	       (save-sound-as "test1.snd" ind mus-next :data-format type)
	       (close-sound ind)
	       (set! ind (open-sound "test1.snd"))
	       (let ((v1 (channel->vct 0 len ind 0)))
		 (do ((i 0 (+ 1 i)))
		     ((= i len))
		   (let ((diff (abs (- (vct-ref v i) (vct-ref v1 i)))))
		     (if (> diff maxdiff)
			 (begin
			   (set! maxdiff diff)
			   (set! maxpos i)))))
		 (if (> maxdiff allowed-diff)
		     (snd-display #__line__ ";[line 2841] ~A: ~A at ~A (~A ~A)" 
				  (mus-data-format-name type) 
				  maxdiff maxpos 
				  (vct-ref v maxpos) (vct-ref v1 maxpos)))
		 (close-sound ind))))
	   (list mus-bshort   mus-lshort   mus-mulaw   mus-alaw   mus-byte  
		 mus-lfloat   mus-bint     mus-lint    mus-b24int mus-l24int
		 mus-ubshort  mus-ulshort  mus-ubyte   mus-bfloat mus-bdouble 
		 mus-ldouble)
	   (list (expt 2 -15) (expt 2 -15) 0.02 0.02 (expt 2 -7)
		 (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) (expt 2 -23) ; assuming sndlib bits=24 here (if int)
		 (expt 2 -15) (expt 2 -15) (expt 2 -7) (expt 2 -23) (expt 2 -23)
		 (expt 2 -23))))
	
	(let* ((ob (view-sound "oboe.snd"))
	       (samp (sample 1000 ob))
	       (old-comment (mus-sound-comment "oboe.snd"))
	       (str (string-append "written " 
				   (strftime "%a %d-%b-%Y %H:%M %Z" 
					     (localtime (current-time))))))
	  (set! (comment ob) str)
	  (let ((tag (catch #t
			    (lambda ()
			      (save-sound-as "test.snd" ob mus-aifc mus-bdouble))
			    (lambda args (car args)))))
	    (if (eq? tag 'cannot-save) (snd-display #__line__ ";save-sound-as test.snd write trouble")))
	  (set! (filter-control-in-hz) #t)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug))
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (provided? 'snd-debug)
		(if (snd-sound-pointer 12345) (snd-display #__line__ ";snd-sound-pointer #f: ~A" (snd-sound-pointer 12345))))
	    (if (not (= (header-type ab) mus-aifc)) 
		(snd-display #__line__ ";save-as aifc -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-aifc)) 
		(snd-display #__line__ ";saved-as aifc -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";aifc[1000] = ~A?" (sample 1000 ab)))
	    (if (or (not (string? (mus-sound-comment "test.snd")))
		    (not (string-=? (mus-sound-comment "test.snd") str)))
		(snd-display #__line__ ";output-comment: ~A ~A" (mus-sound-comment "test.snd") str))
	    (if (or (not (string? (comment ab)))
		    (not (string-=? (comment ab) str)))
		(snd-display #__line__ ";output-comment (comment): ~A ~A" (comment ab) str))
	    (close-sound ab))
	  (if (not (equal? old-comment (mus-sound-comment "oboe.snd")))
	      (snd-display #__line__ ";set-comment overwrote current ~A ~A" old-comment (mus-sound-comment "oboe.snd")))
	  (set! (filter-control-in-hz) #f)
	  (save-sound-as "test.snd" ob mus-raw)
	  (let ((ab (open-raw-sound "test.snd" 1 22050 mus-bshort)))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-raw)) 
		(snd-display #__line__ ";save-as raw -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-raw)) 
		(snd-display #__line__ ";saved-as raw -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";raw[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-nist mus-bint)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-nist)) 
		(snd-display #__line__ ";save-as nist -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-nist)) 
		(snd-display #__line__ ";saved-as nist -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-bint)) 
		(snd-display #__line__ ";save-as int -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-bint)) 
		(snd-display #__line__ ";saved-as int -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";nist[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (reset-hook! output-comment-hook)
	  (add-hook! output-comment-hook
		     (lambda (str) 
		       (string-append str " [written by me]")))
	  (save-sound-as :file "test.snd" :sound ob :header-type mus-riff :data-format mus-lfloat)
	  (reset-hook! output-comment-hook)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-riff)) 
		(snd-display #__line__ ";save-as riff -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-riff)) 
		(snd-display #__line__ ";saved-as riff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-lfloat)) 
		(snd-display #__line__ ";save-as float -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-lfloat)) 
		(snd-display #__line__ ";saved-as float -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";riff[1000] = ~A?" (sample 1000 ab)))
	    (if (or (not (string? (comment ab)))
		    (not (string-=? (comment ab) 
				    (string-append "written " 
						   (strftime "%a %d-%b-%Y %H:%M %Z" (localtime (current-time)))
						   " [written by me]"))))
		(snd-display #__line__ ";output-comment-hook: ~A~%(~A)" (comment ab) (mus-sound-comment "test.snd")))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-aiff mus-b24int)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-aiff)) 
		(snd-display #__line__ ";save-as aiff -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-aiff)) 
		(snd-display #__line__ ";saved-as aiff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-b24int))
		(snd-display #__line__ ";save-as 24-bit -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-b24int))
		(snd-display #__line__ ";saved-as 24-bit -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";aiff[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-ircam mus-mulaw)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-ircam)) 
		(snd-display #__line__ ";save-as ircam -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-ircam)) 
		(snd-display #__line__ ";saved-as ircam -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-mulaw))
		(snd-display #__line__ ";save-as mulaw -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-mulaw))
		(snd-display #__line__ ";saved-as mulaw -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";ircam[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-next mus-alaw)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-next)) 
		(snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
		(snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-alaw)) 
		(snd-display #__line__ ";save-as alaw -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-alaw)) 
		(snd-display #__line__ ";saved-as alaw -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (alaw)[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-next mus-bdouble)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug))
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-next)) 
		(snd-display #__line__ ";save-as dbl next -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (data-format ab) mus-bdouble)) 
		(snd-display #__line__ ";save-as dbl -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (dbl)[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-next mus-bshort)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug))
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-next)) 
		(snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
		(snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-bshort)) 
		(snd-display #__line__ ";save-as short -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-bshort)) 
		(snd-display #__line__ ";saved-as short -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (short)[1000] = ~A?" (sample 1000 ab)))
	    (reset-hook! update-hook)
	    (set! (y-bounds ab 0) (list -3.0 3.0))
	    (set! (data-format ab) mus-lshort)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd"))) ; these set!'s can change the index via update-sound
	    (if (not (= (data-format ab) mus-lshort)) (snd-display #__line__ ";set data-format: ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (equal? (y-bounds ab 0) (list -3.0 3.0))) (snd-display #__line__ ";set data format y-bounds: ~A?" (y-bounds ab 0)))
	    (set! (y-bounds ab 0) (list 2.0))
	    (if (not (equal? (y-bounds ab 0) (list -2.0 2.0))) (snd-display #__line__ ";set data format y-bounds 1: ~A?" (y-bounds ab 0)))
	    (set! (y-bounds ab 0) (list -2.0))
	    (if (not (equal? (y-bounds ab 0) (list -2.0 2.0))) (snd-display #__line__ ";set data format y-bounds -2: ~A?" (y-bounds ab 0)))
	    (set! (header-type ab) mus-aifc)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (header-type ab) mus-aifc)) (snd-display #__line__ ";set header-type: ~A?" (mus-header-type-name (header-type ab))))
	    (set! (channels ab) 3)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (channels ab) 3)) (snd-display #__line__ ";set chans: ~A?" (channels ab)))
	    (set! (data-location ab) 1234)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (data-location ab) 1234)) (snd-display #__line__ ";set data-location: ~A?" (data-location ab)))
	    (let ((old-size (data-size ab)))
	      (set! (data-size ab) 1234)
	      (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	      (if (not (= (data-size ab) 1234)) (snd-display #__line__ ";set data-size: ~A?" (data-size ab)))
	      (set! (data-size ab) old-size))
	    (set! (srate ab) 12345)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (srate ab) 12345)) (snd-display #__line__ ";set srate: ~A?" (srate ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-next mus-bfloat)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (if (not (= (header-type ab) mus-next)) 
		(snd-display #__line__ ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	    (if (not (= (mus-sound-header-type "test.snd") mus-next)) 
		(snd-display #__line__ ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	    (if (not (= (data-format ab) mus-bfloat)) 
		(snd-display #__line__ ";save-as float -> ~A?" (mus-data-format-name (data-format ab))))
	    (if (not (= (mus-sound-data-format "test.snd") mus-bfloat)) 
		(snd-display #__line__ ";saved-as float -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	    (if (fneq (sample 1000 ab) samp) (snd-display #__line__ ";next (float)[1000] = ~A?" (sample 1000 ab)))
	    (close-sound ab))
	  (save-sound-as "test.snd" ob mus-next mus-bshort)
	  (close-sound ob)
	  (let ((ab (open-sound "test.snd")))
	    (if (and (provided? 'xm) (provided? 'snd-debug)) 
		(XtCallCallbacks (cadr (sound-widgets ab)) XmNactivateCallback (snd-sound-pointer ab)))
	    (set! (data-format) mus-lshort)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (data-format) mus-lshort)) (snd-display #__line__ ";set data-format: ~A?" (mus-data-format-name (data-format))))
	    (set! (header-type) mus-aifc)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (header-type) mus-aifc)) (snd-display #__line__ ";set header-type: ~A?" (mus-header-type-name (header-type))))
	    (set! (channels) 3)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (channels) 3)) (snd-display #__line__ ";set chans: ~A?" (channels)))
	    (set! (data-location) 1234)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (data-location) 1234)) (snd-display #__line__ ";set data-location: ~A?" (data-location)))
	    (set! (srate) 12345)
	    (if (not (equal? ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	    (if (not (= (srate) 12345)) (snd-display #__line__ ";set srate: ~A?" (srate)))
	    (close-sound ab)))
	
	(let ((ind (open-sound "2a.snd")))
	  (save-sound-as "test.snd" :data-format mus-l24int :header-type mus-riff :channel 0)
	  (let ((ind0 (open-sound "test.snd")))
	    (if (not (= (channels ind0) 1)) 
		(snd-display #__line__ ";save-sound-as :channel 0 chans: ~A" (channels ind0)))
	    (if (not (= (data-format ind0) mus-l24int)) 
		(snd-display #__line__ ";save-sound-as :channel 0 data-format: ~A ~A" (data-format ind0) (mus-data-format-name (data-format ind0))))
	    (if (not (= (header-type ind0) mus-riff))
		(snd-display #__line__ ";save-sound-as :channel 0 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	    (if (not (= (srate ind0) (srate ind)))
		(snd-display #__line__ ";save-sound-as :channel 0 srates: ~A ~A" (srate ind0) (srate ind)))    
	    (if (not (= (frames ind0) (frames ind 0)))
		(snd-display #__line__ ";save-sound-as :channel 0 frames: ~A ~A" (frames ind0) (frames ind 0)))
	    (if (fneq (maxamp ind0 0) (maxamp ind 0))
		(snd-display #__line__ ";save-sound-as :channel 0 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 0)))
	    (close-sound ind0))
	  (save-sound-as "test.snd" :data-format mus-bfloat :header-type mus-aifc :channel 1 :srate 12345)
	  (let ((ind0 (open-sound "test.snd")))
	    (if (not (= (channels ind0) 1)) 
		(snd-display #__line__ ";save-sound-as :channel 1 chans: ~A" (channels ind0)))
	    (if (not (= (data-format ind0) mus-bfloat)) 
		(snd-display #__line__ ";save-sound-as :channel 1 data-format: ~A ~A" (data-format ind0) (mus-data-format-name (data-format ind0))))
	    (if (not (= (header-type ind0) mus-aifc))
		(snd-display #__line__ ";save-sound-as :channel 1 header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	    (if (not (= (srate ind0) 12345))
		(snd-display #__line__ ";save-sound-as :channel 1 srates: ~A ~A" (srate ind0) (srate ind)))    
	    (if (not (= (frames ind0) (frames ind 1)))
		(snd-display #__line__ ";save-sound-as :channel 1 frames: ~A ~A" (frames ind0) (frames ind 1)))
	    (if (fneq (maxamp ind0 0) (maxamp ind 1))
		(snd-display #__line__ ";save-sound-as :channel 1 maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	    (close-sound ind0))
	  (save-sound-as "test.snd" :channel 1 :comment "this is a test")
	  (let ((ind0 (open-sound "test.snd")))
	    (if (not (= (channels ind0) 1)) 
		(snd-display #__line__ ";save-sound-as :channel 1 (1) chans: ~A" (channels ind0)))
	    (if (not (= (data-format ind0) (data-format ind)))
		(snd-display #__line__ ";save-sound-as :channel 1 (1) data-format: ~A ~A" (data-format ind0) (mus-data-format-name (data-format ind0))))
	    (if (not (= (header-type ind0) (header-type ind)))
		(snd-display #__line__ ";save-sound-as :channel 1 (1) header-type: ~A ~A" (header-type ind0) (mus-header-type-name (header-type ind0))))
	    (if (not (= (srate ind0) (srate ind)))
		(snd-display #__line__ ";save-sound-as :channel 1 (1) srates: ~A ~A" (srate ind0) (srate ind)))    
	    (if (not (= (frames ind0) (frames ind 1)))
		(snd-display #__line__ ";save-sound-as :channel 1 (1) frames: ~A ~A" (frames ind0) (frames ind 1)))
	    (if (fneq (maxamp ind0 0) (maxamp ind 1))
		(snd-display #__line__ ";save-sound-as :channel 1 (1) maxamps: ~A ~A" (maxamp ind0 0) (maxamp ind 1)))
	    (if (not (string=? (comment ind0) "this is a test"))
		(snd-display #__line__ ";save-sound-as :channel 0 (1) comment: ~A" (comment ind0)))
	    (close-sound ind0))
	  (close-sound ind))
	
	(let ((fsnd (string-append sf-dir "t15.aiff")))
	  (if (file-exists? fsnd)
	      (let ((ind (open-sound fsnd)))
		(if (or (fneq (sample 132300 ind 0) .148)
			(fneq (sample 132300 ind 1) .126))
		    (snd-display #__line__ ";aifc sowt trouble: ~A ~A" (sample 132300 ind 0) (sample 132300 ind 1)))
		(close-sound ind))))
	(let ((fsnd (string-append sf-dir "M1F1-float64C-AFsp.aif")))
	  (if (file-exists? fsnd)
	      (let ((ind (open-sound fsnd)))
		(if (or (fneq (sample 8000 ind 0) -0.024)
			(fneq (sample 8000 ind 1) 0.021))
		    (snd-display #__line__ ";aifc fl64 trouble: ~A ~A" (sample 8000 ind 0) (sample 8000 ind 1)))
		(close-sound ind))))
	
	(for-each (lambda (n vals)
		    (let ((val (catch #t (lambda () 
					   (list (mus-sound-chans n)
						 (mus-sound-srate n)
						 (mus-sound-frames n)))
				      (lambda args (car args)))))
		      (if (and (not (equal? val vals))
			       (not (eq? val 'mus-error)))
			  (snd-display #__line__ ";~A: ~A ~A" n val vals))))
		  (list (string-append sf-dir "bad_chans.snd")
			(string-append sf-dir "bad_srate.snd")
			(string-append sf-dir "bad_data_format.snd")
			(string-append sf-dir "bad_chans.aifc")
			(string-append sf-dir "bad_srate.aifc")
			(string-append sf-dir "bad_length.aifc")
			(string-append sf-dir "bad_chans.riff")
			(string-append sf-dir "bad_srate.riff")
			(string-append sf-dir "bad_chans.nist")
			(string-append sf-dir "bad_srate.nist")
			(string-append sf-dir "bad_length.nist"))
		  (list (list 0 22050 0)
			(list 1 0 0)
			(list 1 22050 4411)
			(list 0 22050 0)
			(list 1 0 0)
			(list 1 22050 -10)
			(list 0 22050 0)
			(list 1 0 0)
			(list 0 22050 0)
			(list 1 0 0)
			(list 1 22050 -10)))
	
	(let ((ind (open-sound (string-append "/usr/include/sys/" home-dir "/cl/oboe.snd"))))
	  (if (or (not (sound? ind))
		  (not (string=? (short-file-name ind) "oboe.snd")))
	      (snd-display #__line__ ";open-sound with slashes: ~A ~A" ind (and (sound? ind) (short-file-name ind))))
	  (add-hook! bad-header-hook (lambda (n) #t))
	  (for-each (lambda (n)
		      (begin
			(catch #t (lambda () 
				    (insert-sound n))
			       (lambda args (car args)))
			(catch #t (lambda () 
				    (convolve-with n))
			       (lambda args (car args)))
			(catch #t (lambda () 
				    (mix n))
			       (lambda args (car args)))
			(catch #t (lambda () 
				    (let ((ind (open-sound n)))
				      (if (and (number? ind)
					       (sound? ind))
					  (close-sound ind))))
			       (lambda args (car args)))))
		    (list (string-append sf-dir "bad_chans.snd")
			  (string-append sf-dir "bad_srate.snd")
			  (string-append sf-dir "bad_chans.aifc")
			  (string-append sf-dir "bad_srate.aifc")
			  (string-append sf-dir "bad_length.aifc")
			  (string-append sf-dir "bad_chans.riff")
			  (string-append sf-dir "bad_srate.riff")
			  (string-append sf-dir "bad_chans.nist")
			  (string-append sf-dir "bad_location.nist")
			  (string-append sf-dir "bad_field.nist")
			  (string-append sf-dir "bad_srate.nist")
			  (string-append sf-dir "bad_length.nist")))
	  (close-sound ind))
	
	(map close-sound (sounds))
	
	(let* ((ob (open-sound (string-append "~/baddy/" home-dir "/cl/oboe.snd")))
	       (sd (vct->sound-data (channel->vct)))
	       (mx (sound-data-maxamp sd)))
	  (if (not (= (sound-data-length sd) 50828)) (snd-display #__line__ ";oboe->sd: len ~A?" (sound-data-length sd)))
	  (if (fneq (sound-data-ref sd 0 1000) .0328369) (snd-display #__line__ ";oboe->sd[1000]: ~A?" (sound-data-ref sd 0 1000)))
	  (if (not (= (length mx) 1)) (snd-display #__line__ ";sound-data-maxamp oboe.snd: ~A?" mx))
	  (if (not (= (maxamp ob 0) (car mx))) (snd-display #__line__ ";sound-data-maxamp oboe.snd: ~A ~A?" mx (maxamp ob 0)))
	  (if (fneq (sound-data-peak sd) (car mx)) (snd-display #__line__ ";sound-data-peak oboe.snd: ~A ~A" (sound-data-peak sd) mx))
	  
	  (let ((var (catch #t (lambda () (set! (selected-channel) 1)) (lambda args args))))
	    (if (not (eq? (car var) 'no-such-channel))
		(snd-display #__line__ ";set selected-channel bad chan: ~A" var)))
	  (let ((var (catch #t (lambda () (set! (selected-channel 123456) 1)) (lambda args args))))
	    (if (not (eq? (car var) 'no-such-sound))
		(snd-display #__line__ ";set selected-channel bad snd: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-ref sd 2 1000)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-ref bad chan: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-ref sd -1 1000)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-ref bad chan -1: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-ref sd 0 -1)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-ref bad frame: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-ref sd 0 10000000)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-ref bad frame high: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-set! sd 2 1000 1)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-set! bad chan: ~A" var)))
	  (let ((var (catch #t (lambda () (sound-data-set! sd 0 10000000 1)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";sound-data-set! bad frame: ~A" var)))
	  (let* ((v (make-vct 3))
		 (var (catch #t (lambda () (vct->sound-data v sd 2)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct->sound-data-set! bad chan: ~A" var)))
	  (close-sound ob))
	(if (selected-sound)
	    (snd-display #__line__ ";selected-sound ~A ~A" (selected-sound) (sounds)))
	
	(if (file-exists? (string-append (or sf-dir "") "a.sf2"))
	    (let ((fil (open-sound (string-append (or sf-dir "") "a.sf2"))))
	      (if fil
		  (let ((loops (and fil (soundfont-info))))
		    (if (or (null? loops)
			    (not (= (caddar loops) 65390))
			    (not (= (cadadr loops) 65490)))
			(snd-display #__line__ ";soundfont-info: ~A?" loops))
		    (close-sound fil)))))
	
	(if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	(set! (print-length) 12)
	(let ((fd (mus-sound-open-output "fmv5.snd" 22050 1 mus-bshort mus-aiff "no comment"))
	      (sdata (make-sound-data 1 100)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 100))
	    (sound-data-set! sdata 0 i (* i .01)))
	  (if (not (string-=? "#<sound-data[chans=1, length=100]:\n    (0.000 0.010 0.020 0.030 0.040 0.050 0.060 0.070 0.080 0.090 0.100 0.110 ...)>"
			      (format #f "~A" sdata)))
	      (snd-display #__line__ ";print sound-data: ~A?" (format #f "~A" sdata)))
	  (let ((edat sdata)
		(edat1 (make-sound-data 1 100))
		(edat2 (make-sound-data 2 100)))
	    (if (not (eq? sdata edat)) (snd-display #__line__ ";sound-data not eq? ~A ~A" sdata edat))
	    (if (not (equal? sdata edat)) (snd-display #__line__ ";sound-data not equal? ~A ~A" sdata edat))
	    (if (equal? sdata edat1) (snd-display #__line__ ";sound-data 1 equal? ~A ~A" sdata edat1))
	    (if (equal? edat2 edat1) (snd-display #__line__ ";sound-data 2 equal? ~A ~A" edat2 edat1))
	    (do ((i 0 (+ 1 i)))
		((= i 100))
	      (set! (sound-data-ref edat1 0 i) (sound-data-ref sdata 0 i)))
	    (if (not (equal? sdata edat1)) (snd-display #__line__ ";sound-data 3 not equal? ~A ~A" sdata edat1)))
	  (let ((v0 (make-vct 100))
		(v1 (make-vct 3)))
	    (sound-data->vct sdata 0 v0) 
	    (if (fneq (vct-ref v0 10) .1) (snd-display #__line__ ";sound-data->vct: ~A?" v0))
	    (sound-data->vct sdata 0 v1) 
	    (if (fneq (vct-ref v1 1) .01) (snd-display #__line__ ";sound-data->(small)vct: ~A?" v1))
	    (vct->sound-data v0 sdata 0) 
	    (if (fneq (sound-data-ref sdata 0 10) .1) (snd-display #__line__ ";vct->sound-data: ~A?" (sound-data-ref sdata 0 10)))
	    (if (fneq (sdata 0 10) .1) (snd-display #__line__ ";vct->sound-data applied: ~A?" (sdata 0 10)))
	    (let ((var (catch #t (lambda () (sound-data->vct sdata 2 v0)) (lambda args args))))
	      (if (not (eq? (car var) 'out-of-range))
		  (snd-display #__line__ ";sound-data->vct bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (mus-audio-write 1 (make-sound-data 3 3) 123)) (lambda args args))))
	      (if (not (eq? (car var) 'out-of-range))
		  (snd-display #__line__ ";mus-audio-write bad frames: ~A" var))))
	  
	  (let ((v0 (make-vct 10))
		(vx (make-vct 3))
		(sdata2 (make-sound-data 2 10)))
	    (do ((i 0 (+ 1 i)))
		((= i 10))
	      (sound-data-set! sdata2 0 i 0.1)
	      (sound-data-set! sdata2 1 i 0.2))
	    (sound-data->vct sdata2 0 v0) 
	    (sound-data->vct sdata2 0 vx)
	    (if (fneq (vct-ref v0 1) .1) (snd-display #__line__ ";sound-data->vct[1]: ~A?" v0))
	    (sound-data->vct sdata2 1 v0) 
	    (if (fneq (vct-ref v0 1) .2) (snd-display #__line__ ";sound-data->vct[2]: ~A?" v0))
	    (vct->sound-data v0 sdata2 0) 
	    (if (fneq (sound-data-ref sdata2 0 1) .2) 
		(snd-display #__line__ ";vct->sound-data[2]: ~A?" (sound-data-ref sdata2 0 1)))
	    (vct-fill! v0 .3)
	    (vct->sound-data v0 sdata2 1) 
	    (if (fneq (sound-data-ref sdata2 1 1) .3) 
		(snd-display #__line__ ";vct->sound-data[3]: ~A?" (sound-data-ref sdata2 1 1)))
	    (vct->sound-data vx sdata2 0))
	  (mus-sound-write fd 0 99 1 sdata)
	  (mus-sound-close-output fd (* 100 (mus-bytes-per-sample mus-bshort))) ; bshort chosen at open
	  (set! fd (mus-sound-reopen-output "fmv5.snd" 1 mus-bshort mus-aiff (mus-sound-data-location "fmv5.snd")))
	  (mus-sound-close-output fd (* 100 (mus-bytes-per-sample mus-bshort)))
	  (set! fd (mus-sound-open-input "fmv5.snd"))
	  (mus-sound-read fd 0 99 1 sdata)
	  (if (fneq (sound-data-ref sdata 0 10) .1) (snd-display #__line__ ";mus-sound-write: ~A?" (sound-data-ref sdata 0 10)))
	  (let ((pos (mus-sound-seek-frame fd 20)))
	    (if (not (= pos (ftell fd))) 
		(snd-display #__line__ ";1 mus-sound-seek-frame: ~A ~A?" pos (ftell fd)))
	    (if (not (= pos (frame->byte "fmv5.snd" 20)))
		(snd-display #__line__ ";2 mus-sound-seek-frame(2): ~A ~A?" pos (frame->byte "fmv5.snd" 20))))
	  (mus-sound-read fd 0 10 1 sdata)
	  (if (fneq (sound-data-ref sdata 0 0) .2) (snd-display #__line__ ";2 mus-sound-seek: ~A?" (sound-data-ref sdata 0 0)))
	  (mus-sound-close-input fd))
	
	(let ((sd (make-sound-data 2 10)))
	  (vct->sound-data (make-vct 10 .25) sd 0)  
	  (vct->sound-data (make-vct 10 .5) sd 1)
	  (sound-data-scale! sd 2.0)
	  (if (not (vequal (sound-data->vct sd 0) (make-vct 10 .5)))
	      (snd-display #__line__ ";sound-data-scale! chan 0: ~A" (sound-data->vct sd 0)))
	  (if (not (vequal (sound-data->vct sd 1) (make-vct 10 1.0)))
	      (snd-display #__line__ ";sound-data-scale! chan 1: ~A" (sound-data->vct sd 1))))
	
	(let ((sd (make-sound-data 2 10)))
	  (sound-data-fill! sd 2.0)
	  (if (not (vequal (sound-data->vct sd 0) (make-vct 10 2.0)))
	      (snd-display #__line__ ";sound-data-fill! chan 0: ~A" (sound-data->vct sd 0)))
	  (if (not (vequal (sound-data->vct sd 1) (make-vct 10 2.0)))
	      (snd-display #__line__ ";sound-data-fill! chan 1: ~A" (sound-data->vct sd 1))))
	
	(let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 -1 mus-bshort mus-aiff "no comment")) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-open-output bad chans: ~A" var)))
	(let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 1 -1 mus-aiff "no comment")) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-open-output bad format: ~A" var)))
	(let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 1 mus-bshort -1 "no comment")) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-open-output bad type: ~A" var)))
	
	(let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" -1 mus-bshort mus-aiff #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-reopen-output bad chans: ~A" var)))
	(let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" 1 -1 mus-aiff #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-reopen-output bad format: ~A" var)))
	(let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" 1 mus-bshort -1 #f)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";mus-sound-reopen-output bad type: ~A" var)))
	
	(let ((sd (make-sound-data 2 10)))
	  (fill! sd 1.0)
	  (if (not (vequal (sound-data->vct sd 0) (make-vct 10 1.0)))
	      (snd-display #__line__ ";fill! sd chan 0: ~A" (sound-data->vct sd 0)))
	  (if (not (vequal (sound-data->vct sd 1) (make-vct 10 1.0)))
	      (snd-display #__line__ ";fill! sd chan 1: ~A" (sound-data->vct sd 1)))
	  (let ((sd1 (copy sd)))
	    (if (not (equal? sd sd1)) (snd-display #__line__ ";copy sd: ~A ~A"))))
	
	(for-each
	 (lambda (file)
	   (let ((tag (catch #t
			     (lambda () (open-sound (string-append sf-dir file)))
			     (lambda args args))))
	     (if (not (eq? (car tag) 'mus-error))
		 (snd-display #__line__ ";open-sound ~A: ~A" file tag))))
	 (list "trunc.snd" "trunc.aiff" "trunc.wav" "trunc.sf" "trunc.voc" "trunc.nist" "bad.wav" 
	       "trunc1.aiff" "badform.aiff"))
	(add-hook! open-raw-sound-hook (lambda (file choice) (list 1 22050 mus-bshort)))
	(let ((ind (open-sound (string-append sf-dir "empty.snd"))))
	  (if (or (not (= (data-format ind) mus-bshort))
		  (not (= (chans ind) 1))
		  (not (= (srate ind) 22050))
		  (not (= (data-location ind) 0))
		  (not (= (frames ind) 0)))
	      (snd-display #__line__ ";open raw: ~A ~A ~A ~A ~A" (data-format ind) (chans ind) (srate ind) (data-location ind) (frames ind)))
	  (reset-hook! open-raw-sound-hook)
	  (close-sound ind))
	
	(let ((sd1 (make-sound-data 1 32))
	      (sd2 (make-sound-data 2 64)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 32))
	    (sound-data-set! sd1 0 i (* .01 i)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 64))
	    (sound-data-set! sd2 0 i (* .1 i))
	    (sound-data-set! sd2 1 i (* .2 i)))
	  (sound-data->sound-data sd2 sd1 3 6 32)
	  (if (fneq (sound-data-ref sd1 0 0) 0.0) (snd-display #__line__ ";sound-data->sound-data 0: ~A" (sound-data-ref sd1 0 0)))
	  (if (fneq (sound-data-ref sd1 0 2) 0.02) (snd-display #__line__ ";sound-data->sound-data 2: ~A" (sound-data-ref sd1 0 2)))
	  (if (fneq (sound-data-ref sd1 0 3) 0.0) (snd-display #__line__ ";sound-data->sound-data 3: ~A" (sound-data-ref sd1 0 3)))
	  (if (fneq (sound-data-ref sd1 0 6) 0.3) (snd-display #__line__ ";sound-data->sound-data 6: ~A" (sound-data-ref sd1 0 6)))
	  (if (fneq (sound-data-ref sd1 0 10) 0.1) (snd-display #__line__ ";sound-data->sound-data 10: ~A" (sound-data-ref sd1 0 10)))
	  (sound-data->sound-data sd1 sd2 0 10 32)
	  (if (fneq (sound-data-ref sd2 0 5) 0.2) (snd-display #__line__ ";sound-data->sound-data 2 5: ~A" (sound-data-ref sd2 0 5))))
	(let ((sdi (make-sound-data 1 32))
	      (sdo (make-sound-data 1 32)))
	  (let ((j (sound-data->sound-data sdi sdo 10 32 10)))
	    (if (not (= j 2)) (snd-display #__line__ ";sound-data->sound-data wrap around 2: ~A" j)))
	  (let ((j (sound-data->sound-data sdi sdo 10 32 32)))
	    (if (not (= j 10)) (snd-display #__line__ ";sound-data->sound-data wrap around 10: ~A" j)))
	  (let ((tag (catch #t
			    (lambda () (sound-data->sound-data sdi sdo -1 10 10))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'out-of-range))
		(snd-display #__line__ ";sound-data->sound-data start: ~A" tag)))
	  (let ((tag (catch #t
			    (lambda () (sound-data->sound-data sdi sdo 0 -1 10))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'out-of-range))
		(snd-display #__line__ ";sound-data->sound-data frames: ~A" tag)))
	  (let ((tag (catch #t
			    (lambda () (sound-data->sound-data sdi sdo 0 128 10))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'out-of-range))
		(snd-display #__line__ ";sound-data->sound-data frames: ~A" tag))))
	
	
	(let ((sd (make-sound-data 1 1)))
	  (if (fneq (sd 0 0) 0.0) (snd-display #__line__ ";sound-data ref: ~A" (sd 0 0)))
	  (set! (sd 0 0) 1.0)
	  (if (fneq (sd 0 0) 1.0) (snd-display #__line__ ";sound-data set: ~A" (sd 0 0)))
	  (if (not (equal? sd (let ((sd1 (make-sound-data 1 1))) (sound-data-set! sd1 0 0 1.0) sd1)))
	      (snd-display #__line__ ";sound-data set not equal: ~A" sd)))
	
	(let ((sd (make-sound-data 2 3)))
	  (if (fneq (sd 0 0) 0.0) (snd-display #__line__ ";sound-data ref (1): ~A" (sd 0 0)))
	  (set! (sd 1 0) 1.0)
	  (if (fneq (sd 1 0) 1.0) (snd-display #__line__ ";sound-data set (1 0): ~A" (sd 1 0)))
	  (set! (sd 1 2) 2.0)
	  (if (fneq (sd 1 2) 2.0) (snd-display #__line__ ";sound-data set (1 2): ~A" (sd 1 2)))
	  (if (not (equal? sd (let ((sd1 (make-sound-data 2 3)))
				(sound-data-set! sd1 1 0 1.0)
				(sound-data-set! sd1 1 2 2.0)
				sd1)))
	      (snd-display #__line__ ";sound-data set (3) not equal: ~A" sd)))
	
	
	(for-each 
	 (lambda (chans)
	   (for-each 
	    (lambda (df-ht)
	      (let ((samps (if (= chans 1) 100000
			       (if (= chans 2) 50000
				   1000))))
		(if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
		(let ((fd (mus-sound-open-output "fmv5.snd" 22050 chans (car df-ht) (cadr df-ht) "no comment"))
		      (sdata (make-sound-data chans samps))
		      (ndata (make-sound-data chans samps)))
		  (run 
		   (do ((k 0 (+ 1 k)))
		       ((= k chans))
		     (do ((i 0 (+ 1 i)))
			 ((= i samps))
		       (sound-data-set! sdata k i (- (random 2.0) 1.0)))))
		  (mus-sound-write fd 0 (- samps 1) chans sdata)
		  (mus-sound-close-output fd (* samps chans (mus-bytes-per-sample (car df-ht))))
		  (set! fd (mus-sound-open-input "fmv5.snd"))
		  (mus-sound-read fd 0 (- samps 1) chans ndata)
		  (let ((pos (mus-sound-seek-frame fd 100)))
		    (if (not (= pos (ftell fd))) 
			(snd-display #__line__ ";mus-sound-seek-frame[~A]: chans ~A ~A (~A ~A)?" 
				     pos chans (ftell fd) (mus-header-type-name (cadr df-ht)) (mus-data-format-name (car df-ht))))
		    (if (not (= pos (frame->byte "fmv5.snd" 100))) 
			(snd-display #__line__ ";mus-sound-seek-frame(100): ~A ~A (~A ~A ~A)?" 
				     pos (frame->byte "fmv5.snd" 100) chans (mus-header-type-name (cadr df-ht)) (mus-data-format-name (car df-ht)))))
		  (mus-sound-close-input fd)
		  (let ((v0 0.0)
			(v1 0.0))
		    (catch 'read-write-error
			   (lambda ()
			     (run
			      (do ((k 0 (+ 1 k)))
				  ((= k chans))
				(do ((i 0 (+ 1 i)))
				    ((= i samps))
				  (if (fneq (sound-data-ref sdata k i) (sound-data-ref ndata k i))
				      (begin
					(set! v0 (sound-data-ref sdata k i))
					(set! v1 (sound-data-ref ndata k i))
					;(snd-display #__line__ ";v0: ~A, v1: ~A, diff: ~A, k: ~A, i: ~A" v0 v1 (- v1 v0) k i)
					(throw 'read-write-error)))))))
			   (lambda args 
			     (begin 
			       (snd-display #__line__ ";read-write trouble: ~A ~A (~A != ~A): ~A"
					    (mus-data-format-name (car df-ht))
					    (mus-header-type-name (cadr df-ht))
					    v0 v1 args)
			       (car args))))))))
	    (list (list mus-bshort mus-next)
		  (list mus-bfloat mus-aifc)
		  (list mus-lshort mus-aifc)
		  (list mus-lfloat mus-riff)
		  (list mus-lshort mus-nist)
		  (list mus-bint mus-aiff)
		  (list mus-lint mus-next)
		  (list mus-bintn mus-next)
		  (list mus-lintn mus-next)
		  (list mus-b24int mus-aifc)
		  (list mus-l24int mus-riff)
		  (list mus-bfloat mus-ircam)
		  (list mus-bfloat-unscaled mus-next)
		  (list mus-lfloat-unscaled mus-next)
		  (list mus-bdouble-unscaled mus-next)
		  (list mus-ldouble-unscaled mus-next)
		  (list mus-bdouble mus-next)
		  (list mus-ldouble mus-next)
		  (list mus-ulshort mus-next)
		  (list mus-ubshort mus-next))))
	 (list 1 2 4 8))
	
#|
	;; big sound-data objects (needs 32 Gbytes):
	(if (and (string? (getenv "HOSTNAME"))
		 (string=? (getenv "HOSTNAME") "fatty8"))
	    (let ((size (+ 2 (expt 2 31))))
	      (if (not (= size 2147483650))
		  (snd-display #__line__ ";big sd, size: ~A (~A ~A)" size 2147483650 (- 2147483650 size)))
	      (set! (mus-max-malloc) (expt 2 40))
	      (if (not (= (mus-max-malloc) 1099511627776))
		  (snd-display #__line__ ";big sd, mus-max-malloc: ~A" (mus-max-malloc)))
	      (let ((hi (make-sound-data 1 size)))
		(if (not (sound-data? hi))
		    (snd-display #__line__ ";big sd, not a sound-data?? ~A" hi))
		(if (fneq (sound-data-ref hi 0 (expt 2 31)) 0.0)
		    (snd-display #__line__ ";big sd, created at end: ~A" (sound-data-ref hi 0 (expt 2 31))))
		(if (not (= (sound-data-chans hi) 1))
		    (snd-display #__line__ ";big sd, sound-data-chans: ~A" (sound-data-chans hi)))
		(sound-data+ hi .1)
		(if (fneq (sound-data-ref hi 0 (expt 2 31)) 0.1)
		    (snd-display #__line__ ";big sd, add .1 at end: ~A" (sound-data-ref hi 0 (expt 2 31))))
		(let ((pk (sound-data-peak hi)))
		  (if (fneq pk .1)
		      (snd-display #__line__ ";big sd, sound-data-peak: ~A" pk)))
		(let ((len (sound-data-length hi)))
		  (if (not (= len size))
		      (snd-display #__line__ ";big sd, len: ~A" len)))
		(sound-data-scale! hi 2.0)
		(if (fneq (sound-data-ref hi 0 (+ 1 (expt 2 31))) .2)
		    (snd-display #__line__ ";big sd, scale: ~A ~A" (sound-data-ref hi 0 (+ 1 (expt 2 31))) hi))
		(sound-data-set! hi 0 (expt 2 31) 1.0)
		(if (fneq (sound-data-ref hi 0 (expt 2 31)) 1.0)
		    (snd-display #__line__ ";big sd, set at end: ~A" (sound-data-ref hi 0 (expt 2 31))))
		(sound-data-offset! hi .2)
		(if (fneq (sound-data-ref hi 0 (expt 2 31)) 1.2)
		    (snd-display #__line__ ";big sd, offset: ~A" (sound-data-ref hi 0 (expt 2 31))))
		(let ((pk (sound-data-maxamp hi)))
		  (if (fneq (car pk) 1.2)
		      (snd-display #__line__ ";big sd, subtract sound-data-maxamp: ~A ~A" pk hi)))
		(let ((pk (sound-data-peak hi)))
		  (if (fneq pk 1.2)
		      (snd-display #__line__ ";big sd, sound-data-peak: ~A ~A" pk hi)))
		(sound-data-fill! hi 1.0)
		(if (fneq (sound-data-ref hi 0 (expt 2 31)) 1.0)
		    (snd-display #__line__ ";big sd, fill: ~A ~A" (sound-data-ref hi 0 (expt 2 31)) hi))
		(sound-data-reverse! hi)
		(let ((v (sound-data->vct hi 0)))
		  (if (not (= (vct-length v) size))
		      (snd-display #__line__ ";big sd, sound-data->vct length: ~A" (vct-length v)))
		  (if (fneq (vct-ref v (expt 2 31)) 1.0)
		      (snd-display #__line__ ";big sd, sd->v ref: ~A" (vct-ref v (expt 2 31)))))
		)))
|#
	
	(let ((ind (open-sound (string-append "/usr//usr/include/" home-dir "/cl/oboe.snd"))))
	  (show-input-1)
	  (close-sound ind))
	
	(let ((fd (mus-sound-open-output "fmv.snd" 22050 1 mus-bshort mus-next "no comment"))
	      (sdata (make-sound-data 1 10)))
	  (define (sound-data-channel->list sd chan)
	    (let ((ls '()))
	      (do ((i (- (sound-data-length sd) 1) (- i 1)))
		  ((< i 0) ls)
		(set! ls (cons (sound-data-ref sd chan i) ls)))))
	  (define (sound-data->list sd)
	    (let ((lst '()))
	      (do ((i (- (sound-data-chans sd) 1) (- i 1)))
		  ((< i 0) lst)
		(set! lst (cons (sound-data-channel->list sd i) lst)))))
	  (sound-data-set! sdata 0 1 .1)
	  (mus-sound-write fd 0 9 1 sdata)
	  (mus-sound-close-output fd 20)
	  (set! fd (mus-sound-open-input "fmv.snd"))
	  (mus-sound-read fd 0 9 1 sdata)
	  (if (or (fneq (sound-data-ref sdata 0 0) 0.0)
		  (fneq (sound-data-ref sdata 0 1) 0.1)
		  (fneq (sound-data-ref sdata 0 2) 0.0)
		  (fneq (sound-data-ref sdata 0 6) 0.0))
	      (snd-display #__line__ ";read/write: ~A?" (sound-data->list sdata)))
	  (mus-sound-close-input fd)  
	  (set! fd (mus-sound-reopen-output "fmv.snd" 1 mus-bshort mus-next (mus-sound-data-location "fmv.snd")))
	  (mus-sound-seek-frame fd 0)
	  (sound-data-set! sdata 0 2 .1)
	  (sound-data-set! sdata 0 3 .1)
	  (mus-sound-write fd 0 9 1 sdata)
	  (mus-sound-close-output fd 20)
	  (set! fd (mus-sound-open-input "fmv.snd"))
	  (let ((sdata1 (make-sound-data 1 10)))
	    (mus-sound-read fd 0 9 1 sdata1)
	    (if (or (fneq (sound-data-ref sdata1 0 0) 0.0)
		    (fneq (sound-data-ref sdata1 0 1) 0.1)
		    (fneq (sound-data-ref sdata1 0 2) 0.1)
		    (fneq (sound-data-ref sdata1 0 3) 0.1)
		    (fneq (sound-data-ref sdata1 0 6) 0.0))
		(snd-display #__line__ ";re-read/write: ~A ~A?" (sound-data->list sdata1) (sound-data->lisp sdata))))
	  (mus-sound-close-input fd)
	  
	  ;; check clipping choices
	  (let ((ind (view-sound "oboe.snd")))
	    (set! (clipping) #f)
	    (map-channel (lambda (y) (* y 10.0)) 0 (frames) ind 0)
	    (save-sound-as "test.snd" ind mus-next mus-bfloat)
	    (undo 1 ind 0)
	    (let ((ind1 (open-sound "test.snd")))
	      (if (fneq (maxamp ind1 0) (* 10 (maxamp ind 0)))
		  (snd-display #__line__ ";clipping 0: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	      (close-sound ind1))
	    (delete-file "test.snd")
	    (set! (clipping) #t)
	    (map-channel (lambda (y) (* y 10.0)) 0 (frames) ind 0)
	    (save-sound-as "test.snd" ind mus-next mus-bfloat)
	    (undo 1 ind 0)
	    (let ((ind1 (open-sound "test.snd")))
	      (if (fneq (maxamp ind1 0) 1.0)
		  (snd-display #__line__ ";clipping 1: ~A ~A" (maxamp ind1 0) (maxamp ind 0)))
	      (close-sound ind1))
	    (delete-file "test.snd")
	    (set! (clipping) #f)
	    (let ((mx (maxamp ind)))
	      (map-channel (lambda (y) (+ y (- 1.001 mx))) 0 (frames) ind 0)
	      (save-sound-as "test.snd" ind mus-next mus-bshort)
	      (let* ((ind1 (open-sound "test.snd"))
		     (baddy (scan-channel (lambda (y) (< y 0.0)))))
		(if (not (list-p baddy))
		    (snd-display #__line__ ";clipping 2: ~A" baddy))
		(close-sound ind1))
	      (delete-file "test.snd")
	      (set! (clipping) #t)
	      (save-sound-as "test.snd" ind mus-next mus-bshort)
	      (let* ((ind1 (open-sound "test.snd"))
		     (baddy (scan-channel (lambda (y) (< y 0.0)))))
		(if (list-p baddy)
		    (snd-display #__line__ ";clipping 3: ~A" baddy))
		(close-sound ind1))
	      (delete-file "test.snd")
	      (set! (clipping) #f))
	    (close-sound ind))
	  (delete-file "fmv.snd")
	  
	  (set! (clipping) #f)
	  (let ((snd (new-sound "test.snd" :data-format mus-lshort)))
	    (pad-channel 0 10)
	    (set! (sample 1) 1.0)
	    (set! (sample 2) -1.0)
	    (set! (sample 3) 0.9999)
	    (set! (sample 4) 2.0)
	    (set! (sample 5) -2.0)
	    (set! (sample 6) 1.3)
	    (set! (sample 7) -1.3)
	    (set! (sample 8) 1.8)
	    (set! (sample 9) -1.8)
	    (save-sound snd)
	    (close-sound snd))
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 1.000 -1.000 1.000 -1.000 -1.000 -1.000 -1.000 -1.000 -1.000)))
		  (snd-display #__line__ ";unclipped 1: ~A" data)))
	    (close-sound snd))
	  (mus-sound-forget "test.snd")
	  
	  (set! (clipping) #t)
	  (let ((snd (new-sound "test.snd" :data-format mus-lshort)))
	    (pad-channel 0 10)
	    (set! (sample 1) 1.0)
	    (set! (sample 2) -1.0)
	    (set! (sample 3) 0.9999)
	    (set! (sample 4) 2.0)
	    (set! (sample 5) -2.0)
	    (set! (sample 6) 1.3)
	    (set! (sample 7) -1.3)
	    (set! (sample 8) 1.8)
	    (set! (sample 9) -1.8)
	    (save-sound snd)
	    (close-sound snd))
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 1.000 -1.000 1.000 1.000 -1.000 1.000 -1.000 1.000 -1.000)))
		  (snd-display #__line__ ";clipped: ~A" data)))
	    (close-sound snd))
	  
	  (let* ((data (vct 0.0 1.0 -1.0 0.9999 2.0 -2.0 1.3 -1.3 1.8 -1.8))
		 (sdata (vct->sound-data data))
		 (snd (mus-sound-open-output "test.snd" 22050 1 mus-lshort mus-riff "a comment")))
	    (set! (mus-file-clipping snd) #f)
	    (mus-sound-write snd 0 9 1 sdata)
	    (mus-sound-close-output snd 40))
	  
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 -1.000 -1.000 1.000 -1.000 -1.000 -1.000 -1.000 -1.000 -1.000)))
		  (snd-display #__line__ ";unclipped 2: ~A" data)))
	    (close-sound snd))
	  (mus-sound-forget "test.snd")
	  
	  (let* ((data (vct 0.0 1.0 -1.0 0.9999 2.0 -2.0 1.3 -1.3 1.8 -1.8))
		 (sdata (vct->sound-data data))
		 (snd (mus-sound-open-output "test.snd" 22050 1 mus-lshort mus-riff "a comment")))
	    (set! (mus-file-clipping snd) #t)
	    (mus-sound-write snd 0 9 1 sdata)
	    (set! (mus-file-clipping snd) #f)
	    (mus-sound-close-output snd 40))
	  
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 1.000 -1.000 1.000 1.000 -1.000 1.000 -1.000 1.000 -1.000)))
		  (snd-display #__line__ ";clipped 1: ~A" data)))
	    (close-sound snd))
	  
	  (set! (mus-clipping) #f)
	  (let* ((data (vct 0.0 1.0 -1.0 0.9999 2.0 -2.0 1.3 -1.3 1.8 -1.8))
		 (sdata (vct->sound-data data))
		 (snd (mus-sound-open-output "test.snd" 22050 1 mus-lshort mus-riff "a comment")))
	    (mus-sound-write snd 0 9 1 sdata)
	    (mus-sound-close-output snd 40))
	  
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 -1.000 -1.000 1.000 -1.000 -1.000 -1.000 -1.000 -1.000 -1.000)))
		  (snd-display #__line__ ";unclipped 3: ~A" data)))
	    (close-sound snd))
	  (mus-sound-forget "test.snd")
	  
	  (set! (mus-clipping) #t)
	  (let* ((data (vct 0.0 1.0 -1.0 0.9999 2.0 -2.0 1.3 -1.3 1.8 -1.8))
		 (sdata (vct->sound-data data))
		 (snd (mus-sound-open-output "test.snd" 22050 1 mus-lshort mus-riff "a comment")))
	    (mus-sound-write snd 0 9 1 sdata)
	    (mus-sound-close-output snd 40))
	  
	  (let ((snd (open-sound "test.snd")))
	    (let ((data (channel->vct 0 10)))
	      (if (not (vequal data (vct 0.000 1.000 -1.000 1.000 1.000 -1.000 1.000 -1.000 1.000 -1.000)))
		  (snd-display #__line__ ";clipped 2: ~A" data)))
	    (close-sound snd))
	  
	  (set! (mus-clipping) #t)
	  (let* ((data (vct 0.0 1.0 -1.0 0.9999 2.0 -2.0 1.3 -1.3 1.8 -1.8))
		 (sdata (vct->sound-data data))
		 (snd (mus-sound-open-output "test.snd" 22050 1 mus-lshort mus-riff "a comment")))
	    (let ((tag (catch #t
			      (lambda () (mus-sound-write snd 0 10 1 sdata))
			      (lambda args args))))
	      (if (or (not (list? tag)) (not (eq? (car tag) 'out-of-range))) (snd-display #__line__ ";mus-sound-write too many bytes: ~A" tag)))
	    (let ((tag (catch #t
			      (lambda () (mus-sound-read snd 0 10 1 sdata))
			      (lambda args args))))
	      (if (or (not (list? tag)) (not (eq? (car tag) 'out-of-range))) (snd-display #__line__ ";mus-sound-read too many bytes: ~A" tag)))
	    (mus-sound-close-output snd 0))
	  (delete-file "test.snd")
	  (mus-sound-forget "test.snd")
	  
	  (set! (mus-clipping) #f) ; this is the default
	  (set! (clipping) #f)
	  
	  (let ((com "this is a comment which we'll repeat enough times to trigger an internal loop"))
	    (do ((i 0 (+ 1 i)))
		((= i 3))
	      (set! com (string-append com com)))
	    (set! fd (mus-sound-open-output "fmv.snd" 22050 4 mus-lshort mus-riff com)))
	  (set! sdata (make-sound-data 4 10))
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (sound-data-set! sdata i 1 .1))
	  (mus-sound-write fd 0 9 4 sdata)
	  (mus-sound-close-output fd 80)
	  (set! fd (mus-sound-open-input "fmv.snd"))
	  (mus-sound-read fd 0 9 4 sdata)
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (if (or (fneq (sound-data-ref sdata i 0) 0.0)
		    (fneq (sound-data-ref sdata i 1) 0.1)
		    (fneq (sound-data-ref sdata i 2) 0.0)
		    (fneq (sound-data-ref sdata i 6) 0.0))
		(snd-display #__line__ ";1 read/write[~A]: ~A?" i (sound-data-channel->list sdata i))))
	  (mus-sound-close-input fd)  
	  (set! fd (mus-sound-reopen-output "fmv.snd" 4 mus-lshort mus-riff (mus-sound-data-location "fmv.snd")))
	  (mus-sound-seek-frame fd 0)
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (sound-data-set! sdata i 2 .1)
	    (sound-data-set! sdata i 3 .1))
	  (mus-sound-write fd 0 9 4 sdata)
	  (mus-sound-close-output fd 80)
	  (set! fd (mus-sound-open-input "fmv.snd"))
	  (let ((sdata1 (make-sound-data 4 10)))
	    (mus-sound-read fd 0 9 4 sdata1)
	    (do ((i 0 (+ 1 i)))
		((= i 4))
	      (if (or (fneq (sound-data-ref sdata1 i 0) 0.0)
		      (fneq (sound-data-ref sdata1 i 1) 0.1)
		      (fneq (sound-data-ref sdata1 i 2) 0.1)
		      (fneq (sound-data-ref sdata1 i 3) 0.1)
		      (fneq (sound-data-ref sdata1 i 6) 0.0))
		  (snd-display #__line__ ";2 re-read/write[~A]: ~A ~A?" i (sound-data-channel->list sdata1 i) (sound-data-channel->list sdata i)))))
	  (mus-sound-close-input fd))
	
	(if (file-exists? (string-append sf-dir "32bit.sf"))
	    (let ((ind (open-sound (string-append sf-dir "32bit.sf"))))
	      (if (fneq (maxamp ind 0) .228) (snd-display #__line__ ";32bit max: ~A" (maxamp ind 0)))
	      (close-sound ind)))
	
	(let ((test-data (lambda (file beg dur data)
			   (catch #t
				  (lambda ()
				    (let* ((ind (open-sound file))
					   (ndata (channel->vct beg dur ind 0)))
				      (if (not (vequal data ndata))
					  (snd-display #__line__ ";~A: ~A != ~A" file data ndata))
				      (close-sound ind)))
				  (lambda args args)))))
	  (test-data (string-append sf-dir "next-dbl.snd") 10 10 (vct 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	  (test-data (string-append sf-dir "oboe.ldbl") 1000 10 (vct 0.033 0.035 0.034 0.031 0.026 0.020 0.013 0.009 0.005 0.004))
	  
	  (test-data (string-append sf-dir "next-flt.snd") 10 10 (vct 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	  (test-data (string-append sf-dir "clbonef.wav") 1000 10 (vct 0.111 0.101 0.070 0.032 -0.014 -0.060 -0.085 -0.108 -0.129 -0.152))
	  
	  (test-data (string-append sf-dir "next-8.snd") 10 10 (vct 0.898 0.945 0.977 0.992 0.992 0.977 0.945 0.906 0.844 0.773))
	  (test-data (string-append sf-dir "o2_u8.wave") 1000 10 (vct -0.164 -0.219 -0.258 -0.242 -0.180 -0.102 -0.047 0.000 0.039 0.055))
	  
	  (test-data (string-append sf-dir "next-16.snd") 1000 10 (vct -0.026 -0.022 -0.024 -0.030 -0.041 -0.048 -0.050 -0.055 -0.048 -0.033))
	  (test-data (string-append sf-dir "o2.wave") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  
	  (test-data (string-append sf-dir "o2_18bit.aiff") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "o2_12bit.aiff") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  
	  (test-data (string-append sf-dir "next24.snd") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "mono24.wav") 1000 10 (vct 0.005 0.010 0.016 0.008 -0.007 -0.018 -0.025 -0.021 -0.005 0.001))
	  
	  (test-data (string-append sf-dir "o2_711u.wave") 1000 10 (vct -0.164 -0.219 -0.254 -0.242 -0.172 -0.103 -0.042 0.005 0.042 0.060))
	  (test-data (string-append sf-dir "alaw.wav") 1000 10 (vct -0.024 -0.048 -0.024 0.000 0.008 0.008 0.000 -0.040 -0.064 -0.024))
	  
	  ;; it is not a bug if these don't match if MUS_SAMPLE_BITS is not 24
	  (test-data (string-append sf-dir "b32.pvf") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "b32.wave") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "b32.snd") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "32bit.sf") 1000 10 (vct 0.016 0.014 0.013 0.011 0.010 0.010 0.010 0.010 0.012 0.014))
	  
	  (test-data (string-append sf-dir "nist-shortpack.wav") 10000 10 (vct 0.021 0.018 0.014 0.009 0.004 -0.001 -0.004 -0.006 -0.007 -0.008))
	  (test-data (string-append sf-dir "wood.sds") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	  (test-data (string-append sf-dir "oboe.g721") 1000 10 (vct -0.037 -0.040 -0.040 -0.041 -0.042 -0.038 -0.028 -0.015 -0.005 0.002))
	  (test-data (string-append sf-dir "oboe.g723_40") 1000 10 (vct -0.037 -0.040 -0.041 -0.041 -0.041 -0.038 -0.028 -0.015 -0.005 0.003))
	  (test-data (string-append sf-dir "mus10.snd") 10000 10 (vct 0.004 0.001 0.005 0.009 0.017 0.015 0.008 0.011 0.009 0.012))
	  (test-data (string-append sf-dir "ieee-text-16.snd") 1000 10 (vct -0.052 -0.056 -0.069 -0.077 -0.065 -0.049 -0.054 -0.062 -0.066 -0.074))
	  (test-data (string-append sf-dir "hcom-16.snd") 10000 10 (vct 0.000 0.000 0.000 0.008 0.000 -0.016 -0.016 -0.016 -0.008 0.000))
	  (test-data (string-append sf-dir "ce-c3.w02") 1000 10 (vct 0.581 0.598 0.596 0.577 0.552 0.530 0.508 0.479 0.449 0.425))
	  (test-data (string-append sf-dir "nasahal.avi") 20000 10 (vct 0.390 0.120 -0.399 -0.131 0.464 0.189 -0.458 -0.150 0.593 0.439))
	  (test-data (string-append sf-dir "oki.wav") 100 10 (vct 0.396 0.564 0.677 0.779 0.761 0.540 0.209 -0.100 -0.301 -0.265))
	  
	  (test-data (string-append sf-dir "trumps22.adp") 5000 10 (vct 0.267 0.278 0.309 0.360 0.383 0.414 0.464 0.475 0.486 0.495))
	  )
	
	(let ((errs (list "no error" "no frequency method" "no phase method" "null gen arg to method" "no length method"
			  "no free method" "no describe method" "no data method" "no scaler method"
			  "memory allocation failed" "unstable two pole error"
			  "can't open file" "no sample input" "no sample output"
			  "no such channel" "no file name provided" "no location method" "no channel method"
			  "no such fft window" "unsupported data format" "header read failed"
			  "unsupported header type" "file descriptors not initialized" "not a sound file" "file closed" "write error"
			  "header write failed" "can't open temp file" "interrupted" "bad envelope"
			  "audio channels not available" "audio srate not available" "audio format not available"
			  "no audio input available" "audio configuration not available" 
			  "audio write error" "audio size not available" "audio device not available"
			  "can't close audio" "can't open audio" "audio read error"
			  "can't write audio" "can't read audio" "no audio read permission" 
			  "can't close file" "arg out of range" "wrong type arg"
			  "no channels method" "no hop method" "no width method" "no file-name method" "no ramp method" "no run method"
			  "no increment method" "no offset method"
			  "no xcoeff method" "no ycoeff method" "no xcoeffs method" "no ycoeffs method" "no reset" "bad size" "can't convert"
			  "read error" "no safety method"
			  "can't translate"
			  )))
	  (let ((happy #t)
		(len (length errs)))
	    (do ((i 0 (+ 1 i)))
		((or (not happy) (= i len)))
	      (if (not (string-=? (list-ref errs i) (mus-error-type->string i)))
		  (begin
		    (snd-display #__line__ ";mus-error-type->string ~D: ~A ~A" i (list-ref errs i) (mus-error-type->string i))
		    (set! happy #f))))))
	
					;	  (let ((new-id (mus-make-error "hiho all messed up")))
					;	    (if (not (string=? (mus-error-type->string new-id) "hiho all messed up"))
					;		(snd-display #__line__ ";mus-make-error :~A ~A" new-id (mus-error-type->string new-id))))
	
	(let ((cur-srate (mus-sound-srate "oboe.snd"))
	      (cur-chans (mus-sound-chans "oboe.snd"))
	      (cur-format (mus-sound-data-format "oboe.snd"))
	      (cur-type (mus-sound-header-type "oboe.snd"))
	      (cur-loc (mus-sound-data-location "oboe.snd"))
	      (cur-samps (mus-sound-samples "oboe.snd")))
	  (set! (mus-sound-srate "oboe.snd") (* cur-srate 2))
	  (if (not (= (* cur-srate 2) (mus-sound-srate "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-srate: ~A -> ~A" cur-srate (mus-sound-srate "oboe.snd")))
	  (set! (mus-sound-samples "oboe.snd") (* cur-samps 2))
	  (if (not (= (* cur-samps 2) (mus-sound-samples "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-samples: ~A -> ~A" cur-samps (mus-sound-samples "oboe.snd")))
	  (set! (mus-sound-chans "oboe.snd") (* cur-chans 2))
	  (if (not (= (* cur-chans 2) (mus-sound-chans "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-chans: ~A -> ~A" cur-chans (mus-sound-chans "oboe.snd")))
	  (set! (mus-sound-data-location "oboe.snd") (* cur-loc 2))
	  (if (not (= (* cur-loc 2) (mus-sound-data-location "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-data-location: ~A -> ~A" cur-loc (mus-sound-data-location "oboe.snd")))
	  (set! (mus-sound-header-type "oboe.snd") mus-nist)
	  (if (not (= mus-nist (mus-sound-header-type "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-header-type: ~A -> ~A" cur-type (mus-sound-header-type "oboe.snd")))
	  (set! (mus-sound-data-format "oboe.snd") mus-lintn)
	  (if (not (= mus-lintn (mus-sound-data-format "oboe.snd"))) 
	      (snd-display #__line__ ";set mus-sound-data-format: ~A -> ~A" cur-format (mus-sound-data-format "oboe.snd")))
	  (set! (mus-sound-srate "oboe.snd") cur-srate)
	  (set! (mus-sound-samples "oboe.snd") cur-samps)
	  (set! (mus-sound-chans "oboe.snd") cur-chans)
	  (set! (mus-sound-data-location "oboe.snd") cur-loc)
	  (set! (mus-sound-header-type "oboe.snd") cur-type)
	  (set! (mus-sound-data-format "oboe.snd") cur-format))
	
	(let ((ind (open-sound "oboe.snd")))
	  (save-sound-as "test.wave" ind mus-riff)
	  (save-sound-as "test.rf64" ind mus-rf64)
	  (save-sound-as "test.aifc" ind mus-aifc)
	  (close-sound ind)
	  
	  (for-each
	   (lambda (file)
	     (let ((cur-srate (mus-sound-srate file))
		   (cur-chans (mus-sound-chans file))
		   (cur-format (mus-sound-data-format file))
		   (cur-type (mus-sound-header-type file))
		   (cur-loc (mus-sound-data-location file))
		   (cur-samps (mus-sound-samples file)))
	       (set! (mus-sound-srate file) (* cur-srate 2))
	       (if (not (= (* cur-srate 2) (mus-sound-srate file))) 
		   (snd-display #__line__ ";~A: set mus-sound-srate: ~A -> ~A" file cur-srate (mus-sound-srate file)))
	       (set! (mus-sound-samples file) (* cur-samps 2))
	       (if (not (= (* cur-samps 2) (mus-sound-samples file))) 
		   (snd-display #__line__ ";~A: set mus-sound-samples: ~A -> ~A" file cur-samps (mus-sound-samples file)))
	       (set! (mus-sound-chans file) (* cur-chans 2))
	       (if (not (= (* cur-chans 2) (mus-sound-chans file))) 
		   (snd-display #__line__ ";~A: set mus-sound-chans: ~A -> ~A" file cur-chans (mus-sound-chans file)))
	       (set! (mus-sound-data-location file) (* cur-loc 2))
	       (if (not (= (* cur-loc 2) (mus-sound-data-location file))) 
		   (snd-display #__line__ ";~A: set mus-sound-data-location: ~A -> ~A" file cur-loc (mus-sound-data-location file)))
	       (set! (mus-sound-header-type file) mus-nist)
	       (if (not (= mus-nist (mus-sound-header-type file))) 
		   (snd-display #__line__ ";~A: set mus-sound-header-type: ~A -> ~A" file cur-type (mus-sound-header-type file)))
	       (set! (mus-sound-data-format file) mus-lintn)
	       (if (not (= mus-lintn (mus-sound-data-format file))) 
		   (snd-display #__line__ ";~A: set mus-sound-data-format: ~A -> ~A" file cur-format (mus-sound-data-format file)))
	       (set! (mus-sound-srate file) cur-srate)
	       (set! (mus-sound-samples file) cur-samps)
	       (set! (mus-sound-chans file) cur-chans)
	       (set! (mus-sound-data-location file) cur-loc)
	       (set! (mus-sound-header-type file) cur-type)
	       (set! (mus-sound-data-format file) cur-format)))
	   (list "test.wave" "test.rf64" "test.aifc"))
	  
	  (for-each 
	   (lambda (file)
	     (let ((ind (open-sound file)))
	       (let ((cur-srate (srate ind))
		     (cur-chans (chans ind))
		     (cur-format (data-format ind))
		     (cur-type (header-type ind))
		     (cur-loc (data-location ind))
		     (cur-samps (frames ind)))
		 (set! (srate ind) (* cur-srate 2))
		 (if (not (= (* cur-srate 2) (srate ind))) 
		     (snd-display #__line__ ";~A: set srate: ~A -> ~A" file cur-srate (srate ind)))
		 (set! (frames ind) (* cur-samps 2))
		 (if (not (= (* cur-samps 2) (frames ind))) 
		     (snd-display #__line__ ";~A: set frames: ~A -> ~A" file cur-samps (frames ind)))
		 (set! (chans ind) (* cur-chans 2)) ; this can change the index
		 (let ((xind (find-sound file)))
		   (if (not (equal? ind xind))
		       (set! ind xind)))
		 (if (not (= (* cur-chans 2) (chans ind))) 
		     (snd-display #__line__ ";~A: set chans: ~A -> ~A" file cur-chans (chans ind)))
		 (set! (data-location ind) (* cur-loc 2))
		 (if (not (= (* cur-loc 2) (data-location ind))) 
		     (snd-display #__line__ ";~A: set data-location: ~A -> ~A" file cur-loc (data-location ind)))
		 (set! (header-type ind) mus-nist)
		 (if (not (= mus-nist (header-type ind))) 
		     (snd-display #__line__ ";~A: set header-type: ~A -> ~A" file cur-type (header-type ind)))
		 (set! (data-format ind) mus-lintn)
		 (if (not (= mus-lintn (data-format ind))) 
		     (snd-display #__line__ ";~A: set data-format: ~A -> ~A" file cur-format (data-format ind)))
		 (set! (srate ind) cur-srate)
		 (set! (frames ind) cur-samps)
		 (set! (chans ind) cur-chans)
		 (set! (data-location ind) cur-loc)
		 (set! (header-type ind) cur-type)
		 (set! (data-format ind) cur-format))
	       (close-sound ind))
	     (if (file-exists? file)
		 (delete-file file)))
	   (list "test.wave" "test.rf64" "test.aifc")))
	
	;;	  (with-sound (:output big-file-name :srate 44100 :play #f)
	;;	    (do ((i 0 (+ 1 i))) ((= i 72000))
	;;	      (fm-violin i .1 440 (+ .01 (* (/ i 72000.0) .9)))))
	
	(if with-big-file
	    (let ((probable-frames (floor (* 44100 71999.1)))) ; silence as last .9 secs, so it probably wasn't written
	      (if (not (= (mus-sound-samples big-file-name) 3175160310))
		  (snd-display #__line__ ";bigger samples: ~A" (mus-sound-samples big-file-name)))
	      (if (not (= (mus-sound-frames big-file-name) 3175160310))
		  (snd-display #__line__ ";bigger frames: ~A" (mus-sound-frames big-file-name)))
	      (if (not (= (mus-sound-frames big-file-name) probable-frames))
		  (snd-display #__line__ ";bigger frames: ~A (probable: ~A)" (mus-sound-frames big-file-name) probable-frames))
	      (if (not (= (mus-sound-length big-file-name) 6350320648))
		  (snd-display #__line__ ";bigger bytes: ~A" (mus-sound-length big-file-name)))
	      (if (fneq (mus-sound-duration big-file-name) 71999.1015)
		  (snd-display #__line__ ";bigger dur: ~A" (mus-sound-duration big-file-name)))
	      (let ((ind (open-sound big-file-name)))
		(if (not (= (frames ind) 3175160310)) (snd-display #__line__ ";bigger frames: ~A" (frames ind)))
		(set! big-file-frames (frames ind))
		(if (not (= (frames ind) probable-frames)) (snd-display #__line__ ";bigger frames: ~A (probable: ~A)" (frames ind) probable-frames))
		(if (not (= (frames ind 0 0) big-file-frames)) (snd-display #__line__ ";bigger edpos-frames: ~A" (frames ind)))
		(let ((m1 (add-mark (* 44100 50000) ind)))
		  (if (not (= (mark-sample m1) (* 44100 50000))) (snd-display #__line__ ";bigger mark at: ~A" (mark-sample m1)))
		  (set! (mark-sample m1) (* 44100 66000))
		  (if (not (= (mark-sample m1) (* 44100 66000))) (snd-display #__line__ ";bigger mark to: ~A" (mark-sample m1))))
		(let ((mx (mix-sound "oboe.snd" (* 44100 60000))))
		  (if (mix? mx)
		      (begin
			(if (not (= (mix-position mx) (* 44100 60000))) (snd-display #__line__ ";bigger mix at: ~A" (mix-position mx)))
			(set! (mix-position mx) (* 44100 61000))
			(if (not (= (mix-position mx) (* 44100 61000))) (snd-display #__line__ ";bigger mix to: ~A" (mix-position mx))))
		      (snd-display #__line__ ";no mix tag from mix-sound"))
		  (undo 2))
		(let ((res (find-channel (lambda (y) (not (= y 0.0))))))
		  (if (or (not res)
			  (> (cadr res) 100))
		      (snd-display #__line__ ";bigger find not 0.0: ~A" res)))
		(let ((old-select (selection-creates-region)))
		  (set! (selection-creates-region) #f)
		  (select-all ind)
		  (if (not (= (selection-frames) (frames ind))) (snd-display #__line__ ";bigger select all: ~A ~A" (selection-frames) (frames)))
		  (set! (selection-position) (* 44100 50000))
		  (if (not (= (selection-position) (* 44100 50000))) (snd-display #__line__ ";bigger select pos: ~A" (selection-position)))
		  (set! (selection-position) 0)
		  (set! (selection-frames) (* 44100 65000))
		  (if (not (= (selection-frames) (* 44100 65000))) (snd-display #__line__ ";bigger select len: ~A" (selection-frames)))
		  (set! (selection-creates-region) old-select))
		(set! (cursor ind) (* 44100 50000))
		(if (not (= (cursor ind) (* 44100 50000))) (snd-display #__line__ ";bigger cursor: ~A" (cursor ind)))
		(let ((m1 (add-mark (* 44123 51234) ind)))
		  (if (not (= (mark-sample m1) (* 44123 51234))) (snd-display #__line__ ";bigger mark at: ~A" (mark-sample m1)))
		  (let ((mid (find-mark (* 44123 51234))))
		    (if (or (not (number? mid)) (not (= mid m1))) (snd-display #__line__ ";bigger mark seach: ~A ~A" mid m1))))
		(let ((mx (mix-sound "oboe.snd" (* 44123 61234))))
		  (let ((mxd (find-mix (* 44123 61234))))
		    (if (or (not (number? mxd)) (not (= mxd mx))) (snd-display #__line__ ";bigger find-mix ~A ~A" mxd mx))))
		(set! (cursor ind) (* 44123 51234))
		(if (not (= (cursor ind) (* 44123 51234))) (snd-display #__line__ ";bigger cursor 123: ~A" (cursor ind)))
		(close-sound ind))))
	
	(let ((ind (new-sound "tmp.snd" mus-riff mus-l24int 22050 1 :size 100000))
	      (old-selection-creates-region (selection-creates-region)))
	  (set! (selection-creates-region) #t)
	  (let ((x -0.5) 
		(incr (/ 1.0 (frames)))) 
	    (map-channel (lambda (n) 
			   (let ((val x)) 
			     (set! x (+ x incr)) 
			     val))))
	  (save-sound)
	  (close-sound ind)
	  (set! ind (open-sound "tmp.snd"))
	  (let ((reg (select-all)))
	    (save-selection "tmp1.snd" mus-next mus-l24int)
	    (let ((ind1 (open-sound "tmp1.snd")))
	      (let* ((x -0.5) 
		     (incr (/ 1.0 (frames))) 
		     (err (scan-channel 
			   (lambda (n) 
			     (let ((val x)) 
			       (set! x (+ x incr)) 
			       (fneq val n)))
			   0 100000 ind1)))
		(if err (snd-display #__line__ ";l24 (next) selection not saved correctly? ~A" err)))
	      (close-sound ind1))
	    (save-selection "tmp1.snd" mus-aifc mus-l24int)
	    (let ((ind1 (open-sound "tmp1.snd")))
	      (let* ((x -0.5) 
		     (incr (/ 1.0 (frames))) 
		     (err (scan-channel 
			   (lambda (n) 
			     (let ((val x)) 
			       (set! x (+ x incr)) 
			       (fneq val n)))
			   0 100000 ind1)))
		(if err (snd-display #__line__ ";l24 (aifc) selection not saved correctly? ~A" err)))
	      (close-sound ind1))
	    (save-region reg "tmp1.snd" mus-next mus-l24int)
	    (let ((ind1 (open-sound "tmp1.snd")))
	      (let* ((x -0.5) 
		     (incr (/ 1.0 (frames))) 
		     (err (scan-channel 
			   (lambda (n) 
			     (let ((val x)) 
			       (set! x (+ x incr)) 
			       (fneq val n)))
			   0 100000 ind1)))
		(if err (snd-display #__line__ ";l24 (next) region not saved correctly? ~A" err)))
	      (close-sound ind1))
	    (delete-file "tmp1.snd")
	    (close-sound ind)
	    (delete-file "tmp.snd"))
	  (set! (selection-creates-region) old-selection-creates-region))
	
	(let ((ind (new-sound "tmp.snd" mus-next mus-bfloat 22050 1 :size 10 :comment #f)))
	  (map-channel (lambda (y) 1.0))
	  (env-channel '(0 0 .1 .1 .2 .2 .3 .3 .4 .4 .5 .5 .6 .6 .7 .7 .8 .8 .9  .9))
	  (if (not (vequal (channel->vct) (vct 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900)))
	      (snd-display #__line__ ";ramp env by .1: ~A" (channel->vct)))
	  (close-sound ind))
	))
    
    (reset-hook! open-raw-sound-hook)
    (add-hook! open-raw-sound-hook (lambda (a b) #t))
    (reset-hook! bad-header-hook)
    (add-hook! bad-header-hook (lambda (n) #t))
    (if (hook-empty? open-raw-sound-hook) (snd-display #__line__ ";add-hook open-raw-sound-hook failed??"))
    (if (hook-empty? bad-header-hook) (snd-display #__line__ ";add-hook bad-header-hook failed??"))
    (let* ((magic-words (list ".snd" "FORM" "AIFF" "AIFC" "COMM" "COMT" "INFO" "INST" "inst" "MARK" "SSND"
			      "FVER" "NONE" "ULAW" "ulaw" "ima4" "raw " "sowt" "in32" "in24" "ni23" "fl32"
			      "FL32" "fl64" "twos" "ALAW" "alaw" "APPL" "CLM " "RIFF" "RIFX" "WAVE" "fmt "
			      "data" "fact" "clm " "NIST" "8SVX" "16SV" "Crea" "tive" "SOUN" "D SA" "MPLE"
			      "BODY" "VHDR" "CHAN" "ANNO" "NAME" "2BIT" "HCOM" "FSSD" "%//\n" "%---" "ALaw"
			      "Soun" "MAUD" "MHDR" "MDAT" "mdat" "MThd" "sfbk" "sdta" "shdr" "pdta"
			      "LIST" "GF1P" "ATCH" "$SIG" "NAL_" "GOLD" " SAM" "SRFS" "Diam" "ondW" "CSRE"
			      "SND " "SNIN" "SNDT" "DDSF" "FSMu" "UWFD" "LM89" "SY80" "SY85" "SCRS" "DSPL"
			      "AVI " "strf" "movi" "PRAM" " paf" "fap " "DS16" "HEDR" "HDR8" "SDA_" "SDAB"
			      "SD_B" "NOTE" "file" "=sam" "SU7M" "SU7R" "PVF1" "PVF2" "AUTH" "riff" "TWIN"
			      "IMPS" "SMP1" "Maui" "SDIF" "NVF "))
	   (len (length magic-words))
	   (ctr 0))
      (for-each
       (lambda (magic)
	 (if (hook-empty? open-raw-sound-hook) (snd-display #__line__ ";open-raw-sound-hook cleared??"))
	 (if (hook-empty? bad-header-hook) (snd-display #__line__ ";bad-header-hook cleared??"))
	 (if (file-exists? "test.snd")
	     (delete-file "test.snd"))
	 (mus-sound-forget "test.snd")
	 ;; try random garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ 1 i)))
		 ((= i 128))
	       (write (random 1.0)))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound garbage ~A: ~A -> ~A?" magic tag (file->string "test.snd"))
		 (if (sound? tag) (close-sound tag)))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; try plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 0 (+ 1 i)))
		 ((= i 128))
	       (write (random 128)))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound plausible garbage ~A: ~A?" magic tag)
		 (if (sound? tag) (close-sound tag)))))
	 (delete-file "test.snd")
	 (mus-sound-forget "test.snd")
	 ;; write very plausible garbage
	 (with-output-to-file "test.snd"
	   (lambda ()
	     (display magic)
	     (do ((i 1 (+ 1 i)))
		 ((= i 12))
	       (if (< (+ ctr i) len)
		   (display (list-ref magic-words (+ ctr i)))
		   (display (list-ref magic-words i))))))
	 (let ((tag (catch #t
			   (lambda ()
			     (open-sound "test.snd"))
			   (lambda args (car args)))))
	   (if (and (number? tag)
		    (sound? tag))
	       (begin
		 (snd-display #__line__ ";open-sound very plausible garbage ~A: ~A?" magic tag)
		 (if (sound? tag) (close-sound tag)))))
	 (set! ctr (+ 1 ctr)))
       magic-words))
    (if (file-exists? "test.snd") (delete-file "test.snd"))
    (mus-sound-forget "test.snd")
    
    (with-output-to-file "test.snd"
      (lambda ()
	(display ".snd")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o034) ; location
	(write-byte #o000) (write-byte #o001) (write-byte #o215) (write-byte #o030) ; nominal size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o022) ; format
	(write-byte #o000) (write-byte #o000) (write-byte #o126) (write-byte #o042) ; srate
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; comment
	(write-byte #o000) (write-byte #o001) ; samp 1
	))
    (if (not (= (mus-sound-data-format "test.snd") mus-bshort))
	(snd-display #__line__ ";next 18: ~A" (mus-sound-data-format "test.snd")))
    (delete-file "test.snd")
    (mus-sound-forget "test.snd")
    (with-output-to-file "test.snd"
      (lambda ()
	(display ".snd")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; location
	(write-byte #o000) (write-byte #o001) (write-byte #o215) (write-byte #o030) ; nominal size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o022) ; format
	(write-byte #o000) (write-byte #o000) (write-byte #o126) (write-byte #o042) ; srate
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; comment
	(write-byte #o000) (write-byte #o001) ; samp 1
	))
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
      (if (and (number? tag)
	       (sound? tag))
	  (begin
	    (snd-display #__line__ ";open-sound next bad location ~A: ~A?" (data-location tag) tag)
	    (close-sound tag))))
    (delete-file "test.snd")
    (mus-sound-forget "test.snd")
    (with-output-to-file "test.snd"
      (lambda ()
	(display ".snd")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o034) ; location
	(write-byte #o000) (write-byte #o001) (write-byte #o215) (write-byte #o030) ; nominal size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o122) ; format
	(write-byte #o000) (write-byte #o000) (write-byte #o126) (write-byte #o042) ; srate
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; comment
	(write-byte #o000) (write-byte #o001) ; samp 1
	))
    
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.snd"))
		      (lambda args (car args)))))
      (if (and (number? tag)
	       (sound? tag))
	  (begin
	    (snd-display #__line__ ";open-sound next bad format ~A: ~A?" (data-format tag) tag)
	    (close-sound tag))))
    (delete-file "test.snd")
    (mus-sound-forget "test.snd")
    
    (letrec ((make-aifc-file 
	      (lambda (frames auth-lo bits)
		(with-output-to-file "test.aif"
		  (lambda ()
		    (display "FORM")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o146) ; len
		    (display "AIFCFVER")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
		    (write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
		    (display "COMM")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
		    (write-byte #o000) (write-byte #o001) ; 1 chan
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte frames) ; frames
		    (write-byte #o000) (write-byte bits) ; bits
		    (write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ;
		    ;; srate as 80-bit float (sheesh)
		    (display "NONE") ; compression
		    (write-byte #o016) ; pascal string len
		    (display "not compressed")
		    (write-byte #o000)
		    (display "AUTH")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte auth-lo) ; AUTH chunk size
		    (display "bil")
		    (write-byte #o000)
		    (display "SSND")
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
		    (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
		    (write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
		    )))))
      (if (file-exists? "test.aif") (delete-file "test.aif"))
      (mus-sound-forget "test.aif")
      ;;correct (make-aifc-file #o002 #o004 #o020)
      (make-aifc-file #o102 #o004 #o020)
      (catch #t
	     (lambda ()
	       (let ((ind (open-sound "test.aif")))
		 (if (not (= (frames ind) 2)) (snd-display #__line__ ";bad frames in header: ~A" (frames ind)))
		 (close-sound ind)))
	     (lambda args (snd-display #__line__ args)))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o150 #o020)
      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound aifc no ssnd chunk ~A: ~A?" (data-location tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o000 #o020)
      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound aifc 0-len auth chunk ~A: ~A?" (data-location tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif")
      (make-aifc-file #o002 #o150 #o120)
      (let ((tag (catch #t
			(lambda ()
			  (open-sound "test.aif"))
			(lambda args (car args)))))
	(if (and (number? tag)
		 (sound? tag))
	    (begin
	      (snd-display #__line__ ";open-sound bits 80 ~A: ~A?" (data-format tag) tag)
	      (close-sound tag))))
      (delete-file "test.aif")
      (mus-sound-forget "test.aif"))
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "AUTH")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "bil")
	(write-byte #o000)
	(display "ANNO")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "cat")
	(write-byte #o000)
	(display "NAME")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "dog")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))
    (catch #t
	   (lambda ()
	     (if (not (= (string-length (mus-sound-comment "test.aif")) 15))
		 (snd-display #__line__ ";aifc 3 aux comments: ~A?" (mus-sound-comment "test.aif"))))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "COMT")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(display "bil")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (if (not (string=? (substring (mus-sound-comment "test.aif") 0 3) "bil"))
		 (snd-display #__line__ ";aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif"))))
	   (lambda args (snd-display #__line__ args)))
    (if (not (= (mus-sound-frames "test.aif") 2))
	(snd-display #__line__ ";aifc trailing comt frames: ~A?" (mus-sound-frames "test.aif")))
    (catch #t
	   (lambda ()
	     (let ((ind (open-sound "test.aif")))
	       (if (or (fneq (sample 0) 0.00198)
		       (fneq (sample 1) 0.00195)
		       (fneq (sample 2) 0.0)
		       (fneq (sample 3) 0.0))
		   (snd-display #__line__ ";aifc trailing comt samps: ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	       (close-sound ind)))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o100) (write-byte #o102) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "COMT")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) 
	(display "bil")
	(write-byte #o000)
	))
    (if (or (not (string? (mus-sound-comment "test.aif")))
	    (not (string=? (substring (mus-sound-comment "test.aif") 0 3) "bil")))
	(snd-display #__line__ ";aifc trailing comt comment: ~A?" (mus-sound-comment "test.aif")))
    (if (not (= (mus-sound-frames "test.aif") 2))
	(snd-display #__line__ ";aifc trailing comt (bogus) frames: ~A?" (mus-sound-frames "test.aif")))
    (catch #t
	   (lambda ()
	     (let ((ind (open-sound "test.aif")))
	       (if (or (fneq (sample 0) 0.00198)
		       (fneq (sample 1) 0.00195)
		       (fneq (sample 2) 0.0)
		       (fneq (sample 3) 0.0))
		   (snd-display #__line__ ";aifc trailing comt samps (bogus frame setting): ~A ~A ~A ~A" (sample 0) (sample 1) (sample 2) (sample 3)))
	       (close-sound ind)))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o142) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o100) (write-byte #o102) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.aif"))
		      (lambda args (car args)))))
      (if (and (number? tag)
	       (sound? tag))
	  (begin
	    (snd-display #__line__ ";open-sound aifc 2 ssnd chunks ~A: ~A?" (data-location tag) tag)
	    (close-sound tag))))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o040) ; len
	(display "AIFC")
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o000) (write-byte #o101) (write-byte #o000) (write-byte #o100) ; two samples
	))
    (let ((tag (catch #t
		      (lambda ()
			(open-sound "test.aif"))
		      (lambda args (car args)))))
      (if (not (eq? tag 'mus-error))
	  (begin
	    (snd-display #__line__ ";open-sound aifc no comm chunk ~A?" tag)
	    (if (and (number? tag)
		     (sound? tag))
		(close-sound tag)))))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples
	(display "AUTH")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "bil")
	(write-byte #o000)
	(display "ANNO")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "cat")
	(write-byte #o000)
	(display "NAME")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; AUTH chunk size
	(display "dog")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0: ~A" (gen 0)))
	       (if (fneq (gen 1) 0.50195) (snd-display #__line__ ";file->sample chunked 1: ~A" (gen 1)))
	       (if (fneq (gen 2) 0.0) (snd-display #__line__ ";file->sample chunked eof: ~A" (gen 2)))
	       (if (fneq (gen 3) 0.0) (snd-display #__line__ ";file->sample chunked eof+1: ~A" (gen 3))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (frames file) 2)) (snd-display #__line__ ";chunked frames: ~A" (frames file)))
	       (if (fneq (sample 0) 0.93948) (snd-display #__line__ ";file chunked 0: ~A" (sample 0)))
	       (if (fneq (sample 1) 0.50195) (snd-display #__line__ ";file chunked 1: ~A" (sample 1)))
	       (if (fneq (sample 2) 0.0) (snd-display #__line__ ";file chunked eof: ~A" (sample 2)))
	       (if (fneq (sample 3) 0.0) (snd-display #__line__ ";file chunked eof+1: ~A" (sample 3)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ args)))
    (catch #t
	   (lambda ()
	     (if (not (= (mus-sound-frames "test.aif") 2)) (snd-display #__line__ ";chunked mus-sound-frames: ~A" (mus-sound-frames "test.aif"))))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o001) ; 1 chan
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o002) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "APPL")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte (char->integer #\h))
	(display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0: ~A" (gen 0)))
	       (if (fneq (gen 1) 0.50195) (snd-display #__line__ ";file->sample chunked 1: ~A" (gen 1)))
	       (if (fneq (gen 2) 0.0) (snd-display #__line__ ";file->sample chunked eof: ~A" (gen 2)))
	       (if (fneq (gen 3) 0.0) (snd-display #__line__ ";file->sample chunked eof+1: ~A" (gen 3))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (frames file) 2)) (snd-display #__line__ ";chunked frames: ~A" (frames file)))
	       (if (fneq (sample 0) 0.93948) (snd-display #__line__ ";file chunked 0: ~A" (sample 0)))
	       (if (fneq (sample 1) 0.50195) (snd-display #__line__ ";file chunked 1: ~A" (sample 1)))
	       (if (fneq (sample 2) 0.0) (snd-display #__line__ ";file chunked eof: ~A" (sample 2)))
	       (if (fneq (sample 3) 0.0) (snd-display #__line__ ";file chunked eof+1: ~A" (sample 3)))
	       (if (or (not (string? (comment)))
		       (not (string=? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")))
		   (snd-display #__line__ ";chunked appl comment: ~A" (comment)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (with-output-to-file "test.aif"
      (lambda ()
					;write AIFC with trailing chunks to try to confuse file->sample
	(display "FORM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o176) ; len
	(display "AIFCFVER")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o004) ; version chunk size
	(write-byte #o242) (write-byte #o200) (write-byte #o121) (write-byte #o100) ; version  
	(display "SSND")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o014) ; SSND chunk size
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; SSND data loc
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; block size?
	(write-byte #o170) (write-byte #o101) (write-byte #o100) (write-byte #o100) ; two samples (one frame)
	(display "COMM")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o046) ; COMM chunk size
	(write-byte #o000) (write-byte #o002) ; 2 chans
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o001) ; frames
	(write-byte #o000) (write-byte #o020) ; bits
	(write-byte #o100) (write-byte #o016) (write-byte #o254) (write-byte #o104) (write-byte #o000) 
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte #o000) ; srate as 80-bit float (sheesh)
	(display "NONE") ; compression
	(write-byte #o016) ; pascal string len
	(display "not compressed")
	(write-byte #o000)
	(display "APPL")
	(write-byte #o000) (write-byte #o000) (write-byte #o000) (write-byte (char->integer #\h))
	(display "CLM ;Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")
	(write-byte #o000)
	))
    (catch #t
	   (lambda ()
	     (let ((gen (make-file->sample "test.aif")))
	       (if (fneq (gen 0 0) 0.93948) (snd-display #__line__ ";file->sample chunked 0 0: ~A" (gen 0 0)))
	       (if (fneq (gen 0 1) 0.50195) (snd-display #__line__ ";file->sample chunked 0 1: ~A" (gen 0 1)))
	       (if (fneq (gen 1 0) 0.0) (snd-display #__line__ ";file->sample chunked eof(stereo): ~A" (gen 1 0)))
	       (if (fneq (gen 1 1) 0.0) (snd-display #__line__ ";file->sample chunked eof+1 (stereo): ~A" (gen 1 1))))
	     (let ((file (open-sound "test.aif")))
	       (if (not (= (frames file) 1)) (snd-display #__line__ ";chunked frames (1): ~A" (frames file)))
	       (if (fneq (sample 0 file 0) 0.93948) (snd-display #__line__ ";file chunked 0 0: ~A" (sample 0 file 0)))
	       (if (fneq (sample 0 file 1) 0.50195) (snd-display #__line__ ";file chunked 0 1: ~A" (sample 0 file 1)))
	       (if (fneq (sample 1 file 0) 0.0) (snd-display #__line__ ";file chunked eof (stereo): ~A" (sample 1 file 0)))
	       (if (fneq (sample 1 file 1) 0.0) (snd-display #__line__ ";file chunked eof+1 (stereo): ~A" (sample 1 file 1)))
	       (if (or (not (string? (comment)))
		       (not (string=? (comment) ";Written Mon 02-Nov-98 01:44 CST by root at ockeghem (Linux/X86) using Allegro CL, clm of 20-Oct-98")))
		   (snd-display #__line__ ";chunked appl comment (stereo): ~A" (comment)))
	       (close-sound file)))
	   (lambda args (snd-display #__line__ args)))
    (delete-file "test.aif")
    (mus-sound-forget "test.aif")
    
    (let ((files (sound-files-in-directory cwd)))
      (if (null? files) (snd-display #__line__ ";no sound files in ~A?" cwd))
      (let ((files1 (sound-files-in-directory)))
	(if (not (equal? files files1)) (snd-display #__line__ ";different sound files in ~A and default?" cwd))
	(let ((files2 (sound-files-in-directory ".")))
	  (if (or (not (equal? files1 files2))
		  (not (equal? files files2)))
	      (snd-display #__line__ ";sound-files-in-directory dot: ~A but ~A" files2 files)))))
    
    (reset-hook! bad-header-hook)
    (reset-hook! open-raw-sound-hook)
    (if (not (null? (sounds))) (for-each close-sound (sounds)))
    
    (let ((ind (new-sound :size 0)))
      (if (not (= (frames ind) 0)) (snd-display #__line__ ";new-sound :size 0 -> ~A frames" (frames ind)))
      (if (fneq (sample 0) 0.0) (snd-display #__line__ ";new-sound :size 0 sample 0: ~A" (sample 0)))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    (let ((ind (new-sound :size 1)))
      (if (not (= (frames ind) 1)) (snd-display #__line__ ";new-sound :size 1 -> ~A frames" (frames ind)))
      (if (fneq (sample 0) 0.0) (snd-display #__line__ ";new-sound :size 1 sample 0: ~A" (sample 0)))
      (let ((new-file-name (file-name ind)))
	(close-sound ind)
	(if (file-exists? new-file-name) (delete-file new-file-name))))
    (let ((tag (catch #t
		      (lambda () (new-sound :size -1))
		      (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (begin
	    (snd-display #__line__ ";new-sound :size -1: ~A" tag)
	    (if (not (null? (sounds))) (for-each close-sound (sounds))))))
    
    (let ((ind (read-ascii (string-append sf-dir "caruso.asc"))))
      (if (not (sound? ind)) 
	  (snd-display #__line__ ";read-ascii can't find ~A (~A)" (string-append sf-dir "caruso.asc") (map file-name (sounds)))
	  (begin
	    (if (fneq (maxamp ind 0) 0.723) (snd-display #__line__ ";read-ascii maxamp: ~A" (maxamp ind 0)))
	    (if (not (= (frames ind 0) 50000)) (snd-display #__line__ ";read-ascii frames: ~A" (frames ind 0)))
	    (if (not (= (srate ind) 44100)) (snd-display #__line__ ";read-ascii srate: ~A" (srate ind)))
	    (set! (srate ind) 8000)
	    (if (or (not (= (frames ind 0) 50000))
		    (fneq (maxamp ind 0) .723))
		(snd-display #__line__ ";set srate clobbered new sound: ~A ~A (~A)" (frames ind 0) (maxamp ind 0) (srate ind)))
	    
	    (close-sound ind))))
    
    (let ((ind (open-sound "oboe.snd")))
      (save-sound-as "test space.snd")
      (close-sound ind)
      (set! ind (open-sound "test space.snd"))
      (if (not (string=? (short-file-name ind) "test space.snd"))
	  (snd-display #__line__ ";file name with space: ~A" (short-file-name ind)))
      (let ((len (frames ind))
	    (slen (mus-sound-frames "test space.snd")))
	(if (not (= len slen)) (snd-display #__line__ ";spaced filename frames: ~A ~A" len slen)))
      (add-mark 1234 ind 0)
      (save-marks ind) ; should write "test space.marks"
      (close-sound ind)
      (set! ind (open-sound "test space.snd"))
      (load (string-append cwd "test space.marks"))
      (if (not (find-mark 1234 ind))
	  (snd-display #__line__ ";space file name save marks: ~A" (marks ind)))
      (let ((rd (make-readin :file "test space.snd")))
	(if (not (string=? (mus-file-name rd) "test space.snd"))
	    (snd-display #__line__ ";file name with space readin: ~A" (mus-file-name rd))))
      (close-sound ind)
      (if (file-exists? "test space.snd")
	  (delete-file "test space.snd"))
      (if (file-exists? "test space.marks")
	  (delete-file "test space.marks")))
    
    (if (provided? 'snd-threads)
	(let ((old-file-buffer-size *clm-file-buffer-size*))
	  
	  (let* ((result (with-threaded-sound ()
					      (outa 0 0.5)
					      (outa 1 0.25)
					      (outa 2 0.125)
					      (outa 3 -0.5)))
		 (snd (find-sound result)))
	    (if (not (sound? snd)) 
		(snd-display #__line__ ";with-threaded-sound 0 no output: ~A ~A" result snd)
		(let ((samps (channel->vct 0 (frames snd) snd 0)))
		  (if (not (vequal samps (vct 0.5 0.25 0.125 -0.5)))
		      (snd-display #__line__ ";with-threaded-sound 0 output: ~A" samps)))))
	  
	  (let* ((result (with-threaded-sound ()
					      (outa 0 0.5)
					      (outa 1 0.25)
					      (outa 2 0.125)
					      (outa 3 -0.5)
					      (outa 4 -0.25)
					      (outa 5 -0.125)))
		 (snd (find-sound result)))
	    (if (not (sound? snd)) 
		(snd-display #__line__ ";with-threaded-sound 0a no output: ~A ~A" result snd)
		(let ((samps (channel->vct 0 (frames snd) snd 0)))
		  (if (not (vequal samps (vct 0.5 0.25 0.125 -0.5 -0.25 -0.125)))
		      (snd-display #__line__ ";with-threaded-sound 0a output: ~A" samps)))))
	  
	  (let* ((result (with-threaded-sound ()
					      (outa 0 0.5)
					      (outa 1 0.25)
					      (outa 1 -0.5)))
		 (snd (find-sound result)))
	    (if (not (sound? snd)) 
		(snd-display #__line__ ";with-threaded-sound 0b no output: ~A ~A" result snd)
		(let ((samps (channel->vct 0 (frames snd) snd 0)))
		  (if (not (vequal samps (vct 0.5 -0.25)))
		      (snd-display #__line__ ";with-threaded-sound 0b output: ~A" samps)))))
	  
	  (let ((samps (make-vct 512)))
	    (run 
	     (do ((i 0 (+ 1 i)))
		 ((= i 512))
	       (vct-set! samps i (- (random 2.0) 1.0))))
	    (let* ((result (with-threaded-sound (:channels 2)
						(out-samps 0 0 samps)
						(out-samps 0 1 samps)))
		   (snd (find-sound result)))
	      (if (not (sound? snd)) 
		  (snd-display #__line__ ";with-threaded-sound 1 no output: ~A ~A" result snd)
		  (let ((new-samps-0 (channel->vct 0 (frames snd) snd 0))
			(new-samps-1 (channel->vct 0 (frames snd) snd 1)))
		    (if (not (vequal samps new-samps-0))
			(snd-display #__line__ ";with-threaded-sound 1 chan 0 output differs"))
		    (if (not (vequal samps new-samps-1))
			(snd-display #__line__ ";with-threaded-sound 1 chan 1 output differs"))))))
	  
	  (for-each
	   (lambda (buflen)
	     (set! *clm-file-buffer-size* buflen)
	     (let* ((len 1000000)
		    (samps (make-vct len)))
	       (run 
		(do ((i 0 (+ 1 i)))
		    ((= i len))
		  (vct-set! samps i (- (random 2.0) 1.0))))
	       (let* ((result (with-threaded-sound (:channels 2)
						   (out-samps 0 0 samps)
						   (out-samps 0 1 samps)))
		      (snd (find-sound result)))
		 (if (not (sound? snd)) 
		     (snd-display #__line__ ";with-threaded-sound 2 (~D) no output: ~A ~A" buflen result snd)
		     (let ((new-samps-0 (channel->vct 0 (frames snd) snd 0))
			   (new-samps-1 (channel->vct 0 (frames snd) snd 1)))
		       (if (not (vequal samps new-samps-0))
			   (snd-display #__line__ ";with-threaded-sound 2 (~D) chan 0 output differs" buflen))
		       (if (not (vequal samps new-samps-1))
			   (snd-display #__line__ ";with-threaded-sound 2 (~D) chan 1 output differs" buflen)))))))
	   (list 65536 8192 1024 256 1234))
	  (set! *clm-file-buffer-size* old-file-buffer-size)
	  (set! (mus-file-buffer-size) old-file-buffer-size)	  
	  
	  (let ((samps (make-vct 512)))
	    (run
	     (do ((i 0 (+ 1 i)))
		 ((= i 512))
	       (vct-set! samps i (- (random 2.0) 1.0))))
	    (with-threaded-sound (:channels 1 :output "thread-test.snd")
				 (out-samps 0 0 samps))
	    (let* ((inp (make-file->sample "thread-test.snd"))
		   (inres (make-vct 512))
		   (result (with-threaded-sound ()
						(do ((i 0 (+ 1 i)))
						    ((= i 512))
						  (let ((val (ina i inp)))
						    (vct-set! inres i val)
						    (outa i val)))))
		   (snd (find-sound result)))
	      (if (not (sound? snd)) 
		  (snd-display #__line__ ";with-threaded-sound 3 no output: ~A ~A" result snd)
		  (let ((new-samps-0 (channel->vct 0 (frames snd) snd 0)))
		    (if (not (vequal samps new-samps-0))
			(snd-display #__line__ ";with-threaded-sound 3 output differs"))
		    (if (not (vequal samps inres))
			(snd-display #__line__ ";with-threaded-sound 3 input differs"))))
	      (close-sound snd)
	      (set! snd (find-sound "thread-test.snd"))
	      (if (sound? snd) (close-sound snd))
	      (delete-file "thread-test.snd")))
	  
	  (let ((samps (make-vct 512)))
	    (run
	     (do ((i 0 (+ 1 i)))
		 ((= i 512))
	       (vct-set! samps i (- (random 2.0) 1.0))))
	    (let* ((result (with-threaded-sound (:channels 1)
						(out-samps 0 0 samps)
						(out-samps-invert 0 0 samps)))
		   (snd (find-sound result)))
	      (if (not (sound? snd)) 
		  (snd-display #__line__ ";with-threaded-sound 4 no output: ~A ~A" result snd)
		  (let ((new-samps-0 (channel->vct 0 (frames snd) snd 0)))
		    (if (fneq (vct-peak new-samps-0) 0.0)
			(snd-display #__line__ ";with-threaded-sound 4 chan 1 output differs"))))))
	  
	  (for-each
	   (lambda (buflen)
	     (set! *clm-file-buffer-size* buflen)
	     (let* ((len 1000000)
		    (samps (make-vct len)))
	       (run
		(do ((i 0 (+ 1 i)))
		    ((= i len))
		  (vct-set! samps i (- (random 2.0) 1.0))))
	       (let* ((result (with-threaded-sound (:channels 1)
						   (out-samps 0 0 samps)
						   (out-samps-invert 0 0 samps)))
		      (snd (find-sound result)))
		 (if (not (sound? snd)) 
		     (snd-display #__line__ ";with-threaded-sound 5 (~D) no output: ~A ~A" buflen result snd)
		     (let ((new-samps-0 (channel->vct 0 (frames snd) snd 0)))
		       (if (fneq (vct-peak new-samps-0) 0.0)
			   (snd-display #__line__ ";with-threaded-sound 5 chan 1 output differs")))))))
	   (list 65536 8192 1024 256 1234))
	  (set! *clm-file-buffer-size* old-file-buffer-size)
	  (set! (mus-file-buffer-size) old-file-buffer-size)
	  (for-each (lambda (snd) (close-sound snd)) (sounds))
	  ))
    
    (if (file-is-directory? "oboe.snd") (snd-display #__line__ ";file-is-directory? oboe.snd!"))
    (if (not (file-is-directory? ".")) (snd-display #__line__ ";file-is-directory? . #f!"))
    (if (not (getenv "PATH")) (snd-display #__line__ ";getenv: no PATH?"))
    (if (not (number? (getpid))) (snd-display #__line__ ";getpid: ~A" (getpid)))
    
    (if (not (list? (global-environment))) (snd-display #__line__ ";global-environment not a list?: ~A" (global-environment)))
    
    (let ((ip (current-input-port)))
      (let ((tag (catch #t (lambda () (set-current-input-port "hiho!")) (lambda args (car args)))))
	(if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-input-port tag: ~A" tag))
	(if (not (equal? ip (current-input-port))) (snd-display #__line__ ";set-current-input-port clobbered port? ~A ~A" ip (current-input-port)))))
    
    (let ((ip (current-output-port)))
      (let ((tag (catch #t (lambda () (set-current-output-port "hiho!")) (lambda args (car args)))))
	(if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-output-port tag: ~A" tag))
	(if (not (equal? ip (current-output-port))) (snd-display #__line__ ";set-current-output-port clobbered port? ~A ~A" ip (current-output-port)))))
    
    (let ((ip (current-error-port)))
      (let ((tag (catch #t (lambda () (set-current-error-port "hiho!")) (lambda args (car args)))))
	(if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";set-current-error-port tag: ~A" tag))
	(if (not (equal? ip (current-error-port))) (snd-display #__line__ ";set-current-error-port clobbered port? ~A ~A" ip (current-error-port)))))
    
    (if (not (provided? 'gmp))
	(let* ((LONG_MAX 2147483647)
	       (LONG_MIN -2147483648)
	       (LLONG_MAX most-positive-fixnum)
	       (LLONG_MIN most-negative-fixnum)
	       (ints (list 0 1 -1 10 -10 1234 -1234 LONG_MAX LONG_MIN 65536 -65536))
	       (shorts (list 0 1 -1 10 -10 1234 -1234 32767 -32768 8191 -8191))
	       (longs (list 0 1 -1 11 -11 LONG_MAX LONG_MIN LLONG_MAX LLONG_MIN 1000 -1000))
	       (floats (list 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003))
	       (doubles (list 0.0 1.0 -1.0 0.1 -0.1 10.0 -10.0 1234.0 65536.0 -1234.0 -0.003)))
	  (load "binary-io.scm")
	  
	  (with-output-to-file "idf1.data"
	    (lambda ()
	      
	      (write-lint32 123)
	      (write-bint32 321)
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint32 (list-ref ints i))
		(write-bint32 (list-ref ints i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint16 (list-ref shorts i))
		(write-bint16 (list-ref shorts i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lint64 (list-ref longs i))
		(write-bint64 (list-ref longs i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lfloat32 (list-ref floats i))
		(write-bfloat32 (list-ref floats i)))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(write-lfloat64 (list-ref doubles i))
		(write-bfloat64 (list-ref doubles i)))
	      ))
	  
	  (with-input-from-file "idf1.data" 
	    (lambda ()
	      
	      (define (testf val1 val2 name)
		(if (not (= val1 val2))
		    (if (and (not (eq? name 'lfloat32))
			     (not (eq? name 'bfloat32)))
			(format #t ";~A: ~A != ~A~%" name val1 val2)
			(if (> (abs (- val1 val2)) 1.0e-6)
			    (format #t ";~A: ~A != ~A (~A)~%" name val1 val2 (abs (- val1 val2)))))))
	      
	      (testf (read-lint32) 123 'lint32)
	      (testf (read-bint32) 321 'bint32)
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint32) (list-ref ints i) 'lint32)
		(testf (read-bint32) (list-ref ints i) 'bint32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint16) (list-ref shorts i) 'lint16)
		(testf (read-bint16) (list-ref shorts i) 'bint16))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lint64) (list-ref longs i) 'lint64)
		(testf (read-bint64) (list-ref longs i) 'bint64))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat32) (list-ref floats i) 'lfloat32)
		(testf (read-bfloat32) (list-ref floats i) 'bfloat32))
	      
	      (do ((i 0 (+ i 1)))
		  ((= i 11))
		(testf (read-lfloat64) (list-ref doubles i) 'lfloat64)
		(testf (read-bfloat64) (list-ref doubles i) 'bfloat64))
	      ))
	  ))
    ))



;;; ---------------- test 5: simple overall checks ----------------

(if (not (provided? 'snd-selection.scm)) (load "selection.scm"))
(if (not (provided? 'snd-extensions.scm)) (load "extensions.scm"))
(if (not (provided? 'snd-selection.scm)) (load "selection.scm"))
(if (not (provided? 'snd-dsp.scm)) (load "dsp.scm"))
(if (not (provided? 'snd-pvoc.scm)) (load "pvoc.scm"))
(if (and with-gui (not (provided? 'snd-edit-menu.scm))) (load "edit-menu.scm"))

(define* (cosine-channel-via-ptree (beg 0) dur snd chn edpos)
  ;; vct: angle increment
  (ptree-channel
   (lambda (y data forward)
     (let* ((angle (vct-ref data 0))
	    (incr (vct-ref data 1))
	    (val (* y (cos angle))))
       (if forward
	   (vct-set! data 0 (+ angle incr))
	   (vct-set! data 0 (- angle incr)))
       val))
   beg dur snd chn edpos #t
   (lambda (frag-beg frag-dur)
     (let ((incr (/ pi frag-dur)))
       (vct (+ (* -0.5 pi) (* frag-beg incr))
	    incr)))))

(define old-opt-val (optimization))

(define (snd_test_5)
  (define a-ctr 0)
  (define g-init-val 0)
  
  (define (append-sound filename)
    (insert-sound filename (frames)))
  
  (define (test-edpos test-func func-name change-thunk ind1)
    (let ((fr1 (test-func ind1 0))
	  (fr2 (test-func ind1 0 0))
	  (fr3 (test-func ind1 0 current-edit-position))
	  (fr4 (test-func ind1 0 (lambda (snd chn) 0))))
      (if (not (and (= fr1 fr2)
		    (= fr1 fr3)
		    (= fr1 fr4)))
	  (snd-display #__line__ ";initial ~A: ~A ~A ~A ~A?" func-name fr1 fr2 fr3 fr4))
      (change-thunk)
      (let ((fr5 (test-func ind1 0))
	    (fr6 (test-func ind1 0 1))
	    (fr7 (test-func ind1 0 current-edit-position))
	    (fr8 (test-func ind1 0 (lambda (snd chn) (edit-position snd chn)))))
	(if (not (and (= fr5 fr6)
		      (= fr5 fr7)
		      (= fr5 fr8)))
	    (snd-display #__line__ ";~A (edpos 1): ~A ~A ~A ~A?" func-name fr5 fr6 fr7 fr8))
	(set! fr5 (test-func ind1 0 0))
	(set! fr6 (test-func ind1 0 (lambda (snd chn) 0)))
	(if (not (and (= fr1 fr5)
		      (= fr1 fr6)))
	    (snd-display #__line__ ";~A (edpos -1): ~A ~A ~A?" func-name fr1 fr5 fr6))))
    (revert-sound ind1))
  
  (define (test-edpos-1 test-func func-name ind1)
    (let ((v0 (channel->vct 12000 10 ind1 0)))
      (test-func ind1 0)
      (let ((v1 (channel->vct 12000 10 ind1 0)))
	(if (vequal v0 v1)
	    (snd-display #__line__ ";~A (0) no change! ~A ~A" func-name v0 v1))
	(test-func ind1 0)
	(let ((v2 (channel->vct 12000 10 ind1 0)))
	  (if (not (vequal v1 v2))
	      (snd-display #__line__ ";~A (1) ~A ~A" func-name v1 v2))
	  (test-func ind1 (lambda (snd chn) 0))
	  (set! v2 (channel->vct 12000 10 ind1 0))
	  (if (not (vequal v1 v2))
	      (snd-display #__line__ ";~A (2) ~A ~A" func-name v1 v2)))))
    (revert-sound ind1))
  
  (define (vfequal v0 v1)
    (define (dequal ctr len)
      (if (= ctr len)
	  #t
	  (and (< (abs (- (vct-ref v0 ctr) (vct-ref v1 ctr))) .01)
	       (dequal (+ 1 ctr) len))))
    (let ((len (vct-length v0)))
      (and (= len (vct-length v1))
	   (dequal 0 len))))
  
  (define (test-orig func0 func1 func-name ind1)
    (let ((v0 (channel->vct 12000 10 ind1 0)))
      (func0 ind1)
      (let ((v1 (channel->vct 12000 10 ind1 0)))
	(if (vfequal v0 v1)
	    (snd-display #__line__ ";~A (orig: 0) no change! ~A ~A" func-name v0 v1))
	(func1 ind1)
	(let ((v2 (channel->vct 12000 10 ind1 0)))
	  (if (not (vfequal v0 v2))
	      (snd-display #__line__ ";~A (orig: 1) ~A ~A" func-name v0 v2))))
      (revert-sound ind1)))
  
  (define* (make-bandpass-2 flo1 fhi1 flo2 fhi2 (len 30))
    (let* ((f1 (make-bandpass flo1 fhi1 len))
	   (f2 (make-bandpass flo2 fhi2 len)))
      (vct-add! (mus-xcoeffs f1) (mus-xcoeffs f2))
      f1))
  
  (define* (cosine-channel (beg 0) dur snd chn edpos)
    (let ((old-opt (optimization))
	  (samps (or dur (frames snd chn))))
      (set! (optimization) 0)
      (map-channel
       (let* ((incr (/ pi samps))
	      (angle (* -0.5 pi)))
	 (lambda (y)
	   (let ((val (* y (cos angle))))
	     (set! angle (+ angle incr))
	     val)))
       beg dur snd chn edpos)
      (set! (optimization) old-opt)))
  
  (define (check-maxamp ind val name)
    (if (fneq (maxamp ind 0) val) (snd-display #__line__ ";maxamp amp-env ~A: ~A should be ~A" name (maxamp ind) val))
    (let ((pos (find-channel (lambda (y) (>= (abs y) (- val .0001)))))
	  (maxpos (maxamp-position ind 0)))
      (if (not pos) 
	  (snd-display #__line__ ";actual maxamp ~A vals not right" name)
	  (if (not (= maxpos (cadr pos)))
	      (snd-display #__line__ ";~A: find and maxamp-position disagree: ~A (~A) ~A (~A)" 
			   name pos (sample (cadr pos) ind 0) maxpos (sample maxpos ind 0))))
      (let ((mx 0.0)
	    (ctr 0)
	    (mpos 0))
	(scan-chan (lambda (y) 
		     (if (> (abs y) mx)
			 (begin
			   (set! mpos ctr)
			   (set! mx (abs y))))
		     (set! ctr (+ 1 ctr))
		     #f))
	(if (not (= mpos maxpos))
	    (snd-display #__line__ ";scan-chan and maxamp-position disagree: ~A ~A" mpos maxpos))
	(if (fneq mx val) (snd-display #__line__ ";actual ~A max: ~A (correct: ~A)" name mx val)))))
  
  (define (check-env-vals name gen)
    (let ((ctr -1))
      (scan-chan (lambda (y)
		   (let ((val (env gen)))
		     (set! ctr (+ 1 ctr))
		     (if (fneq val y)
			 (begin
			   (display (format #f "~%;check-env-vals ~A at ~D: ~A ~A" name ctr val y))
			   #t)
			 #f))))))
  
  (define (our-x->position ind x) 
    (let ((ax (axis-info ind 0)))
      (list
       (+ (list-ref ax 10) 
	  (/ (* (- x (list-ref ax 2))
		(- (list-ref ax 12) (list-ref ax 10)))
	     (- (list-ref ax 4) (list-ref ax 2))))
       (x->position x ind))))
  
  (define (region-to-vct r c len)
    (let* ((rs (make-region-sampler r 0 c))
	   (v (make-vct len)))
      (do ((i 0 (+ 1 i)))
	  ((= i len) v)
	(vct-set! v i (next-sample rs)))))
  
  (define (region2vct r c len)
    (region->vct r 0 len c))
  
  ;; extensions.scm (commented out)
  (define* (delay-channel dly (beg 0) dur snd chn edpos)
    (let ((cur-edpos (if (or (not edpos)
			     (= edpos current-edit-position))
			 (edit-position snd chn)
			 edpos)))
      (ptree-channel (lambda (y data dir)
		       (let* ((pos (floor (vct-ref data 0)))
			      (len (floor (vct-ref data 1)))
			      (val (vct-ref data (+ pos 2))))
			 (vct-set! data (+ pos 2) y)
			 (set! pos (+ 1 pos))
			 (if (>= pos len) (vct-set! data 0 0) (vct-set! data 0 pos))
			 val))
		     beg dur snd chn edpos #f
		     (lambda (fpos fdur)
		       (let ((data (make-vct (+ dly 2))))
			 (vct-set! data 0 0.0)
			 (vct-set! data 1 dly)
			 (if (= fpos 0)
			     data
			     (let* ((reader (make-sampler (- fpos 1) snd chn -1 cur-edpos)))
			       (do ((i (- dly 1) (- i 1)))
				   ((< i 0))
				 (vct-set! data (+ i 2) (reader)))
			       data)))))))
  
  (begin
    
    (set! (optimization) max-optimization) ; these trees assume optimization is on
    
    (if (playing) (snd-display #__line__ ";dac is running??"))
    (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
      (log-mem clmtest)
      
      (let ((ind (open-sound "oboe.snd")))
	(set! (transform-graph? ind 0) #t)
	(set! (transform-graph-type ind 0) graph-as-sonogram)
	(catch 'no-such-axis
	       (lambda ()
		 (set! (y-axis-label ind 0 1) "hiho"))
	       (lambda args
		 (snd-display #__line__ ";no fft axis: ~A" args)))
	(set! (fft-log-frequency ind 0) #t) ; segfault here originally
	(update-transform-graph ind 0)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" :size 10)))
	(vct->channel (make-vct 10 1.0))
	(env-channel '(0 0 1 1 2 0))
	(let ((data (channel->vct)))
	  (if (not (vequal data (vct 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";pyr 10: ~A" data)))
	(undo)
	(env-channel '((0 0) (1 1) (2 0)))
	(let ((data (channel->vct)))
	  (if (not (vequal data (vct 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";pyr 10: ~A" data)))
	(undo)
	(env-channel (make-env '(0 0 1 1 2 0) :length 10))
	(let ((data (channel->vct)))
	  (if (not (vequal data (vct 0.000 0.200 0.400 0.600 0.800 1.000 0.750 0.500 0.250 0.000)))
	      (snd-display #__line__ ";pyr 10: ~A" data)))
	(undo)
	(close-sound ind))
      
      (for-each
       (lambda (size)
	 (let ((ind (new-sound "test.snd" :size size))
	       (incr (/ 1.0 (- size 1)))
	       (e (make-env '(0 0 1 1) :length size)))
	   (vct->channel (make-vct size 1.0))
	   
	   (ramp-channel 0.0 1.0)
	   (let ((data (channel->vct)))
	     (if (or (fneq (vct-ref data 0) 0.0)
		     (fneq (vct-ref data (- size 1)) 1.0))
		 (snd-display #__line__ ";ramp-channel ~A end points: ~A ~A" size (vct-ref data 0) (vct-ref data (- size 1))))
	     (do ((i 0 (+ 1 i)))
		 ((= i size))
	       (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0)))
		     (segval (env e)))
		 (if (or (fneq segval val)
			 (fneq (vct-ref data i) val))
		     (snd-display #__line__ ";ramp-channel ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (vct-ref data i) val segval)))))
	   (undo)
	   (xramp-channel 0.0 1.0 32.0)
	   (let ((e (make-env '(0 0 1 1) :length size :base 32.0)))
	     (let ((data (channel->vct)))
	       (if (or (fneq (vct-ref data 0) 0.0)
		       (fneq (vct-ref data (- size 1)) 1.0))
		   (snd-display #__line__ ";xramp-channel 32 ~A end points: ~A ~A" size (vct-ref data 0) (vct-ref data (- size 1))))
	       (do ((i 0 (+ 1 i)))
		   ((= i size))
		 (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 32.0))
		       (segval (env e)))
		   (if (or (fneq segval val)
			   (fneq (vct-ref data i) val))
		       (snd-display #__line__ ";xramp-channel 32 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (vct-ref data i) val segval))))))
	   (undo)
	   (xramp-channel 0.0 1.0 0.4)
	   (let ((e (make-env '(0 0 1 1) :length size :base 0.4)))
	     (let ((data (channel->vct)))
	       (if (or (fneq (vct-ref data 0) 0.0)
		       (fneq (vct-ref data (- size 1)) 1.0))
		   (snd-display #__line__ ";xramp-channel .4 ~A end points: ~A ~A" size (vct-ref data 0) (vct-ref data (- size 1))))
	       (do ((i 0 (+ 1 i)))
		   ((= i size))
		 (let ((val (envelope-interp (* i incr) '(0.0 0.0 1.0 1.0) 0.4))
		       (segval (env e)))
		   (if (or (fneq segval val)
			   (fneq (vct-ref data i) val))
		       (snd-display #__line__ ";xramp-channel .4 ~A of ~A: ramp: ~A, interp: ~A, env: ~A" i size (vct-ref data i) val segval))))))
	   (undo)
	   (xramp-channel 1.0 -1.0 8.0)
	   (let ((e (make-env '(0 1 1 -1) :length size :base 8.0)))
	     (let ((data (channel->vct)))
	       (if (or (fneq (vct-ref data 0) 1.0)
		       (fneq (vct-ref data (- size 1)) -1.0))
		   (snd-display #__line__ ";xramp-channel 1 -1 8 ~A end points: ~A ~A" size (vct-ref data 0) (vct-ref data (- size 1))))
	       (do ((i 0 (+ 1 i)))
		   ((= i size))
		 (let ((segval (env e)))
		   (if (fneq segval (vct-ref data i))
		       (snd-display #__line__ ";xramp-channel 1 -1 8 ~A of ~A: ramp: ~A, env: ~A" i size (vct-ref data i) segval))))))
	   (undo)
	   (close-sound ind)))
       (list 10 100 1000))
      
      ;; basic edit tree cases
      (let ((ind (new-sound "test.snd")))
	(if (not (= (redo) 0)) (snd-display #__line__ ";redo with no ops: ~A" (redo)))
	(if (not (= (undo) 0)) (snd-display #__line__ ";undo with no ops: ~A" (undo)))
	
	(if (not (string-=? (display-edits) (string-append "
EDITS: 0

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)
")))
	    (snd-display #__line__ ";new 0: ~A" (display-edits)))
	(insert-samples 10 10 (make-vct 10))
	(if (not (= (frames) 20)) (snd-display #__line__ ";new 1 frames: ~A" (frames)))
	(if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 1 20) ; insert-samples [1:4]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, cp->sounds[-1][0:8, 0.000])
   (at 10, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
")))
	    (snd-display #__line__ ";new 1: ~A" (display-edits)))
	(undo)
	(insert-samples 0 10 (make-vct 10))
	(if (not (= (frames) 11)) (snd-display #__line__ ";new 2 frames: ~A" (frames))) ; 11 because there was 1 sample when new-sound created 
	(if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";new 2: ~A" (display-edits)))
	(let ((eds (undo 2)))
	  (if (not (= eds 2)) (snd-display #__line__ ";new 3 undo: ~A" eds)))
	(insert-samples 0 10 (make-vct 10))
	(if (not (= (frames) 11)) (snd-display #__line__ ";new 3 frames: ~A" (frames)))
	(if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (insert 0 10) ; insert-samples [1:3]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";new 3: ~A" (display-edits)))
	(undo)
	(set! (sample 0) .5)
	(if (not (= (frames) 1)) (snd-display #__line__ ";new 4 frames: ~A" (frames)))
	(if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 1) ; set-sample 0 0.5000 [1:2]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1, end_mark)
")))
	    (snd-display #__line__ ";new 4: ~A" (display-edits)))      
	(undo)
	
	(set! (samples 0 10) (make-vct 10))
	(if (not (= (frames) 10)) (snd-display #__line__ ";new 5 frames: ~A" (frames)))
	(if (not (string-=? (display-edits) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
")))
	    (snd-display #__line__ ";new 5: ~A" (display-edits)))
	
	(delete-samples 3 4)
	(if (not (= (frames) 6)) (snd-display #__line__ ";new 6 frames: ~A" (frames)))
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (delete 3 4) ; delete-samples 3 4 [2:3]:
   (at 0, cp->sounds[1][0:2, 1.000]) [buf: 10] 
   (at 3, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	    (snd-display #__line__ ";new 6: ~A" (safe-display-edits ind 0 2)))
	
	(set! (samples 1 4) (make-vct 4))
	(if (not (= (frames) 6)) (snd-display #__line__ ";new 7 frames: ~A" (frames)))
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (set 1 4) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[2][0:3, 1.000]) [buf: 4] 
   (at 5, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	    (snd-display #__line__ ";new 7: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	(insert-samples 2 3 (make-vct 3))
	(insert-samples 2 1 (make-vct 1))
	(insert-samples 4 1 (make-vct 1))
	(insert-samples 15 1 (make-vct 1))
	(if (not (= (frames) 16)) (snd-display #__line__ ";new 8 frames: ~A" (frames)))
	(if (not (string-=? (display-edits) (string-append "
EDITS: 5

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:0, 0.000]) [file: " cwd "test.snd[0]]
   (at 1, end_mark)

 (set 0 10) ; set-samples [1:2]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)

 (insert 2 3) ; insert-samples [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 13, end_mark)

 (insert 2 1) ; insert-samples [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, end_mark)

 (insert 4 1) ; insert-samples [4:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, end_mark)

 (insert 15 1) ; insert-samples [5:8]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 3, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 4, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 7, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 15, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 16, end_mark)
")))
	    (snd-display #__line__ ";new 8: ~A" (display-edits)))
	(delete-samples 2 1)
	(if (not (string-=? (safe-display-edits ind 0 6) "
 (delete 2 1) ; delete-samples 2 1 [6:7]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[2][0:0, 1.000]) [buf: 3] 
   (at 3, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 4, cp->sounds[2][1:2, 1.000]) [buf: 3] 
   (at 6, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 14, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 15, end_mark)
"))
	    (snd-display #__line__ ";new 9: ~A" (safe-display-edits ind 0 6)))
	(delete-samples 0 5)
	(if (not (string-=? (safe-display-edits ind 0 7) "
 (delete 0 5) ; delete-samples 0 5 [7:4]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:9, 1.000]) [buf: 10] 
   (at 9, cp->sounds[5][0:0, 1.000]) [buf: 1] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";new 10: ~A" (safe-display-edits ind 0 7)))
	(delete-samples 6 4)
	(if (not (string-=? (safe-display-edits ind 0 8) "
 (delete 6 4) ; delete-samples 6 4 [8:3]:
   (at 0, cp->sounds[2][2:2, 1.000]) [buf: 3] 
   (at 1, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	    (snd-display #__line__ ";new 11: ~A" (safe-display-edits ind 0 8)))
	(delete-samples 0 1)
	(if (not (string-=? (safe-display-edits ind 0 9) "
 (delete 0 1) ; delete-samples 0 1 [9:2]:
   (at 0, cp->sounds[1][2:6, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	    (snd-display #__line__ ";new 12: ~A" (safe-display-edits ind 0 9)))
	
	(delete-samples 0 5)
	(if (not (string-=? (safe-display-edits ind 0 10) "
 (delete 0 5) ; delete-samples 0 5 [10:1]:
   (at 0, end_mark)
"))
	    (snd-display #__line__ ";new 13: ~A" (safe-display-edits ind 0 10)))
	(delete-samples 0 10)
	(if (not (= (edit-position) 10))
	    (snd-display #__line__ ";no-op delete deleted something! ~A" (display-edits)))
	(insert-samples 0 3 (make-vct 3))
	(if (not (string-=? (safe-display-edits ind 0 11) "
 (insert 0 3) ; insert-samples [11:2]:
   (at 0, cp->sounds[6][0:2, 1.000]) [buf: 3] 
   (at 3, end_mark)
"))
	    (snd-display #__line__ ";new 14: ~A" (safe-display-edits ind 0 11)))
	(delete-samples 2 1)
	(if (not (string-=? (safe-display-edits ind 0 12) "
 (delete 2 1) ; delete-samples 2 1 [12:2]:
   (at 0, cp->sounds[6][0:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	    (snd-display #__line__ ";new 15: ~A" (safe-display-edits ind 0 12)))
	(set! (sample 0) .5)
	(if (not (string-=? (safe-display-edits ind 0 13) "
 (set 0 1) ; set-sample 0 0.5000 [13:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[6][1:1, 1.000]) [buf: 3] 
   (at 2, end_mark)
"))
	    (snd-display #__line__ ";new 16: ~A" (safe-display-edits ind 0 13)))
	(set! (sample 1) .5)
	(if (not (string-=? (safe-display-edits ind 0 14) "
 (set 1 1) ; set-sample 1 0.5000 [14:3]:
   (at 0, cp->sounds[7][0:0, 1.000]) [buf: 1] 
   (at 1, cp->sounds[8][0:0, 1.000]) [buf: 1] 
   (at 2, end_mark)
"))
	    (snd-display #__line__ ";new 17: ~A" (safe-display-edits ind 0 14)))  
	(map-channel (lambda (y) 1.0) 0 10)
	(if (not (string-=? (safe-display-edits ind 0 15) "
 (set 0 10) ; map-channel [15:2]:
   (at 0, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";new 18: ~A" (safe-display-edits ind 0 15)))  
	(insert-samples 0 10 (make-vct 10))
	(if (not (string-=? (safe-display-edits ind 0 16) "
 (insert 0 10) ; insert-samples [16:3]:
   (at 0, cp->sounds[10][0:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	    (snd-display #__line__ ";new 19: ~A" (safe-display-edits ind 0 16)))
	(set! (samples 2 3) (make-vct 3))
	(if (not (string-=? (safe-display-edits ind 0 17) "
 (set 2 3) ; set-samples [17:5]:
   (at 0, cp->sounds[10][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[11][0:2, 1.000]) [buf: 3] 
   (at 5, cp->sounds[10][5:9, 1.000]) [buf: 10] 
   (at 10, cp->sounds[9][0:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	    (snd-display #__line__ ";new 20: ~A" (safe-display-edits ind 0 17)))
	(set! (samples 0 12) (make-vct 12))
	(if (not (string-=? (safe-display-edits ind 0 18) "
 (set 0 12) ; set-samples [18:3]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, end_mark)
"))
	    (snd-display #__line__ ";new 21: ~A" (safe-display-edits ind 0 18)))
	(set! (samples 30 10) (make-vct 10))
	(if (not (string-=? (safe-display-edits ind 0 19) "
 (set 20 21) ; set-samples [19:5]:
   (at 0, cp->sounds[12][0:11, 1.000]) [buf: 12] 
   (at 12, cp->sounds[9][2:9, 1.000]) [buf: 10] 
   (at 20, cp->sounds[-1][0:9, 0.000])
   (at 30, cp->sounds[13][0:9, 1.000]) [buf: 10] 
   (at 40, end_mark)
"))
	    (snd-display #__line__ ";new 21: ~A" (safe-display-edits ind 0 19)))
	(close-sound ind))
      
      ;; scale/ramp
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 10)
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 10) ; scale-channel 0.500 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 0: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(scale-channel 0.5 0 3)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 0 3) ; scale-channel 0.500 0 3 [2:3]:
   (at 0, cp->sounds[1][0:2, 0.500]) [buf: 10] 
   (at 3, cp->sounds[1][3:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 1: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(scale-channel 0.5 5 5)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 2: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 2 4) ; scale-channel 0.500 2 4 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 2a: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(scale-channel 0.5 10 10)
	(if (not (= (edit-position) 1))
	    (snd-display #__line__ ";scale beyond end edited? ~A" (display-edits)))
	(scale-channel 0.5 100 10)
	(if (not (= (edit-position) 1))
	    (snd-display #__line__ ";scale way beyond end edited? ~A" (display-edits)))
	(scale-channel 0.5 5 10)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (scale 5 5) ; scale-channel 0.500 5 5 [2:3]:
   (at 0, cp->sounds[1][0:4, 1.000]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 3: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (set 4 1) ; set-sample 4 0.5000 [2:4]:
   (at 0, cp->sounds[1][0:3, 1.000]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 4: ~A" (safe-display-edits ind 0 2)))
	(scale-channel 0.5 0 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 4) ; scale-channel 0.500 0 4 [3:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 5: ~A" (safe-display-edits ind 0 3)))
	(scale-channel 0.5 4 1)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 4 1) ; scale-channel 0.500 4 1 [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 6: ~A" (safe-display-edits ind 0 4)))
	(scale-channel 0.5 0 7)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 7) ; scale-channel 0.500 0 7 [5:5]:
   (at 0, cp->sounds[1][0:3, 0.250]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.250]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 7: ~A" (safe-display-edits ind 0 5)))
	(scale-channel 0.5 1 4)
	(if (not (string-=? (safe-display-edits ind 0 6) "
 (scale 1 4) ; scale-channel 0.500 1 4 [6:6]:
   (at 0, cp->sounds[1][0:0, 0.250]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.125]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.125]) [buf: 1] 
   (at 5, cp->sounds[1][5:6, 0.500]) [buf: 10] 
   (at 7, cp->sounds[1][7:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 8: ~A" (safe-display-edits ind 0 6)))
	(undo 4)
	(scale-channel 0.5 1 8)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 1 8) ; scale-channel 0.500 1 8 [3:6]:
   (at 0, cp->sounds[1][0:0, 1.000]) [buf: 10] 
   (at 1, cp->sounds[1][1:3, 0.500]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 0.500]) [buf: 1] 
   (at 5, cp->sounds[1][5:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";scl 9: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 0: ~A" (safe-display-edits ind 0 2)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 1: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 2: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 4) ; scale-channel 0.500 2 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.111]) [buf: 10] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.222 -> 0.556]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.667 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 3: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 5 5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 5) ; scale-channel 0.500 5 5 [3:3]:
   (at 0, cp->sounds[1][0:4, 1.000, [1]-0.000 -> 0.444]) [buf: 10] 
   (at 5, cp->sounds[1][5:9, 0.500, [1]0.556 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 4: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	(ramp-channel .2 .6 2 6)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [2:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 5: ~A" (safe-display-edits ind 0 2)))
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 5) ; scale-channel 0.500 0 5 [3:5]:
   (at 0, cp->sounds[1][0:1, 0.500]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 6: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 2 6)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 2 6) ; scale-channel 0.500 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:7, 0.500, [1]0.200 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 7: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 5 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 5 4) ; scale-channel 0.500 5 4 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:4, 1.000, [1]0.200 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 0.500, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:8, 0.500]) [buf: 10] 
   (at 9, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 8: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 0.5000 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 9: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 4 1)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 1) ; scale-channel 0.500 4 1 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:4, 0.500, [1]0.360 -> 0.360]) [buf: 10] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 10: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-sample 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600]) [buf: 10] 
   (at 7, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 9, end_mark)
"))
	    (snd-display #__line__ ";ramp 11: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-samples 4 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 6, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 8, end_mark)
"))
	    (snd-display #__line__ ";ramp 12: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-samples 4 3)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 3) ; delete-samples 4 3 [3:5]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][7:7, 1.000, [1]0.600 -> 0.600]) [buf: 10] 
   (at 5, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 7, end_mark)
"))
	    (snd-display #__line__ ";ramp 13: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-samples 4 4)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 4) ; delete-samples 4 4 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 6, end_mark)
"))
	    (snd-display #__line__ ";ramp 14: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(delete-samples 4 5)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 5) ; delete-samples 4 5 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][9:9, 1.000]) [buf: 10] 
   (at 5, end_mark)
"))
	    (snd-display #__line__ ";ramp 15: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-channel 0.5 4 2)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.360 -> 0.440]) [buf: 10] 
   (at 6, cp->sounds[1][6:7, 1.000, [1]0.520 -> 0.600]) [buf: 10] 
   (at 8, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";ramp 16: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(pad-channel 4 1)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 1) ; pad-channel [3:6]:
   (at 0, cp->sounds[1][0:1, 1.000]) [buf: 10] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280]) [buf: 10] 
   (at 4, cp->sounds[-1][0:0, 0.000])
   (at 5, cp->sounds[1][4:7, 1.000, [1]0.360 -> 0.600]) [buf: 10] 
   (at 9, cp->sounds[1][8:9, 1.000]) [buf: 10] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp 17: ~A" (safe-display-edits ind 0 3)))
	(close-sound ind))
      
      ;; xramp
      (let ((ind (new-sound "test.snd"))) ; 2nd main let
	(map-channel (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 1: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(xramp-channel 0.0 1.0 0.325)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.000 1.000 0.325 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 1.000, off: 1.481, scl: -1.481]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 2: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(xramp-channel 0.0 1.0 0.0)
	(if (not (string-=? (safe-display-edits ind 0 2) (string-append "
 (scale 0 10) ; scale-channel 0.000 0 #f [2:2]:
   (at 0, cp->sounds[0][0:9, 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 10, end_mark)
")))
	    (snd-display #__line__ ";xramp 3: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(xramp-channel 0.0 1.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; ramp-channel 0.000 1.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.000 -> 1.000]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 4: ~A" (safe-display-edits ind 0 2)))
	(undo)
	(xramp-channel 0.5 1.5 32.0)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel 0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.500 -> 1.500, off: 0.468, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 5: ~A" (safe-display-edits ind 0 2)))
	(if (or (fneq (maxamp) 1.5) (fneq (sample 0) 0.5))
	    (snd-display #__line__ ";xramp 5 vals: ~A ~A" (maxamp) (sample 0)))
	(undo)
	(xramp-channel -0.5 1.5 32.0)
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ramp 0 10) ; xramp-channel -0.500 1.500 32.000 0 #f [2:2]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]-0.500 -> 1.500, off: -0.565, scl: 0.065]) [buf: 10] 
   (at 10, end_mark)
"))
	    (snd-display #__line__ ";xramp 6: ~A" (safe-display-edits ind 0 2)))
	(if (or (fneq (maxamp) 1.5) (fneq (sample 0) -0.5))
	    (snd-display #__line__ ";xramp 6 vals: ~A ~A" (maxamp) (sample 0)))
	(undo)
	(xramp-channel 0.0 1.0 32.0)
	(let ((vals (channel->vct))
	      (ctr 0))
	  (scale-channel 0.5)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 10) ; scale-channel 0.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 7: ~A" (safe-display-edits ind 0 3)))
	  (set! ctr 0)
	  (let ((baddy (scan-chan (lambda (y) (if (fneq y (* 0.5 (vct-ref vals ctr))) #t (begin (set! ctr (+ 1 ctr)) #f))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 7: ~A" baddy)))
	  (undo)
	  (delete-sample 0)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 1) ; delete-samples 0 1 [3:2]:
   (at 0, cp->sounds[1][1:9, 1.000, [1]0.015 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	      (snd-display #__line__ ";xramp 8: ~A" (safe-display-edits ind 0 3)))
	  (set! ctr 1)
	  (let ((baddy (scan-chan (lambda (y) (if (fneq y (vct-ref vals ctr)) #t (begin (set! ctr (+ 1 ctr)) #f))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 8: ~A" baddy)))
	  (undo)
	  (delete-samples 0 2)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 0 2) ; delete-samples 0 2 [3:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	      (snd-display #__line__ ";xramp 9: ~A" (safe-display-edits ind 0 3)))
	  (set! ctr 2)
	  (let ((baddy (scan-chan (lambda (y) (if (fneq y (vct-ref vals ctr)) #t (begin (set! ctr (+ 1 ctr)) #f))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 9: ~A" baddy)))
	  (undo)
	  (delete-sample 0)
	  (delete-sample 0)
	  (if (not (string-=? (safe-display-edits ind 0 4) "
 (delete 0 1) ; delete-samples 0 1 [4:2]:
   (at 0, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	      (snd-display #__line__ ";xramp 10: ~A" (safe-display-edits ind 0 4)))
	  (undo 2)
	  (delete-sample 4)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 1) ; delete-samples 4 1 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 9, end_mark)
"))
	      (snd-display #__line__ ";xramp 11: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (delete-samples 4 2)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (delete 4 2) ; delete-samples 4 2 [3:3]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 8, end_mark)
"))
	      (snd-display #__line__ ";xramp 12: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (scale-channel 0.5 4 2)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 4 2) ; scale-channel 0.500 4 2 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[1][4:5, 0.500, [1]0.118 -> 0.189, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 13: ~A" (safe-display-edits ind 0 3)))
	  (set! ctr 0)
	  (let ((baddy (scan-chan (lambda (y)
				    (if (or (and (> ctr 5) (fneq y (vct-ref vals ctr)))
					    (and (< ctr 4) (fneq y (vct-ref vals ctr)))
					    (and (or (= ctr 4) (= ctr 5)) (fneq y (* 0.5 (vct-ref vals ctr)))))
					#t
					(begin (set! ctr (+ 1 ctr)) #f))))))
	    (if baddy (snd-display #__line__ ";trouble in xramp 8: ~A" baddy)))
	  (undo)
	  (scale-channel 0.5 0 2)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 2) ; scale-channel 0.500 0 2 [3:3]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.015, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 2, cp->sounds[1][2:9, 1.000, [1]0.037 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 14: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (pad-channel 4 2)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (silence 4 2) ; pad-channel [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[-1][0:1, 0.000])
   (at 6, cp->sounds[1][4:9, 1.000, [1]0.118 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 12, end_mark)
"))
	      (snd-display #__line__ ";xramp 15: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (set! (sample 4) 1.0)
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 1) ; set-sample 4 1.0000 [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:9, 1.000, [1]0.189 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 16: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (set! (samples 4 2) (make-vct 2))
	  (if (not (string-=? (safe-display-edits ind 0 3) "
 (set 4 2) ; set-samples [3:4]:
   (at 0, cp->sounds[1][0:3, 1.000, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 1.000, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 17: ~A" (safe-display-edits ind 0 3)))
	  (undo)
	  (scale-channel 0.5)
	  (set! (samples 4 2) (make-vct 2))
	  (if (not (string-=? (safe-display-edits ind 0 4) "
 (set 4 2) ; set-samples [4:4]:
   (at 0, cp->sounds[1][0:3, 0.500, [1]0.000 -> 0.070, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 4, cp->sounds[2][0:1, 1.000]) [buf: 2] 
   (at 6, cp->sounds[1][6:9, 0.500, [1]0.293 -> 1.000, off: -0.032, scl: 0.032]) [buf: 10] 
   (at 10, end_mark)
"))
	      (snd-display #__line__ ";xramp 18: ~A" (safe-display-edits ind 0 4)))
	  )
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd"))) ; 3rd
	(map-channel (lambda (y) 1.0) 0 100)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(ramp-channel 0.0 1.0)
	(if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 100) ; ramp-channel 0.000 1.000 0 #f [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp 1: ~A" (safe-display-edits ind 0 12)))
	(if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 1 maxamp: ~A" (maxamp)))
	(undo)
	(ramp-channel 0.1 1.0 10 90)
	(if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 90) ; ramp-channel 0.100 1.000 10 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.302 -> 0.393]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.403 -> 0.494]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.504 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp 2: ~A" (safe-display-edits ind 0 12)))
	(if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 2 maxamp: ~A" (maxamp)))
	(undo)
	(ramp-channel 0.0 0.9 0 90)
	(if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 0 90) ; ramp-channel 0.000 0.900 0 90 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.496]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.506 -> 0.597]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.607 -> 0.698]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp 3: ~A" (safe-display-edits ind 0 12)))
	(if (fneq (maxamp) 0.5) (snd-display #__line__ ";multi ramp 3 maxamp: ~A" (maxamp)))
	(if (fneq (sample 89) 0.45) (snd-display #__line__ ";multi ramp 3 sample 89: ~A" (sample 89)))
	(if (fneq (sample 90) 0.5) (snd-display #__line__ ";multi ramp 3 sample 90: ~A" (sample 90)))
	(undo)
	(ramp-channel 0.1 0.9 10 80)
	(if (not (string=? (safe-display-edits ind 0 12) "
 (ramp 10 80) ; ramp-channel 0.100 0.900 10 80 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.100 -> 0.191]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.201 -> 0.292]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.708 -> 0.799]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.809 -> 0.900]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp 4: ~A" (safe-display-edits ind 0 12)))
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(ramp-channel 0.0 1.0)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(if (not (string=? (safe-display-edits ind 0 12) "
 (scale 90 10) ; scale-channel 0.500 90 10 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp 5: ~A" (safe-display-edits ind 0 12)))
	(close-sound ind))
      
      
      (let ((ind (new-sound "test.snd")))
	
	;; ptree+scale
	(map-channel (lambda (y) 1.0) 0 100)
	(cosine-channel 0 100)
	(let ((map-data (channel->vct)))
	  (undo)
	  (cosine-channel-via-ptree 0 100)
	  (let ((tree-data (channel->vct)))
	    (if (not (vequal map-data tree-data))
		(snd-display #__line__ ";map and ptree cosine disagree: ~A ~A" map-data tree-data)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (if (not (string=? (safe-display-edits ind 0 12 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, loc: 0, pos: 10, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, loc: 0, pos: 20, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, loc: 0, pos: 30, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, loc: 0, pos: 40, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, loc: 0, pos: 50, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, loc: 0, pos: 60, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, loc: 0, pos: 70, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, loc: 0, pos: 80, scl: 1.000]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, loc: 0, pos: 90, scl: 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 0: ~A" (safe-display-edits ind 0 12 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and ptree->scl cosine disagree: ~%  ~A~%  ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (cosine-channel-via-ptree 0 100)
	  (if (not (string=? (safe-display-edits ind 0 12 #f) "
 (ptree[0] 0 100) ; ptree-channel [12:11]:
   (at 0, cp->sounds[1][0:9, 1.000, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, loc: 0, pos: 80, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 1.000, loc: 0, pos: 90, scl: 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 1: ~A" (safe-display-edits ind 0 12 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and scl->ptree cosine disagree: ~A ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (cosine-channel 10 90)
	  (set! map-data (channel->vct))
	  
	  (undo)
	  (cosine-channel-via-ptree 10 90)
	  (let ((tree-data (channel->vct)))
	    (if (not (vequal map-data tree-data))
		(snd-display #__line__ ";map and ptree 10:90 cosine disagree: ~A ~A" map-data tree-data)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (if (not (string-=? (safe-display-edits ind 0 12 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, loc: 0, pos: 10, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, loc: 0, pos: 20, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, loc: 0, pos: 30, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, loc: 0, pos: 40, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, loc: 0, pos: 50, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, loc: 0, pos: 60, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, loc: 0, pos: 70, scl: 1.000]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, loc: 0, pos: 80, scl: 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 2: ~A" (safe-display-edits ind 0 12 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and scl->ptree 10:90 cosine disagree: ~A ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (cosine-channel 10 80)
	  (set! map-data (channel->vct))
	  (undo)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (cosine-channel-via-ptree 10 80)
	  (let ((tree-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data tree-data))
		(snd-display #__line__ ";map and ptree 10:80 cosine disagree: ~A ~A" map-data tree-data)))
	  (if (not (string-=? (safe-display-edits ind 0 12 #f) "
 (ptree[0] 10 80) ; ptree-channel [12:11]:
   (at 0, cp->sounds[1][0:9, 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 3: ~A" (safe-display-edits ind 0 12 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and scl->ptree 10:80 cosine disagree: ~A ~A" map-data scl-data)))
	  
	  ;; ptree + ramp
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (env-channel '(0 0 1 1))
	  (cosine-channel 0 100)
	  (set! map-data (channel->vct))
	  (undo)
	  (cosine-channel-via-ptree 0 100)
	  (let ((tree-data (channel->vct)))
	    (if (not (vequal map-data tree-data))
		(snd-display #__line__ ";ptree->ramp cosine disagree: ~A ~A" map-data tree-data)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, loc: 0, pos: 10, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, loc: 0, pos: 20, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, loc: 0, pos: 30, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, loc: 0, pos: 40, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, loc: 0, pos: 50, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, loc: 0, pos: 60, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, loc: 0, pos: 70, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, loc: 0, pos: 80, scl: 1.000]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, loc: 0, pos: 90, scl: 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 4: ~A" (safe-display-edits ind 0 13 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and (scl) ptree->ramp cosine disagree: ~A ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (env-channel '((0 0) (1 1)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (cosine-channel-via-ptree 0 100)
	  (if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (ptree[0] 0 100) ; ptree-channel [13:11]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 0.091, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.101 -> 0.192, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.202 -> 0.293, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, [1]0.303 -> 0.394, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.404 -> 0.495, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.505 -> 0.596, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.606 -> 0.697, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, [1]0.707 -> 0.798, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, [1]0.808 -> 0.899, loc: 0, pos: 80, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 1.000, [1]0.909 -> 1.000, loc: 0, pos: 90, scl: 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 5: ~A" (safe-display-edits ind 0 13 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 2.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and ptree->ramp (scl) cosine disagree: ~A ~A" map-data scl-data)))
	  
	  (scale-channel 0.5)
	  (if (not (string-=? (safe-display-edits ind 0 14 #f) "
 (scale 0 100) ; scale-channel 0.500 0 #f [14:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, loc: 0, pos: 80, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, loc: 0, pos: 90, scl: 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 5 + scl: ~A" (safe-display-edits ind 0 14 #f)))
	  (let ((scl-data (vct-scale! (channel->vct) 4.0)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";map and ptree->ramp (scl twice) cosine disagree: ~A ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (env-channel '(0 0 1 1))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (cosine-channel-via-ptree 10 80)
	  (set! map-data (channel->vct))
	  (if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (ptree[0] 10 80) ; ptree-channel [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.101 -> 0.192, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.202 -> 0.293, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, [1]0.303 -> 0.394, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.404 -> 0.495, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.505 -> 0.596, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.606 -> 0.697, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, [1]0.707 -> 0.798, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, [1]0.808 -> 0.899, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 6: ~A" (safe-display-edits ind 0 13 #f)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (env-channel '(0 0 1 1))
	  (cosine-channel-via-ptree 10 80)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (let ((scl-data (channel->vct)))
	    (if (not (vequal map-data scl-data))
		(snd-display #__line__ ";ptree+ramp order matters? ~A ~A" map-data scl-data)))
	  
	  (revert-sound)
	  (map-channel (lambda (y) 1.0) 0 100)
	  (env-channel '(0 0 1 1))
	  (cosine-channel-via-ptree 15 70)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (scale-channel 0.5 (* i 10) 10))
	  (if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [13:13]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091]) [buf: 100] 
   (at 10, cp->sounds[1][10:14, 0.500, [1]0.101 -> 0.141]) [buf: 100] 
   (at 15, cp->sounds[1][15:19, 0.500, [1]0.152 -> 0.192, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, loc: 0, pos: 5, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, loc: 0, pos: 15, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, loc: 0, pos: 25, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, loc: 0, pos: 35, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, loc: 0, pos: 45, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, loc: 0, pos: 55, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:84, 0.500, [1]0.808 -> 0.848, loc: 0, pos: 65, scl: 1.000]) [buf: 100] 
   (at 85, cp->sounds[1][85:89, 0.500, [1]0.859 -> 0.899]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";multi-tree 7: ~A" (safe-display-edits ind 0 13 #f)))
	  (close-sound ind)))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 100)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.75 (* i 10) 10))
	(ptree-channel (lambda (y data forward)
			 (* y (vct-ref data 0)))
		       0 (frames) ind 0 #f #f
		       (lambda (pos dur)
			 (vct 0.5)))
	(ptree-channel (lambda (y data forward)
			 (* y (vct-ref data 0)))
		       20 45 ind 0 #f #f
		       (lambda (pos dur)
			 (vct 0.25)))
	(let ((data (channel->vct))
	      (orig (make-vct 100 1.0)))
	  (vct-scale! orig 0.75) ; scale-channel
	  (vct-scale! orig 0.5)  ; ptree-channel
	  (do ((i 20 (+ 1 i)))
	      ((= i 65))
	    (vct-set! orig i (* (vct-ref orig i) .25)))
	  (if (not (vvequal orig data))
	      (snd-display #__line__ ";p2 pos test data: ~A" data))
	  (if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (ptree[1] 20 45) ; ptree-channel [13:12]:
   (at 0, cp->sounds[1][0:9, 1.000, loc: 0, pos: 0, scl: 0.750]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, loc: 0, pos: 10, scl: 0.750]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 20, scl: 0.750]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, loc2: 1, pos2: 10, scl2: 1.000, loc: 0, pos: 30, scl: 0.750]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, loc2: 1, pos2: 20, scl2: 1.000, loc: 0, pos: 40, scl: 0.750]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, loc2: 1, pos2: 30, scl2: 1.000, loc: 0, pos: 50, scl: 0.750]) [buf: 100] 
   (at 60, cp->sounds[1][60:64, 1.000, loc2: 1, pos2: 40, scl2: 1.000, loc: 0, pos: 60, scl: 0.750]) [buf: 100] 
   (at 65, cp->sounds[1][65:69, 1.000, loc: 0, pos: 65, scl: 0.750]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, loc: 0, pos: 70, scl: 0.750]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, loc: 0, pos: 80, scl: 0.750]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 1.000, loc: 0, pos: 90, scl: 0.750]) [buf: 100] 
   (at 100, end_mark)
"))
	      (snd-display #__line__ ";p2 pos multi: ~A" (safe-display-edits ind 0 13 #f)))
	  (close-sound ind)))
      
      (let ((ind (new-sound "test.snd"))
	    (map-data #f))
	
	;; ptree + xramp
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(env-sound '(0 0 1 1) 0 100 32.0)
	(cosine-channel 0 100)
	(set! map-data (channel->vct))
	(undo)
	(cosine-channel-via-ptree 0 100)
	(let ((tree-data (channel->vct)))
	  (if (not (vequal map-data tree-data))
	      (snd-display #__line__ ";ptree->xramp cosine disagree: ~A ~A" map-data tree-data)))
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.012, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.014 -> 0.030, off: -0.032, scl: 0.032, loc: 0, pos: 10, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.033 -> 0.057, off: -0.032, scl: 0.032, loc: 0, pos: 20, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.060 -> 0.094, off: -0.032, scl: 0.032, loc: 0, pos: 30, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.099 -> 0.147, off: -0.032, scl: 0.032, loc: 0, pos: 40, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.153 -> 0.222, off: -0.032, scl: 0.032, loc: 0, pos: 50, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.231 -> 0.329, off: -0.032, scl: 0.032, loc: 0, pos: 60, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.342 -> 0.480, off: -0.032, scl: 0.032, loc: 0, pos: 70, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.499 -> 0.695, off: -0.032, scl: 0.032, loc: 0, pos: 80, scl: 1.000]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.721 -> 1.000, off: -0.032, scl: 0.032, loc: 0, pos: 90, scl: 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-tree 9: ~A" (safe-display-edits ind 0 13 #f)))
	(let ((scl-data (vct-scale! (channel->vct) 2.0)))
	  (if (not (vequal map-data scl-data))
	      (snd-display #__line__ ";map and (scl) ptree->xramp cosine disagree: ~A ~A" map-data scl-data)))
	
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(env-sound '(0 0 1 1) 0 100 32.0)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(cosine-channel-via-ptree 0 100)
	(if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (ptree[0] 0 100) ; ptree-channel [13:11]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 0.012, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.014 -> 0.030, off: -0.032, scl: 0.032, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.033 -> 0.057, off: -0.032, scl: 0.032, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, [1]0.060 -> 0.094, off: -0.032, scl: 0.032, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.099 -> 0.147, off: -0.032, scl: 0.032, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.153 -> 0.222, off: -0.032, scl: 0.032, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.231 -> 0.329, off: -0.032, scl: 0.032, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, [1]0.342 -> 0.480, off: -0.032, scl: 0.032, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, [1]0.499 -> 0.695, off: -0.032, scl: 0.032, loc: 0, pos: 80, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 1.000, [1]0.721 -> 1.000, off: -0.032, scl: 0.032, loc: 0, pos: 90, scl: 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-tree 10: ~A" (safe-display-edits ind 0 13 #f)))
	(let ((scl-data (vct-scale! (channel->vct) 2.0)))
	  (if (not (vequal map-data scl-data))
	      (snd-display #__line__ ";map and ptree->xramp (scl) cosine disagree: ~A ~A" map-data scl-data)))
	
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(env-sound '(0 0 1 1) 0 100 32.0)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(cosine-channel-via-ptree 10 80)
	(set! map-data (channel->vct))
	(if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (ptree[0] 10 80) ; ptree-channel [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.012, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.014 -> 0.030, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.033 -> 0.057, off: -0.032, scl: 0.032, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, [1]0.060 -> 0.094, off: -0.032, scl: 0.032, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.099 -> 0.147, off: -0.032, scl: 0.032, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.153 -> 0.222, off: -0.032, scl: 0.032, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.231 -> 0.329, off: -0.032, scl: 0.032, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, [1]0.342 -> 0.480, off: -0.032, scl: 0.032, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, [1]0.499 -> 0.695, off: -0.032, scl: 0.032, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.721 -> 1.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-tree 11: ~A" (safe-display-edits ind 0 13 #f)))
	
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(env-sound '(0 0 1 1) 0 100 32.0)
	(cosine-channel-via-ptree 10 80)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(let ((scl-data (channel->vct)))
	  (if (not (vequal map-data scl-data))
	      (snd-display #__line__ ";ptree+xramp order matters? ~A ~A" map-data scl-data)))
	
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(env-sound '(0 0 1 1) 0 100 32.0)
	(cosine-channel-via-ptree 15 70)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(if (not (string-=? (safe-display-edits ind 0 13 #f) "
 (scale 90 10) ; scale-channel 0.500 90 10 [13:13]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.012, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:14, 0.500, [1]0.014 -> 0.020, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 15, cp->sounds[1][15:19, 0.500, [1]0.022 -> 0.030, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 1.000]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.033 -> 0.057, off: -0.032, scl: 0.032, loc: 0, pos: 5, scl: 1.000]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.060 -> 0.094, off: -0.032, scl: 0.032, loc: 0, pos: 15, scl: 1.000]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.099 -> 0.147, off: -0.032, scl: 0.032, loc: 0, pos: 25, scl: 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.153 -> 0.222, off: -0.032, scl: 0.032, loc: 0, pos: 35, scl: 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.231 -> 0.329, off: -0.032, scl: 0.032, loc: 0, pos: 45, scl: 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.342 -> 0.480, off: -0.032, scl: 0.032, loc: 0, pos: 55, scl: 1.000]) [buf: 100] 
   (at 80, cp->sounds[1][80:84, 0.500, [1]0.499 -> 0.578, off: -0.032, scl: 0.032, loc: 0, pos: 65, scl: 1.000]) [buf: 100] 
   (at 85, cp->sounds[1][85:89, 0.500, [1]0.600 -> 0.695, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.721 -> 1.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-tree 12: ~A" (safe-display-edits ind 0 13 #f)))
	(close-sound ind))
      
      ;; ptree2
      (let ((ind (new-sound "test.snd")) ;4th
	    (case1 #f)
	    (case2 #f))
	(map-chan (lambda (y) 1.0) 0 10)
	(ptree-channel (lambda (y) (* y 0.5)))
	(if (not (vequal (channel->vct) (make-vct 11 0.5)))
	    (snd-display #__line__ ";ptree2 0: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 2) "
 (ptree[0] 0 11) ; ptree-channel [2:2]:
   (at 0, cp->sounds[1][0:10, 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 3: ~A" (safe-display-edits ind 0 2)))
	(ptree-channel (lambda (y) (* y 1.5)))
	(if (not (vequal (channel->vct) (make-vct 11 0.75)))
	    (snd-display #__line__ ";ptree2 1: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ptree[1] 0 11) ; ptree-channel [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 4: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(scale-by (vct 1.5))
	(if (not (vequal (channel->vct) (make-vct 11 0.75)))
	    (snd-display #__line__ ";ptree2 5: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (scale 0 11) ; scale-channel 1.500 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.500, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 6: ~A" (safe-display-edits ind 0 3)))
	(ptree-channel (lambda (y) (* y 0.1)))
	(if (not (vequal (channel->vct) (make-vct 11 0.075)))
	    (snd-display #__line__ ";ptree2 7: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ptree[1] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.500, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 8: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	(scale-by '(0.5))
	(ptree-channel (lambda (y) (* y 1.5)))
	(scale-by 2.0)
	(ptree-channel (lambda (y) (* y 0.1)))
	(scale-by 3.0)
	(if (not (vequal (channel->vct) (make-vct 11 0.45)))
	    (snd-display #__line__ ";ptree2 9: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 6) "
 (scale 0 11) ; scale-channel 3.000 0 #f [6:2]:
   (at 0, cp->sounds[1][0:10, 3.000, loc2: 1, pos2: 0, scl2: 2.000, loc: 0, pos: 0, scl: 0.500, code: (lambda (y) (* y 1.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 10: ~A" (safe-display-edits ind 0 6)))
	(undo 2)
	(ptree-channel (lambda (y) (* y 0.1)) 2 4)
	(scale-by 3.0)
	(if (not (vequal (channel->vct) (vct 4.500 4.500 0.450 0.450 0.450 0.450 4.500 4.500 4.500 4.500 4.500)))
	    (snd-display #__line__ ";ptree2 11: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 6) "
 (scale 0 11) ; scale-channel 3.000 0 #f [6:4]:
   (at 0, cp->sounds[1][0:1, 6.000, loc: 0, pos: 0, scl: 0.500, code: (lambda (y) (* y 1.5))]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 3.000, loc2: 1, pos2: 0, scl2: 2.000, loc: 0, pos: 2, scl: 0.500, code: (lambda (y) (* y 1.5))]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 6.000, loc: 0, pos: 6, scl: 0.500, code: (lambda (y) (* y 1.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2 12: ~A" (safe-display-edits ind 0 6)))
	(close-sound ind))
      
      ;; ptree2-zero
      (let ((ind (new-sound "test.snd"))
	    (case1 #f)
	    (case2 #f))
	(map-chan (lambda (y) 1.0) 0 10)
	(scale-by 0.0)
	(ptree-channel (lambda (y) (+ y 0.5)))
	(if (not (vequal (channel->vct) (make-vct 11 0.5)))
	    (snd-display #__line__ ";ptree2-zero 0: ~A" (channel->vct)))
	(ptree-channel (lambda (y) (+ y 0.25)))
	(if (not (vequal (channel->vct) (make-vct 11 0.75)))
	    (snd-display #__line__ ";ptree2-zero 1: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 4) (string-append "
 (ptree[1] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[0][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 0.000, code: (lambda (y) (+ y 0.5))]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";ptree2-zero 2: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	(scale-channel 0.0 2 4)
	(ptree-channel (lambda (y) (+ y 0.5)))
	(ptree-channel (lambda (y) (+ y 0.25)))
	(if (not (vequal (channel->vct) (vct 1.750 1.750 0.750 0.750 0.750 0.750 1.750 1.750 1.750 1.750 1.750)))
	    (snd-display #__line__ ";ptree2-zero 3: ~A" (channel->vct)))
	
	;; ptree2-ramp
	(revert-sound)
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y .5)))
	(ptree-channel (lambda (y) (+ y .25)))
	(if (not (vequal (channel->vct) (vct 0.250 0.300 0.350 0.400 0.450 0.500 0.550 0.600 0.650 0.700 0.750)))
	    (snd-display #__line__ ";ptree2-ramp 1: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ptree[1] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2-ramp 2: ~A" (safe-display-edits ind 0 4)))
	(scale-by 0.5)
	(if (not (vequal (channel->vct) (vct 0.125 0.150 0.175 0.200 0.225 0.250 0.275 0.300 0.325 0.350 0.375)))
	    (snd-display #__line__ ";ptree2-ramp 3: ~A" (channel->vct)))
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 11) ; scale-channel 0.500 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]-0.000 -> 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) (* y 0.5))]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree2-ramp 4: ~A" (safe-display-edits ind 0 5)))
	
	;; ptree+ramp3
	(revert-sound)
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y .5)))
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ptree[0] 0 11) ; ptree-channel [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp3: ~A" (safe-display-edits ind 0 5 #f)))
	(undo 1)
	(ptree-channel (lambda (y data forward)
			 (* y (vct-ref data 0)))
		       0 (frames) ind 0 #f #t
		       (lambda (pos dur)
			 (vct 0.5)))
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ptree[0] 0 11) ; ptree-channel [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptreec-ramp3: ~A" (safe-display-edits ind 0 5 #f)))
	(undo 4)
	(xramp-channel 0.0 1.0 32.0)
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp2: ~A" (safe-display-edits ind 0 4)))
	(close-sound ind))
      
      ;; ramp2
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 0: ~A" (safe-display-edits ind 0 3)))
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ramp2 (1): ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 11) ; scale-channel 0.500 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 1: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.400, [2]-0.000 -> 0.400]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.500 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 2: ~A" (safe-display-edits ind 0 4)))
	(if (not (vequal (channel->vct) (vct 0.000 0.005 0.020 0.045 0.080 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ramp2 (2): ~A" (channel->vct)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 2 4) ; scale-channel 0.500 2 4 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100, [2]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.200 -> 0.500, [2]0.200 -> 0.500]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.600 -> 1.000, [2]0.600 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 3: ~A" (safe-display-edits ind 0 4)))
	(undo 2)
	(ramp-channel 0.75 0.25)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.750 0.250 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]0.750 -> 0.250]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 4: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(ramp-channel .2 .6 2 6)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.700, [2]0.200 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 5: ~A" (safe-display-edits ind 0 3)))
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.400, [2]0.200 -> 0.360]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.440 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 6: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (set 4 1) ; set-sample 4 0.5000 [4:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.300, [2]0.200 -> 0.280]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.440 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 7: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 100)
	
	;; multi-ramp2
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(ramp-channel 0.0 1.0)
	(ramp-channel 1.0 0.0)
	(if (not (string-=? (safe-display-edits ind 0 13) "
 (ramp 0 100) ; ramp-channel 1.000 0.000 0 #f [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, [2]1.000 -> 0.909]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, [2]0.899 -> 0.808]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, [2]0.798 -> 0.707]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, [2]0.697 -> 0.606]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, [2]0.596 -> 0.505]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, [2]0.495 -> 0.404]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, [2]0.394 -> 0.303]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, [2]0.293 -> 0.202]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, [2]0.192 -> 0.101]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, [2]0.091 -> -0.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp2 1: ~A" (safe-display-edits ind 0 13)))
	(undo 12)
	(ramp-channel 0.0 1.0 10 20)
	(ramp-channel 0.0 1.0 50 10)
	(ramp-channel 0.0 1.0 25 10)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 25 10) ; ramp-channel 0.000 1.000 25 10 [4:8]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:24, 1.000, [1]-0.000 -> 0.737]) [buf: 100] 
   (at 25, cp->sounds[1][25:29, 1.000, [1]0.789 -> 1.000, [2]-0.000 -> 0.444]) [buf: 100] 
   (at 30, cp->sounds[1][30:34, 1.000, [1]0.556 -> 1.000]) [buf: 100] 
   (at 35, cp->sounds[1][35:49, 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]-0.000 -> 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:99, 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp2 2: ~A" (safe-display-edits ind 0 4)))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	;; ramp ptree cases
	(for-each
	 (lambda (func func-zero name)
	   (func)
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 3 #f) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	       (snd-display #__line__ ";~A 1: ~A" name (safe-display-edits ind 0 3 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.050 0.100 0.150 0.200 0.250 0.300 0.350 0.400 0.450 0.500)))
	       (snd-display #__line__ ";~A 1: ~A" name (channel->vct)))
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 4 #f) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	       (snd-display #__line__ ";~A 2: ~A" name (safe-display-edits ind 0 4 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.005 0.020 0.045 0.080 0.125 0.180 0.245 0.320 0.405 0.500)))
	       (snd-display #__line__ ";~A 2: ~A" name (channel->vct)))
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	       (snd-display #__line__ ";~A 3: ~A" name (safe-display-edits ind 0 5 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.000 0.004 0.013 0.032 0.062 0.108 0.171 0.256 0.364 0.500)))
	       (snd-display #__line__ ";~A 3: ~A" name (channel->vct)))
	   
	   (undo 4)
	   (scale-by 0.0)
	   (func-zero)
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 4 #f) (string-append "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[0][0:10, 1.000, [1]-0.000 -> 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	       (snd-display #__line__ ";~A-zero 1: ~A" name (safe-display-edits ind 0 4 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.050 0.100 0.150 0.200 0.250 0.300 0.350 0.400 0.450 0.500)))
	       (snd-display #__line__ ";~A-zero 1: ~A" name (channel->vct)))
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 5 #f) (string-append "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [5:2]:
   (at 0, cp->sounds[0][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	       (snd-display #__line__ ";~A-zero 2: ~A" name (safe-display-edits ind 0 5 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.005 0.020 0.045 0.080 0.125 0.180 0.245 0.320 0.405 0.500)))
	       (snd-display #__line__ ";~A-zero 2: ~A" name (channel->vct)))
	   (ramp-channel 0 1)
	   (if (not (string-=? (safe-display-edits ind 0 6 #f) (string-append "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [6:2]:
   (at 0, cp->sounds[0][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	       (snd-display #__line__ ";~A-zero 3: ~A" name (safe-display-edits ind 0 6 #f)))
	   (if (not (vequal (channel->vct) (vct 0.000 0.000 0.004 0.013 0.032 0.062 0.108 0.171 0.256 0.364 0.500)))
	       (snd-display #__line__ ";~A-zero 3: ~A" name (channel->vct)))
	   (undo 5)
	   )
	 (list 
	  (lambda () (ptree-channel (lambda (y) (* y 0.5))))
	  (lambda () (ptree-channel
		      (lambda (y data forward)
			(* y (vct-ref data 0)))
		      0 (frames) ind 0 #f #f (lambda (p d) (vct 0.5)))))
	 (list 
	  (lambda () (ptree-channel (lambda (y) (+ y 0.5))))
	  (lambda () (ptree-channel
		      (lambda (y data forward)
			(+ y (vct-ref data 0)))
		      0 (frames) ind 0 #f #f (lambda (p d) (vct 0.5)))))
	 (list "ramp-ptree" "ramp-ptreec"))
	
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	;; xramp ptree cases
	(for-each
	 (lambda (func func-zero name twice)
	   (func)
	   (xramp-channel 0 1 32)
	   (if (not (vequal (channel->vct) (vct 0.000 0.007 0.016 0.029 0.048 0.075 0.113 0.166 0.242 0.349 0.500)))
	       (snd-display #__line__ ";~A 1: ~A" name (channel->vct)))
	   (if twice
	       (begin
		 (xramp-channel 0 1 32)
		 (if (not (vequal (channel->vct) (vct 0.000 0.000 0.001 0.002 0.005 0.011 0.025 0.055 0.117 0.243 0.500)))
		     (snd-display #__line__ ";~A 2: ~A" name (channel->vct)))
		 (undo 1)))
	   (undo 2)
	   (scale-by 0.0)
	   (func-zero)
	   (xramp-channel 0 1 32)
	   (if (not (vequal (channel->vct) (vct 0.000 0.007 0.016 0.029 0.048 0.075 0.113 0.166 0.242 0.349 0.500)))
	       (snd-display #__line__ ";~A-zero 1: ~A" name (channel->vct)))
	   (if twice
	       (begin
		 (xramp-channel 0 1 32)
		 (if (not (vequal (channel->vct) (vct 0.000 0.000 0.001 0.002 0.005 0.011 0.025 0.055 0.117 0.243 0.500)))
		     (snd-display #__line__ ";~A-zero 2: ~A" name (channel->vct)))
		 (undo 1)))
	   (undo 3))
	 (list 
	  (lambda () (ptree-channel (lambda (y) (* y 0.5))))
	  (lambda () (ptree-channel
		      (lambda (y data forward)
			(* y (vct-ref data 0)))
		      0 (frames) ind 0 #f #f (lambda (p d) (vct 0.5)))))
	 (list 
	  (lambda () (ptree-channel (lambda (y) (+ y 0.5))))
	  (lambda () (ptree-channel
		      (lambda (y data forward)
			(+ y (vct-ref data 0)))
		      0 (frames) ind 0 #f #f (lambda (p d) (vct 0.5)))))
	 (list "xramp-ptree" "xramp-ptreec")
	 (list #t #t))
	
	(close-sound ind))
      
      ;; ramp-xramp, xramp-ramp
      (let ((ind (new-sound "test.snd"))
	    (case1 #f)
	    (case2 #f))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 0: ~A" (safe-display-edits ind 0 3)))
	(set! case1 (channel->vct))
	(if (not (vequal case1 (vct 0.000 0.001 0.006 0.018 0.039 0.075 0.135 0.233 0.387 0.628 1.000)))
	    (snd-display #__line__ ";ramp-xramp (1): ~A" case1))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 11) ; scale-channel 0.500 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 1: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]0.000 -> 0.400, [2]0.000 -> 0.097, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.150 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 2: ~A" (safe-display-edits ind 0 4)))
	(set! case2 (channel->vct))
	(if (not (vequal case2 (vct 0.000 0.001 0.003 0.009 0.019 0.075 0.135 0.233 0.387 0.628 1.000)))
	    (snd-display #__line__ ";ramp-xramp (2): ~A" case2))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 2 4) ; scale-channel 0.500 2 4 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100, [2]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.200 -> 0.500, [2]0.032 -> 0.150, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.600 -> 1.000, [2]0.226 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 3: ~A" (safe-display-edits ind 0 4)))
	(undo 2)
	(xramp-channel 0.75 0.25 32.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.750 0.250 32.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.750 -> 0.250, off: 0.234, scl: 0.016]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 4: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(xramp-channel .2 .6 3.0 2 6)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 2 6) ; xramp-channel 0.200 0.600 3.000 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.700, [2]0.200 -> 0.600, off: -0.000, scl: 0.200]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 5: ~A" (safe-display-edits ind 0 3)))
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.400, [2]0.200 -> 0.310, off: -0.000, scl: 0.200]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.387 -> 0.600, off: -0.000, scl: 0.200]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 6: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (set 4 1) ; set-sample 4 0.5000 [4:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.300, [2]0.200 -> 0.249, off: -0.000, scl: 0.200]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.387 -> 0.600, off: -0.000, scl: 0.200]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp-xramp 7: ~A" (safe-display-edits ind 0 4)))
	(revert-sound)
	(map-chan (lambda (y) 1.0) 0 10)
	
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 0: ~A" (safe-display-edits ind 0 3)))
	(if (not (vequal case1 (channel->vct)))
	    (snd-display #__line__ ";xramp-ramp (1): ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 11) ; scale-channel 0.500 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 1: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]0.000 -> 0.400, [2]0.000 -> 0.097, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.150 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 2: ~A" (safe-display-edits ind 0 4)))
	(if (not (vequal case2 (channel->vct)))
	    (snd-display #__line__ ";xramp-ramp (2): ~A" (channel->vct)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (scale 2 4) ; scale-channel 0.500 2 4 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100, [2]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.200 -> 0.500, [2]0.032 -> 0.150, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.600 -> 1.000, [2]0.226 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 3: ~A" (safe-display-edits ind 0 4)))
	(undo 2)
	(ramp-channel 0.75 0.25)
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.750 0.250 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.750 -> 0.250, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 4: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(ramp-channel .2 .6 2 6)
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.600, [2]0.032 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 5: ~A" (safe-display-edits ind 0 3)))
	(scale-channel 0.5 0 5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.360, [2]0.032 -> 0.097, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600, [2]0.150 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 6: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (set 4 1) ; set-sample 4 0.5000 [4:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.280, [2]0.032 -> 0.059, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.440 -> 0.600, [2]0.150 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp-ramp 7: ~A" (safe-display-edits ind 0 4)))
	(close-sound ind))
      
      ;; ramp2+xramp
      (let ((ind (new-sound "test.snd"))
	    (case1 #f)
	    (case2 #f))
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 0: ~A" (safe-display-edits ind 0 4)))
	(set! case1 (channel->vct))
	(if (not (vequal case1 (vct 0.000 0.000 0.001 0.005 0.015 0.038 0.081 0.163 0.310 0.565 1.000)))
	    (snd-display #__line__ ";ramp2+xramp (1): ~A" case1))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 11) ; scale-channel 0.500 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]0.000 -> 1.000, [2]0.000 -> 1.000, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 1: ~A" (safe-display-edits ind 0 5)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 5) ; scale-channel 0.500 0 5 [5:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]0.000 -> 0.400, [2]0.000 -> 0.400, [3]0.000 -> 0.097, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.500 -> 1.000, [3]0.150 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 2: ~A" (safe-display-edits ind 0 5)))
	(set! case2 (channel->vct))
	(if (not (vequal case2 (vct 0.000 0.000 0.001 0.003 0.008 0.038 0.081 0.163 0.310 0.565 1.000)))
	    (snd-display #__line__ ";ramp2+xramp (2): ~A" case2))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 2 4) ; scale-channel 0.500 2 4 [5:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100, [2]0.000 -> 0.100, [3]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.200 -> 0.500, [2]0.200 -> 0.500, [3]0.032 -> 0.150, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.600 -> 1.000, [2]0.600 -> 1.000, [3]0.226 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 3: ~A" (safe-display-edits ind 0 5)))
	(undo 2)
	(ramp-channel 0.75 0.25)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.750 0.250 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.750 -> 0.250, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 4: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(ramp-channel .2 .6 2 6)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100, [2]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.700, [2]0.200 -> 0.600, [3]0.032 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 5: ~A" (safe-display-edits ind 0 4)))
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 5) ; scale-channel 0.500 0 5 [5:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.100, [2]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.400, [2]0.200 -> 0.360, [3]0.032 -> 0.097, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.440 -> 0.600, [3]0.150 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 6: ~A" (safe-display-edits ind 0 5)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (set 4 1) ; set-sample 4 0.5000 [5:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.100, [2]0.000 -> 0.013, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.300, [2]0.200 -> 0.280, [3]0.032 -> 0.059, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.440 -> 0.600, [3]0.150 -> 0.333, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.484 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2+xramp 7: ~A" (safe-display-edits ind 0 5)))
	(revert-sound)
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+ramp2 0: ~A" (safe-display-edits ind 0 4)))
	(if (not (vequal case1 (channel->vct)))
	    (snd-display #__line__ ";xramp+ramp2 (1): ~A" (channel->vct)))
	
	(revert-sound ind)
	(map-channel (lambda (y) 1.0) 0 100)
	(scale-channel 0.75)
	(ramp-channel .5 1)
	(ptree-channel (lambda (y) (* y (/ 1.0 0.75))))
	(scale-channel 2.0)
	(ramp-channel 1 .5)
	(ptree-channel (lambda (y) (* y .25)))
	(scale-channel 4.0)
	(ramp-channel 0 1)
	(if (fneq (maxamp) 1.0)
	    (snd-display #__line__ ";rprpr max: ~A" (maxamp)))
	
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd"))
	    (case3 #f))
	(map-channel (lambda (y) 1.0) 0 100)
	(scale-channel 0.5)
	(xramp-channel 1.0 0.0 32.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(set! case3 (channel->vct))
	(undo 4)
	
	;; multi-ramp2+xramp
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(xramp-channel 1.0 0.0 32.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 14) "
 (ramp 0 100) ; ramp-channel 0.000 1.000 0 #f [14:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, [2]0.000 -> 0.091, [3]1.000 -> 0.721, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, [2]0.101 -> 0.192, [3]0.695 -> 0.499, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, [2]0.202 -> 0.293, [3]0.480 -> 0.342, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, [2]0.303 -> 0.394, [3]0.329 -> 0.231, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, [2]0.404 -> 0.495, [3]0.222 -> 0.153, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, [2]0.505 -> 0.596, [3]0.147 -> 0.099, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, [2]0.606 -> 0.697, [3]0.094 -> 0.060, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, [2]0.707 -> 0.798, [3]0.057 -> 0.033, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, [2]0.808 -> 0.899, [3]0.030 -> 0.014, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, [2]0.909 -> 1.000, [3]0.012 -> 0.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp2+xramp 1: ~A" (safe-display-edits ind 0 14)))
	(if (not (vequal case3 (channel->vct)))
	    (snd-display #__line__ ";multi-ramp2+xramp:~%;  ~A~%;  ~A" 
			 case3 (channel->vct)))
	(revert-sound)
	(map-channel (lambda (y) 1.0) 0 100)
	(xramp-channel 1.0 0.0 32.0)
	
	(ramp-channel 0.0 1.0 10 20)
	(ramp-channel 0.0 1.0 50 10)
	(ramp-channel 0.0 1.0 25 10)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (ramp 25 10) ; ramp-channel 0.000 1.000 25 10 [5:8]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]1.000 -> 0.721, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:24, 1.000, [1]0.000 -> 0.737, [2]0.695 -> 0.413, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 25, cp->sounds[1][25:29, 1.000, [1]0.789 -> 1.000, [2]0.000 -> 0.444, [3]0.398 -> 0.342, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 30, cp->sounds[1][30:34, 1.000, [1]0.556 -> 1.000, [2]0.329 -> 0.282, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 35, cp->sounds[1][35:49, 1.000, [1]0.271 -> 0.153, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.000 -> 1.000, [2]0.147 -> 0.099, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 60, cp->sounds[1][60:99, 1.000, [1]0.094 -> 0.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp2+xramp 2: ~A" (safe-display-edits ind 0 5)))
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd"))
	    (case3 #f))
	(map-channel (lambda (y) 1.0) 0 100)
	(scale-channel 0.5)
	(ramp-channel 0.0 1.0)
	(xramp-channel 1.0 0.0 32.0)
	(set! case3 (channel->vct))
	(undo 3)
	
	;; multi-ramp-xramp
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(ramp-channel 0.0 1.0)
	(xramp-channel 1.0 0.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 13) "
 (ramp 0 100) ; xramp-channel 1.000 0.000 32.000 0 #f [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, [2]1.000 -> 0.721, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, [2]0.695 -> 0.499, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, [2]0.480 -> 0.342, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, [2]0.329 -> 0.231, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, [2]0.222 -> 0.153, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, [2]0.147 -> 0.099, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, [2]0.094 -> 0.060, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, [2]0.057 -> 0.033, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, [2]0.030 -> 0.014, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, [2]0.012 -> 0.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp-xramp 1: ~A" (safe-display-edits ind 0 13)))
	(if (not (vequal case3 (channel->vct)))
	    (snd-display #__line__ ";multi-ramp-xramp: ~A" (channel->vct)))
	(undo 12)
	(xramp-channel 0.0 1.0 3.0 10 20)
	(xramp-channel 0.0 1.0 3.0 50 10)
	(xramp-channel 0.0 1.0 3.0 25 10)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 25 10) ; xramp-channel 0.000 1.000 3.000 25 10 [4:8]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:24, 1.000, [1]0.000 -> 0.623, off: -0.500, scl: 0.500]) [buf: 100] 
   (at 25, cp->sounds[1][25:29, 1.000, [1]0.690 -> 1.000, off: -0.500, scl: 0.500, [2]0.000 -> 0.315, off: -0.500, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:34, 1.000, [1]0.421 -> 1.000, off: -0.500, scl: 0.500]) [buf: 100] 
   (at 35, cp->sounds[1][35:49, 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.000 -> 1.000, off: -0.500, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:99, 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp-xramp 2: ~A" (safe-display-edits ind 0 4)))
	(revert-sound)
	
	(map-channel (lambda (y) 1.0) 0 100)
	;; multi-xramp-ramp
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(xramp-channel 1.0 0.0 32.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 13) "
 (ramp 0 100) ; ramp-channel 0.000 1.000 0 #f [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, [2]1.000 -> 0.721, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, [2]0.695 -> 0.499, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, [2]0.480 -> 0.342, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, [2]0.329 -> 0.231, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, [2]0.222 -> 0.153, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, [2]0.147 -> 0.099, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, [2]0.094 -> 0.060, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, [2]0.057 -> 0.033, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, [2]0.030 -> 0.014, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, [2]0.012 -> 0.000, off: -0.032, scl: 0.032]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-xramp-ramp 3: ~A" (safe-display-edits ind 0 13)))
	(if (not (vequal case3 (channel->vct)))
	    (snd-display #__line__ ";case3 xramp-ramp 3: ~A" (channel->vct)))
	(undo 12)
	(ramp-channel 0.0 1.0 10 20)
	(ramp-channel 0.0 1.0 50 10)
	(ramp-channel 0.0 1.0 25 10)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 25 10) ; ramp-channel 0.000 1.000 25 10 [4:8]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:24, 1.000, [1]-0.000 -> 0.737]) [buf: 100] 
   (at 25, cp->sounds[1][25:29, 1.000, [1]0.789 -> 1.000, [2]-0.000 -> 0.444]) [buf: 100] 
   (at 30, cp->sounds[1][30:34, 1.000, [1]0.556 -> 1.000]) [buf: 100] 
   (at 35, cp->sounds[1][35:49, 1.000]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]-0.000 -> 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:99, 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-xramp-ramp 2: ~A" (safe-display-edits ind 0 4)))
	(close-sound ind))
      
      ;; xramp2
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(xramp-channel 0.0 1.0 2.0)
	(xramp-channel 0.0 1.0 2.0)
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 2.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, off: -1.000, scl: 1.000, [2]0.000 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 0: ~A" (safe-display-edits ind 0 3)))
	(if (not (vequal (channel->vct) (vct 0.000 0.005 0.022 0.053 0.102 0.172 0.266 0.390 0.549 0.750 1.000)))
	    (snd-display #__line__ ";xramp2 (1): ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (scale 0 11) ; scale-channel 0.500 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]0.000 -> 1.000, off: -1.000, scl: 1.000, [2]0.000 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 1: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]0.000 -> 0.320, off: -1.000, scl: 1.000, [2]0.000 -> 0.320, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.414 -> 1.000, off: -1.000, scl: 1.000, [2]0.414 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 2: ~A" (safe-display-edits ind 0 4)))
	(if (not (vequal (channel->vct) (vct 0.000 0.003 0.011 0.027 0.051 0.172 0.266 0.390 0.549 0.750 1.000)))
	    (snd-display #__line__ ";xramp2 (2): ~A" (channel->vct)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (scale 2 4) ; scale-channel 0.500 2 4 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.072, off: -1.000, scl: 1.000, [2]0.000 -> 0.072, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.149 -> 0.414, off: -1.000, scl: 1.000, [2]0.149 -> 0.414, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.516 -> 1.000, off: -1.000, scl: 1.000, [2]0.516 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 3: ~A" (safe-display-edits ind 0 4)))
	(undo 2)
	(xramp-channel 0.75 0.25 0.3)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.750 0.250 0.300 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, off: -1.000, scl: 1.000, [2]0.750 -> 0.250, off: 0.964, scl: -0.714]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 4: ~A" (safe-display-edits ind 0 3)))
	(undo)
	(xramp-channel .2 .6 32.0 2 6)
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ramp 2 6) ; xramp-channel 0.200 0.600 32.000 2 6 [3:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.072, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.149 -> 0.625, off: -1.000, scl: 1.000, [2]0.200 -> 0.600, off: 0.187, scl: 0.013]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.741 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 5: ~A" (safe-display-edits ind 0 3)))
	(scale-channel 0.5 0 5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (scale 0 5) ; scale-channel 0.500 0 5 [4:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]0.000 -> 0.072, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.149 -> 0.320, off: -1.000, scl: 1.000, [2]0.200 -> 0.239, off: 0.187, scl: 0.013]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.414 -> 0.625, off: -1.000, scl: 1.000, [2]0.290 -> 0.600, off: 0.187, scl: 0.013]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.741 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 6: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (set 4 1) ; set-sample 4 0.5000 [4:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.072, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.149 -> 0.231, off: -1.000, scl: 1.000, [2]0.200 -> 0.213, off: 0.187, scl: 0.013]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.414 -> 0.625, off: -1.000, scl: 1.000, [2]0.290 -> 0.600, off: 0.187, scl: 0.013]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.741 -> 1.000, off: -1.000, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp2 7: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 100)
	
	;; multi-xramp2
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(xramp-channel 0.0 1.0 3.0)
	(xramp-channel 1.0 0.0 0.3)
	(if (not (string-=? (safe-display-edits ind 0 13) "
 (ramp 0 100) ; xramp-channel 1.000 0.000 0.300 0 #f [13:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.053, off: -0.500, scl: 0.500, [2]1.000 -> 0.950, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.059 -> 0.117, off: -0.500, scl: 0.500, [2]0.945 -> 0.889, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.124 -> 0.190, off: -0.500, scl: 0.500, [2]0.882 -> 0.819, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.198 -> 0.271, off: -0.500, scl: 0.500, [2]0.811 -> 0.740, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.279 -> 0.361, off: -0.500, scl: 0.500, [2]0.731 -> 0.651, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.371 -> 0.462, off: -0.500, scl: 0.500, [2]0.641 -> 0.550, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.473 -> 0.575, off: -0.500, scl: 0.500, [2]0.540 -> 0.437, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.587 -> 0.701, off: -0.500, scl: 0.500, [2]0.425 -> 0.308, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.715 -> 0.842, off: -0.500, scl: 0.500, [2]0.295 -> 0.164, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.857 -> 1.000, off: -0.500, scl: 0.500, [2]0.148 -> 0.000, off: 1.429, scl: -1.429]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-xramp2 1: ~A" (safe-display-edits ind 0 13)))
	(close-sound ind))
      
      ;; ptree+ramp2
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 4 #f) "
 (ptree[0] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp2 0: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ptree-ramp2 (1): ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (scale 0 11) ; scale-channel 0.500 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp2 1: ~A" (safe-display-edits ind 0 5 #f)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (scale 0 5) ; scale-channel 0.500 0 5 [5:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.400, [2]-0.000 -> 0.400, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.500 -> 1.000, loc: 0, pos: 5, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp2 2: ~A" (safe-display-edits ind 0 5 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.005 0.020 0.045 0.080 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ptree-ramp2 (2): ~A" (channel->vct)))
	(undo 4)
	
	(scale-channel .5)
	(env-channel '(0 0 1 1 2 0))
	(ramp-channel 0 1 2 3)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ptree[0] 0 11) ; ptree-channel [5:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]0.000 -> 0.200, loc: 0, pos: 0, scl: 0.500]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 1.000, [1]0.400 -> 0.800, [2]0.000 -> 1.000, loc: 0, pos: 2, scl: 0.500]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]1.000 -> -0.000, loc: 0, pos: 5, scl: 0.500]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp2 4: ~A" (safe-display-edits ind 0 5 #f)))
	
	(undo 4)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y data forward)
			 (* y (vct-ref data 0)))
		       0 (frames) ind 0 #f #t
		       (lambda (pos dur)
			 (vct 0.5)))
	(if (not (string-=? (safe-display-edits ind 0 4 #f) "
 (ptree[0] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp2 5: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.005 0.020 0.045 0.080 0.125 0.180 0.245 0.320 0.405 0.500)))
	    (snd-display #__line__ ";ptree+closure+ramp2: ~A" (channel->vct)))
	
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 100)
	
	;; multi-ramp2
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(ramp-channel 0.0 1.0)
	(ramp-channel 1.0 0.0)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 14 #f) "
 (ptree[0] 0 100) ; ptree-channel [14:11]:
   (at 0, cp->sounds[1][0:9, 1.000, [1]0.000 -> 0.091, [2]1.000 -> 0.909, loc: 0, pos: 0, scl: 0.500]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.101 -> 0.192, [2]0.899 -> 0.808, loc: 0, pos: 10, scl: 0.500]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.202 -> 0.293, [2]0.798 -> 0.707, loc: 0, pos: 20, scl: 0.500]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 1.000, [1]0.303 -> 0.394, [2]0.697 -> 0.606, loc: 0, pos: 30, scl: 0.500]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.404 -> 0.495, [2]0.596 -> 0.505, loc: 0, pos: 40, scl: 0.500]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]0.505 -> 0.596, [2]0.495 -> 0.404, loc: 0, pos: 50, scl: 0.500]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.606 -> 0.697, [2]0.394 -> 0.303, loc: 0, pos: 60, scl: 0.500]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 1.000, [1]0.707 -> 0.798, [2]0.293 -> 0.202, loc: 0, pos: 70, scl: 0.500]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 1.000, [1]0.808 -> 0.899, [2]0.192 -> 0.101, loc: 0, pos: 80, scl: 0.500]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 1.000, [1]0.909 -> 1.000, [2]0.091 -> -0.000, loc: 0, pos: 90, scl: 0.500]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";ptree multi-ramp2 1: ~A" (safe-display-edits ind 0 14 #f)))
	(undo 12)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (+ y .1)))
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ptree[0] 0 11) ; ptree-channel [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp3 0: ~A" (safe-display-edits ind 0 5 #f)))
	(if (not (vequal (channel->vct) (vct 0.100 0.101 0.108 0.127 0.164 0.225 0.316 0.443 0.612 0.829 1.100)))
	    (snd-display #__line__ ";ptree-ramp3 1: ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 6 #f) "
 (scale 0 11) ; scale-channel 0.500 0 #f [6:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp3 2: ~A" (safe-display-edits ind 0 6 #f)))
	
	(undo 5)
	(ramp-channel 0 1)
	(ramp-channel 0 1 5 5)
	(ramp-channel 0 1 7 3)
	(ptree-channel (lambda (y) (+ y .1)))
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ptree[0] 0 11) ; ptree-channel [5:5]:
   (at 0, cp->sounds[1][0:4, 1.000, [1]-0.000 -> 0.400, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 5, cp->sounds[1][5:6, 1.000, [1]0.500 -> 0.600, [2]0.000 -> 0.250, loc: 0, pos: 5, scl: 1.000]) [buf: 11] 
   (at 7, cp->sounds[1][7:9, 1.000, [1]0.700 -> 0.900, [2]0.500 -> 1.000, [3]0.000 -> 1.000, loc: 0, pos: 7, scl: 1.000]) [buf: 11] 
   (at 10, cp->sounds[1][10:10, 1.000, [1]1.000 -> 1.000, loc: 0, pos: 10, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree-ramp3 3: ~A" (safe-display-edits ind 0 5 #f)))
	(if (not (vequal (channel->vct) (vct 0.100 0.200 0.300 0.400 0.500 0.100 0.250 0.100 0.400 1.000 1.100)))
	    (snd-display #__line__ ";ptree-ramp3 4: ~A" (channel->vct)))
	(close-sound ind))
      
      ;; ramp3
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 0: ~A" (safe-display-edits ind 0 4)))
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.008 0.027 0.064 0.125 0.216 0.343 0.512 0.729 1.000)))
	    (snd-display #__line__ ";ramp3 (1): ~A" (channel->vct)))
	(scale-channel 0.5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 11) ; scale-channel 0.500 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 0.500, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 1: ~A" (safe-display-edits ind 0 5)))
	(undo)
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 5) ; scale-channel 0.500 0 5 [5:3]:
   (at 0, cp->sounds[1][0:4, 0.500, [1]-0.000 -> 0.400, [2]-0.000 -> 0.400, [3]-0.000 -> 0.400]) [buf: 11] 
   (at 5, cp->sounds[1][5:10, 1.000, [1]0.500 -> 1.000, [2]0.500 -> 1.000, [3]0.500 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 2: ~A" (safe-display-edits ind 0 5)))
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.004 0.014 0.032 0.125 0.216 0.343 0.512 0.729 1.000)))
	    (snd-display #__line__ ";ramp3 (2): ~A" (channel->vct)))
	(undo)
	(scale-channel 0.5 2 4)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 2 4) ; scale-channel 0.500 2 4 [5:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100, [2]-0.000 -> 0.100, [3]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:5, 0.500, [1]0.200 -> 0.500, [2]0.200 -> 0.500, [3]0.200 -> 0.500]) [buf: 11] 
   (at 6, cp->sounds[1][6:10, 1.000, [1]0.600 -> 1.000, [2]0.600 -> 1.000, [3]0.600 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 3: ~A" (safe-display-edits ind 0 5)))
	(undo 2)
	(ramp-channel 0.75 0.25)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.750 0.250 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]0.750 -> 0.250]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 4: ~A" (safe-display-edits ind 0 4)))
	(undo)
	(ramp-channel .2 .6 2 6)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 2 6) ; ramp-channel 0.200 0.600 2 6 [4:4]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100, [2]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:7, 1.000, [1]0.200 -> 0.700, [2]0.200 -> 0.700, [3]0.200 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 5: ~A" (safe-display-edits ind 0 4)))
	(scale-channel 0.5 0 5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (scale 0 5) ; scale-channel 0.500 0 5 [5:5]:
   (at 0, cp->sounds[1][0:1, 0.500, [1]-0.000 -> 0.100, [2]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:4, 0.500, [1]0.200 -> 0.400, [2]0.200 -> 0.400, [3]0.200 -> 0.360]) [buf: 11] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.500 -> 0.700, [3]0.440 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 6: ~A" (safe-display-edits ind 0 5)))
	(undo)
	(set! (sample 4) .5)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (set 4 1) ; set-sample 4 0.5000 [5:6]:
   (at 0, cp->sounds[1][0:1, 1.000, [1]-0.000 -> 0.100, [2]-0.000 -> 0.100]) [buf: 11] 
   (at 2, cp->sounds[1][2:3, 1.000, [1]0.200 -> 0.300, [2]0.200 -> 0.300, [3]0.200 -> 0.280]) [buf: 11] 
   (at 4, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 5, cp->sounds[1][5:7, 1.000, [1]0.500 -> 0.700, [2]0.500 -> 0.700, [3]0.440 -> 0.600]) [buf: 11] 
   (at 8, cp->sounds[1][8:10, 1.000, [1]0.800 -> 1.000, [2]0.800 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3 7: ~A" (safe-display-edits ind 0 5)))
	(undo 3)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-channel (lambda (y) 1.0) 0 100)
	
	;; multi-ramp3
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (scale-channel 0.5 (* i 10) 10))
	(ramp-channel 0.0 1.0)
	(ramp-channel 1.0 -0.5)
	(ramp-channel -0.5 1.5)
	(if (not (string=? (safe-display-edits ind 0 14) "
 (ramp 0 100) ; ramp-channel -0.500 1.500 0 #f [14:11]:
   (at 0, cp->sounds[1][0:9, 0.500, [1]0.000 -> 0.091, [2]1.000 -> 0.864, [3]-0.500 -> -0.318]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 0.500, [1]0.101 -> 0.192, [2]0.848 -> 0.712, [3]-0.298 -> -0.116]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 0.500, [1]0.202 -> 0.293, [2]0.697 -> 0.561, [3]-0.096 -> 0.086]) [buf: 100] 
   (at 30, cp->sounds[1][30:39, 0.500, [1]0.303 -> 0.394, [2]0.545 -> 0.409, [3]0.106 -> 0.288]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 0.500, [1]0.404 -> 0.495, [2]0.394 -> 0.258, [3]0.308 -> 0.490]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 0.500, [1]0.505 -> 0.596, [2]0.242 -> 0.106, [3]0.510 -> 0.692]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 0.500, [1]0.606 -> 0.697, [2]0.091 -> -0.045, [3]0.712 -> 0.894]) [buf: 100] 
   (at 70, cp->sounds[1][70:79, 0.500, [1]0.707 -> 0.798, [2]-0.061 -> -0.197, [3]0.914 -> 1.096]) [buf: 100] 
   (at 80, cp->sounds[1][80:89, 0.500, [1]0.808 -> 0.899, [2]-0.212 -> -0.348, [3]1.116 -> 1.298]) [buf: 100] 
   (at 90, cp->sounds[1][90:99, 0.500, [1]0.909 -> 1.000, [2]-0.364 -> -0.500, [3]1.318 -> 1.500]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp3 1: ~A" (safe-display-edits ind 0 14)))
	(undo 13)
	(ramp-channel 0.0 1.0 10 30)
	(ramp-channel 0.0 1.0 50 20)
	(ramp-channel 0.0 1.0 20 15)
	(ramp-channel 0.0 1.0 30 30)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (ramp 30 30) ; ramp-channel 0.000 1.000 30 30 [5:10]:
   (at 0, cp->sounds[1][0:9, 1.000]) [buf: 100] 
   (at 10, cp->sounds[1][10:19, 1.000, [1]0.000 -> 0.310]) [buf: 100] 
   (at 20, cp->sounds[1][20:29, 1.000, [1]0.345 -> 0.655, [2]-0.000 -> 0.643]) [buf: 100] 
   (at 30, cp->sounds[1][30:34, 1.000, [1]0.690 -> 0.828, [2]0.714 -> 1.000, [3]0.000 -> 0.138]) [buf: 100] 
   (at 35, cp->sounds[1][35:39, 1.000, [1]0.862 -> 1.000, [2]0.172 -> 0.310]) [buf: 100] 
   (at 40, cp->sounds[1][40:49, 1.000, [1]0.345 -> 0.655]) [buf: 100] 
   (at 50, cp->sounds[1][50:59, 1.000, [1]-0.000 -> 0.474, [2]0.690 -> 1.000]) [buf: 100] 
   (at 60, cp->sounds[1][60:69, 1.000, [1]0.526 -> 1.000]) [buf: 100] 
   (at 70, cp->sounds[1][70:99, 1.000]) [buf: 100] 
   (at 100, end_mark)
"))
	    (snd-display #__line__ ";multi-ramp3 2: ~A" (safe-display-edits ind 0 5)))
	
	(let ((vals (channel->vct)))
	  (undo 4)
	  (ptree-channel (lambda (y) y))
	  (ramp-channel 0.0 1.0 10 30)
	  (ptree-channel (lambda (y) y))
	  (ramp-channel 0.0 1.0 50 20)
	  (ptree-channel (lambda (y) y))
	  (ramp-channel 0.0 1.0 20 15)
	  (ptree-channel (lambda (y) y))
	  (ramp-channel 0.0 1.0 30 30)
	  (if (not (vequal vals (channel->vct)))
	      (snd-display #__line__ ";ramp3 opt vs unopt: ~A ~A" vals (channel->vct))))
	
	(close-sound ind))
      
      ;; various cases not optimized, presumably
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	;; ramp+xramp (now optimized)
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp+xramp: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	
	;; xramp+xramp -- this one now optimized
	(xramp-channel 0.0 1.0 0.32)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, off: 1.471, scl: -1.471, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+xramp: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	
	;; xramp+xramp+xramp
	(xramp-channel 0.0 1.0 0.32)
	(xramp-channel 0.0 1.0 32.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, off: 1.471, scl: -1.471, [2]0.000 -> 1.000, off: -0.032, scl: 0.032, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+xramp+xramp (maxed): ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	
	;; xramp+xramp+ramp (now optimized)
	(xramp-channel 0.0 1.0 0.32)
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: 1.471, scl: -1.471, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+xramp+ramp: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	
	;; xramp+ramp (now optimized)
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+ramp: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	
	;; ramp+ramp+xramp
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, [3]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp+ramp+xramp: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	
	;; ramp+ramp+ramp+ramp
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, [4]-0.000 -> 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp+ramp+ramp+ramp: ~A" (safe-display-edits ind 0 5)))
	(undo 4)
	
	;; ramp+ramp+ramp+xramp
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, [3]0.000 -> 1.000, [4]0.000 -> 1.000, off: -0.032, scl: 0.032]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp+ramp+ramp+xramp: ~A" (safe-display-edits ind 0 5)))
	(undo 4)
	
	;; ptree+ramp (now optimized)
	(ptree-channel (lambda (y) y))
	(ramp-channel 0.0 1.0)
	(if (not (string-=? (safe-display-edits ind 0 3) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) y)]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree+ramp: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	
	;; ramp+xramp+ptree (now optimized)
	(ramp-channel 0.0 1.0)
	(xramp-channel 0.0 1.0 32.0)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ptree[0] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) y)]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp+xramp+ptree: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	
	;; xramp+ramp+ptree (now optimized)
	(xramp-channel 0.0 1.0 32.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 4) "
 (ptree[0] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, [2]0.000 -> 1.000, off: -0.032, scl: 0.032, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) y)]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp+ramp+ptree: ~A" (safe-display-edits ind 0 4)))
	(undo 3)
	
	;; ramp3+ptree (now optimized)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) y))
	(if (not (string-=? (safe-display-edits ind 0 5) "
 (ptree[0] 0 11) ; ptree-channel [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, [3]-0.000 -> 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) y)]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp3+ptree: ~A" (safe-display-edits ind 0 5)))
	(undo 4)
	
	;; ptree+ptree (now optimized)
	(ptree-channel (lambda (y) y))
	(ptree-channel (lambda (y) y))
	(if (not (string=? (safe-display-edits ind 0 3) "
 (ptree[1] 0 11) ; ptree-channel [3:2]:
   (at 0, cp->sounds[1][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000, code: (lambda (y) y)]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ptree+ptree: ~A" (safe-display-edits ind 0 3)))
	(undo 2)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd")))
	(map-chan (lambda (y) 1.0) 0 10)
	
	;; ramp ptree2 cases
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ramp-channel 0 1)
	(if (not (string-=? (safe-display-edits ind 0 4 #f) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp ptree2: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0)))
	    (snd-display #__line__ ";ramp ptree2: ~A" (channel->vct)))
	(ramp-channel 0 1)
	(if (not (string-=? (safe-display-edits ind 0 5 #f) "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [5:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]-0.000 -> 1.000, [2]-0.000 -> 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";ramp2 ptree2: ~A" (safe-display-edits ind 0 5 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ramp2 ptree2: ~A" (channel->vct)))
	(undo 2)
	(xramp-channel 0 1 32)
	(if (not (string=? (safe-display-edits ind 0 4 #f) "
 (ramp 0 11) ; xramp-channel 0.000 1.000 32.000 0 #f [4:2]:
   (at 0, cp->sounds[1][0:10, 1.000, [1]0.000 -> 1.000, off: -0.032, scl: 0.032, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 1.000]) [buf: 11] 
   (at 11, end_mark)
"))
	    (snd-display #__line__ ";xramp ptree2: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.013 0.032 0.059 0.097 0.150 0.226 0.333 0.484 0.698 1.000)))
	    (snd-display #__line__ ";xramp ptree2: ~A" (channel->vct)))
	
	(undo 3)
	(scale-channel 0.0)
	
	(ptree-channel (lambda (y) (+ y 0.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ramp-channel 0 1)
	(if (not (string=? (safe-display-edits ind 0 4 #f) (string-append "
 (ptree[1] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[0][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";ramp ptree2 zero: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0)))
	    (snd-display #__line__ ";ramp ptree2 zero: ~A" (channel->vct)))
	(ramp-channel 0 1)
	(if (not (string-=? (safe-display-edits ind 0 5 #f) (string-append "
 (ramp 0 11) ; ramp-channel 0.000 1.000 0 #f [5:2]:
   (at 0, cp->sounds[0][0:10, 1.000, [1]-0.000 -> 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";ramp2 ptree2 zero: ~A" (safe-display-edits ind 0 5 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ramp2 ptree2 zero: ~A" (channel->vct)))
	(undo 2)
	(xramp-channel 0 1 32)
	(if (not (string=? (safe-display-edits ind 0 4 #f) (string-append "
 (ptree[1] 0 11) ; ptree-channel [4:2]:
   (at 0, cp->sounds[0][0:10, 1.000, loc2: 1, pos2: 0, scl2: 1.000, loc: 0, pos: 0, scl: 0.000]) [file: " (getcwd) "/test.snd[0]]
   (at 11, end_mark)
")))
	    (snd-display #__line__ ";xramp ptree2 zero: ~A" (safe-display-edits ind 0 4 #f)))
	(if (not (vequal (channel->vct) (vct 0.000 0.013 0.032 0.059 0.097 0.150 0.226 0.333 0.484 0.698 1.000)))
	    (snd-display #__line__ ";xramp ptree2 zero: ~A" (channel->vct)))
	
	(close-sound ind))
      
      ;; ptree3 + ramps
      (let ((ind (new-sound "test.snd"))
	    (case1 #f)
	    (case2 #f))
	(map-chan (lambda (y) 1.0) 0 10)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (make-vct 11 4.0)))
	    (snd-display #__line__ ";ptree3 1: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 16)))
	    (snd-display #__line__ ";ptree3 2: ~A" (edit-tree)))
	
	(scale-channel 0.25)
	(if (not (vequal (channel->vct) (make-vct 11 1.0)))
	    (snd-display #__line__ ";ptree3 3: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.250 0.0 0.0 16)))
	    (snd-display #__line__ ";ptree3 4: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900 1.000)))
	    (snd-display #__line__ ";ptree3 5: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.25 0.0 0.1 26)))
	    (snd-display #__line__ ";ptree3 6: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ptree3 7: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.25 0.0 0.1 26)))
	    (snd-display #__line__ ";ptree3 8: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.008 0.027 0.064 0.125 0.216 0.343 0.512 0.729 1.000)))
	    (snd-display #__line__ ";ptree3 9: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.25 0.0 0.1 26)))
	    (snd-display #__line__ ";ptree3 10: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.000 0.002 0.008 0.026 0.062 0.130 0.240 0.410 0.656 1.000)))
	    (snd-display #__line__ ";ptree3 11: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.25 0.0 0.1 26)))
	    (snd-display #__line__ ";ptree3 12: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.25 0.0 0.1 26)))
	    (snd-display #__line__ ";ptree3 13: ~A" (edit-tree)))
	
	;; ptree3-zero + ramps
	(revert-sound ind)
	(map-chan (lambda (y) 1.0) 0 10)
	(scale-by 0.0)
	
	(ptree-channel (lambda (y) (+ y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (make-vct 11 4.0)))
	    (snd-display #__line__ ";ptree3 14: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.0 18)))
	    (snd-display #__line__ ";ptree3 15: ~A" (edit-tree)))
	
	(scale-channel 0.25)
	(if (not (vequal (channel->vct) (make-vct 11 1.0)))
	    (snd-display #__line__ ";ptree3 16: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 0.250 0.0 0.0 18)))
	    (snd-display #__line__ ";ptree3 17: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.100 0.200 0.300 0.400 0.500 0.600 0.700 0.800 0.900 1.000)))
	    (snd-display #__line__ ";ptree3 18: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 0.25 0.0 0.1 28)))
	    (snd-display #__line__ ";ptree3 19: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.010 0.040 0.090 0.160 0.250 0.360 0.490 0.640 0.810 1.000)))
	    (snd-display #__line__ ";ptree3 20: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 0.25 0.0 0.1 28)))
	    (snd-display #__line__ ";ptree3 21: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.008 0.027 0.064 0.125 0.216 0.343 0.512 0.729 1.000)))
	    (snd-display #__line__ ";ptree3 22: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 0.25 0.0 0.1 28)))
	    (snd-display #__line__ ";ptree3 23: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.000 0.002 0.008 0.026 0.062 0.130 0.240 0.410 0.656 1.000)))
	    (snd-display #__line__ ";ptree3 24: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 0.25 0.0 0.1 28)))
	    (snd-display #__line__ ";ptree3 25: ~A" (edit-tree)))
	
	(revert-sound ind)
	
	;; ptree3 + various scalers
	(map-chan (lambda (y) 1.0) 0 10)
	(scale-channel 0.5)
	(ptree-channel (lambda (y) (+ y 0.5)))
	(scale-channel 2.0)
	(ptree-channel (lambda (y) (+ y 1.5)))
	(scale-channel 0.25)
	(ptree-channel (lambda (y) (+ y 1.0)))
	(scale-channel 0.1)
	(if (not (vequal (channel->vct) (vct 0.188 0.188 0.188 0.188 0.188 0.188 0.188 0.188 0.188 0.188 0.188)))
	    (snd-display #__line__ ";ptree3 26: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 0.100000001490116 0.0 0.0 16)))
	    (snd-display #__line__ ";ptree3 27: ~A" (edit-tree)))
	(revert-sound ind)
	
	;; ramps + ptree3
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.100 3.200 3.300 3.400 3.500 3.600 3.700 3.800 3.900 4.000)))
	    (snd-display #__line__ ";ptree3 28: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 20)))
	    (snd-display #__line__ ";ptree3 29: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.010 3.040 3.090 3.160 3.250 3.360 3.490 3.640 3.810 4.000)))
	    (snd-display #__line__ ";ptree3 30: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 20)))
	    (snd-display #__line__ ";ptree3 31: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.001 3.008 3.027 3.064 3.125 3.216 3.343 3.512 3.729 4.000)))
	    (snd-display #__line__ ";ptree3 32: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 20)))
	    (snd-display #__line__ ";ptree3 33: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.000 3.002 3.008 3.026 3.062 3.130 3.240 3.410 3.656 4.000)))
	    (snd-display #__line__ ";ptree3 34: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 20)))
	    (snd-display #__line__ ";ptree3 35: ~A" (edit-tree)))
	(revert-sound ind)
	
	
	;; xramps+ptree3 and vice-versa
	(map-chan (lambda (y) 1.0) 0 10)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(xramp-channel 0.0 1.0 10.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.115 0.260 0.442 0.672 0.961 1.325 1.783 2.360 3.086 4.000)))
	    (snd-display #__line__ ";ptree3 36: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 30)))
	    (snd-display #__line__ ";ptree3 37: ~A" (edit-tree)))
	
	(xramp-channel 0.0 1.0 10.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.003 0.017 0.049 0.113 0.231 0.439 0.795 1.392 2.381 4.000)))
	    (snd-display #__line__ ";ptree3 38: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 30)))
	    (snd-display #__line__ ";ptree3 39: ~A" (edit-tree)))
	
	(undo)
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.012 0.052 0.133 0.269 0.481 0.795 1.248 1.888 2.777 4.000)))
	    (snd-display #__line__ ";ptree3 40: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 34)))
	    (snd-display #__line__ ";ptree3 41: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.010 0.040 0.108 0.240 0.477 0.874 1.510 2.500 4.000)))
	    (snd-display #__line__ ";ptree3 42: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 34)))
	    (snd-display #__line__ ";ptree3 43: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.000 0.002 0.012 0.043 0.120 0.286 0.612 1.208 2.250 4.000)))
	    (snd-display #__line__ ";ptree3 44: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 34)))
	    (snd-display #__line__ ";ptree3 45: ~A" (edit-tree)))
	
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(scale-channel 0.0)
	(ptree-channel (lambda (y) (+ y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(xramp-channel 0.0 1.0 10.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.115 0.260 0.442 0.672 0.961 1.325 1.783 2.360 3.086 4.000)))
	    (snd-display #__line__ ";ptree3 46: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.0 32)))
	    (snd-display #__line__ ";ptree3 47: ~A" (edit-tree)))
	
	(xramp-channel 0.0 1.0 10.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.003 0.017 0.049 0.113 0.231 0.439 0.795 1.392 2.381 4.000)))
	    (snd-display #__line__ ";ptree3 48: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.0 32)))
	    (snd-display #__line__ ";ptree3 49: ~A" (edit-tree)))
	
	(undo)
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.012 0.052 0.133 0.269 0.481 0.795 1.248 1.888 2.777 4.000)))
	    (snd-display #__line__ ";ptree3 50: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.1 36)))
	    (snd-display #__line__ ";ptree3 51: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.001 0.010 0.040 0.108 0.240 0.477 0.874 1.510 2.500 4.000)))
	    (snd-display #__line__ ";ptree3 52: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.1 36)))
	    (snd-display #__line__ ";ptree3 53: ~A" (edit-tree)))
	
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.000 0.002 0.012 0.043 0.120 0.286 0.612 1.208 2.250 4.000)))
	    (snd-display #__line__ ";ptree3 54: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 0 0 10 1.0 0.0 0.1 36)))
	    (snd-display #__line__ ";ptree3 55: ~A" (edit-tree)))
	
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.029 3.065 3.111 3.168 3.240 3.331 3.446 3.590 3.771 4.000)))
	    (snd-display #__line__ ";ptree3 56: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 22)))
	    (snd-display #__line__ ";ptree3 57: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(ramp-channel 0.0 1.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.003 3.013 3.033 3.067 3.120 3.199 3.312 3.472 3.694 4.000)))
	    (snd-display #__line__ ";ptree3 58: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 24)))
	    (snd-display #__line__ ";ptree3 59: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(xramp-channel 0.0 1.0 10.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(if (not (vequal (channel->vct) (vct 3.000 3.001 3.004 3.012 3.028 3.058 3.110 3.199 3.348 3.595 4.000)))
	    (snd-display #__line__ ";ptree3 60: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 22)))
	    (snd-display #__line__ ";ptree3 61: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.303 0.613 0.933 1.267 1.620 1.999 2.412 2.872 3.394 4.000)))
	    (snd-display #__line__ ";ptree3 62: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 39)))
	    (snd-display #__line__ ";ptree3 63: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.030 0.123 0.280 0.507 0.810 1.199 1.688 2.298 3.055 4.000)))
	    (snd-display #__line__ ";ptree3 64: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 39)))
	    (snd-display #__line__ ";ptree3 65: ~A" (edit-tree)))
	(revert-sound ind)
	
	
	(map-chan (lambda (y) 1.0) 0 10)
	(xramp-channel 0.0 1.0 10.0)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(ramp-channel 0.0 1.0)
	(if (not (vequal (channel->vct) (vct 0.000 0.003 0.025 0.084 0.203 0.405 0.720 1.182 1.838 2.749 4.000)))
	    (snd-display #__line__ ";ptree3 66: ~A" (channel->vct)))
	(if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.1 39)))
	    (snd-display #__line__ ";ptree3 67: ~A" (edit-tree)))
	(revert-sound ind)
	
	(map-chan (lambda (y) 1.0) 0 10)
	(ptree-channel (lambda (y) (* y 0.5)))
	(ptree-channel (lambda (y) (+ y 1.5)))
	(ptree-channel (lambda (y) (* y 2.0)))
	(ptree-channel (lambda (y) (* y 0.1)))
	(if (not (vequal (channel->vct) (make-vct 11 0.4)))
	    (snd-display #__line__ ";ptree4: ~A" (channel->vct)))
	(if (< (max-virtual-ptrees) 4)
	    (if (not (feql (car (edit-tree)) (list 0 2 0 10 1.0 0.0 0.0 0)))
		(snd-display #__line__ ";ptree4: ~A" (edit-tree)))
	    (if (not (feql (car (edit-tree)) (list 0 1 0 10 1.0 0.0 0.0 16)))
		(snd-display #__line__ ";ptree4 (maxed): ~A" (edit-tree))))
	
	(close-sound ind))
      
      (let ((old-pmax (max-virtual-ptrees)))
	
	(set! (max-virtual-ptrees) 10)
	
	(let ((ind (new-sound "test.snd" :size 20)))
	  (vct->channel (make-vct 20 1.0))
	  
	  (env-channel '(0 0 1 1 2 1 3 0))
	  (let ((ramp-to-1 (channel->vct)))
	    (undo)
	    (xramp-channel 0 1 8)
	    (let ((xramp-to-1 (channel->vct)))
	      (undo)
	      (ptree-channel (lambda (y) (* y 2.5)))
	      (let ((pdata (channel->vct)))
		(undo)
		
		;; -------- ramp-ptree-ramp -------- 
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! (make-vct 20 1.0) ramp-to-1)
				pdata)
			       ramp-to-1)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";simple rpr:~%; ~A~%; ~A" rpr nrpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.234)
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply! (make-vct 20 3.0) ramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				ramp-to-1)
			       -1.234)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * rpr:~%; ~A~%; ~A" rpr nrpr))))
		
		
		;; -------- ramp-ptree-xramp -------- 
		
		(set! (edit-position) 1)
		(xramp-channel 0 1 8)
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! (make-vct 20 1.0) xramp-to-1)
				pdata)
			       ramp-to-1)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";simple rpx:~%; ~A~%; ~A" rpr nrpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.234)
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply! (make-vct 20 3.0) xramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				ramp-to-1)
			       -1.234)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * rpx:~%; ~A~%; ~A" rpr nrpr))))
		
		
		;; -------- ramp-ptree-xramp-ramp -------- 
		
		(set! (edit-position) 1)
		(xramp-channel 0 1 8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! 
				 (vct-multiply! (make-vct 20 1.0) ramp-to-1)
				 xramp-to-1)
				pdata)
			       ramp-to-1)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";simple rpxr:~%; ~A~%; ~A" rpr nrpr))))
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.0)
		(let ((rpr (channel->vct)))
		  (let ((nrpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply!
				    (vct-multiply! (make-vct 20 3.0) ramp-to-1)
				    xramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				ramp-to-1)
			       -1.0)))
		    (if (not (vequal rpr nrpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * rpxr:~%; ~A~%; ~A" rpr nrpr))))
		
		
		;; -------- xramp-ptree-ramp -------- 
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(ptree-channel (lambda (y) (* y 2.5)))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! (make-vct 20 1.0) ramp-to-1)
				pdata)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xpr:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(xramp-channel 0 1 8)
		(scale-by -1.234)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply! (make-vct 20 3.0) ramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				xramp-to-1)
			       -1.234)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xpr:~%; ~A~%; ~A" xpr nxpr))))
		
		
		;; -------- xramp-ptree-xramp -------- 
		
		(set! (edit-position) 1)
		(xramp-channel 0 1 8)
		(ptree-channel (lambda (y) (* y 2.5)))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! (make-vct 20 1.0) xramp-to-1)
				pdata)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xpx:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(xramp-channel 0 1 8)
		(scale-by -1.234)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply! (make-vct 20 3.0) xramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				xramp-to-1)
			       -1.234)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xpx:~%; ~A~%; ~A" xpr nxpr))))
		
		
		;; -------- xramp-ptree-xramp-ramp --------
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(xramp-channel 0 1 8)
		(ptree-channel (lambda (y) (* y 2.5)))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply! 
			       (vct-multiply! 
				(vct-multiply! 
				 (vct-multiply! (make-vct 20 1.0) ramp-to-1)
				 xramp-to-1)
				pdata)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xpxr:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(xramp-channel 0 1 8)
		(scale-by -1.234)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-scale!
			       (vct-multiply! 
				(vct-scale! 
				 (vct-multiply! 
				  (vct-scale! 
				   (vct-multiply!
				    (vct-multiply! (make-vct 20 3.0) ramp-to-1)
				    xramp-to-1) 
				   1.25)
				  pdata)
				 -0.8)
				xramp-to-1)
			       -1.234)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xpxr:~%; ~A~%; ~A" xpr nxpr))))
		
		
		;; -------- xramp-ramp-ptree-ramp -------- 
		
		(set! (edit-position) 1)
		(env-channel '(0 0 1 1 2 1 3 0))
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-multiply! 
				(vct-multiply! 
				 (vct-multiply! (make-vct 20 1.0) ramp-to-1)
				 pdata)
				ramp-to-1)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xrpr:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.234)
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-scale!
				(vct-multiply! 
				 (vct-scale! 
				  (vct-multiply! 
				   (vct-scale! 
				    (vct-multiply! (make-vct 20 3.0) ramp-to-1) 
				    1.25)
				   pdata)
				  -0.8)
				 ramp-to-1)
				-1.234)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xrpr:~%; ~A~%; ~A" xpr nxpr))))
		
		;; -------- xramp-ramp-ptree-xramp -------- 
		
		(set! (edit-position) 1)
		(xramp-channel 0 1 8)
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-multiply! 
				(vct-multiply! 
				 (vct-multiply! (make-vct 20 1.0) xramp-to-1)
				 pdata)
				ramp-to-1)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xrpx:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.234)
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-scale!
				(vct-multiply! 
				 (vct-scale! 
				  (vct-multiply! 
				   (vct-scale! 
				    (vct-multiply! (make-vct 20 3.0) xramp-to-1) 
				    1.25)
				   pdata)
				  -0.8)
				 ramp-to-1)
				-1.234)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xrpx:~%; ~A~%; ~A" xpr nxpr))))
		
		
		
		;; -------- xramp-ramp-ptree-xramp-ramp -------- 
		
		(set! (edit-position) 1)
		(xramp-channel 0 1 8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(ptree-channel (lambda (y) (* y 2.5)))
		(env-channel '(0 0 1 1 2 1 3 0))
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-multiply! 
				(vct-multiply! 
				 (vct-multiply! (vct-multiply! (make-vct 20 1.0) xramp-to-1) ramp-to-1)
				 pdata)
				ramp-to-1)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";simple xrpxr:~%; ~A~%; ~A" xpr nxpr))))
		
		(set! (edit-position) 1)
		(scale-by 3.0)
		(xramp-channel 0 1 8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by 1.25)
		(ptree-channel (lambda (y) (* y 2.5)))
		(scale-by -0.8)
		(env-channel '(0 0 1 1 2 1 3 0))
		(scale-by -1.234)
		(xramp-channel 0 1 8)
		(let ((xpr (channel->vct)))
		  (let ((nxpr (vct-multiply!
			       (vct-scale!
				(vct-multiply! 
				 (vct-scale! 
				  (vct-multiply! 
				   (vct-scale! 
				    (vct-multiply! (vct-multiply! (make-vct 20 3.0) xramp-to-1) ramp-to-1)
				    1.25)
				   pdata)
				  -0.8)
				 ramp-to-1)
				-1.234)
			       xramp-to-1)))
		    (if (not (vequal xpr nxpr))
			(snd-display #__line__ ";3.0 1.25 -0.8 -1.234 * xrpxr:~%; ~A~%; ~A" xpr nxpr))))
		
		(close-sound ind)))))
	(set! (max-virtual-ptrees) old-pmax))
      
      (let ((data (make-vct 101 1.0))
	    (rto1-data (make-vct 101))
	    (xto1-data (make-vct 101))
	    (cos-data (make-vct 101))
	    (ind (new-sound "test.snd")))
	;; test-ops.scm for 7 and 8 cases (40 min per branch)
	
	(define (set-to-1) (map-chan (lambda (y) 1.0) 0 100))
	(define (cset-to-1 dat) (do ((i 0 (+ 1 i))) ((= i 101)) (vct-set! dat i 1.0)))
	(define (ramp-to-1) (ramp-channel 0.0 1.0))
	(define (cramp-to-1 dat) (vct-multiply! dat rto1-data))
	(define (scale-by-half) (scale-channel 0.5))
	(define (cscale-by-half dat) (vct-scale! dat 0.5000))
	(define (scale-by-two) (scale-channel 2.0 30 40))
	(define (cscale-by-two dat) (do ((i 30 (+ 1 i))) ((= i 70)) (vct-set! dat i (* (vct-ref dat i) 2.0))))
	(define (xramp-to-1) (xramp-channel 0.0 1.0 32.0))
	(define (cxramp-to-1 dat) (vct-multiply! dat xto1-data))
	(define (scale-mid) (scale-channel 0.125 30 30))
	(define (cscale-mid dat) (do ((i 30 (+ 1 i))) ((= i 60)) (vct-set! dat i (* (vct-ref dat i) 0.125))))
	(define (on-air) (scale-channel 0.0 10 30))
	(define (con-air dat) (do ((i 10 (+ 1 i))) ((= i 40)) (vct-set! dat i 0.0)))
	(define (ptree) (ptree-channel (lambda (y) (* y 0.75)) 20 20))
	(define (cptree dat) (do ((i 20 (+ 1 i))) ((= i 40)) (vct-set! dat i (* (vct-ref dat i) .75))))
	(define (ptreec) (cosine-channel-via-ptree))
	(define (cptreec dat) (vct-multiply! dat cos-data))
	(define (xen) (ptree-channel (lambda (y) (* y 0.25)) 0 (frames) ind 0))
	(define (cxen dat) (vct-scale! dat 0.25))
	(define (rev-channel->vct)
	  (let* ((l (vct-length data))
		 (r (make-sampler (- l 1) ind 0 -1))
		 (d (make-vct l)))
	    (do ((i (- l 1) (- i 1)))
		((< i 0))
	      (vct-set! d i (r)))
	    d))
	(define (ptreec1)
	  (ptree-channel (lambda (y data forward)
			   (* y (vct-ref data 0)))
			 10 50 ind 0 #f #f
			 (lambda (pos dur)
			   (vct 0.625))))
	(define (cptreec1 dat) (do ((i 10 (+ 1 i))) ((= i 60)) (vct-set! dat i (* (vct-ref dat i) 0.625))))
	
	(let ((xe (make-env '(0 0 1 1) :length 101 :base 32.0)))
	  (do ((i 0 (+ 1 i))
	       (incr (/ pi 101.0))
	       (ang (* -0.5 pi)))
	      ((= i 101))
	    (vct-set! rto1-data i (* i .01))
	    (vct-set! xto1-data i (env xe))
	    (vct-set! cos-data i (cos ang))
	    (set! ang (+ ang incr))))
	
	(set! (squelch-update ind) #t)
	
	;; 0 case
	(set-to-1)
	(if (not (vvequal data (channel->vct)))
	    (snd-display #__line__ ";0 case! ~A" (channel->vct)))
	(if (not (vvequal data (rev-channel->vct)))
	    (snd-display #__line__ ";0 case rev! ~A" (rev-channel->vct)))
	
	;; 1 case
	(for-each
	 (lambda (func check)
	   (revert-sound)
	   (set-to-1)
	   (cset-to-1 data)
	   (func)
	   (check data)
	   (if (not (vvequal data (channel->vct)))
	       (snd-display #__line__ ";1 case: ~A ~A" (procedure-name func) (channel->vct)))
	   (if (not (vvequal data (rev-channel->vct)))
	       (snd-display #__line__ ";1 rev case: ~A ~A" (procedure-name func) (rev-channel->vct))))
	 (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	 (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen))
	
	;; 2 case
	(for-each
	 (lambda (func check)
	   (for-each
	    (lambda (func1 check1)
	      (revert-sound)
	      (set-to-1)
	      (cset-to-1 data)
	      (func)
	      (check data)
	      (func1)
	      (check1 data)
	      (if (not (vvequal data (channel->vct)))
		  (snd-display #__line__ ";2 case: ~A(~A): ~A" (procedure-name func1) (procedure-name func) (channel->vct)))
	      (if (not (vvequal data (rev-channel->vct)))
		  (snd-display #__line__ ";2 rev case: ~A(~A): ~A" (procedure-name func1) (procedure-name func) (rev-channel->vct))))
	    (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	    (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
	 (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	 (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen))
	
	(set! (print-length) 200)
	
	;; 3 case
	(for-each
	 (lambda (func check)
	   (for-each
	    (lambda (func1 check1)
	      (for-each
	       (lambda (func2 check2)
		 (revert-sound)
		 (set-to-1)
		 (cset-to-1 data)
		 (func)
		 (check data)
		 (func1)
		 (check1 data)
		 (func2)
		 (check2 data)
		 (if (not (vvequal data (channel->vct)))
		     (snd-display #__line__ ";3 case: ~A(~A(~A)): off by ~A~%; calc: ~A~%; chan: ~A" 
				  (procedure-name func2) (procedure-name func1) (procedure-name func) 
				  (vmaxdiff data (channel->vct)) data (channel->vct)))
		 (if (not (vvequal data (rev-channel->vct)))
		     (snd-display #__line__ ";3 rev case: ~A(~A(~A)) off by ~A:~%; calc: ~A~%; chan: ~A" 
				  (procedure-name func2) (procedure-name func1) (procedure-name func) 
				  (vmaxdiff data (rev-channel->vct)) data (rev-channel->vct))))
	       (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	       (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
	    (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	    (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
	 (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	 (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen))
	
	(if all-args
	    (begin
	      ;; 4 case
	      (for-each
	       (lambda (func check)
		 (for-each
		  (lambda (func1 check1)
		    (for-each
		     (lambda (func2 check2)
		       (for-each
			(lambda (func3 check3)
			  (revert-sound)
			  (set-to-1)
			  (cset-to-1 data)
			  (func)
			  (check data)
			  (func1)
			  (check1 data)
			  (func2)
			  (check2 data)
			  (func3)
			  (check3 data)
			  (if (not (vvequal data (channel->vct)))
			      (snd-display #__line__ ";4 case: ~A(~A(~A(~A))): ~A" 
					   (procedure-name func3) (procedure-name func2) (procedure-name func1) (procedure-name func) 
					   (channel->vct)))
			  (if (not (vvequal data (rev-channel->vct)))
			      (snd-display #__line__ ";4 rev case: ~A(~A(~A(~A))): ~A" 
					   (procedure-name func3) (procedure-name func2) (procedure-name func1) (procedure-name func) 
					   (rev-channel->vct))))
			(list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			(list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
		     (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
		     (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
		  (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
		  (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
	       (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
	       (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen))
	      
	      ;; 5 case
	      (for-each
	       (lambda (func check)
		 (for-each
		  (lambda (func1 check1)
		    (for-each
		     (lambda (func2 check2)
		       (for-each
			(lambda (func3 check3)
			  (for-each
			   (lambda (func4 check4)
			     (revert-sound)
			     (set-to-1)
			     (cset-to-1 data)
			     (func)
			     (check data)
			     (func1)
			     (check1 data)
			     (func2)
			     (check2 data)
			     (func3)
			     (check3 data)
			     (func4)
			     (check4 data)
			     (if (not (vvequal data (channel->vct)))
				 (snd-display #__line__ ";5 case: ~A(~A(~A(~A(~A)))): ~A" 
					      (procedure-name func4) (procedure-name func3) (procedure-name func2) 
					      (procedure-name func1) (procedure-name func) 
					      (channel->vct))))
			   (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			   (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
			(list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			(list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
		     (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
		     (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
		  (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1)
		  (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1)))
	       (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1)
	       (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1))
	      
	      ;; 6 case
	      (for-each
	       (lambda (func check)
		 (for-each
		  (lambda (func1 check1)
		    (for-each
		     (lambda (func2 check2)
		       (for-each
			(lambda (func3 check3)
			  (for-each
			   (lambda (func4 check4)
			     (for-each
			      (lambda (func5 check5)
				(revert-sound)
				(set-to-1)
				(cset-to-1 data)
				(func)
				(check data)
				(func1)
				(check1 data)
				(func2)
				(check2 data)
				(func3)
				(check3 data)
				(func4)
				(check4 data)
				(func5)
				(check5 data)
				(if (not (vvequal data (channel->vct)))
				    (snd-display #__line__ ";6 case: ~A(~A(~A(~A(~A(~A))))): ~A" 
						 (procedure-name func5) (procedure-name func4) (procedure-name func3) 
						 (procedure-name func2) (procedure-name func1) (procedure-name func) 
						 (channel->vct))))
			      (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			      (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
			   (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			   (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
			(list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1 xen)
			(list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1 cxen)))
		     (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air ptree ptreec ptreec1)
		     (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air cptree cptreec cptreec1)))
		  (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air)
		  (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air)))
	       (list scale-by-two ramp-to-1 xramp-to-1 scale-by-half scale-mid on-air)
	       (list cscale-by-two cramp-to-1 cxramp-to-1 cscale-by-half cscale-mid con-air))
	      ))
	(close-sound ind))
      
      (set! (optimization) old-opt-val)
      
      (let ((ind (open-sound "oboe.snd")))
	(if (not (= (redo 1 ind 0) 0)) (snd-display #__line__ ";open redo with no ops: ~A" (redo)))
	(if (not (= (undo 1 ind 0) 0)) (snd-display #__line__ ";open undo with no ops: ~A" (undo)))
	(set! (cursor) 1000)
	(delete-sample 321)
	(if (not (= (cursor) 999)) (snd-display #__line__ ";delete-sample before cursor: ~A" (cursor)))
	(if (not (= (cursor ind 0 0) 1000)) (snd-display #__line__ ";delete-sample before cursor (0): ~A" (cursor ind 0 0)))
	(undo)
	(if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-sample after cursor undo: ~A" (cursor)))
	(undo -1)
	(if (not (= (cursor) 999)) (snd-display #__line__ ";delete-sample before cursor redo: ~A" (cursor)))
	(redo -1)
	(delete-sample 1321)
	(if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-sample after cursor: ~A" (cursor)))
	(undo)
	(delete-samples 0 100)
	(if (not (= (cursor) 900)) (snd-display #__line__ ";delete-samples before cursor: ~A" (cursor)))
	(undo)
	(delete-samples 1100 100)
	(if (not (= (cursor) 1000)) (snd-display #__line__ ";delete-samples after cursor: ~A" (cursor)))
	(undo)
	(insert-samples 100 100 (make-vct 100))
	(if (not (= (cursor) 1100)) (snd-display #__line__ ";insert-samples before cursor: ~A" (cursor)))
	(undo)
	(insert-samples 1100 100 (make-vct 100))
	(if (not (= (cursor) 1000)) (snd-display #__line__ ";insert-samples after cursor: ~A" (cursor)))
	(undo)
	(set! (samples 0 100) (make-vct 100))
	(if (not (= (cursor) 1000)) (snd-display #__line__ ";set-samples cursor: ~A" (cursor)))
	(set! (show-axes ind 0) show-x-axis-unlabelled)
	(update-time-graph)
	(set! (show-axes ind 0) show-all-axes-unlabelled)
	(update-time-graph)
	(close-sound ind))
      
      (let ((ind (new-sound "test.snd" :size 100)))
	(vct->channel (make-vct 3 1.0) 10 8)
	(if (fneq (maxamp ind 0) 1.0)
	    (snd-display #__line__ ";vct->channel size mismatch maxamp: ~A" (maxamp ind 0)))
	(if (not (vequal (channel->vct 0 20 ind 0)
			 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";vct->channel size mismatch: ~A" (channel->vct 0 20 ind 0)))
	(revert-sound ind)
	(set! (samples 10 5) (make-vct 3 1.0))
	(if (fneq (maxamp ind 0) 1.0)
	    (snd-display #__line__ ";set samples size mismatch maxamp: ~A" (maxamp ind 0)))
	(if (not (vequal (channel->vct 0 20 ind 0)
			 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";set samples size mismatch: ~A" (channel->vct 0 20 ind 0)))
	(revert-sound ind)
	(insert-samples 10 8 (make-vct 3 1.0) ind 0)
	(if (fneq (maxamp ind 0) 1.0)
	    (snd-display #__line__ ";insert samples size mismatch maxamp: ~A" (maxamp ind 0)))
	(if (not (vequal (channel->vct 0 20 ind 0)
			 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0)))
	    (snd-display #__line__ ";insert samples size mismatch: ~A" (channel->vct 0 20 ind 0)))
	(close-sound ind))
      
      (let* ((index (open-sound "oboe.snd"))
	     (bnds (x-bounds index))
	     (xp (x-position-slider))
	     (yp (y-position-slider))
	     (xz (x-zoom-slider))
	     (yz (y-zoom-slider)))
	(if (not (string=? (snd-completion " open-so") " open-sound"))
	    (snd-display #__line__ ";completion: ~A" (snd-completion " open-so")))
					;	(if (not (string=? (snd-completion " open-sound") " open-sound"))
					;	    (snd-display #__line__ ";completion: ~A" (snd-completion " open-so")))
	(if (not (string=? (snd-completion " zoom-focus-r") " zoom-focus-right"))
	    (snd-display #__line__ ";completion: ~A" (snd-completion " zoom-focus-r")))
	(play "oboe.snd" :wait #t)
	(play "oboe.snd" :start 12000 :wait #t)
	(play "oboe.snd" :start 12000 :end 15000 :wait #t)
	(play :edit-position (- (edit-position) 1) :wait #t)
	(let ((old-speed (speed-control index))
	      (old-style (speed-control-style))
	      (old-open (show-controls index)))
	  (set! (show-controls index) #t)
	  (set! (speed-control index) -2.0)
	  (play index :start 12345 :wait #t)
	  (set! (speed-control-style) speed-control-as-semitone)
	  (set! (speed-control index) 0.5)
	  (set! (speed-control-style) speed-control-as-ratio)
	  (set! (speed-control index) 0.25)
	  (set! (speed-control index) old-speed)
	  (set! (speed-control-style) old-style)
	  (set! (show-controls index) old-open))
	(bomb index #t)
	(let ((k (disk-kspace "oboe.snd")))
	  (if (or (not (number? k))
		  (<= k 0))
	      (snd-display #__line__ ";disk-kspace = ~A" (disk-kspace "oboe.snd")))
	  (set! k (disk-kspace "/baddy/hiho"))
	  (if (not (= k -1))
	      (snd-display #__line__ ";disk-kspace of bogus file = ~A" (disk-kspace "/baddy/hiho"))))
	(if (not (= (transform-frames) 0)) (snd-display #__line__ ";transform-frames ~A?" (transform-frames)))
	(set! (transform-size) 512)
	
	(set! (transform-graph?) #t)
	(let ((pk (fft-peak index 0 1.0)))
	  (if (not pk) (snd-display #__line__ ";fft-peak? ")))
	(set! (time-graph?) #t)
	
	(catch #t
	       (lambda ()
		 (if (not (string=? (x-axis-label) "time")) (snd-display #__line__ ";def time x-axis-label: ~A" (x-axis-label)))
		 (set! (x-axis-label index 0 time-graph) "no time")
		 (if (not (string=? (x-axis-label) "no time")) (snd-display #__line__ ";time x-axis-label: ~A" (x-axis-label index 0 time-graph)))
		 
		 (update-transform-graph)
		 (if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) (snd-display #__line__ ";get fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		 (set! (x-axis-label index 0 transform-graph) "hiho")
		 (update-transform-graph)
		 (if (not (string=? (x-axis-label index 0 transform-graph) "hiho")) (snd-display #__line__ ";set set fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		 (set! (x-axis-label index 0 transform-graph) "frequency") ; for later test
		 
		 (graph '(0 0 1 1 2 0) "lisp")
		 (update-lisp-graph)
		 (if (not (string=? (x-axis-label index 0 lisp-graph) "lisp")) (snd-display #__line__ ";def lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
		 (set! (x-axis-label index 0 lisp-graph) "no lisp")
		 (if (not (string=? (x-axis-label index 0 lisp-graph) "no lisp")) (snd-display #__line__ ";lisp x-axis-label: ~A" (x-axis-label index 0 lisp-graph)))
		 
		 (set! (y-axis-label index 0 time-graph) "no amp")
		 (if (not (string=? (y-axis-label) "no amp")) (snd-display #__line__ ";time y-axis-label: ~A" (y-axis-label index 0 time-graph)))
		 (set! (y-axis-label index 0 lisp-graph) "no lamp")
		 (if (not (string=? (y-axis-label index 0 lisp-graph) "no lamp")) (snd-display #__line__ ";lisp y-axis-label: ~A" (y-axis-label index 0 lisp-graph)))
		 (set! (y-axis-label) #f)
		 (set! (y-axis-label index 0) "no amp")
		 (if (not (string=? (y-axis-label) "no amp")) (snd-display #__line__ ";time y-axis-label (time): ~A" (y-axis-label index 0 time-graph)))
		 (set! (y-axis-label index) #f))
	       (lambda args (snd-display #__line__ ";axis label error: ~A" args)))
	
	(graph-data (make-vct 4))
	(update-lisp-graph)
	(graph (vct 0 0 1 1 2 0))
	(do ((i 0 (+ 1 i))) 
	    ((= i 32)) 
	  (graph (vct 0 1 2)) 
	  (graph (list (vct 0 1 2) (vct 3 2 1) (vct 1 2 3)))
	  (graph (list (vct 0 1 2) (vct 3 2 1))))
	(set! (x-bounds) (list 0.0 0.01))
	(let ((data (make-graph-data)))
	  (if (vct? data)
	      (let ((mid (round (* .5 (vct-length data)))))
		(if (not (= (vct-length data) (+ 1 (- (right-sample) (left-sample)))))
		    (snd-display #__line__ ";make-graph-data bounds: ~A ~A -> ~A" (left-sample) (right-sample) (vct-length data)))
		(if (fneq (vct-ref data mid)
			  (sample (+ (left-sample) mid)))
		    (snd-display #__line__ ";make-graph-data[~D]: ~A ~A" mid (vct-ref data mid) (sample (+ (left-sample) mid)))))))
	(let ((data (make-graph-data index 0 0 100 199)))
	  (if (vct? data)
	      (begin
		(if (not (= (vct-length data) 100))
		    (snd-display #__line__ ";make-graph-data 100:199: ~A" (vct-length data)))
		(if (fneq (vct-ref data 50) (sample 50))
		    (snd-display #__line__ ";make-graph-data 50: ~A ~A" (vct-ref data 50) (sample 50))))))
	(set! (x-bounds) (list 0.0 0.1))
	(update-transform-graph)
	(catch 'no-such-axis
	       (lambda ()
		 (if (not (string=? (x-axis-label index 0 transform-graph) "frequency")) 
		     (snd-display #__line__ ";def fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		 (set! (x-axis-label index 0 transform-graph) "fourier")
		 (if (not (string=? (x-axis-label index 0 transform-graph) "fourier")) 
		     (snd-display #__line__ ";fft x-axis-label: ~A" (x-axis-label index 0 transform-graph)))
		 (set! (x-axis-label) "hiho")
		 
		 (set! (y-axis-label index 0 transform-graph) "spectra")
		 (let ((val (y-axis-label index 0 transform-graph)))
		   (if (or (not (string? val))
			   (not (string=? val "spectra")))
		       (snd-display #__line__ ";fft y-axis-label: ~A" val)))
		 (set! (y-axis-label) "hiho"))
	       (lambda args (snd-display #__line__ ";transform axis not displayed?")))
	
	(if (and (number? (transform-frames))
		 (= (transform-frames) 0))
	    (snd-display #__line__ ";transform-graph? transform-frames ~A?" (transform-frames)))
	(update-transform-graph)
	(let ((tag (catch #t (lambda () (peaks "/baddy/hiho")) (lambda args (car args)))))
	  (if (not (eq? tag 'cant-open-file)) (snd-display #__line__ ";peaks bad file: ~A" tag)))
	(peaks "tmp.peaks")
	(if (defined? 'read-line)
	    (let ((p (open-input-file "tmp.peaks")))
	      (if (not p)
		  (snd-display #__line__ ";peaks->tmp.peaks failed?")
		  (let ((line (read-line p)))
		    (if (or (not (string? line))
			    (not (string=? "Snd: fft peaks" (substring line 0 14))))
			(snd-display #__line__ ";peaks 1: ~A?" line))
		    (set! line (read-line p))
		    (set! line (read-line p))
		    (if (or (not (string? line))
			    (and (not (string=? "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2" line))
				 (not (string=? (string-append "oboe.snd, fft 512 points beginning at sample 0 (0.000 secs), Blackman2" (string #\newline)) line))))
			(snd-display #__line__ ";peaks 2: ~A?" line))
		    (set! line (read-line p))
		    (set! line (read-line p))
		    (close-input-port p)))))
	(delete-file "tmp.peaks")
	(peaks)
	(if (and (provided? 'xm) 
		 (or (not (list-ref (dialog-widgets) 20))
		     (not (XtIsManaged (list-ref (dialog-widgets) 20)))))
	    (snd-display #__line__ ";peaks but no help?"))
	(dismiss-all-dialogs)
	(let* ((num-transforms 6)
	       (num-transform-graph-types 3))
	  (set! (transform-graph? index 0) #t)
	  (set! (transform-size index 0) 64)
	  (do ((i 0 (+ 1 i)))
	      ((= i num-transforms))
	    (set! (transform-type) (integer->transform i))
	    (if (not (transform? (integer->transform i))) (snd-display #__line__ ";transform? ~A?" i))
	    (do ((j 0 (+ 1 j)))
		((= j num-transform-graph-types))
	      (set! (transform-graph-type index 0) j)
	      (update-transform-graph index 0))))
	(set! (transform-type) fourier-transform)
	(if (not (transform? (transform-type))) (snd-display #__line__ ";transform? ~A ~A?" (transform-type) fourier-transform))
	(if (not (transform? autocorrelation)) (snd-display #__line__ ";transform? autocorrelation"))
	
	(if (read-only index) (snd-display #__line__ ";read-only open-sound: ~A?" (read-only index)))
	(set! (read-only index) #t)
	(if (not (read-only index)) (snd-display #__line__ ";set-read-only: ~A?" (read-only index)))
	(bind-key #\a 0 (lambda () (set! a-ctr 3)))
	(key (char->integer #\a) 0) 
	(if (not (= a-ctr 3)) (snd-display #__line__ ";bind-key: ~A?" a-ctr))
	(let ((str (with-output-to-string (lambda () (display (procedure-source (key-binding (char->integer #\a) 0)))))))
	  (if (not (string=? str "(lambda () (set! a-ctr 3))"))
	      (snd-display #__line__ ";key-binding: ~A?" str)))
	(unbind-key (char->integer #\a) 0)
	(set! a-ctr 0)
	(key (char->integer #\a) 0) 
	(do ((i 0 (+ 1 i)))
	    ((= i 5))
	  (let ((psf (eps-file)))
	    (if (and psf (string? psf))
		(begin
		  (if (file-exists? psf) (delete-file psf))
		  (set! (graph-style) i)
		  (graph->ps)
		  (if (not (file-exists? psf)) 
		      (snd-display #__line__ ";graph->ps: ~A?" psf)
		      (delete-file psf))))))
	(let ((err (catch 'cannot-print 
			  (lambda () 
			    (graph->ps "/bad/bad.eps"))
			  (lambda args 12345))))
	  (if (not (= err 12345)) (snd-display #__line__ ";graph->ps err: ~A?" err)))
	(let ((n2 (or (open-sound "2.snd") (open-sound "4.aiff"))))
	  (set! (transform-graph? n2) #t)
	  (set! (channel-style n2) channels-superimposed)
	  (if (not (= (channel-style n2) channels-superimposed)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-superimposed (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-combined)
	  (if (not (= (channel-style n2) channels-combined)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-combined (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (set! (channel-style n2) channels-separate)
	  (if (not (= (channel-style n2) channels-separate)) (snd-display #__line__ ";channel-style->~D: ~A?" channels-separate (channel-style n2)))
	  (graph->ps "aaa.eps")
	  (close-sound n2))
	(if (= (channels index) 1)
	    (begin
	      (set! (channel-style index) channels-superimposed)
	      (if (not (= (channel-style index) channels-separate)) (snd-display #__line__ ";channel-style[0]->~D: ~A?" channels-separate (channel-style index)))))
	(set! (sync index) 32)
	(if (not (= (sync index) 32)) (snd-display #__line__ ";sync->32: ~A?" (sync index)))
	(if (not (>= (sync-max) 32)) (snd-display #__line__ ";sync-max 32: ~A" (sync-max)))
	(set! (sync index) 0)
	(set! (channel-sync index 0) 12)
	(if (not (= (channel-sync index 0) 12)) (snd-display #__line__ ";sync-chn->12: ~A?" (channel-sync index 0)))
	(set! (channel-sync index 0) 0)
	(if (not (= a-ctr 0)) (snd-display #__line__ ";unbind-key: ~A?" a-ctr))
	(if (fneq xp 0.0) (snd-display #__line__ ";x-position-slider: ~A?" xp))
	(if (fneq yp 0.0) (snd-display #__line__ ";y-position-slider: ~A?" yp))
	(if (and (fneq xz 0.04338) (fneq xz 1.0)) (snd-display #__line__ ";x-zoom-slider: ~A?" xz))
	(if (fneq yz 1.0) (snd-display #__line__ ";y-zoom-slider: ~A?" yz))
	(if (and (or (fneq (car bnds) 0.0) (fneq (cadr bnds) 0.1)) 
		 (or (fneq (car bnds) 0.0) (fneq (cadr bnds) 2.305))) ; open-hook from ~/.snd*
	    (snd-display #__line__ ";x-bounds: ~A?" bnds))
	(if (not (equal? (find-sound "oboe.snd") index)) (snd-display #__line__ ";oboe: index ~D /= ~D?" (find-sound "oboe.snd") index))
	(if (not (sound? index)) (snd-display #__line__ ";oboe: ~D not ok?" index))
	(if (not (= (chans index) 1)) (snd-display #__line__ ";oboe: chans ~D?" (chans index)))
	(if (not (= (channels index) 1)) (snd-display #__line__ ";oboe: channels ~D?" (channels index)))
	(if (not (= (frames index) 50828)) (snd-display #__line__ ";oboe: frames ~D?" (frames index)))
	(if (not (= (srate index) 22050)) (snd-display #__line__ ";oboe: srate ~D?" (srate index)))
	(if (not (= (data-location index) 28)) (snd-display #__line__ ";oboe: location ~D?" (data-location index)))
	(if (not (= (data-size index) (* 50828 2))) (snd-display #__line__ ";oboe: size ~D?" (data-size index)))
	(if (not (= (data-format index) mus-bshort)) (snd-display #__line__ ";oboe: format ~A?" (data-format index)))
	(if (fneq (maxamp index) .14724) (snd-display #__line__ ";oboe: maxamp ~F?" (maxamp index)))
	(if (not (= (maxamp-position index) 24971)) (snd-display #__line__ ";oboe: maxamp-position ~A?" (maxamp-position index)))
	(if (comment index) (snd-display #__line__ ";oboe: comment ~A?" (comment index)))
	(if (not (= (string-length "asdf") 4)) (snd-display #__line__ ";string-length: ~A?" (string-length "asdf")))
	(if (not (string=? (short-file-name index) "oboe.snd")) (snd-display #__line__ ";oboe short name: ~S?" (short-file-name index)))
	(let ((matches (count-matches (lambda (a) (> a .125)))))
	  (if (not (= matches 1313)) (snd-display #__line__ ";count-matches: ~A?" matches)))
	(let ((matches (count-matches (lambda (y) (let ((a (list .1 .2))) (> y (car a))))))) ; force xen not ptree
	  (if (not (= matches 2851)) (snd-display #__line__ ";unopt count-matches: ~A?" matches)))
	(let ((spot (find-channel (lambda (a) (> a .13)))))
	  (if (or (null? spot) (not (= (cadr spot) 8862))) (snd-display #__line__ ";find: ~A?" spot)))
	(set! (right-sample) 3000) 
	(let ((samp (right-sample)))
	  (if (> (abs (- samp 3000)) 1) (snd-display #__line__ ";right-sample: ~A?" samp)))
	(set! (left-sample) 1000) 
	(let ((samp (left-sample)))
	  (if (> (abs (- samp 1000)) 1) (snd-display #__line__ ";left-sample: ~A?" samp)))
	(let ((eds (edits)))
	  (if (or (not (= (car eds) 0)) (not (= (cadr eds) 0)))
	      (snd-display #__line__ ";edits: ~A?" eds))
	  (if (not (= (edit-position) (car eds)))
	      (snd-display #__line__ ";edit-position: ~A ~A?" (edit-position) eds)))
	(play index :channel 0 :wait #t)
	
	(bomb index #f)
	(if (not (selection-creates-region)) (set! (selection-creates-region) #t))
	(select-all index 0) 
	(let ((r0 (car (regions)))
	      (sel (selection)))
	  (if (not (selection?)) (snd-display #__line__ ";selection?"))
	  (if (not (selection? sel)) (snd-display #__line__ ";selection? sel"))
	  (if (not (region? r0)) (snd-display #__line__ ";region?"))
	  (if (not (= (selection-chans) 1)) (snd-display #__line__ ";selection-chans(1): ~A" (selection-chans)))
	  (if (not (= (channels sel) 1)) (snd-display #__line__ ";generic selection-chans(1): ~A" (channels sel)))
	  (if (not (= (selection-srate) (srate index))) (snd-display #__line__ ";selection-srate: ~A ~A" (selection-srate) (srate index)))
	  (if (not (= (srate sel) (srate index))) (snd-display #__line__ ";generic selection-srate: ~A ~A" (srate sel) (srate index)))
	  (if (fneq (region-maxamp r0) (maxamp index)) (snd-display #__line__ ";region-maxamp (1): ~A?" (region-maxamp r0)))
	  (if (not (= (region-maxamp-position r0) (maxamp-position index)))
	      (snd-display #__line__ ";region-maxamp-position (1): ~A ~A?" (region-maxamp-position r0) (maxamp-position index)))
	  (if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display #__line__ ";selection-maxamp (1): ~A?" (selection-maxamp index 0)))
	  (if (fneq (maxamp sel index 0) (maxamp index)) (snd-display #__line__ ";generic selection-maxamp (1): ~A?" (maxamp sel index 0)))
	  (if (not (= (selection-maxamp-position index 0) (maxamp-position index)))
	      (snd-display #__line__ ";selection-maxamp-position (1): ~A ~A?" (selection-maxamp-position index 0) (maxamp-position index)))
	  (save-region r0 "temp.dat")
	  (if (file-exists? "temp.dat")
	      (delete-file "temp.dat")
	      (snd-display #__line__ ";save-region file disappeared?"))
	  (play r0 :wait #t) ;needs to be #t here or it never gets run
	  (if (not (= (length (regions)) 1)) (snd-display #__line__ ";regions: ~A?" (regions)))
	  (if (not (selection-member? index)) (snd-display #__line__ ";selection-member?: ~A" (selection-member? index)))
	  (if (not (= (region-srate r0) 22050)) (snd-display #__line__ ";region-srate: ~A?" (region-srate r0)))
	  (if (not (= (region-chans r0) 1)) (snd-display #__line__ ";region-chans: ~A?" (region-chans r0)))
	  (if (not (equal? (region-home r0) (list "oboe.snd" 0 50827))) (snd-display #__line__ ";region-home: ~A" (region-home r0)))
	  (if (not (= (region-frames r0) 50828)) (snd-display #__line__ ";region-frames: ~A?" (region-frames r0)))
	  (if (not (= (selection-frames) 50828)) (snd-display #__line__ ";selection-frames: ~A?" (selection-frames 0)))
	  (if (not (= (frames sel) 50828)) (snd-display #__line__ ";generic selection-frames: ~A?" (frames sel)))
	  (if (not (= (length sel) 50828)) (snd-display #__line__ ";generic length selection-frames: ~A?" (length sel)))
	  (if (not (= (selection-position) 0)) (snd-display #__line__ ";selection-position: ~A?" (selection-position)))
	  (if (not (= (region-position r0 0) 0)) (snd-display #__line__ ";region-position: ~A?" (region-position r0 0)))
	  (if (fneq (region-maxamp r0) (maxamp index)) (snd-display #__line__ ";region-maxamp: ~A?" (region-maxamp r0)))
	  (if (fneq (selection-maxamp index 0) (maxamp index)) (snd-display #__line__ ";selection-maxamp: ~A?" (selection-maxamp index 0)))
	  (let ((samps1 (channel->vct 0 50827 index 0))
		(samps2 (region->vct r0 0 50828 0))
		(vr (make-sampler 0 index 0 1)))
	    (if (not (sampler? vr)) (snd-display #__line__ ";~A not sampler?" vr))
	    (if (not (= (sampler-position vr) 0)) (snd-display #__line__ ";initial sampler-position: ~A" (sampler-position vr)))
	    (if (not (equal? (sampler-home vr) (list index 0))) 
		(snd-display #__line__ ";sampler-home: ~A ~A?" (sampler-home vr) (list index 0)))
	    (if (sampler-at-end? vr) (snd-display #__line__ ";~A init at end?" vr))
	    (let ((err (catch #t
			      (lambda ()
				(region->vct r0 -1 1233))
			      (lambda args (car args)))))
	      (if (not (eq? err 'no-such-sample)) (snd-display #__line__ ";region->vct -1: ~A" err)))
	    (let ((err (catch #t
			      (lambda ()
				(region->vct r0 12345678 1))
			      (lambda args (car args)))))
	      ;; should this return 'no-such-sample?
	      (if err (snd-display #__line__ ";region->vct 12345678: ~A" err)))
	    (let ((reader-string (format #f "~A" vr)))
	      (if (not (string=? reader-string "#<sampler: oboe.snd[0: 0] from 0, at 0, forward>"))
		  (snd-display #__line__ ";sampler actually got: [~S]" reader-string)))
	    (let ((evr vr))
	      (if (not (equal? evr vr)) (snd-display #__line__ ";sampler equal? ~A ~A" vr evr)))
	    (catch 'break
		   (lambda ()
		     (do ((i 0 (+ 1 i)))
			 ((= i 50827))
		       (if (not (= (if (odd? i) (next-sample vr) (read-sample vr)) (vct-ref samps1 i) (vct-ref samps2 i)))
			   (begin
			     (snd-display #__line__ ";readers disagree at ~D" i)
			     (throw 'break)))))
		   (lambda args (car args)))
	    (free-sampler vr)))
	(let ((var (catch #t (lambda () (make-sampler 0 index -1)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display #__line__ ";make-sampler bad chan (-1): ~A" var)))
	(let ((var (catch #t (lambda () (make-sampler 0 index 1)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display #__line__ ";make-sampler bad chan (1): ~A, ~A" var index)))
	(let ((fd (make-sampler 0)))
	  (if (mix-sampler? fd) (snd-display #__line__ ";sampler: mix ~A" fd))
	  (if (region-sampler? fd) (snd-display #__line__ ";sampler: region ~A" fd))
	  (if (not (sampler? fd)) (snd-display #__line__ ";sampler: normal ~A" fd))
	  (if (not (= (sampler-position fd) 0)) (snd-display #__line__ ";sampler: position: ~A" fd))
	  (free-sampler fd)
	  (let ((str (format #f "~A" fd)))
	    (if (not (string=? (my-substring str (- (string-length str) 16)) "at eof or freed>"))
		(snd-display #__line__ ";freed sampler: ~A [~A]?" str (my-substring str (- (string-length str) 16))))))
	(let* ((reg (car (regions)))
	       (chns (region-chans reg))
	       (var (catch #t (lambda () (make-region-sampler reg 0 (+ chns 1))) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display #__line__ ";make-region-sampler bad chan (2): ~A ~A" var (regions)))
	  (let ((tag (catch #t (lambda () (make-region-sampler reg 0 0 -2)) (lambda args args))))
	    (if (not (eq? (car tag) 'no-such-direction))
		(snd-display #__line__ ";make-region-sampler bad dir (-2): ~A" tag))))
	
	(revert-sound index)
	(insert-sample 100 .5 index) 
	(let ((var (catch #t (lambda () (insert-sound "oboe.snd" 0 1)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-channel))
	      (snd-display #__line__ ";insert-sound bad chan (1): ~A" var)))
	(let ((var (catch #t (lambda () (insert-sample -12 1.0)) (lambda args args))))
	  (if (not (eq? (car var) 'no-such-sample))
	      (snd-display #__line__ ";insert-sample bad pos: ~A" var)))
	(set! (show-axes index 0) show-no-axes)
	(update-transform-graph index) 
	(update-time-graph index) 
	(if (or (fneq (sample 100) .5)
		(not (= (frames index) 50829)))
	    (snd-display #__line__ ";insert-sample: ~A ~A?" (sample 100) (frames index)))
	(let ((v0 (make-vector 3))
	      (v1 (make-vct 3)))
	  (vct-fill! v1 .75)
	  (do ((i 0 (+ 1 i))) ((= i 3)) (vector-set! v0 i .25))
	  (insert-samples 200 3 v0 index) 
	  (insert-samples 300 3 v1 index) 
	  (if (or (fneq (sample 201) .25)
		  (fneq (sample 301) .75)
		  (not (= (frames index) 50835)))
	      (snd-display #__line__ ";insert-samples: ~A ~A ~A?" (sample 201) (sample 301) (frames index))))
	(save-sound-as "hiho.snd" index mus-next mus-bshort :srate 22050)
	(let ((nindex (view-sound "hiho.snd")))
	  (if (fneq (sample 101 nindex) (sample 101 index))
	      (snd-display #__line__ ";save-sound-as: ~A ~A?" (sample 101 nindex) (sample 101 index)))
	  (if (not (read-only nindex)) (snd-display #__line__ ";read-only view-sound: ~A?" (read-only nindex)))
	  
	  (set! (speed-control-style nindex) speed-control-as-semitone)
	  (if (not (= (speed-control-style nindex) speed-control-as-semitone))
	      (snd-display #__line__ ";speed-control-style set semi: ~A" (speed-control-style nindex)))
	  (set! (speed-control-tones nindex) -8)
	  (if (not (= (speed-control-tones nindex) 12))
	      (snd-display #__line__ ";speed-control-tones -8: ~A" (speed-control-tones nindex)))
	  (set! (speed-control-tones nindex) 18)
	  (if (not (= (speed-control-tones nindex) 18))
	      (snd-display #__line__ ";speed-control-tones 18: ~A" (speed-control-tones nindex)))
	  (graph->ps "aaa.eps")
	  (close-sound nindex))
	(revert-sound index)
	(set! (sample 50 index) .5) 
	(if (fneq (sample 50) .5) (snd-display #__line__ ";set-sample: ~A?" (sample 50)))
	(let ((v0 (make-vector 3)))
	  (do ((i 0 (+ 1 i))) ((= i 3)) (vector-set! v0 i .25))
	  (set! (samples 60 3 index) v0) 
	  (if (or (fneq (sample 60) .25) (fneq (sample 61) .25))
	      (snd-display #__line__ ";set-samples: ~A ~A ~A?" (sample 60) (sample 61) (sample 62))))
	(set! (samples 10 3 index) (list 0.1 0.2 0.3))
	(if (not (vequal (channel->vct 10 3 index) (vct 0.1 0.2 0.3)))
	    (snd-display #__line__ ";set-samples via list: ~A" (channel->vct 10 3 index)))
	(revert-sound index)
	(save-sound-as "temporary.snd" index)
	(set! (samples 100000 20000 index) "temporary.snd")
	(if (not (vequal (channel->vct 110000 10) (channel->vct 10000 10)))
	    (snd-display #__line__ ";set samples to self: ~A ~A" (channel->vct 110000 10) (channel->vct 10000 10)))
	(revert-sound index)
	(delete-sample 100 index) 
	(if (not (file-exists? "temporary.snd"))
	    (snd-display #__line__ ";set-samples temp deleted?"))
	(delete-file "temporary.snd")
	(if (not (= (frames index) 50827)) (snd-display #__line__ ";delete-sample: ~A?" (frames index)))
	(delete-samples 0 100 index) 
	(if (not (= (frames index) 50727)) (snd-display #__line__ ";delete-samples: ~A?" (frames index)))
	(revert-sound index)
	(let ((maxa (maxamp index)))
	  (scale-to .5 index) 
	  (let ((newmaxa (maxamp index)))
	    (if (fneq newmaxa .5) (snd-display #__line__ ";scale-to: ~A?" newmaxa))
	    (undo 1 index) 
	    (scale-by 2.0 index) 
	    (set! newmaxa (maxamp index))
	    (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";scale-by: ~A?" newmaxa))
	    (revert-sound index)
	    (scale-by -1 index)
	    (mix "oboe.snd")
	    (if (fneq (maxamp index 0) 0.0) (snd-display #__line__ ";invert+mix->~A" (maxamp)))
	    (revert-sound index)
	    (select-all index) 
	    (if (not (= (length (regions)) 2)) (snd-display #__line__ ";regions(2): ~A?" (regions)))
	    (scale-selection-to .5) 
	    (set! newmaxa (maxamp index))
	    (if (fneq newmaxa .5) (snd-display #__line__ ";scale-selection-to: ~A?" newmaxa))
	    (revert-sound index)
	    (select-all index) 
	    (scale-selection-by 2.0) 
	    (set! newmaxa (maxamp index))
	    (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";scale-selection-by: ~A?" newmaxa))
	    (revert-sound index)
	    (with-temporary-selection (lambda () (scale-selection-by 2.0)) 0 (frames) index 0)
	    (set! newmaxa (maxamp index))
	    (if (fneq newmaxa (* 2.0 maxa)) (snd-display #__line__ ";with-temporary-selection: ~A?" newmaxa))
	    (revert-sound index)
	    (let ((samp999 (sample 999 index 0))
		  (samp1001 (sample 1001 index 0)))
	      (with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	      (if (fneq (sample 1000 index 0) 2.0) (snd-display #__line__ ";with-temporary-selection 1000: ~A" (sample 1000 index 0)))
	      (if (fneq (sample 999 index 0) samp999) (snd-display #__line__ ";with-temporary-selection 999: ~A from ~A" (sample 999 index 0) samp999))
	      (if (fneq (sample 1001 index 0) samp1001) (snd-display #__line__ ";with-temporary-selection 1001: ~A from ~A" (sample 1001 index 0) samp1001)))
	    (revert-sound index)
	    (make-selection 100 199 index 0)
	    (let ((old-start (selection-position index 0))
		  (old-len (selection-frames index 0)))
	      (with-temporary-selection (lambda () (scale-selection-to 2.0)) 1000 1 index 0)
	      (if (not (selection?)) (snd-display #__line__ ";with-temporary-selection restore?"))
	      (if (not (selection-member? index 0)) (snd-display #__line__ ";with-temporary-selection not member?"))
	      (if (not (= (selection-position index 0) old-start)) (snd-display #__line__ ";with-temporary-selection start: ~A" (selection-position index 0)))
	      (if (not (= (selection-frames index 0) old-len)) (snd-display #__line__ ";with-temporary-selection len: ~A" (selection-frames index 0))))
	    (revert-sound index)
	    (select-all index) 
	    (let ((rread (make-region-sampler (car (regions)) 0))
		  (sread (make-sampler 0 index))
		  (rvect (region->vct (car (regions)) 0 100))
		  (svect (samples 0 100 index)))
	      (if (fneq (vct-ref rvect 1) (region-sample (car (regions)) 1))
		  (snd-display #__line__ ";region-sample: ~A ~A?" (region-sample (car (regions)) 1) (vct-ref rvect 1)))
	      (do ((i 0 (+ 1 i)))
		  ((= i 100))
		(let ((rval (next-sample rread))
		      (sval (next-sample sread)))
		  (if (fneq rval sval) (snd-display #__line__ ";sample-read: ~A ~A?" rval sval))
		  (if (fneq rval (vct-ref rvect i)) (snd-display #__line__ ";region-samples: ~A ~A?" rval (vct-ref rvect i)))
		  (if (fneq sval (vct-ref svect i)) (snd-display #__line__ ";samples: ~A ~A?" sval (vct-ref svect i)))))
	      (free-sampler rread) 
	      (let ((val0 (next-sample sread)))
		(if (sampler-at-end? sread) (snd-display #__line__ ";premature end?"))
		(previous-sample sread)
		(let ((val1 (previous-sample sread)))
		  (if (fneq val0 val1) (snd-display #__line__ ";previous-sample: ~A ~A?" val0 val1))))
	      (free-sampler sread))))
	(revert-sound index)
	(let ((s100 (sample 100))
	      (s40 (sample 40))
	      (len (frames))
	      (addlen (mus-sound-frames "fyow.snd")))
	  (set! (cursor-style) cursor-line)
	  (set! (cursor-size) 25)
	  (set! (cursor index) 50) 
	  (if (not (= (cursor-style) cursor-line))
	      (snd-display #__line__ ";cursor-style: ~A? " (cursor-style)))
	  (if (not (= (cursor-size) 25))
	      (snd-display #__line__ ";cursor-size: ~A? " (cursor-size)))
	  (set! (cursor-style) cursor-cross)
	  (set! (cursor-size) 15)
	  (set! (cursor index 0) 30) 
	  (set! (cursor-style) cursor-line)
	  (set! (cursor index 0) 20) 
	  (if with-gui
	      (begin
		(set! (cursor-style index 0)
		      (lambda (snd chn ax)
			(let* ((point (cursor-position))
			       (x (car point))
			       (y (cadr point))
			       (size (floor (/ (cursor-size) 2))))
			  (draw-line (- x size) (- y size) (+ x size) (+ y size) snd chn cursor-context)    
			  (draw-line (- x size) (+ y size) (+ x size) (- y size) snd chn cursor-context))))
		(if (not (procedure? (cursor-style index 0))) (snd-display #__line__ ";set cursor-style to proc: ~A" (cursor-style index 0)))))
	  (set! (cursor index) 50)
	  (insert-sound "fyow.snd" (cursor) 0 index 0) 
	  (if (or (fneq (sample 40) s40) (not (fneq (sample 100) s100)) (fneq (sample 100) 0.001831))
	      (snd-display #__line__ ";insert-sound: ~A?" (sample 100)))
	  (if (not (= (frames) (+ len addlen))) (snd-display #__line__ ";insert-sound len: ~A?" (frames)))
	  (save-sound-as "not-temporary.snd")
	  (insert-samples 0 100 "not-temporary.snd")
	  (set! (cursor index 0 0) (- (frames index 0 0) 2))
	  (revert-sound)
	  (if (not (= (cursor index 0) (- (frames index 0) 2)))
	      (snd-display #__line__ ";set edpos cursor: ~A ~A ~A" (cursor) (cursor index 0 0) (- (frames index 0 0) 2)))
	  (if (not (file-exists? "not-temporary.snd"))
	      (snd-display #__line__ ";insert-samples deleted its file?")
	      (delete-file "not-temporary.snd"))
	  (let ((id (make-region 0 99)))
	    (insert-region id 60 index) 
	    (if (not (= (frames) (+ len 100))) (snd-display #__line__ ";insert-region len: ~A?" (frames)))
	    (if (fneq (sample 100) s40) (snd-display #__line__ ";insert-region: ~A ~A?" (sample 100) s40))
	    (let ((var (catch #t (lambda () (insert-region (integer->region (+ 1000 (apply max (map region->integer (regions))))) 0)) (lambda args args))))
	      (if (not (eq? (car var) 'no-such-region))
		  (snd-display #__line__ ";insert-region bad id: ~A" var)))
	    (save-region id "fmv.snd")
	    (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
		(snd-display #__line__ ";save-region header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	    (if (not (= (mus-sound-data-format "fmv.snd") mus-out-format))
		(snd-display #__line__ ";save-region format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	    (if (not (= (mus-sound-srate "fmv.snd") (region-srate id)))
		(snd-display #__line__ ";save-region srate: ~A (~A)" (mus-sound-srate "fmv.snd") (region-srate id)))
	    (if (not (= (mus-sound-chans "fmv.snd") (region-chans id)))
		(snd-display #__line__ ";save-region chans: ~A (~A)" (mus-sound-chans "fmv.snd") (region-chans id)))
	    (if (not (= (mus-sound-frames "fmv.snd") (region-frames id)))
		(snd-display #__line__ ";save-region length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-frames id)))
	    (if (not (= (region-position id 0) 0))
		(snd-display #__line__ ";save-region position: ~A" (region-position id 0)))
	    (delete-file "fmv.snd")
	    (save-region id "fmv.snd" mus-riff mus-lshort "this is a comment")
	    (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
		(snd-display #__line__ ";save-region riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	    (if (not (= (mus-sound-data-format "fmv.snd") mus-lshort))
		(snd-display #__line__ ";save-region lshort format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	    (if (not (= (mus-sound-frames "fmv.snd") (region-frames id)))
		(snd-display #__line__ ";save-region length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-frames id)))
	    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
		(snd-display #__line__ ";save-region comment: ~A" (mus-sound-comment "fmv.snd")))
	    (delete-file "fmv.snd")
	    (save-region id :file "fmv.snd" :header-type mus-riff :data-format mus-lshort :comment "this is a comment")
	    (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
		(snd-display #__line__ ";save-region opt riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	    (if (not (= (mus-sound-data-format "fmv.snd") mus-lshort))
		(snd-display #__line__ ";save-region opt lshort format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	    (if (not (= (mus-sound-frames "fmv.snd") (region-frames id)))
		(snd-display #__line__ ";save-region opt length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-frames id)))
	    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
		(snd-display #__line__ ";save-region opt comment: ~A" (mus-sound-comment "fmv.snd")))
	    (delete-file "fmv.snd")
	    (save-region id :comment "this is a comment" :file "fmv.snd" :data-format mus-lshort :header-type mus-riff)
	    (if (not (= (mus-sound-header-type "fmv.snd") mus-riff))
		(snd-display #__line__ ";save-region opt1 riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	    (if (not (= (mus-sound-data-format "fmv.snd") mus-lshort))
		(snd-display #__line__ ";save-region opt1 lshort format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	    (if (not (= (mus-sound-frames "fmv.snd") (region-frames id)))
		(snd-display #__line__ ";save-region opt1 length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-frames id)))
	    (if (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
		(snd-display #__line__ ";save-region opt1 comment: ~A" (mus-sound-comment "fmv.snd")))
	    (delete-file "fmv.snd")
	    (save-region id "fmv.snd" :data-format mus-bshort)
	    (if (not (= (mus-sound-header-type "fmv.snd") mus-next))
		(snd-display #__line__ ";save-region opt2 next header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	    (if (not (= (mus-sound-data-format "fmv.snd") mus-bshort))
		(snd-display #__line__ ";save-region opt2 bshort format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	    (delete-file "fmv.snd")
	    ))
	(close-sound index)
	(let ((var (catch #t (lambda () (new-sound "hi.snd" 0 1 100 0)) (lambda args args))))
	  (if (not (eq? (car var) 'out-of-range))
	      (snd-display #__line__ ";new-sound bad chan: ~A" var)))
	(set! index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "unequal lens"))
	(insert-silence 0 1000 index 1)
	(if (or (not (= (frames index 0) 1))
		(not (= (frames index 1) 1001)))
	    (snd-display #__line__ ";silence 1: ~A ~A" (frames index 0) (frames index 1)))
	(save-sound index)
	(if (or (not (= (frames index 0) 1001))
		(not (= (frames index 1) 1001)))
	    (snd-display #__line__ ";saved silence 1: ~A ~A" (frames index 0) (frames index 1)))
	(if (not (= (mus-sound-frames "fmv.snd") 1001))
	    (snd-display #__line__ ";saved framers silence 1: ~A" (mus-sound-frames "fmv.snd")))
	(let ((v0 (channel->vct 0 1000 index 0))
	      (v1 (channel->vct 0 1000 index 1)))
	  (if (fneq (vct-peak v0) 0.0)
	      (snd-display #__line__ ";auto-pad 0: ~A" (vct-peak v0)))
	  (if (fneq (vct-peak v1) 0.0)
	      (snd-display #__line__ ";silence 0: ~A" (vct-peak v1))))
	(close-sound index)
	(delete-file "fmv.snd")
	
	(set! index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "unequal lens"))
	(pad-channel 0 1000 index 1)
	(if (or (not (= (frames index 0) 1))
		(not (= (frames index 1) 1001)))
	    (snd-display #__line__ ";pad-channel 1: ~A ~A" (frames index 0) (frames index 1)))
	(let ((v0 (channel->vct 0 1000 index 0))
	      (v1 (channel->vct 0 1000 index 1)))
	  (if (fneq (vct-peak v0) 0.0)
	      (snd-display #__line__ ";pad 0: ~A" (vct-peak v0)))
	  (if (fneq (vct-peak v1) 0.0)
	      (snd-display #__line__ ";pad 1: ~A" (vct-peak v1))))
	(map-channel (lambda (n) 1.0) 0 2 index 0)
	(map-channel (lambda (n) 1.0) 0 1002 index 1)
	(pad-channel 0 1000 index 0 1)
	(if (not (= (frames index 1) 1002))
	    (snd-display #__line__ ";pad-channel ed 1: ~A ~A" (frames index 0) (frames index 1)))
	(close-sound index)
	(delete-file "fmv.snd")
	
	(let ((ind (open-sound "1a.snd")))
	  (scale-to 1.0 ind 0)
	  (make-selection 1000 2000 ind 0)
	  (filter-selection-and-smooth .01 (vct .25 .5 .5 .5 .25))
					;	  (if (fneq (sample 1500 ind 0) -0.0045776) (snd-display #__line__ ";filter-selection-and-smooth: ~A" (sample 1500 ind 0)))
	  (revert-sound ind)
	  (close-sound ind))
	
	(set! index (new-sound "fmv.snd" mus-ircam mus-bshort 22050 1 "this is a comment"))
	(let ((v0 (make-vct 128)))
	  (vct-set! v0 64 .5)
	  (vct-set! v0 127 .5)
	  (vct->channel v0 0 128 index 0)
	  (make-selection 0 126) 
	  (smooth-selection) 
	  (set! v0 (channel->vct 0 128 index 0))
	  (if (or (fneq (sample 127) .5) (fneq (sample 120) .4962) (fneq (sample 32) 0.07431) (fneq (sample 64) 0.25308))
	      (snd-display #__line__ ";smooth-selection: ~A?" v0))
	  (revert-sound index)
	  (vct-fill! v0 0.0)
	  (vct-set! v0 10 .5)

	  (vct->channel v0)
	  (select-all) 
	  (set! (sinc-width) 40)
	  (src-selection 0.5) 
	  (set! v0 (channel->vct 0 128 index 0))
	  (if (or (fneq (sample 20) .5) (fneq (sample 30) 0.0) (fneq (sample 17) -.1057) )
	      (snd-display #__line__ ";src-selection: ~A?" v0))
	  (revert-sound index)
	  (vct-fill! v0 0.0)
	  (vct-set! v0 10 .5)
	  (vct->channel v0 0)
	  (select-all) 
	  (filter-selection '(0 0 .1 1 1 0) 40) 
	  (set! v0 (channel->vct 0 128 index 0)) 
	  (if (or (fneq (sample 29) .1945) (fneq (sample 39) -.0137) (fneq (sample 24) -0.01986))
	      (snd-display #__line__ ";filter-selection: ~A?" v0))
	  (revert-sound index)
	  (vct-fill! v0 1.0)
	  (vct->channel v0 0 128 index 0) 
	  (select-all) 
	  (filter-selection (make-one-zero :a0 .5 :a1 0.0))
	  (set! v0 (channel->vct 0 128 index 0)) 
	  (if (or (fneq (sample 29) .5) (fneq (sample 39) .5) (fneq (sample 24) 0.5))
	      (snd-display #__line__ ";filter-selection one-zero: ~A?" v0))
	  (revert-sound index)
	  (vct-fill! v0 1.0)
	  (vct->channel v0 0 128 index 0) 
	  (if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	  (select-all) 
	  (env-selection '(0 0 1 1 2 0) 1.0) 
	  (set! v0 (channel->vct 0 128 index 0)) 
	  (if (or (fneq (sample 64) 1.0) (fneq (sample 20) .3125) (fneq (sample 119) 0.127))
	      (snd-display #__line__ ";env-selection [len: ~A]: ~A ~A ~A ~A?" (selection-frames) (sample 64) (sample 20) (sample 119) v0))
	  (save-selection "fmv5.snd" mus-next mus-bint 22050 "") ;1.0->-1.0 if short
	  (revert-sound index)
	  (let ((tag (catch #t (lambda () (file->array "/baddy/hiho" 0 0 128 v0)) (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-file)) (snd-display #__line__ ";file->array w/o file: ~A" tag)))
	  (let ((tag (catch #t (lambda () (file->array "fmv5.snd" 123 0 128 v0)) (lambda args (car args)))))
	    (if (not (eq? tag 'no-such-channel)) (snd-display #__line__ ";file->array w/o channel: ~A" tag)))
	  (file->array "fmv5.snd" 0 0 128 v0) 
	  (if (or (fneq (vct-ref v0 64) 1.0) (fneq (vct-ref v0 20) .3125) (fneq (vct-ref v0 119) 0.127))
	      (snd-display #__line__ ";save-selection: ~A ~A ~A ~A?" (vct-ref v0 64) (vct-ref v0 20) (vct-ref v0 119) v0))
	  (if (not (= (mus-sound-header-type "fmv5.snd") mus-next))
	      (snd-display #__line__ ";save-selection type: ~A?" (mus-header-type-name (mus-sound-header-type "fmv5.snd"))))
	  (if (not (= (mus-sound-data-format "fmv5.snd") mus-bint))
	      (snd-display #__line__ ";save-selection format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv5.snd"))))
	  (if (not (= (mus-sound-srate "fmv5.snd") 22050))
	      (snd-display #__line__ ";save-selection srate: ~A?" (mus-sound-srate "fmv5.snd")))
	  (vct-fill! v0 0.0)
	  (vct-set! v0 100 .5)
	  (vct-set! v0 2 -.5)
	  (vct->channel v0 0 128 index 0) 
	  (select-all) 
	  (without-errors (reverse-selection)) 
	  (save-selection "fmv4.snd" mus-riff mus-lfloat 44100 "this is a comment")
	  (set! v0 (channel->vct 0 128 index 0)) 
	  (if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	      (snd-display #__line__ ";reverse-selection: ~A?" v0))
	  (file->array "fmv4.snd" 0 0 128 v0) 
	  (if (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	      (snd-display #__line__ ";save reverse-selection: ~A?" v0))
	  (if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	      (snd-display #__line__ ";save-selection type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	  (if (not (= (mus-sound-data-format "fmv4.snd") mus-lfloat))
	      (snd-display #__line__ ";save-selection format 1: ~A?" (mus-data-format-name (mus-sound-data-format "fmv4.snd"))))
	  (if (not (= (mus-sound-srate "fmv4.snd") 44100))
	      (snd-display #__line__ ";save-selection srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	  (if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	      (snd-display #__line__ ";save-selection comment: ~A?" (mus-sound-comment "fmv4.snd")))
	  (delete-file "fmv4.snd")
	  (save-selection :file "fmv4.snd" :header-type mus-riff :data-format mus-lfloat :srate 44100 :comment "this is a comment")
	  (if (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	      (snd-display #__line__ ";save-selection opt type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	  (if (not (= (mus-sound-data-format "fmv4.snd") mus-lfloat))
	      (snd-display #__line__ ";save-selection opt format 1: ~A?" (mus-data-format-name (mus-sound-data-format "fmv4.snd"))))
	  (if (not (= (mus-sound-srate "fmv4.snd") 44100))
	      (snd-display #__line__ ";save-selection opt srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	  (if (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	      (snd-display #__line__ ";save-selection opt comment: ~A?" (mus-sound-comment "fmv4.snd")))
	  (delete-file "fmv4.snd")
	  (save-selection :file "fmv4.snd" :data-format mus-bfloat :channel 0)
	  (if (and (not (= (mus-sound-header-type "fmv4.snd") mus-next))
		   (not (= (mus-sound-header-type "fmv4.snd") mus-ircam)))
	      (snd-display #__line__ ";save-selection opt1 type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	  (if (not (= (mus-sound-data-format "fmv4.snd") mus-bfloat))
	      (snd-display #__line__ ";save-selection opt1 format 1: ~A?" (mus-data-format-name (mus-sound-data-format "fmv4.snd"))))
	  (if (not (= (mus-sound-chans "fmv4.snd") 1))
	      (snd-display #__line__ ";save-selection opt1 chans: ~A?" (mus-sound-chans "fmv4.snd")))
	  (delete-file "fmv4.snd")
	  (revert-sound index)
	  (vct-fill! v0 0.0)
	  (vct-set! v0 2 1.0)
	  (let ((v1 (make-vct 256)))
	    (do ((i 0 (+ 1 i)))
		((= i 128))
	      (vct-set! v1 i (vct-ref v0 i)))
	    (vct->channel v1 0 128 index 0))
	  (select-all)
	  (if (mus-clipping) (set! (mus-clipping) #f))
	  (if (clipping) (set! (clipping) #f))
	  (convolve-selection-with "fmv5.snd" .5) 
	  (set! v0 (channel->vct 0 128 index 0))
	  (if (fneq (sample 66) -.5) (snd-display #__line__ ";convolve-selection-with: ~A ~A ~A?" (vct-ref v0 66) (sample 66) v0))
	  (close-sound index))
	(let* ((obind (open-sound "oboe.snd"))
	       (vol (maxamp obind))
	       (dur (frames)))
	  (set! (amp-control obind) 2.0)
	  (if (fffneq (amp-control obind) 2.0) (snd-display #__line__ ";set amp-control ~A" (amp-control obind)))
	  (reset-controls obind)
	  (if (ffneq (amp-control obind) 1.0) (snd-display #__line__ ";reset amp-control ~A" (amp-control obind)))
	  (set! (amp-control-bounds obind) (list 0.0 4.0))
	  (if (not (equal? (amp-control-bounds obind) (list 0.0 4.0))) (snd-display #__line__ ";amp-control-bounds: ~A" (amp-control-bounds)))
	  (set! (amp-control obind) 2.0)
	  (if (eq? (without-errors (apply-controls obind)) 'no-such-sound) (snd-display #__line__ ";apply-controls can't find oboe.snd?"))
	  (let ((newamp (maxamp obind)))
	    (if (> (abs (- (* 2.0 vol) newamp)) .05) (snd-display #__line__ ";apply amp: ~A -> ~A?" vol newamp))
	    (set! (amp-control-bounds obind) (list 0.0 8.0))
	    (set! (speed-control-bounds obind) (list 1.0 5.0))
	    (if (not (equal? (speed-control-bounds obind) (list 1.0 5.0))) (snd-display #__line__ ";speed-control-bounds: ~A" (speed-control-bounds)))
	    (set! (speed-control obind) 0.5)
	    (set! (speed-control-bounds obind) (list .05 20.0))
	    (add-mark 1234)
	    (apply-controls obind)
	    (let ((newdur (frames obind)))
	      (set! (speed-control obind) 1.0)
	      (if (not (< (- newdur (* 2.0 dur)) 256)) (snd-display #__line__ ";apply speed: ~A -> ~A?" dur newdur))
	      ;; within 256 which is apply's buffer size (it always flushes full buffers) 
	      (set! (contrast-control? obind) #t)
	      (set! (contrast-control-bounds obind) (list 0.5 2.5))
	      (if (not (equal? (contrast-control-bounds obind) (list 0.5 2.5))) (snd-display #__line__ ";contrast-control-bounds: ~A" (contrast-control-bounds)))
	      (set! (contrast-control obind) 1.0)
	      (apply-controls obind)
	      (set! (contrast-control-bounds obind) (list 0.0 10.0))
	      (if (not (equal? (contrast-control-bounds obind) (list 0.0 10.0))) (snd-display #__line__ ";contrast-control-bounds (2): ~A" (contrast-control-bounds)))
	      (let ((secamp (maxamp obind))
		    (secdur (frames obind)))
		(if (fneq secamp .989) (snd-display #__line__ ";apply contrast: ~A?" secamp))
		(if (not (= secdur newdur)) (snd-display #__line__ ";apply contrast length: ~A -> ~A?" newdur secdur))
		(undo 3 obind)
		(set! (reverb-control? obind) #t)
		(set! (reverb-control-scale-bounds obind) (list 0.0 1.0))
		(if (not (equal? (reverb-control-scale-bounds obind) (list 0.0 1.0))) 
		    (snd-display #__line__ ";reverb-control-scale-bounds: ~A" (reverb-control-scale-bounds)))
		(set! (reverb-control-length-bounds obind) (list 0.0 2.0))
		(if (not (equal? (reverb-control-length-bounds obind) (list 0.0 2.0))) 
		    (snd-display #__line__ ";reverb-control-length-bounds: ~A" (reverb-control-length-bounds)))
		(set! (reverb-control-scale obind) .2)
		(apply-controls obind)
		(let ((revamp (maxamp obind))
		      (revdur (frames obind)))
		  (if (ffneq revamp .214) (snd-display #__line__ ";apply reverb scale: ~A?" revamp))
		  (if (not (< (- revdur (+ 50828 (round (* (reverb-control-decay) 22050)))) 256)) 
		      (snd-display #__line__ ";apply reverb length: ~A?" revdur))
		  (undo 1 obind)
		  (set! (expand-control? obind) #t)
		  (set! (expand-control-bounds obind) (list 1.0 3.0))
		  (if (not (equal? (expand-control-bounds obind) (list 1.0 3.0))) (snd-display #__line__ ";expand-control-bounds: ~A" (expand-control-bounds)))
		  (set! (expand-control obind) 1.5)
		  (apply-controls obind)
		  (let ((expamp (maxamp obind))
			(expdur (frames obind)))
		    (if (> (abs (- expamp .152)) .05) (snd-display #__line__ ";apply expand-control scale: ~A?" expamp))
		    (if (not (> expdur (* 1.25 50828))) (snd-display #__line__ ";apply expand-control length: ~A?" expdur))
		    (set! (expand-control-bounds obind) (list 0.001 20.0))
		    (undo 1 obind)
		    (set! (filter-control? obind) #t)
		    (set! (filter-control-order obind) 40)
		    (set! (filter-control-envelope obind) '(0 0 1 .5 2 0))
		    (apply-controls obind)
		    (let ((fltamp (maxamp obind))
			  (fltdur (frames obind)))
		      (if (> (abs (- fltamp .02)) .005) (snd-display #__line__ ";apply filter scale: ~A?" fltamp))
		      (if (> (- fltdur (+ 40 50828)) 256) (snd-display #__line__ ";apply filter length: ~A?" fltdur))
		      (undo 1 obind)))))))
	  (revert-sound obind)
	  (make-selection 1000 1000)
	  (scale-selection-to .1)
	  (scale-selection-by 2.0)
	  (make-selection 2000 2001)
	  (scale-selection-by 2.0)
	  (scale-selection-to .5)
	  (make-selection 1000 2001)
	  (scale-selection-to .5)
	  (scale-selection-by .5)
	  (make-selection 2000 2000)
	  (scale-selection-by 2.0)
	  (scale-selection-to .5)
	  (make-selection 1000 1001)
	  (scale-selection-to .1)
	  (scale-selection-by 2.0)
	  (make-selection 999 2002)
	  (scale-selection-to 1.0)
	  (scale-selection-by .5)
	  (let ((tree (edit-tree))
		(true-tree '((0 0 0 998 1.0 0.0 0.0 0) 
			     (999 0 999 999 0.999969720840454 0.0 0.0 0) 
			     (1000 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			     (1001 0 1001 1001 0.999969720840454 0.0 0.0 0) 
			     (1002 0 1002 1999 0.499984979629517 0.0 0.0 0) 
			     (2000 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			     (2001 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			     (2002 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			     (2003 0 2003 50827 1.0 0.0 0.0 0) 
			     (50828 -2 0 0 0.0 0.0 0.0 0))))
	    (if (not (= (length tree) (length true-tree)))
		(snd-display #__line__ ";edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
		(let ((len (length tree)))
		  (do ((i 0 (+ 1 i)))
		      ((= i len))
		    (let ((branch (list-ref tree i))
			  (true-branch (list-ref true-tree i)))
		      (if (or (not (= (car branch) (car true-branch)))
			      (not (= (cadr branch) (cadr true-branch)))
			      (not (= (caddr branch) (caddr true-branch)))
			      (not (= (cadddr branch) (cadddr true-branch)))
			      (fneq (list-ref branch 4) (list-ref true-branch 4)))
			  (snd-display #__line__ ";edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	  (insert-silence 1001 8)
	  (insert-silence 900 50)
	  (insert-silence 2005 1)
	  (insert-silence 999 2)
	  (let ((tree (edit-tree))
		(true-tree '((0 0 0 899 1.0 0.0 0.0 0) 
			     (900 -1 0 49 0.0 0.0 0.0 0) 
			     (950 0 900 948 1.0 0.0 0.0 0) 
			     (999 -1 0 1 0.0 0.0 0.0 0) 
			     (1001 0 949 998 1.0 0.0 0.0 0) 
			     (1051 0 999 999 0.999969720840454 0.0 0.0 0) 
			     (1052 0 1000 1000 6.09052181243896 0.0 0.0 0) 
			     (1053 -1 0 7 0.0 0.0 0.0 0) 
			     (1061 0 1001 1001 0.999969720840454 0.0 0.0 0)
			     (1062 0 1002 1946 0.499984979629517 0.0 0.0 0) 
			     (2007 -1 0 0 0.0 0.0 0.0 0) 
			     (2008 0 1947 1999 0.499984979629517 0.0 0.0 0) 
			     (2061 0 2000 2000 7.54652404785156 0.0 0.0 0) 
			     (2062 0 2001 2001 3.7732629776001 0.0 0.0 0) 
			     (2063 0 2002 2002 0.999969720840454 0.0 0.0 0) 
			     (2064 0 2003 50827 1.0 0.0 0.0 0) 
			     (50889 -2 0 0 0.0 0.0 0.0 0))))
	    (if (not (= (length tree) (length true-tree)))
		(snd-display #__line__ ";silenced edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
		(let ((len (length tree)))
		  (do ((i 0 (+ 1 i)))
		      ((= i len))
		    (let ((branch (list-ref tree i))
			  (true-branch (list-ref true-tree i)))
		      (if (or (not (= (car branch) (car true-branch)))
			      (not (= (cadr branch) (cadr true-branch)))
			      (not (= (caddr branch) (caddr true-branch)))
			      (not (= (cadddr branch) (cadddr true-branch)))
			      (fneq (list-ref branch 4) (list-ref true-branch 4)))
			  (snd-display #__line__ ";silenced edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	  (if (or (fneq (sample 998) -.03)
		  (fneq (sample 999) 0.0)
		  (fneq (sample 1000) 0.0)
		  (fneq (sample 1001) -.03))
	      (snd-display #__line__ ";insert-silence [999 for 2]: ~A ~A ~A ~A?" (sample 998) (sample 999) (sample 1000) (sample 1001) ))
	  (if (or (fneq (sample 2006) -.033)
		  (fneq (sample 2007) 0.0)
		  (fneq (sample 2008) -.033))
	      (snd-display #__line__ ";insert-silence [2007 for 1]: ~A ~A ~A?" (sample 2006) (sample 2007) (sample 2008)))
	  (revert-sound obind)
	  (add-mark 1200 obind 0)
	  (let ((mark-num (length (marks obind 0))))
	    (scale-by 2.0 obind 0)
	    (let ((mark-now (length (marks obind 0))))
	      (if (not (= mark-num mark-now))
		  (snd-display #__line__ ";mark lost after scaling?"))
	      (set! (selection-position) 0)
	      (set! (selection-frames) 100)
	      (scale-selection-to .5)
	      (set! mark-now (length (marks obind 0)))
	      (if (not (= mark-num mark-now))
		  (snd-display #__line__ ";mark lost after selection scaling?")))
	    (let ((m1 (add-mark 1000)))
	      (set! (cursor obind 0) 100)
	      (key (char->integer #\u) 4 obind)
	      (key (char->integer #\1) 0 obind)
	      (key (char->integer #\0) 0 obind)
	      (key (char->integer #\0) 0 obind)
	      (key (char->integer #\o) 4 obind)
	      (if (not (= (mark-sample m1) 1100))
		  (snd-display #__line__ ";mark after zeros: ~D (1100)? " (mark-sample m1)))
	      (set! (cursor obind) 0)
	      (key (char->integer #\j) 4 obind)
	      (if (not (= (cursor obind) 1100)) (snd-display #__line__ ";c-j to ~A" (cursor obind)))
	      (add-mark 100)
	      (set! (cursor obind) 0)
	      (key (char->integer #\u) 4 obind)
	      (key (char->integer #\2) 0 obind)
	      (key (char->integer #\j) 4 obind)
	      (if (not (= (cursor obind) 1100)) (snd-display #__line__ ";c-u 2 c-j ~A" (cursor obind)))
	      (key (char->integer #\-) 4 obind)
	      (key (char->integer #\j) 4 obind)
	      (if (not (= (cursor obind) 100)) (snd-display #__line__ ";c-- c-j ~A" (cursor obind)))))
	  (revert-sound obind)
	  (let ((frs (frames obind)))
	    (make-region 0 999 obind 0)
	    (if (not (selection?)) (snd-display #__line__ ";make-region but no selection? ~A" (selection?)))
	    (delete-selection)
	    (if (not (= (frames obind) (- frs 1000)))
		(snd-display #__line__ ";delete-selection: ~A?" (frames obind)))
	    (let ((val (sample 0 obind 0)))
	      (undo)
	      (if (fneq (sample 1000) val)
		  (snd-display #__line__ ";delete-selection val: ~A ~A" val (sample 1000)))
	      (insert-selection)
	      (let ((var (catch #t (lambda () (insert-selection 0 obind 123)) (lambda args args))))
		(if (not (eq? (car var) 'no-such-channel))
		    (snd-display #__line__ ";insert-selection bad chan: ~A" var)))
	      (let ((var (catch #t (lambda () (mix-selection 0 obind 123)) (lambda args args))))
		(if (not (eq? (car var) 'no-such-channel))
		    (snd-display #__line__ ";mix-selection bad chan: ~A" var)))
	      (if (not (= (frames obind) (+ frs 1000)))
		  (snd-display #__line__ ";insert-selection: ~A?" (frames obind)))
	      (if (fneq (sample 2000) val)
		  (snd-display #__line__ ";insert-selection val: ~A ~A" val (sample 2000)))
	      (set! val (sample 900))
	      (mix-selection)
	      (if (fneq (sample 900) (* 2 val))
		  (snd-display #__line__ ";mix-selection val: ~A ~A" (* 2 val) (sample 900)))
	      (if (not (= (frames obind) (+ frs 1000)))
		  (snd-display #__line__ ";mix-selection len: ~A?" (frames obind)))))
	  (close-sound obind))
	
	(let* ((ind (open-sound "2.snd"))
	       (apply-to-sound 0)
	       (apply-to-channel 1)
	       (apply-to-selection 2)
	       (len (frames ind)))
	  (set! (sync ind) 1)
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-sound) ; temp 1
	  (if (> (abs (- (frames) (* 2 len))) 256)
	      (snd-display #__line__ ";apply srate .5: ~A ~A" (frames) (* 2 len)))
	  (make-selection 0 (frames))
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-selection) ; temp 2
	  (if (> (abs (- (frames) (* 4 len))) 256)
	      (snd-display #__line__ ";apply srate .5 to selection: ~A ~A" (frames) (* 4 len)))
	  (env-sound '(0 0 1 1) 0 (frames) 32.0) ; temp 3
	  (let ((reg (select-all))) ; make multi-channel region
	    (insert-region reg 0) ; temp 4
	    (insert-selection 0))  ; temp 5
	  (revert-sound ind)
	  (set! (speed-control) .5)
	  (set! (sync ind) 0)
	  (set! (selected-channel ind) 1)
	  (apply-controls ind apply-to-channel)
	  (if (> (abs (- (frames ind 1) (* 2 len))) 256)
	      (snd-display #__line__ ";apply srate .5 to chan 1: ~A ~A" (frames ind 1) (* 2 len)))
	  (if (not (= (frames ind 0) len))
	      (snd-display #__line__ ";apply srate .5 but chan 0: ~A ~A" (frames ind 0) len))
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-sound 1000)
	  (make-selection 2000 4000)
	  (set! (speed-control ind) .5)
	  (apply-controls ind apply-to-selection)
	  (set! (selected-channel ind) #f)
	  (if (selected-channel ind) (snd-display #__line__ ";selected-channel #f: ~A" (selected-channel ind)))
	  (close-sound ind))
	
	(let* ((ind1 (open-sound "oboe.snd"))
	       (mx1 (maxamp ind1 0))
	       (ind2 (open-sound "2.snd"))
	       (mx20 (maxamp ind2 0))
	       (mx21 (maxamp ind2 1)))
	  (select-sound ind1)
	  (scale-sound-by 2.0)
	  (let ((nmx (maxamp ind1 0)))
	    (if (fneq (* 2 mx1) nmx) (snd-display #__line__ ";scale-sound-by 2.0: ~A ~A?" mx1 nmx))
	    (if (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.000 0 #f" "scale" 0 50828)))
		(snd-display #__line__ ";scale-sound-by: ~A?" (edit-fragment 1 ind1 0))))
	  (scale-sound-to 0.5)
	  (let ((nmx (maxamp ind1 0)))
	    (if (fneq nmx 0.5) (snd-display #__line__ ";scale-sound-to 0.5: ~A?" nmx))
	    (if (not (equal? (edit-fragment 2 ind1 0) (list "scale-channel 1.698 0 #f" "scale" 0 50828)))
		(snd-display #__line__ ";scale-sound-to: ~A?" (edit-fragment 2 ind1 0))))
	  (scale-sound-by 0.0 0 1000 ind1 0)
	  (let ((nmx (maxamp ind1 0)))
	    (if (fneq 0.5 nmx) (snd-display #__line__ ";scale-sound-by 0.0: ~A ~A?" mx1 nmx))
	    (if (not (equal? (edit-fragment 3 ind1 0) (list "scale-channel 0.000 0 1000" "scale" 0 1000)))
		(snd-display #__line__ ";scale-sound-by 0.0: ~A?" (edit-fragment 3 ind1 0))))
	  (let* ((v (channel->vct 0 1000 ind1 0))
		 (pk (vct-peak v)))
	    (if (fneq pk 0.0) (snd-display #__line__ ";scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	  (revert-sound ind1)
	  (let ((oldv (channel->vct 12000 10 ind1 0)))
	    (scale-sound-by 2.0 12000 10 ind1 0)
	    (let ((newv (channel->vct 12000 10 ind1 0)))
	      (do ((i 0 (+ 1 i)))
		  ((= i 10))
		(if (fneq (* 2.0 (vct-ref oldv i)) (vct-ref newv i))
		    (snd-display #__line__ ";scale ~D: ~A ~A?" i (vct-ref oldv i) (vct-ref newv i)))))
	    (if (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.000 12000 10" "scale" 12000 10)))
		(snd-display #__line__ ";scale-sound-by 2.0 [12000:10]: ~A?" (edit-fragment 1 ind1 0))))
	  (revert-sound ind1)
	  (select-sound ind2)
	  (scale-sound-by 2.0)
	  (let ((nmx (maxamp ind2 0)))
	    (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	  (let ((nmx (maxamp ind2 1)))
	    (if (fneq (* 2 mx21) nmx) (snd-display #__line__ ";2:1 scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	  (scale-sound-to 0.5)
	  (let ((nmx (max (maxamp ind2 0) (maxamp ind2 1))))
	    (if (fneq nmx 0.5) (snd-display #__line__ ";2 scale-sound-to 0.5: ~A (~A)?" nmx (maxamp ind2))))
	  (scale-sound-by 0.0 0 1000 ind2 1)
	  (if (not (equal? (edit-fragment 3 ind2 1) (list "scale-channel 0.000 0 1000" "scale" 0 1000)))
	      (snd-display #__line__ ";2:1 scale-sound-by 0.0: ~A?" (edit-fragment 3 ind2 1)))
	  (let* ((v (channel->vct 0 1000 ind2 1))
		 (pk (vct-peak v)))
	    (if (fneq pk 0.0) (snd-display #__line__ ";2:1 scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	  (revert-sound ind2)
	  (let ((oldv (channel->vct 12000 10 ind2 0)))
	    (scale-sound-by 2.0 12000 10 ind2 0)
	    (let ((newv (channel->vct 12000 10 ind2 0)))
	      (do ((i 0 (+ 1 i)))
		  ((= i 10))
		(if (fneq (* 2.0 (vct-ref oldv i)) (vct-ref newv i))
		    (snd-display #__line__ ";2 scale ~D: ~A ~A?" i (vct-ref oldv i) (vct-ref newv i))))))
	  (revert-sound ind2)
	  (set! (sync ind2) 3)
	  (set! (sync ind1) 3)
	  (scale-sound-by 2.0)
	  (let ((nmx (maxamp ind1 0)))
	    (if (fneq mx1 nmx) (snd-display #__line__ ";sync scale-sound-by 2.0: ~A ~A?" mx1 nmx)))
	  (let ((nmx (maxamp ind2 0)))
	    (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 sync scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	  (let ((nmx (maxamp ind2 1)))
	    (if (fneq (* 2 mx21) nmx) (snd-display #__line__ ";2:1 sync scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	  (scale-sound-to 1.0 20000 40000 ind2 1)
	  (let ((nmx (maxamp ind1 0)))
	    (if (fneq mx1 nmx) (snd-display #__line__ ";sync scale-sound-to 1.0: ~A ~A?" mx1 nmx)))
	  (let ((nmx (maxamp ind2 0)))
	    (if (fneq (* 2 mx20) nmx) (snd-display #__line__ ";2:0 sync scale-sound-to 1.0: ~A ~A?" mx20 nmx)))
	  (let ((nmx (maxamp ind2 1)))
	    (if (fneq nmx 1.0) (snd-display #__line__ ";2:1 sync scale-sound-to 1.0: ~A?" nmx)))
	  
	  (close-sound ind1)
	  (close-sound ind2))
	
	(let* ((ind (open-sound "now.snd")))
	  (set! (amp-control ind) .5)
	  (if (ffneq (amp-control ind) .5) (snd-display #__line__ ";amp-control (.5): ~A?" (amp-control ind)))
	  (set! (amp-control ind 0) .25)
	  (if (ffneq (amp-control ind) .5) (snd-display #__line__ ";amp-control after local set (.5): ~A?" (amp-control ind)))
	  (if (ffneq (amp-control ind 0) .25) (snd-display #__line__ ";amp-control 0 (.25): ~A?" (amp-control ind 0)))
	  (set! (amp-control ind) 1.0)
	  (if (ffneq (amp-control ind) 1.0) (snd-display #__line__ ";amp-control (1.0): ~A?" (amp-control ind)))
	  (if (ffneq (amp-control ind 0) .25) (snd-display #__line__ ";amp-control 0 after set (.25): ~A?" (amp-control ind 0)))
	  (set! (transform-graph? ind 0) #t)
	  (set! (transform-graph-type ind 0) graph-as-sonogram)
	  (update-transform-graph ind 0)
	  (let ((val (transform-frames ind 0)))
	    (if (or (not (list? val))
		    (fneq (car val) 1.0)
		    (not (= (caddr val) 256)))
		(snd-display #__line__ ";transform-frames: ~A (~A)" val (transform-size ind 0))))
	  (close-sound ind)
	  (set! ind (open-sound "4.aiff"))
	  (if (ffneq (amp-control ind) 1.0) (snd-display #__line__ ";amp-control upon open (1.0): ~A?" (amp-control ind)))
	  (if (ffneq (amp-control ind 2) 1.0) (snd-display #__line__ ";amp-control 2 upon open (1.0): ~A?" (amp-control ind 2)))
	  (set! (amp-control ind) .5)
	  (if (ffneq (amp-control ind 2) .5) (snd-display #__line__ ";amp-control 2 after global set (.5): ~A?" (amp-control ind 2)))
	  (set! (amp-control ind 2) .25)
	  (if (ffneq (amp-control ind 2) .25) (snd-display #__line__ ";amp-control 2 (.25): ~A?" (amp-control ind 2)))
	  (if (ffneq (amp-control ind 1) .5) (snd-display #__line__ ";amp-control 1 after local set (.5): ~A?" (amp-control ind 1)))
	  (let ((after-ran #f))
	    (reset-hook! after-apply-controls-hook)
	    (add-hook! after-apply-controls-hook (lambda (snd) (set! after-ran snd)))
	    (apply-controls ind)
	    (if (not (equal? ind after-ran)) (snd-display #__line__ ";after-apply-controls-hook: ~A?" after-ran))
	    (reset-hook! after-apply-controls-hook))
	  (revert-sound ind)
	  (set! (sync ind) 1)
	  (scale-to (vct .1 .2))
	  (let ((mx (maxamp ind #t)))
	    (if (or (fneq (list-ref mx 0) .1)
		    (fneq (list-ref mx 1) .2)
		    (fneq (list-ref mx 2) .2)
		    (fneq (list-ref mx 3) .2))
		(snd-display #__line__ ";scale to with vector: ~A" mx)))
	  (set! (filter-control-envelope ind) '(0 0 1 1))
	  (if (not (feql '(0.0 0.0 1.0 1.0) (filter-control-envelope ind))) 
	      (snd-display #__line__ ";set filter-control-envelope: ~A?" (filter-control-envelope ind)))
	  (set! (filter-control-order ind) 20)
	  (if (not (vequal (filter-control-coeffs ind)
			   (vct -0.007 0.010 -0.025 0.029 -0.050 0.055 -0.096 0.109 -0.268 0.241 
				0.241 -0.268 0.109 -0.096 0.055 -0.050 0.029 -0.025 0.010 -0.007)))
	      (snd-display #__line__ ";highpass coeffs: ~A" (filter-control-coeffs ind)))
	  (set! (filter-control-envelope ind) (filter-control-envelope ind))
	  (if (not (feql '(0.0 0.0 1.0 1.0) (filter-control-envelope ind))) 
	      (snd-display #__line__ ";set filter-control-envelope to self: ~A?" (filter-control-envelope ind)))
	  (set! (filter-control-envelope ind) '(0 1 1 0))
	  (if (not (vequal (filter-control-coeffs ind)
			   (vct 0.003 0.002 0.004 0.002 0.007 0.003 0.014 0.012 0.059 0.394 
				0.394 0.059 0.012 0.014 0.003 0.007 0.002 0.004 0.002 0.003)))
	      (snd-display #__line__ ";lowpass coeffs: ~A" (filter-control-coeffs ind)))
	  (close-sound ind))
	
	(let* ((obind (open-sound "4.aiff"))
	       (amps (maxamp obind #t))
	       (times (maxamp-position obind #t)))
	  (if (not (equal? times (list 810071 810071 810071 810071)))
	      (snd-display #__line__ ";4.aiff times: ~A" times))
	  (if (< (window-width) 600) 
	      (set! (window-width) 600))
	  (if (< (window-height) 600)
	      (set! (window-height) 600))
	  (set! (x-bounds obind 0) (list 0.0 0.1))
	  (set! (show-axes obind 0) show-x-axis)
	  (update-time-graph)
	  (set! (amp-control obind) 0.1)
	  (select-channel 2)
	  (if (eq? (without-errors (apply-controls obind 1)) 'no-such-sound) (snd-display #__line__ ";apply-controls can't find 4.aiff?"))
	  (let ((newamps (maxamp obind #t)))
	    (if (or (fneq (car amps) (car newamps))
		    (fneq (cadr amps) (cadr newamps))
		    (> (abs (- (* 0.1 (caddr amps)) (caddr newamps))) .05)
		    (fneq (cadddr amps) (cadddr newamps)))
		(snd-display #__line__ ";apply amps:~%  ~A ->~%  ~A?" amps newamps))
	    (undo 1 obind 2)
	    (set! (amp-control obind) 0.1)
	    (make-region 0 (frames obind) obind 1)
	    (without-errors (apply-controls obind 2))
	    (set! newamps (maxamp obind #t))
	    (if (or (fneq (car amps) (car newamps))
		    (> (abs (- (* 0.1 (cadr amps)) (cadr newamps))) .05)
		    (fneq (caddr amps) (caddr newamps))
		    (fneq (cadddr amps) (cadddr newamps)))
		(snd-display #__line__ ";apply selection amp:~%  ~A ->~%  ~A?" amps newamps))
	    (if with-gui
		(let* ((axinfo (axis-info obind 0 time-graph))
		       (losamp (car axinfo))
		       (hisamp (cadr axinfo))
		       (x0 (list-ref axinfo 2))
		       (y0 (list-ref axinfo 3))
		       (x1 (list-ref axinfo 4))
		       (y1 (list-ref axinfo 5))
		       (xpos (+ x0 (* .5 (- x1 x0))))
		       (ypos (+ y0 (* .75 (- y1 y0)))))
		  (define (cp-x x) (floor (+ (list-ref axinfo 10) 
					     (* (- x x0) (/ (- (list-ref axinfo 12) (list-ref axinfo 10)) 
							    (- x1 x0))))))
		  (define (cp-y y) (floor (+ (list-ref axinfo 13) 
					     (* (- y1 y) (/ (- (list-ref axinfo 11) (list-ref axinfo 13)) 
							    (- y1 y0))))))
		  (select-channel 0)
		  (set! (cursor obind) 100)
		  (let ((xy (cursor-position obind)))
		    (if (fneq (position->x (car xy)) (/ (cursor obind) (srate obind)))
			(snd-display #__line__ ";cursor-position: ~A ~A ~A?" (car xy) (position->x (car xy)) (/ (cursor obind) (srate obind)))))
		  (if (fneq (position->x (x->position xpos)) xpos)
		      (snd-display #__line__ ";x<->position: ~A ~A?" (position->x (x->position xpos)) xpos))
		  (if (> (abs (- (position->y (y->position ypos)) ypos)) .5)
		      (snd-display #__line__ ";y<->position: ~A ~A?" (position->y (y->position ypos)) ypos))
		  (if (not (= losamp (left-sample obind 0)))
		      (snd-display #__line__ ";axis-info[0 losamp]: ~A ~A?" losamp (left-sample obind 0)))
		  (if (not (= hisamp (right-sample obind 0)))
		      (snd-display #__line__ ";axis-info[1 hisamp]: ~A ~A?" hisamp (right-sample obind 0)))
		  (if (fneq (list-ref axinfo 6) 0.0)
		      (snd-display #__line__ ";axis-info[6 xmin]: ~A?" (list-ref axinfo 6)))
		  (if (fneq (list-ref axinfo 7) -1.0)
		      (snd-display #__line__ ";axis-info[7 ymin]: ~A?" (list-ref axinfo 7)))
		  (if (fneq (list-ref axinfo 9) 1.0)
		      (snd-display #__line__ ";axis-info[9 ymax]: ~A?" (list-ref axinfo 9)))
		  (if (> (abs (apply - (our-x->position obind x0))) 1) 
		      (snd-display #__line__ ";x0->position: ~A?" (our-x->position obind x0)))
		  (if (> (abs (apply - (our-x->position obind x1))) 1) 
		      (snd-display #__line__ ";x1->position: ~A?" (our-x->position obind x1)))
		  (if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		      (snd-display #__line__ ";xmid->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		  (if (not full-test)
		      (begin
			(if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			    (snd-display #__line__ ";cp-x .5: ~A ~A?" (x->position xpos) (cp-x xpos)))
			(if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			    (snd-display #__line__ ";cp-y .75: ~A ~A?" (y->position ypos) (cp-y ypos)))
			(do ((i 0 (+ 1 i)))
			    ((= i 10))
			  (let ((xpos (+ x0 (random (- x1 x0))))
				(ypos (+ y0 (random (- y1 y0)))))
			    (if (> (abs (- (x->position xpos) (cp-x xpos))) 1)
				(snd-display #__line__ ";cp-x[~A] ~A: ~A ~A?" i xpos (x->position xpos) (cp-x xpos)))
			    (if (> (abs (- (y->position ypos) (cp-y ypos))) 1)
				(snd-display #__line__ ";cp-y[~A] ~A: ~A ~A?" i ypos (y->position ypos) (cp-y ypos)))
			    (if (fneq (position->x (cp-x xpos)) xpos)
				(snd-display #__line__ ";x->position cp-x ~A ~A" xpos (position->x (cp-x xpos))))
			    (if (fffneq (position->y (cp-y ypos)) ypos)
				(snd-display #__line__ ";y->position cp-y ~A ~A" ypos (position->y (cp-y ypos))))))))
		  (set! (left-sample obind 0) 1234)
		  (if (not (= 1234 (car (axis-info obind 0))))
		      (snd-display #__line__ ";axis-info[0 losamp at 1234]: ~A ~A?" (car (axis-info obind 0)) (left-sample obind 0)))
		  (set! axinfo (axis-info obind 0))
		  (set! x0 (list-ref axinfo 2))
		  (set! x1 (list-ref axinfo 4))
		  (if (> (abs (apply - (our-x->position obind x0))) 1) 
		      (snd-display #__line__ ";x0a->position: ~A?" (our-x->position obind x0)))
		  (if (> (abs (apply - (our-x->position obind x1))) 1) 
		      (snd-display #__line__ ";x1a->position: ~A?" (our-x->position obind x1)))
		  (if (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		      (snd-display #__line__ ";xmida->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		  (set! (y-bounds obind 0) (list -2.0 3.0))
		  (if (fneq (list-ref (axis-info obind 0) 7) -2.0)
		      (snd-display #__line__ ";axis-info[7 ymin -2.0]: ~A?" (list-ref (axis-info obind 0) 7)))
		  (if (fneq (list-ref (axis-info obind 0) 9) 3.0)
		      (snd-display #__line__ ";axis-info[9 ymax 3.0]: ~A?" (list-ref (axis-info obind 0) 9)))
		  
		  ))
	    (close-sound obind)))
	
	(let ((ind1 (open-sound "oboe.snd")))
	  (test-orig (lambda (snd) (src-sound 2.0 1.0 ind1)) (lambda (snd) (src-sound 0.5 1.0 ind1)) 'src-sound ind1)
	  (test-orig (lambda (snd) (src-channel 2.0)) (lambda (snd) (src-channel 0.5)) 'src-channel ind1)
	  (test-orig (lambda (snd) (scale-by 2.0 ind1)) (lambda (snd) (scale-by 0.5 ind1)) 'scale-by ind1)
	  (test-orig (lambda (snd) (scale-channel 2.0)) (lambda (snd) (scale-channel 0.5)) 'scale-channel ind1)
	  (test-orig (lambda (snd) (reverse-sound ind1)) (lambda (snd) (reverse-sound ind1)) 'reverse-sound ind1)
	  (test-orig (lambda (snd) (reverse-channel)) (lambda (snd) (reverse-channel)) 'reverse-channel ind1)
	  (test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0))) (lambda (snd) (env-sound '(0 1.0 1 0.5))) 'env-sound ind1)
	  (test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0 2 1.0))) (lambda (snd) (env-sound '(0 1.0 1 0.5 2 1.0))) 'env-sound ind1)
	  (test-orig (lambda (snd) (env-channel (make-env :envelope '(0 1.0 1 2.0) :length (frames))))
		     (lambda (snd) (env-channel (make-env :envelope '((0 1.0) (1 0.5)) :length (frames)))) 'env-channel ind1)
	  (test-orig (lambda (snd) (env-channel '(0 1.0 1 2.0)))
		     (lambda (snd) (env-channel '(0 1.0 1 0.5))) 'env-channel ind1)
	  (test-orig (lambda (snd) (env-channel (make-env :envelope '(0 2 1 2 2 0.5 3 0.5) :base 0 :length (frames))))
		     (lambda (snd) (env-channel (make-env :envelope '(0 0.5 1 0.5 2 2 3 2) :base 0 :length (frames)))) 'env-channel ind1)
	  (test-orig (lambda (snd) (map-channel (lambda (n) (* n 2)))) (lambda (snd) (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	  (test-orig (lambda (snd) (map-channel (lambda (n) (* n 2)) 1234)) (lambda (snd) (map-channel (lambda (n) (* n 0.5)) 1234)) 'map-channel ind1)
	  (test-orig (lambda (snd) (map-channel (lambda (n) (* n 2)) 12005 10)) (lambda (snd) (map-channel (lambda (n) (* n 0.5)) 12005 10)) 'map-channel ind1)
	  (test-orig (lambda (snd) (map-channel 
				    (let ((vect (make-vct 2 0.0))) 
				      (lambda (y) 
					(vct-set! vect 0 (* y 2))
					(vct-set! vect 1 (* y 2))
					vect))))
		     (lambda (snd) (map-channel
				    (let ((outp #f))
				      (lambda (y) 
					(if outp
					    (set! outp #f)
					    (set! outp (* y 0.5)))
					outp))))
		     'map-channel ind1)
	  (test-orig (lambda (snd) (map-chan (lambda (n) (* n 2)))) (lambda (snd) (map-chan (lambda (n) (* n 0.5)))) 'map-chan ind1)
	  (test-orig (lambda (snd) (pad-channel 1000 2000 ind1)) (lambda (snd) (delete-samples 1000 2000 ind1)) 'pad-channel ind1)
	  (test-orig (lambda (snd) (clm-channel (make-one-zero :a0 2.0 :a1 0.0)))
		     (lambda (snd) (clm-channel (make-one-zero :a0 0.5 :a1 0.0))) 'clm-channel ind1)
	  (test-orig (lambda (snd) (clm-channel (make-one-pole :a0 2.0 :b1 0.0)))
		     (lambda (snd) (clm-channel (make-one-pole :a0 0.5 :b1 0.0))) 'clm-channel ind1)
	  (test-orig (lambda (snd) (filter-sound (make-one-zero :a0 2.0 :a1 0.0) 2 ind1 0)) 
		     (lambda (snd) (filter-sound (make-one-zero :a0 0.5 :a1 0.0)) 2 ind1 0) 'filter-sound ind1)
	  
	  (let ((var (catch #t (lambda () (src-sound '(0 0 1 1))) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";src-sound env at 0: ~A" var)))
	  (let ((var (catch #t (lambda () (src-sound '(0 1 1 -1))) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";src-sound env through 0: ~A" var)))
	  
	  (scale-to 1.0 ind1)
	  (let ((v0 (make-vct 10))
		(v1 (channel->vct 12000 10 ind1 0)))
	    (vct-set! v0 0 1.0)
	    (array->file "fmv3.snd" v0 10 22050 1)
	    (copy-file "oboe.snd" "fmv4.snd")
	    (convolve-with "fmv3.snd" 1.0 ind1)
	    (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	    (let ((v2 (channel->vct 12000 10 ind1 0)))
	      (if (not (vfequal v1 v2))
		  (snd-display #__line__ ";~A (orig: 0) ~A ~A" 'convolve-with v1 v2))
	      (file->array "fmv5.snd" 0 12000 10 v2)
	      (if (not (vfequal v1 v2))
		  (snd-display #__line__ ";convolve-files: (orig: 0) ~A ~A" v1 v2)))
	    (delete-file "fmv3.snd")
	    (delete-file "fmv5.snd"))
	  (convolve-files "2.snd" "oboe.snd" 0.5 "fmv5.snd")
	  (if (or (fneq (cadr (mus-sound-maxamp "fmv5.snd")) 0.25)
		  (fneq (cadddr (mus-sound-maxamp "fmv5.snd")) 0.5))
	      (snd-display #__line__ ";convolve-files stereo: ~A" (mus-sound-maxamp "fmv5.snd")))
	  (delete-file "fmv5.snd")
	  (scale-to .25 ind1)
	  (set! (y-bounds ind1) '())
	  (if (not (equal? (y-bounds ind1) (list -.25 .25)))
	      (snd-display #__line__ ";y-bounds '(): ~A?" (y-bounds ind1)))
	  (revert-sound ind1)
	  
	  (scale-to 1.0 ind1)
	  (let ((v0 (make-vct 10))
		(v1 (channel->vct 12000 10 ind1 0)))
	    (vct-set! v0 5 1.0)
	    (array->file "fmv3.snd" v0 10 22050 1)
	    (convolve-with "fmv3.snd" 1.0 ind1)
	    (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	    (let ((v2 (channel->vct 12005 10 ind1 0)))
	      (if (not (vfequal v1 v2))
		  (snd-display #__line__ ";~A (orig: 2) ~A ~A" 'convolve-with v1 v2))
	      (file->array "fmv5.snd" 0 12005 10 v2)
	      (if (not (vfequal v1 v2))
		  (snd-display #__line__ ";convolve-files: (orig: 2) ~A ~A" v1 v2)))
	    (delete-file "fmv3.snd")
	    (delete-file "fmv4.snd")
	    (delete-file "fmv5.snd"))
	  
	  (revert-sound ind1)
	  (let ((old-val (selection-creates-region))
		(old-regions (regions)))
	    (set! (selection-creates-region) #f)
	    (select-all ind1)
	    (set! (selection-creates-region) old-val)
	    (if (not (equal? old-regions (regions)))
		(snd-display #__line__ ";selection-create-region: ~A -> ~A?" old-regions (regions))))
	  (convolve-selection-with "pistol.snd" (maxamp))
	  (let ((data (channel->vct 12000 10 ind1 0)))
	    (convolve-with "pistol.snd" (maxamp ind1 0 0) ind1 0 0)
	    (let ((new-data (channel->vct 12000 10 ind1 0)))
	      (if (not (vfequal data new-data))
		  (snd-display #__line__ ";convolve-selection-with: ~A ~A?" data new-data))))
	  (revert-sound ind1)
	  (make-selection 1000 2000 ind1)
	  (let ((ma (maxamp ind1)))
	    (convolve-selection-with "pistol.snd" ma)
	    (if (fneq (maxamp ind1) ma) (snd-display #__line__ ";convolve-selection-with 1000: ~A ~A?" ma (maxamp ind1))))
	  (make-selection 1000 2000 ind1)
	  (let ((id (make-region)))
	    (if (not (region? id))
		(snd-display #__line__ ";make-region argless: ~A" id))
	    (if (not (= (region-frames id 0) (selection-frames)))
		(snd-display #__line__ ";region/selection-frames: ~A ~A (~A)?" (region-frames id 0) (selection-frames) (region-frames id)))
	    (if (fneq (region-sample id 0) (sample 1000 ind1))
		(snd-display #__line__ ";region-sample from make-region: ~A ~A?" (region-sample id 0) (sample 1000 ind1))))
	  (close-sound ind1))
	(let* ((ind (open-sound "2.snd"))
	       (reg (make-region 0 100 ind #t)))
	  (if (not (equal? (region-home reg) (list "2.snd" 0 100))) 
	      (snd-display #__line__ ";make + region-home: ~A" (region-home reg)))
	  (if (not (= (region-chans reg) 2))
	      (snd-display #__line__ ";make-region chan #t: ~A" (region-chans reg)))
	  (close-sound ind))
	
	(let ((ind1 (open-sound "2.snd")))
	  (let ((v0 (channel->vct 12000 10 ind1 0))
		(v1 (channel->vct 12000 10 ind1 1)))
	    (swap-channels ind1)
	    (let ((v2 (channel->vct 12000 10 ind1 0))
		  (v3 (channel->vct 12000 10 ind1 1)))
	      (if (or (vequal v0 v2)
		      (vequal v1 v3))
		  (snd-display #__line__ ";swap-channels 0: no change! ~A ~A ~A ~A" v0 v2 v1 v3)))
	    (swap-channels ind1)
	    (let ((v2 (channel->vct 12000 10 ind1 0))
		  (v3 (channel->vct 12000 10 ind1 1)))
	      (if (or (not (vequal v0 v2))
		      (not (vequal v1 v3)))
		  (snd-display #__line__ ";swap-channels 1: ~A ~A ~A ~A" v0 v2 v1 v3)))
	    ;; as long as we're here...
	    (set! (cursor ind1 0) 100)
	    (set! (cursor ind1 1) 200)
	    (if (or (not (= (cursor ind1 0) 100)) 
		    (not (= (cursor ind1 1) 200)))
		(snd-display #__line__ ";cursor: ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	    (set! (sync ind1) 1)
	    (scale-by (list .5 .25) ind1)
	    (scale-by (vct 2.0 4.0) ind1)
	    (revert-sound ind1)
	    (let ((amps (maxamp ind1 #t)))
	      (swap-channels ind1 0 ind1)
	      (let ((newamps (maxamp ind1 #t)))
		(if (or (fneq (car amps) (cadr newamps))
			(fneq (cadr amps) (car newamps)))
		    (snd-display #__line__ ";swap-channels with cp def: ~A ~A" amps newamps)))
	      (swap-channels ind1 1)
	      (let ((newamps (maxamp ind1 #t)))
		(if (or (fneq (car amps) (car newamps))
			(fneq (cadr amps) (cadr newamps)))
		    (snd-display #__line__ ";swap-channels with cp def 0: ~A ~A" amps newamps))))
	    (close-sound ind1)))
	
	(let ((ind1 (open-sound "oboe.snd"))
	      (ind2 (open-sound "2.snd")))
	  (let ((ups1 (count-matches (lambda (n) (> n .1)) 0 ind1 0))
		(ups2 (let ((count 0))
			(scan-chan (lambda (n)
				     (if (> n .1)
					 (set! count (+ count 1)))
				     #f)
				   0 (frames ind1) ind1 0)
			count)))
	    (if (not (= ups1 ups2))
		(snd-display #__line__ ";scan-chan: ~A ~A?" ups1 ups2))
	    (set! ups1 (count-matches (lambda (n) (> n .03)) 0 ind2 0))
	    (set! ups2 (count-matches (lambda (n) (> n .03)) 0 ind2 1))
	    (let ((ups3 (let ((count 0))
			  (scan-chan (lambda (n)
				       (if (> n .03)
					   (set! count (+ count 1)))
				       #f)
				     0 (frames ind2) ind2 0)
			  count))
		  (ups4 (let ((count 0))
			  (scan-chan (lambda (n)
				       (if (> n .03)
					   (set! count (+ count 1)))
				       #f)
				     0 (frames ind2) ind2 1)
			  count)))
	      (if (not (= ups1 ups3))
		  (snd-display #__line__ ";2[0] scan-chan: ~A ~A?" ups1 ups3))
	      (if (not (= ups2 ups4))
		  (snd-display #__line__ ";2[1] scan-chan: ~A ~A?" ups2 ups4))))
	  (close-sound ind1)
	  (close-sound ind2))
	
	(let* ((ind1 (open-sound "oboe.snd"))
	       (len (frames ind1))
	       (ctr 0))
	  (map-chan (lambda (n)
		      (if (= ctr 1) (set! ctr 0) (set! ctr 1))
		      (if (= ctr 0)
			  (* n 2.0)
			  #f))
		    0 (frames ind1) "ignore: cut 2" ind1 0)
	  (if (> (frames ind1) (+ (* len 2) 1))
	      (snd-display #__line__ ";map-chan cut: ~A ~A?" len (frames ind1)))
	  (revert-sound ind1)
	  (set! ctr 0)
	  (map-chan (lambda (n)
		      (set! ctr (+ 1 ctr))
		      (if (> ctr 3)
			  #t
			  n))
		    0 (frames ind1) "ignore: cut none" ind1 0)
	  (if (> ctr 4)
	      (snd-display #__line__ ";map-chan no-edit count: ~A?" ctr))
	  (revert-sound ind1)
	  (let ((v1 (make-vct 2)))
	    (map-chan (lambda (n)
			(vct-set! v1 0 n)
			(vct-set! v1 1 (* n 3))
			v1)
		      0 (frames ind1) "ignore: cut 2" ind1 0))
	  (if (> (abs (- (frames ind1) (* len 2))) 3)
	      (snd-display #__line__ ";map-chan double: ~A ~A?" len (frames ind1)))
	  (revert-sound ind1)
	  (let ((otime (maxamp-position ind1)))
	    (set! (sample 1234) .9)
	    (let* ((ntime (maxamp-position ind1))
		   (nval (maxamp ind1))
		   (npos (edit-position ind1 0)))
	      (if (not (= ntime 1234)) (snd-display #__line__ ";maxamp-position 1234: ~A" ntime))
	      (let ((ootime (maxamp-position ind1 0 0)))
		(if (not (= ootime otime)) (snd-display #__line__ ";maxamp-position edpos 0: ~A ~A" otime ootime)))
	      (let ((nntime (maxamp-position ind1 0 npos)))
		(if (not (= nntime ntime)) (snd-display #__line__ ";maxamp-position edpos ~D: ~A ~A" npos ntime nntime)))
	      (if (fneq nval .9) (snd-display #__line__ ";maxamp .9: ~A" nval)))
	    (set! (sample 1234) 0.0)
	    (env-channel '(0 0 1 1))
	    (if (not (= (maxamp-position) 35062)) (snd-display #__line__ ";env-channel maxamp-position: ~A" (maxamp-position)))
	    (let ((ootime (maxamp-position ind1 0 0)))
	      (if (not (= ootime otime)) (snd-display #__line__ ";maxamp-position edpos 0(1): ~A ~A" otime ootime)))
	    (let ((nntime (maxamp-position ind1 0 1)))
	      (if (not (= nntime 1234)) (snd-display #__line__ ";maxamp-position edpos 1(1): ~A ~A" 1234 nntime)))
	    (let ((nntime (maxamp-position ind1 0 current-edit-position)))
	      (if (not (= nntime 35062)) (snd-display #__line__ ";maxamp-position edpos current: ~A ~A" 35062 nntime))))
	  (revert-sound ind1)
	  (make-selection 24000 25000)
	  (if (not (= (selection-maxamp-position) 971))
	      (snd-display #__line__ ";selection maxamp position: ~A" (selection-maxamp-position)))
	  (let ((reg (make-region 24000 25000)))
	    (if (not (= (region-maxamp-position reg) 971))
		(snd-display #__line__ ";region maxamp position: ~A" (region-maxamp-position))))
	  (close-sound ind1))
	(let* ((ind1 (open-sound "oboe.snd")))
	  (test-edpos maxamp 'maxamp (lambda () (scale-by 2.0 ind1 0)) ind1)
	  (test-edpos frames 'frames (lambda () (src-sound 2.0 1.0 ind1 0)) ind1)
	  (test-edpos 
	   (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) (count-matches (lambda (n1) (> n1 .1)) 0 snd chn edpos)) 
	   'count-matches
	   (lambda () (scale-by 2.0 ind1 0)) 
	   ind1)
	  (test-edpos 
	   (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) (cadr (find-channel (lambda (n2) (> n2 .1)) 0 snd chn edpos)))
	   'find
	   (lambda () (delete-samples 0 100 ind1 0))
	   ind1)
	  (test-edpos 
	   (lambda* ((snd 0) (chn 0) (edpos current-edit-position)) 
		    (let ((samp 0)) 
		      (scan-chan (lambda (n3) 
				   (or (> n3 .1) 
				       (begin 
					 (set! samp (+ 1 samp)) 
					 #f)))
				 0 (frames snd chn) snd chn edpos)
		      samp))
	   'scan-chan
	   (lambda () (delete-samples 0 100 ind1 0))
	   ind1)
	  
	  (src-sound 2.0 1.0 ind1 0)
	  (undo 1 ind1 0)
	  
	  (delete-samples 0 10000 ind1 0)
	  (save-sound-as "fmv.snd" ind1 :edit-position 0)
	  (save-sound-as "fmv1.snd" ind1 :edit-position (lambda (snd chn) 1))
	  (let ((var (catch #t (lambda () (save-sound-as "fmv2.snd" ind1 :channel 1234)) (lambda args args))))
	    (if (not (eq? (car var) 'no-such-channel))
		(snd-display #__line__ ";save-sound-as bad chan: ~A" var)))
	  (if (not (= (mus-sound-frames "fmv.snd") (frames ind1 0 0)))
	      (snd-display #__line__ ";save-sound-as (edpos): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 0)))
	  (if (not (= (mus-sound-frames "fmv1.snd") (frames ind1 0 1)))
	      (snd-display #__line__ ";save-sound-as (edpos 1): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 1)))
	  (if (= (mus-sound-frames "fmv.snd") (frames ind1 0 1))
	      (snd-display #__line__ ";save-sound-as (edpos 1)(2): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 1)))
	  (let ((ind2 (open-sound "fmv.snd"))
		(ind3 (open-sound "fmv1.snd")))
	    (if (not (vequal (channel->vct 12000 10 ind1 0 0) (channel->vct 12000 10 ind2 0)))
		(snd-display #__line__ ";save-sound-as (edpos 3): ~A ~A?" (channel->vct 12000 10 ind1 0 0) (channel->vct 12000 10 ind2 0)))
	    (if (not (vequal (channel->vct 12000 10 ind1 0 1) (channel->vct 12000 10 ind3 0)))
		(snd-display #__line__ ";save-sound-as (edpos 4): ~A ~A?" (channel->vct 12000 10 ind1 0 1) (channel->vct 12000 10 ind3 0)))
	    (if (vequal (channel->vct 12000 10 ind2 0) (channel->vct 12000 10 ind3 0))
		(snd-display #__line__ ";save-sound-as (edpos 5): ~A ~A?" (channel->vct 12000 10 ind2 0) (channel->vct 12000 10 ind3 0)))
	    (select-sound ind3)
	    (set! (comment) "hiho")
	    (if (not (string=? (comment) "hiho")) (snd-display #__line__ ";set! comment no index: ~A" (comment)))
	    (close-sound ind2)
	    (close-sound ind3))
	  (delete-file "fmv.snd")
	  (delete-file "fmv1.snd")
	  
	  (test-edpos-1 (lambda (snd pos) (reverse-sound snd 0 pos)) 'reverse-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (env-sound '(0 0 1 1 2 0) 0 20000 1.0 snd 0 pos)) 'env-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (src-sound 0.5 1.0 snd 0 pos)) 'src-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (filter-sound (make-fir-filter 6 (list->vct '(.1 .2 .3 .3 .2 .1))) 6 snd 0 pos)) 'filter-sound ind1)
	  (test-edpos-1 (lambda (snd pos) (convolve-with "pistol.snd" .5 snd 0 pos)) 'convolve-with ind1)
	  
	  (let ((ind (new-sound "fmv.snd"))
		(v (make-vct 2000))
		(ctr 0))
	    (vct-map! v (lambda ()
			  (let ((val (sin (* ctr 2.0 (/ pi 10.0)))))
			    (set! ctr (+ 1 ctr))
			    val)))
	    (vct->channel v 0 2000 ind 0)
	    (filter-sound '(0 0 .09 0 .1 1 .11 0 1 0) 1024)
	    (if (> (maxamp) .025) (snd-display #__line__ ";filter-sound maxamp 1: ~A" (maxamp)))
	    (undo)
	    (filter-sound '(0 0 .19 0 .2 1 .21 0 1 0) 1024)  
	    (if (< (maxamp) .9) (snd-display #__line__ ";filter-sound maxamp 2: ~A" (maxamp)))
	    (undo)
	    (filter-sound '(0 0 .29 0 .3 1 .31 0 1 0) 1024)  
	    (if (> (maxamp) .02) (snd-display #__line__ ";filter-sound maxamp 3: ~A" (maxamp)))
	    
	    (set! (show-sonogram-cursor) #t) 
	    (set! (cursor-follows-play) #t) 
	    (if (not (cursor-follows-play)) (snd-display #__line__ ";cursor-follows-play set to #t: ~A" (cursor-follows-play)))
	    
	    (set! (transform-graph-type) graph-as-sonogram) 
	    (play :wait #t)
	    (set! (transform-graph?) #t) 
	    
	    (close-sound ind))
	  (close-sound ind1))
	
	(let* ((ind (open-sound "oboe.snd"))
	       (mx (maxamp ind 0))
	       (e0 (channel-amp-envs ind 0)))
	  
	  (define (peak-env-equal? name index e diff)
	    (let* ((reader (make-sampler 0 index 0))
		   (e-size (vct-length (car e)))
		   (samps-per-bin (ceiling (/ (frames index) e-size)))
		   (mins (car e))
		   (maxs (cadr e))
		   (max-diff 0.0)
		   (happy #t))
	      (do ((e-bin 0)
		   (samp 0 (+ 1 samp))
		   (mx -10.0)
		   (mn 10.0))
		  ((or (not happy) (= e-bin e-size))
		   happy)
		(if (>= samp (floor samps-per-bin))
		    (let ((mxdiff (abs (- mx (vct-ref maxs e-bin))))
			  (mndiff (abs (- mn (vct-ref mins e-bin)))))
		      (if (> mxdiff max-diff)
			  (set! max-diff mxdiff))
		      (if (> mndiff max-diff)
			  (set! max-diff mndiff))
		      (if (or (> mxdiff diff)
			      (> mndiff diff))
			  (begin
			    (snd-display #__line__ ";~A: peak-env-equal? [bin ~D of ~D]: (~,4F to ~,4F), diff: ~,5F" 
					 name
					 e-bin e-size
					 mn mx
					 (max mxdiff mndiff))
			    (set! happy #f)))
		      (set! samp 0)
		      (set! mx -10.0)
		      (set! mn 10.0)
		      (set! e-bin (+ e-bin 1))))
		(let ((val (next-sample reader)))
		  (if (< val mn)
		      (set! mn val))
		  (if (> val mx)
		      (set! mx val))))))
	  
	  (if (null? e0)
	      (snd-display #__line__ ";no amp env data")
	      (let ((mx1 (vct-peak (car e0)))
		    (mx2 (vct-peak (cadr e0))))
		(if (fneq mx (max mx1 mx2))
		    (snd-display #__line__ ";amp env max: ~A ~A ~A" mx mx1 mx2))
		(peak-env-equal? "straight peak" ind e0 .0001)
		(scale-by 3.0)
		(let* ((e1 (channel-amp-envs ind 0 1))
		       (mx3 (vct-peak (car e1)))
		       (mx4 (vct-peak (cadr e1))))
		  (if (or (fneq (* 3.0 mx1) mx3)
			  (fneq (* 3.0 mx2) mx4))
		      (snd-display #__line__ ";3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		  (peak-env-equal? "scaled peak" ind e1 .0001))
		(if (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display #__line__ ";maxamp after scale: ~A ~A" mx (maxamp ind 0)))
		(undo)
		(set! (selection-member? #t) #f)
		(set! (selection-member? ind 0) #t)
		(set! (selection-position ind 0) 20000)
		(set! (selection-frames ind 0) 12000)
		(scale-selection-by 3.0)
		(let* ((e1 (channel-amp-envs ind 0 1))
		       (mx3 (vct-peak (car e1)))
		       (mx4 (vct-peak (cadr e1))))
		  (if (or (fneq (* 3.0 mx1) mx3)
			  (fneq (* 3.0 mx2) mx4))
		      (snd-display #__line__ ";selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		  (if (fneq (maxamp ind 0) (* 3 mx)) 
		      (snd-display #__line__ ";maxamp after selection scale: ~A ~A" mx (maxamp ind 0)))
		  (peak-env-equal? "selection peak" ind e1 .0001))
		(map-chan abs 0 #f "test" ind 0)
		(let* ((e1 (channel-amp-envs ind 0 2))
		       (mx3 (vct-peak (car e1)))
		       (mx4 (vct-peak (cadr e1))))
		  (if (fneq (* 3.0 mx2) mx4)
		      (snd-display #__line__ ";abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		  (if (fneq (maxamp ind 0) (* 3 mx)) 
		      (snd-display #__line__ ";maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		  (if (ffneq mx3 0.03)
		      (snd-display #__line__ ";abs max: ~A ~A" mx3 mx4))
		  (peak-env-equal? "map-chan peak" ind e1 .0001))
		(delete-samples 10000 5000)
		(let* ((e1 (channel-amp-envs ind 0))
		       (mx3 (vct-peak (car e1)))
		       (mx4 (vct-peak (cadr e1))))
		  (if (fneq (* 3.0 mx2) mx4)
		      (snd-display #__line__ ";abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		  (if (fneq (maxamp ind 0) (* 3 mx)) 
		      (snd-display #__line__ ";maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		  (if (ffneq mx3 0.03)
		      (snd-display #__line__ ";abs max: ~A ~A" mx3 mx4))
		  (peak-env-equal? "delete peak" ind e1 .0001))
		(scale-selection-by -.333)
		(let* ((e1 (channel-amp-envs ind 0 4))
		       (mx3 (vct-peak (car e1))))
		  (if (fneq (maxamp ind 0) mx)
		      (snd-display #__line__ ";maxamp after minus abs selection scale: ~A ~A" mx (maxamp ind 0)))
		  (if (fneq (maxamp ind 0) mx3)
		      (snd-display #__line__ ";mx3 maxamp after minus abs selection scale: ~A ~A" mx mx3))
		  (peak-env-equal? "scale-selection peak" ind e1 .0001))
		
		(revert-sound ind)
		(ramp-channel 0.0 1.0)
		(peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .001)
		(undo)
		(env-channel '(0 0 1 1 2 0))
		(peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .002)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length (frames)))
		(peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .002)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) 0.5 :length (frames)))
		(peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .001)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length (frames)))
		(peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .001)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 0.0 :length (frames)))
		(peak-env-equal? "env-channel base 0.0 peak" ind (channel-amp-envs ind 0 1) .001)
		(undo)
		(xramp-channel 0.0 1.0 32.0)
		(peak-env-equal? "xramp 32.0 peak" ind (channel-amp-envs ind 0 1) .008)
		(undo)
		(xramp-channel 0.0 1.0 .032)
		(peak-env-equal? "xramp .032 peak" ind (channel-amp-envs ind 0 1) .004)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length (frames)))
		(peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .003)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) :base .10 :length (frames)))
		(peak-env-equal? "env-channel base .1 peak" ind (channel-amp-envs ind 0 1) .003)
		(undo)
		(ptree-channel (lambda (y) (* y 2)) 0 (frames) ind 0 #f #t)
		(peak-env-equal? "ptree-channel peak" ind (channel-amp-envs ind 0 1) .0001)
		(undo)
		(ramp-channel 0.0 1.0)
		(ptree-channel (lambda (y) (* y 2)) 0 (frames) ind 0 #f #t)
		(peak-env-equal? "ptree+ramp peak" ind (channel-amp-envs ind 0 2) .01)
		(undo 2)
		(xramp-channel 0.0 1.0 3.0)
		(ptree-channel (lambda (y) (* y 2)) 0 (frames) ind 0 #f #t)
		(peak-env-equal? "ptree+xramp peak" ind (channel-amp-envs ind 0 2) .004)
		(undo 2)
		(ptree-channel (lambda (y data forward)
				 (* y (vct-ref data 0)))
			       0 (frames) ind 0 #f #t
			       (lambda (pos dur)
				 (vct 0.5)))
		(peak-env-equal? "ptree+closure peak" ind (channel-amp-envs ind 0 1) .009)
		(undo)
		(ramp-channel 0.0 1.0)
		(ptree-channel (lambda (y data forward)
				 (* y (vct-ref data 0)))
			       0 (frames) ind 0 #f #t
			       (lambda (pos dur)
				 (vct 0.5)))
		(peak-env-equal? "ptree+ramp+closure peak" ind (channel-amp-envs ind 0 2) .01)
		(undo 2)
		(xramp-channel 0.0 1.0 3.0)
		(ptree-channel (lambda (y data forward)
				 (* y (vct-ref data 0)))
			       0 (frames) ind 0 #f #t
			       (lambda (pos dur)
				 (vct 0.5)))
		(peak-env-equal? "ptree+xramp+closure peak" ind (channel-amp-envs ind 0 2) .001)
		(undo 2)
		(insert-samples 1000 5000 (make-vct 5000 .5))
		(peak-env-equal? "insert-samples peak" ind (channel-amp-envs ind 0 1) .0001)
		(undo)
		(set! (samples 500 100) (make-vct 100 .1))
		(peak-env-equal? "set-samples peak" ind (channel-amp-envs ind 0) .0001)
		(undo)
		
		(revert-sound ind)
		(ramp-channel 0.0 1.0)
		(ramp-channel 1.0 0.0)
		(peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
		
		(revert-sound ind)
		(env-channel '(0 0 1 1))
		(env-channel '(0 0 1 1 2 0))
		(peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
		
		(revert-sound ind)
		(env-channel '(0 0 1 1))
		(env-channel '(0 0 1 1 2 0))
		(ptree-channel (lambda (y) (* y 2.0)))
		(peak-env-equal? "ptree-ramp20 peak" ind (channel-amp-envs ind 0 3) .0001)
		
		(revert-sound ind)
		(ramp-channel 0.0 1.0 12000 5000)
		(peak-env-equal? "ramp-channel peak" ind (channel-amp-envs ind 0 1) .002)
		(undo)
		(env-channel '(0 0 1 1 2 0) 12000 5000)
		(peak-env-equal? "env-channel peak" ind (channel-amp-envs ind 0 1) .003)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :length 5000) 12000 5000)
		(peak-env-equal? "scaled env-channel peak" ind (channel-amp-envs ind 0 1) .004)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) 0.5 :length 5000) 12000 5000)
		(peak-env-equal? "scaled nokey env-channel peak" ind (channel-amp-envs ind 0 1) .004)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 0) :scaler 0.5 :offset 0.5 :length 5000) 12000 5000)
		(peak-env-equal? "scaled and offset env-channel peak" ind (channel-amp-envs ind 0 1) .002)
		(undo)
		(xramp-channel 0.0 1.0 32.0 2000 1000)
		(peak-env-equal? "xramp 32.0 peak (1)" ind (channel-amp-envs ind 0 1) .009)
		(undo)
		(xramp-channel 0.0 1.0 .032 2000 1000)
		(peak-env-equal? "xramp .032 peak (1)" ind (channel-amp-envs ind 0 1) .009)
		(undo)
		(env-channel (make-env '(0 0 1 1 2 .5 3 0) :base 10.0 :length 5000) 12000 5000)
		(peak-env-equal? "env-channel base 10.0 peak" ind (channel-amp-envs ind 0 1) .1)
		;; this can be way off because the envelope is not very closely sampled in this case
		(undo)
		(ptree-channel (lambda (y) (* y 2)) 2000 1000 ind 0 #f #t)
		(peak-env-equal? "ptree-channel peak" ind (channel-amp-envs ind 0 1) .0001)
		(undo)
		(ramp-channel 0.0 1.0)
		(ptree-channel (lambda (y) (* y 2)) 2000 1000 ind 0 #f #t)
		(peak-env-equal? "ptree+ramp peak" ind (channel-amp-envs ind 0 2) .001)
		(undo 2)
		(xramp-channel 0.0 1.0 3.0)
		(ptree-channel (lambda (y) (* y 2)) 2000 1000 ind 0 #f #t)
		(peak-env-equal? "ptree+xramp peak" ind (channel-amp-envs ind 0 2) .001)
		(undo 2)
		(ptree-channel (lambda (y data forward)
				 (* y (vct-ref data 0)))
			       2000 1000 ind 0 #f #t
			       (lambda (pos dur)
				 (vct 0.5)))
		(peak-env-equal? "ptree+closure peak" ind (channel-amp-envs ind 0 1) .0001)
		(undo)
		(ramp-channel 0.0 1.0)
		(ptree-channel (lambda (y data forward)
				 (* y (vct-ref data 0)))
			       2000 1000 ind 0 #f #t
			       (lambda (pos dur)
				 (vct 0.5)))
		(peak-env-equal? "ptree+ramp+closure peak" ind (channel-amp-envs ind 0 2) .001)
		
		(revert-sound ind)
		(ramp-channel 0.0 1.0)
		(ramp-channel 1.0 0.0 2000 1000)
		(peak-env-equal? "ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
		
		(revert-sound ind)
		(env-channel '(0 0 1 1))
		(env-channel '(0 0 1 1 2 0) 2000 1000)
		(peak-env-equal? "env ramp2 peak" ind (channel-amp-envs ind 0 2) .002)
		
		(revert-sound ind)
		(env-channel '(0 0 1 1))
		(env-channel '(0 0 1 1 2 0))
		(ptree-channel (lambda (y) (* y 2.0)) 2000 1000)
		(peak-env-equal? "ptree-ramp21 peak" ind (channel-amp-envs ind 0 3) .002)
		
		(revert-sound ind)
		(env-channel '(0 0 1 1))
		(env-channel '(0 0 1 1 2 0))
		(env-channel '(0 0 1 1) 12000 5000)
		(peak-env-equal? "ptree-ramp3 peak" ind (channel-amp-envs ind 0 3) .01)
		
		(revert-sound ind)
		
		))
	  (close-sound ind))
	
	;; ptree-channel init-func state cases
	(let ((ind (new-sound "test.snd" :size 10 :comment "ptree-channel state tests")))
	  (set! (sample 5) 1.0)
	  (set! (sample 4) -0.5)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val float) (dir boolean))
			   (* y val))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   0.5)
			 "ptree channel float arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.250 0.500 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with float state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val int) (dir boolean))
			   (* y val))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   3)
			 "ptree channel int arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -1.500 3.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with int state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val boolean) (dir boolean))
			   (if val y (* y 100)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   #t)
			 "ptree channel boolean arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with boolean state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val char) (dir boolean))
			   (if (char=? val #\f) y (* 10 y)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   #\f)
			 "ptree channel char arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with char state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val string) (dir boolean))
			   (if (string=? val "hiho") y (* 10 y)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   "hiho")
			 "ptree channel string arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with string state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val vct) (dir boolean))
			   (* y (vct-ref val 0)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   (make-vct 1 2.0))
			 "ptree channel vct arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -1.000 2.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with vct state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val sound-data) (dir boolean))
			   (* y (sound-data-ref val 0 0)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   (let ((sd (make-sound-data 1 2)))
			     (sound-data-set! sd 0 0 4.0)
			     sd))
			 "ptree channel sound-data arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -2.000 4.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with sound-data state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val symbol) (dir boolean))
			   (if (eq? val 'hiho) y (* y 100)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   'hiho)
			 "ptree channel symbol arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with symbol state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val keyword) (dir boolean))
			   (if (eq? val :hiho) y (* y 100)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   :hiho)
			 "ptree channel keyword arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with keyword state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  ;; this works, but can't currently be optimized:
	  ;;  (ptree-channel (lambda (y val dir)
	  ;;		       (declare (y real) (val list) (dir boolean))
	  ;;		       (* y (car val)))
	  ;;		     0 10 ind 0 -1 #t
	  ;;		     (lambda (beg dur)
	  ;;		       (list 2.0 100.0)))
	  ;;  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -1.000 2.000 0.000 0.000 0.000 0.000)))
	  ;;      (snd-display #__line__ ";ptree-channel with list state: ~A" (channel->vct 0 10 ind 0)))
	  ;;  (undo)
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val sampler) (dir boolean))
			   (let ((n (read-sample val)))
			     (* y n)))
			 0 10 ind 0 -1 #f
			 (lambda (beg dur)
			   (make-sampler beg ind 0 1 2)) ; beg here is vital! as is "2" for edpos
			 "ptree channel sampler arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 0.250 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with reader state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  
	  ;; this can't work because it needs access to previous samples (the generator has internal state)
					;	  (ptree-channel (lambda (y val dir)
					;			   (declare (y real) (val clm) (dir boolean))
					;			   (one-zero val y))
					;			 0 10 ind 0 -1 #t
					;			 (lambda (beg dur)
					;			   (make-one-zero .5 .5))
					;			 "ptree channel clm arg")
					;	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.250 0.250 0.500 0.000 0.000 0.000)))
					;	      (snd-display #__line__ ";ptree-channel with clm state: ~A from ~A"
					;			   (channel->vct 0 10 ind 0) 
					;			   (channel->vct 0 10 ind 0 (- (edit-position ind 0) 1))))
					;	  (undo)
	  (let ((mx (mix-vct (vct .2 .3 .4) 2 ind 0 #t)))
	    (ptree-channel (lambda (y val dir)
			     (declare (y real) (val mix-sampler) (dir boolean))
			     (let ((n (read-mix-sample val)))
			       (+ y n)))
			   0 10 ind 0 -1 #f
			   (lambda (beg dur)
			     (make-mix-sampler mx beg))
			   "ptree channel mix-sampler arg"))
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.200 0.300 0.600 0.300 -0.100 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with mix reader state: ~A" (channel->vct 0 10 ind 0)))
	  (set! (edit-position ind 0) 2)
	  
	  ;; now check error handling...
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val vct) (dir boolean))
			   (* y 2.0))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   (make-vct 1 2.0))
			 "ptree channel vct unrefd arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -1.000 2.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with unrefd vct state: ~A" (channel->vct 0 10 ind 0)))
	  (undo)
	  
	  ;; this does print an error message, but trying to halt execution leads to a segfault
	  ;;	  (let ((tag (catch #t
	  ;;			    (lambda ()
	  ;;			      (ptree-channel (lambda (y val dir)
	  ;;					       (declare (y real) (val float-vector) (dir boolean))
	  ;;					       (* y (vector-ref val 0)))
	  ;;					     0 10 ind 0 -1 #t
	  ;;					     (lambda (beg dur)
	  ;;					       (make-vector 1 2.0))
	  ;;					     "ptree channel vector arg"))
	  ;;			    (lambda args (car args)))))
	  ;;	    (if (not (eq? tag 'snd-error))
	  ;;		(snd-display #__line__ ";ptree-channel vector arg: ~A" tag)))
	  
	  ;; now check 3 ptrees with different types
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val float) (dir boolean))
			   (* y val))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   0.5)
			 "ptree channel float arg")
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val int) (dir boolean))
			   (* y val))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   2)
			 "ptree channel int arg")
	  (ptree-channel (lambda (y val dir)
			   (declare (y real) (val boolean) (dir boolean))
			   (if val y (* y 100)))
			 0 10 ind 0 -1 #t
			 (lambda (beg dur)
			   #t)
			 "ptree channel boolean arg")
	  (if (not (vequal (channel->vct 0 10 ind 0) (vct 0.000 0.000 0.000 0.000 -0.500 1.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";ptree-channel with 3 states: ~A" (channel->vct 0 10 ind 0)))
	  
	  (close-sound ind)
	  (if (file-exists? "test.snd") (delete-file "test.snd")))
	
	(let ((ind (new-sound "test.snd")))
	  (map-chan (lambda (y) 1.0) 0 50000)
	  (ramp-channel 0.5 1.0 1000 4000)
	  (let* ((peaks (channel-amp-envs ind 0))
		 (mx (cadr peaks))
		 (mn (car peaks)))
	    (call-with-current-continuation
	     (lambda (break)
	       (if (not (continuation? break)) (snd-display #__line__ ";not a continuation: ~A" break))
	       (if (continuation? abs) (snd-display #__line__ ";abs is a continuation?"))
	       (if (continuation? open-sound) (snd-display #__line__ ";open-sound is a continuation?"))
	       (if (continuation? 32) (snd-display #__line__ ";32 is a continuation?"))
	       (if (continuation? (let ((hi 1)) (lambda () hi))) (snd-display #__line__ ";closure is a continuation?"))
	       (do ((i 0 (+ 1 i)))
		   ((= i (- (vct-length mn) 4)))
		 (if (< (vct-ref mn i) 0.5) (begin (snd-display #__line__ ";peak min: ~A ~A" (vct-ref mn i) i) (break #f)))
		 (if (< (vct-ref mx i) 0.5) (begin (snd-display #__line__ ";peak max: ~A ~A" (vct-ref mx i) i) (break #f)))))))
	  (undo 2)
	  (map-chan (lambda (y) -1.0) 0 50000)
	  (ramp-channel 0.5 1.0 1000 4000)
	  (let* ((peaks (channel-amp-envs ind 0))
		 (mx (cadr peaks))
		 (mn (car peaks))
		 (happy #t))
	    (do ((i 0 (+ 1 i)))
		((or (not happy) 
		     (= i (- (vct-length mn) 4))))
	      (if (> (vct-ref mn i) -0.5) (begin (snd-display #__line__ ";1 peak min: ~A ~A" (vct-ref mn i) i) (set! happy #f)))
	      (if (> (vct-ref mx i) -0.5) (begin (snd-display #__line__ ";1 peak max: ~A ~A" (vct-ref mx i) i) (set! happy #f)))))
	  (close-sound ind))
	
	(let ((index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "channel tests")))
	  (define (test-channel-func func val-func init-val)
	    (let* ((len (frames index))
		   (chns (chans index))
		   (val #f))
	      (set! g-init-val init-val)
	      (do ((k 0 (+ 1 k)))
		  ((= k 2))
		(set! val (val-func len))
		(set! (sync index) k)
		(do ((i 0 (+ 1 i)))
		    ((= i chns))
		  (map-channel (lambda (n) 0.0) 0 len index i)
		  (if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index i)
		      (snd-display #__line__ ";init scan: ~A?" (scan-channel (lambda (n) (> (abs n) 0.001))))))
		;; now it's cleared
		(do ((i 0 (+ 1 i)))
		    ((= i chns))
		  (map-channel (lambda (n) g-init-val) 0 len index i)
		  (func 0 len index i)
		  (do ((j 0 (+ 1 j)))
		      ((= j chns))
		    (let ((vi (channel->vct 0 len index j)))
		      (if (= j i)
			  (if (not (vequal vi val))
			      (snd-display #__line__ ";chan func: ~A ~A" vi val))
			  (if (scan-channel (lambda (n) (> (abs n) .001)) 0 len index j)
			      (snd-display #__line__ ";chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		  (map-channel (lambda (n) 0.0) 0 len index i))
		(do ((i 0 (+ 1 i)))
		    ((= i chns))
		  (map-channel (lambda (n) g-init-val) 0 len index i)
		  (let ((ed (edit-position index i)))
		    (map-channel (lambda (n) (+ g-init-val 1.0)) 0 len index i)
		    (func 0 len index i ed)
		    (do ((j 0 (+ 1 j)))
			((= j chns))
		      (let ((vi (channel->vct 0 len index j)))
			(if (= j i)
			    (if (not (vequal vi val))
				(snd-display #__line__ ";ed chan func: ~A ~A" vi val))
			    (if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
				(snd-display #__line__ ";ed chan func leaks? ~A ~A ~A: ~A" i j ed (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		    (map-channel (lambda (n) 0.0) 0 len index i)))
		(let* ((beg (floor (/ len 3)))
		       (dur beg)
		       (nv (val-func dur)))
		  (vct-fill! val 0.0)
		  (do ((i beg (+ 1 i))
		       (j 0 (+ 1 j)))
		      ((= j dur))
		    (vct-set! val i (vct-ref nv j)))
		  (do ((i 0 (+ 1 i)))
		      ((= i chns))
		    (map-channel (lambda (n) g-init-val) beg dur index i)
		    (func beg dur index i)
		    (add-mark beg index i)
		    (do ((j 0 (+ 1 j)))
			((= j chns))
		      (let ((vi (channel->vct 0 len index j)))
			(if (= j i)
			    (if (not (vequal vi val))
				(snd-display #__line__ ";chan func n: ~A ~A" vi val))
			    (if (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j)
				(snd-display #__line__ ";dur chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (> (abs n) 0.001)) 0 len index j))))))
		    (map-channel (lambda (n) 0.0) 0 len index i))))))
	  
	  (insert-silence 0 10 index 0)
	  (insert-silence 0 10 index 1)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (clm-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			     (lambda (dur)
			       (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				     (v (make-vct dur)))
				 (do ((i 0 (+ 1 i)))
				     ((= i dur))
				   (vct-set! v i (env e)))
				 v))
			     0.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (clm-channel (make-oscil :frequency 0.0 :initial-phase (/ pi 2)) beg dur index chan edpos))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (vct-fill! v 1.0)
				 v))
			     0.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (scale-channel 0.5 beg dur index chan edpos))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (vct-fill! v 0.5)
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos))
			     (lambda (dur)
			       (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				     (v (make-vct dur)))
				 (do ((i 0 (+ 1 i)))
				     ((= i dur))
				   (vct-set! v i (env e)))
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (env-channel '(0 0 1 1) beg dur index chan edpos))
			     (lambda (dur)
			       (let ((e (make-env :envelope '(0 0 1 1) :length dur))
				     (v (make-vct dur)))
				 (do ((i 0 (+ 1 i)))
				     ((= i dur))
				   (vct-set! v i (env e)))
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (let ((v (make-vct dur)))
					(vct-fill! v -1.0)
					(vct->channel v beg dur index chan)))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (vct-fill! v -1.0)
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (delete-samples beg dur index chan edpos)
				      (pad-channel beg dur index chan edpos))
			     (lambda (dur)
			       (make-vct dur))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (let ((v (make-vct dur)))
					(vct-fill! v -1.0)
					(delete-samples beg dur index chan edpos)
					(insert-samples beg dur v index chan edpos)))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (vct-fill! v -1.0)
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (let ((v (make-vct dur)))
					(vct-fill! v -1.0)
					(set! (samples beg dur index chan #f "test-channel" 0 edpos) v)))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (vct-fill! v -1.0)
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
				      (reverse-channel beg dur index chan))
			     (lambda (dur)
			       (let ((e (make-env :envelope '(0 1 1 0) :length dur))
				     (v (make-vct dur)))
				 (do ((i 0 (+ 1 i)))
				     ((= i dur))
				   (vct-set! v i (env e)))
				 v))
			     1.0)
	  
	  (test-channel-func (lambda* (beg dur index chan edpos)
				      (env-channel (make-env :envelope '(0 0 1 1) :length dur) beg dur index chan edpos)
				      (set! (sample (+ beg dur) index chan) 1.0)
				      (smooth-channel beg dur index chan)
				      (if (not (= beg 0))
					  (set! (sample (+ beg dur) index chan) 0.0)))
			     (lambda (dur)
			       (let ((v (make-vct dur)))
				 (do ((i 0 (+ 1 i)))
				     ((= i dur))
				   (vct-set! v i (+ 0.5 (* 0.5 (cos (+ pi (/ (* pi i) dur)))))))
				 v))
			     1.0)
	  
	  (let ((old-max (maxamp index #t))
		(regdata (map (lambda (n)
				(region->vct n 0 10))
			      (regions)))
		;; (old-pos0 (edit-position index 0))
		;; (old-pos1 (edit-position index 1))
		(old-reglen (map region-frames (regions)))
		(s61-files '()))
	    (add-hook! save-state-hook
		       (lambda (file)
			 (set! s61-files (cons file s61-files))
			 #f))
	    (if (file-exists? "s61.scm") (delete-file "s61.scm"))
	    (save-state "s61.scm")
	    (close-sound index)
	    (for-each forget-region (regions))
	    (load (string-append cwd "s61.scm"))
	    (if (not (equal? old-reglen (map region-frames (regions))))
		(snd-display #__line__ ";region-frames after save: ~A ~A" old-reglen (map region-frames (regions))))
	    (for-each (lambda (n data)
			(if (not (vequal data (region->vct n 0 10)))
			    (snd-display #__line__ ";region after save ~A: ~A ~A" n data (region->vct n 0 10))))
		      (regions)
		      regdata)
	    (set! index (find-sound "fmv.snd"))
	    (if (not (equal? (maxamp index #t) old-max))
		(snd-display #__line__ ";maxes: ~A ~A" (maxamp index #t) old-max))
	    (if (not (equal? (edits index) (list 275 0)))
		(snd-display #__line__ ";saved channel edits: ~A" (edits index)))
	    
	    (do ((i 0 (+ 1 i)))
		((= i 10))
	      (let ((pos (random (car (edits index)))))
		(scale-channel (random 2.0) (random 5) (random 5) index 0 pos)
		(set! (edit-position index) (floor (* (car (edits index)) .7)))))
	    
	    (close-sound index)
	    (for-each
	     (lambda (n)
	       (forget-region n))
	     (regions))
	    (for-each
	     (lambda (file)
	       (if (file-exists? file) 
		   (delete-file file)))
	     s61-files)
	    (delete-file "s61.scm")
	    (reset-hook! save-state-hook)
	    ))
	
	(let ((index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "channel tests"))
	      (v (make-vct 10))
	      (sw (sinc-width)))
	  (set! (sinc-width) 10)
	  (vct-set! v 0 1.0)
	  (vct->channel v 0 10 index 0)
	  (src-channel 0.5 0 10 index 0)
	  (let ((v (make-vct 10))
		(s (make-src :srate 0.5
			     :input (let ((val 1.0))
				      (lambda (dir)
					(let ((rtn val))
					  (set! val 0.0)
					  rtn))))))
	    (vct-set! v 0 (src s))
	    (do ((i 1 (+ 1 i)))
		((= i 10))
	      (vct-set! v i (src s)))
	    (if (not (vequal v (channel->vct 0 10 index 0)))
		(snd-display #__line__ ";src-channel: ~A ~A" v (channel->vct 0 10 index 0)))
	    (if (not (vequal (make-vct 10) (channel->vct 0 10 index 1)))
		(snd-display #__line__ ";src-channel leaks: ~A" (channel->vct 0 10 index 1)))
	    (let ((tag (catch #t (lambda () (src s 1.0 (lambda (a b) a))) (lambda args (car args)))))
	      (if (not (eq? tag 'bad-arity)) 
		  (snd-display #__line__ ";src bad func: ~A" tag))))
	  (let ((tag (catch #t (lambda () (src-channel 120000.0)) (lambda args args))))
	    (if (not (eq? (car tag) 'mus-error)) (snd-display #__line__ ";src-channel crazy srate: ~A" tag)))
	  (let ((tag (catch #t (lambda () (filter-sound (make-snd->sample))) (lambda args args))))
	    (if (not (eq? (car tag) 'mus-error)) (snd-display #__line__ ";filter-sound + un-run gen: ~A" tag)))
	  (revert-sound index)
	  (vct->channel v 0 10 index 1)
	  (vct->channel v 10 10 index 1)
	  (src-channel (make-env :envelope '(1 1 2 2) :length 21) 0 20 index 1)
	  (if (not (vequal (channel->vct 0 10 index 1) (vct 1.000 -0.000 -0.048 0.068 -0.059 0.022 0.030 -0.100 0.273 0.606)))
	      (snd-display #__line__ ";src-channel env: ~A" (channel->vct 0 10 index 1)))
	  (if (not (vequal (make-vct 10) (channel->vct 0 10 index 0)))
	      (snd-display #__line__ ";src-channel env leaks: ~A" (channel->vct 0 10 index 0)))
	  (revert-sound index)
	  (vct->channel v 0 10 index 1)
	  (vct->channel v 10 10 index 1)
	  (src-channel '(1 1 2 2) 0 20 index 1) ; end is off above -- should be 19 I think
	  (if (not (vequal (channel->vct 0 10 index 1) (vct 1.000 -0.000 -0.051 0.069 -0.056 0.015 0.042 -0.117 0.320 0.568)))
	      (snd-display #__line__ ";src-channel lst: ~A" (channel->vct 0 10 index 1)))
	  (if (not (vequal (make-vct 10) (channel->vct 0 10 index 0)))
	      (snd-display #__line__ ";src-channel lst leaks: ~A" (channel->vct 0 10 index 0)))
	  (set! (sinc-width) sw)
	  (close-sound index))
	
	(if (< (max-regions) 8) (set! (max-regions) 8))
	(let* ((ind (open-sound "oboe.snd"))
	       (rid0 (make-region 2000 2020 ind 0))
	       (rid0-data (region2vct rid0 0 20)))
	  (scale-sound-by 2.0)
	  (play rid0 :wait #t)
	  (let ((nv (region2vct rid0 0 20)))
	    (if (not (vequal rid0-data nv)) (snd-display #__line__ ";deferred region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	  (let ((nv (region-to-vct rid0 0 20)))
	    (if (not (vequal rid0-data nv)) (snd-display #__line__ ";deferred region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	  (undo)
	  (scale-by 4.0)
	  (play rid0 :wait #t)
	  (let ((nv (region2vct rid0 0 20)))
	    (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after scaling:~%  ~A~%  ~A" rid0-data nv)))
	  (let ((nv (region-to-vct rid0 0 20)))
	    (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
	  (let* ((rid1 (make-region 2000 2020 ind 0))
		 (rid1-data (region2vct rid1 0 20)))
	    (scale-to .5)
	    (let ((nv (region2vct rid1 0 20)))
	      (if (not (vequal rid1-data nv)) (snd-display #__line__ ";deferred region after scale-to:~%  ~A~%  ~A" rid1-data nv)))
	    (close-sound ind)
	    (play rid0 :wait #t)
	    (play rid1 :wait #t)
	    (let ((nv (region2vct rid1 0 20)))
	      (if (not (vequal rid1-data nv)) (snd-display #__line__ ";deferred region after close:~%  ~A~%  ~A" rid1-data nv)))
	    (let ((nv (region2vct rid0 0 20)))
	      (if (not (vequal rid0-data nv)) (snd-display #__line__ ";file region after close:~%  ~A~%  ~A" rid0-data nv))))
	  
	  (for-each
	   (lambda (s1 l1 s2 l2)
	     (set! ind (open-sound "2.snd"))
	     (set! (selection-member? #t) #f)
	     (set! (selection-member? ind 0) #t)
	     (set! (selection-position ind 0) s1)
	     (set! (selection-frames ind 0) l1)
	     (set! (selection-member? ind 1) #t)
	     (set! (selection-position ind 1) s2)
	     (set! (selection-frames ind 1) l2)
	     (let* ((rid2 (make-region))
		    (rid20-data (region2vct rid2 0 l1))
		    (rid21-data (region2vct rid2 1 l2)))
	       (if (not (= (region-chans rid2) 2)) (snd-display #__line__ ";region-chans of sync'd sound: ~A?" (region-chans rid2)))
	       (swap-channels ind 0 ind 1)
	       (let ((nv (region2vct rid2 0 l1)))
		 (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region-to-vct rid2 0 l1)))
		 (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region2vct rid2 1 l2)))
		 (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	       (let ((nv (region-to-vct rid2 1 l2)))
		 (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	       (close-sound ind)
	       (let ((nv (region2vct rid2 0 l1)))
		 (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region-to-vct rid2 0 l1)))
		 (if (not (vequal rid20-data nv)) (snd-display #__line__ ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
	       (let ((nv (region2vct rid2 1 l2)))
		 (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
	       (let ((nv (region-to-vct rid2 1 l2)))
		 (if (not (vequal rid21-data nv)) (snd-display #__line__ ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
	       ))
	   (list 2000 2000 2000 0 2000 0 2000)
	   (list 20 10 20 20 20 10 20)
	   (list 2000 2000 2000 2000 0 2000 0)
	   (list 20 20 10 20 20 20 10)))
	
	(let ((ind (open-sound "obtest.snd")))
	  (set! (read-only ind) #t)
	  (delete-samples 0 1000 ind 0)
	  (let ((val (catch #t
			    (lambda ()
			      (save-sound ind))
			    (lambda args args))))
	    (if (sound? val) (snd-display #__line__ ";save-sound read-only: ~A" val))
	    (if (not (equal? (edits ind) (list 1 0))) (snd-display #__line__ ";read-only ignored? ~A" (edits ind))))
	  (set! (read-only ind) #f)
	  (revert-sound ind)
	  (let ((tag (catch #t
			    (lambda () (save-sound ind))
			    (lambda args args))))
	    (if (not (sound? tag)) (snd-display #__line__ ";save-sound read-write: ~A" tag)))
	  (key (char->integer #\j) 4)
	  (if with-gui
	      (let ((str (widget-text (list-ref (sound-widgets ind) 3))))
		(if (and (not (string=? str "no marks"))
			 (not (string=? str "no such mark")))
		    (snd-display #__line__ ";C-j w/o marks: ~A?" str))))
	  (key (char->integer #\-) 4)
	  (key (char->integer #\j) 4)
	  (key (char->integer #\j) 4)
	  (key (char->integer #\x) 4)
	  (key (char->integer #\c) 0)
	  (if with-gui
	      (let ((str (widget-text (list-ref (sound-widgets ind) 3))))
		(if (widget-text (cadr (main-widgets))) 
		    (snd-display #__line__ ";widget-text of non-text widget: ~A" (widget-text (cadr (main-widget)))))
		(set! (widget-text (list-ref (channel-widgets ind 0) 2)) "F")
		(if (not (string=? (widget-text (list-ref (channel-widgets ind 0) 2)) "F"))
		    (snd-display #__line__ ";set button label to F: ~A" (widget-text (list-ref (channel-widgets ind 0) 2)) "F"))
		(if (and (not (string=? str "no marks"))
			 (not (string=? str "no such mark")))
		    (snd-display #__line__ ";C-x c w/o marks: ~A?" str))))
	  (add-mark 123)
	  (key (char->integer #\u) 4)
	  (key (char->integer #\6) 4)
	  (key (char->integer #\j) 4)
	  (if with-gui
	      (let ((str (widget-text (list-ref (sound-widgets ind) 3))))
		(if (not (string=? str "no such mark"))
		    (snd-display #__line__ ";C-u 6 C-j: ~A?" str))))
	  (key (char->integer #\u) 4)
	  (key (char->integer #\6) 4)
	  (key (char->integer #\x) 4)
	  (key (char->integer #\c) 0)
	  (if with-gui
	      (let ((str (widget-text (list-ref (sound-widgets ind) 3))))
		(if (not (string=? str "no such mark"))
		    (snd-display #__line__ ";C-u 6 C-x c: ~A?" str))))
	  (close-sound ind))
	
	(let ((ind (view-sound "obtest.snd")))
	  (delete-samples 0 1000 ind 0)
	  (let ((tag (catch #t
			    (lambda () (save-sound ind))
			    (lambda args args))))
	    (if (integer? tag) (snd-display #__line__ ";save-viewed-sound: ~A" tag))
	    (if (not (equal? (edits ind) (list 1 0))) (snd-display #__line__ ";view read-only ignored? ~A" (edits ind))))
	  (close-sound ind))
	
	(let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1)))
	  (insert-silence 0 150000)
	  (map-channel (lambda (y) 0.5))
	  (env-sound '(0 0 1 1 2 0))
	  (fp 1.0 0.3 20)
	  (let ((old-curse (with-tracking-cursor)))
	    (set! (with-tracking-cursor) #t)
	    (play :wait #t)
	    (set! (with-tracking-cursor) old-curse))
	  (close-sound ind))
	(let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1)))
	  (for-each
	   (lambda (dur)
	     (insert-silence 0 dur)
	     (map-channel (lambda (y) 1.0))
	     (env-sound '(0 0 1 1 2 0))
	     (let ((reader (make-sampler (- (frames) 1) ind 0 -1)))
	       (if (not (= (sampler-position reader) (- (frames) 1))) (snd-display #__line__ ";sampler-position: ~A" (sampler-position reader)))
	       (map-channel (lambda (y) (read-sample reader))))
	     (scan-channel (let ((pos 0)
				 (e (make-env '(0 0 1 1 2 0) :length (+ 1 dur))))
			     (lambda (y)
			       (let ((val (env e)))
				 (if (fneq val y) 
				     (begin
				       (display (format #f "~%;trouble in reverse read at ~D ~A ~A" pos val y))
				       #t)
				     (begin
				       (set! pos (+ 1 pos))
				       #f))))))
	     (revert-sound))
	   (list 150 1500 150000))
	  (close-sound ind))
	(let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1)))
	  (insert-silence 0 1000)
	  (map-channel (lambda (y) 1.0))
	  (env-sound '(0 0 1 1 2 0))
	  (scale-channel 0.0 100 200)
	  (let ((reader (make-sampler (- (frames) 1) ind 0 -1)))
	    (map-channel (lambda (y) (read-sample reader))))
	  (scan-channel (let ((pos 0)
			      (e (make-env '(0 0 1 1 2 0) :length 1001)))
			  (lambda (y)
			    (let ((val (env e)))
			      (if (or (and (or (> pos 900) (<= pos 700))
					   (fneq val y))
				      (and (> pos 700) (<= pos 900)
					   (fneq y 0.0)))
				  (begin
				    (display (format #f "~%;trouble in reverse read 2 at ~D ~A ~A" pos val y))
				    #t)
				  (begin
				    (set! pos (+ 1 pos))
				    #f))))))
	  (close-sound ind))
	(let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1)))
	  (insert-silence 0 150000)
	  (map-channel (lambda (y) 1.0))
	  (let ((edpos (edit-position)))
	    (do ((i 0 (+ 1 i)))
		((= i 7))
	      (if (= i 5)
		  (scale-channel 0.5 1000 12345))
	      (env-sound '(0 0 1 1 2.5 0 3 1 4 0))
	      (if (= i 1)
		  (delete-samples 50 100)
		  (if (= i 2)
		      (insert-samples 300 100 (vct-fill! (make-vct 100) 0.5))
		      (if (= i 3)
			  (scale-channel 0.0 1000 1000)
			  (if (= i 4)
			      (vct->channel (vct-fill! (make-vct 100) .5) 500 100)
			      (if (= i 6)
				  (env-sound '(0 1 1 0) 10000 2000))))))
	      (let ((reader (make-sampler (- (frames) 1) ind 0 -1)))
		(map-channel (lambda (y) (read-sample reader))))
	      (let ((reader (make-sampler (- (frames) 1) ind 0 -1)))
		(map-channel (lambda (y) (read-sample reader))))
	      (scan-channel (let ((old-reader (make-sampler 0 ind 0 1 (- (edit-position ind 0) 2)))
				  (pos 0))
			      (lambda (y)
				(let ((val (read-sample old-reader)))
				  (if (fneq y val)
				      (begin
					(display (format #f "~%;trouble in reverse (~D) read at ~D ~A ~A" i pos val y))
					#t)
				      (begin
					(set! pos (+ 1 pos))
					#f))))))
	      (set! (edit-position ind 0) edpos)))
	  (close-sound ind))
	(let ((reader #f)
	      (last-proc #f))
	  (define (scan-again)
	    (if (sampler-at-end? reader)
		#f
		(let ((val (last-proc (reader))))
		  (if val 
		      (list val (- (sampler-position reader) 1))
		      (scan-again)))))
	  (define* (my-scan-chan proc)
	    (if proc 
		(begin
		  (set! last-proc proc)
		  (set! reader (make-sampler 0))))
	    (scan-again))
	  (let ((ind (open-sound "oboe.snd"))
		(val #f))
	    (let ((samp (sample 1000)))
	      (set! (cursor ind 0) 1000)
	      (if (fneq (sample) samp)
		  (snd-display #__line__ ";sample no args: ~A ~A" (sample) samp)))
	    (set! val (my-scan-chan (lambda (y) (> y .1))))
	    (if (not (equal? val (list #t 4423)))
		(snd-display #__line__ ";my-scan-chan: ~A" val))
	    (set! val (scan-again))
	    (if (not (equal? val (list #t 4463)))
		(snd-display #__line__ ";scan-again: ~A" val))
	    (let ((val (find-channel (lambda (y)
				       (let ((val (find-channel (lambda (y) (> y .1)))))
					 val)))))
	      (if (not (equal? val (list (list #t 4423) 0)))
		  (snd-display #__line__ ";find twice: ~A" val)))
	    (let ((val (find-channel (lambda (y)
				       (count-matches (lambda (y) (> y .1)))))))
	      (if (not (equal? val (list 2851 0)))
		  (snd-display #__line__ ";find+count: ~A" val)))
	    (set! (cursor) 1000)
	    (set! (sample) .5)
	    (if (fneq (sample 1000) .5)
		(snd-display #__line__ ";set sample no arg: ~A ~A" (sample 1000) (sample 0)))
	    (close-sound ind)))
	
	;; edit-menu.scm tests
	(if (defined? 'selection->new)
	    (let ((ind (view-sound "oboe.snd")))
	      (make-selection 1000 1999 ind 0)
	      (let ((newsnd (selection->new)))
		(if (not (sound? newsnd)) (snd-display #__line__ ";selection->new -> ~A" newsnd))
		(if (not (= (frames newsnd 0) 1000)) (snd-display #__line__ ";selection->new frames: ~A" (frames newsnd 0)))
		(if (not (equal? (edits ind 0) (list 0 0))) (snd-display #__line__ ";selection->new edited original? ~A" (edits ind 0)))
		(let ((newfile (file-name newsnd)))
		  (close-sound newsnd)
		  (delete-file newfile)
		  (mus-sound-forget newfile)))
	      (make-selection 1000 1999 ind 0)
	      (let ((newsnd (cut-selection->new)))
		(if (not (sound? newsnd)) (snd-display #__line__ ";cut-selection->new -> ~A" newsnd))
		(if (not (= (frames newsnd 0) 1000)) (snd-display #__line__ ";cut-selection->new frames: ~A" (frames newsnd 0)))
		(if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";cut-selection->new did not edit original? ~A" (edits ind 0)))
		(if (not (= (frames ind 0) (- (frames ind 0 0) 1000))) 
		    (snd-display #__line__ ";cut-selection->new cut: ~A ~A" (frames ind 0) (- (frames ind 0 0) 1000)))
		(undo 1 ind 0)
		(let ((newfile (file-name newsnd)))
		  (close-sound newsnd)
		  (delete-file newfile)
		  (mus-sound-forget newfile)))
	      (make-selection 1000 1999 ind 0)
	      (append-selection)
	      (if (not (= (frames ind 0) (+ (frames ind 0 0) 1000)))
		  (snd-display #__line__ ";append-selection: ~A ~A" (frames ind 0) (frames ind 0 0)))
	      (append-sound "oboe.snd")
	      (if (not (= (frames ind 0) (+ (* 2 (frames ind 0 0)) 1000)))
		  (snd-display #__line__ ";append-sound: ~A ~A" (frames ind 0) (frames ind 0 0)))
	      (revert-sound ind)
	      (let ((m1 (add-mark 1000))
		    (m2 (add-mark 12000)))
		(trim-front)
		(if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";time-front did not edit original? ~A" (edits ind 0)))
		(if (not (= (frames ind 0) (- (frames ind 0 0) 1000))) 
		    (snd-display #__line__ ";trim-front: ~A ~A" (frames ind 0) (- (frames ind 0 0) 1000)))
		(if (not (= (mark-sample m2) 11000)) (snd-display #__line__ ";trim-front m2: ~A" (mark-sample m2)))
		(undo 1 ind 0)
		(trim-back)
		(if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";time-back did not edit original? ~A" (edits ind 0)))
		(if (not (= (frames ind 0) 12001)) (snd-display #__line__ ";trim-back: ~A" (frames ind 0)))
		(if (not (= (mark-sample m1) 1000)) (snd-display #__line__ ";trim-back m1: ~A" (mark-sample m1)))
		(undo 1 ind 0)
		(add-mark 22000)
		(crop)
		(if (not (equal? (edits ind 0) (list 1 0))) (snd-display #__line__ ";crop did not edit original? ~A" (edits ind 0)))
		(if (not (= (frames ind 0) 21001)) (snd-display #__line__ ";crop: ~A" (frames ind 0)))
		(undo 1 ind 0)
		(close-sound ind))))
	
	(let ((ind (new-sound "test.snd")))
	  (map-chan (lambda (y) 1.0) 0 1000)
	  (env-channel (make-env '(0 1 1 1) :scaler .5 :length 1001))
	  (check-maxamp ind .5 "simple scaler")
	  (check-env-vals "simple scaler" (make-env '(0 1 1 1) :scaler .5 :length 1001))
	  (if (= (edit-position) 2)
	      (undo)
	      (snd-display #__line__ ";env+scl was no-op"))
	  (env-channel (make-env '(0 1 1 1) :offset .5 :length 1001))
	  (check-maxamp ind 1.5 "simple offset")
	  (check-env-vals "simple offset" (make-env '(0 1 1 1) :offset .5 :length 1001))
	  (if (= (edit-position) 2)
	      (undo)
	      (snd-display #__line__ ";env+offset was no-op"))
	  (env-channel (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	  (check-maxamp ind 2.5 "off+scl")
	  (check-env-vals "off+scl" (make-env '(0 0 1 1 2 0) :offset .5 :scaler 2.0 :length 1001))
	  (undo)
	  (env-channel (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	  (check-maxamp ind 1.5 "off+scl #2")
	  (let ((mx -12.0))
	    (scan-chan (lambda (y) 
			 (if (> y mx) 
			     (set! mx y))
			 #f))
	    (if (fneq mx 0.5) (snd-display #__line__ ";non abs max: ~A (correct: 0.5)" mx)))
	  (check-env-vals "off+scl #2" (make-env '(0 -0.5 1 0 2 -1) :offset .5 :scaler 2.0 :length 1001))
	  (undo)
	  (env-sound '(0 .5 1 .75 2 .25) 0 (frames) 32.0)
	  (check-maxamp ind 0.75 "xramp")
	  (check-env-vals "xramp" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001))
	  (undo)
	  (env-channel-with-base '(0 .5 1 .75 2 .25) 32.0)
	  (check-maxamp ind 0.75 "xramp1")
	  (check-env-vals "xramp1" (make-env '(0 .5 1 .75 2 .25) :base 32.0 :length 1001))
	  
	  (close-sound ind))
	
	(let ((hlb (make-hilbert-transform 8))
	      (data (make-vct 20)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 20))
	    (vct-set! data i (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	  (if (not (vequal data (vct 0.0 -0.010 0.0 -0.046 0.0 -0.152 0.0 -0.614 0.0 0.614 0.0 0.152 0.0 0.046 0.0 0.010 0.0 0.0 0.0 0.0)))
	      (snd-display #__line__ ";hilbert-transform 8 impulse response: ~A" data)))
	
	(let ((hlb (make-hilbert-transform 7))
	      (data (make-vct 20)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 20))
	    (vct-set! data i (hilbert-transform hlb (if (= i 0) 1.0 0.0))))
	  (if (not (vequal data (vct -0.007 0.0 -0.032 0.0 -0.136 0.0 -0.608 0.0 0.608 0.0 0.136 0.0 0.032 0.0 0.007 0.0 0.0 0.0 0.0 0.0)))
	      (snd-display #__line__ ";hilbert-transform 7 impulse response: ~A" data)))
	
	(let ((ind (new-sound "test.snd")))
	  (pad-channel 0 1000)
	  (set! (sample 100) 1.0)
	  (let ((h (make-hilbert-transform 100)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    ;; now ideally we'd be back to an impulse
	    (if (> (abs (- (sample 500) .98)) .01)
		(snd-display #__line__ ";hilbert impulse: ~A" (sample 500)))
	    (set! (sample 500) 0.0)
	    (if (> (maxamp ind 0) .02)
		(snd-display #__line__ ";hilbert sidelobes: ~A" (maxamp ind 0)))
	    (scale-channel 0.0)
	    (set! (sample 100) 1.0)
	    (set! h (make-hilbert-transform 101))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (map-channel (lambda (y) (hilbert-transform h y)))
	    (if (> (abs (- (sample 504) .98)) .01)
		(snd-display #__line__ ";hilbert 101 impulse: ~A: ~A" (sample 504) (channel->vct 498 10)))
	    (set! (sample 504) 0.0)
	    (if (> (maxamp ind 0) .02)
		(snd-display #__line__ ";hilbert 101 sidelobes: ~A" (maxamp ind 0)))
	    (revert-sound))
	  (pad-channel 0 1000)
	  (set! (sample 100) 1.0)
	  (let ((lo (make-lowpass (* .1 pi) 20))
		(hi (make-highpass (* .1 pi) 20)))
	    (map-channel (lambda (y) (+ (lowpass lo y) (highpass hi y))))
	    (if (fneq (sample 120) 1.0)
		(snd-display #__line__ ";lowpass+highpass impulse: ~A" (sample 120)))
	    (set! (sample 120) 0.0)
	    (if (fneq (maxamp ind 0) 0.0)
		(snd-display #__line__ ";lowpass+highpass sidelobes: ~A" (maxamp ind 0))))
	  (undo 2)
	  (let ((lo (make-bandpass (* .1 pi) (* .2 pi) 20))
		(hi (make-bandstop (* .1 pi) (* .2 pi) 20)))
	    (map-channel (lambda (y) (+ (bandpass lo y) (bandstop hi y))))
	    (if (fneq (sample 120) 1.0)
		(snd-display #__line__ ";bandpass+bandstop impulse: ~A" (sample 120)))
	    (set! (sample 120) 0.0)
	    (if (fneq (maxamp ind 0) 0.0)
		(snd-display #__line__ ";bandpass+bandstop sidelobes: ~A" (maxamp ind 0))))
	  (close-sound ind))
	
	(let ((ind (new-sound "test.snd")))
	  (map-channel (lambda (y) (- 1.0 (random 2.0))) 0 10000)
	  (let ((f2 (make-bandpass-2 (* .12 pi) (* .15 pi) (* .22 pi) (* .25 pi) 100)))
	    (map-channel (lambda (y) (fir-filter f2 y)))
	    (let ((data (channel->vct)))
	      (undo)
	      (let* ((f1 (make-bandpass (* .12 pi) (* .15 pi) 100))
		     (f2 (make-bandpass (* .22 pi) (* .25 pi) 100)))
		(map-channel (lambda (y) (+ (fir-filter f1 y) (fir-filter f2 y))))
		(let ((data1 (channel->vct)))
		  (vct-subtract! data data1)
		  (if (> (vct-peak data) .00001)
		      (snd-display #__line__ ";fir-filter 2: ~A" (vct-peak data))))
		(undo))))
	  (close-sound ind))
	
	(reset-almost-all-hooks)
	
	(let ((ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "1st ramp re-order tests" 100)))
	  (map-channel (lambda (y) 1.0))
	  (for-each
	   (lambda (lst)
	     (let ((name (car lst))
		   (try-scale (cadr lst))
		   (f1 (caddr lst))
		   (f2 (cadddr lst))
		   (edpos (edit-position ind 0)))
	       (f1)
	       (let ((v1 (channel->vct 0 100 ind 0)))
		 (set! (edit-position ind 0) edpos)
		 (f2)
		 (let ((v2 (channel->vct 0 100 ind 0)))
		   (if (not (vequal v1 v2))
		       (snd-display #__line__ ";env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
		   (set! (edit-position ind 0) edpos)))
	       (if try-scale
		   (begin
		     (scale-by 2.0)
		     (f1)
		     (let ((v1 (channel->vct 0 100 ind 0)))
		       (set! (edit-position ind 0) edpos)
		       (f2)
		       (scale-by 2.0)
		       (let ((v2 (channel->vct 0 100 ind 0)))
			 (if (not (vequal v1 v2))
			     (snd-display #__line__ ";scaled (2) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
			 (set! (edit-position ind 0) edpos)))
		     (f1)
		     (scale-by .5)
		     (let ((v1 (channel->vct 0 100 ind 0)))
		       (set! (edit-position ind 0) edpos)
		       (scale-by .5)
		       (f2)
		       (let ((v2 (channel->vct 0 100 ind 0)))
			 (if (not (vequal v1 v2))
			     (snd-display #__line__ ";scaled (.5) env reordering test ~A:~%; ~A~%; ~A" name v1 v2))
			 (set! (edit-position ind 0) edpos)))))))
	   
	   (list (list "ramp-xramp" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1) 0 100 2.0))
		       (lambda ()
			 (env-sound '(0 0 1 1) 0 100 2.0)
			 (env-sound '(0 0 1 1 2 0))))
		 (list "ramp2-xramp (1)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0))
			 (env-sound '(0 0 1 1) 0 100 2.0))
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1) 0 100 2.0)
			 (env-sound '(0 0 1 1 3 0))))
		 (list "ramp2-xramp (2)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 3 0) 0 100 2.0))
		       (lambda ()
			 (env-sound '(0 0 1 1 3 0) 0 100 2.0)
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1))))
		 (list "xramp2-ramp (1)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 3 0) 0 100 3.0))
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1 3 0) 0 100 3.0)
			 (env-sound '(0 0 1 1))))
		 (list "xramp2-ramp (2)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1 3 0))
			 (env-sound '(0 0 1 1) 0 100 3.0))
		       (lambda ()
			 (env-sound '(0 0 1 1 3 0))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1) 0 100 3.0)))
		 (list "ptree-ramp" #t
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (ptree-channel (lambda (y) (* y 2.0))))
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1))))
		 (list "ptree-xramp" #t
		       (lambda ()
			 (env-sound '(0 0 1 1) 0 100 2.0)
			 (ptree-channel (lambda (y) (* y 2.0))))
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1) 0 100 2.0)))
		 (list "ptree-ramp2 (1)" #t
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0)))
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1 2 0))))
		 (list "ptree-ramp2 (2)" #t
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0)))
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0))
			 (ptree-channel (lambda (y) (* y 2.0)))))
		 (list "xramp-ptree-ramp (1)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1)))
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1))))
		 (list "xramp-ptree-ramp (2)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0))
		       (lambda ()
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1))
			 (ptree-channel (lambda (y) (* y 2.0)))))
		 (list "xramp-ptree-ramp (3)" #t
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0))
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (ptree-channel (lambda (y) (* y 2.0)))))
		 (list "xramp-ptree-ramp-zero" #f
		       (lambda ()
			 (scale-by 0.0)
			 (ptree-channel (lambda (y) 1.0))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0))
		       (lambda ()
			 (scale-by 0.0)
			 (ptree-channel (lambda (y) 1.0))
			 (env-sound '(0 0 1 1 2 0) 0 100 2.0)
			 (env-sound '(0 0 1 1))))
		 (list "ptree-ramp3 (1)" #t
		       (lambda ()
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0)))
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0))))
		 (list "ptree-ramp3 (2)" #t
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0))
			 (ptree-channel (lambda (y) (* y 2.0)))
			 (env-sound '(0 0 1 1 3 0)))
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0))
			 (ptree-channel (lambda (y) (* y 2.0)))))
		 (list "ramp4" #t
		       (lambda ()
			 (env-sound '(0 0 1 1))
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0))
			 (env-sound '(0 0 1 1 4 0)))
		       (lambda ()
			 (env-sound '(0 0 1 1 4 0))
			 (env-sound '(0 0 1 1 2 0))
			 (env-sound '(0 0 1 1 3 0))
			 (env-sound '(0 0 1 1))))
		 
		 ))
	  (close-sound ind))
	
	(let ((ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "2nd ramp re-order tests" 100))
	      (oldopt (optimization)))
	  
	  (define (reversed-channel->vct start dur snd chn)
	    (let* ((data (make-vct dur))
		   (sf (make-sampler (+ start dur -1) snd chn -1)))
	      (do ((i (+ start dur -1) (- i 1)))
		  ((< i start))
		(vct-set! data i (read-sample sf)))
	      data))
	  
	  (if (and (provided? 'snd-motif)
		   (provided? 'xm))
	      (let* ((edhist (list-ref (channel-widgets ind 0) 7))
		     (edp (XtParent edhist))
		     (pmax (cadr (XtVaGetValues edp (list XmNpaneMaximum 0)))))
		(XtUnmanageChild edp) 
		(XtVaSetValues edp (list XmNpaneMinimum 100)) 
		(XtManageChild edp)))
	  
	  (set! (squelch-update ind) #t)
	  
	  (do ((k 0 (+ 1 k)))
	      ((= k 2))
	    (revert-sound ind)
	    (if (= k 0)
		(map-channel (lambda (y) 1.0))
		(begin
		  (scale-by 0.0)
		  (ptree-channel (lambda (y) 1.0))))
	    (let* ((ramp1 (lambda () (env-sound '(0 0 1 1))))
		   (ramp2 (lambda () (env-sound '(0 0 1 1 2 0))))
		   (ramp3 (lambda () (env-sound '(0 1 1 0 2 0 3 1))))
		   (ramp4 (lambda () (env-sound '(0 1 1 0 2 1))))
		   (xramp1 (lambda () (env-sound '(0 0 1 1) 0 100 2.0)))
		   (xramp2 (lambda () (env-sound '(0 1 1 0 2 0 3 1) 0 100 .6)))
		   (ptree1 (lambda () (ptree-channel (lambda (y) (+ y .2)))))
		   (ptree2 (lambda () (ptree-channel (lambda (y) (- y .1)))))
		   (map1 (lambda () (map-channel (lambda (y) (+ y .2)))))
		   (map2 (lambda () (map-channel (lambda (y) (- y .1)))))
		   (ops (list ramp1 ramp2 ramp3 xramp1 xramp2 ptree1 ptree2 ramp4))
		   (op-names (list "ramp1" "ramp2" "ramp3" "xramp1" "xramp2" "ptree1" "ptree2" "ramp4"))
		   (op (lambda (which) ((list-ref ops which))))
		   (op-name (lambda (which) (list-ref op-names which)))
		   (vals1 #f)
		   (vals2 #f)
		   (scl 1.0)
		   (scalers '())
		   (saved-scalers '())
		   (edpos (edit-position ind 0)))
	      
	      (let ((op1 (list 0 3 5))
		    (op2 (list 1 4 6)))
		(for-each
		 (lambda (first)
		   (for-each 
		    (lambda (second)
		      (if (and (not (= first second))
			       (let ((val (+ k
					     (if (> first 4) 1 0)
					     (if (> second 4) 1 0))))
				 (not (> val 2))))
			  (begin
			    (set! scalers '())
			    (set! scl (+ .5 (random 1.0)))
			    (scale-by scl)
			    (set! scalers (cons scl scalers))
			    (op first)
			    (set! scl (+ .5 (random 1.0)))
			    (scale-by scl)
			    (set! scalers (cons scl scalers))
			    (op second)
			    (set! scl (+ .5 (random 1.0)))
			    (scale-by scl)
			    (set! scalers (cons scl scalers))
			    (set! vals1 (channel->vct 0 100 ind 0))
			    (let ((rvals (reversed-channel->vct 0 100 ind 0)))
			      (if (not (vequal rvals vals1))
				  (snd-display #__line__ ";1 virtual op reversed tests: ~A(~A~A) * ~A:~%; ~A~%; ~A => ~A"
					       (op-name second) (op-name first)
					       (if (= k 1) "(ptree_zero)" "")
					       scalers vals1 rvals
					       (vct-peak (vct-subtract! (vct-copy vals1) rvals)))))
			    (set! (edit-position ind 0) edpos)
			    (set! (optimization) 0)
			    (set! scalers (reverse scalers))
			    (set! saved-scalers scalers)
			    (scale-by (car scalers)) (set! scalers (cdr scalers))
			    (if (= first 5) (map1) (if (= first 6) (map2) (op first)))
			    (scale-by (car scalers)) (set! scalers (cdr scalers))
			    (if (= second 5) (map1) (if (= second 6) (map2) (op second)))
			    (scale-by (car scalers)) (set! scalers (cdr scalers))
			    (set! (optimization) oldopt)
			    (set! vals2 (channel->vct 0 100 ind 0))
			    (if (not (vequal vals1 vals2)) 
				(snd-display #__line__ ";1 virtual op tests: ~A(~A~A) * ~A:~%; ~A~%; ~A => ~A at ~A"
					     (op-name second) (op-name first)
					     (if (= k 1) "(ptree_zero)" "")
					     saved-scalers vals1 vals2
					     (vct-peak (vct-subtract! (vct-copy vals1) vals2))
					     (let* ((pks (vct-subtract! (vct-copy vals1) vals2))
						    (pk (abs (vct-ref pks 0)))
						    (loc 0))
					       (do ((i 1 (+ 1 i)))
						   ((= i 100) (list loc (vct-ref pks loc) (vct-ref vals1 loc) (vct-ref vals2 loc)))
						 (if (> (abs (vct-ref pks i)) pk)
						     (begin
						       (set! loc i)
						       (set! pk (abs (vct-ref pks i)))))))
					     ))
			    (let ((rvals (reversed-channel->vct 0 100 ind 0)))
			      (if (not (vequal rvals vals2))
				  (snd-display #__line__ ";1 virtual op reversed tests (2): ~A(~A~A) * ~A:~%; ~A~%; ~A => ~A"
					       (op-name second) (op-name first)
					       (if (= k 1) "(ptree_zero)" "")
					       saved-scalers vals2 rvals
					       (vct-peak (vct-subtract! (vct-copy vals2) rvals)))))
			    (set! (edit-position ind 0) edpos))))
		    op2))
		 op1))
	      (let ((op1 (list 0 3 5))
		    (op2 (list 1 4 6))
		    (op3 (list 2 3 4 5 6)))
		(for-each
		 (lambda (first)
		   (for-each 
		    (lambda (second)
		      (if (not (= first second))
			  (for-each
			   (lambda (third)
			     (if (and (not (= first third))
				      (not (= second third))
				      (let ((val (+ k
						    (if (or (= first 5) (= first 6)) 1 0)
						    (if (or (= second 5) (= second 6)) 1 0)
						    (if (or (= third 5) (= third 6)) 1 0))))
					(not (> val 2))))
				 (begin
				   (set! scalers '())
				   (set! scl (+ .5 (random 1.0)))
				   (scale-by scl)
				   (set! scalers (cons scl scalers))
				   (op first)
				   (set! scl (+ .5 (random 1.0)))
				   (scale-by scl)
				   (set! scalers (cons scl scalers))
				   (op second)
				   (set! scl (+ .5 (random 1.0)))
				   (scale-by scl)
				   (set! scalers (cons scl scalers))
				   (op third)
				   (set! scl (+ .5 (random 1.0)))
				   (scale-by scl)
				   (set! scalers (cons scl scalers))
				   (set! vals1 (channel->vct 0 100 ind 0))
				   (let ((rvals (reversed-channel->vct 0 100 ind 0)))
				     (if (not (vequal rvals vals1))
					 (snd-display #__line__ ";2 virtual op reversed tests: ~A(~A(~A~A)) * ~A:~%; ~A~%; ~A => ~A"
						      (op-name third) (op-name second) (op-name first)
						      (if (= k 1) "(ptree_zero)" "")
						      scalers vals1 rvals
						      (vct-peak (vct-subtract! (vct-copy vals1) rvals)))))
				   (set! (edit-position ind 0) edpos)
				   (set! (optimization) 0)
				   (set! scalers (reverse scalers))
				   (set! saved-scalers scalers)				     
				   (scale-by (car scalers)) (set! scalers (cdr scalers))
				   (if (= first 5) (map1) (if (= first 6) (map2) (op first)))
				   (scale-by (car scalers)) (set! scalers (cdr scalers))
				   (if (= second 5) (map1) (if (= second 6) (map2) (op second)))
				   (scale-by (car scalers)) (set! scalers (cdr scalers))
				   (if (= third 5) (map1) (if (= third 6) (map2) (op third)))
				   (scale-by (car scalers)) (set! scalers (cdr scalers))
				   (set! (optimization) oldopt)
				   (set! vals2 (channel->vct 0 100 ind 0))
				   (if (not (vequal vals1 vals2)) 
				       (snd-display #__line__ ";2 virtual op tests: ~A * ~A(~A(~A~A)): ~A ~A => ~A at ~A"
						    saved-scalers (op-name third) (op-name second) (op-name first) 
						    (if (= k 1) "(ptree_zero)" "")
						    vals1 vals2
						    (vct-peak (vct-subtract! (vct-copy vals1) vals2))
						    (let* ((pks (vct-subtract! (vct-copy vals1) vals2))
							   (pk (abs (vct-ref pks 0)))
							   (loc 0))
						      (do ((i 1 (+ 1 i)))
							  ((= i 100) (list loc (vct-ref pks loc) (vct-ref vals1 loc) (vct-ref vals2 loc)))
							(if (> (abs (vct-ref pks i)) pk)
							    (begin
							      (set! loc i)
							      (set! pk (abs (vct-ref pks i)))))))
						    ))
				   (let ((rvals (reversed-channel->vct 0 100 ind 0)))
				     (if (not (vequal rvals vals2))
					 (snd-display #__line__ ";2 virtual op reversed tests (2): ~A(~A(~A~A)) * ~A:~%; ~A~%; ~A => ~A"
						      (op-name third) (op-name second) (op-name first)
						      (if (= k 1) "(ptree_zero)" "")
						      saved-scalers vals2 rvals
						      (vct-peak (vct-subtract! (vct-copy vals2) rvals)))))
				   (set! (edit-position ind 0) edpos))))
			   op3)))
		    op2))
		 op1))
	      (let ((op1 (list 0 3 5))
		    (op2 (list 0 1 3 4 5 6))
		    (op3 (list 0 1 2 3 4 5 6))
		    (op4 (list 0 1 2 3 4 5 6)))
		(for-each
		 (lambda (first)
		   (for-each 
		    (lambda (second)
		      (if (not (= first second))
			  (for-each
			   (lambda (third)
			     (if (and (not (= first third))
				      (not (= second third)))
				 (for-each
				  (lambda (fourth)
				    (if (and (not (= first fourth))
					     (not (= second fourth))
					     (not (= third fourth))
					     (let ((val (+ k
							   (if (or (= first 5) (= first 6)) 1 0)
							   (if (or (= second 5) (= second 6)) 1 0)
							   (if (or (= third 5) (= third 6)) 1 0)
							   (if (or (= fourth 5) (= fourth 6)) 1 0))))
					       (not (> val 2))))
					(begin
					  (set! scalers '())
					  (set! scl (+ .5 (random 1.0)))
					  (scale-by scl)
					  (set! scalers (cons scl scalers))
					  (op first)
					  (set! scl (+ .5 (random 1.0)))
					  (scale-by scl)
					  (set! scalers (cons scl scalers))
					  (op second)
					  (set! scl (+ .5 (random 1.0)))
					  (scale-by scl)
					  (set! scalers (cons scl scalers))
					  (op third)
					  (set! scl (+ .5 (random 1.0)))
					  (scale-by scl)
					  (set! scalers (cons scl scalers))
					  (op fourth)
					  (set! scl (+ .5 (random 1.0)))
					  (scale-by scl)
					  (set! scalers (cons scl scalers))
					  (set! vals1 (channel->vct 0 100 ind 0))
					  (let ((rvals (reversed-channel->vct 0 100 ind 0)))
					    (if (not (vequal rvals vals1))
						(snd-display #__line__ ";3 virtual op reversed tests: ~A(~A(~A(~A~A))) * ~A:~%; ~A~%; ~A => ~A"
							     (op-name fourth) (op-name third) (op-name second) (op-name first)
							     (if (= k 1) "(ptree_zero)" "")
							     scalers vals1 rvals
							     (vct-peak (vct-subtract! (vct-copy vals1) rvals)))))
					  (set! (edit-position ind 0) edpos)
					  (set! (optimization) 0)
					  (set! scalers (reverse scalers))
					  (set! saved-scalers scalers)
					  (scale-by (car scalers)) (set! scalers (cdr scalers))
					  (if (= first 5) (map1) (if (= first 6) (map2) (op first)))
					  (scale-by (car scalers)) (set! scalers (cdr scalers))
					  (if (= second 5) (map1) (if (= second 6) (map2) (op second)))
					  (scale-by (car scalers)) (set! scalers (cdr scalers))
					  (if (= third 5) (map1) (if (= third 6) (map2) (op third)))
					  (scale-by (car scalers)) (set! scalers (cdr scalers))
					  (if (= fourth 5) (map1) (if (= fourth 6) (map2) (op fourth)))
					  (scale-by (car scalers)) (set! scalers (cdr scalers))
					  (set! (optimization) oldopt)
					  (set! vals2 (channel->vct 0 100 ind 0))
					  (if (not (vequal vals1 vals2)) 
					      (snd-display #__line__ ";3 virtual op tests: ~A * ~A(~A(~A(~A~A))):~%  opt vals:   ~A~%  unopt vals: ~A~%  => ~A at ~A"
							   saved-scalers
							   (op-name fourth) (op-name third) (op-name second) (op-name first)
							   (if (= k 1) "(ptree_zero)" "") 
							   vals1 vals2
							   (vct-peak (vct-subtract! (vct-copy vals1) vals2))
							   (let* ((pks (vct-subtract! (vct-copy vals1) vals2))
								  (pk (abs (vct-ref pks 0)))
								  (loc 0))
							     (do ((i 1 (+ 1 i)))
								 ((= i 100) (list loc (vct-ref pks loc) (vct-ref vals1 loc) (vct-ref vals2 loc)))
							       (if (> (abs (vct-ref pks i)) pk)
								   (begin
								     (set! loc i)
								     (set! pk (abs (vct-ref pks i)))))))
							   ))
					  (let ((rvals (reversed-channel->vct 0 100 ind 0)))
					    (if (not (vequal rvals vals2))
						(snd-display #__line__ ";3 virtual op reversed tests (2): ~A(~A(~A(~A~A))) * ~A: ~A ~A => ~A"
							     (op-name fourth) (op-name third) (op-name second) (op-name first)
							     (if (= k 1) "(ptree_zero)" "")
							     saved-scalers vals2 rvals
							     (vct-peak (vct-subtract! (vct-copy vals2) rvals)))))
					  (set! (edit-position ind 0) edpos))))
				  op4)))
			   op3)))
		    op2))
		 op1))
	      
	      (if all-args
		  (let ((op1 (list 0 3 5))
			(op2 (list 0 1 3 4 5 6))
			(op3 (list 0 1 2 3 4 5 6))
			(op4 (list 0 1 2 3 4 5 6 7))
			(op5 (list 7 3 5)))
		    (for-each
		     (lambda (first)
		       (for-each 
			(lambda (second)
			  (if (not (= first second))
			      (for-each
			       (lambda (third)
				 (if (and (not (= first third))
					  (not (= second third)))
				     (for-each
				      (lambda (fourth)
					(if (and (not (= first fourth))
						 (not (= second fourth))
						 (not (= third fourth)))
					    (for-each
					     (lambda (fifth)
					       (if (and (not (= first fifth))
							(not (= second fifth))
							(not (= third fifth))
							(not (= fourth fifth))
							(let ((val (+ k
								      (if (or (= first 5) (= first 6)) 1 0)
								      (if (or (= second 5) (= second 6)) 1 0)
								      (if (or (= third 5) (= third 6)) 1 0)
								      (if (or (= fourth 5) (= fourth 6)) 1 0)
								      (if (or (= fifth 5) (= fifth 6)) 1 0))))
							  (not (> val 2))))
						   (begin
						     (set! scalers '())
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (op first)
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (op second)
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (op third)
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (op fourth)
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (op fifth)
						     (set! scl (+ .5 (random 1.0)))
						     (scale-by scl)
						     (set! scalers (cons scl scalers))
						     (set! vals1 (channel->vct 0 100 ind 0))
						     (let ((rvals (reversed-channel->vct 0 100 ind 0)))
						       (if (not (vequal rvals vals1))
							   (snd-display #__line__ ";4 virtual op reversed tests: ~A(~A(~A(~A(~A~A)))) * ~A: ~A ~A => ~A"
									(op-name fifth) (op-name fourth) (op-name third) (op-name second) (op-name first)
									(if (= k 1) "(ptree_zero)" "")
									scalers vals1 rvals
									(vct-peak (vct-subtract! (vct-copy vals1) rvals)))))
						     (set! (edit-position ind 0) edpos)
						     (set! (optimization) 0)
						     (set! scalers (reverse scalers))
						     (set! saved-scalers scalers)
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (if (= first 5) (map1) (if (= first 6) (map2) (op first)))
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (if (= second 5) (map1) (if (= second 6) (map2) (op second)))
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (if (= third 5) (map1) (if (= third 6) (map2) (op third)))
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (if (= fourth 5) (map1) (if (= fourth 6) (map2) (op fourth)))
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (if (= fifth 5) (map1) (if (= fifth 6) (map2) (op fifth)))
						     (scale-by (car scalers)) (set! scalers (cdr scalers))
						     (set! (optimization) oldopt)
						     (set! vals2 (channel->vct 0 100 ind 0))
						     (if (not (vequal vals1 vals2)) 
							 (snd-display #__line__ ";4 virtual op tests: ~A * ~A(~A(~A(~A(~A~A)))): ~A ~A => ~A at ~A"
								      saved-scalers
								      (op-name fifth) (op-name fourth) (op-name third) (op-name second) (op-name first)
								      (if (= k 1) "(ptree_zero)" "") 
								      vals1 vals2
								      (vct-peak (vct-subtract! (vct-copy vals1) vals2))
								      (let* ((pks (vct-subtract! (vct-copy vals1) vals2))
									     (pk (abs (vct-ref pks 0)))
									     (loc 0))
									(do ((i 1 (+ 1 i)))
									    ((= i 100) (list loc (vct-ref pks loc) (vct-ref vals1 loc) (vct-ref vals2 loc)))
									  (if (> (abs (vct-ref pks i)) pk)
									      (begin
										(set! loc i)
										(set! pk (abs (vct-ref pks i)))))))
								      ))
						     (let ((rvals (reversed-channel->vct 0 100 ind 0)))
						       (if (not (vequal rvals vals2))
							   (snd-display #__line__ ";4 virtual op reversed tests (2): ~A(~A(~A(~A(~A~A)))) * ~A: ~A ~A => ~A"
									(op-name fifth) (op-name fourth) (op-name third) (op-name second) (op-name first)
									(if (= k 1) "(ptree_zero)" "")
									saved-scalers vals2 rvals
									(vct-peak (vct-subtract! (vct-copy vals2) rvals)))))
						     (set! (edit-position ind 0) edpos))))
					     op5)))
				      op4)))
			       op3)))
			op2))
		     op1)))
	      
	      (if all-args
		  (let ((op1 (list 0 3 5))
			(op2 (list 0 1 3 4 5 6))
			(op3 (list 0 1 2 3 4 5 6))
			(op4 (list 0 1 2 3 4 5 6))
			(op5 (list 7 3 5))
			(op6 (list 0 1 2 3 4 5 6 7)))
		    (for-each
		     (lambda (first)
		       (for-each 
			(lambda (second)
			  (if (not (= first second))
			      (for-each
			       (lambda (third)
				 (if (and (not (= first third))
					  (not (= second third)))
				     (for-each
				      (lambda (fourth)
					(if (and (not (= first fourth))
						 (not (= second fourth))
						 (not (= third fourth)))
					    (for-each
					     (lambda (fifth)
					       (if (and (not (= first fifth))
							(not (= second fifth))
							(not (= third fifth))
							(not (= fourth fifth)))
						   (for-each
						    (lambda (sixth)
						      (if (and (not (= first sixth))
							       (not (= second sixth))
							       (not (= third sixth))
							       (not (= fourth sixth))
							       (not (= fifth sixth))
							       (let ((val (+ k
									     (if (or (= first 5) (= first 6)) 1 0)
									     (if (or (= second 5) (= second 6)) 1 0)
									     (if (or (= third 5) (= third 6)) 1 0)
									     (if (or (= fourth 5) (= fourth 6)) 1 0)
									     (if (or (= fifth 5) (= fifth 6)) 1 0)
									     (if (or (= sixth 5) (= sixth 6)) 1 0))))
								 (not (> val 2)))
							       (let ((val (+ (if (member first (list 0 1 2 3 4 7)) 1 0)
									     (if (member second (list 0 1 2 3 4 7)) 1 0)
									     (if (member third (list 0 1 2 3 4 7)) 1 0)
									     (if (member fourth (list 0 1 2 3 4 7)) 1 0)
									     (if (member fifth (list 0 1 2 3 4 7)) 1 0)
									     (if (member sixth (list 0 1 2 3 4 7)) 1 0))))
								 (not (> val 4))))
							  (begin
							    (set! scalers '())
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op first)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op second)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op third)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op fourth)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op fifth)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (op sixth)
							    (set! scl (+ .5 (random 1.0)))
							    (scale-by scl)
							    (set! scalers (cons scl scalers))
							    (set! vals1 (channel->vct 0 100 ind 0))
							    (let ((rvals (reversed-channel->vct 0 100 ind 0)))
							      (if (not (vequal rvals vals1))
								  (snd-display #__line__ ";5 virtual op reversed tests: ~A(~A(~A(~A(~A(~A~A))))) * ~A: ~A ~A => ~A"
									       (op-name sixth) (op-name fifth) (op-name fourth) 
									       (op-name third) (op-name second) (op-name first)
									       (if (= k 1) "(ptree_zero)" "")
									       scalers vals1 rvals
									       (vct-peak (vct-subtract! (vct-copy vals1) rvals)))))
							    (set! (edit-position ind 0) edpos)
							    (set! (optimization) 0)
							    (set! scalers (reverse scalers))
							    (set! saved-scalers scalers)
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= first 5) (map1) (if (= first 6) (map2) (op first)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= second 5) (map1) (if (= second 6) (map2) (op second)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= third 5) (map1) (if (= third 6) (map2) (op third)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= fourth 5) (map1) (if (= fourth 6) (map2) (op fourth)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= fifth 5) (map1) (if (= fifth 6) (map2) (op fifth)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (if (= sixth 5) (map1) (if (= sixth 6) (map2) (op sixth)))
							    (scale-by (car scalers)) (set! scalers (cdr scalers))
							    (set! (optimization) oldopt)
							    (set! vals2 (channel->vct 0 100 ind 0))
							    (if (not (vequal vals1 vals2)) 
								(snd-display #__line__ ";5 virtual op tests: ~A * ~A(~A(~A(~A(~A(~A~A))))): ~A ~A => ~A at ~A"
									     saved-scalers
									     (op-name sixth) (op-name fifth) (op-name fourth) 
									     (op-name third) (op-name second) (op-name first)
									     (if (= k 1) "(ptree_zero)" "") 
									     vals1 vals2
									     (vct-peak (vct-subtract! (vct-copy vals1) vals2))
									     (let* ((pks (vct-subtract! (vct-copy vals1) vals2))
										    (pk (abs (vct-ref pks 0)))
										    (loc 0))
									       (do ((i 1 (+ 1 i)))
										   ((= i 100) (list loc (vct-ref pks loc) (vct-ref vals1 loc) (vct-ref vals2 loc)))
										 (if (> (abs (vct-ref pks i)) pk)
										     (begin
										       (set! loc i)
										       (set! pk (abs (vct-ref pks i)))))))
									     ))
							    (let ((rvals (reversed-channel->vct 0 100 ind 0)))
							      (if (not (vequal rvals vals2))
								  (snd-display #__line__ ";5 virtual op reversed tests (2): ~A(~A(~A(~A(~A(~A~A))))) * ~A: ~A ~A => ~A"
									       (op-name sixth) (op-name fifth) (op-name fourth) 
									       (op-name third) (op-name second) (op-name first)
									       (if (= k 1) "(ptree_zero)" "")
									       saved-scalers vals2 rvals
									       (vct-peak (vct-subtract! (vct-copy vals2) rvals)))))
							    (set! (edit-position ind 0) edpos))))
						    op6)))
					     op5)))
				      op4)))
			       op3)))
			op2))
		     op1)))))
	  (close-sound ind))
	
	(if all-args ; include mix in cycling tests
	    (let ((old-ptrees (max-virtual-ptrees)))
	      
	      (set! (max-virtual-ptrees) 10)
	      
	      (letrec ((local-vequal (lambda (v0 v1 n)
				       (let ((old-fudge (mus-float-equal-fudge-factor)))
					 (set! (mus-float-equal-fudge-factor) (* n .001))
					 (let ((result (equal? v0 v1)))
					   (set! (mus-float-equal-fudge-factor) old-fudge)
					   result))))
		       
		       (add-1 (lambda (ind)
				(ptree-channel (lambda (y) (+ y 1.0)) 0 20 ind 0)
				(let ((data (channel->vct 0 20 ind 1)))
				  (vct-offset! data 1.0)
				  (vct->channel data 0 20 ind 1))))
		       
		       (ramp-1 (lambda (ind)
				 (ramp-channel 0 1.0 0 21 ind 0)
				 (let ((data (channel->vct 0 20 ind 1)))
				   (do ((i 0 (+ 1 i))
					(val 0 (+ val .05)))
				       ((= i 20))
				     (vct-set! data i (* (vct-ref data i) val)))
				   (vct->channel data 0 20 ind 1))))
		       
		       (mix-1 (lambda (ind)
				(let ((mdata (vct 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 -0.5)))
				  (mix-vct mdata 5 ind 0 #t)
				  (let ((data (channel->vct 5 10 ind 1)))
				    (vct-add! data mdata)
				    (vct->channel data 5 10 ind 1)))))
		       
		       (env-1 (lambda (ind)
				(env-channel '(0 0 1 1 2 1 3 0) 0 20 ind 0)
				(let ((e1 (vct 0.0 0.166667 0.333333 0.5 0.666667 0.833333 1.0 1.0 1.0 1.0 
					       1.0 1.0 1.0 1.0 0.833333 0.666667 0.5 0.333333 0.166667 0.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (env-2 (lambda (ind)
				(env-channel-with-base '(0 0 1 1 2 1 3 0) 8.0 0 20 ind 0)
				(let ((e1 (vct 0.0 0.059173 0.142857 0.261204 0.428571 0.665265 1.0 1.0 1.0 
					       1.0 1.0 1.0 1.0 1.0 0.665265 0.428571 0.261204 0.142857 0.059173 0.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (env-3 (lambda (ind)
				(env-channel '(0 1 1 0 2 0 3 1) 0 20 ind 0)
				(let ((e1 (vct 1.0 0.833333 0.666667 0.5 0.333333 0.166667 0.0 0.0 0.0 0.0 
					       0.0 0.0 0.0 0.0 0.166667 0.333333 0.5 0.666667 0.833333 1.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (env-4 (lambda (ind)
				(env-channel-with-base '(0 1 1 0 2 0 3 1) 8.0 0 20 ind 0)
				(let ((e1 (vct 1.0 0.665265 0.428571 0.261204 0.142857 0.059173 0.0 0.0 0.0 
					       0.0 0.0 0.0 0.0 0.0 0.059173 0.142857 0.261204 0.428571 0.665265 1.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (env-5 (lambda (ind)
				(env-channel '(0 1 1 .5 2 .5 3 1) 0 20 ind 0)
				(let ((e1 (vct 1.0 0.916667 0.833333 0.750000 0.666667 0.583333 0.5 0.5 0.5 
					       0.5 0.5 0.5 0.5 0.5 0.583333 0.666667 0.750000 0.833333 0.916667 1.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (env-6 (lambda (ind)
				(env-channel-with-base '(0 1 1 .5 2 .5 3 1) 8.0 0 20 ind 0)
				(let ((e1 (vct 1.0 0.832632 0.714286 0.630602 0.571429 0.529587 0.5 0.5 0.5 
					       0.5 0.5 0.5 0.5 0.5 0.529587 0.571429 0.630602 0.714286 0.832632 1.0))
				      (data (channel->vct 0 20 ind 1)))
				  (vct-multiply! data e1)
				  (vct->channel data 0 20 ind 1))))
		       
		       (set-1 (lambda (ind)
				(set! (sample 10 ind 0) -0.5)
				(let ((data (channel->vct 0 20 ind 1)))
				  (vct-set! data 10 -0.5)
				  (vct->channel data 0 20 ind 1))))
		       
		       (scl-1 (lambda (ind)
				(ptree-channel (lambda (y data forward)
						 (* y (vct-ref data 0)))
					       0 20 ind 0 #f #f
					       (lambda (pos dur)
						 (vct 0.625)))
				(scale-channel 0.625 0 20 ind 1)))
		       
		       (rvequal (lambda (ind name n)
				  (let ((r1 (make-sampler 19 ind 0 -1))
					(r2 (make-sampler 19 ind 1 -1))
					(v1 (make-vct 20))
					(v2 (make-vct 20)))
				    (do ((i 0 (+ 1 i)))
					((= i 20))
				      (vct-set! v1 i (r1))
				      (vct-set! v2 i (r2)))
				    (if (not (local-vequal v1 v2 n))
					(snd-display #__line__ ";!~A reversed: ~A ~A" name v1 v2))
				    (free-sampler r1)
				    (free-sampler r2)))))
		
		(let ((all-ops (list add-1 ramp-1 mix-1 env-1 env-2 env-3 env-4 env-5 env-6 set-1 scl-1))
		      (all-op-names (list 'add-1 'ramp-1 'mix-1 'env-1 'env-2 'env-3 'env-4 'env-5 'env-6 'set-1 'scl-1))
		      (two-ops (list add-1 ramp-1))
		      (two-op-names (list 'add-1 'ramp-1)))
		  
		  (let ((ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat)))
		    
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    (for-each ; check that they are the same
		     (lambda (op op-name)
		       (do ((k 0 (+ 1 k)))
			   ((= k 2))
			 (if (= k 1)
			     (vct->channel (make-vct 20 0.0) 0 20 ind 1)
			     (begin
			       (vct->channel (make-vct 20 1.0) 0 20 ind 0)
			       (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
			 (op ind)
			 (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
			     (snd-display #__line__ ";unequal: ~A by ~A (~A, ~A, ~A):~%; ~A~%; ~A~%;  ~A~%;  ~A" 
					  op-name 
					  (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) 
					  (mus-float-equal-fudge-factor) (mus-clipping) (mus-file-clipping ind)
					  (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 
					  (display-edits ind 0) (display-edits ind 1))
			     (rvequal ind op-name 1))
			 (revert-sound ind)))
		     all-ops all-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 2 ops
		    (for-each
		     (lambda (op2 op2-name)
		       (for-each
			(lambda (op1 op1-name)
			  (let ((op-name (format #f "~A(~A)" op2-name op1-name)))
			    (do ((k 0 (+ 1 k)))
				((= k 2))
			      (if (= k 1)
				  (vct->channel (make-vct 20 0.0) 0 20 ind 1)
				  (begin
				    (vct->channel (make-vct 20 1.0) 0 20 ind 0)
				    (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
			      (op1 ind)
			      (op2 ind)
			      (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
				  (snd-display #__line__ ";unequal: ~A~A by ~A (~A):~%; ~A~%; ~A~%;  ~A~%;  ~A"
					       op-name (if (= k 0) "[0]" "") 
					       (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor)
					       (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)
					       (display-edits ind 0) (display-edits ind 1))
				  (rvequal ind op-name 1))
			      (revert-sound ind))))
			all-ops all-op-names))
		     all-ops all-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 3 ops
		    (for-each
		     (lambda (op3 op3-name)
		       (for-each
			(lambda (op2 op2-name)
			  (for-each
			   (lambda (op1 op1-name)
			     (let ((op-name (format #f "~A(~A(~A))" op3-name op2-name op1-name)))
			       (do ((k 0 (+ 1 k)))
				   ((= k 2))
				 (if (= k 1)
				     (vct->channel (make-vct 20 0.0) 0 20 ind 1)
				     (begin
				       (vct->channel (make-vct 20 1.0) 0 20 ind 0)
				       (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
				 (op1 ind)
				 (op2 ind)
				 (op3 ind)
				 (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
				     (snd-display #__line__ ";unequal: ~A by ~A (~A):~%; ~A~%; ~A~%;  ~A~%;  ~A"
						  op-name 
						  (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor)
						  (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)
						  (display-edits ind 0) (display-edits ind 1))
				     (rvequal ind op-name 1))
				 (revert-sound ind))))
			   all-ops all-op-names))
			all-ops all-op-names))
		     all-ops all-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 4 ops
		    (for-each
		     (lambda (op4 op4-name)
		       (for-each
			(lambda (op3 op3-name)
			  (for-each
			   (lambda (op2 op2-name)
			     (for-each
			      (lambda (op1 op1-name)
				(let ((op-name (format #f "~A(~A(~A(~A)))" op4-name op3-name op2-name op1-name)))
				  (do ((k 0 (+ 1 k)))
				      ((= k 2))
				    (if (= k 1)
					(vct->channel (make-vct 20 0.0) 0 20 ind 1)
					(begin
					  (vct->channel (make-vct 20 1.0) 0 20 ind 0)
					  (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
				    (op1 ind)
				    (op2 ind)
				    (op3 ind)
				    (op4 ind)
				    (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
					(snd-display #__line__ ";unequal: ~A~A by ~A (~A):~%; ~A~%; ~A"
						     op-name (if (= k 0) "[0]" "") 
						     (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor)
						     (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1))
					(rvequal ind op-name 1))
				    (revert-sound ind))))
			      all-ops all-op-names))
			   all-ops all-op-names))
			all-ops all-op-names))
		     all-ops all-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 5 ops
		    (for-each
		     (lambda (op5 op5-name)
		       (for-each
			(lambda (op4 op4-name)
			  (for-each
			   (lambda (op3 op3-name)
			     (for-each
			      (lambda (op2 op2-name)
				(for-each
				 (lambda (op1 op1-name)
				   (let ((op-name (format #f "~A(~A(~A(~A(~A))))" op5-name op4-name op3-name op2-name op1-name)))
				     (do ((k 0 (+ 1 k)))
					 ((= k 2))
				       (if (= k 1)
					   (vct->channel (make-vct 20 0.0) 0 20 ind 1)
					   (begin
					     (vct->channel (make-vct 20 1.0) 0 20 ind 0)
					     (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
				       (op1 ind)
				       (op2 ind)
				       (op3 ind)
				       (op4 ind)
				       (op5 ind)
				       (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
					   (snd-display #__line__ ";unequal: ~A by ~A (~A),  ~A in ~A:~%; ~A~%; ~A" 
							op-name
							(vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor) 
							(map (lambda (lst) (edit-fragment-type-name (list-ref lst 7))) (edit-tree ind 0))
							(edit-tree ind 0)
							(channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1))
					   (rvequal ind op-name 1))
				       (revert-sound ind))))
				 all-ops all-op-names))
			      all-ops all-op-names))
			   all-ops all-op-names))
			all-ops all-op-names))
		     all-ops all-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 6 ops
		    (for-each
		     (lambda (op6 op6-name)
		       (for-each
			(lambda (op5 op5-name)
			  (for-each
			   (lambda (op4 op4-name)
			     (for-each
			      (lambda (op3 op3-name)
				(for-each
				 (lambda (op2 op2-name)
				   (for-each
				    (lambda (op1 op1-name)
				      (let ((op-name (format #f "~A(~A(~A(~A(~A(~A)))))" op6-name op5-name op4-name op3-name op2-name op1-name)))
					(do ((k 0 (+ 1 k)))
					    ((= k 2))
					  (if (= k 1)
					      (vct->channel (make-vct 20 0.0) 0 20 ind 1)
					      (begin
						(vct->channel (make-vct 20 1.0) 0 20 ind 0)
						(vct->channel (make-vct 20 1.0) 0 20 ind 1)))
					  (op1 ind)
					  (op2 ind)
					  (op3 ind)
					  (op4 ind)
					  (op5 ind)
					  (op6 ind)
					  (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
					      (snd-display #__line__ ";unequal: ~A by ~A (~A):~%; ~A~%; ~A" 
							   op-name 
							   (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor) 
							   (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1))
					      (rvequal ind op-name 1))
					  (revert-sound ind))))
				    two-ops two-op-names))
				 all-ops all-op-names))
			      all-ops all-op-names))
			   all-ops all-op-names))
			all-ops all-op-names))
		     two-ops two-op-names)
		    
		    (close-sound ind)
		    (set! ind (new-sound "test.snd" :size 20 :channels 2 :data-format mus-lfloat))
		    (set! (squelch-update ind 0) #t)
		    (set! (squelch-update ind 1) #t)
		    
		    ;; 7 ops
		    (for-each
		     (lambda (op7 op7-name)
		       (for-each
			(lambda (op6 op6-name)
			  (for-each
			   (lambda (op5 op5-name)
			     (for-each
			      (lambda (op4 op4-name)
				(for-each
				 (lambda (op3 op3-name)
				   (for-each
				    (lambda (op2 op2-name)
				      (for-each
				       (lambda (op1 op1-name)
					 (let ((op-name (format #f "~A(~A(~A(~A(~A(~A(~A))))))" op7-name op6-name op5-name op4-name op3-name op2-name op1-name)))
					   (do ((k 0 (+ 1 k)))
					       ((= k 2))
					     (if (= k 1)
						 (vct->channel (make-vct 20 0.0) 0 20 ind 1)
						 (begin
						   (vct->channel (make-vct 20 1.0) 0 20 ind 0)
						   (vct->channel (make-vct 20 1.0) 0 20 ind 1)))
					     (op1 ind)
					     (op2 ind)
					     (op3 ind)
					     (op4 ind)
					     (op5 ind)
					     (op6 ind)
					     (op7 ind)
					     (if (not (local-vequal (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1) 1))
						 (snd-display #__line__ ";unequal: ~A by ~A (~A):~%; ~A~%; ~A" 
							      op-name 
							      (vmaxdiff (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1)) (mus-float-equal-fudge-factor) 
							      (channel->vct 0 20 ind 0) (channel->vct 0 20 ind 1))
						 (rvequal ind op-name 1))
					     (revert-sound ind))))
				       two-ops two-op-names))
				    all-ops all-op-names))
				 all-ops all-op-names))
			      all-ops all-op-names))
			   two-ops two-op-names))
			two-ops two-op-names))
		     two-ops two-op-names)
		    
		    (set! (squelch-update ind 0) #f)
		    (set! (squelch-update ind 1) #f)
		    (set! (max-virtual-ptrees) old-ptrees)
		    
		    (if (and (provided? 'snd-motif)
			     (provided? 'xm))
			(let* ((edhist (list-ref (channel-widgets ind 0) 7))
			       (edp (XtParent edhist)))
			  (XtUnmanageChild edp) 
			  (XtVaSetValues edp (list XmNpaneMinimum 1))  ; not 0 here -- Xt warnings
			  (XtManageChild edp)))
		    
		    (close-sound ind)))
		)))))
    
    (let ((ind (open-sound "oboe.snd")))
      
      ;; simple cases
      
      (as-one-edit
       (lambda ()
	 (set! (sample 10) 1.0)))
      (if (fneq (sample 10) 1.0) (snd-display #__line__ ";as-one-edit 1: ~A" (sample 10)))
      (if (not (= (edit-position ind 0) 1)) 
	  (snd-display #__line__ ";as-one-edit 1 edpos: ~A" (edit-position ind 0))
	  (begin
	    (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
		(snd-display #__line__ ";as-one-edit 1 edlist: ~A" (edit-fragment 1 ind 0)))
	    (if (not (equal? (edit-fragment 0 ind 0) (list #f "init" 0 50828)))
		(snd-display #__line__ ";as-one-edit 1 original edlist: ~A" (edit-fragment 0 ind 0)))))
      
      (revert-sound ind)
      (as-one-edit
       (lambda ()
	 (set! (sample 10) 1.0)
	 (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit")
	 (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 2 edpos internal: ~A" (edit-position ind 0))))
       "as-one-edit test-2")
      (if (fneq (sample 10) 2.0) (snd-display #__line__ ";as-one-edit 2: ~A" (sample 10)))
      (if (not (= (edit-position ind 0) 1)) 
	  (snd-display #__line__ ";as-one-edit 2 edpos: ~A" (edit-position ind 0))
	  (begin
	    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-2" "set" 0 21)))
		(snd-display #__line__ ";as-one-edit 2 edlist: ~A" (edit-fragment 1 ind 0)))
	    (if (not (equal? (edit-fragment 0 ind 0) (list #f "init" 0 50828)))
		(snd-display #__line__ ";as-one-edit 2 original edlist: ~A" (edit-fragment 0 ind 0)))))
      
      (revert-sound ind)
      (let ((ind2 (open-sound "2a.snd")))
	(set! (sample 1 ind2 0) 1.0)
	(set! (sample 2 ind2 1) 0.5)
	(set! (selected-sound) ind)
	
	(as-one-edit
	 (lambda ()
	   (set! (sample 10 ind 0) 1.0)))
	(if (fneq (sample 10 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 3: ~A" (sample 10 ind 0)))
	(if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 3 edpos: ~A" (edit-position ind 0)))
	(if (not (= (edit-position ind2 0) 1)) (snd-display #__line__ ";as-one-edit 3 2 edpos: ~A" (edit-position ind2 0)))
	(if (not (= (edit-position ind2 1) 1)) (snd-display #__line__ ";as-one-edit 3 2 1 edpos: ~A" (edit-position ind2 1)))
	(if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	    (snd-display #__line__ ";as-one-edit 3 edlist: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 1 1.0000" "set" 1 1)))
	    (snd-display #__line__ ";as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
	(if (not (equal? (edit-fragment 1 ind2 1) (list "set-sample 2 0.5000" "set" 2 1)))
	    (snd-display #__line__ ";as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
	
	(revert-sound ind)
	
	(as-one-edit    
	 (lambda ()
	   (set! (sample 10 ind 0) 1.0)
	   (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 2")
	   (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 4 edpos internal: ~A" (edit-position ind 0))))
	 "as-one-edit test-4")
	(if (fneq (sample 10) 2.0) (snd-display #__line__ ";as-one-edit 4: ~A" (sample 10 ind 0)))
	(if (not (= (edit-position ind 0) 1)) 
	    (snd-display #__line__ ";as-one-edit 4 edpos: ~A" (edit-position ind 0))
	    (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-4" "set" 0 21)))
		(snd-display #__line__ ";as-one-edit 4 edlist: ~A" (edit-fragment 1 ind 0))))
	(if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 1 1.0000" "set" 1 1)))
	    (snd-display #__line__ ";as-one-edit 3 2 edlist: ~A" (edit-fragment 1 ind2 0)))
	(if (not (equal? (edit-fragment 1 ind2 1) (list "set-sample 2 0.5000" "set" 2 1)))
	    (snd-display #__line__ ";as-one-edit 3 2 1 edlist: ~A" (edit-fragment 1 ind2 1)))
	
	(revert-sound ind)
	(set! (sample 3 ind 0) 1.0)
	
	(as-one-edit
	 (lambda ()
	   (set! (sample 10 ind 0) 1.0)
	   (set! (sample 10 ind2 0) 0.5)
	   (set! (sample 10 ind2 1) 0.4)))
	(if (fneq (sample 3 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 5 (3): ~A" (sample 3 ind 0)))
	(if (fneq (sample 10 ind 0) 1.0) (snd-display #__line__ ";as-one-edit 5 (10): ~A" (sample 10 ind 0)))
	(if (fneq (sample 10 ind2 0) 0.5) (snd-display #__line__ ";as-one-edit 5 (2 10): ~A" (sample 10 ind2 0)))
	(if (fneq (sample 10 ind2 1) 0.4) (snd-display #__line__ ";as-one-edit 5 (2 1 10): ~A" (sample 10 ind2 1)))
	(if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit 5 edpos: ~A" (edit-position ind 0)))
	(if (not (= (edit-position ind2 0) 2)) (snd-display #__line__ ";as-one-edit 5 2 edpos: ~A" (edit-position ind2 0)))
	(if (not (= (edit-position ind2 1) 2)) (snd-display #__line__ ";as-one-edit 5 2 1 edpos: ~A" (edit-position ind2 1)))
	
	(if (not (equal? (edit-fragment 2 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	    (snd-display #__line__ ";as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 3 1.0000" "set" 3 1)))
	    (snd-display #__line__ ";as-one-edit 5 edlist 1: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 0 ind 0) (list #f "init" 0 50828)))
	    (snd-display #__line__ ";as-one-edit 5 original edlist: ~A" (edit-fragment 0 ind 0)))
	(if (not (equal? (edit-fragment 2 ind2 0) (list "set-sample 10 0.5000" "set" 10 1)))
	    (snd-display #__line__ ";as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
	
	(as-one-edit
	 (lambda ()
	   (map-channel (lambda (y) (* y 2.0)) 0 20 ind 0 #f "map-channel as-one-edit 6")
	   (map-channel (lambda (y) (* y 2.0)) 0 20 ind2 1 #f "map-channel as-one-edit 6 2 1"))
	 "as-one-edit test-6")
	
	
	(if (fneq (sample 3 ind 0) 2.0) (snd-display #__line__ ";as-one-edit 6 (3): ~A" (sample 3 ind 0)))
	(if (fneq (sample 10 ind 0) 2.0) (snd-display #__line__ ";as-one-edit 6 (10): ~A" (sample 10 ind 0)))
	(if (fneq (sample 10 ind2 0) 0.5) (snd-display #__line__ ";as-one-edit 6 (2 10): ~A" (sample 10 ind2 0)))
	(if (fneq (sample 10 ind2 1) 0.8) (snd-display #__line__ ";as-one-edit 6 (2 1 10): ~A" (sample 10 ind2 1)))
	(if (not (= (edit-position ind 0) 3)) (snd-display #__line__ ";as-one-edit 6 edpos: ~A" (edit-position ind 0)))
	(if (not (= (edit-position ind2 0) 2)) (snd-display #__line__ ";as-one-edit 6 2 edpos: ~A" (edit-position ind2 0)))
	(if (not (= (edit-position ind2 1) 3)) (snd-display #__line__ ";as-one-edit 6 2 1 edpos: ~A" (edit-position ind2 1)))
	
	(if (not (equal? (edit-fragment 2 ind 0) (list "set-sample 10 1.0000" "set" 10 1)))
	    (snd-display #__line__ ";as-one-edit 5 edlist 2: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 2 ind2 0) (list "set-sample 10 0.5000" "set" 10 1)))
	    (snd-display #__line__ ";as-one-edit 5 edlist 2 1: ~A" (edit-fragment 1 ind2 0)))
	(if (not (equal? (edit-fragment 3 ind 0) (list "as-one-edit test-6" "set" 0 20)))
	    (snd-display #__line__ ";as-one-edit 6 edlist: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 3 ind2 1) (list "as-one-edit test-6" "set" 0 20)))
	    (snd-display #__line__ ";as-one-edit 6 edlist 2 1: ~A" (edit-fragment 1 ind2 1)))
	(close-sound ind2))
      
      ;; nested cases
      (revert-sound ind)
      
      (as-one-edit
       (lambda ()
	 (set! (sample 100) .9)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200) .8)
	    (set! (sample 300) .7)))
	 (set! (sample 300) .6)))
      (if (or (fneq (sample 100) .9)
	      (fneq (sample 200) .8)
	      (fneq (sample 300) .6))
	  (snd-display #__line__ ";nested as-one-edit 7: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
      (if (not (= (edit-position ind 0) 1))
	  (snd-display #__line__ ";nested as-one-edit 7 edpos: ~A" (edit-position ind 0)))
      (if (squelch-update ind 0)
	  (begin
	    (snd-display #__line__ ";nested as-one-edit 7 squelch is on")
	    (set! (squelch-update) #f)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "set-sample 300 0.6000" "set" 100 204)))
	  (snd-display #__line__ ";as-one-edit 7 edlist: ~A" (edit-fragment 1 ind 0)))
      
      (revert-sound ind)
      (as-one-edit
       (lambda ()
	 (set! (sample 100) .9)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200) .8)
	    (set! (sample 300) .7)))
	 (set! (sample 300) .6))
       "as-one-edit test-8")
      (if (or (fneq (sample 100) .9)
	      (fneq (sample 200) .8)
	      (fneq (sample 300) .6))
	  (snd-display #__line__ ";nested as-one-edit 8: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
      (if (not (= (edit-position ind 0) 1))
	  (snd-display #__line__ ";nested as-one-edit 8 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-8" "set" 100 204)))
	  (snd-display #__line__ ";as-one-edit 8 edlist: ~A" (edit-fragment 1 ind 0)))
      
      (revert-sound ind)
      (as-one-edit
       (lambda ()
	 (set! (sample 100) .9)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200) .8)
	    (set! (sample 300) .7))
	  "as-one-edit 9 internal")
	 (set! (sample 300) .6))
       "as-one-edit test-9")
      (if (or (fneq (sample 100) .9)
	      (fneq (sample 200) .8)
	      (fneq (sample 300) .6))
	  (snd-display #__line__ ";nested as-one-edit 9: ~A ~A ~A" (sample 100) (sample 200) (sample 300)))
      (if (not (= (edit-position ind 0) 1))
	  (snd-display #__line__ ";nested as-one-edit 9 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-9" "set" 100 204)))
	  (snd-display #__line__ ";as-one-edit 9 edlist: ~A" (edit-fragment 1 ind 0)))
      
      (revert-sound ind)
      (as-one-edit
       (lambda ()
	 (set! (sample 100) .9)
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200) .8)
	    (as-one-edit
	     (lambda ()
	       (set! (sample 400) .3))
	     "not a name")
	    (set! (sample 300) .7))
	  "as-one-edit 10 internal")
	 (set! (sample 300) .6))
       "as-one-edit test-10")
      (if (or (fneq (sample 100) .9)
	      (fneq (sample 200) .8)
	      (fneq (sample 300) .6)
	      (fneq (sample 400) .3))
	  (snd-display #__line__ ";nested as-one-edit 10: ~A ~A ~A ~A" (sample 100) (sample 200) (sample 300) (sample 400)))
      (if (not (= (edit-position ind 0) 1))
	  (snd-display #__line__ ";nested as-one-edit 10 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit test-10" "set" 100 305)))
	  (snd-display #__line__ ";as-one-edit 10 edlist: ~A" (edit-fragment 1 ind 0)))
      
      ;; try implicit as-one-edits nested
      (revert-sound ind)
      (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0)
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 11 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) 
		       (list "env-channel-with-base '(0.000 0.000 1.000 1.000 2.000 0.500 3.000 0.250 4.000 0.000) 0.0000 0 #f" "scale" 0 50830)))
	  (snd-display #__line__ ";as-one-edit 11: ~A" (edit-fragment 1 ind 0)))
      
      (revert-sound ind)
      (as-one-edit
       (lambda ()
	 (env-channel-with-base '(0 0 1 1 2 .5 3 .25 4 0) 0.0 0 #f ind 0))
       "as-one-edit 12")
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit 12 edpos: ~A" (edit-position ind 0)))
      (if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit 12" "scale" 0 50830)))
	  (snd-display #__line__ ";as-one-edit 12: ~A" (edit-fragment 1 ind 0)))
      
      (revert-sound ind)
      (let ((m1 #f)
	    (m2 #f)
	    (m3 #f)
	    (m4 #f))
	(as-one-edit
	 (lambda ()
	   (set! m1 (add-mark 1234 ind 0))
	   (set! (sample 1236 ind 0) .6)
	   (as-one-edit
	    (lambda ()
	      (set! (sample 123 ind 0) .3)
	      (set! m2 (add-mark 1235 ind 0)))
	    "as-one-edit inner 1")
	   (if (not (mark? m1)) (snd-display #__line__ ";as-one-edit stepped on m1: ~A" m1))
	   (if (not (mark? m2)) (snd-display #__line__ ";as-one-edit stepped on m2: ~A" m2))
	   (as-one-edit
	    (lambda ()
	      (set! m3 (add-mark 1238 ind 0))
	      (set! (sample 1238 ind 0) .8))
	    "as-one-edit inner 2")
	   (set! (sample 1239 ind 0) .9)
	   (set! m4 (add-mark 1237 ind 0)))
	 "outer as-one-edit")
	(if (not (mark? m1)) (snd-display #__line__ ";2nd as-one-edit stepped on m1: ~A" m1))
	(if (not (mark? m2)) (snd-display #__line__ ";2nd as-one-edit stepped on m2: ~A" m2))
	(if (not (mark? m3)) (snd-display #__line__ ";2nd as-one-edit stepped on m3: ~A" m3))
	(if (not (mark? m4)) (snd-display #__line__ ";2nd as-one-edit stepped on m4: ~A" m4))
	(if (not (= (mark-sample m1) 1234)) (snd-display #__line__ ";as-one-edit m1 sample: ~A (1234)" (mark-sample m1)))
	(if (not (= (mark-sample m2) 1235)) (snd-display #__line__ ";as-one-edit m2 sample: ~A (1235)" (mark-sample m2)))
	(if (not (= (mark-sample m3) 1238)) (snd-display #__line__ ";as-one-edit m3 sample: ~A (1238)" (mark-sample m3)))
	(if (not (= (mark-sample m4) 1237)) (snd-display #__line__ ";as-one-edit m4 sample: ~A (1237)" (mark-sample m4)))
	(if (not (string=? (display-edits ind 0) (string-append "
EDITS: 1

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 123 1120) ; outer as-one-edit [1:9]:
   (at 0, cp->sounds[0][0:122, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 123, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 124, cp->sounds[0][124:1235, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1236, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 1237, cp->sounds[0][1237:1237, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 1238, cp->sounds[3][0:0, 1.000]) [buf: 1] 
   (at 1239, cp->sounds[4][0:0, 1.000]) [buf: 1] 
   (at 1240, cp->sounds[0][1240:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	    (snd-display #__line__ ";as-one-edit edits: ~A" (display-edits ind 0)))
	
	(revert-sound ind))
      
      (let ((m1 #f)
	    (m2 #f)
	    (m3 #f)
	    (m4 #f))
	(as-one-edit
	 (lambda ()
	   (set! m1 (mix-vct (vct .1 .2 .3) 1234 ind 0))
	   (set! (sample 1236 ind 0) .6)
	   (as-one-edit
	    (lambda ()
	      (set! (sample 123 ind 0) .3)
	      (set! m2 (mix-vct (vct .1 .2 .3) 1235 ind 0)))
	    "as-one-edit inner 1")
	   (if (not (mix? m1)) (snd-display #__line__ ";as-one-edit stepped on m1: ~A" m1))
	   (if (not (mix? m2)) (snd-display #__line__ ";as-one-edit stepped on m2: ~A" m2))
	   (as-one-edit
	    (lambda ()
	      (set! m3 (mix-vct (vct .1 .2 .3) 1238 ind 0))
	      (set! (sample 1238 ind 0) .8))
	    "as-one-edit inner 2")
	   (set! (sample 1239 ind 0) .9)
	   (set! m4 (mix-vct (vct .1 .2 .3) 1237 ind 0)))
	 "outer as-one-edit")
	(if (not (mix? m1)) (snd-display #__line__ ";2nd as-one-edit stepped on mx1: ~A" m1))
	(if (not (mix? m2)) (snd-display #__line__ ";2nd as-one-edit stepped on mx2: ~A" m2))
	(if (not (mix? m3)) (snd-display #__line__ ";2nd as-one-edit stepped on mx3: ~A" m3))
	(if (not (mix? m4)) (snd-display #__line__ ";2nd as-one-edit stepped on mx4: ~A" m4))
	(revert-sound ind))
      
      (let ((ind2 #f))
	(as-one-edit
	 (lambda ()
	   (set! ind2 (open-sound "pistol.snd"))
	   (set! (sample 100 ind 0) .5)
	   (set! (sample 200 ind2 0) .6))
	 "as-one-edit+open")
	(if (not (sound? ind2)) (snd-display #__line__ ";as-one-edit didn't open sound? ~A ~A" ind2 (sounds)))
	(if (not (= (edit-position ind2 0) 1)) (snd-display #__line__ ";edpos as-one-edit opened sound: ~A" (edit-position ind2 0)))
	(if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";edpos as-one-edit original sound: ~A" (edit-position ind 0)))
	(if (not (equal? (edit-fragment 1 ind 0) (list "as-one-edit+open" "set" 100 1)))
	    (snd-display #__line__ ";as-one-edit open sound edlist orig: ~A" (edit-fragment 1 ind 0)))
	(if (not (equal? (edit-fragment 1 ind2 0) (list "set-sample 200 0.6000" "set" 200 1)))
	    (snd-display #__line__ ";as-one-edit open sound edlist new: ~A" (edit-fragment 1 ind2 0)))
	
	(as-one-edit
	 (lambda ()
	   (set! (sample 200 ind 0) .7)
	   (close-sound ind2))
	 "as-one-edit+close")
	(if (sound? ind2) 
	    (begin
	      (snd-display #__line__ ";as-one-edit didn't close sound? ~A ~A" ind2 (sounds))
	      (close-sound ind2)))
	(if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";edpos as-one-edit close original sound: ~A" (edit-position ind 0)))
	(if (not (string=? (display-edits ind 0) (string-append "
EDITS: 2

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 100 1) ; as-one-edit+open [1:4]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)

 (set 200 1) ; as-one-edit+close [2:6]:
   (at 0, cp->sounds[0][0:99, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 100, cp->sounds[1][0:0, 1.000]) [buf: 1] 
   (at 101, cp->sounds[0][101:199, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 200, cp->sounds[2][0:0, 1.000]) [buf: 1] 
   (at 201, cp->sounds[0][201:50827, 1.000]) [file: " cwd "oboe.snd[0]]
   (at 50828, end_mark)
")))
	    (snd-display #__line__ ";as-one-edit open+close: ~A" (display-edits ind 0))))
      
      (close-sound ind))  
    
    (let ((ind1 (open-sound "oboe.snd"))
	  (ind2 #f))
      (as-one-edit 
       (lambda ()
	 (set! (sample 100 ind1 0) .5)
	 (set! ind2 (open-sound "pistol.snd"))
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200 ind2 0) .5)
	    (close-sound ind1))
	  "inner edit")
	 (set! (sample 300 ind2 0) .6))
       "outer edit")
      (if (sound? ind1) (snd-display #__line__ ";as-one-edit close inner: ~A ~A" ind1 (sounds)))
      (if (not (sound? ind2)) (snd-display #__line__ ";as-one-edit open inner: ~A ~A" ind2 (sounds)))
      
      (revert-sound ind2)
      (as-one-edit
       (lambda ()
	 (set! ind1 (open-sound "oboe.snd"))
	 (as-one-edit
	  (lambda ()
	    (set! (sample 200 ind1 0) .5))
	  "inner edit")
	 (set! (sample 100 ind2 0) .4))
       "outer edit")
      (close-sound ind1)
      (close-sound ind2))
    
    (let* ((ind (open-sound "oboe.snd"))
	   (mx (maxamp ind 0)))
      (as-one-edit
       (lambda ()
	 (ptree-channel (lambda (y) (* y 2)))
	 (env-sound '(0 0 1 1))))
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit env+ptree pos: ~A" (edit-position ind 0)))
      (if (fneq (maxamp ind 0) .1825) (snd-display #__line__ ";as-one-edit env+ptree max: ~A" (maxamp ind 0)))
      (undo)
      (let ((tag (catch #t
			(lambda () (as-one-edit (lambda (oops) #f)))
			(lambda args (car args)))))
	(if (not (eq? tag 'bad-arity))
	    (snd-display #__line__ ";as-one-edit arg? ~A" tag)))
      (let ((tag (catch #t
			(lambda () (as-one-edit (lambda* (oops) #f)))
			(lambda args (car args)))))
	(if (not (eq? tag 'bad-arity))
	    (snd-display #__line__ ";as-one-edit arg? ~A" tag)))
      (as-one-edit
       (lambda ()
	 (ptree-channel (lambda (y) (* y 2)))
	 (ptree-channel (lambda (y) (* y 2)))))
      (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";as-one-edit ptree+ptree pos: ~A" (edit-position ind 0)))
      (if (fneq (maxamp ind 0) (* 4 mx)) (snd-display #__line__ ";as-one-edit ptree+ptree max: ~A ~A" (maxamp ind 0) (* 4 mx)))
      (close-sound ind))
    (let ((ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "ptree tests" 10)))
      ;; offset-channel
      (offset-channel .1)
      (if (not (vequal (channel->vct 0 10) (make-vct 10 .1)))
	  (snd-display #__line__ ";offset-channel (.1): ~A" (channel->vct 0 10)))
      (offset-channel -.2 5 5)
      (if (not (vequal (channel->vct 0 10) (vct .1 .1 .1 .1 .1 -.1 -.1 -.1 -.1 -.1)))
	  (snd-display #__line__ ";offset-channel (-.1): ~A" (channel->vct 0 10)))
      (undo)
      (offset-channel .9 0 10 ind 0)
      (if (not (vequal (channel->vct 0 10) (make-vct 10 1.0)))
	  (snd-display #__line__ ";offset-channel (1): ~A" (channel->vct 0 10)))
      ;; sine-env and sine-ramp...
      (revert-sound ind)
      (map-channel (lambda (y) 1.0))
      (sine-ramp 0.0 1.0)
      (if (not (vequal (channel->vct) (vct 0.000 0.024 0.095 0.206 0.345 0.500 0.655 0.794 0.905 0.976)))
	  (snd-display #__line__ ";sine-ramp 0 1: ~A" (channel->vct)))
      (revert-sound ind)
      (offset-channel 1.0)
      (sine-ramp 1.0 0.0)
      (if (not (vequal (channel->vct) (vct 1.000 0.976 0.905 0.794 0.655 0.500 0.345 0.206 0.095 0.024)))
	  (snd-display #__line__ ";sine-ramp 1 0: ~A" (channel->vct)))
      (if (> (optimization) 0)
	  (if (not (string=? (edit-fragment-type-name (list-ref (car (edit-tree)) 7)) "ed_ptree_zero"))
	      (snd-display #__line__ ";sine-ramp tree op: ~A ~A" (edit-fragment-type-name (list-ref (car (edit-tree)) 7)) (edit-tree))))
      (close-sound ind)
      (set! ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "sine-env tests" 100))
      (map-channel (lambda (y) 1.0))
      (sine-env-channel '(0 0 1 1 2 -.5 3 1))
      (if (or (not (vequal (channel->vct 20 10) (vct 0.664 0.708 0.750 0.790 0.827 0.862 0.893 0.921 0.944 0.964)))
	      (not (vequal (channel->vct 60 10) (vct -0.381 -0.417 -0.446 -0.470 -0.486 -0.497 -0.500 -0.497 -0.486 -0.470))))
	  (snd-display #__line__ ";sine-env-channel 0: ~A ~A" (channel->vct 20 10) (channel->vct 60 10)))
      (if (not (= (edit-position ind 0) 2)) (snd-display #__line__ ";as-one-edit sine-env-channel: ~A" (edit-position ind 0)))
      (revert-sound ind)
      (offset-channel -1.0)
      (sine-env-channel '(0 0 1 1 2 1 3 0) 40 20)
      (if (or (not (vequal (channel->vct 40 20) (vct -0.000 -0.050 -0.188 -0.389 -0.611 -0.812 -0.950 -1.000 -1.000 -1.000
						     -1.000 -1.000 -1.000 -1.000 -1.000 -0.950 -0.812 -0.611 -0.389 -0.188)))
	      (not (vequal (channel->vct 30 10) (make-vct 10 -1.0))))
	  (snd-display #__line__ ";off+sine-env: ~A ~A" (channel->vct 40 20) (channel->vct 30 10)))
      (revert-sound ind)
      (ptree-channel (lambda (y d f) (* y 2)) 0 (frames) ind 0 #f #f (lambda (p d) (vct 1.0)))
      (revert-sound ind)
      (scale-by 0.0)
      (dither-channel)
      (let ((mx (maxamp)))
	(if (or (< mx .00003) (> mx .0001))
	    (snd-display #__line__ ";dithering: ~A" mx)))
      (revert-sound ind)
      (map-channel (ring-mod 10 (list 0 0 1 (hz->radians 100))))
      (osc-formants .99 (vct 400.0 800.0 1200.0) (vct 400.0 800.0 1200.0) (vct 4.0 2.0 3.0))
      (map-channel (zecho .5 .75 6 10.0))
      (map-channel (flecho .5 .9))
      (filtered-env '(0 0 1 1 2 0))
      (map-channel (formant-filter .99 2400))
      (map-channel (comb-filter .8 32))
      (map-channel (zcomb .8 32 '(0 0 1 10)))
      (map-channel (notch-filter .8 32))
      (let ((ind1 (open-sound "now.snd")))
	(select-sound ind1)
	(if (fneq (maxamp) .309) (snd-display #__line__ ";squelch-vowels init: ~A" (maxamp)))
	(squelch-vowels)
	(if (fneq (maxamp) .047) (snd-display #__line__ ";squelch-vowels maxamp: ~A" (maxamp)))
	(select-sound ind)
	(map-channel (cross-synthesis ind1 .5 128 6.0))
	(revert-sound ind1)
	(fft-edit 40 8000)
	(fft-squelch .1)
	(close-sound ind)
	(revert-sound ind1)
	(scramble-channel .01)
	(revert-sound ind1)
	(close-sound ind1)))
    
    (let ((ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "special env tests" 100)))
      (map-channel (lambda (y) 1.0))
      
      (blackman4-ramp 0.0 1.0)
      (let ((vals (channel->vct)))
	(undo)
	(blackman4-env-channel '(0 0 1 1))
	(let ((new-vals (channel->vct)))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";blackman4-env-channel/ramp: ~A ~A" vals new-vals))
	  (undo)
	  (blackman4-ramp 0.0 1.0 0 50)
	  (set! vals (channel->vct))
	  (undo)
	  (blackman4-env-channel '(0 0 1 1 2 1))
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";blackman4-env-channel/ramp 1: ~A ~A" vals new-vals))
	  (undo)
	  (blackman4-env-channel '(0 0 1 1 2 -.5 3 0))
	  (if (not (vequal (channel->vct 60 10) (vct -0.109 -0.217 -0.313 -0.392 -0.451 -0.488 -0.499 -0.499 -0.499 -0.499)))
	      (snd-display #__line__ ";blackman4 to -.5: ~A" (channel->vct 60 10)))
	  (undo)
	  
	  (ramp-squared 0.0 1.0)
	  (set! vals (channel->vct))
	  (undo)
	  (env-squared-channel '(0 0 1 1))
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-squared/ramp: ~A ~A" vals new-vals))
	  (undo)
	  (ramp-squared 0.0 1.0 #t 0 50)
	  (set! vals (channel->vct))
	  (undo)
	  (env-squared-channel '(0 0 1 1 2 1))
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-squared/ramp 1: ~A ~A" vals new-vals))
	  (undo)
	  (env-squared-channel '(0 0 1 1 2 -.5 3 0))
	  (if (not (vequal (channel->vct 60 10) (vct -0.450 -0.466 -0.478 -0.488 -0.494 -0.499 -0.500 -0.500 -0.498 -0.496)))
	      (snd-display #__line__ ";env-squared to -.5: ~A" (channel->vct 60 10)))
	  (undo)
	  (env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
	  (if (not (vequal (channel->vct 60 10) (vct -0.004 -0.080 -0.158 -0.240 -0.324 -0.410 -0.500 -0.500 -0.498 -0.496)))
	      (snd-display #__line__ ";env-squared unsymmetric to -.5: ~A" (channel->vct 60 10)))
	  (undo)
	  
	  (ramp-squared 0.0 1.0)
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1) 2)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt2/ramp: ~A ~A" vals new-vals))
	  (undo)
	  (env-squared-channel '(0 0 1 1 2 -.5 3 0))
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt2/env-squared: ~A ~A" vals new-vals))
	  (undo)
	  (env-squared-channel '(0 0 1 1 2 -.5 3 0) #f)
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1 2 -.5 3 0) 2.0 #f)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt2/env-squared unsymmetric: ~A ~A" vals new-vals))
	  (undo)
	  
	  (ramp-expt 0.0 1.0 32.0)
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1) 32.0)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt/ramp 32: ~A ~A" vals new-vals))
	  (undo)
	  (ramp-expt 0.0 1.0 32.0 #f 0 50)
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1 2 1) 32.0)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt/ramp 1 32: ~A ~A" vals new-vals))
	  (undo)
	  (ramp-expt 0.0 1.0 .1)
	  (set! vals (channel->vct))
	  (undo)
	  (env-expt-channel '(0 0 1 1) .1)
	  (set! new-vals (channel->vct))
	  (if (not (vequal vals new-vals))
	      (snd-display #__line__ ";env-expt/ramp .1: ~A ~A" vals new-vals))
	  (undo)
	  
	  (env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0)
	  (if (not (vequal (channel->vct 30 10) (vct 0.319 0.472 0.691 1.000 0.537 0.208 -0.022 -0.182 -0.291 -0.365)))
	      (snd-display #__line__ ";env-expt to -.5 12.0: ~A" (channel->vct 30 10)))
	  (undo)
	  (env-expt-channel '(0 0 1 1 2 -.5 3 0) 12.0 #f)
	  (if (not (vequal (channel->vct 30 10) (vct 0.319 0.472 0.691 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	      (snd-display #__line__ ";env-expt to -.5 12.0 unsymmetric: ~A" (channel->vct 30 10)))
	  (undo)
	  (close-sound ind))))
    
    (let ((ind (new-sound  "test.snd" mus-next mus-bfloat 22050 1 "3rd ramp re-order tests" 101)))
      (offset-channel 1.0)
      (env-sound '(0 0 1 1))
      (contrast-channel 1.0)
      (let ((reader (make-sampler 0))
	    (happy #t))
	(do ((i 0 (+ 1 i))
	     (val 0.0 (+ val .01)))
	    ((or (not happy) (= i 100)))
	  (let ((y (reader))
		(ny (sin (+ (* val 0.5 pi) (* 1.0 (sin (* val 2.0 pi)))))))
	    (if (fneq y ny)
		(begin
		  (snd-display #__line__ ";contrast-channel: ~A ~A ~A" val y ny)
		  (set! happy #f))))))
      (undo)
      (compand-channel)
      (let ((reader (make-sampler 0))
	    (happy #t))
	(do ((i 0 (+ 1 i))
	     (val 0.0 (+ val .01)))
	    ((or (not happy) (= i 100)))
	  (let ((y (reader))
		(ny (array-interp compand-table (+ 8.0 (* 8.0 val)) 17)))
	    (if (fneq y ny)
		(begin
		  (snd-display #__line__ ";compand-channel: ~A ~A ~A" val y ny)
		  (set! happy #f))))))
      (undo 2)
      (ring-modulate-channel 1000)
      (let ((reader (make-sampler 0))
	    (incr (/ (* 2 pi 1000) (srate)))
	    (happy #t))
	(do ((i 0 (+ 1 i))
	     (val 0.0 (+ val incr)))
	    ((or (not happy) (= i 100)))
	  (let ((y (reader))
		(ny (sin val)))
	    (if (fneq y ny)
		(begin
		  (snd-display #__line__ ";ring-modulate-channel: ~A ~A ~A" val y ny)
		  (set! happy #f))))))
      (undo)
      (env-sound '(0 0 1 1))
      (smooth-channel-via-ptree)
      (let ((reader (make-sampler 0))
	    (incr (/ pi 101))
	    (happy #t))
	(do ((i 0 (+ 1 i))
	     (val pi (+ val incr)))
	    ((or (not happy) (= i 100)))
	  (let ((y (reader))
		(ny (+ 0.5 (* 0.5 (cos val)))))
	    (if (fneq y ny)
		(begin
		  (snd-display #__line__ ";smooth-channel-via-ptree: ~A ~A ~A" val y ny)
		  (set! happy #f))))))
      (undo 2)
      (env-channel '(0 1 1 0 2 1) 10 11)
      (if (not (vequal (channel->vct 0 30) (vct 1 1 1 1 1 1 1 1 1 1 1.000 0.800 0.600 0.400 0.200 0.000 0.200 0.400 0.600 0.800 1 1 1 1 1 1 1 1 1 1)))
	  (snd-display #__line__ ";env+ptree: ~A ~A ~A" (channel->vct 0 10) (channel->vct 10 10) (channel->vct 20 10)))
      (close-sound ind))
    
    (let ((ind0 (open-sound "oboe.snd"))
	  (ind1 (open-sound "pistol.snd")))
      
      (let ((clip (channel-clipped? ind0 0)))
	(if clip (snd-display #__line__ ";channel-clipped? oboe.snd -> ~A" clip)))
      (scale-to 1.5 ind0 0)
      (let ((clip (channel-clipped? ind0 0)))
	(if (not (equal? clip (list #t 4503))) (snd-display #__line__ ";channel-clipped after scale: ~A" clip)))
      (revert-sound ind0)
      
      (ramp-channel 0.0 1.0 0 #f ind1 0)
      (ramp-channel 0.0 1.0 0 #f ind1 0)
      (ramp-channel 0.0 1.0 0 #f ind1 0)
      (ramp-channel 0.0 1.0 0 #f ind1 0)
      (make-selection 1000 2000 ind1 0)
      (set! (sync ind0) 1)
      (set! (selected-sound) ind0)
      (env-selection '(0 0 1 1))
      (if (or (not (= (edit-position ind0 0) 0))
	      (not (= (edit-position ind1 0) 5)))
	  (snd-display #__line__ ";selection override of sync field: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
      (env-sound '(0 0 1 1 2 0))
      (if (or (not (= (edit-position ind0 0) 1))
	      (not (= (edit-position ind1 0) 5)))
	  (snd-display #__line__ ";sync field over selection: ~A ~A" (edit-position ind0 0) (edit-position ind1 0)))
      
      (close-sound ind1)
      (revert-sound ind0)
      (let ((val (sample 1990)))
	(delay-channel 10)
	(if (fneq (sample 2000) val) (snd-display #__line__ ";delay-channel: ~A ~A" val (sample 2000))))
      (close-sound ind0))
    
    (let ((ind (new-sound "test.snd" :size 20)))
      
      (vct->channel (make-vct 20 1.0))
      (ramp-channel 0 1)
      (env-sound '(0 1 1 .5 2 .5 3 1) 0 20 .6)
      (let ((data (channel->vct)))
	(if (not (vequal data (vct 0.000 0.049 0.091 0.123 0.146 0.158 0.158 0.184 0.211 0.237 0.263 0.289 0.316 0.342 0.444 0.549 0.658 0.770 0.884 1.000)))
	    (snd-display #__line__ ";env-sound xramp with flat segment: ~A" data)))
      (ptree-channel (lambda (y) (+ y .5)))
      (xramp-channel .1 .2 32.0)
      (let ((data (channel->vct)))
	(if (not (vequal data (vct 0.050 0.055 0.060 0.064 0.067 0.069 0.070 0.074 0.079 0.084 0.089 0.095 0.102 0.111 0.130 0.154 0.181 0.214 0.253 0.300)))
	    (snd-display #__line__ ";ramp->xramp->ptree->xramp: ~A" data)))
      
      (set! (edit-position) 1)
      (ramp-channel 0 1)
      (env-sound '(0 1 1 0.0 2 0.0 3 1) 0 20 .6)
      (ptree-channel (lambda (y) (+ y .5)))
      (xramp-channel .1 .2 32.0)
      (let ((data (channel->vct)))
	(if (not (vequal data (vct 0.050 0.055 0.058 0.060 0.060 0.058 0.053 0.054 0.055 0.057 0.058 0.060 0.063 0.066 0.090 0.119 0.153 0.193 0.241 0.300)))
	    (snd-display #__line__ ";1 ramp->xramp->ptree->xramp: ~A" data)))
      
      (set! (edit-position) 1)
      (env-sound '(0 1 1 0.5 2 0.5 3 1) 0 20 .6)
      (env-sound '(0 1 1 0 2 0 3 1) 0 20)
      (ptree-channel (lambda (y) (+ y .5)))
      (xramp-channel .1 .2 32.0)
      (let ((data (channel->vct)))
	(if (not (vequal data (vct 0.150 0.129 0.109 0.091 0.076 0.063 0.053 0.054 0.055 0.057 0.058 0.060 0.063 0.066 0.083 0.107 0.139 0.181 0.234 0.300)))
	    (snd-display #__line__ ";2 ramp->xramp->ptree->xramp: ~A" data)))
      
      (close-sound ind))
    
    (let ((s1 (open-sound "oboe.snd")))
      (let ((s2 (copy s1)))
	(if (not (sound? s2))
	    (snd-display #__line__ ";copy sound oboe -> ~A" s2)
	    (begin
	      (if (not (= (srate s1) (srate s2))) (snd-display #__line__ ";copy sounds srates: ~A ~A" (srate s1) (srate s2)))
	      (if (not (= (frames s1) (frames s2))) (snd-display #__line__ ";copy sounds frames: ~A ~A" (frames s1) (frames s2)))
	      (if (not (= (chans s1) (chans s2) 1)) (snd-display #__line__ ";copy sounds chans: ~A ~A" (chans s1) (chans s2)))
	      (let ((r1 (make-sampler 0 s1))
		    (r2 (make-sampler 0 s2))
		    (happy #t))
		(do ((i 0 (+ i 1)))
		    ((or (not happy)
			 (= i (frames s1))))
		  (let ((v1 (r1))
			(v2 (r2)))
		    (if (> (abs (- v1 v2)) .0001)
			(begin
			  (set! happy #f)
			  (snd-display #__line__ ";copied sound not equal? pos: ~A, ~A ~A" i v1 v2))))))
	      (close-sound s2))))
      (fill! s1 0.0)
      (if (fneq (maxamp s1) 0.0) (snd-display #__line__ ";fill 1 with 0: ~A" (maxamp s1)))
      (fill! s1 0.3)
      (if (fneq (maxamp s1) 0.3) (snd-display #__line__ ";fill 1 with 0.3: ~A" (maxamp s1)))
      (close-sound s1))
    
    (let ((s1 (open-sound "2a.snd")))
      (let ((s2 (copy s1)))
	(if (not (sound? s2))
	    (snd-display #__line__ ";copy sound 2a -> ~A" s2)
	    (begin
	      (if (not (= (srate s1) (srate s2))) (snd-display #__line__ ";copy sounds srates 2: ~A ~A" (srate s1) (srate s2)))
	      (if (not (= (frames s1) (frames s2))) (snd-display #__line__ ";copy sounds frames 2: ~A ~A" (frames s1) (frames s2)))
	      (if (not (= (chans s1) (chans s2) 2)) (snd-display #__line__ ";copy sounds chans 2: ~A ~A" (chans s1) (chans s2)))
	      (let ((r10 (make-sampler 0 s1 0))
		    (r11 (make-sampler 0 s1 1))
		    (r20 (make-sampler 0 s2 0))
		    (r21 (make-sampler 0 s2 1))
		    (happy #t))
		(do ((i 0 (+ i 1)))
		    ((or (not happy)
			 (= i (frames s1))))
		  (let ((v1 (r10))
			(v2 (r20)))
		    (if (> (abs (- v1 v2)) .0001)
			(begin
			  (set! happy #f)
			  (snd-display #__line__ ";copied sound 2 (0) not equal? pos: ~A, ~A ~A" i v1 v2))))
		  (let ((v1 (r11))
			(v2 (r21)))
		    (if (> (abs (- v1 v2)) .0001)
			(begin
			  (set! happy #f)
			  (snd-display #__line__ ";copied sound 2 (1) not equal? pos: ~A, ~A ~A" i v1 v2))))))
	      (close-sound s2))))
      (fill! s1 0.0)
      (if (fneq (maxamp s1) 0.0) (snd-display #__line__ ";fill 2 with 0: ~A" (maxamp s1)))
      (fill! s1 0.3)
      (if (fneq (maxamp s1) 0.3) (snd-display #__line__ ";fill 2 with 0.3: ~A" (maxamp s1)))
      (close-sound s1))
    
    (for-each close-sound (sounds))
    (let ((snd (open-sound "oboe.snd")))
      (make-selection 1000 2000 snd 0)
      (if (not (selection?)) (snd-display #__line__ ";make-selection for copy failed?"))
      (copy (selection))
      (let* ((r1 (make-sampler 1000 snd 0))
	     (snds (sounds))
	     (sel (if (equal? (car snds) snd) (cadr snds) (car snds)))
	     (r2 (make-sampler 0 sel 0))
	     (happy #t))
	(if (equal? sel snd)
	    (snd-display #__line__ ";very weird: ~A equal? ~A from ~A (~A ~A ~A)" sel snd snds (car snds) (cadr snds) (equal? (car snds) snd)))
	(do ((i 0 (+ i 1)))
	    ((or (not happy)
		 (= i 1000)))
	  (let ((v1 (r1))
		(v2 (r2)))
	    (if (> (abs (- v1 v2)) .0001)
		(begin
		  (set! happy #f)
		  (snd-display #__line__ ";copied selection not equal? pos: ~A, ~A ~A (~A ~A from ~A)" i v1 v2 sel snd snds)))))
	(close-sound sel)
	(if (not (selection?))
	    (snd-display #__line__ ";copy selection unselected? ~A" (sounds))
	    (begin
	      (fill! (selection) 0.0)
	      (let ((r1 (make-sampler 1000 snd 0))
		    (happy #t))
		(do ((i 0 (+ i 1)))
		    ((or (not happy)
			 (= i 1000)))
		  (let ((v1 (r1)))
		    (if (not (= v1 0.0))
			(begin
			  (set! happy #f)
			  (snd-display #__line__ ";fill! selection not 0.0? pos: ~A, ~A" i v1))))))
	      (revert-sound snd)
	      (if (not (selection?))
		  (snd-display #__line__ ";revert-sound selection unselected?")
		  (begin
		    (fill! (selection) 0.3)
		    (let ((r1 (make-sampler 1000 snd 0))
			  (happy #t))
		      (do ((i 0 (+ i 1)))
			  ((or (not happy)
			       (= i 1000)))
			(let ((v1 (r1)))
			  (if (not (= v1 0.3))
			      (begin
				(set! happy #f)
				(snd-display #__line__ ";fill! selection not 0.3? pos: ~A, ~A" i v1)))))))))))
      (for-each close-sound (sounds)))
    
    (let ((snd (open-sound "oboe.snd")))
      (make-selection 1000 2000 snd 0)
      (if (not (selection?)) 
	  (snd-display #__line__ ";make-selection failed?")
	  (let ((sel-max (maxamp (selection)))
		(sel-len (length (selection))))
	    (let ((mx (car (selection->mix))))
	      (if (not (mix? mx))
		  (snd-display #__line__ ";selection->mix: ~A" mx)
		  (let ((mx-rd (make-mix-sampler mx 0))
			(snd-rd (make-sampler 1000 snd 0))
			(orig-rd (make-sampler 1000 snd 0 1 0)))
		    (let ((happy #t))
		      (do ((i 0 (+ i 1)))
			  ((or (not happy) 
			       (= i 1000)))
			(let ((mx-val (mx-rd))
			      (snd-val (snd-rd))
			      (orig-val (orig-rd)))
			  (if (or (fneq mx-val snd-val)
				  (fneq snd-val orig-val))
			      (begin
				(set! happy #f)
				(snd-display #__line__ ";selection->mix at ~A: ~A ~A ~A" (+ i 1000) mx-val snd-val orig-val))))))
		    (if (not (= (length mx) sel-len 1001)) (snd-display #__line__ ";selection->mix mix length: ~A (~A)" (length mx) sel-len))
		    (if (fneq (maxamp mx) sel-max) (snd-display #__line__ ";selection->mix maxamps: ~A ~A" (maxamp mx) sel-max)))))))
      (for-each close-sound (sounds)))
    
    (let ((snd (open-sound "2.snd")))
      (set! (sync snd) 1)
      ;; make-selection claims it follows the sync field
      (make-selection 2000 3000 snd)
      (if (not (selection?)) 
	  (snd-display #__line__ ";make-selection (2) failed?")
	  (let ((sel-max (maxamp (selection)))
		(sel-len (length (selection)))
		(sel-chns (channels (selection))))
	    (if (not (= sel-chns 2)) (snd-display #__line__ ";make-selection stereo syncd chans: ~A" sel-chns))
	    (if (not (= sel-len 1001)) (snd-display #__line__ ";make-selection stereo length: ~A" sel-len))
	    (let* ((mx-list (selection->mix))
		   (mx0 (car mx-list))
		   (mx1 (cadr mx-list)))
	      (if (or (not (mix? mx0))
		      (not (mix? mx1)))
		  (snd-display #__line__ ";selection->mix stereo: ~A ~A" mx0 mx1)
		  (let ((mx0-rd (make-mix-sampler mx0 0))
			(mx1-rd (make-mix-sampler mx1 0))
			(snd0-rd (make-sampler 2000 snd 0))
			(snd1-rd (make-sampler 2000 snd 1))
			(orig0-rd (make-sampler 2000 snd 0 1 0))
			(orig1-rd (make-sampler 2000 snd 1 1 0)))
		    (let ((happy #t))
		      (do ((i 0 (+ i 1)))
			  ((or (not happy) 
			       (= i 1000)))
			(let ((mx0-val (mx0-rd))
			      (mx1-val (mx1-rd))
			      (snd0-val (snd0-rd))
			      (snd1-val (snd1-rd))
			      (orig0-val (orig0-rd))
			      (orig1-val (orig1-rd)))
			  (if (or (fneq mx0-val snd0-val)
				  (fneq snd0-val orig0-val))
			      (begin
				(set! happy #f)
				(snd-display #__line__ ";selection->mix stereo 0 at ~A: ~A ~A ~A" (+ i 2000) mx0-val snd0-val orig0-val)))
			  (if (or (fneq mx1-val snd1-val)
				  (fneq snd1-val orig1-val))
			      (begin
				(set! happy #f)
				(snd-display #__line__ ";selection->mix stereo 1 at ~A: ~A ~A ~A" (+ i 2000) mx1-val snd1-val orig1-val))))))))
	      
	      (if (not (= (length mx0) (length mx1) sel-len 1001))
		  (snd-display #__line__ ";selection->mix stereo mix length: ~A ~A (~A)" (length mx0) (length mx1) sel-len))
	      (if (fneq (max (maxamp mx0) (maxamp mx1)) sel-max) 
		  (snd-display #__line__ ";selection->mix stereo maxamps: ~A ~A ~A" (maxamp mx0) (maxamp mx1) sel-max)))))
      (for-each close-sound (sounds)))
    
    (clear-save-state-files)))


;;; ---------------- test 6: vcts ----------------

(define (snd_test_6)
  (begin 
    
    (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests)) 
      (log-mem clmtest)
      (let ((v0 (make-vct 10))
	    (v1 (make-vct 10))
	    (vlst (make-vct 3)))
	(if (not (vct? v0)) (snd-display #__line__ ";v0 isn't a vct?!?"))
	(if (equal? v0 10) (snd-display #__line__ ";v0 is 10!?"))
	(if (vct? 10) (snd-display #__line__ ";10 is a vct?"))
	(if (not (= (vct-length v0) 10)) (snd-display #__line__ ";v0 length = ~D?" (vct-length v0)))
	(vct-fill! v0 1.0)
	(vct-fill! v1 0.5)
	(if (equal? v0 v1) (snd-display #__line__ ";vct equal? ~A ~A" v0 v1))
	(if (eq? v0 v1) (snd-display #__line__ ";vct eq? ~A ~A" v0 v1))
	(let ((v2 v1)
	      (v3 (make-vct 10))
	      (v4 (make-vct 3)))
	  (if (not (eq? v1 v2)) (snd-display #__line__ ";vct not eq? ~A ~A" v1 v2))
	  (vct-fill! v3 0.5) 
	  (if (not (equal? v3 v1)) (snd-display #__line__ ";vct not equal? ~A ~A" v3 v1))
	  (if (equal? v4 v1) (snd-display #__line__ ";len diff vct equal? ~A ~A" v4 v1))
	  (set! (vct-ref v3 0) 1.0)
	  (if (fneq (vct-ref v3 0) 1.0) (snd-display #__line__ ";set! vct-ref: ~A" (vct-ref v3 0))))
	(vct-set! vlst 1 .1)
	(if (not (feql (vct->list vlst) (list 0.0 0.1 0.0))) (snd-display #__line__ ";vct->list: ~A?" (vct->list vlst)))
	(let* ((vect '#(0.0 1.0 2.0 3.0))
	       (v123 (vct 0.0 1.0 2.0 3.0))
	       (v2 (vector->vct vect))
	       (v3 v2)
	       (str (format #f "~A" v2))
	       (str1 (format #f "~A" (make-vct 32))))
	  (if (not (vct? (vector->vct (make-vector 0)))) (snd-display #__line__ ";vector->vct empty vect: ~A" (vector->vct (make-vector 0))))
	  (if (not (string=? str "#<vct[len=4]: 0.000 1.000 2.000 3.000>"))
	      (snd-display #__line__ ";vct print: ~%  ~A~%  ~A?" str v2))
	  (if (and (= (print-length) 12)
		   (not (string=? str1 "#<vct[len=32]: 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 ...>")))
	      (snd-display #__line__ ";vct(32) print: ~%  ~A~%" str1))
	  (if (not (vequal v123 v2)) (snd-display #__line__ ";vector->vct: ~A" v2))
	  (if (not (equal? (vct->vector v123) vect)) (snd-display #__line__ ";vct->vector: ~A ~A" vect (vct->vector v123)))
	  (if (not (equal? v3 v2)) (snd-display #__line__ ";vct=? ~A ~A?" v2 v3))
	  (if (not (= (vct-length v2) 4)) (snd-display #__line__ ";vector->vct length: ~A?" (vct-length v2)))
	  (if (fneq (vct-ref v2 2) 2.0) (snd-display #__line__ ";vector->vct: ~A?" v2))
	  (vct-move! v2 0 2)
	  (if (fneq (vct-ref v2 0) 2.0) (snd-display #__line__ ";vct-move!: ~A?" v2)))
	(let ((v2 (make-vct 4)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (vct-set! v2 i i))
	  (vct-move! v2 3 2 #t)
	  (if (or (fneq (vct-ref v2 3) 2.0) (fneq (vct-ref v2 2) 1.0))
	      (snd-display #__line__ ";vct-move! back: ~A?" v2)))
	
	(if (not (string=? (vct->string (vct 1.0 2.0)) "(vct 1.000 2.000)")) 
	    (snd-display #__line__ ";vct->string: ~A" (vct->string (vct 1.0 2.0))))
	
	(if (not (vequal (vct 4 3 2 1) (vct-reverse! (vct 1 2 3 4)))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2 3 4))))
	(if (not (vequal (vct 3 2 1) (vct-reverse! (vct 1 2 3)))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2 3))))
	(if (not (vequal (vct 2 1) (vct-reverse! (vct 1 2)))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2))))
	(if (not (vequal (vct 1) (vct-reverse! (vct 1)))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1))))
	(if (not (vequal (vct 4 3 2 1) (vct-reverse! (vct 1 2 3 4) 4))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2 3 4))))
	(if (not (vequal (vct 3 2 1) (vct-reverse! (vct 1 2 3) 3))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2 3))))
	(if (not (vequal (vct 2 1) (vct-reverse! (vct 1 2) 2))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1 2))))
	(if (not (vequal (vct 1) (vct-reverse! (vct 1) 1))) (snd-display #__line__ ";vct-reverse: ~A" (vct-reverse! (vct 1))))
	
	(if (not (vequal (vct 3 2 1) (reverse (vct 1 2 3)))) (snd-display #__line__ ";reverse(vct): ~A" (reverse (vct 1 2 3))))
	(let ((v (vct 3 2 1)))
	  (let ((rv (reverse v)))
	    (if (or (not (vequal v (vct 3 2 1)))
		    (not (vequal rv (vct 1 2 3))))
		(snd-display #__line__ ";reverse(vct) -> ~A ~A" v rv))))

	(let ((v0 (make-vct 3)))
	  (let ((var (catch #t (lambda () (vct-ref v0 10)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-ref high index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-ref v0 -1)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-ref low index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-set! v0 10 1.0)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-set! high index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-set! v0 -1 1.0)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-set! low index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-move! v0 10 0 #t)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-move! high index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-move! v0 0 10 #t)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-move! high 2 index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-move! v0 -10 0 #f)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-move! back high index: ~A" var)))
	  (let ((var (catch #t (lambda () (vct-move! v0 0 -10 #f)) (lambda args args))))
	    (if (not (eq? (car var) 'out-of-range))
		(snd-display #__line__ ";vct-move! back high 2 index: ~A" var))))
	
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (if (fneq (vct-ref v0 i) 1.0) (snd-display #__line__ ";fill v0[~D] = ~F?" i (vct-ref v0 i)))
	  (if (fneq (vct-ref v1 i) 0.5) (snd-display #__line__ ";preset v1[~D] = ~F?" i (vct-ref v1 i))))
	(vct-add! v0 v1)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (if (fneq (vct-ref v0 i) 1.5) (snd-display #__line__ ";add v0[~D] = ~F?" i (vct-ref v0 i))))
	(vct-subtract! v0 v1)
	(do ((i 0 (+ 1 i)))
	    ((= i 10))
	  (if (fneq (vct-ref v0 i) 1.0) (snd-display #__line__ ";subtract v0[~D] = ~F?" i (vct-ref v0 i))))
	(let ((v2 (vct-copy v0)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (if (fneq (vct-ref v2 i) 1.0) (snd-display #__line__ ";copy v0[~D] = ~F?" i (vct-ref v2 i))))
	  (vct-scale! v2 5.0)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (if (fneq (vct-ref v2 i) 5.0) (snd-display #__line__ ";scale v2[~D] = ~F?" i (vct-ref v2 i))))
	  (vct-offset! v0 -1.0)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (if (fneq (vct-ref v0 i) 0.0) (snd-display #__line__ ";offset v0[~D] = ~F?" i (vct-ref v0 i))))
	  (vct-multiply! v2 v1)
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (if (fneq (vct-ref v2 i) 2.5) (snd-display #__line__ ";multiply v2[~D] = ~F?" i (vct-ref v2 i))))
	  (if (fneq (vct-peak v2) 2.5) (snd-display #__line__ ";v2's peak is ~F?" (vct-peak v2)))
	  (vct-set! v2 5 123.0)
	  (if (fneq (vct-peak v2) 123.0) (snd-display #__line__ ";v2's set peak is ~F?" (vct-peak v2)))
	  (let ((vn (make-vct 32))
		(vb (make-vct 64))
		(vs (make-vct 3))
		(vss (make-vct 1)))
	    (do ((i 0 (+ 1 i)))
		((= i 32))
	      (vct-set! vn i i))
	    (let ((vnew (vct-subseq vn 3)))
	      (if (fneq (vct-ref vnew 0) 3.0) (snd-display #__line__ ";vct-subseq[3:] ~A?" (vct-ref vnew 0)))
	      (if (not (= (vct-length vnew) 29)) (snd-display #__line__ ";vct-subseq[3:] length: ~A?" (vct-length vnew))))
	    (let ((vnew (vct-subseq vn 3 8)))
	      (if (fneq (vct-ref vnew 0) 3.0) (snd-display #__line__ ";vct-subseq[3:8] ~A?" (vct-ref vnew 0)))
	      (if (not (= (vct-length vnew) 6)) (snd-display #__line__ ";vct-subseq[3:8] length: ~A?" (vct-length vnew))))
	    (vct-subseq vn 3 3 vs)
	    (if (or (fneq (vct-ref vs 0) 3.0)
		    (fneq (vct-ref vs 1) 0.0)
		    (fneq (vct-ref vs 2) 0.0))
		(snd-display #__line__ ";vct-subseq[3:3->vs] ~A?" vs))
	    (vct-subseq vn 0 32 vs)
	    (if (not (= (vct-length vs) 3)) (snd-display #__line__ ";vct-subseq[0:32->vs] length: ~A?" (vct-length vs)))
	    (vct-subseq vn 2 3 vss)
	    (if (fneq (vct-ref vss 0) 2.0) (snd-display #__line__ ";vct-subseq[2:3->vss] ~A?" (vct-ref vss 0)))
	    (vct-set! vb 8 123.0)
	    (vct-subseq vn 1 8 vb)
	    (if (fneq (vct-ref vb 0) 1.0) (snd-display #__line__ ";vct-subseq[1:8->vb] ~A?" (vct-ref vb 0)))
	    (if (fneq (vct-ref vb 8) 123.0) (snd-display #__line__ ";vct-subseq[1:8->vb][8] ~A?" (vct-ref vb 8))))
	  
	  (let ((v1 (make-vct 3 .1))
		(v2 (make-vct 4 .2)))
	    (let ((val (vct+ (vct-copy v1) v2)))
	      (if (not (vequal val (vct .3 .3 .3))) (snd-display #__line__ ";vct+ .1 .2: ~A" val)))
	    (vct-set! v1 1 .3)
	    (let ((val (vct+ (vct-copy v1) v2)))
	      (if (not (vequal val (vct .3 .5 .3))) (snd-display #__line__ ";vct+ .1 .2 (1): ~A" val)))
	    (let ((val (vct+ (vct-copy v1) 2.0)))
	      (if (not (vequal val (vct 2.1 2.3 2.1))) (snd-display #__line__ ";vct+ .1 2.0: ~A" val)))
	    (let ((val (vct+ 2.0 (vct-copy v1))))
	      (if (not (vequal val (vct 2.1 2.3 2.1))) (snd-display #__line__ ";vct+ .1 2.0 (1): ~A" val)))
	    (let ((val (vct* 2.0 (vct-copy v1))))
	      (if (not (vequal val (vct .2 .6 .2))) (snd-display #__line__ ";vct* 2.0: ~A" val)))
	    (let ((val (vct* (vct-copy v1) 2.0)))
	      (if (not (vequal val (vct .2 .6 .2))) (snd-display #__line__ ";vct* 2.0 (1): ~A" val)))
	    (let ((val (vct* (vct-copy v1) v2)))
	      (if (not (vequal val (vct .02 .06 .02))) (snd-display #__line__ ";vct* v1 v2: ~A" val))))
	  
	  (vct-map! v0 (lambda () 1.0))
	  (do ((i 0 (+ 1 i)))
	      ((= i 10))
	    (if (fneq (vct-ref v0 i) 1.0) (snd-display #__line__ ";map v0[~D] = ~F?" i (vct-ref v0 i)))))
	
	(if (fneq ((vct 1.0 2.0 3.0) 1) 2.0)
	    (snd-display #__line__ ";(vct...) = ~A?" ((vct 1.0 2.0 3.0) 1)))
	(let ((v1 (vct 1 2 3 4)))
	  (if (fneq (v1 1) 2.0)
	      (snd-display #__line__ ";(v1 1) = ~A?" (v1 1))))
	
	(let ((ind (open-sound "oboe.snd"))
	      (ctr 0))
	  (set! (speed-control ind) .5)
	  (play :wait #t)
	  (apply-controls)
	  (revert-sound)
	  (reset-controls ind)
	  ;; try some special cases
	  (apply-controls)
	  (if (not (= (edit-position ind) 0))
	      (snd-display #__line__ ";apply-controls with no:change: ~A: ~A" (edits ind) (edit-tree ind)))
	  (set! (speed-control ind) -1.0)
	  (apply-controls)
	  (if (not (= (edit-position ind) 1))
	      (snd-display #__line__ ";apply-controls with srate -1.0: ~A ~A" (edits ind) (edit-tree ind)))
	  (if (> (abs (- (frames ind 0) (frames ind 0 0))) 2)
	      (snd-display #__line__ ";apply-controls srate -1.0 lengths: ~A ~A" (frames ind 0) (frames ind 0 0)))
	  (if (or (fneq (maxamp) .147)
		  (< (abs (sample 9327)) .01))
	      (snd-display #__line__ ";apply-controls srate -1.0 samples: ~A ~A" (maxamp) (sample 9327)))
	  (if (fneq (speed-control ind) 1.0) (snd-display #__line__ ";apply-controls -1.0 -> ~A?" (speed-control ind)))
	  
	  (add-hook! dac-hook (lambda (data) 
				(set! ctr (+ 1 ctr))
				(if (>= ctr 3) (c-g!))))
	  (play :wait #t)
	  (if (not (= ctr 3)) (snd-display #__line__ ";ctr after dac-hook: ~A" ctr))
	  (set! ctr 0)
	  (set! (speed-control) 1.5)
	  (apply-controls)
					;		(if (fneq (sample 28245) 0.0) (snd-display #__line__ ";dac-hook stop apply-controls? ~A" (sample 28245)))
	  (reset-hook! dac-hook)
	  (revert-sound)
	  (set! (speed-control) 1.5)
	  (set! ctr 0)
	  (add-hook! dac-hook (lambda (data) 
				(set! ctr (+ 1 ctr))
				(if (= ctr 3) (apply-controls))))
	  (play :wait #t)
	  (if (not (= (edit-position ind 0) 1)) (snd-display #__line__ ";apply-controls from hook: ~A ~A" (edits ind) (edit-tree ind)))
	  (revert-sound)
	  (reset-hook! dac-hook)
	  (set! (speed-control) 1.5)
	  (stop-playing)
	  (add-hook! after-apply-controls-hook (lambda (s) 
						 (let ((tag (catch #t 
								   (lambda () (apply-controls)) 
								   (lambda args args))))
						   (if (not (eq? (car tag) 'cannot-apply-controls))
						       (snd-display #__line__ ";after-apply-controls-hook: recursive attempt apply-controls: ~A" tag)))))
	  (apply-controls)
	  (reset-hook! after-apply-controls-hook)
	  (add-hook! dac-hook (lambda (s) 
				(let ((tag (catch #t 
						  (lambda () (apply-controls)) 
						  (lambda args args))))
				  (if (not (eq? (car tag) 'cannot-apply-controls))
				      (snd-display #__line__ ";dac-hook: recursive attempt apply-controls: ~A" tag)))))
	  (reset-hook! dac-hook)
	  
	  (revert-sound)
	  (close-sound ind))
	
	(let ((v1 (make-vct 32)))
	  (vct-map! v1
		    (lambda ()
		      (let ((v2 (make-vct 3)))
			(vct-map! v2 (lambda () .1))
			(vct-ref v2 0))))
	  (if (fneq (vct-ref v1 12) .1) (snd-display #__line__ ";vct-map! twice: ~A" (vct-ref v1 12))))
	(let ((hi (make-vct 3)))
	  (let ((tag (catch #t
			    (lambda () (vct-subseq hi 1 0))
			    (lambda args (car args)))))
	    (if (not (eq? tag 'out-of-range))
		(snd-display #__line__ ";vct-subseq 1 0: ~A" tag)))
	  (if (not (vct? (vct))) (snd-display #__line__ ";(vct) -> ~A" (vct)))
	  (let ((tag (catch #t (lambda () (make-vct 0)) (lambda args (car args)))))
	    (if (not (vct? tag)) (snd-display #__line__ ";make-vct 0 -> ~A" tag)))
	  (let ((ho (make-vct 3)))
	    (vct-add! hi ho 4)))
	(let ((v0 (make-vct 5 .1))
	      (v1 (make-vct 6 .2)))
	  (vct-add! v0 v1 2)
	  (if (not (vequal v0 (vct .1 .1 .3 .3 .3)))
	      (snd-display #__line__ ";vct-add + offset: ~A" v0)))
	
	;; test local var gc protection in vct.h vct_to_vector
	(let ((v1 (vct-map! 
		   (make-vct 44100 0.0) 
		   (make-oscil 1)))) 
	  (vct->vector v1) 
	  (vct->vector v1)
	  (let ((vect (vct->vector v1)))
	    (vector->vct vect)
	    (vector->vct vect)
	    (set! v1 (vector->vct vect))))
	
#|
	;; a test of big vcts (needs 16 Gbytes):
	(if (and (string? (getenv "HOSTNAME"))
		 (string=? (getenv "HOSTNAME") "fatty8"))
	    (let ((size (+ 2 (expt 2 31))))
	      (if (not (= size 2147483650))
		  (snd-display #__line__ ";big vct, size: ~A (~A ~A)" size 2147483650 (- 2147483650 size)))
	      (set! (mus-max-malloc) (expt 2 40))
	      (if (not (= (mus-max-malloc) 1099511627776))
		  (snd-display #__line__ ";big vct, mus-max-malloc: ~A" (mus-max-malloc)))
	      (let ((hi (make-vct size)))
		(if (not (vct? hi))
		    (snd-display #__line__ ";big vct, not a vct?? ~A" hi))
		(if (fneq (vct-ref hi (expt 2 31)) 0.0)
		    (snd-display #__line__ ";big vct, created at end: ~A" (vct-ref hi (expt 2 31))))
		(vct+ hi .1)
		(if (fneq (vct-ref hi (expt 2 31)) 0.1)
		    (snd-display #__line__ ";big vct, add .1 at end: ~A" (vct-ref hi (expt 2 31))))
		(let ((pk (vct-peak hi)))
		  (if (fneq pk .1)
		      (snd-display #__line__ ";big vct, vct-peak: ~A" pk)))
		(let ((len (vct-length hi)))
		  (if (not (= len size))
		      (snd-display #__line__ ";big vct, len: ~A" len)))
		(vct-scale! hi 2.0)
		(if (fneq (vct-ref hi (+ 1 (expt 2 31))) .2)
		    (snd-display #__line__ ";big vct, scale: ~A ~A" (vct-ref hi (+ 1 (expt 2 31))) hi))
		(vct-set! hi (expt 2 31) 1.0)
		(if (fneq (vct-ref hi (expt 2 31)) 1.0)
		    (snd-display #__line__ ";big vct, set at end: ~A" (vct-ref hi (expt 2 31))))
		(vct-offset! hi .2)
		(if (fneq (vct-ref hi (expt 2 31)) 1.2)
		    (snd-display #__line__ ";big vct, offset: ~A" (vct-ref hi (expt 2 31))))
		(vct-subtract! hi hi)
		(let ((pk (vct-peak hi)))
		  (if (fneq pk 0.0)
		      (snd-display #__line__ ";big vct, subtract vct-peak: ~A ~A" pk hi)))
		(vct-fill! hi 1.0)
		(if (fneq (vct-ref hi (expt 2 31)) 1.0)
		    (snd-display #__line__ ";big vct, fill: ~A ~A" (vct-ref hi (expt 2 31)) hi))
		(vct-set! hi (expt 2 31) 0.0)
		(let ((ho (vct-subseq hi (- (expt 2 31) 3) (+ (expt 2 31) 1))))
		  (if (not (vequal ho (vct 1.0 1.0 1.0 0.0 1.0)))
		      (snd-display #__line__ ";big vct, subseq: ~A" ho)))
		(vct-reverse! hi)
		(let ((ho (vct-subseq hi 0 5)))
		  (if (not (vequal ho (vct 1.0 0.0 1.0 1.0 1.0 1.0)))
		      (snd-display #__line__ ";big vct, reverse: ~A" ho)))
		(vct-set! hi (expt 2 31) 10.0)
		(vct-move! hi (- (expt 2 31) 3) (expt 2 31))
		(let ((ho (vct-subseq hi (- (expt 2 31) 3) (+ (expt 2 31) 1))))
		  (if (not (vequal ho (vct 10.0 1.0 1.0 10.0 1.0)))
		      (snd-display #__line__ ";big vct, subseq: ~A" ho)))
		)
	      
	      ;; big vectors/hash-tables also
	      
	      
	      (let ((size (+ 2 (expt 2 31))))
		(if (not (= size 2147483650))
		    (snd-display #__line__ ";big vector size: ~A (~A ~A)" size 2147483650 (- 2147483650 size)))
		(let ((hi (make-vector size '())))
		  (if (not (vector? hi))
		      (snd-display #__line__ ";big vector not a vector?? ~A" hi))
		  (if (not (null? (vector-ref hi (expt 2 31))))
		      (snd-display #__line__ ";big vector created at end: ~A" (vector-ref hi (expt 2 31))))
		  (set! (hi (expt 2 31)) 100)
		  (if (not (= (vector-ref hi (expt 2 31)) 100))
		      (snd-display #__line__ ";big vector set to 100 at end: ~A" (vector-ref hi (expt 2 31))))
		  (let ((len (vector-length hi)))
		    (if (not (= len size))
			(snd-display #__line__ ";big vector len: ~A" len)))
		  (vector-fill! hi 2)
		  (if (not (= (vector-ref hi (expt 2 31)) 2))
		      (snd-display #__line__ ";big vector fill: ~A" (vector-ref hi (expt 2 31))))))
	      
	      
	      
	      (let ((hi (make-vector (list (+ 2 (expt 2 30)) 2) '())))
		(if (not (= (vector-length hi) (* 2 (+ 2 (expt 2 30)))))
		    (snd-display #__line__ ";big vector 2dim size: ~A ~A" (vector-length hi) (* 2 (+ 2 (expt 2 30)))))
		(if (not (null? (vector-ref hi (expt 2 30) 0)))
		    (snd-display #__line__ ";big vector 2dim created at end (0): ~A" (vector-ref hi (expt 2 30) 0)))
		(if (not (null? (vector-ref hi (expt 2 30) 1)))
		    (snd-display #__line__ ";big vector 2dim created at end (1): ~A" (vector-ref hi (expt 2 30) 1)))
		(set! (hi (expt 2 30) 1) 100)
		(if (not (= (vector-ref hi (expt 2 30) 1) 100))
		    (snd-display #__line__ ";big vector 2dim set to 100 at end: ~A" (vector-ref hi (expt 2 30) 1)))
		(vector-fill! hi 2)
		(if (not (= (vector-ref hi (expt 2 30) 0) 2))
		    (snd-display #__line__ ";big vector 2dim fill: ~A" (vector-ref hi (expt 2 30) 0))))
	      
	      
	      
	      (let ((hi (make-hash-table (+ 2 (expt 2 31)))))
		(if (not (= (hash-table-size hi) (+ 2 (expt 2 31))))
		    (snd-display #__line__ ";big hash size: ~A ~A" (hash-table-size hi) (+ 2 (expt 2 31))))
		(if (fneq (let () (hash-table-set! hi 'key 3.14) (hash-table-ref hi 'key)) 3.14)
		    (snd-display #__line__ ";big hash 3.14: ~A" (hash-table-ref hi 'key)))
		(if (not (equal? (let () (hash-table-set! hi 123 "hiho") (hash-table-ref hi 123)) "hiho"))
		    (snd-display #__line__ ";big hash 123: ~A" (hash-table-ref hi 123)))
		(if (not (equal? (let () 
				   (hash-table-set! hi 'hiho-this-is-a-big-name-to-overflow-32-bits-I-hope "hiho")
				   (hash-table-ref hi 'hiho-this-is-a-big-name-to-overflow-32-bits-I-hope))
				 "hiho"))
		    (snd-display #__line__ ";big hash big symbol: ~A" (hash-table-ref hi 'hiho-this-is-a-big-name-to-overflow-32-bits-I-hope)))
		(if (not (equal? (let () 
				   (hash-table-set! hi 12345678912345 "hiho")
				   (hash-table-ref hi 12345678912345))
				 "hiho"))
		    (snd-display #__line__ ";big hash big symbol: ~A" (hash-table-ref hi 12345678912345))))
	      
	      
	      ))
|#
	
	(let ((sum 0)) 
	  (for-each (lambda (n) (set! sum (+ sum n))) (vct 1 2 3))
	  (if (not (= sum 6.0))
	      (snd-display #__line__ ";object for-each (vct): ~A" sum)))
	
	))))


;;; ---------------- test 7: colors ----------------

(if (not (provided? 'snd-rgb.scm)) (load "rgb.scm"))

(define (snd_test_7)
  (define colormap-error-max 0.0)
  (define cfneq (lambda (a b) (> (abs (- a b)) colormap-error-max)))
  (define old-colormap-size (colormap-size))
  
  (if (or (provided? 'snd-gtk)
	  (provided? 'snd-motif))
      (letrec ((test-color
		(lambda (lst)
		  (if (not (null? lst))
		      (let* ((name (list-ref (car lst) 0))
			     (getfnc (list-ref (car lst) 1))
			     (setfnc (lambda (val) (set! (getfnc) val)))
			     (initval (list-ref (car lst) 2)))
			(if (not (color? initval)) (snd-display #__line__ ";~A not color?" initval))
			;; we'll get warnings here if the cell chosen didn't exactly match the one requested -- not a bug
			;; (if (not (equal? (getfnc) initval))
			;;	  (snd-display #__line__ ";~A /= ~A (~A)?" name initval (getfnc)))
			(setfnc beige)
			(if (not (equal? (getfnc) beige))
			    (snd-display #__line__ ";set-~A /= beige (~A)?" name (getfnc)))
			(setfnc initval)
			(test-color (cdr lst)))))))
	
	(let* ((c1 (catch 'no-such-color
			  (lambda () (make-color 0 0 1))
			  (lambda args #f)))
	       (c2 c1)
	       (c3 (catch 'no-such-color
			  (lambda () (make-color 0 0 1))
			  (lambda args #f))))
	  (if (not (equal? c1 c2)) (snd-display #__line__ ";color equal? ~A ~A?" c1 c2))
	  (if (not (eq? c1 c2)) (snd-display #__line__ ";color eq? ~A ~A?" c1 c2))
	  (if (provided? 'snd-motif) (if (not (equal? c1 c3)) (snd-display #__line__ ";diff color equal? ~A ~A?" c1 c3)))
	  (if (eq? c1 c3) (snd-display #__line__ ";diff color eq? ~A ~A?" c1 c3))
	  (if (not (equal? (color->list c1) (list 0.0 0.0 1.0)))
	      (snd-display #__line__ ";color->list: ~A ~A?" c1 (color->list c1))))
	(do ((i 0 (+ 1 i))) 
	    ((not (colormap? (integer->colormap i))))
	  (let ((val (colormap-ref (integer->colormap i) 0))
		(true-val (list-ref (list '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 0.0 0.0) '(0.0 1.0 1.0)
					  '(0.0 0.0 7.01915007248035e-4) '(0.0 0.0 0.0) '(0.0 0.0 0.0)
					  '(0.0 0.0 0.49999) '(1.0 0.0 0.0) '(1.0 0.0 0.0) '(0.0 0.0 1.0)
					  '(1.0 0.0 1.0) '(0.0 0.500007629510948 0.4) '(1.0 0.0 0.0)
					  '(1.0 0.0 0.0) '(0.0 0.0 1.0))
				    i)))
	    (if (not (feql val true-val))
		(snd-display #__line__ ";colormap-ref ~A: ~A (~A)" i val true-val))))
	(catch #t ; might be undefined var as well as no-such-color
	       (lambda () 
		 (test-color
		  (list
		   (list 'basic-color basic-color ivory2)
		   (list 'cursor-color cursor-color red)
		   (list 'data-color data-color black)
		   (list 'enved-waveform-color enved-waveform-color blue)
		   (list 'filter-control-waveform-color filter-control-waveform-color blue)
		   (list 'graph-color graph-color white)
		   (list 'highlight-color highlight-color ivory1)
		   (list 'listener-color listener-color alice-blue)
		   (list 'listener-text-color listener-text-color black)
		   (list 'mark-color mark-color red)
		   (list 'mix-color mix-color dark-gray)
		   (list 'position-color position-color ivory3)
		   (list 'pushed-button-color pushed-button-color lightsteelblue1)
		   (list 'sash-color sash-color light-green)
		   (list 'selected-data-color selected-data-color black)
		   (list 'selected-graph-color selected-graph-color white)
		   (list 'selection-color selection-color lightsteelblue1)
		   (list 'text-focus-color text-focus-color white)
		   (list 'zoom-color zoom-color ivory4)
		   
		   (list 'quit-button-color quit-button-color indian-red)
		   (list 'help-button-color help-button-color lightsteelblue2)
		   (list 'reset-button-color reset-button-color goldenrod1)
		   (list 'doit-button-color doit-button-color palegreen2)
		   (list 'doit-again-button-color doit-again-button-color darkolivegreen1)
		   ))
		 
		 (let ((ind (open-sound "oboe.snd")))
		   (set! (selected-data-color) light-green)
		   (set! (data-color) blue)
		   (set! (selected-graph-color) black)
		   (let ((red (make-color-with-catch 1.0 0.0 0.0)))
		     (set! (foreground-color ind 0 cursor-context) red)
		     (let ((col (foreground-color ind 0 cursor-context)))
		       (if (not (feql (color->list col) (color->list red)))
			   (snd-display #__line__ ";set foreground cursor color: ~A ~A" (color->list col) (color->list red))))
		     (set! (foreground-color) blue)
		     (let ((col (foreground-color)))
		       (if (not (feql (color->list col) (color->list blue)))
			   (snd-display #__line__ ";set foreground-color: ~A ~A" (color->list col) (color->list blue))))
		     (set! (foreground-color ind) red)
		     (let ((col (foreground-color ind)))
		       (if (not (feql (color->list col) (color->list red)))
			   (snd-display #__line__ ";set foreground-color with ind (red): ~A ~A" (color->list col) (color->list red))))
		     (set! (foreground-color ind) black)
		     (let ((col (foreground-color ind)))
		       (if (not (feql (color->list col) (color->list black)))
			   (snd-display #__line__ ";set foreground-color with ind (black): ~A ~A" (color->list col) (color->list black)))))
		   (set! (selected-graph-color) (make-color-with-catch 0.96 0.96 0.86))
		   (set! (data-color) black)
		   (set! (selected-data-color) blue)
		   (set! (graph-color) white)
		   (close-sound ind)))
	       (lambda args args))
	
	(if (not (= (length jet-colormap) (colormap-size)))
	    (snd-display #__line__ ";jet-colormap length: ~A ~A" (length jet-colormap) (colormap-size)))
	
	(for-each 
	 (lambda (n err)
	   (set! (colormap-size) n)
	   (set! colormap-error-max err)
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/4)
			   (* 7/8 x)
			   (- (* 11/8 x) 3/8)))
		    (g (if (< x 3/8)
			   (* 7/8 x)
			   (if (< x 3/4)
			       (- (* 29/24 x) 1/8)
			       (+ (* 7/8 x) 1/8))))
		    (b (if (< x 3/8)
			   (* 29/24 x)
			   (+ (* 7/8 x) 1/8)))
		    (rgb (colormap-ref bone-colormap x))
		    (rgb1 (bone-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2))
		    (r2 (list-ref rgb1 0))
		    (g2 (list-ref rgb1 1))
		    (b2 (list-ref rgb1 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) 
			(or (cfneq r r1) 
			    (cfneq g g1) 
			    (cfneq b b1)
			    (cfneq r2 r1) 
			    (cfneq g2 g1) 
			    (cfneq b2 b1)))
		   (snd-display #__line__ ";bone ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 4/5)
			   (* 5/4 x)
			   1.0))
		    (g (* 4/5 x))
		    (b (* 1/2 x))
		    (rgb (colormap-ref copper-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";copper ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 0.0)
		    (g x)
		    (b (- 1.0 (/ g 2.0)))
		    (rgb (colormap-ref winter-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";winter ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 1.0)
		    (g x)
		    (b 0.0)
		    (rgb (colormap-ref autumn-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";autumn ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g (- 1.0 r))
		    (b 1.0)	     
		    (rgb (colormap-ref cool-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";cool ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/8)
			   (* 8/3 x)
			   1.0))
		    (g (if (< x 3/8)
			   0.0
			   (if (< x 3/4)
			       (- (* 8/3 x) 1.0)
			       1.0)))
		    (b (if (< x 3/4)
			   0.0
			   (- (* 4 x) 3)))
		    (rgb (colormap-ref hot-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";hot ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 3/8)
			   0.0
			   (if (< x 5/8)
			       (- (* 4 x) 3/2)
			       (if (< x 7/8)
				   1.0
				   (+ (* -4 x) 9/2)))))
		    (g (if (< x 1/8)
			   0.0
			   (if (< x 3/8)
			       (- (* 4 x) 1/2)
			       (if (< x 5/8)
				   1.0
				   (if (< x 7/8)
				       (+ (* -4 x) 7/2)
				       0.0)))))
		    (b (if (< x 1/8)
			   (+ (* 4 x) 1/2)
			   (if (< x 3/8)
			       1.0
			       (if (< x 5/8)
				   (+ (* -4 x) 5/2)
				   0.0))))
		    (rgb (colormap-ref jet-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";jet ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (if (colormap? pink-colormap)
	       (do ((i 0 (+ 1 i))) ((= i 10))
		 (let* ((x (random 1.0))
			(r (if (< x 3/8)
			       (* 14/9 x)
			       (+ (* 2/3 x) 1/3)))
			(g (if (< x 3/8)
			       (* 2/3 x)
			       (if (< x 3/4)
				   (- (* 14/9 x) 1/3)
				   (+ (* 2/3 x) 1/3))))			
			(b (if (< x 3/4)
			       (* 2/3 x)
			       (- (* 2 x) 1)))
			(rgb (colormap-ref pink-colormap x))
			(r1 (list-ref rgb 0))
			(g1 (list-ref rgb 1))
			(b1 (list-ref rgb 2)))
		   (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		       (snd-display #__line__ ";pink ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				    x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 1.0)
		    (g x)
		    (b (- 1.0 g))
		    (rgb (colormap-ref spring-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";spring ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g x)
		    (b x)
		    (rgb (colormap-ref gray-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";gray ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r 0.0)
		    (g 0.0)
		    (b 0.0)
		    (rgb (colormap-ref black-and-white-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";black-and-white ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r x)
		    (g (+ 0.5 (/ r 2)))
		    (b 0.4)
		    (rgb (colormap-ref summer-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";summer ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (r (if (< x 2/5)
			   1.0
			   (if (< x 3/5)
			       (+ (* -5 x) 3)
			       (if (< x 4/5)
				   0.0
				   (- (* 10/3 x) 8/3)))))
		    (g (if (< x 2/5)
			   (* 5/2 x)
			   (if (< x 3/5)
			       1.0
			       (if (< x 4/5)
				   (+ (* -5 x) 4)
				   0.0))))
		    (b (if (< x 3/5)
			   0.0
			   (if (< x 4/5)
			       (- (* 5 x) 3)
			       1.0)))
		    (rgb (colormap-ref rainbow-colormap x))
		    (r1 (list-ref rgb 0))
		    (g1 (list-ref rgb 1))
		    (b1 (list-ref rgb 2)))
	       (if (and (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		   (snd-display #__line__ ";rainbow ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1)))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (rgb (colormap-ref prism-colormap x)))
	       (if (and (< x (- 1.0 (/ 1.0 n)))
			(not (feql rgb '(1 0 0)))
			(not (feql rgb '(1 0.5 0)))
			(not (feql rgb '(1 1 0)))
			(not (feql rgb '(0 1 0)))
			(not (feql rgb '(0 0 1)))
			(not (feql rgb '(.6667 0 1))))
		   (snd-display #__line__ ";prism ~A" rgb))))
	   
	   (do ((i 0 (+ 1 i))) ((= i 10))
	     (let* ((x (random 1.0))
		    (rgb (colormap-ref flag-colormap x)))
	       (if (and (< x (- 1.0 (/ 1.0 n)))
			(not (feql rgb '(1 0 0)))
			(not (feql rgb '(1 1 1)))
			(not (feql rgb '(0 0 1)))
			(not (feql rgb '(0 0 0))))
		   (snd-display #__line__ ";flag: ~A" rgb))))
	   )
	 (list 512 64)
	 (list 0.005 0.04))
	
	(let ((ind (add-colormap "white" (lambda (size) (list (make-vct size 1.0) (make-vct size 1.0) (make-vct size 1.0))))))
	  (if (not (colormap? ind))
	      (snd-display #__line__ ";add-colormap ~A: ~A" ind (colormap? ind)))
	  (if (not (feql (colormap-ref ind 0.5) '(1.0 1.0 1.0)))
	      (snd-display #__line__ ";white colormap: ~A" (colormap-ref ind 0.5)))
	  (let ((tag (catch #t (lambda () (set! (colormap) ind)) (lambda args args))))
	    (if (or (eq? tag 'no-such-colormap)
		    (not (equal? (colormap) ind))
		    (not (= (colormap->integer (colormap)) (colormap->integer ind))))
		(snd-display #__line__ ";colormap white: ~A ~A ~A" tag ind (colormap))))
	  (if (not (string=? (colormap-name ind) "white"))
	      (snd-display #__line__ ";white colormap name: ~A" (colormap-name ind))))
	
	(let ((tag (catch #t (lambda () (delete-colormap (integer->colormap 1234))) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ ";delete-colormap 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref (integer->colormap 1234) 0.5)) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ ";colormap-ref 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref (integer->colormap -1) 0.5)) (lambda args (car args)))))
	  (if (and (not (eq? tag 'no-such-colormap))
		   (not (eq? tag 'wrong-type-arg)))
	      (snd-display #__line__ ";colormap-ref -1: ~A" tag)))
	(let ((tag (catch #t (lambda () (set! (colormap) (integer->colormap 1234))) (lambda args (car args)))))
	  (if (not (eq? tag 'no-such-colormap))
	      (snd-display #__line__ "; set colormap 1234: ~A" tag)))
	(let ((tag (catch #t (lambda () (set! (colormap) (integer->colormap -1))) (lambda args (car args)))))
	  (if (and (not (eq? tag 'no-such-colormap))
		   (not (eq? tag 'wrong-type-arg)))
	      (snd-display #__line__ "; set colormap -1: ~A" tag)))
	(let ((tag (catch #t (lambda () (colormap-ref copper-colormap 2.0)) (lambda args (car args)))))
	  (if (not (eq? tag 'out-of-range))
	      (snd-display #__line__ ";colormap-ref 2.0: ~A" tag)))
	
	(set! (colormap-size) old-colormap-size)
	(if (not (= (colormap-size) old-colormap-size))
	    (snd-display #__line__ ";set colormap-size: ~A ~A" (colormap-size) old-colormap-size))
	
	(if (not (string=? (colormap-name black-and-white-colormap) "black-and-white"))
	    (snd-display #__line__ ";black-and-white: ~A" (colormap-name black-and-white-colormap)))
	(if (not (string=? (colormap-name gray-colormap) "gray"))
	    (snd-display #__line__ ";gray: ~A" (colormap-name gray-colormap)))
	(if (not (string=? (colormap-name rainbow-colormap) "rainbow"))
	    (snd-display #__line__ ";rainbow: ~A" (colormap-name rainbow-colormap)))
	
	(let ((purple-cmap (add-colormap "purple" 
					 (lambda (size) 
					   (let ((r (make-vct size))
						 (g (make-vct size))
						 (b (make-vct size))
						 (incr (exact->inexact (/ 256.0 size)))
						 (er (list 0 60 60 116 128 252 192 252 256 60))
						 (eg (list 0 0  64 0   128 252 192 252 256 0))
						 (eb (list 0 80        128 252 192 0   256 80)))
					     (do ((i 0 (+ 1 i))
						  (x 0.0 (+ x incr)))
						 ((= i size))
					       (vct-set! r i (exact->inexact (/ (envelope-interp x er) 256.0)))
					       (vct-set! g i (exact->inexact (/ (envelope-interp x eg) 256.0)))
					       (vct-set! b i (exact->inexact (/ (envelope-interp x eb) 256.0))))
					     (list r g b)))))
	      (sin-cmap (add-colormap "sin" 
				      (lambda (size) 
					(let ((r (make-vct size))
					      (g (make-vct size))
					      (b (make-vct size))
					      (incr (exact->inexact (/ (* 2 pi) size))))
					  (do ((i 0 (+ 1 i))
					       (x 0.0 (+ x incr)))
					      ((= i size))
					    (vct-set! r i (abs (sin (* 1.5 x))))
					    (vct-set! g i (abs (sin (* 3.5 x))))
					    (vct-set! b i (abs (sin (* 2.5 x)))))
					  (list r g b)))))
	      (another-sin-cmap (add-colormap "another-sin" 
					      (lambda (size) 
						(let ((r (make-vct size))
						      (g (make-vct size))
						      (b (make-vct size))
						      (incr (exact->inexact (/ (* 2 pi) size))))
						  (do ((i 0 (+ 1 i))
						       (x 0.0 (+ x incr)))
						      ((= i size))
						    (vct-set! r i (abs (sin (* 2.5 x))))
						    (vct-set! g i (abs (sin (* 3.5 x))))
						    (vct-set! b i (abs (sin (* 4.5 x)))))
						  (list r g b))))))
	  (delete-colormap pink-colormap)
	  (if (colormap? pink-colormap)
	      (snd-display #__line__ ";delete-colormap ~A: ~A" pink-colormap (colormap? pink-colormap)))
	  (let ((tag (catch #t (lambda () (set! (colormap) pink-colormap)) (lambda args args))))
	    (if (or (not (eq? (car tag) 'no-such-colormap))
		    (equal? (colormap) pink-colormap))
		(snd-display #__line__ ";delete pink colormap: ~A ~A ~A" tag pink-colormap (colormap))))
	  
	  (for-each
	   (lambda (n)
	     (set! (colormap-size) n)
	     (do ((i 0 (+ 1 i))) 
		 ((= i 10))
	       (let* ((x (random 1.0))
		      (r (if (< x 4/5) (* 5/4 x) 1.0))
		      (g (* 4/5 x))
		      (b (* 1/2 x))
		      (rgb (colormap-ref copper-colormap x))
		      (r1 (list-ref rgb 0))
		      (g1 (list-ref rgb 1))
		      (b1 (list-ref rgb 2)))
		 (if (and (> n 2) (< x (- 1.0 (/ 1.0 n))) (or (cfneq r r1) (cfneq g g1) (cfneq b b1)))
		     (snd-display #__line__ ";copper size reset ~A: ~,3F (~,3F): ~{~,3F ~} ~{~,3F ~}" 
				  n x (max (abs (- r r1)) (abs (- g g1)) (abs (- b b1))) (list r g b) (list r1 g1 b1))))))
	   (list 1024 256 2 512))
	  (set! (colormap-size) 512))
	
	(reset-hook! graph-hook)
	(clear-sincs)
	
	)))



;;; ---------------- test 8: clm ----------------

(if (not (provided? 'snd-moog.scm)) (load "moog.scm"))
(if (not (provided? 'snd-mixer.scm)) (load "mixer.scm"))
(if (not (provided? 'snd-frame.scm)) (load "frame.scm"))
(if (not (provided? 'snd-poly.scm)) (load "poly.scm"))
(if (not (provided? 'snd-analog-filter.scm)) (if (defined? 'gsl-roots) (load "analog-filter.scm")))
(if (not (provided? 'snd-bird.scm)) (load "bird.scm"))
(if (not (provided? 'snd-v.scm)) (load "v.scm"))
(if (not (provided? 'snd-numerics.scm)) (load "numerics.scm"))
(if (not (provided? 'snd-generators.scm)) (load "generators.scm"))

(def-clm-struct sa1 (freq 0.0 :type float) (coscar #f :type clm) (sincar #f :type clm) (dly #f :type clm) (hlb #f :type clm))

(define (snd-test-jc-reverb decay-dur low-pass volume amp-env)
  "(jc-reverb decay-dur low-pass volume amp-env) is the old Chowning reverberator: (jc-reverb 2.0 #f .1 #f)"
  (let* ((allpass1 (make-all-pass -0.700 0.700 1051))
	 (allpass2 (make-all-pass -0.700 0.700  337))
	 (allpass3 (make-all-pass -0.700 0.700  113))
	 (comb1 (make-comb 0.742 4799))
	 (comb2 (make-comb 0.733 4999))
	 (comb3 (make-comb 0.715 5399))
	 (comb4 (make-comb 0.697 5801))
	 (outdel1 (make-delay (round (* .013 (srate)))))
	 (dur (+ decay-dur (/ (frames) (srate))))
	 (envA (if amp-env (make-env :envelope amp-env :scaler volume :duration dur) #f)))
    (map-chan
     (let ((comb-sum 0.0)
	   (comb-sum-1 0.0)
	   (comb-sum-2 0.0)
	   (all-sums 0.0))
       (lambda (inval)
	 (let ((allpass-sum (all-pass allpass3 (all-pass allpass2 (all-pass allpass1 inval)))))
	   (set! comb-sum-2 comb-sum-1)
	   (set! comb-sum-1 comb-sum)
	   (set! comb-sum 
		 (+ (comb comb1 allpass-sum)
		    (comb comb2 allpass-sum)
		    (comb comb3 allpass-sum)
		    (comb comb4 allpass-sum)))
	   (if low-pass
	       (set! all-sums (+ (* .25 (+ comb-sum comb-sum-2)) (* .5 comb-sum-1)))
	       (set! all-sums comb-sum))
	   (+ inval
	      (if envA
		  (* (env envA) (delay outdel1 all-sums))
		  (* volume (delay outdel1 all-sums)))))))
     0 (round (* dur (srate))))))

;;; -------- scissor-tailed flycatcher
;;;
;;; mix a scissor-tailed flycatcher call into the current sound
;;; see bird.scm for lots more birds


(define (scissor begin-time) ; test 23 also
  "(scissor beg) is the scissor-tailed flycatcher"
  (let ((scissorf '(0 0  40 1  60 1  100 0)))
    (bigbird begin-time 0.05 1800 1800 .2 
	     scissorf 
	     '(0 0  25 1  75 1  100 0) 
	     '(1 .5  2 1  3 .5  4 .1  5 .01))))


(define (snd_test_8)
  
  ;; ----------------
  (define (bumpy)
    (let* ((x 0.0) 
	   (xi (/ 1.0 (frames)))
	   (start 0)
	   (end 1)
	   (scl (exp (/ 4.0 (- end start))))) ; normalize it
      (map-channel (lambda (y) 
		     (let ((val (if (or (<= x start) ; don't divide by zero
					(>= x end))
				    0.0
				    (* (exp (/ -1.0 (- x start))) 
				       (exp (/ -1.0 (- end x)))))))
		       (set! x (+ x xi))
		       (* scl val))))))
  
  ;; ----------------
  (define test-scanned-synthesis
    ;; check out scanned-synthesis
    (lambda (amp dur mass xspring damp)
      (let* ((size 256)
	     (x0 (make-vct size))	   
	     (x1 (make-vct size))	   
	     (x2 (make-vct size)))
	(do ((i 0 (+ 1 i)))
	    ((= i 12))
	  (let ((val (sin (/ (* 2 pi i) 12.0))))
	    (vct-set! x1 (+ i (- (/ size 4) 6)) val)))
	(let* ((gen1 (make-table-lookup 440.0 :wave x1))
	       (gen2 (make-table-lookup 440.0 :wave x2))
	       (recompute-samps 30) ;just a quick guess
	       (data (make-vct dur)))
	  (do ((i 0 (+ 1 i))
	       (k 0.0)
	       (kincr (/ 1.0 recompute-samps)))
	      ((or (c-g?) 
		   (= i dur)))
	    (if (>= k 1.0)
		(begin
		  (set! k 0.0)
		  (compute-uniform-circular-string size x0 x1 x2 mass xspring damp))
		(set! k (+ k kincr)))
	    (let ((g1 (table-lookup gen1))
		  (g2 (table-lookup gen2)))
	      (vct-set! data i (+ g2 (* k (- g1 g2))))))
	  (let ((curamp (vct-peak data)))
	    (vct-scale! data (/ amp curamp)))
	  (vct->channel data 0 dur)))))
  
  ;; (test-scanned-synthesis .1 10000 1.0 0.1 0.0)
  
  ;; ----------------
  (define* (array-interp-sound-diff snd chn)
    
    (define (envelope->vct e len)
      (let ((v (make-vct len))
	    (e (make-env e :length len)))
	(do ((i 0 (+ 1 i)))
	    ((= i len))
	  (vct-set! v i (env e)))
	v))
    
    (let ((tbl (envelope->vct (list 0.0 -1.0 1.0 1.0) 1001))
	  (curpos (edit-position snd chn)))
      (map-channel (lambda (y)
		     (let ((pos (+ 500 (* 500 y))))
		       (array-interp tbl pos 1000)))
		   0 #f snd chn)
      
      (let ((r (make-sampler 0 snd chn 1 curpos))
	    (mx 0.0))
	(scan-channel (lambda (y) 
			(set! mx (max mx (abs (- y (r))))))
		      0 #f snd chn)
	mx)))
  
  ;; ----------------
  (define (make-papoulis-window n)
    "(make-papoulis-window size) returns a papoulis window os the given size"
    (let ((v (make-vct n))
	  (n2 (/ n 2)))
      (do ((i (- n2) (+ i 1)))
	  ((= i n2))
	(let* ((ratio (/ i n))
	       (pratio (* 2 pi ratio)))
	  (vct-set! v (+ i n2) (+ (/ (abs (sin pratio)) pi)
				  (* (- 1.0 (* 2 (abs ratio)))
				     (cos pratio))))))
      v))
  
  ;; ----------------
  (define (make-dpss-window n w)
    "(make-dpss-window size w) returns a prolate spheriodal (slepian) window of the given size"
    ;; from Verma, Bilbao, Meng, "The Digital Prolate Spheroidal Window"
    ;; output checked using Julius Smith's dpssw.m, although my "w" is different
    (let* ((mat (make-mixer! n))
	   (cw (cos (* 2 pi w))))
      (do ((i 0 (+ i 1)))
	  ((= i n))
	(let ((n2 (- (* 0.5 (- n 1)) i))) 
	  (mixer-set! mat i i (* cw n2 n2))
	  (if (< i (- n 1))
	      (mixer-set! mat i (+ i 1) (* 0.5 (+ i 1) (- n 1 i))))
	  (if (> i 0)
	      (mixer-set! mat i (- i 1) (* 0.5 i (- n i))))))
      (let ((v (vector->vct (vector-ref (cadr (gsl-eigenvectors mat)) 0)))
	    (pk 0.0))
	;; sign of eigenvalue is arbitrary, and eigenvector is scaled to sum to 1.0
	;;   but we want peak of 1.0 to serve as fft window
	(do ((i 0 (+ i 1)))
	    ((= i n))
	  (if (> (abs (vct-ref v i)) (abs pk))
	      (set! pk (vct-ref v i)))) 
	(vct-scale! v (/ 1.0 pk)))))

  ;; ----------------

  (define mus-a0
    (make-procedure-with-setter
     (lambda (gen)
       "obsolete way to access mus-xcoeff 0"
       (mus-xcoeff gen 0))
     (lambda (gen val)
       (set! (mus-xcoeff gen 0) val))))
  
  (define mus-a1
    (make-procedure-with-setter
     (lambda (gen)
       "obsolete way to access mus-xcoeff 1"
       (mus-xcoeff gen 1))
     (lambda (gen val)
       (set! (mus-xcoeff gen 1) val))))
  
  (define mus-a2
    (make-procedure-with-setter
     (lambda (gen)
       "obsolete way to access mus-xcoeff 2"
       (mus-xcoeff gen 2))
     (lambda (gen val)
       (set! (mus-xcoeff gen 2) val))))
  
  (define mus-b1
    (make-procedure-with-setter
     (lambda (gen)
       "obsolete way to access mus-ycoeff 1"
       (mus-ycoeff gen 1))
     (lambda (gen val)
       (set! (mus-ycoeff gen 1) val))))
  
  (define mus-b2
    (make-procedure-with-setter
     (lambda (gen)
       "obsolete way to access mus-ycoeff 2"
       (mus-ycoeff gen 2))
     (lambda (gen val)
       (set! (mus-ycoeff gen 2) val))))
  
  ;; ----------------
  (define (test-lpc)
    (define (make-sine n) 
      (let ((data (make-vct n 0.0))) 
	(do ((i 0 (+ 1 i))) 
	    ((= i n) data) 
	  (vct-set! data i (sin (* 2 pi (/ i n)))))))
    (define (make-sines n) 
      (let ((data (make-vct n 0.0))) 
	(do ((i 0 (+ 1 i))) 
	    ((= i n) data) 
	  (vct-set! data i (+ (sin (* 2 pi (/ i n)))
			      (* .25 (sin (* 4 pi (/ i n))))
			      (* .125 (sin (* 8 pi (/ i n)))))))))
    
    (let ((vals (lpc-predict (vct 0 1 2 3 4 5 6 7) 8 (lpc-coeffs (vct 0 1 2 3 4 5 6 7) 8 4) 4 2)))
      (if (not (vequal vals (vct 7.906 8.557)))
	  (snd-display #__line__ ";predict ramp: ~A" vals)))
    (let ((vals (lpc-predict (vct 0 1 2 3 4 5 6 7) 8 (lpc-coeffs (vct 0 1 2 3 4 5 6 7) 8 7) 7 2)))
      (if (not (vequal vals (vct 7.971 8.816))) 
	  (snd-display #__line__ ";predict ramp 1: ~A" vals)))
    (let ((vals (lpc-predict (vct 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
			     (lpc-coeffs (vct 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 7) 7 5)))
      (if (not (vequal vals (vct 14.999 15.995 16.980 17.940 18.851)))
	  (snd-display #__line__ ";predict ramp 2: ~A" vals)))
    (let ((vals (lpc-predict (vct 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 
			     (lpc-coeffs (vct 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14) 15 14) 14 5)))
      (if (not (vequal vals (vct 15.000 16.000 16.998 17.991 18.971)))
	  (snd-display #__line__ ";predict ramp 3: ~A" vals)))
    (let ((vals (lpc-predict (make-sine 16) 16 (lpc-coeffs (make-sine 16) 16 8) 8 2)))
      (if (not (vequal vals (vct 0.000 0.383)))
	  (snd-display #__line__ ";predict sine: ~A" vals)))
    (let ((vals (lpc-predict (make-sine 16) 16 (lpc-coeffs (make-sine 16) 16 8) 8 8)))
      (if (not (vequal vals (vct 0.000 0.383 0.707 0.924 1.000 0.924 0.707 0.383)))
	  (snd-display #__line__ ";predict sine 1: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 8) 8 8)))
      (if (not (vequal vals (vct 0.000 0.379 0.686 0.880 0.970 1.001 1.022 1.053)))
	  (snd-display #__line__ ";predict sines: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 16) 16 8)))
      (if (and (not (vequal vals (vct 0.000 0.379 0.684 0.876 0.961 0.987 1.006 1.046)))
	       (not (vequal vals (vct 0.000 0.379 0.685 0.876 0.961 0.985 0.998 1.029)))) ; if --with-doubles
	  (snd-display #__line__ ";predict sines 1: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 32) 32 (lpc-coeffs (make-sines 32) 32 30) 30 4)))
      (if (and (not (vequal vals (vct 0.000 0.379 0.685 0.878)))
	       (not (vequal vals (vct 0.000 0.379 0.684 0.875)))) ; double vcts
	  (snd-display #__line__ ";predict sines 2: ~A" vals)))
    (let ((vals (lpc-predict (make-sines 64) 64 (lpc-coeffs (make-sines 64) 64 32) 32 8)))
      (if (not (vequal vals (vct 0.000 0.195 0.379 0.545 0.684 0.795 0.875 0.927)))
	  (snd-display #__line__ ";predict sines 3: ~A" vals))))
  
  ;; ----------------
  (define (test-unclip-channel)
    (let ((ind (new-sound "test.snd" mus-next mus-lfloat 22050 2 "unclip-channel test" 1)))
      (set! (sync ind) 1)
      
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.01 (maxamp ind 0)))
	    (dur (frames ind 0)))
	(scale-channel scl 0 dur ind 0)
	(scale-channel scl 0 dur ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 20)) (snd-display #__line__ ";unclip-channel 0 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 0 oboe max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 0 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (e (make-env '(0 0 1 .8 1.5 1.0 2.0 1.0 2.5 .8 3.5 0) :length 101))
	    (o (make-oscil 1000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* 1.05 (env e) (oscil o))))
	(vct->channel data 0 100 ind 0)
	(vct->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 1 sine clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 1 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 1 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (e (make-env '(0 0 1 .8 1.75 1.0 2.0 1.0 2.25 .8 3.5 0) :length 101))
	    (o (make-oscil 1000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* 1.1 (env e) (oscil o))))
	(vct->channel data 0 100 ind 0)
	(vct->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 2 sine clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display #__line__ ";unclip-channel 2 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 2 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (e (make-env '(0 0 1 .8 1.85 1.0 2.0 1.0 2.15 .8 3.5 0) :length 101))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* 1.2 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
	(vct->channel data 0 100 ind 0)
	(vct->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 3 sine clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 3 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 3 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (e (make-env '(0 0 40 .75 45 1.0 50 1.25 55 1.0 60 .75 100 0.0) :length 101))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* 1.5 (env e) (+ (* .75 (oscil o1)) (* .25 (oscil o2))))))
	(vct->channel data 0 100 ind 0)
	(vct->channel data 0 100 ind 1))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 4 sine clips: ~A" clips))
	(if (not (= lmax 4)) (snd-display #__line__ ";unclip-channel 4 sine max len: ~A" lmax))
	(if (fneq umax .999) (snd-display #__line__ ";unclip-channel 4 sine maxamp: ~A" umax)))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* .25 (oscil o1))))
	(let ((true-max (vct-peak data)))
	  (vct-set! data 50 (+ (vct-ref data 50) 1.25))
	  (vct->channel data 0 100 ind 0)
	  (vct->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (list-ref vals 1))
		 (clips (list-ref vals 3))
		 (lmax (list-ref vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 5 click clips: ~A" clips))
	    (if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 5 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 5 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* .25 (oscil o1))))
	(let ((true-max (vct-peak data)))
	  (do ((i 49 (+ 1 i)))
	      ((= i 51))
	    (vct-set! data i (+ (vct-ref data i) 1.25)))
	  (vct->channel data 0 100 ind 0)
	  (vct->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (list-ref vals 1))
		 (clips (list-ref vals 3))
		 (lmax (list-ref vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 6 click clips: ~A" clips))
	    (if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 6 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 6 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (o1 (make-oscil 1000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* .25 (oscil o1))))
	(let ((true-max (vct-peak data)))
	  (do ((i 45 (+ 1 i)))
	      ((= i 55))
	    (vct-set! data i (+ (vct-ref data i) 1.25)))
	  (vct->channel data 0 100 ind 0)
	  (vct->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (list-ref vals 1))
		 (clips (list-ref vals 3))
		 (lmax (list-ref vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 7 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 7 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 7 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-vct 100 0.0))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 100) data) 
	  (vct-set! data i (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (vct-peak data)))
	  (do ((i 45 (+ 1 i)))
	      ((= i 55))
	    (vct-set! data i (+ (vct-ref data i) 1.25)))
	  (vct->channel data 0 100 ind 0)
	  (vct->channel data 0 100 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (list-ref vals 1))
		 (clips (list-ref vals 3))
		 (lmax (list-ref vals 5)))
	    (if (not (= clips 1)) (snd-display #__line__ ";unclip-channel 8 click clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 8 click max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 8 click maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (let ((data (make-vct 200 0.0))
	    (o1 (make-oscil 1000))
	    (o2 (make-oscil 2000)))
	(do ((i 0 (+ 1 i))) 
	    ((= i 200) data) 
	  (vct-set! data i (* .25 (+ (oscil o1) (oscil o2)))))
	(let ((true-max (vct-peak data)))
	  (do ((i 45 (+ 1 i)))
	      ((= i 55))
	    (vct-set! data i (+ (vct-ref data i) 2.0)))
	  (do ((i 75 (+ 1 i)))
	      ((= i 85))
	    (vct-set! data i (+ (vct-ref data i) 2.0)))
	  (vct->channel data 0 200 ind 0)
	  (vct->channel data 0 200 ind 1)
	  
	  (let* ((vals (unclip-channel ind 1))
		 (umax (list-ref vals 1))
		 (clips (list-ref vals 3))
		 (lmax (list-ref vals 5)))
	    (if (not (= clips 2)) (snd-display #__line__ ";unclip-channel 9 collision clips: ~A" clips))
	    (if (not (= lmax 10)) (snd-display #__line__ ";unclip-channel 9 collision max len: ~A" lmax))
	    (if (fneq umax true-max) (snd-display #__line__ ";unclip-channel 9 collision maxamp: ~A ~A" umax true-max)))))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.01 (maxamp ind 0)))
	    (dur (frames ind 0)))
	(do ((i 0 (+ 1 i))) ((= i 2))
	  (map-channel (lambda (uy) (let ((y (* uy scl))) (if (> y 1.0) 1.0 (if (< y -1.0) -1.0 y)))) 0 dur ind i)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 20)) (snd-display #__line__ ";unclip-channel 10 oboe clips: ~A" clips))
	(if (not (= lmax 1)) (snd-display #__line__ ";unclip-channel 10 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 10 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let ((scl (/ 1.05 (maxamp ind 0)))
	    (dur (frames ind 0)))
	(do ((i 0 (+ 1 i))) ((= i 2))
	  (map-channel (lambda (uy) (let ((y (* uy scl))) (if (> y 1.0) 1.0 (if (< y -1.0) -1.0 y)))) 0 dur ind i)))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 217)) (snd-display #__line__ ";unclip-channel 11 oboe clips: ~A" clips))
	(if (not (= lmax 2)) (snd-display #__line__ ";unclip-channel 11 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 11 oboe maxamp: ~A" umax)))
      
      (revert-sound ind)
      (mix "oboe.snd" 0 0 ind 0 #f)
      (mix "oboe.snd" 0 0 ind 1 #f)
      (let* ((scl (/ 1.2 (maxamp ind 0)))
	     (dur (frames ind 0)))
	(do ((i 0 (+ 1 i))) ((= i 2))
	  (let ((e (make-env (list 0 0 .48 (/ scl 2) .5 scl .52 (/ scl 2) 1.0 0) :length dur)))
	    (map-channel (lambda (uy) (let ((y (* uy (env e)))) (if (> y 1.0) 1.0 (if (< y -1.0) -1.0 y)))) 0 dur ind i))))
      
      (let* ((vals (unclip-channel ind 1))
	     (umax (list-ref vals 1))
	     (clips (list-ref vals 3))
	     (lmax (list-ref vals 5)))
	(if (not (= clips 28)) (snd-display #__line__ ";unclip-channel 12 oboe clips: ~A" clips))
	(if (not (= lmax 3)) (snd-display #__line__ ";unclip-channel 12 oboe max len: ~A" lmax))
	(if (fneq umax 0.999) (snd-display #__line__ ";unclip-channel 12 oboe maxamp: ~A" umax)))
      
      (close-sound ind)))
  
  ;; ----------------
  (define (analog-filter-tests)
    
    (define (sweep->bins flt bins)
      (let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050 1 #f 22050)))
	(let ((phase 0.0)
	      (freq 0.0)
	      (incr (/ pi 22050)))
	  (map-channel 
	   (lambda (y)
	     (let ((val (sin phase))) 
	       (set! phase (+ phase freq)) 
	       (set! freq (+ freq incr))
	       (* .5 val)))))
	(map-channel flt)
	(let* ((mx (maxamp))
	       (resp (make-vct bins))
	       (size (round (/ 22050 bins))))
	  (do ((i 0 (+ 1 i)))
	      ((= i bins))
	    (let ((data (channel->vct (* i size) size)))
	      (vct-set! resp i (vct-peak data))))
	  (close-sound ind)
	  (list mx resp))))
    
    (define (filter-response-max f1)
      (let ((mx 0.0)
	    (signal 1.0))
	(do ((i 0 (+ 1 i)))
	    ((= i 1000))
	  (set! mx (max mx (abs (f1 signal))))
	  (set! signal 0.0))
	mx))
    
    (define (filter-equal? f1 f2) ; equalp in clm2xen is too restrictive
      (and (= (mus-order f1) (mus-order f2))
	   (vequal (mus-xcoeffs f1) (mus-xcoeffs f2))
	   (vequal (mus-ycoeffs f1) (mus-ycoeffs f2))))
    
    ;; ---------------- butterworth tests ----------------
    
    (let ((poles (list (vct 1.000 1.414 1.000) ; numerous references provide these tables (y[0] is ignored)
		       (vct 1.000 1.848 1.000 1.000 0.765 1.000)
		       (vct 1.000 1.932 1.000 1.000 1.414 1.000 1.000 0.518 1.000)
		       (vct 1.000 1.962 1.000 1.000 1.663 1.000 1.000 1.111 1.000 1.000 0.390 1.000)
		       (vct 1.000 1.975 1.000 1.000 1.782 1.000 1.000 1.414 1.000 1.000 0.908 1.000 1.000 0.313 1.000))))
      (do ((i 2 (+ i 2))
	   (k 0 (+ 1 k)))
	  ((>= i 12))
	(let ((vals (butterworth-prototype i)))
	  (if (not (vequal (cadr vals) (list-ref poles k)))
	      (snd-display #__line__ ";butterworth prototype poles ~A: ~A (~A)" i (cadr vals) (list-ref poles k)))
	  (let ((zeros (make-vct (* (+ k 1) 3))))
	    (do ((j 2 (+ j 3)))
		((>= j (* (+ k 1) 3)))
	      (vct-set! zeros j 1.0))
	    (if (not (vequal (car vals) zeros))
		(snd-display #__line__ ";butterworth prototype zeros ~A: ~A (~A)" i (car vals) zeros)))))
      (do ((cutoff .1 (+ cutoff .1))
	   (m 0 (+ 1 m)))
	  ((= m 3))
	(do ((i 2 (+ i 2))
	     (k 1 (+ k 1)))
	    ((= i 16))
	  (let ((local (make-butterworth-lowpass i cutoff))
		(dsp (make-butter-lp k (* (mus-srate) cutoff))))
	    (if (not (filter-equal? local dsp))
		(snd-display #__line__ ";butterworth lowpass ~A ~A ~A" cutoff local dsp)))
	  (let ((local (make-butterworth-highpass i cutoff))
		(dsp (make-butter-hp k (* (mus-srate) cutoff))))
	    (if (not (filter-equal? local dsp))
		(snd-display #__line__ ";butterworth highpass ~A ~A ~A" cutoff local dsp)))))
      
      (let ((ind (open-sound "oboe.snd")))
	(let ((hummer (make-eliminate-hum 550))) 
	  (map-channel (lambda (x) (eliminate-hum hummer x))))
	(let ((peaker (make-peaking-2 500 1000 1.0)))
	  (map-channel peaker))
	(map-channel (chordalize))
	(close-sound ind))
      
      (let* ((f1 (make-butterworth-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.359 0.014 0.001 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butterworth lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.499 0.358 0.010 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butterworth lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth lp 10 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.361 0.001)))
		 (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.499 0.360 0.002))))
	    (snd-display #__line__ ";butterworth lp 10 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 12))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-butterworth-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";butter low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-butterworth-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.348 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.011 0.348 0.500 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (fneq (car vals) .5) (snd-display #__line__ ";butterworth hp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.005 0.343 0.501 0.501)))
	    (snd-display #__line__ ";butterworth hp 10 .4 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-butterworth-bandpass 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.028 0.350 0.481 0.479 0.346 0.132 0.038 0.009 0.002 0.000)))
	    (snd-display #__line__ ";butterworth bp 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandpass 12 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 12 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.006 0.317 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (vct 0.012 0.319 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.323 0.501 0.500 0.358 0.009 0.000 0.000 0.000 0.000))))
	    (snd-display #__line__ ";butterworth bp 12 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandpass 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.003 0.034 0.344 0.499 0.499 0.353 0.002)))
	    (snd-display #__line__ ";butterworth bp 8 .3 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 12))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-butterworth-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";butter high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-butterworth-bandstop 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.347 0.339 0.481 0.499 0.500 0.500 0.500 0.500)))
	    (snd-display #__line__ ";butterworth bs 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandstop 12 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 12 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.503 0.503 0.364 0.334 0.500 0.500 0.500 0.500 0.500 0.500)))
		 (not (vequal1 (cadr vals) (vct 0.502 0.503 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500)))
		 (not (vequal1 (cadr vals) (vct 0.500 0.500 0.365 0.334 0.500 0.500 0.500 0.500 0.500 0.500))))
	    (snd-display #__line__ ";butterworth bs 12 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-butterworth-bandstop 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";butterworth bs 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.500 0.498 0.354 0.332 0.500 0.500)))
	    (snd-display #__line__ ";butterworth bs 8 .3 .4 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- Chebyshev ----------------
      
      ;; ripple .01 .1 1 for 2..10 even
      
      (let ((poles-01 (list (vct 1.000 4.456 10.426)
			    (vct 1.000 0.822 2.006 1.000 1.984 1.299)
			    (vct 1.000 0.343 1.372 1.000 0.937 0.939 1.000 1.280 0.506)
			    (vct 1.000 0.189 1.196 1.000 0.537 0.925 1.000 0.804 0.542 1.000 0.948 0.272)
			    (vct 1.000 0.119 1.121 1.000 0.347 0.940 1.000 0.540 0.646 1.000 0.680 0.352 1.000 0.754 0.170)))
	    (zeros    (list (vct 0.000 0.000 1.000)
			    (vct 0.000 0.000 0.250 0.000 0.000 1.000)
			    (vct 0.000 0.000 0.062 0.000 0.000 1.000 0.000 0.000 1.000)
			    (vct 0.000 0.000 0.016 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)
			    (vct 0.000 0.000 0.004 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000 0.000 0.000 1.000)))
	    (poles-1  (list (vct 1.000 2.372 3.314)
			    (vct 1.000 0.528 1.330 1.000 1.275 0.623)
			    (vct 1.000 0.229 1.129 1.000 0.627 0.696 1.000 0.856 0.263)
			    (vct 1.000 0.128 1.069 1.000 0.364 0.799 1.000 0.545 0.416 1.000 0.643 0.146)
			    (vct 1.000 0.082 1.044 1.000 0.237 0.862 1.000 0.369 0.568 1.000 0.465 0.274 1.000 0.515 0.092)))
	    (poles-10 (list (vct 1.000 1.098 1.103)
			    (vct 1.000 0.279 0.987 1.000 0.674 0.279)
			    (vct 1.000 0.124 0.991 1.000 0.340 0.558 1.000 0.464 0.125)
			    (vct 1.000 0.070 0.994 1.000 0.199 0.724 1.000 0.298 0.341 1.000 0.352 0.070)
			    (vct 1.000 0.045 0.996 1.000 0.130 0.814 1.000 0.203 0.521 1.000 0.255 0.227 1.000 0.283 0.045))))
	(do ((i 2 (+ i 2))
	     (k 0 (+ 1 k)))
	    ((>= i 12))
	  (let ((vals (chebyshev-prototype i .01)))
	    (if (not (vequal1 (cadr vals) (list-ref poles-01 k)))
		(snd-display #__line__ ";chebyshev prototype .01 poles ~A: ~A (~A)" i (cadr vals) (list-ref poles-01 k))))
	  (let ((vals (chebyshev-prototype i .1)))
	    (if (not (vequal1 (cadr vals) (list-ref poles-1 k)))
		(snd-display #__line__ ";chebyshev prototype .1 poles ~A: ~A (~A)" i (cadr vals) (list-ref poles-1 k))))
	  (let ((vals (chebyshev-prototype i)))
	    (if (not (vequal1 (cadr vals) (list-ref poles-10 k)))
		(snd-display #__line__ ";chebyshev prototype 1 poles ~A: ~A (~A)" i (cadr vals) (list-ref poles-10 k)))
	    (if (not (vequal (car vals) (list-ref zeros k)))
		(snd-display #__line__ ";chebyshev prototype .01 zeros ~A: ~A (~A)" i (car vals) (list-ref zeros k))))))
      
      (let* ((f1 (make-chebyshev-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.508 0.512 0.468 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (vct 0.507 0.512 0.467 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
		 (not (vequal1 (cadr vals) (vct 0.508 0.513 0.469 0.001 0.000 0.000 0.000 0.000 0.000 0.000)))
                 (not (vequal1 (cadr vals) (vct 0.509 0.508 0.465 0.001 0.000 0.000 0.000 0.000 0.000 0.000))))
	    (snd-display #__line__ ";chebyshev lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.509 0.500 0.508 0.508 0.507 0.413 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev lp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.465 0.493 0.509 0.508 0.477 0.507 0.508 0.507 0.431 0.000)))
	    (snd-display #__line__ ";chebyshev lp 10 .4 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-chebyshev-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";cheby low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-chebyshev-lowpass 8 .1 .01))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 8 .1 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.492 0.491 0.483 0.006 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 8 .1 .01 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 12 .25 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 12 .1 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.488 0.488 0.488 0.488 0.487 0.403 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev lp 12 .25 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-lowpass 10 .4 .001))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev lp 10 .001 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.497 0.488 0.000)))
	    (snd-display #__line__ ";chebyshev lp 10 .4 .001 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .55) (snd-display #__line__ ";chebyshev hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.341 0.551 0.509 0.466 0.501 0.509 0.505 0.481 0.461)))
	    (snd-display #__line__ ";chebyshev hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .55) (snd-display #__line__ ";chebyshev hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.299 0.554 0.509 0.509 0.500 0.509)))
	    (snd-display #__line__ ";chebyshev hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (and (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.297 0.786 0.677)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.301 0.788 0.660)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.322 0.861 0.724)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.262 0.571 0.509))))
	    (snd-display #__line__ ";chebyshev hp 10 .4 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-highpass 8 .1 .01))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .49) (snd-display #__line__ ";chebyshev hp 8 .1 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.498 0.498 0.492 0.491 0.492 0.492 0.492 0.491 0.491)))
	    (snd-display #__line__ ";chebyshev hp 8 .1 .01 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 12 .25 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";chebyshev hp 12 .1 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.453 0.516 0.489 0.489 0.488 0.488)))
	    (snd-display #__line__ ";chebyshev hp 12 .25 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-highpass 10 .4 .001))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .5) (snd-display #__line__ ";chebyshev hp 10 .001 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.501 0.504 0.504)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.505 0.504)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.002 0.503 0.501 0.497))))
	    (snd-display #__line__ ";chebyshev hp 10 .4 .001 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-chebyshev-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";cheby high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-chebyshev-bandpass 4 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.009 0.449 0.509 0.505 0.442 0.065 0.013 0.003 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 4 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 6 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 6 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.376 0.505 0.498 0.412 0.011 0.001 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 6 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 8 .3 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.002 0.363 0.517 0.513 0.433 0.000)))
	    (snd-display #__line__ ";chebyshev bp 8 .3 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandpass 8 .2 .2 .01))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bp 10 .2 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.015 0.483 0.482 0.021 0.001 0.000 0.000 0.000)))
	    (snd-display #__line__ ";chebyshev bp 10 .2 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-chebyshev-bandstop 4 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.509 0.505 0.447 0.033 0.006 0.006 0.033 0.445 0.512 0.509)))
	    (snd-display #__line__ ";chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandstop 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .51)) .05) (snd-display #__line__ ";chebyshev bs 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.508 0.512 0.468 0.001 0.000 0.000 0.001 0.345 0.551 0.507)))
		 (not (vequal1 (cadr vals) (vct 0.507 0.512 0.467 0.001 0.000 0.000 0.001 0.344 0.549 0.508)))
		 (not (vequal1 (cadr vals) (vct 0.508 0.513 0.469 0.001 0.000 0.000 0.001 0.345 0.552 0.508)))
		 (not (vequal1 (cadr vals) (vct 0.509 0.508 0.465 0.001 0.000 0.000 0.001 0.343 0.548 0.508))))
	    (snd-display #__line__ ";chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-chebyshev-bandstop 8 .1 .4 .01))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";chebyshev bs 8 .01 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.492 0.491 0.483 0.006 0.000 0.000 0.006 0.494 0.495 0.492)))
	    (snd-display #__line__ ";chebyshev bs 8 .1 .4 .01 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- inverse-chebyshev ----------------
      
      (let* ((f1 (make-inverse-chebyshev-lowpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.501 0.496 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001)))
		 (not (vequal1 (cadr vals) (vct 0.500 0.498 0.001 0.000 0.001 0.000 0.000 0.000 0.000 0.001))))
	    (snd-display #__line__ ";inverse-chebyshev lp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.496 0.001 0.001 0.001 0.001 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev lp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 10 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.001 0.001)))
		 (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.497 0.002 0.002))))
	    (snd-display #__line__ ";inverse-chebyshev lp 10 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-lowpass 10 .4 120))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev lp 10 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.501 0.501 0.501 0.501 0.501 0.500 0.345 0.007 0.000 0.000)))
	    (snd-display #__line__ ";inverse-chebyshev lp 10 .4 120 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-inverse-chebyshev-lowpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";inv cheby low max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-inverse-chebyshev-highpass 8 .1))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.001 0.440 0.505 0.505 0.503 0.502 0.501 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 8 .1 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 12 .25))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 12 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.001 0.001 0.001 0.001 0.505 0.506 0.503 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 12 .25 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 10 .4))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 10 .4 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.503 0.503)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.505 0.503)))
		 (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.001 0.001 0.001 0.001 0.001 0.509 0.504))))
	    (snd-display #__line__ ";inverse-chebyshev hp 10 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-highpass 10 .1 120))
	     (vals (sweep->bins f1 10)))
	(if (ffneq (car vals) .51) (snd-display #__line__ ";inverse-chebyshev hp 10 .1 120 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.007 0.328 0.502 0.502 0.502 0.501 0.501 0.501)))
	    (snd-display #__line__ ";inverse-chebyshev hp 10 .1 120 spect: ~A" (cadr vals))))
      
      (do ((i 2 (+ i 2)))
	  ((= i 10))
	(do ((j .1 (+ j .1)))
	    ((>= j .45))
	  (let* ((f1 (make-inverse-chebyshev-highpass i j))
		 (mx (filter-response-max f1)))
	    (if (> mx 1.0)
		(snd-display #__line__ ";inv cheby high max ~A ~A: ~A" i j mx)))))
      
      (let* ((f1 (make-inverse-chebyshev-bandpass 10 .1 .2))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.001 0.498 0.485 0.001 0.001 0.000 0.001 0.000 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .1 .2 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 10 .1 .2 30))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 6 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.026 0.025 0.509 0.505 0.020 0.016 0.012 0.016 0.011 0.016)))
		 (not (vequal1 (cadr vals) (vct 0.030 0.042 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016)))
		 (not (vequal1 (cadr vals) (vct 0.022 0.017 0.511 0.505 0.020 0.016 0.012 0.016 0.011 0.016))))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .1 .2 30 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 8 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.001 0.001 0.440 0.506 0.505 0.503 0.502 0.434 0.001 0.001)))
	    (snd-display #__line__ ";inverse-chebyshev bp 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandpass 8 .3 .4 40))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bp 10 .2 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.002 0.005 0.007 0.007 0.005 0.005 0.503 0.505 0.006 0.005)))
	    (snd-display #__line__ ";inverse-chebyshev bp 10 .2 spect: ~A" (cadr vals))))
      
      (let* ((f1 (make-inverse-chebyshev-bandstop 4 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 4 max: ~A" (car vals)))
	(if (not (vequal1 (cadr vals) (vct 0.500 0.054 0.001 0.001 0.000 0.000 0.000 0.001 0.055 0.503)))
	    (snd-display #__line__ ";inverse-chebyshev bs 4 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandstop 8 .1 .4))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 8 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.501 0.496 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506)))
		 (not (vequal1 (cadr vals) (vct 0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.511)))
		 (not (vequal1 (cadr vals) (vct 0.500 0.498 0.001 0.001 0.000 0.000 0.000 0.001 0.507 0.506))))
	    (snd-display #__line__ ";inverse-chebyshev bs 8 .1 .4 spect: ~A" (cadr vals))))
      (let* ((f1 (make-inverse-chebyshev-bandstop 8 .1 .4 90))
	     (vals (sweep->bins f1 10)))
	(if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";inverse-chebyshev bs 8 90 max: ~A" (car vals)))
	(if (and (not (vequal1 (cadr vals) (vct 0.505 0.325 0.000 0.000 0.000 0.000 0.000 0.000 0.270 0.506)))
		 (not (vequal1 (cadr vals) (vct 0.506 0.328 0.000 0.000 0.000 0.000 0.000 0.000 0.269 0.509)))
		 (not (vequal1 (cadr vals) (vct 0.501 0.327 0.000 0.000 0.000 0.000 0.000 0.000 0.268 0.506))))
	    (snd-display #__line__ ";inverse-chebyshev bs 8 .1 .4 90 spect: ~A" (cadr vals))))
      
      
      ;; ---------------- bessel ----------------
      
      ;; checked poly coeff tables, but the prototype has scaling built in
      
      (if (provided? 'gsl)
	  (begin
	    (let* ((f1 (make-bessel-lowpass 4 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 4 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.500 0.417 0.209 0.062 0.018 0.005 0.001 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 4 .1 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-lowpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 8 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.499 0.365 0.116 0.010 0.001 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-lowpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 12 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.500 0.477 0.410 0.309 0.185 0.063 0.006 0.000 0.000 0.000)))
		  (snd-display #__line__ ";bessel lp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-lowpass 10 .4))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel lp 10 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.001)))
		       (not (vequal1 (cadr vals) (vct 0.500 0.498 0.491 0.479 0.458 0.423 0.364 0.259 0.086 0.002))))
		  (snd-display #__line__ ";bessel lp 10 .4 spect: ~A" (cadr vals))))
	    
	    (do ((i 2 (+ i 2)))
		((= i 12))
	      (do ((j .1 (+ j .1)))
		  ((>= j .45))
		(let* ((f1 (make-bessel-lowpass i j))
		       (mx (filter-response-max f1)))
		  (if (> mx 1.0)
		      (snd-display #__line__ ";bess low max ~A ~A: ~A" i j mx)))))
	    
	    (let* ((f1 (make-bessel-highpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel hp 8 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.001 0.115 0.290 0.386 0.435 0.465 0.483 0.493 0.498 0.500)))
		  (snd-display #__line__ ";bessel hp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-highpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (fneq (car vals) .5) (snd-display #__line__ ";bessel hp 12 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.006 0.063 0.181 0.309 0.410 0.477 0.500)))
		  (snd-display #__line__ ";bessel hp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-bessel-highpass 10 .4))
		   (vals (sweep->bins f1 10)))
	      (if (ffneq (car vals) .5) (snd-display #__line__ ";bessel hp 10 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.004 0.084 0.343 0.499)))
		  (snd-display #__line__ ";bessel hp 10 .4 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-bandpass 4 .1 .2))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .245)) .05) (snd-display #__line__ ";bessel bp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.023 0.176 0.245 0.244 0.179 0.085 0.031 0.008 0.001 0.000)))
		  (snd-display #__line__ ";bessel bp 4 .1 .2 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-bessel-bandstop 12 .1 .2))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .05) (snd-display #__line__ ";bessel bs 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.498 0.325 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500)))
		       (not (vequal1 (cadr vals) (vct 0.499 0.324 0.065 0.066 0.177 0.297 0.389 0.452 0.488 0.500))))
		  (snd-display #__line__ ";bessel bs 12 .1 .2 spect: ~A" (cadr vals))))
	    
	    ;; ---------------- elliptic ----------------
	    
	    (let* ((f1 (make-elliptic-lowpass 8 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.500 0.515 0.379 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (vct 0.500 0.509 0.385 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (vct 0.499 0.498 0.373 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
		  (snd-display #__line__ ";elliptic lp 8 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 12 .25))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.476 0.500 0.491 0.499 0.494 0.412 0.003 0.001 0.000 0.000)))
		       (not (vequal1 (cadr vals) (vct 0.476 0.500 0.491 0.499 0.494 0.561 0.004 0.000 0.000 0.000)))
		       (not (vequal1 (cadr vals) (vct 0.476 0.500 0.491 0.499 0.493 0.299 0.006 0.001 0.000 0.000))))
		  (snd-display #__line__ ";elliptic lp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 4 .4))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.447 0.453 0.462 0.477 0.494 0.500 0.497 0.496 0.445 0.003)))
		  (snd-display #__line__ ";elliptic lp 4 .4 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .1 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .1 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .1 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .1 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.500 0.499 0.475 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .1 .1 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-lowpass 8 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic lp 8 .25 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.500 0.500 0.500 0.500 0.499 0.495 0.001 0.000 0.000 0.000)))
		  (snd-display #__line__ ";elliptic lp 8 .25 .1 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-highpass 4 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.004 0.438 0.516 0.499 0.502 0.495 0.478 0.463 0.453 0.447)))
		  (snd-display #__line__ ";elliptic hp 4 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 12 .25))
		   (vals (sweep->bins f1 10)))
					;(if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 12 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.000 0.001 0.001 0.001 0.026 0.934 0.518 0.495 0.503 0.477)))
		       (not (vequal1 (cadr vals) (vct 0.000 0.001 0.001 0.001 0.033 1.185 0.519 0.495 0.503 0.477)))
		       (not (vequal1 (cadr vals) (vct 0.000 0.001 0.001 0.001 0.018 0.788 0.520 0.495 0.503 0.477))))
		  (snd-display #__line__ ";elliptic hp 12 .25 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 12 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 12 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.000 0.499 0.517 0.503 0.501 0.500 0.500)))
		  (snd-display #__line__ ";elliptic hp 12 .25 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 4 .4))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.001 0.001 0.002 0.023 0.447 0.515 0.502)))
		  (snd-display #__line__ ";elliptic hp 4 .4 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .1 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .1 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.478 0.553 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		  (snd-display #__line__ ";elliptic hp 8 .1 .1 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .1 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .1 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.478 0.554 0.506 0.499 0.501 0.501 0.499 0.497 0.495)))
		  (snd-display #__line__ ";elliptic hp 8 .1 .1 90 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-highpass 8 .25 .01 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic hp 8 .25 90 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.000 0.000 0.000 0.001 0.516 0.517 0.507 0.503 0.501 0.500)))
		  (snd-display #__line__ ";elliptic hp 8 .25 .1 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-bandpass 4 .1 .2 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bp 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.036 0.546 0.550 0.510 0.501 0.032 0.024 0.009 0.021 0.024)))
		  (snd-display #__line__ ";elliptic bp 4 .1 .2 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-bandpass 6 .1 .2 .1 90))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bp 6 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.002 0.511 0.532 0.503 0.492 0.003 0.001 0.001 0.001 0.001)))
		  (snd-display #__line__ ";elliptic bp 6 .1 .2 90 spect: ~A" (cadr vals))))
	    
	    (let* ((f1 (make-elliptic-bandstop 4 .1 .3 .1))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bs 4 max: ~A" (car vals)))
	      (if (not (vequal1 (cadr vals) (vct 0.499 0.502 0.498 0.037 0.050 0.540 0.544 0.527 0.526 0.521)))
		  (snd-display #__line__ ";elliptic bs 4 .1 .2 spect: ~A" (cadr vals))))
	    (let* ((f1 (make-elliptic-bandstop 8 .1 .3 .1 120))
		   (vals (sweep->bins f1 10)))
	      (if (> (abs (- (car vals) .5)) .1) (snd-display #__line__ ";elliptic bs 8 max: ~A" (car vals)))
	      (if (and (not (vequal1 (cadr vals) (vct 0.500 0.499 0.476 0.000 0.000 0.495 0.526 0.505 0.501 0.501)))
		       (not (vequal1 (cadr vals) (vct 0.500 0.499 0.475 0.000 0.000 0.495 0.526 0.505 0.501 0.501))))
		  (snd-display #__line__ ";elliptic bs 8 .1 .2 spect: ~A" (cadr vals))))
	    ))))
  
  (define (test-polyoid n)
    (let* ((res (with-sound (:channels 2 :clipped #f)
			    (let ((angle 0.0)
				  (incr (hz->radians 1.0))
				  (cur-phases (make-vct (* 3 n))))
			      (do ((i 0 (+ i 1))
				   (j 0 (+ j 3)))
				  ((= i n))
				(vct-set! cur-phases j (+ i 1))
				(vct-set! cur-phases (+ j 1) (/ 1.0 n))
				(vct-set! cur-phases (+ j 2) (random (* 2 pi))))
			      (let ((gen (make-polyoid 1.0 cur-phases)))
				(do ((i 0 (+ 1 i)))
				    ((= i 88200))
				  (let ((poly-sum 0.0)
					(sin-sum 0.0))
				    (do ((k 0 (+ 1 k)))
					((= k n))
				      (set! sin-sum (+ sin-sum (sin (+ (* (+ k 1) angle) (vct-ref cur-phases (+ (* 3 k) 2)))))))
				    (set! poly-sum (polyoid gen 0.0))
				    (set! angle (+ angle incr))
				    (outa i (/ sin-sum n))
				    (outb i poly-sum)))))))
	   (snd (find-sound res)))
      (channel-distance snd 0 snd 1)))
  
  (define (test-polyoid-run n)
    (let* ((res (with-sound (:channels 2 :clipped #f)
			    (let ((angle 0.0)
				  (incr (hz->radians 1.0))
				  (cur-phases (make-vct (* 3 n))))
			      (do ((i 0 (+ i 1))
				   (j 0 (+ j 3)))
				  ((= i n))
				(vct-set! cur-phases j (+ i 1))
				(vct-set! cur-phases (+ j 1) (/ 1.0 n))
				(vct-set! cur-phases (+ j 2) (random (* 2 pi))))
			      (let ((gen (make-polyoid 1.0 cur-phases)))
				(run
				 (do ((i 0 (+ 1 i)))
				     ((= i 88200))
				   (let ((poly-sum 0.0)
					 (sin-sum 0.0))
				     (do ((k 0 (+ 1 k)))
					 ((= k n))
				       (set! sin-sum (+ sin-sum (sin (+ (* (+ k 1) angle) (vct-ref cur-phases (+ (* 3 k) 2)))))))
				     (set! poly-sum (polyoid gen 0.0))
				     (set! angle (+ angle incr))
				     (outa i (/ sin-sum n))
				     (outb i poly-sum))))))))
	   (snd (find-sound res)))
      (channel-distance snd 0 snd 1)))
  
  ;; ----------------
  (define (poly-roots-tests)
    (letrec ((ceql (lambda (a b)
		     (if (null? a)
			 (null? b)
			 (if (null? b)
			     #f
			     (if (or (fneq (real-part (car a)) (real-part (car b)))
				     (fneq (imag-part (car a)) (imag-part (car b))))
				 #f
				 (ceql (cdr a) (cdr b))))))))
      
      ;; degree=0
      (let ((val (poly-roots (vct 0.0))))
	(if (not (null? val)) (snd-display #__line__ ";poly-roots 0.0: ~A" val)))
      (let ((val (poly-roots (vct 12.3))))
	(if (not (null? val)) (snd-display #__line__ ";poly-roots 12.3: ~A" val)))
      
      ;; degree 0 + x=0
      (let ((val (poly-roots (vct 0.0 1.0))))
	(if (not (ceql val (list 0.0))) (snd-display #__line__ ";poly-roots 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct 0.0 0.0 0.0 121.0))))
	(if (not (ceql val (list 0.0 0.0 0.0))) (snd-display #__line__ ";poly-roots 0.0 0.0 0.0 121.0: ~A" val)))
      
      ;; degree=1
      (let ((val (poly-roots (vct -1.0 1.0))))
	(if (not (ceql val (list 1.0))) (snd-display #__line__ ";poly-roots -1.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct -2.0 4.0))))
	(if (not (ceql val (list 0.5))) (snd-display #__line__ ";poly-roots -2.0 4.0: ~A" val)))
      (let ((val (poly-as-vector-roots (vector 0.0-i 1))))
	(if (not (ceql val (list -0.0+1.0i))) (snd-display #__line__ ";poly-roots: -i 1: ~A" val)))
      
      ;; linear x^n
      (let ((val (poly-roots (vct -1.0 0.0 0.0 0.0 1.0))))
	(if (and (not (ceql val (list 0.0-1.0i -1.0 0.0+1.0i 1.0)))
		 (not (ceql val (list 1.0 -1.0 0.0+1.0i -0.0-1.0i))))
	    (snd-display #__line__ ";poly-roots -1.0 0.0 0.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct -16.0 0.0 0.0 0.0 1.0))))
	(if (and (not (ceql val (list 0.0-2.0i -2.0 0.0+2.0i 2.0)))
		 (not (ceql val (list 2.0 -2.0 0.0+2.0i -0.0-2.0i))))
	    (snd-display #__line__ ";poly-roots -16.0 0.0 0.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct -32.0 0 0 0 0 0 0.5))))
	(if (not (ceql val (list 1.0-1.7320i -1.0-1.7320i -2.0 -1.0+1.7320i 1.0+1.7320i 2.0))) (snd-display #__line__ ";poly-roots 32 0 0 0 0 0 0.5: ~A" val)))
      
      ;; linear + x=0
      (let ((val (poly-roots (vct 0.0 -2.0 4.0))))
	(if (not (ceql val (list 0.0 0.5))) (snd-display #__line__ ";poly-roots 0.0 -2.0 4.0: ~A" val)))
      
      ;; degree=2
      (let ((val (poly-roots (vct -1.0 0.0 1.0))))
	(if (not (ceql val (list 1.0 -1.0))) (snd-display #__line__ ";poly-roots -1.0 0.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct 15.0 -8.0 1.0))))
	(if (not (ceql val (list 5.0 3.0))) (snd-display #__line__ ";poly-roots 15.0 -8.0 1.0: ~A" val)))
      (let ((val (poly-roots (vct 1 -2 1))))
	(if (not (ceql val (list 1.0 1.0))) (snd-display #__line__ ";poly-roots 1 -2 1: ~A" val)))
      (let ((val (poly-as-vector-roots (vector -1 0.0+2i 1))))
	(if (not (ceql val (list 0.0-1.0i 0.0-1.0i))) (snd-display #__line__ ";poly-roots -1 2i 1: ~A" val)))
      (let ((val (poly-roots (vct 1 1 5))))
	(if (not (ceql val (list -0.1+0.43589i -0.1-0.43589i))) (snd-display #__line__ ";poly-roots 1 1 5: ~A" val)))
      
      ;; 2 + x=0
      (let ((val (poly-roots (vct 0.0 0.0 -1.0 0.0 1.0))))
	(if (not (ceql val (list 0.0 0.0 1.0 -1.0))) (snd-display #__line__ ";poly-roots 0.0 0.0 -1.0 0.0 1.0: ~A" val)))
      
      ;; quadratic in x^(n/2)
      (let ((vals (poly-roots (vct 1.0 0.0 -2.0 0.0 1.0))))
	(if (and (not (ceql vals (list -1.0 1.0 -1.0 1.0)))
		 (not (ceql vals (list 1.0 1.0 -1.0 -1.0))))
	    (snd-display #__line__ ";poly-roots 1 0 -2 0 1: ~A" vals)))
      (let ((vals (poly-roots (vct 64.0 0.0 0.0 -16.0 0.0 0.0 1.0))))
	(if (not (ceql vals (list -1.0-1.73205i -1.0+1.73205i 2.0 -1.0-1.73205i -1.0+1.73205i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 0 0 -16 0 0 1: ~A" vals)))
      
      ;; degree=3
      (let ((val (poly-roots (vct -15.0 23.0 -9.0 1.0))))
	(if (not (ceql val (list 5.0 1.0 3.0))) (snd-display #__line__ ";poly-roots 5 1 3: ~A" val)))
      (let ((val (poly-roots (vct -126 -15 0 1))))
	(if (not (ceql val (list 6.0 -3.0+3.46410i -3.0-3.46410i))) (snd-display #__line__ ";poly-roots -126 -15 0 1: ~A" val)))
      
      (let ((val (poly-roots (vct -1 3 -3 1))))
	(if (not (ceql val (list 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots -1 3 -3 1: ~A" val))) 
      (let ((val (poly-roots (vct 1 -1 -1 1))))
	(if (and (not (ceql val (list 1.0 -1.0 1.0))) 
		 (not (ceql val (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 1 -1 1: ~A" val)))
      (let ((val (poly-roots (vct 2 -2 -2 2))))
	(if (and (not (ceql val (list 1.0 -1.0 1.0))) 
		 (not (ceql val (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 2 -2 -2 2: ~A" val)))
      
      ;; degree=4
					;      (let ((vals (poly-roots (vct -15 8 14 -8 1))))
					;	(if (not (ceql vals (list 5.0 3.0 1.0 -1.0))) (snd-display #__line__ ";poly-roots -15 8 14 -8 1: ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (vct 2 1) (vct -3 1)) (poly* (vct 8 1) (vct -9 1)))))))
					;	(if (not (ceql vals (list 9.0 3.0 -2.0 -8.0))) (snd-display #__line__ ";poly-roots 4(1): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (vct .2 1) (vct -3 1)) (poly* (vct .8 1) (vct -9 1)))))))
					;	(if (not (ceql vals (list 9.0 3.0 -0.2 -0.8))) (snd-display #__line__ ";poly-roots 4(2): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (poly* (vct .02 1) (vct -32 1)) (poly* (vct .8 1) (vct -9 1)))))))
					;	(if (not (ceql vals (list 32.0 9.0 -0.02 -0.8))) (snd-display #__line__ ";poly-roots 4(3): ~A" vals)))
      
      ;; degree>4
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct 1 1) (poly* (poly* (vct 2 1) (vct -3 1)) (poly* (vct -1 1) (vct -2 1))))))))
					;	(if (not (ceql vals (list 3.0 2.0 -1.0 -2.0 1.0))) 
					;	    (snd-display #__line__ ";poly-roots n(1): ~A from ~A ~A ~A" 
					;			 vals 
					;			 (poly-reduce (poly* (vct 1 1) (poly* (poly* (vct 2 1) (vct -3 1)) (poly* (vct -1 1) (vct -2 1)))))
					;			 (mus-float-equal-fudge-factor) 
					;			 poly-roots-epsilon)))
      
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct 1 1) (poly* (poly* (vct 2 1) (vct -3 1)) (poly* (vct 8 1) (vct -9 1))))))))
					;	(if (not (ceql vals (list 9.0 3.0 -2.0 -8.0 -1.0))) (snd-display #__line__ ";poly-roots n(2): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct -1 0 1) (poly* (poly* (vct 9 1) (vct -3 1)) (poly* (vct -10 1) (vct -2 1))))))))
					;	(if (not (ceql vals (list 10.0 3.0 -1.0 -9.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(3): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct -1 0 1) (poly* (poly* (vct -4 0 1) (vct -3 1)) (poly* (vct -10 1) (vct -9 0 1))))))))
					;	(if (not (ceql vals (list 10.0 3.0 -2.0 -3.0 -1.0 3.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(4): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct -1 0 1) (poly* (poly* (vct -4 0 1) (vct -16 0 1)) (poly* (vct -25 0 1) (vct -9 0 1))))))))
					;	(if (not (ceql vals (list 5.0 -3.0 -4.0 -5.0 4.0 -2.0 3.0 -1.0 2.0 1.0))) (snd-display #__line__ ";poly-roots n(5): ~A" vals)))
					;      (let ((vals (poly-roots (poly-reduce (poly* (vct 1 1) (poly* (poly* (vct 2 1) (vct -3 1)) (poly* (vct 1 1) (vct -2 1))))))))
					;	(if (not (ceql vals (list 3.0 -1.0 -1.0 -2.0 2.0))) (snd-display #__line__ ";poly-roots n(6): ~A" vals)))
      (let ((vals (poly-roots (vct -64 0 0 0 0 0 1))))
	(if (not (ceql vals (list 0.999999999999999-1.73205080756888i -1.0-1.73205080756888i -2.0 -1.0+1.73205080756888i 1.0+1.73205080756888i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 6: ~A" vals)))
      (let ((vals (poly-roots (vct 64 0 0 -16 0 0 1))))
	(if (not (ceql vals (list -1.0-1.73205080756888i -1.0+1.73205080756888i 2.0 -1.0-1.73205080756888i -1.0+1.73205080756888i 2.0)))
	    (snd-display #__line__ ";poly-roots 64 16 6: ~A" vals)))
      (do ((i 0 (+ 1 i))) ((= i 10)) (poly-roots (vct (random 1.0) (random 1.0) (random 1.0))))
      (do ((i 0 (+ 1 i))) ((= i 10)) (poly-roots (vct (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
      
      (let ((vals1 (convolution (vct 1 2 3 0 0 0 0 0) (vct 1 2 3 0 0 0 0 0) 8))
	    (vals2 (poly* (vct 1 2 3 0) (vct 1 2 3 0))))
	(if (not (vequal vals1 vals2))
	    (snd-display #__line__ ";poly* convolve: ~A ~A" vals1 vals2)))
      
      
      (do ((i 0 (+ 1 i))) ((= i 10)) 
	(poly-as-vector-roots (vector (make-rectangular (mus-random 1.0) (mus-random 1.0)) 
				      (make-rectangular (mus-random 1.0) (mus-random 1.0)))))
      (do ((i 0 (+ 1 i))) ((= i 10)) 
	(poly-as-vector-roots (vector (make-rectangular (mus-random 1.0) (mus-random 1.0)) 
				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
				      (make-rectangular (mus-random 1.0) (mus-random 1.0)))))
      
      (do ((i 0 (+ 1 i))) ((= i 10)) 
	(poly-roots (vct (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
      
      (do ((i 0 (+ 1 i))) ((= i 10)) 
	(poly-as-vector-roots (vector (make-rectangular (mus-random 1.0) (mus-random 1.0)) 
				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
				      (make-rectangular (mus-random 1.0) (mus-random 1.0)))))
      
					;      (do ((i 0 (+ 1 i))) ((= i 10)) 
					;	(poly-roots (vct (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0) (mus-random 1.0))))
					;      
					;      (do ((i 0 (+ 1 i))) ((= i 10)) 
					;	(poly-as-vector-roots (vector (make-rectangular (mus-random 1.0) (mus-random 1.0)) 
					;				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
					;				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
					;				      (make-rectangular (mus-random 1.0) (mus-random 1.0))
					;				      (make-rectangular (mus-random 1.0) (mus-random 1.0)))))
      
      (do ((i 3 (+ 1 i))) ((= i 20)) 
	(let ((v (make-vct i 0.0)))
	  (vct-set! v 0 (mus-random 1.0))
	  (vct-set! v (- i 1) 1.0)
	  (poly-roots v)))
      
      (do ((i 3 (+ i 2))) ((= i 21)) 
	(let ((v (make-vct i 0.0)))
	  (vct-set! v 0 (mus-random 1.0))
	  (vct-set! v (- i 1) 1.0)
	  (vct-set! v (/ (- i 1) 2) 1.0)
	  (poly-roots v)))
      
      (let ((vals (poly-roots (vct 1 -1 -1 1))))
	(if (and (not (ceql vals (list 1.0 -1.0 1.0))) 
		 (not (ceql vals (list -1.0 1.0 1.0))))
	    (snd-display #__line__ ";poly-roots 1-1-11: ~A" vals)))
      (let ((vals (poly-roots (vct 2 -1 -2 1))))
	(if (not (ceql vals (list 2.0 -1.0 1.0))) (snd-display #__line__ ";poly-roots 2-1-21: ~A" vals)))
      (let ((vals (poly-roots (vct -1 1 1 1))))
	(if (not (ceql vals (list 0.543689012692076 -0.771844506346038+1.11514250803994i -0.771844506346038-1.11514250803994i)))
	    (snd-display #__line__ ";poly-roots -1111: ~A" vals)))
      (let ((vals (poly-roots (vct -1 3 -3 1))))
	(if (not (ceql vals (list 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots -13-31: ~A" vals)))
					;      (let ((vals (poly-roots (vct 1 -4 6 -4 1))))
					;	(if (not (ceql vals (list 1.0 1.0 1.0 1.0))) (snd-display #__line__ ";poly-roots 1-46-41: ~A" vals)))
      (let ((vals (poly-roots (vct 0.5 0 0 1.0))))
	(if (and (not (ceql vals (list 0.396850262992049-0.687364818499302i -0.7937005259841 0.39685026299205+0.687364818499301i)))
		 (not (ceql vals (list 0.39685026299205+0.687364818499301i 0.39685026299205-0.687364818499301i -0.7937005259841)))
		 (not (ceql vals (list -7.9370052598409979172089E-1 3.968502629920498958E-1+6.873648184993013E-1i 3.96850262992049E-1-6.873648184993E-1i))))
	    (snd-display #__line__ ";poly-roots 0..5 3: ~A" vals)))
      (let ((vals (poly-roots (poly* (poly* (poly* (vct -1 1) (vct 1 1)) (poly* (vct -2 1) (vct 2 1))) (poly* (vct -3 1) (vct 3 1))))))
	(if (not (ceql vals (list -3.0 3.0 -1.0 1.0 -2.0 2.0)))
	    (snd-display #__line__ ";cube in 2: ~A" vals)))
      ))
  
  ;; ----------------
  (define (fltit)
    "(fltit) returns a time-varying filter: (map-chan (fltit))"
    (let* ((coeffs (list .1 .2 .3 .4 .4 .3 .2 .1))
	   (flt (make-fir-filter 8 (list->vct coeffs)))
	   (es (make-vector 8)))
      (do ((i 0 (+ 1 i)))
	  ((= i 8))
	(vector-set! es i (make-env (list 0 (list-ref coeffs i) 1 0) :length 101)))
      (vector-set! es 5 (make-env '(0 .4 1 1) :duration 1.0))
      (lambda (x)
	(let ((val (fir-filter flt x))
	      (xcof (mus-xcoeffs flt)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 8))
	    (vct-set! xcof i (env (vector-ref es i))))
	  val))))
  
  ;; ----------------
  (define (freq-sweep dur)
    (let ((phase 0.0)
	  (freq 0.0)
	  (incr (/ pi (* dur 1.05 (mus-srate)))))
      (map-channel 
       (lambda (y)
	 (let ((val (sin phase))) 
	   (set! phase (+ phase freq)) 
	   (set! freq (+ freq incr))
	   (* .5 val))))))
  
  ;; ----------------
  (define* (make-ssb-am-1 freq (order 40))
    (if (even? order) (set! order (+ 1 order)))
    (make-sa1 :freq (abs freq)
	      :coscar (make-oscil freq (* .5 pi))
	      :sincar (make-oscil freq)
	      :dly (make-delay order)
	      :hlb (make-hilbert-transform order)))
  
  ;; ----------------
  (define* (ssb-am-1 gen y (fm-1 0.0))
    (let* ((fm fm-1)
	   (ccos (oscil (sa1-coscar gen) fm))
	   (csin (oscil (sa1-sincar gen) fm))
	   (yh (hilbert-transform (sa1-hlb gen) y))
	   (yd (delay (sa1-dly gen) y)))
      (if (> (sa1-freq gen) 0.0)
	  (- (* ccos yd) ; shift up
	     (* csin yh))
	  (+ (* ccos yd) ; shift down
	     (* csin yh)))))
  
  ;; ----------------
  (define (rough-spectrum ind)
    (let ((r (make-sampler 0 ind 0))
	  (spect (make-vct 10))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let ((sum 0.0))
	  (do ((j 0 (+ 1 j)))
	      ((= j 1000))
	    (let ((val (r)))
	      (set! sum (+ sum (* val val)))))
	  (if (> sum mx) (set! mx sum))
	  (vct-set! spect i sum)))
      (vct-scale! spect (/ 1.0 mx))))
  
  ;; ----------------
  (define* (print-and-check gen name desc (desc1 "") (desc2 ""))
    
    (if (not (string=? (mus-name gen) name))
	(snd-display #__line__ ";mus-name ~A: ~A?" name (mus-name gen)))
    (if (and (not (string=? (mus-describe gen) desc))
	     (not (string=? (mus-describe gen) desc1))
	     (not (string=? (mus-describe gen) desc2)))
	(snd-display #__line__ ";mus-describe ~A: ~A?" (mus-name gen) (mus-describe gen)))
    (let ((egen gen))
      (if (not (equal? egen gen))
	  (snd-display #__line__ ";equal? ~A: ~A?" gen egen))))
  
  ;; ----------------
  (define (test-gen-equal g0 g1 g2)
    ;; g0 = g1 at start != g2
    
    (let ((g3 g0)
	  (gad (make-frame 2)))
      (if (not (eq? g0 g3))
	  (snd-display #__line__ ";let ~A not eq? ~A ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display #__line__ ";arg ~A eq? ~A ~A" (mus-name g0) g0 g1))
      (if (not (equal? g0 g1))
	  (snd-display #__line__ ";~A not equal? ~A ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display #__line__ ";~A equal? ~A ~A" (mus-name g0) g0 g2))
      (if (equal? g0 gad)
	  (snd-display #__line__ ";~A equal frame? ~A ~A" (mus-name g0) g0 gad))
      (g0)
      (g3)
      (g3)
      (if (not (eq? g0 g3))
	  (snd-display #__line__ ";run let ~A not eq? ~A ~A" (mus-name g0) g0 g3))
      (if (eq? g0 g1)
	  (snd-display #__line__ ";arg ~A eq? ~A ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g1)
	  (snd-display #__line__ ";run ~A equal? ~A ~A" (mus-name g0) g0 g1))
      (if (equal? g0 g2)
	  (snd-display #__line__ ";run ~A equal? ~A ~A" (mus-name g0) g0 g2))))
  
  ;; ----------------
  (define (fm-test gen)
    (if (not (mus-generator? gen)) (snd-display #__line__ ";~A not a gen?" gen))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 0.0)
    (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";~A phase(0): ~A" gen (mus-phase gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";~A phase(1): ~A" gen (mus-phase gen)))
    (gen 0.0)
    (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";~A phase(1, 0): ~A" gen (mus-phase gen)))
    (set! (mus-frequency gen) (radians->hz 2.0))
    (if (fneq (mus-increment gen) 2.0) (snd-display #__line__ ";~A increment: ~A" gen (mus-increment gen)))
    (set! (mus-increment gen) 2.0)
    (if (fneq (mus-frequency gen) (radians->hz 2.0)) (snd-display #__line__ ";~A set increment: ~A ~A" gen (mus-increment gen) (hz->radians (mus-frequency gen))))
    (gen 0.0)
    (if (fneq (mus-phase gen) 3.0) (snd-display #__line__ ";~A phase(1, 2): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (gen 1.0)
    (if (fneq (mus-phase gen) 6.0) (snd-display #__line__ ";~A phase(3, 2, 1): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (do ((i 0 (+ 1 i))) ((= i 10)) (gen 10.0))
    (if (fneq (mus-phase gen) (+ 26 (- 100 (* 2 pi 20)))) (snd-display #__line__ ";~A phase (over): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen 1234567812345678)
    (gen -1234567812345678)
    (set! (mus-frequency gen) 0.0)
    (set! (mus-phase gen) 0.0)
    (gen -2.0)
    (if (and (fneq (mus-phase gen) -2.0)
	     (fneq (mus-phase gen) (- (* 2 pi) 2.0)))
	(snd-display #__line__ ";phase: ~A freq: ~A" (mus-phase gen))))
  
  ;; ----------------
  ;; from mixer.scm (commented out)
  (define (frame-cross m1 m2)
    (if (or (not (= (mus-length m1) 3))
	    (not (= (mus-length m2) 3)))
	(snd-print "cross product only in 3 dimensions")
	(make-frame 3 
		    (- (* (frame-ref m1 1) (frame-ref m2 2)) 
		       (* (frame-ref m1 2) (frame-ref m2 1)))
		    (- (* (frame-ref m1 2) (frame-ref m2 0)) 
		       (* (frame-ref m1 0) (frame-ref m2 2)))
		    (- (* (frame-ref m1 0) (frame-ref m2 1)) 
		       (* (frame-ref m1 1) (frame-ref m2 0))))))
  
  ;; ----------------
  (define (frame-normalize f)
    (let ((mag (sqrt (dot-product (mus-data f) (mus-data f)))))
      (if (> mag 0.0)
	  (frame* f (/ 1.0 mag))
	  f)))
  
  ;; ----------------
  (define* (agc (ramp-speed .001) (window-size 512))
    (let ((maxer (make-moving-max window-size))
	  (mult 1.0))
      (map-channel
       (lambda (y)
	 (let* ((curmax (moving-max maxer y))
		(diff (- 0.5 (* mult curmax)))
		(this-incr (* diff ramp-speed)))
	   (set! mult (+ mult this-incr))
	   (* y mult))))))
  
  ;; ----------------
  (define (numerical-reality-checks)
    ;; a few reality checks from John Burkardt test_values.C
    
    (let ((vals (vector 1.6709637479564564156 1.5707963267948966192 1.4706289056333368229 1.3694384060045658278 1.2661036727794991113 
			1.1592794807274085998 1.0471975511965977462 0.92729521800161223243 0.79539883018414355549 0.64350110879328438680 
			0.45102681179626243254 0.00000000000000000000))
	  (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 12))
	(let* ((nval (acos (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";acos: ~A" max-bad)))
    
    (let ((vals (vector 0.0000000000000000000 0.14130376948564857735 0.44356825438511518913 0.62236250371477866781 0.75643291085695958624 
			0.86701472649056510395 0.96242365011920689500 1.3169578969248167086 1.7627471740390860505 1.8115262724608531070 
			2.0634370688955605467 2.2924316695611776878 2.9932228461263808979 5.2982923656104845907 7.6009022095419886114))
	  (args (vector 1.0 1.01 1.1 1.2 1.3 1.4 1.5 2.0 3.0 3.1415926535897932385 4.0 5.0 10.0 100.0 1000.0))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 15))
	(let* ((nval (acosh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";acosh: ~A" max-bad)))
    
    (let ((vals (vector -0.10016742116155979635 0.00000000000000000000 0.10016742116155979635 0.20135792079033079146 0.30469265401539750797 
			0.41151684606748801938 0.52359877559829887308 0.64350110879328438680 0.77539749661075306374 0.92729521800161223243 
			1.1197695149986341867 1.5707963267948966192))
	  (args (vector -0.1 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 12))
	(let* ((nval (asin (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";asin: ~A" max-bad)))
    
    (let ((vals (vector -2.3124383412727526203 -0.88137358701954302523 0.00000000000000000000 0.099834078899207563327 0.19869011034924140647 
			0.29567304756342243910 0.39003531977071527608 0.48121182505960344750 0.56882489873224753010 0.65266656608235578681 
			0.73266825604541086415 0.80886693565278246251 0.88137358701954302523 1.4436354751788103425 1.8184464592320668235 
			2.0947125472611012942 2.3124383412727526203 2.9982229502979697388 5.2983423656105887574 7.6009027095419886115))
	  (args (vector -5.0 -1.0 0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 2.0 3.0 4.0 5.0 10.0 100.0 1000.0))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 20))
	(let* ((nval (asinh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))
	  (if (> max-bad 1.0e-14)
	      (snd-display #__line__ ";asinh(~A): ~A ~A -> ~A" (vector-ref args i) nval (vector-ref vals i) max-bad)))))
    
    (let ((vals (vector 0.00000000000000000000 0.24497866312686415417 0.32175055439664219340 0.46364760900080611621 0.78539816339744830962 
			1.1071487177940905030 1.2490457723982544258 1.3258176636680324651 1.3734007669450158609 1.4711276743037345919 1.5208379310729538578))
	  (args (vector 0.00000000000000000000 0.25000000000000000000 0.33333333333333333333 0.50000000000000000000 1.0000000000000000000 
			2.0000000000000000000 3.0000000000000000000 4.0000000000000000000 5.0000000000000000000 10.000000000000000000 20.000000000000000000))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(let* ((nval (atan (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) (set! max-bad diff))))
      (if (> max-bad 1.0e-15)
	  (snd-display #__line__ ";atan: ~A" max-bad)))
    
    (let ((vals (vector -0.54930614433405484570 0.00000000000000000000 0.0010000003333335333335 0.10033534773107558064 0.20273255405408219099 
			0.30951960420311171547 0.42364893019360180686 0.54930614433405484570 0.69314718055994530942 0.86730052769405319443 
			1.0986122886681096914 1.4722194895832202300 2.6466524123622461977 3.8002011672502000318 7.2543286192620472067))
	  (args (vector -0.5 0.0 0.001 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.999999))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 15))
	(let* ((nval (atanh (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-10) ; one is > e-11
	      (snd-display #__line__ ";atanh(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.1000000000000000E+01 0.1010025027795146E+01 0.1040401782229341E+01 0.1092045364317340E+01 0.1166514922869803E+01 
			0.1266065877752008E+01 0.1393725584134064E+01 0.1553395099731217E+01 0.1749980639738909E+01 0.1989559356618051E+01 
			0.2279585302336067E+01 0.3289839144050123E+01 0.4880792585865024E+01 0.7378203432225480E+01 0.1130192195213633E+02 
			0.1748117185560928E+02 0.2723987182360445E+02 0.6723440697647798E+02 0.4275641157218048E+03 0.2815716628466254E+04))
	  (args (vector 0.00E+00 0.20E+00 0.40E+00 0.60E+00 0.80E+00 0.10E+01 0.12E+01 0.14E+01 0.16E+01 0.18E+01 0.20E+01 0.25E+01 0.30E+01 
			0.35E+01 0.40E+01 0.45E+01 0.50E+01 0.60E+01 0.80E+01 
			0.10E+02))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 20))
	(let* ((nval (bes-i0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-4)
	      (snd-display #__line__ ";bes-i0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1775967713143383E+00 -0.3971498098638474E+00 -0.2600519549019334E+00 0.2238907791412357E+00 0.7651976865579666E+00 
			0.1000000000000000E+01 0.7651976865579666E+00 0.2238907791412357E+00 -0.2600519549019334E+00 -0.3971498098638474E+00 
			-0.1775967713143383E+00 0.1506452572509969E+00 0.3000792705195556E+00 0.1716508071375539E+00 -0.9033361118287613E-01 
			-0.2459357644513483E+00 -0.1711903004071961E+00 0.4768931079683354E-01 0.2069261023770678E+00 0.1710734761104587E+00 -0.1422447282678077E-01))
	  (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
			9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 21))
	(let* ((nval (bes-j0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-j0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.3275791375914652E+00 0.6604332802354914E-01 -0.3390589585259365E+00 -0.5767248077568734E+00 -0.4400505857449335E+00 
			0.0000000000000000E+00 0.4400505857449335E+00 0.5767248077568734E+00 0.3390589585259365E+00 -0.6604332802354914E-01 
			-0.3275791375914652E+00 -0.2766838581275656E+00 -0.4682823482345833E-02 0.2346363468539146E+00 0.2453117865733253E+00 
			0.4347274616886144E-01 -0.1767852989567215E+00 -0.2234471044906276E+00 -0.7031805212177837E-01 0.1333751546987933E+00 0.2051040386135228E+00))
	  (args (vector -5.0E+00 -4.0E+00 -3.0E+00 -2.0E+00 -1.0E+00 0.0E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 
			9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 21))
	(let* ((nval (bes-j1 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-j1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector 0.1149034849319005E+00 0.3528340286156377E+00 0.4656511627775222E-01 0.2546303136851206E+00 -0.5971280079425882E-01 
			0.2497577302112344E-03 0.7039629755871685E-02 0.2611405461201701E+00 -0.2340615281867936E+00 -0.8140024769656964E-01 
			0.2630615123687453E-09 0.2515386282716737E-06 0.1467802647310474E-02 0.2074861066333589E+00 -0.1138478491494694E+00 
			0.3873503008524658E-24 0.3918972805090754E-18 0.2770330052128942E-10 0.1151336924781340E-04 -0.1167043527595797E+00))
	  (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20 20)) 
	  (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
			50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 20))
	(let* ((nval (bes-jn (vector-ref ns i) (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-jn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1534238651350367E+01 0.8825696421567696E-01 0.5103756726497451E+00 0.3768500100127904E+00 -0.1694073932506499E-01 
			-0.3085176252490338E+00 -0.2881946839815792E+00 -0.2594974396720926E-01 0.2235214893875662E+00 0.2499366982850247E+00 
			0.5567116728359939E-01 -0.1688473238920795E+00 -0.2252373126343614E+00 -0.7820786452787591E-01 0.1271925685821837E+00 0.2054642960389183E+00))
	  (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 16))
	(let* ((nval (bes-y0 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-15)
	      (snd-display #__line__ ";bes-y0(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.6458951094702027E+01 -0.7812128213002887E+00 -0.1070324315409375E+00 0.3246744247918000E+00 0.3979257105571000E+00 
			0.1478631433912268E+00 -0.1750103443003983E+00 -0.3026672370241849E+00 -0.1580604617312475E+00 0.1043145751967159E+00 
			0.2490154242069539E+00 0.1637055374149429E+00 -0.5709921826089652E-01 -0.2100814084206935E+00 -0.1666448418561723E+00 0.2107362803687351E-01))
	  (args (vector 0.1E+00 1.0E+00 2.0E+00 3.0E+00 4.0E+00 5.0E+00 6.0E+00 7.0E+00 8.0E+00 9.0E+00 10.0E+00 11.0E+00 12.0E+00 13.0E+00 14.0E+00 15.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 16))
	(let* ((nval (bes-y1 (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (> diff 1.0e-14)
	      (snd-display #__line__ ";bes-y1(~A): ~A ~A -> ~A" (vector-ref args i) (vector-ref vals i) nval diff)))))
    
    (let ((vals (vector -0.1650682606816254E+01 -0.6174081041906827E+00 0.3676628826055245E+00 -0.5868082442208615E-02 0.9579316872759649E-01 
			-0.2604058666258122E+03 -0.9935989128481975E+01 -0.4536948224911019E+00 0.1354030476893623E+00 -0.7854841391308165E-01 
			-0.1216180142786892E+09 -0.1291845422080393E+06 -0.2512911009561010E+02 -0.3598141521834027E+00 0.5723897182053514E-02 
			-40816513889983664.0 -0.5933965296914321E+09 -0.1597483848269626E+04 0.1644263394811578E-01))
	  
	  ;; yn(20, 2.0) prints -40816513889983664.0 but I guess due to float inaccuracies (bes-yn 20 2.0) is -40816513889983672.0?
	  
	  (ns (vector 2 2 2 2 2 5 5 5 5 5 10 10 10 10 10 20 20 20 20))
	  (args (vector 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00 1.0E+00 2.0E+00 5.0E+00 10.0E+00 
			50.0E+00 2.0E+00 5.0E+00 10.0E+00 50.0E+00))
	  (max-bad 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 19))
	(let* ((nval (bes-yn (vector-ref ns i) (vector-ref args i)))
	       (diff (abs (- nval (vector-ref vals i)))))
	  (if (> diff max-bad) 
	      (set! max-bad diff))
	  (if (and (> diff 1.0e-6)
		   (not (= i 15))) ; see above
	      (snd-display #__line__ ";bes-yn(~A ~A): ~A ~A -> ~A" (vector-ref ns i) (vector-ref args i) (vector-ref vals i) nval diff)))))
    ;; one (20 1.0) is off by a lot but the val is 1e22 
    
    ;; numerics stuff
    (let ((ns (vector 1 6 6 6 15 15 15 15 15 15 15))
	  (ks (vector 0 1 3 5 1  3  5  7  9  11 13))
	  (vals (vector 1 6 20 6 15 455 3003 6435 5005 1365 105)))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(let* ((nval (binomial-direct (vector-ref ns i) (vector-ref ks i)))
	       (mval (n-choose-k (vector-ref ns i) (vector-ref ks i))))
	  (if (or (not (= nval (vector-ref vals i)))
		  (not (= mval (vector-ref vals i))))
	      (snd-display #__line__ ";binomial(~A ~A): ~A ~A ~A" (vector-ref ns i) (vector-ref ks i) nval mval (vector-ref vals i))))))
    
    (let ((ls (vector 1 1 1 1 1 2 2 2 3 3 3 3 4 5 6 7 8 9 10))
	  (ms (vector 0 0 0 0 1 0 1 2 0 1 2 3 2 2 3 3 4 4 5))
	  (vals (vector 0.000000 0.500000 0.707107 1.000000 -0.866025 -0.125000 -1.29904  2.25000 -0.437500 -0.324759 5.62500 -9.74278 
			4.21875 -4.92187  12.7874  116.685 -1050.67 -2078.49  30086.2))
	  (xs (vector 0.0 0.5 0.7071067 1.0  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5 0.5  0.5 0.5 0.5)))
      (do ((i 0 (+ 1 i)))
	  ((= i 19))
	(let ((val (plgndr (vector-ref ls i) (vector-ref ms i) (vector-ref xs i))))
	  (if (or (not (real? val))
		  (not (real? (vector-ref vals i)))
		  (> (abs (- val (vector-ref vals i))) 0.1))
	      (snd-display #__line__ ";plgndr(~A ~A ~A) = ~A (~A)" (vector-ref ls i) (vector-ref ms i) (vector-ref xs i) val (vector-ref vals i))))))
    
    (let ((vals (vector  1.0000000000  0.8000000000  0.2800000000  -0.3520000000 -0.8432000000 -0.9971200000 
			 -0.7521920000 -0.2063872000  0.4219724800  0.8815431680  0.9884965888  0.7000513741  0.1315856097))
	  (ns (vector  0  1  2   3  4  5   6  7  8   9 10 11 	   12))
	  (xs (vector    0.8  0.8  0.8     0.8  0.8  0.8     0.8  0.8  0.8     0.8  0.8  0.8     0.8)))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 13))
	(let ((val (chebyshev (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";chebyshev ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (order (random 10))
	       (val1 (gegenbauer order x 1.0))
	       (val2 (chebyshev order x 2)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer/chebyshev (alpha=1) ~A ~A: ~A ~A" order x val1 val2)))))
    
    (let ((as (vector      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.5      0.5  0.5  0.0      1.0  2.0  3.0 
			   4.0  5.0  6.0      7.0  8.0  9.0     10.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0      3.0  3.0  3.0 
			   3.0  3.0  3.0      3.0  3.0))
	  (vals (vector    1.0000000000   0.2000000000  -0.4400000000    -0.2800000000   0.2320000000   0.3075200000 
			   -0.0805760000  -0.2935168000  -0.0395648000     0.2459712000   0.1290720256   0.696706 ; was 0 but explicit formula says 2/n cos(nx)
			   -0.3600000000  -0.0800000000   0.8400000000     2.4000000000   4.6000000000   7.4400000000    10.9200000000  15.0400000000  19.8000000000 
			   25.2000000000  9.0000000000  -0.1612800000 ; was -9 but that is wrong (see G&R explicit formula)
			   -6.6729600000  -8.3750400000  -5.5267200000     0.0000000000   5.5267200000   8.3750400000     6.6729600000   0.1612800000  -9.0000000000  
			   -15.4252800000  -9.6969600000  22.4409600000   100.8892800000 252.0000000000))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10  2      2  2  2      2  2  2      2  2  2      2  5  5      5  5  5 
			  5  5  5      5  5  5      5  5  5      5  5))
	  (xs (vector    0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.20     0.20  0.20  0.40     0.40  0.40  0.40 
			 0.40  0.40  0.40     0.40  0.40  0.40     0.40 -0.50 -0.40    -0.30 -0.20 -0.10     0.00  0.10  0.20 
			 0.30  0.40  0.50     0.60  0.70  0.80     0.90  1.00)))
      
      (define (g3 x alpha)
	(- (* 1/3 alpha x x x (+ (* 4 alpha alpha) (* 12 alpha) 8))
	   (* 2 alpha x (+ alpha 1))))
      
      (define (g5 x alpha)
	(+ (* 1/15 alpha x x x x x (+ (* 4 alpha alpha alpha alpha) 
				      (* 40 alpha alpha alpha)
				      (* 140 alpha alpha)
				      (* 200 alpha)
				      96))
	   (* -1/3 alpha x x x (+ (* 4 alpha alpha alpha)
				  (* 24 alpha alpha)
				  (* 44 alpha)
				  24))
	   (* alpha x (+ (* alpha alpha) (* 3 alpha) 2))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 38))
	(let ((val (gegenbauer (vector-ref ns i) (vector-ref xs i) (vector-ref as i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";gegenbauer ~A ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) (vector-ref as i) val (vector-ref vals i)))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 3 x alpha))
	       (val2 (g3 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer 3 ~A ~A: ~A ~A" x alpha val1 val2))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let* ((x (random 10.0))
	       (alpha (random 3.0))
	       (val1 (gegenbauer 5 x alpha))
	       (val2 (g5 x alpha)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";gegenbauer 5 ~A ~A: ~A ~A" x alpha val1 val2))))
      )
    
    (let ((vals (vector     1.0000000000  0.0000000000 -0.5000000000     -0.6666666667 -0.6250000000 -0.4666666667 
			    -0.2569444444 -0.0404761905  0.1539930556      0.3097442681  0.4189459325  0.4801341791 
			    0.4962122235 -0.4455729167  0.8500000000     -3.1666666667 34.3333333333))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	  (xs (vector    1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  1.0  1.0     1.0  0.5  3.0     5.0 10.0)))
      (do ((i 0 (+ 1 i)))
	  ((= i 17))
	(let ((val (laguerre (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";laguerre ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      )
    
    (let ((vals (vector     1.0            10.0           98.0      940.0          8812.0         80600.0 
			    717880.0       6211600.0      52065680.0 ; was off by factor of 10?
			    421271200      3275529760.0   24329873600.0      171237081280.0 41.0          -8.0      3816.0         3041200.0))
	  (ns (vector     0  1  2      3  4  5      6  7  8      9 10 11     12  5  5      5  5))
	  (xs (vector    5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  5.0  5.0     5.0  0.5  1.0     3.0 10.0)))
      (do ((i 0 (+ 1 i)))
	  ((= i 13))
	(let ((val (hermite (vector-ref ns i) (vector-ref xs i))))
	  (if (fneq val (vector-ref vals i))
	      (snd-display #__line__ ";hermite ~A ~A -> ~A ~A" (vector-ref ns i) (vector-ref xs i) val (vector-ref vals i)))))
      )
    
    (do ((i 0 (+ 1 i))) 
	((= i 10))
      (let ((lv (legendre-polynomial (let ((v (make-vector 10 0.0))) 
				       (vector-set! v i 1.0) 
				       v) 
				     0.5))
	    (pv (plgndr i 0 0.5)))
	(if (fneq lv pv)
	    (snd-display #__line__ ";lv: ~A, pv: ~A (~A)" lv pv i))))
    
    (let ((pow-x (lambda (pow x)
		   ;; A&S p798
		   (if (= pow 0)
		       (legendre-polynomial (vector 1) x)
		       (if (= pow 1)
			   (legendre-polynomial (vector 0 1) x)
			   (if (= pow 2)
			       (* (/ 1.0 3.0) (legendre-polynomial (vector 1 0 2) x))
			       (if (= pow 3)
				   (* (/ 1.0 5.0) (legendre-polynomial (vector 0 3 0 2) x))
				   (if (= pow 4)
				       (* (/ 1.0 35.0) (legendre-polynomial (vector 7 0 20 0 8) x))
				       (if (= pow 5)
					   (* (/ 1.0 63.0) (legendre-polynomial (vector 0 27 0 28 0 8) x))
					   (if (= pow 6) 
					       (* (/ 1.0 231.0) (legendre-polynomial (vector 33 0 110 0 72 0 16) x))
					       'oops))))))))))
      (for-each
       (lambda (x)
	 (for-each
	  (lambda (pow)
	    (let ((lv (pow-x pow x))
		  (sv (expt x pow)))
	      (if (fneq lv sv)
		  (snd-display #__line__ ";~A ^ ~A = ~A ~A?" x pow lv sv))))
	  (list 0 1 2 3 4 5 6)))
       (list 2.0 0.5 0.1 -0.5 3.0 0.8)))
    
    (let ((snd (with-sound (:scaled-to 0.5) 
			   (do ((i 0 (+ 1 i)) 
				(x 0.0 (+ x .02))) 
			       ((= i 100)) 
			     (outa i (legendre 20 (cos x)))))))
      (let ((index (find-sound snd)))
	(if (fneq (sample 0 index 0) 0.5) (snd-display #__line__ ";legendre(cos(x)) 0: ~A" (sample 0 index 0)))
	(if (fneq (sample 50 index 0) 0.062572978) (snd-display #__line__ ";legendre(cos(x)) 50: ~A" (sample 50 index 0)))
	(close-sound index)))
    
    
    (let ((h0 (lambda (x) 1.0))
	  (h1 (lambda (x) (* 2 x)))
	  (h2 (lambda (x) (- (* 4 x x) 2)))
	  (h3 (lambda (x) (- (* 8 x x x) (* 12 x))))
	  (h4 (lambda (x) (+ (* 16 x x x x) (* -48 x x) 12)))
	  (h5 (lambda (x) (+ (* 32 x x x x x) (* -160 x x x) (* 120 x))))
	  (h6 (lambda (x) (+ (* 64 x x x x x x) (* -480 x x x x) (* 720 x x) -120))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 20))
	(let ((x (random 10.0)))
	  (let ((v1 (h1 x))
		(v11 (hermite 1 x))
		(v2 (h2 x))
		(v22 (hermite 2 x))
		(v3 (h3 x))
		(v33 (hermite 3 x))
		(v4 (h4 x))
		(v44 (hermite 4 x))
		(v5 (h5 x))
		(v55 (hermite 5 x))
		(v6 (h6 x))
		(v66 (hermite 6 x)))
	    (if (fneq v1 v11) (snd-display #__line__ ";hermite 1 ~A: ~A ~A" x v1 v11)
		(if (fneq v2 v22) (snd-display #__line__ ";hermite 2 ~A: ~A ~A" x v2 v22)
		    (if (fneq v3 v33) (snd-display #__line__ ";hermite 3 ~A: ~A ~A" x v3 v33)
			(if (fneq v4 v44) (snd-display #__line__ ";hermite 4 ~A: ~A ~A" x v4 v44)
			    (if (fneq v5 v55) (snd-display #__line__ ";hermite 5 ~A: ~A ~A" x v5 v55)
				(if (fneq v6 v66) (snd-display #__line__ ";hermite 6 ~A: ~A ~A" x v6 v66)))))))))))
    
    (let ((lg1 (lambda (x) (- 1 x)))
	  (lg2 (lambda (x) (+ 1 (* 0.5 x x) (* -2 x))))
	  (lag1 (lambda (x a) (+ 1 a (- x))))
	  (lag2 (lambda (x a) (* 0.5 (+ (* x x) 
					(* -2 x (+ a 2))
					(* (+ a 1) (+ a 2))))))
	  (lag3 (lambda (x a) (* (/ -1.0 6.0) (+ (* x x x)
						 (* -3 x x (+ a 3))
						 (* 3 x (+ a 2) (+ a 3))
						 (* -1 (+ a 1) (+ a 2) (+ a 3)))))))
      (let ((x (random 10.0))
	    (a (random 1.0)))
	(let ((v1 (laguerre 1 x))
	      (v11 (lg1 x))
	      (v2 (laguerre 2 x))
	      (v22 (lg2 x))
	      (va1 (lag1 x a))
	      (va11 (laguerre 1 x a))
	      (va2 (lag2 x a))
	      (va22 (laguerre 2 x a))
	      (va3 (lag3 x a))
	      (va33 (laguerre 3 x a)))
	  (if (fneq v1 v11) (snd-display #__line__ ";laguerre 1 ~A: ~A ~A" x v1 v11)
	      (if (fneq v2 v22) (snd-display #__line__ ";laguerre 2 ~A: ~A ~A" x v2 v22)
		  (if (fneq va1 va11) (snd-display #__line__ ";laguerre 1a ~A ~A: ~A ~A" x alpha va1 va11)
		      (if (fneq va2 va22) (snd-display #__line__ ";laguerre 2a ~A ~A: ~A ~A" x alpha va2 va22)
			  (if (fneq va3 va33) (snd-display #__line__ ";laguerre 3a ~A ~A: ~A ~A" x alpha va3 va33)))))))))
    )
  
  ;; ----------------
  ;; start of test
  
  (do ((clmtest 0 (+ 1 clmtest))) ((= clmtest tests))
    
    (log-mem clmtest)
    (numerical-reality-checks)
    
    (if (mus-generator? 321) (snd-display #__line__ ";123 is a gen?"))
    (if (mus-generator? (list 321)) (snd-display #__line__ ";(123) is a gen?"))
    (if (mus-generator? (list 'hi 321)) (snd-display #__line__ ";(hi 123) is a gen?"))
    (set! (mus-srate) 22050)
    (let ((samps (seconds->samples 1.0))
	  (secs (samples->seconds 22050)))
      (if (not (= samps 22050)) (snd-display #__line__ ";seconds->samples: ~A" samps))
      (if (fneq secs 1.0) (snd-display #__line__ ";samples->seconds: ~A" secs)))
    (if (and (= clmtest 0)
	     (not (= (mus-file-buffer-size) default-file-buffer-size)))
	(snd-display #__line__ ";mus-file-buffer-size: ~D?" (mus-file-buffer-size)))
    (let ((var (catch #t (lambda () (set! (mus-file-buffer-size) #f)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";mus-file-buffer-size bad size: ~A" var)))
    (set! (mus-file-buffer-size) 128)
    (if (not (= (mus-file-buffer-size) 128)) (snd-display #__line__ ";mus-file-buffer-size: ~D?" (mus-file-buffer-size)))
    (set! (mus-file-buffer-size) default-file-buffer-size)
    
    (if (and (not (= (mus-array-print-length) 8)) 
	     (not (= (mus-array-print-length) 32)))
	(snd-display #__line__ ";mus-array-print-length: ~D?" (mus-array-print-length)))
    (set! (mus-array-print-length) 32)
    (if (not (= (mus-array-print-length) 32)) (snd-display #__line__ ";set mus-array-print-length: ~D?" (mus-array-print-length)))
    (set! (mus-array-print-length) 8)
    
    (let ((fudge (mus-float-equal-fudge-factor)))
      (if (> (abs (- (mus-float-equal-fudge-factor) 0.0000001)) 0.00000001)
	  (snd-display #__line__ ";mus-float-equal-fudge-factor: ~A?" (mus-float-equal-fudge-factor)))
      (set! (mus-float-equal-fudge-factor) .1)
      (if (fneq (mus-float-equal-fudge-factor) .1) 
	  (snd-display #__line__ ";set mus-float-equal-fudge-factor: ~A?" (mus-float-equal-fudge-factor)))
      (set! (mus-float-equal-fudge-factor) fudge))
    
    (if (fneq (mus-srate) 22050.0) (snd-display #__line__ ";mus-srate: ~F?" (mus-srate)))
    (if (fneq (hz->radians 1.0) 2.84951704088598e-4) (snd-display #__line__ ";hz->radians: ~F?" (hz->radians 1.0)))
    (if (fneq (radians->hz 2.84951704088598e-4) 1.0) (snd-display #__line__ ";radians->hz: ~F?" (radians->hz 2.84951704088598e-4)))
    (if (fneq (radians->degrees 1.0) 57.2957801818848) (snd-display #__line__ ";radians->degrees: ~F?" (radians->degrees 1.0)))
    (if (fneq (degrees->radians 57.2957801818848) 1.0) (snd-display #__line__ ";degrees->radians: ~F?" (degrees->radians 57.2957801818848)))
    (if (fneq (linear->db .25) -12.0411996841431) (snd-display #__line__ ";linear->db: ~F?" (linear->db .25)))
    (if (fneq (db->linear -12.0411996841431) .25) (snd-display #__line__ ";db->linear: ~F?" (db->linear -12.0411996841431)))
    (if (fneq (ring-modulate .4 .5) .2) (snd-display #__line__ ";ring-modulate: ~F?" (ring-modulate .4 .5)))
    (if (fneq (amplitude-modulate 1.0 .5 .4) .7) (snd-display #__line__ ";amplitude-modulate: ~F?" (amplitude-modulate 1.0 .5 .4)))
    (if (fneq (contrast-enhancement 0.1 0.75) (sin (+ (* 0.1 (/ pi 2)) (* .75 (sin (* 0.1 2.0 pi))))))
	(snd-display #__line__ ";contrast-enhancement: ~F (0.562925306221587)" (contrast-enhancement 0.1 0.75)))
    (if (fneq (contrast-enhancement 1.0) 1.0) (snd-display #__line__ ";contrast-enhancement opt: ~A" (contrast-enhancement 1.0)))
    (let ((lv0 (partials->polynomial (vct 1 1 2 1) mus-chebyshev-first-kind))
	  (lv1 (partials->polynomial '(1 1 2 1) mus-chebyshev-second-kind))
	  (lv2 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-first-kind))
	  (lv3 (partials->polynomial '(1 1 2 1 3 1 5 1) mus-chebyshev-second-kind))
	  (lv4 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) mus-chebyshev-first-kind))
	  (lv5 (partials->polynomial (list 1 1 2 .5 3 .1 6 .01) mus-chebyshev-second-kind))
	  (lv6 (partials->polynomial (vct 1 9 2 3 3 5 4 7 5 1))) ; MLB
	  (lv7 (partials->polynomial '(7 1)))
	  (lv7a (partials->polynomial '(7 1) mus-chebyshev-first-kind))
	  (lv8 (partials->polynomial '(7 1) mus-chebyshev-second-kind))
	  )
      (if (not (fveql lv0 '(-1.000 1.000 2.000) 0)) (snd-display #__line__ ";partials->polynomial(1): ~A?" lv0))
      (if (not (fveql lv1 '(1.000 2.000 0.0) 0)) (snd-display #__line__ ";partials->polynomial(2): ~A?" lv1))
      (if (not (fveql lv2 '(-1.000 3.000 2.000 -16.000 0.000 16.000) 0)) (snd-display #__line__ ";partials->polynomial(3): ~A?" lv2))
      (if (not (fveql lv3 '(1.000 2.000 -8.000 0.000 16.000 0.000) 0)) (snd-display #__line__ ";partials->polynomial(4): ~A?" lv3))
      (if (not (fveql lv4 '(-0.510 0.700 1.180 0.400 -0.480 0.000 0.320) 0)) (snd-display #__line__ ";partials->polynomial(5): ~A?" lv4))
      (if (not (fveql lv5 '(0.900 1.060 0.400 -0.320 0.000 0.320 0.000) 0)) (snd-display #__line__ ";partials->polynomial(6): ~A?" lv5))
      (if (not (vequal lv6 (vct 4.000 -1.000 -50.000 0.000 56.000 16.000))) (snd-display #__line__ ";partials->polynomial(7): ~A?" lv6))
      (if (not (vequal lv7 (vct 0.000 -7.000 0.000 56.000 0.000 -112.000 0.000 64.000))) (snd-display #__line__ ";partials->polynomial(8): ~A?" lv7))
      (if (not (vequal lv8 (vct -1.000 0.000 24.000 0.000 -80.000 0.000 64.000 0.000))) (snd-display #__line__ ";partials->polynomial(9): ~A?" lv8))
      (if (not (vequal lv7 lv7a)) (snd-display #__line__ ";partials->polynomial kind=1? ~A ~A" lv7 lv7a))
      
      (if (not (vequal (normalize-partials (list 1 1 2 1)) (vct 1.000 0.500 2.000 0.500)))
	  (snd-display #__line__ ";normalize-partials 1: ~A" (normalize-partials (list 1 1 2 1))))
      (if (not (vequal (normalize-partials (vct 1 1 2 1)) (vct 1.000 0.500 2.000 0.500)))
	  (snd-display #__line__ ";normalize-partials 2: ~A" (normalize-partials (vct 1 1 2 1))))
      (if (not (vequal (normalize-partials (vct 1 1 2 -1)) (vct 1.000 0.500 2.000 -0.500)))
	  (snd-display #__line__ ";normalize-partials 3: ~A" (normalize-partials (vct 1 1 2 -1))))
      (if (not (vequal (normalize-partials (vct 1 -.1 2 -.1)) (vct 1.000 -0.500 2.000 -0.500)))
	  (snd-display #__line__ ";normalize-partials 4: ~A" (normalize-partials (vct 1 -.1 2 -.1))))
      (if (not (vequal (normalize-partials (vct 0 2 1 1 4 1)) (vct 0.000 0.500 1.000 0.250 4.000 0.250)))
	  (snd-display #__line__ ";normalize-partials 4: ~A" (normalize-partials (vct 0 2 1 1 4 1))))
      
      (if (fneq (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))) 
	  (snd-display #__line__ ";ccosh cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cosh (* 7 (acosh 1.0)))))
      (if (fneq (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))) 
	  (snd-display #__line__ ";cos cheb 7 1.0: ~A ~A" (polynomial lv7 1.0) (cos (* 7 (acos 1.0)))))
      (if (fneq (polynomial lv8 0.5) (/ (sin (* 7 (acos 0.5))) (sin (acos 0.5))))
	  (snd-display #__line__ ";acos cheb 7 1.0: ~A ~A" (polynomial lv8 0.5) (/ (sin (* 7 (acos 0.5))) (sin (acos 0.5)))))
      ;; G&R 8.943 p 984 uses n+1 where we use n in Un? (our numbering keeps harmonics aligned between Tn and Un)
      
      (do ((i 0 (+ 1 i)))
	  ((+ i 10))
	(let ((val (mus-random 1.0)))
	  (if (fneq (polynomial lv7 val) (cosh (* 7 (acosh val)))) 
	      (snd-display #__line__ ";ccosh cheb 7 ~A: ~A ~A" val (polynomial lv7 val) (cosh (* 7 (acosh val)))))
	  (if (fneq (polynomial lv7 val) (cos (* 7 (acos val)))) 
	      (snd-display #__line__ ";cos cheb 7 ~A: ~A ~A" (polynomial lv7 val) (cos (* 7 (acos val)))))
	  (if (fneq (polynomial lv8 val) (/ (sin (* 7 (acos val))) (sin (acos val))))
	      (snd-display #__line__ ";acos cheb 7 ~A: ~A ~A" val (polynomial lv8 val) (/ (sin (* 7 (acos val))) (sin (acos val)))))))
      )
    
    ;; check phase-quadrature cancellations
    (let ((cos-coeffs (partials->polynomial '(1 1 2 1) mus-chebyshev-first-kind))
	  (sin-coeffs (partials->polynomial (vct 1 1 2 1) mus-chebyshev-second-kind)))
      (do ((i 0 (+ 1 i))
	   (a 0.0 (+ a (/ (* 2 pi 440.0) 22050.0))))
	  ((= i 1100))
	(let* ((x (cos a))
	       (y (sin a))
	       (cax (polynomial cos-coeffs x))
	       (sax (polynomial sin-coeffs x))
	       (upper (- (* (cos (* 2 a)) cax) (* (sin (* 2 a)) (* y sax))))
	       (lower (+ (* (cos (* 2 a)) cax) (* (sin (* 2 a)) (* y sax))))
	       (upper2 (+ (cos (* a 3)) (cos (* a 4))))
	       (lower2 (+ 1.0 (cos a))))
	  (if (or (fneq upper upper2)
		  (fneq lower lower2))
	      (snd-display #__line__ ";~A ~A, ~A ~A" upper upper2 lower lower2)))))
    
    (let ((tag (catch #t (lambda () (harmonicizer 550.0 (list .5 .3 .2) 10)) (lambda args (car args)))))
      (if (not (eq? tag 'no-data)) (snd-display #__line__ ";odd length arg to partials->polynomial: ~A" tag)))
    
    (let* ((amps (list->vct '(1.0)))
	   (phases (list->vct '(0.0)))
	   (val (sine-bank amps phases)))
      (if (fneq val 0.0) (snd-display #__line__ ";sine-bank: ~A 0.0?" val))
      (vct-set! phases 0 (/ pi 2))
      (set! val (sine-bank amps phases))
      (if (fneq val 1.0) (snd-display #__line__ ";sine-bank: ~A 1.0?" val))
      (set! amps (list->vct '(0.5 0.25 1.0)))
      (set! phases (list->vct '(1.0 0.5 2.0)))
      (set! val (sine-bank amps phases))
      (if (fneq val 1.44989) (snd-display #__line__ ";sine-bank: ~A 1.449?" val))
      (set! val (sine-bank amps phases 3))
      (if (fneq val 1.44989) (snd-display #__line__ ";sine-bank (3): ~A 1.449?" val))
      (set! val (sine-bank amps phases 1))
      (if (fneq val 0.4207) (snd-display #__line__ ";sine-bank (1): ~A 1.449?" val)))
    
    (let ((rdat (make-vct 16))
	  (idat (make-vct 16))
	  (vdat (make-vct 16)))
      (vct-set! rdat 0 1.0)
      (vct-set! vdat 0 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 16) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ 1 i)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (vct-ref v0 i) (vct-ref v1 i))
	      (snd-display #__line__ ";spectra not equal 1: ~A ~A" v0 v1))))
      (vct-scale! idat 0.0)
      (vct-scale! rdat 0.0)
      (vct-set! rdat 0 1.0)
      (let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 17) 1)) ;rectangular here to avoid clobbering 0-th data point
	    (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	(do ((i 0 (+ 1 i)))
	    ((= i 8)) ;should all be 1.0 (impulse in)
	  (if (fneq (vct-ref v0 i) (vct-ref v1 i))
	      (snd-display #__line__ ";spectra not equal 0: ~A ~A" v0 v1))))
      (let ((var (catch #t (lambda () (spectrum rdat idat #f -1)) (lambda args args))))
	(if (or (vct? var) 
		(not (eq? (car var) 'out-of-range)))
	    (snd-display #__line__ ";spectrum bad type: ~A" var))))
    
    (let ((rdat (make-vct 16))
	  (idat (make-vct 16))
	  (xdat (make-vct 16))
	  (ydat (make-vct 16)))
      (vct-set! rdat 3 1.0)
      (vct-set! xdat 3 1.0)
      (fft rdat idat 1)
      (mus-fft xdat ydat 16 1)
      (if (fneq (vct-ref rdat 0) (vct-ref xdat 0)) (snd-display #__line__ ";ffts: ~A ~A?" rdat xdat))
      (fft rdat idat -1)
      (mus-fft xdat ydat 17 -1) ; mistake is deliberate
      (do ((i 0 (+ 1 i)))
	  ((= i 16))
	(if (or (and (= i 3) (or (fneq (vct-ref rdat i) 16.0) (fneq (vct-ref xdat i) 16.0)))
		(and (not (= i 3)) (or (fneq (vct-ref rdat i) 0.0) (fneq (vct-ref xdat i) 0.0))))
	    (snd-display #__line__ ";fft real[~D]: ~A ~A?" i (vct-ref rdat i) (vct-ref xdat i)))
	(if (or (fneq (vct-ref idat i) 0.0) (fneq (vct-ref ydat i) 0.0))
	    (snd-display #__line__ ";fft imag[~D]: ~A ~A?" i (vct-ref idat i) (vct-ref ydat i))))
      (let ((var (catch #t (lambda () (mus-fft xdat ydat -1 0)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";mus-fft bad len: ~A" var))))
    
    (let ((rdat (make-vct 20))
	  (idat (make-vct 19)))
      (vct-set! rdat 3 1.0)
      (mus-fft rdat idat)
      (convolution rdat idat)
      (spectrum rdat idat #f))
    
    (let ((v0 (make-vct 10))
	  (v1 (make-vct 10)))
      (vct-fill! v0 1.0)
      (multiply-arrays v0 v1 1)
      (if (not (vequal v0 (vct 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0)))
	  (snd-display #__line__ ";multiply-arrays[0]: ~A?" v0))
      (multiply-arrays v0 v1 100)
      (if (fneq (vct-peak v0) 0.0)
	  (snd-display #__line__ ";multiply-arrays[100]: ~A?" v0))
      (vct-fill! v0 1.0)
      (vct-fill! v1 0.5)
      (multiply-arrays v0 v1)
      (if (fneq (vct-ref v0 0) 0.5) (snd-display #__line__ ";multiple-arrays: ~F?" (vct-ref v0 0)))
      (let ((sum (dot-product v0 v1)))
	(if (fneq sum 2.5) (snd-display #__line__ ";dot-product: ~F?" sum)))
      (let ((sum (dot-product v0 v1 10)))
	(if (fneq sum 2.5) (snd-display #__line__ ";dot-product (10): ~F?" sum)))
      (let ((sum (dot-product v0 v1 3)))
	(if (fneq sum 0.75) (snd-display #__line__ ";dot-product (3): ~F?" sum)))
      (clear-array v0)
      (if (fneq (vct-ref v0 3) 0.0) (snd-display #__line__ ";clear-array: ~A?" v0))
      (vct-fill! v0 1.0)
      (vct-fill! v1 0.5)
      (let ((v2 (rectangular->polar v0 v1)))
	(if (fneq (vct-ref v2 0) 1.118) (snd-display #__line__ ";rectangular->polar: ~A?" v2)))
      (vct-set! v0 0 1.0)
      (vct-set! v1 0 1.0)
      (rectangular->polar v0 v1)
      (if (or (fneq (vct-ref v0 0) (sqrt 2.0))
	      (fneq (vct-ref v1 0) (- (atan 1.0 1.0)))) ;(tan (atan 1.0 1.0)) -> 1.0 
	  (snd-display #__line__ ";rectangular->polar (~A ~A): ~A ~A?" (sqrt 2.0) (- (atan 1.0 1.0)) (vct-ref v0 0) (vct-ref v1 0)))
      (polar->rectangular v0 v1)
      (if (or (fneq (vct-ref v0 0) 1.0)
	      (fneq (vct-ref v1 0) 1.0))
	  (snd-display #__line__ ";polar->rectangular (1 1): ~A ~A?" (vct-ref v0 0) (vct-ref v1 0)))
      
      (let ((v0 (make-vct 1))
	    (v1 (make-vct 1))
	    (v (make-vct 1))
	    (val .123))
	(vct-set! v0 0 1.0)
	(vct-set! v1 0 1.0)
	(vct-map! v (lambda ()
		      (rectangular->polar v0 v1)
		      (set! val (vct-ref v0 0))
		      (polar->rectangular v0 v1)
		      (vct-ref v1 0)))
	(if (fneq (vct-ref v 0) 1.0) (snd-display #__line__ ";run r->p not inverted: ~A" v))
	(if (fneq val (sqrt 2.0)) (snd-display #__line__ ";r->p: ~A" val)))
      
      (let* ((ind (open-sound "oboe.snd"))
	     (rl (channel->vct 1200 512))
	     (im (make-vct 512)))
	(fft rl im 512)
	(let ((rl-copy (vct-copy rl))
	      (im-copy (vct-copy im)))
	  (rectangular->polar rl im)
	  (polar->rectangular rl im)
	  (do ((i 0 (+ 1 i)))
	      ((= i 512))
	    (if (or (fneq (vct-ref rl i) (vct-ref rl-copy i))
		    (fneq (vct-ref im i) (vct-ref im-copy i)))
		(snd-display #__line__ ";polar->rectangular[~D]: ~A ~A ~A ~A" 
			     i 
			     (vct-ref rl i) (vct-ref rl-copy i)
			     (vct-ref im i) (vct-ref im-copy i)))))
	(close-sound ind)))
    
    (let ((v0 (make-vct 8))
	  (v1 (make-vct 8)))
      (do ((i 0 (+ i 1))) ((= i 8)) (vct-set! v0 i i) (vct-set! v1 i (/ (+ i 1))))
      (rectangular->magnitudes v0 v1)
      (if (not (vequal v0 (vct 1.000 1.118 2.028 3.010 4.005 5.003 6.002 7.001)))
	  (snd-display #__line__ ";rectangular->magnitudes v0: ~A" v0)))
    
    (let ((v0 (make-vct 8))
	  (v1 (make-vct 8))
	  (v2 (make-vct 8))
	  (v3 (make-vct 8)))
      (do ((i 0 (+ i 1)))
	  ((= i 8))
	(let ((val1 (random 1.0))
	      (val2 (random 1.0)))
	  (vct-set! v0 i val1)
	  (vct-set! v2 i val1)
	  (vct-set! v1 i val2)
	  (vct-set! v3 i val2)))
      (rectangular->magnitudes v0 v1)
      (rectangular->polar v2 v3)
      (if (not (vequal v0 v2))
	  (snd-display #__line__ ";rectangular->magnitudes|polar: ~A ~A" v0 v2)))
    
    (if (defined? 'edot-product) ; needs complex numbers in C
	(let* ((vals (make-vct 1 1.0))
	       (v1 (edot-product 0.0 vals)))
	  (if (fneq v1 1.0) ; exp 0.0 * 1.0
	      (snd-display #__line__ ";edot a 1.0: ~A" v1))
	  (vct-set! vals 0 0.0)
	  (set! v1 (edot-product 0.0 vals))
	  (if (fneq v1 0.0) ; exp 0.0 * 0.0
	      (snd-display #__line__ ";edot b 0.0: ~A" v1))
	  (set! vals (make-vector 1 1.0))
	  (set! v1 (edot-product 0.0 vals))  
	  (if (fneq v1 1.0) ; exp 0.0 * 1.0
	      (snd-display #__line__ ";edot c 1.0: ~A" v1))
	  (vector-set! vals 0 0.0+i)
	  (set! v1 (edot-product 0.0 vals))
	  (if (cneq v1 0.0+i)
	      (snd-display #__line__ ";edot i: ~A" v1))
	  (set! vals (make-vct 4 1.0))
	  (set! v1 (edot-product (* 0.25 2 pi) vals))
	  (let ((v2 (+ (exp (* 0 2 pi))
		       (exp (* 0.25 2 pi))
		       (exp (* 0.5 2 pi))
		       (exp (* 0.75 2 pi)))))
	    (if (fneq v1 v2) (snd-display #__line__ ";edot 4: ~A ~A" v1 v2)))
	  (set! vals (make-vector 4 0.0))  
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (vector-set! vals i (+ i 1.0)))
	  (set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	  (let ((v2 (+ (* 1 (exp (* 0 2 pi 0.0-i)))
		       (* 2 (exp (* 0.25 2 pi 0.0-i)))
		       (* 3 (exp (* 0.5 2 pi 0.0-i)))
		       (* 4 (exp (* 0.75 2 pi 0.0-i))))))
	    (if (cneq v1 v2) (snd-display #__line__ ";edot 4 -i: ~A ~A" v1 v2)))
	  (do ((i 0 (+ 1 i)))
	      ((= i 4))
	    (vector-set! vals i (+ i 1.0+i)))
	  (set! v1 (edot-product (* 0.25 2 pi 0.0-i) vals))
	  (let ((v2 (+ (* 1+i (exp (* 0 2 pi 0.0-i)))
		       (* 2+i (exp (* 0.25 2 pi 0.0-i)))
		       (* 3+i (exp (* 0.5 2 pi 0.0-i)))
		       (* 4+i (exp (* 0.75 2 pi 0.0-i))))))
	    (if (cneq v1 v2) (snd-display #__line__ ";edot 4 -i * i: ~A ~A" v1 v2)))))
    
    (let ((v0 (make-vct 3)))
      (vct-set! v0 0 1.0)
      (vct-set! v0 1 0.5)
      (vct-set! v0 2 0.1)
      (if (or (fneq (polynomial v0 0.0) 1.0)
	      (fneq (polynomial v0 1.0) 1.6)
	      (fneq (polynomial v0 2.0) 2.4))
	  (snd-display #__line__ ";polynomial: ~A ~A ~A?"
		       (polynomial v0 0.0)
		       (polynomial v0 1.0)
		       (polynomial v0 2.0))))
    (if (fneq (polynomial (vct 0.0 2.0) 0.5) 1.0) 
	(snd-display #__line__ ";polynomial 2.0 * 0.5: ~A" (polynomial (vct 2.0) 0.5)))
    (let ((var (catch #t (lambda () (polynomial #f 1.0)) (lambda args args))))
      (if (not (eq? (car var) 'wrong-type-arg))
	  (snd-display #__line__ ";polynomial empty coeffs: ~A" var)))
    
    (do ((i 0 (+ i 1)))
	((= i 100))
      (let ((arg1 (- (random 100.0) 50.0))
	    (arg2 (- (random 100.0) 50.0)))
	(let ((val1 (fmod arg1 arg2))
	      (val2 (modulo arg1 arg2)))
	  (if (and (> (abs (- val1 val2)) 1e-8)
		   (> (abs (- (abs (- val1 val2)) (abs arg2))) 1e-8))
	      (format #t "~A ~A: ~A ~A -> ~A~%" arg1 arg2 val1 val2 (abs (- val1 val2)))))))
    
    (let ((err 0.0)
	  (coeffs (vct 1.0 0.0 -.4999999963 0.0 .0416666418 0.0 -.0013888397 0.0 .0000247609 0.0 -.0000002605))
	  (pi2 (* pi 0.5)))
      (letrec ((new-cos
		(lambda (x)
		  (let ((xx (abs x)))
		    (if (<= xx pi2)
			(polynomial coeffs xx)
			(let ((nxx (fmod xx (* 2 pi))))
			  (if (<= nxx pi2)
			      (polynomial coeffs nxx)
			      (if (<= nxx pi)
				  (- (polynomial coeffs (- pi nxx)))
				  (if (< nxx (* 1.5 pi))
				      (- (polynomial coeffs (- nxx pi)))
				      (polynomial coeffs (- (* 2 pi) nxx)))))))))))
	(do ((i 0 (+ 1 i))
	     (x -10.0 (+ x .01)))
	    ((= i 2000))
	  (let ((diff (abs (- (cos x) (new-cos x)))))
	    (if (> diff err)
		(set! err diff))))
	(if (> err 1.1e-7) (snd-display #__line__ ";new-cos poly err: ~A" err))))
    
    (let ((val (poly+ (vct .1 .2 .3) (vct 0.0 1.0 2.0 3.0 4.0))))
      (if (not (vequal val (vct 0.100 1.200 2.300 3.000 4.000))) (snd-display #__line__ ";poly+ 1: ~A" val)))
    
    (let ((val (poly+ (vct .1 .2 .3) .5)))
      (if (not (vequal val (vct 0.600 0.200 0.300))) (snd-display #__line__ ";poly+ 2: ~A" val)))
    (let ((val (poly+ .5 (vct .1 .2 .3))))
      (if (not (vequal val (vct 0.600 0.200 0.300))) (snd-display #__line__ ";poly+ 3: ~A" val)))
    
    (let ((val (poly* (vct 1 1) (vct -1 1))))
      (if (not (vequal val (vct -1.000 0.000 1.000 0.000))) (snd-display #__line__ ";poly* 1: ~A" val)))
    (let ((val (poly* (vct -5 1) (vct 3 7 2))))
      (if (not (vequal val (vct -15.000 -32.000 -3.000 2.000 0.000))) (snd-display #__line__ ";poly* 2: ~A" val)))
    (let ((val (poly* (vct -30 -4 2) (vct 0.5 1))))
      (if (not (vequal val (vct -15.000 -32.000 -3.000 2.000 0.000))) (snd-display #__line__ ";poly* 3: ~A" val)))
    (let ((val (poly* (vct -30 -4 2) 0.5)))
      (if (not (vequal val (vct -15.000 -2.000 1.000))) (snd-display #__line__ ";poly* 4: ~A" val)))
    (let ((val (poly* 2.0 (vct -30 -4 2))))
      (if (not (vequal val (vct -60.000 -8.000 4.000))) (snd-display #__line__ ";poly* 5: ~A" val)))
    
    (let ((val (poly/ (vct -1.0 -0.0 1.0) (vct 1.0 1.0))))
      (if (or (not (vequal (car val) (vct -1.000 1.000 0.000)))
	      (not (vequal (cadr val) (vct 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 1: ~A" val)))
    (let ((val (poly/ (vct -15 -32 -3 2) (vct -5 1))))
      (if (or (not (vequal (car val) (vct 3.000 7.000 2.000 0.000)))
	      (not (vequal (cadr val) (vct 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 2: ~A" val)))
    (let ((val (poly/ (vct -15 -32 -3 2) (vct 3 1))))
      (if (or (not (vequal (car val) (vct -5.000 -9.000 2.000 0.000)))
	      (not (vequal (cadr val) (vct 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 3: ~A" val)))
    (let ((val (poly/ (vct -15 -32 -3 2) (vct .5 1))))
      (if (or (not (vequal (car val) (vct -30.000 -4.000 2.000 0.000)))
	      (not (vequal (cadr val) (vct 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 4: ~A" val)))
    (let ((val (poly/ (vct -15 -32 -3 2) (vct 3 7 2))))
      (if (or (not (vequal (car val) (vct -5.000 1.000 0.000 0.000)))
	      (not (vequal (cadr val) (vct 0.000 0.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 5: ~A" val)))
    (let ((val (poly/ (vct -15 -32 -3 2) 2.0)))
      (if (not (vequal (car val) (vct -7.500 -16.000 -1.500 1.000)))
	  (snd-display #__line__ ";poly/ 6: ~A" val)))
    (let ((val (poly/ (vct -1.0 0.0 0.0 0.0 1.0) (vct 1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (vct -1.0 0.0 1.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-vct 5))))
	  (snd-display #__line__ ";poly/ 7: ~A" val)))
    (let ((val (poly/ (vct -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0) (vct 1.0 0.0 0.0 0.0 1.0))))
      (if (or (not (vequal (car val) (vct -1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-vct 9))))
	  (snd-display #__line__ ";poly/ 8: ~A" val)))
    (let ((val (poly/ (vct -1.0 0.0 1.0) (vct -1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (vct 1.0 0.0 0.0)))
	      (not (vequal (cadr val) (make-vct 3))))
	  (snd-display #__line__ ";poly/ 9: ~A" val)))
    (let ((val (poly/ (vct -1.0 0.0 1.0) (vct 2.0 1.0))))
      (if (or (not (vequal (car val) (vct -2.000 1.000 0.000)))
	      (not (vequal (cadr val) (vct 3.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 10: ~A" val)))
    (let ((val (poly/ (vct 2 1) (vct -1.0 0.0 1.0))))
      (if (or (not (vequal (car val) (vct 0.0)))
	      (not (vequal (cadr val) (vct -1.000 0.000 1.000))))
	  (snd-display #__line__ ";poly/ 11: ~A" val)))
    (let ((val (poly/ (vct 1 2 3 0 1) (vct 0 0 0 1))))
      (if (or (not (vequal (car val) (vct 0.000 1.000 0.000 0.000 0.000)))
	      (not (vequal (cadr val) (vct 1.000 2.000 3.000 0.000 0.000))))
	  (snd-display #__line__ ";poly/ 12: ~A" val)))
    
    (let ((ind (open-sound "1a.snd")))
      (let ((v1 (channel->vct 0 100 ind 0))
	    (v2 (channel->vct 0 100 ind 0)))
	(let ((vals (car (poly/ v1 v2)))
	      (res (make-vct 100)))
	  (vct-set! res 0 1.0)
	  (if (not (vequal vals res))
	      (snd-display #__line__ ";poly1 1a: ~A" vals))))
      (close-sound ind))
    
    (let ((val (poly-derivative (vct 0.5 1.0 2.0 4.0))))
      (if (not (vequal val (vct 1.000 4.000 12.000))) (snd-display #__line__ ";poly-derivative: ~A" val)))
    
    (let ((val (poly-reduce (vct 1 2 3))))
      (if (not (vequal val (vct 1.000 2.000 3.000))) (snd-display #__line__ ";poly-reduce 1: ~A" val)))
    (let ((val (poly-reduce (vct 1 2 3 0 0 0))))
      (if (not (vequal val (vct 1.000 2.000 3.000))) (snd-display #__line__ ";poly-reduce 2: ~A" val)))
    (let ((val (poly-reduce (vct 0 0 0 0 1 0))))
      (if (not (vequal val (vct 0.000 0.000 0.000 0.000 1.000))) (snd-display #__line__ ";poly-reduce 3: ~A" val)))
    
    (let ((vals (poly-gcd (poly-reduce (poly* (vct 2 1) (vct -3 1))) (vct 2 1))))
      (if (not (vequal vals (vct 2.000 1.000))) (snd-display #__line__ ";poly-gcd 1: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (vct 2 1) (vct -3 1))) (vct 3 1))))
      (if (not (vequal vals (vct 0.000))) (snd-display #__line__ ";poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (vct 2 1) (vct -3 1))) (vct -3 1))))
      (if (not (vequal vals (vct -3.000 1.000))) (snd-display #__line__ ";poly-gcd 2: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (vct 8 1) (poly* (vct 2 1) (vct -3 1)))) (vct -3 1))))
      (if (not (vequal vals (vct -3.000 1.000))) (snd-display #__line__ ";poly-gcd 3: ~A" vals)))
    (let ((vals (poly-gcd (poly-reduce (poly* (vct 8 1) (poly* (vct 2 1) (vct -3 1)))) (poly-reduce (poly* (vct 8 1) (vct -3 1))))))
      (if (not (vequal vals (vct -24.000 5.000 1.000))) (snd-display #__line__ ";poly-gcd 4: ~A" vals)))
    (let ((vals (poly-gcd (vct -1 0 1) (vct 2 -2 -1 1))))
      (if (not (vequal vals (vct 0.000))) (snd-display #__line__ ";poly-gcd 5: ~A" vals)))
    (let ((vals (poly-gcd (vct 2 -2 -1 1) (vct -1 0 1))))
      (if (not (vequal vals (vct 1.000 -1.000))) (snd-display #__line__ ";poly-gcd 6: ~A" vals)))
    (let ((vals (poly-gcd (vct 2 -2 -1 1) (vct -2.5 1))))
      (if (not (vequal vals (vct 0.000))) (snd-display #__line__ ";poly-gcd 7: ~A" vals)))
    
    (poly-roots-tests)
    
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 0: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 2) (vector 1 -2 1))))
      (if (fneq val 1.0) (snd-display #__line__ ";poly-resultant 1: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 1 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 2: ~A" val)))
    (let ((val (poly-as-vector-resultant (vector -1 0 1) (vector 2 1))))
      (if (fneq val 3.0) (snd-display #__line__ ";poly-resultant 3: ~A" val)))
    (let ((val (poly-resultant (vct -1 0 1) (vct 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-resultant 0: ~A" val)))
    
    (let ((val (poly-as-vector-discriminant (vector -1 0 1))))
      (if (fneq val -4.0) (snd-display #__line__ ";poly-discriminant 0: ~A" val)))
    (let ((val (poly-as-vector-discriminant (vector 1 -2 1))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 1: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (vct -1 1) (vct -1 1)) (vct 3 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 2: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (vct -1 1) (vct -1 1)) (vct 3 1)) (vct 2 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 3: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (vct 1 1) (vct -1 1)) (vct 3 1)) (vct 2 1))))))
      (if (fneq val 2304.0) (snd-display #__line__ ";poly-discriminant 4: ~A" val)))
    (let ((val (poly-discriminant (poly-reduce (poly* (poly* (poly* (vct 1 1) (vct -1 1)) (vct 3 1)) (vct 3 1))))))
      (if (fneq val 0.0) (snd-display #__line__ ";poly-discriminant 5: ~A" val)))
    
    
    (let ((v0 (make-vct 10)))
      (do ((i 0 (+ 1 i))) ((= i 10))
	(vct-set! v0 i i))
      (if (fneq (array-interp v0 3.5) 3.5) (snd-display #__line__ ";array-interp: ~F?" (array-interp v0 3.5)))
      (if (fneq (array-interp v0 13.5) 3.5) (snd-display #__line__ ";array-interp(13.5): ~F?" (array-interp v0 13.5)))
      (if (fneq (array-interp v0 -6.5) 3.5) (snd-display #__line__ ";array-interp(-6.5): ~F?" (array-interp v0 -6.5)))
      (if (fneq (array-interp v0 103.6) 3.6) (snd-display #__line__ ";array-interp(103.5): ~F?" (array-interp v0 103.6)))
      (if (fneq (array-interp v0 -106.6) 3.4) (snd-display #__line__ ";array-interp(-106.6): ~F?" (array-interp v0 -106.6)))
      (if (fneq (array-interp v0 -0.5) 4.5) (snd-display #__line__ ";array-interp(-0.5): ~F?" (array-interp v0 -0.5)))
      ;; interpolating between 9 and 0 here (confusing...)
      (if (fneq (array-interp v0 -0.9) 8.1) (snd-display #__line__ ";array-interp(-0.9): ~F?" (array-interp v0 -0.9)))
      (if (fneq (array-interp v0 -0.1) 0.9) (snd-display #__line__ ";array-interp(-0.1): ~F?" (array-interp v0 -0.1)))
      (if (fneq (array-interp v0 9.1) 8.1) (snd-display #__line__ ";array-interp(9.1): ~F?" (array-interp v0 9.1)))
      (if (fneq (array-interp v0 9.9) 0.9) (snd-display #__line__ ";array-interp(9.9): ~F?" (array-interp v0 9.9)))
      (if (fneq (array-interp v0 10.1) 0.1) (snd-display #__line__ ";array-interp(10.1): ~F?" (array-interp v0 10.1)))
      (let ((var (catch #t (lambda () (array-interp v0 1 -10)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";array-interp bad index: ~A" var))))
    
    (let ((ind (open-sound "oboe.snd")))
      (let ((diff (array-interp-sound-diff ind 0)))
	(if (> diff .00001) (snd-display #__line__ ";array-interp-sound-diff: ~A" diff)))
      (close-sound ind))
    
    (let ((v0 (make-vct 10)))
      (do ((i 0 (+ 1 i))) ((= i 10))
	(vct-set! v0 i i))
      (let ((val (mus-interpolate mus-interp-linear 1.5 v0)))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate linear: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate all-pass: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 1.0) (snd-display #__line__ ";mus-interpolate none: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate hermite: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate bezier: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 1.5) (snd-display #__line__ ";mus-interpolate lagrange: ~A" val))
	(do ((i 0 (+ 1 i))) ((= i 10)) (vct-set! v0 i (sin (* pi (/ i 5)))))
	(set! val (mus-interpolate mus-interp-linear 1.5 v0))
	(if (fneq val 0.7694) (snd-display #__line__ ";mus-interpolate linear sin: ~A" val))
	(set! val (mus-interpolate mus-interp-all-pass 1.5 v0))
	(if (fneq val 0.7694) (snd-display #__line__ ";mus-interpolate all-pass sin: ~A" val))
	(set! val (mus-interpolate mus-interp-none 1.5 v0))
	(if (fneq val 0.5877) (snd-display #__line__ ";mus-interpolate none sin: ~A" val))
	(set! val (mus-interpolate mus-interp-hermite 1.5 v0))
	(if (fneq val 0.8061) (snd-display #__line__ ";mus-interpolate hermite sin: ~A" val))
	(set! val (mus-interpolate mus-interp-bezier 1.5 v0))
	(if (fneq val 0.6959) (snd-display #__line__ ";mus-interpolate bezier sin: ~A" val))
	(set! val (mus-interpolate mus-interp-lagrange 1.5 v0))
	(if (fneq val 0.7975) (snd-display #__line__ ";mus-interpolate lagrange sin: ~A" val))))
    
    (let ((tag (catch #t (lambda () (mus-interpolate 1234 1.0 (make-vct 3))) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display #__line__ ";mus-interpolate 1234: ~A" tag)))
    (let ((tag (catch #t (lambda () (mus-interpolate mus-interp-linear 1.0 (make-vct 3) -1)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range))
	  (snd-display #__line__ ";mus-interpolate size -1: ~A" tag)))
    
    (let ((gen (make-delay 3))
	  (gen2 (make-delay 3))
	  (gen1 (make-delay 4 :initial-contents '(1.0 0.5 0.25 0.0)))
	  (gen3 (make-delay 4 :initial-contents (vct 1.0 0.5 0.25 0.0)))
	  (v0 (make-vct 10))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "delay" 
		       "delay line[3, step]: [0.000 0.000 0.000]")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (delay gen i)))
      (vct-map! v1 (let ((i 0)) (lambda () (let ((val (if (delay? gen2) (delay gen2 i) -1.0))) (set! i (+ 1 i)) val))))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map delay: ~A ~A" v0 v1))
      (if (not (delay? gen)) (snd-display #__line__ ";~A not delay?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";delay length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.0) (fneq (vct-ref v0 4) 1.0) (fneq (vct-ref v0 8) 5.0))
	  (snd-display #__line__ ";delay output: ~A" v0))
      (if (or (fneq (delay gen1) 1.0) 
	      (fneq (delay gen1) 0.5)
	      (fneq (delay gen1) 0.25)
	      (fneq (delay gen1) 0.0)
	      (fneq (delay gen1) 0.0))
	  (snd-display #__line__ ";delay with list initial-contents confused"))
      (if (or (fneq (delay gen3) 1.0) 
	      (fneq (delay gen3) 0.5)
	      (fneq (delay gen3) 0.25)
	      (fneq (delay gen3) 0.0)
	      (fneq (delay gen3) 0.0))
	  (snd-display #__line__ ";delay with vct initial-contents confused"))
      (let ((var (catch #t (lambda () (make-delay :size #f)) (lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-delay bad size #f: ~A" var)))
      (let ((var (catch #t (lambda () (make-delay 3 :initial-element (make-oscil))) (lambda args args))))
	(if (not (eq? (car var) 'wrong-type-arg))
	    (snd-display #__line__ ";make-delay bad initial element: ~A" var)))
      (let ((var (catch #t (lambda () (make-delay -3)) (lambda args args))))
	(if (not (eq? (car var) 'out-of-range))
	    (snd-display #__line__ ";make-delay bad size: ~A" var))))
    
    (test-gen-equal (let ((d1 (make-delay 3))) (delay d1 1.0) d1) 
		    (let ((d2 (make-delay 3))) (delay d2 1.0) d2)
		    (let ((d3 (make-delay 4))) (delay d3 1.0) d3))
    (test-gen-equal (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 0.5))
    (test-gen-equal (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-delay 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let ((gen (make-delay 5)))
      (delay gen 1.0)
      (delay gen 0.0)
      (delay gen 0.5)
      (let ((data (vct-copy (mus-data gen))))
	(vct-set! (mus-data gen) 0 0.3)
	(if (fneq (vct-ref (mus-data gen) 0) 0.3)
	    (snd-display #__line__ ";delay data 0: ~A" (vct-ref (mus-data gen) 0)))
	(vct-set! data 0 .75)
	(set! (mus-data gen) data)
	(if (fneq (vct-ref (mus-data gen) 0) 0.75)
	    (snd-display #__line__ ";delay set data 0: ~A" (vct-ref (mus-data gen) 0)))
	(delay gen 0.0)
	(delay gen 0.0)
	(let ((val (delay gen 0.0)))
	  (if (fneq val 0.75)
	      (snd-display #__line__ ";set delay data: ~A ~A" val (mus-data gen)))))
      (if (mus-data (make-oscil))
	  (snd-display #__line__ ";mus-data osc: ~A" (mus-data (make-oscil)))))
    
    (let* ((del (make-delay 5 :max-size 8)))
      (delay del 1.0)
      (do ((i 0 (+ 1 i))) ((= i 4)) (delay del 0.0))
      (let ((v0 (make-vct 5)))
	(do ((i 0 (+ 1 i)))
	    ((= i 5))
	  (vct-set! v0 i (delay del 0.0 0.4)))
	(if (not (vequal v0 (vct 0.600 0.400 0.000 0.000 0.000)))
	    (snd-display #__line__ ";zdelay: ~A" v0))
	(delay del 1.0)
	(delay del 0.0 0.4)
	(if (not (string=? (mus-describe del) "delay line[5,8, linear]: [0.000 0.000 1.000 0.000 0.000]"))
	    (snd-display #__line__ ";describe zdelay: ~A" (mus-describe del)))))
    (let ((tag (catch #t (lambda () 
			   (let ((gen (make-oscil)))
			     (tap gen)))
		      (lambda args (car args)))))
      (if (not (eq? tag 'wrong-type-arg))
	  (snd-display #__line__ ";tap of oscil: ~A" tag)))
    
    (let ((dly (make-delay 3))
	  (flt (make-one-zero .5 .4))
	  (v (make-vct 20))
	  (inval 1.0))
      (vct-map! v (lambda ()
		    (let ((res (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
		      (set! inval 0.0)
		      res)))
      (if (not (vequal v (vct 0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	  (snd-display #__line__ ";tap with low pass: ~A" v)))
    
    (let ((dly (make-delay 3))
	  (v (make-vct 20))
	  (inval 1.0))
      (vct-map! v (lambda ()
		    (let ((res (delay dly (+ inval (tap dly)))))
		      (set! inval 0.0)
		      res)))
      (if (not (vequal v (vct 0.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0 0.0 1.0 0.0)))
	  (snd-display #__line__ ";simple tap: ~A" v)))
    
    (let ((dly (make-delay 6))
	  (v (make-vct 20))
	  (inval 1.0))
      (vct-map! v (lambda ()
		    (let ((res (delay dly (+ inval (tap dly -2.0)))))
		      (set! inval 0.0)
		      res)))
      (set! (print-length) (max 20 (print-length)))
      (if (not (vequal v (vct 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 1.0 0.0)))
	  (snd-display #__line__ ";tap back 2: ~A" v)))
    
    (let ((dly (make-delay 3))
	  (flt (make-one-zero .5 .4))
	  (v (make-vct 20))
	  (inval 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 20))
	(vct-set! v i (let ((res (delay dly (+ inval (* (one-zero flt (tap dly)) .6)))))
			(set! inval 0.0)
			res)))
      (if (not (vequal v (vct 0.0 0.0 0.0 1.0 0.0 0.0 0.300 0.240 0.0 0.090 0.144 0.058 0.027 0.065 0.052 0.022 0.026 0.031 0.019 0.013)))
	  (snd-display #__line__ ";tap with low pass: ~A" v)))
    
    (let ((dly (make-delay 3 :initial-element 32.0)))
      (if (not (vct? (mus-data dly))) 
	  (snd-display #__line__ ";delay data not vct?")
	  (if (not (= (vct-length (mus-data dly)) 3))
	      (snd-display #__line__ ";delay data len not 3: ~A (~A)" (vct-length (mus-data dly)) (mus-data dly))
	      (if (fneq (vct-ref (mus-data dly) 1) 32.0) (snd-display #__line__ ";delay [1] 32: ~A" (vct-ref (mus-data dly) 1)))))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) -1)) (lambda args (car args)))))
	(if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";len to -1 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 0)) (lambda args (car args)))))
	(if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";len to 0 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	(if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";len to 100 -> ~A" tag)))
      (let ((tag (catch #t (lambda () (set! (vct-ref (mus-data dly) 100) .1)) (lambda args (car args)))))
	(if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";data 100 to .1 -> ~A" tag)))
      (let ((data (make-vct 32 1.0)))
	(set! (mus-data dly) data)
	(if (not (vct? (mus-data dly))) (snd-display #__line__ ";set delay data not vct?"))
	(if (fneq (vct-ref (mus-data dly) 1) 1.0) (snd-display #__line__ ";set delay [1] 1: ~A" (vct-ref (mus-data dly) 1)))
	(if (not (= (vct-length (mus-data dly)) 32)) (snd-display #__line__ ";set delay data len(32): ~A" (vct-length (mus-data dly))))
	(let ((tag (catch #t (lambda () (set! (mus-length dly) 100)) (lambda args (car args)))))
	  (if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";set len to 100 -> ~A" tag)))
	(let ((tag (catch #t (lambda () (set! (vct-ref (mus-data dly) 100) .1)) (lambda args (car args)))))
	  (if (not (equal? tag 'out-of-range)) (snd-display #__line__ ";set data 100 to .1 -> ~A" tag)))))
    
    (let ((d1 (make-delay 4))
	  (d2 (make-delay 4 :max-size 5 :type mus-interp-linear))
	  (d3 (make-delay 4 :max-size 5 :type mus-interp-all-pass))
	  (d4 (make-delay 4 :max-size 5 :type mus-interp-none))
	  (d5 (make-delay 4 :max-size 4 :type mus-interp-lagrange))
	  (d6 (make-delay 4 :max-size 4 :type mus-interp-hermite))
	  (d7 (make-delay 4 :max-size 4 :type mus-interp-linear))
	  (v1 (make-vct 20))
	  (v2 (make-vct 20))
	  (v3 (make-vct 20))
	  (v4 (make-vct 20))
	  (v5 (make-vct 20))
	  (v6 (make-vct 20))
	  (v7 (make-vct 20)))
      (if (not (= (mus-interp-type d1) mus-interp-none)) (snd-display #__line__ ";d1 interp type: ~A" (mus-interp-type d1)))
      (if (not (= (mus-interp-type d2) mus-interp-linear)) (snd-display #__line__ ";d2 interp type: ~A" (mus-interp-type d2)))
      (if (not (= (mus-interp-type d3) mus-interp-all-pass)) (snd-display #__line__ ";d3 interp type: ~A" (mus-interp-type d3)))
      (if (not (= (mus-interp-type d4) mus-interp-none)) (snd-display #__line__ ";d4 interp type: ~A" (mus-interp-type d4)))
      (if (not (= (mus-interp-type d5) mus-interp-lagrange)) (snd-display #__line__ ";d5 interp type: ~A" (mus-interp-type d5)))
      (if (not (= (mus-interp-type d6) mus-interp-hermite)) (snd-display #__line__ ";d6 interp type: ~A" (mus-interp-type d6)))
      (if (not (= (mus-interp-type d7) mus-interp-linear)) (snd-display #__line__ ";d7 interp type: ~A" (mus-interp-type d7)))
      (vct-set! v1 0 (delay d1 1.0))
      (vct-set! v2 0 (delay d2 1.0))
      (vct-set! v3 0 (delay d3 1.0))
      (vct-set! v4 0 (delay d4 1.0))
      (vct-set! v5 0 (delay d5 1.0))
      (vct-set! v6 0 (delay d6 1.0))
      (vct-set! v7 0 (delay d7 1.0))
      (delay-tick d1 0.0)
      (delay-tick d2 0.0)
      (delay-tick d3 0.0)
      (delay-tick d4 0.0)
      (delay-tick d5 0.0)
      (delay-tick d6 0.0)
      (delay-tick d7 0.0)
      (do ((i 1 (+ 1 i))
	   (j -0.2 (- j 0.2)))
	  ((= i 20))
	(vct-set! v1 i (tap d1 j))
	(vct-set! v2 i (tap d2 j))
	(vct-set! v3 i (tap d3 j))
	(vct-set! v4 i (tap d4 j))
	(vct-set! v5 i (tap d5 j))
	(vct-set! v6 i (tap d6 j))
	(vct-set! v7 i (tap d7 j)))
      (set! (print-length) (max 20 (print-length)))
      (if (and (not (vequal v1 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0)))
	       (not (vequal v1 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display #__line__ ";delay interp none (1): ~A" v1))
      (if (not (vequal v2 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay interp linear (2): ~A" v2))
      (if (not (vequal v3 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.600 0.160 0.168 -0.168 0.334 0.199 0.520 0.696 -0.696 0.557 -0.334 0.134 -0.027)))
	  (snd-display #__line__ ";delay interp all-pass (3): ~A" v3))
      (if (and (not (vequal v4 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0)))
	       (not (vequal v4 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0))))
	  (snd-display #__line__ ";delay interp none (4): ~A" v4))
      (if (not (vequal v5 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.120 0.280 0.480 0.720 1.000 0.960 0.840 0.640 0.360 0.000 -0.080 -0.120 -0.120 -0.080)))
	  (snd-display #__line__ ";delay interp lagrange (5): ~A" v5))
      (if (not (vequal v6 (vct 0.0 -0.016 -0.048 -0.072 -0.064 0.0 0.168 0.424 0.696 0.912 1.0 0.912 0.696 0.424 0.168 0.0 -0.064 -0.072 -0.048 -0.016)))
	  (snd-display #__line__ ";delay interp hermite (6): ~A" v6))
      (if (not (vequal v7 (vct 0.0 0.0 0.0 0.0 0.0 0.0 0.200 0.400 0.600 0.800 1.0 0.800 0.600 0.400 0.200 0.0 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay interp linear (7): ~A" v7)))
    
    (let ((dly1 (make-delay :size 2 :max-size 3))
	  (data (make-vct 5))
	  (impulse 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse 0.4)) ; longer line
	(set! impulse 0.0))
      (if (not (vequal data (vct 0.0 0.0 0.6 0.4 0.0)))
	  (snd-display #__line__ ";delay size 2, max 3, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 2 :max-size 3))
      (set! impulse 1.0)
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse -0.4)) ; shorter line
	(set! impulse 0.0))
      (if (not (vequal data (vct 0.0 0.4 0.6 0.0 0.0)))
	  (snd-display #__line__ ";delay size 2, max 3, off -0.4: ~A" data))
      
      (set! dly1 (make-delay :size 1 :max-size 2))
      (set! impulse 1.0)
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (vequal data (vct 0.0 0.6 0.4 0.0 0.0)))
	  (snd-display #__line__ ";delay size 1, max 2, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse 0.4))
	(set! impulse 0.0))
      (if (not (vequal data (vct 0.6 0.0 0.0 0.0 0.0)))
	  (snd-display #__line__ ";delay size 0, max 1, off 0.4: ~A" data))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (let ((val (delay dly1 0.0)))
	(if (fneq val 0.0) (snd-display #__line__ ";initial delay 0 size val: ~A" val)))
      
      (set! dly1 (make-delay :size 0 :max-size 1))
      (set! impulse 1.0)
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse -0.4)) ; shorter than 0? should this be an error?
	(set! impulse 0.0))
      (if (not (vequal data (vct 1.4 0.0 0.0 0.0 0.0))) ; hmmm -- they're asking for undefined values here 
	  (snd-display #__line__ ";delay size 0, max 1, off -0.4: ~A" data))
      
      (set! dly1 (make-delay 0))
      (set! impulse 1.0)
      (do ((i 0 (+ 1 i)))
	  ((= i 5))
	(vct-set! data i (delay dly1 impulse)) 
	(set! impulse 0.0))
      (if (not (vequal data (vct 1 0 0 0 0)))
	  (snd-display #__line__ ";delay size 0: ~A" data))
      
      (if (fneq (delay dly1 0.5) 0.5)
	  (snd-display #__line__ ";delay size 0 0.5: ~A" (delay dly 0.5)))
      )
    
    (let ((gen (make-delay :size 0 :max-size 100))
	  (v (make-vct 10)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v i (delay gen 0.5 i)))
      (if (not (vequal v (vct 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";delay 0 -> 100: ~A" v))
      (do ((i 9 (- i 1)))
	  ((< i 0))
	(vct-set! v i (delay gen 0.5 i)))
      (if (not (vequal v (vct 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.500 0.000)))
	  (snd-display #__line__ ";delay 100 -> 0: ~A" v))
      (mus-reset gen)
      (if (not (vequal (mus-data gen) (make-vct 100 0.0)))
	  (snd-display #__line__ ";after reset mus-data delay peak: ~A" (vct-peak (mus-data gen))))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v i (delay gen (if (odd? i) 1.0 0.0) (* i .1))))
      (if (not (vequal v (vct 0.000 0.900 0.000 0.700 0.000 0.500 0.000 0.300 0.000 0.100)))
	  (snd-display #__line__ ";delay 0 -> 100 .1: ~A (~A)" v gen))
      (mus-reset gen)
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v i (delay gen (if (odd? i) 1.0 0.0) (+ 1.0 (* i .1)))))
      (if (not (vequal v (vct 0.000 0.000 0.800 0.300 0.600 0.500 0.400 0.700 0.200 0.900)))
	  (snd-display #__line__ ";delay 0 -> 100 1.1: ~A" v)))
    
    
    (let ((gen (make-all-pass .4 .6 3))
	  (v0 (make-vct 10))
	  (gen1 (make-all-pass .4 .6 3))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "all-pass"
		       "all-pass feedback: 0.400, feedforward: 0.600, line[3, step]:[0.000 0.000 0.000]")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (all-pass gen 1.0)))
      (vct-map! v1 (lambda () (if (all-pass? gen1) (all-pass gen1 1.0) -1.0)))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map all-pass: ~A ~A" v0 v1))
      (if (not (all-pass? gen)) (snd-display #__line__ ";~A not all-pass?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";all-pass length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";all-pass order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";all-pass feedback: ~F?" (mus-feedback gen)))
      (if (fneq (mus-feedforward gen) .6) (snd-display #__line__ ";all-pass feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (vct-ref v0 1) 0.6) (fneq (vct-ref v0 4) 1.84) (fneq (vct-ref v0 8) 2.336))
	  (snd-display #__line__ ";all-pass output: ~A" v0))
      (set! (mus-feedback gen) 0.5) 
      (if (fneq (mus-feedback gen) .5) (snd-display #__line__ ";all-pass set-feedback: ~F?" (mus-feedback gen)))
      (set! (mus-feedforward gen) 0.5) 
      (if (fneq (mus-feedforward gen) .5) (snd-display #__line__ ";all-pass set-feedforward: ~F?" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-all-pass 0.7 0.5 3))) (all-pass d1 1.0) d1)
		    (let ((d2 (make-all-pass 0.7 0.5 3))) (all-pass d2 1.0) d2) 
		    (let ((d3 (make-all-pass 0.7 0.5 4))) (all-pass d3 1.0) d3))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 0.5))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		    (make-all-pass 0.5 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-all-pass :feedback .2 :feedforward .1 :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-all-pass bad size error message: ~A" err)))
    
    (let ((gen (make-moving-average 4))
	  (v0 (make-vct 10))
	  (gen1 (make-moving-average 4))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "moving-average"
		       "moving-average 0.000, line[4]:[0.000 0.000 0.000 0.000]")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (moving-average gen 1.0)))
      (vct-map! v1 (lambda () (if (moving-average? gen1) (moving-average gen1 1.0) -1.0)))
      (if (not (vequal v1 v0)) (snd-display #__line__ ";map average: ~A ~A" v0 v1))
      (if (not (moving-average? gen)) (snd-display #__line__ ";~A not average?" gen))
      (if (not (= (mus-length gen) 4)) (snd-display #__line__ ";average length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 4)) (snd-display #__line__ ";average order: ~D?" (mus-order gen)))
      (if (or (fneq (vct-ref v0 1) 0.5) (fneq (vct-ref v0 4) 1.0) (fneq (vct-ref v0 8) 1.0))
	  (snd-display #__line__ ";average output: ~A" v0)))
    
    (let* ((gen (make-moving-average 8))
	   (val (moving-average gen)))
      (if (fneq val 0.0) (snd-display #__line__ ";empty average: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.125) (snd-display #__line__ ";average 1: ~A" val))
      (set! val (moving-average gen 1.0))
      (if (fneq val 0.25) (snd-display #__line__ ";average 2: ~A" val))
      (set! val (moving-average gen 0.5))
      (if (fneq val 0.3125) (snd-display #__line__ ";average 2: ~A" val))
      (do ((i 0 (+ 1 i))) ((= i 5)) (set! val (moving-average gen 0.0))) 
      (if (fneq val 0.3125) (snd-display #__line__ ";average 6: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.1875) (snd-display #__line__ ";average 7: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0625) (snd-display #__line__ ";average 8: ~A" val))
      (set! val (moving-average gen 0.0))
      (if (fneq val 0.0) (snd-display #__line__ ";average 9: ~A" val))
      )
    (let* ((gen (make-moving-average 10 :initial-element .5))
	   (val (moving-average gen 0.5)))
      (if (fneq val 0.5) (snd-display #__line__ ";average initial-element: ~A" val)))
    (let* ((gen (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)))
	   (val (moving-average gen 1.0)))
      (if (fneq val 1.0) (snd-display #__line__ ";average initial-contents: ~A" val)))
    
    (test-gen-equal (let ((d1 (make-moving-average 3 :initial-contents '(0.7 0.5 3)))) (moving-average d1 1.0) d1)
		    (let ((d2 (make-moving-average 3 :initial-contents (vct 0.7 0.5 3)))) (moving-average d2 1.0) d2) 
		    (let ((d3 (make-moving-average 4 :initial-contents '(0.7 0.5 0.1 4)))) (moving-average d3 1.0) d3))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 0.5))
    (test-gen-equal (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 3 :initial-element 1.0) 
		    (make-moving-average 4 :initial-element 1.0))
    (test-gen-equal (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-moving-average 3 :initial-contents '(1.0 1.0 1.0)))
    (let ((err (catch #t (lambda () (make-moving-average :size -1)) (lambda args args))))
      (if (not (eq? (car err) 'out-of-range))
	  (snd-display #__line__ ";make-average bad size error message: ~A" err)))
    
    (let ((gen (make-comb .4 3))
	  (v0 (make-vct 10))
	  (gen1 (make-comb .4 3))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "comb"
		       "comb scaler: 0.400, line[3, step]: [0.000 0.000 0.000]")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (comb gen 1.0)))
      (vct-map! v1 (lambda () (if (comb? gen1) (comb gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map comb: ~A ~A" v0 v1))
      (if (not (comb? gen)) (snd-display #__line__ ";~A not comb?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";comb feedback: ~F?" (mus-feedback gen)))
      (if (or (fneq (vct-ref v0 1) 0.0) (fneq (vct-ref v0 4) 1.0) (fneq (vct-ref v0 8) 1.4))
	  (snd-display #__line__ ";comb output: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-comb 0.7 3))) (comb d1 1.0) d1) 
		    (let ((d2 (make-comb 0.7 3))) (comb d2 1.0) d2) 
		    (let ((d3 (make-comb 0.7 4))) (comb d3 1.0) d3))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.7 3 :initial-element 1.0) 
		    (make-comb 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-comb 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    (let* ((del (make-comb 0.0 5 :max-size 8)))
      (comb del 1.0)
      (do ((i 0 (+ 1 i))) ((= i 4)) (comb del 0.0))
      (let ((v0 (make-vct 5)))
	(do ((i 0 (+ 1 i)))
	    ((= i 5))
	  (vct-set! v0 i (comb del 0.0 0.4)))
	(if (not (vequal v0 (vct 0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	    (snd-display #__line__ ";zcomb: ~A" v0))
	(comb del 1.0)
	(comb del 0.0 0.4)
	(if (not (string=? (mus-describe del) "comb scaler: 0.000, line[5,8, linear]: [0.000 0.000 1.000 0.000 0.000]"))
	    (snd-display #__line__ ";describe zcomb: ~A" (mus-describe del))))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display #__line__ ";comb feedback set: ~A" (mus-feedback del))))
    
    
    (let ((gen (make-filtered-comb .4 5 :filter (make-one-zero .3 .7)))
	  (v0 (make-vct 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.400, line[5, step]: [0.000 0.000 0.000 0.000 0.000], filter: [one-zero a0: 0.300, a1: 0.700, x1: 0.000]")
      (let ((val 1.0))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v0 i (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.120 0.280 0.000 0.000 0.000 0.014 0.067 0.078 0.000 0.000)))
	  (snd-display #__line__ ";filtered-comb: ~A" v0))
      (if (not (filtered-comb? gen)) (snd-display #__line__ ";~A not filtered-comb?" gen))
      (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";filtered-comb length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 5)) (snd-display #__line__ ";filtered-comb order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedback gen) .4) (snd-display #__line__ ";filtered-comb feedback: ~F?" (mus-feedback gen))))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-one-zero .5 .5)))
	  (v0 (make-vct 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0.000 0.000 0.000 0.000 0.000], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]")
      (let ((val 1.0))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v0 i (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.450 0.450 0.000 0.000 0.000 0.202 0.405 0.202 0.000 0.000)))
	  (snd-display #__line__ ";filtered-comb .5 .5: ~A" v0)))
    
    (let ((gen (make-filtered-comb .9 5 :filter (make-fir-filter 5 (vct .1 .2 .3 .2 .1))))
	  (v0 (make-vct 20)))
      (print-and-check gen 
		       "filtered-comb"
		       "filtered-comb scaler: 0.900, line[5, step]: [0.000 0.000 0.000 0.000 0.000], filter: [fir-filter order: 5, xs: [0.100 0.200 0.300 0.200 0.100]]")
      (let ((val 1.0))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v0 i (filtered-comb gen val))
	  (set! val 0.0)))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.090 0.180 0.270 0.180 0.090 0.008 0.032 0.081 0.130 0.154)))
	  (snd-display #__line__ ";filtered-comb fir: ~A" v0)))
    
    (test-gen-equal (let ((d1 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d1 1.0) d1) 
		    (let ((d2 (make-filtered-comb 0.7 3 :filter (make-one-pole .3 .7)))) (filtered-comb d2 1.0) d2) 
		    (let ((d3 (make-filtered-comb 0.7 4 :filter (make-one-pole .3 .7)))) (filtered-comb d3 1.0) d3))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 0.5 :filter (make-one-zero .5 .5)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-element 1.0 :filter (make-one-zero .25 .75)))
    (test-gen-equal (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 0.0 0.0) :filter (make-one-zero .5 .5)) 
		    (make-filtered-comb 0.7 3 :initial-contents '(1.0 1.0 1.0) :filter (make-one-zero .5 .5)))
    
    (let* ((del (make-filtered-comb 0.0 5 :max-size 8 :filter (make-one-zero .5 .5))))
      (filtered-comb del 1.0)
      (do ((i 0 (+ 1 i))) ((= i 4)) (filtered-comb del 0.0))
      (let ((v0 (make-vct 5)))
	(do ((i 0 (+ 1 i)))
	    ((= i 5))
	  (vct-set! v0 i (filtered-comb del 0.0 0.4)))
	(if (not (vequal v0 (vct 0.600 0.400 0.000 0.000 0.000))) ; this is assuming interpolation in the delay...
	    (snd-display #__line__ ";zfiltered-comb: ~A" v0))
	(filtered-comb del 1.0)
	(filtered-comb del 0.0 0.4)
	(if (not (string=? (mus-describe del)
			   "filtered-comb scaler: 0.000, line[5,8, linear]: [0.000 0.000 1.000 0.000 0.000], filter: [one-zero a0: 0.500, a1: 0.500, x1: 0.000]"))
	    (snd-display #__line__ ";describe zfiltered-comb: ~A" (mus-describe del))))
      (set! (mus-feedback del) 1.0)
      (if (fneq (mus-feedback del) 1.0)
	  (snd-display #__line__ ";filtered-comb feedback set: ~A" (mus-feedback del))))
    
    
    (let ((gen (make-notch .4 3))
	  (v0 (make-vct 10))
	  (gen1 (make-notch .4 3))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "notch"
		       "notch scaler: 0.400, line[3, step]: [0.000 0.000 0.000]")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (notch gen 1.0)))
      (vct-map! v1 (lambda () (if (notch? gen1) (notch gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map notch: ~A ~A" v0 v1))
      (if (not (notch? gen)) (snd-display #__line__ ";~A not notch?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";notch length: ~D?" (mus-length gen)))
      (if (not (= (mus-order gen) 3)) (snd-display #__line__ ";notch order: ~D?" (mus-order gen)))
      (if (fneq (mus-feedforward gen) .4) (snd-display #__line__ ";notch feedforward: ~F?" (mus-feedforward gen)))
      (if (or (fneq (vct-ref v0 1) 0.4) (fneq (vct-ref v0 4) 1.4) (fneq (vct-ref v0 8) 1.4))
	  (snd-display #__line__ ";notch output: ~A" v0))
      (set! (mus-feedforward gen) 1.0)
      (if (fneq (mus-feedforward gen) 1.0)
	  (snd-display #__line__ ";notch feedforward set: ~A" (mus-feedforward gen))))
    
    (test-gen-equal (let ((d1 (make-notch 0.7 3))) (notch d1 1.0) d1)
		    (let ((d2 (make-notch 0.7 3))) (notch d2 1.0) d2)
		    (let ((d3 (make-notch 0.7 4))) (notch d3 1.0) d3))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 0.5))
    (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.7 3 :initial-element 1.0) 
		    (make-notch 0.5 3 :initial-element 1.0))
    (test-gen-equal (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		    (make-notch 0.7 3 :initial-contents '(1.0 1.0 1.0)))
    
    ;; make sure all-pass is the same as comb/notch given the appropriate feedback/forward settings
    
    (let ((gen (make-comb 0.5 5))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (notch gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";all-pass (5 .5 0): ~A" v0)))
    
    ;; make sure zall-pass is the same as zcomb/znotch given the appropriate feedback/forward and "pm" settings
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";1comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.500)))
	  (snd-display #__line__ ";1all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (notch gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";1notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-vct 11))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 11))
	(vct-set! v0 i (all-pass gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";1all-pass (5 .5 0): ~A" v0)))
    
    ;; now actually use the size difference
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(vct-set! v0 i (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.160 0.360 0.200 0.040 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(vct-set! v0 i (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";2all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(vct-set! v0 i (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	  (snd-display #__line__ ";3comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.160 0.160 0.000 0.080 0.064 0.016 0.035 0.013 0.018 0.007 0.007 0.003 0.002)))
	  (snd-display #__line__ ";3all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(vct-set! v0 i (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";3notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.800 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";3all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-comb 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(vct-set! v0 i (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	  (snd-display #__line__ ";4comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.428 0.079 0.004 0.000 0.000 0.182 0.067 0.008 0.000 0.000)))
	  (snd-display #__line__ ";4all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(vct-set! v0 i (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";4notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 20))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";4all-pass (5 .5 0): ~A" v0)))
    
    ;; now run off either end of the delay line "by accident"
    
    (let ((gen (make-comb 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(vct-set! v0 i (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	  (snd-display #__line__ ";5comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.250 0.125 0.094 0.062 0.055 0.047 0.039 0.031 0.029)))
	  (snd-display #__line__ ";5all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(vct-set! v0 i (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";5notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .5)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.500 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";5all-pass (5 .5 0): ~A" v0)))
    
    
    (let ((gen (make-comb 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(vct-set! v0 i (comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	  (snd-display #__line__ ";6comb (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.5 0.0 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.500 0.000 0.125 0.000 0.031 0.016 0.004 1.000 0.000 0.250 0.031 0.000 0.012 0.002 0.250 0.125 0.008)))
	  (snd-display #__line__ ";6all-pass (5 0 .5): ~A" v0)))
    
    (let ((gen (make-notch 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(vct-set! v0 i (notch gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";6notch (5 .5): ~A" v0)))
    
    (let ((gen (make-all-pass 0.0 0.5 5 :max-size 10))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .5)))
	  ((= i 20))
	(vct-set! v0 i (all-pass gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.500 0.000 0.000 0.500 0.000 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display #__line__ ";6all-pass (5 .5 0): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :filter (make-one-zero .5 .5)))
	  (v0 (make-vct 21))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 21))
	(vct-set! v0 i (filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.250 0.250 
			       0.000 0.000 0.000 0.062 0.125 0.062 0.000 0.000 0.016)))
	  (snd-display #__line__ ";filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .25 .75)))
	  (v0 (make-vct 21))
	  (in1 1.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 21))
	(vct-set! v0 i (filtered-comb gen in1))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.125 0.375 
			       0.000 0.000 0.000 0.016 0.094 0.141 0.000 0.000 0.002)))
	  (snd-display #__line__ ";1filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .2)))
	  ((= i 20))
	(vct-set! v0 i (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.800 0.400 0.000 0.000 0.000 0.000 0.000 0.080 0.220 0.300 0.140 0.040 0.000 0.000)))
	  (snd-display #__line__ ";2filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (- angle .2)))
	  ((= i 20))
	(vct-set! v0 i (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.800 0.000 0.000 0.080 0.200 0.040 0.020 0.068 0.042 0.019 0.026 0.015 0.011 0.009 0.006 0.004)))
	  (snd-display #__line__ ";3filtered-comb (5 .5): ~A" v0)))
    
    (let ((gen (make-filtered-comb 0.5 5 :max-size 20 :filter (make-one-zero .5 .5)))
	  (v0 (make-vct 20))
	  (in1 1.0))
      (do ((i 0 (+ 1 i))
	   (angle 0.0 (+ angle .01)))
	  ((= i 20))
	(vct-set! v0 i (filtered-comb gen in1 angle))
	(set! in1 0.0))
      (if (not (vequal v0 (vct 0.000 0.000 0.000 0.000 0.000 0.950 0.060 0.000 0.000 0.000 0.214 0.251 0.043 0.002 0.000 0.045 0.106 0.081 0.023 0.003)))
	  (snd-display #__line__ ";4filtered-comb (5 .5): ~A" v0)))
    
    
    (let ((gen (make-one-pole .4 .7))
	  (v0 (make-vct 10))
	  (gen1 (make-one-pole .4 .7))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "one-pole"
		       "one-pole a0: 0.400, b1: 0.700, y1: 0.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (one-pole gen 1.0)))
      (vct-map! v1 (lambda () (if (one-pole? gen) (one-pole gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map one-pole: ~A ~A" v0 v1))
      (if (not (one-pole? gen)) (snd-display #__line__ ";~A not one-pole?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display #__line__ ";one-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) .4) (snd-display #__line__ ";one-pole a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-b1 gen) .7) (snd-display #__line__ ";one-pole b1: ~F?" (mus-b1 gen)))
      (if (or (fneq (vct-ref v0 1) 0.120) (fneq (vct-ref v0 4) 0.275) (fneq (vct-ref v0 8) 0.245))
	  (snd-display #__line__ ";one-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";1p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display #__line__ ";1p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";1p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display #__line__ ";1p set xcoeff 0 .3: ~A" gen)))
    
    
    (let ((gen (make-one-zero .4 .7))
	  (v0 (make-vct 10))
	  (gen1 (make-one-zero .4 .7))
	  (v1 (make-vct 10)))
      (print-and-check gen
		       "one-zero"
		       "one-zero a0: 0.400, a1: 0.700, x1: 0.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (one-zero gen 1.0)))
      (vct-map! v1 (lambda () (if (one-zero? gen) (one-zero gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map one-zero: ~A ~A" v0 v1))
      (if (not (one-zero? gen)) (snd-display #__line__ ";~A not one-zero?" gen))
      (if (not (= (mus-order gen) 1)) (snd-display #__line__ ";one-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) .4) (snd-display #__line__ ";one-zero a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-a1 gen) .7) (snd-display #__line__ ";one-zero a1: ~F?" (mus-a1 gen)))
      (if (fneq (vct-ref v0 1) 1.1) (snd-display #__line__ ";one-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";1z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display #__line__ ";1z set xcoeff 0 .1: ~A" gen)))
    
    (let ((gen (make-two-zero .4 .7 .3))
	  (v0 (make-vct 10))
	  (gen1 (make-two-zero .4 .7 .3))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "two-zero"
		       "two-zero a0: 0.400, a1: 0.700, a2: 0.300, x1: 0.000, x2: 0.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (two-zero gen 1.0)))
      (vct-map! v1 (lambda () (if (two-zero? gen1) (two-zero gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map two-zero: ~A ~A" v0 v1))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not two-zero?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";two-zero order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) .4) (snd-display #__line__ ";two-zero a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-a1 gen) .7) (snd-display #__line__ ";two-zero a1: ~F?" (mus-a1 gen)))
      (if (fneq (mus-a2 gen) .3) (snd-display #__line__ ";two-zero a2: ~F?" (mus-a2 gen)))
      (if (or (fneq (vct-ref v0 1) 1.1) (fneq (vct-ref v0 8) 1.4)) (snd-display #__line__ ";two-zero output: ~A" v0))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";2z xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .1)
      (if (fneq (mus-xcoeff gen 0) .1) (snd-display #__line__ ";2z set xcoeff 0 .1: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-frequency two-zero: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display #__line__ ";set mus-frequency two-zero hit r: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) .99)
	(if (fneq (mus-scaler gen) .99) (snd-display #__line__ ";set mus-scaler two-zero: ~A" (mus-scaler gen)))
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-scaler hit freq two-zero: ~A" (mus-frequency gen)))
	(let ((g3 (make-two-zero :radius .99 :frequency 500.0)))
	  (if (or (fneq (mus-a0 gen) (mus-a0 g3))
		  (fneq (mus-a1 gen) (mus-a1 g3))
		  (fneq (mus-a2 gen) (mus-a2 g3)))
	      (snd-display #__line__ ";two-zero setters: ~A ~A" gen g3)))))
    
    (let ((gen (make-two-zero .4 .7 .3)))
      (let ((val (gen 1.0)))
	(if (fneq val .4) (snd-display #__line__ ";2zero->0.4: ~A" val))
	(set! val (gen 0.5))
	(if (fneq val .9) (snd-display #__line__ ";2zero->0.9: ~A" val))
	(set! val (gen 1.0))
	(if (fneq val 1.05) (snd-display #__line__ ";2zero->1.05: ~A" val))))
    
    (let ((gen (make-two-pole .4 .7 .3))
	  (v0 (make-vct 10))
	  (gen1 (make-two-pole .4 .7 .3))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "two-pole"
		       "two-pole a0: 0.400, b1: 0.700, b2: 0.300, y1: 0.000, y2: 0.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (two-pole gen 1.0)))
      (vct-map! v1 (lambda () (if (two-pole? gen1) (two-pole gen1 1.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map two-pole: ~A ~A" v0 v1))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not two-pole?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";two-pole order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) .4) (snd-display #__line__ ";two-pole a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-b1 gen) .7) (snd-display #__line__ ";two-pole b1: ~F?" (mus-b1 gen)))
      (if (fneq (mus-b2 gen) .3) (snd-display #__line__ ";two-pole b2: ~F?" (mus-b2 gen)))
      (if (or (fneq (vct-ref v0 1) 0.12) (fneq (vct-ref v0 8) 0.201)) (snd-display #__line__ ";two-pole output: ~A" v0))
      (if (fneq (mus-ycoeff gen 1) .7) (snd-display #__line__ ";2p ycoeff 1 .7: ~A" gen))
      (set! (mus-ycoeff gen 1) .1)
      (if (fneq (mus-ycoeff gen 1) .1) (snd-display #__line__ ";2p set ycoeff 1 .1: ~A" gen))
      (if (fneq (mus-xcoeff gen 0) .4) (snd-display #__line__ ";2p xcoeff 0 .4: ~A" gen))
      (set! (mus-xcoeff gen 0) .3)
      (if (fneq (mus-xcoeff gen 0) .3) (snd-display #__line__ ";2p set xcoeff 0 .3: ~A" gen))
      (set! (mus-xcoeff gen 0) 1.0)
      (let ((r (mus-scaler gen)))
	(set! (mus-frequency gen) 500.0)
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-frequency two-pole: ~A" (mus-frequency gen)))
	(if (fneq (mus-scaler gen) r) (snd-display #__line__ ";set mus-frequency two-pole hit r: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) .99)
	(if (fneq (mus-scaler gen) .99) (snd-display #__line__ ";set mus-scaler two-pole: ~A" (mus-scaler gen)))
	(if (ffneq (mus-frequency gen) 500.0) (snd-display #__line__ ";set mus-scaler hit freq two-pole: ~A" (mus-frequency gen)))
	(let ((g3 (make-two-pole :radius .99 :frequency 500.0)))
	  (if (or (fneq (mus-a0 gen) (mus-a0 g3))
		  (fneq (mus-b1 gen) (mus-b1 g3))
		  (fneq (mus-b2 gen) (mus-b2 g3)))
	      (snd-display #__line__ ";two-pole setters: ~A ~A" gen g3)))))
    
    (let ((gen (make-two-pole .4 .7 .3)))
      (let ((val (gen 1.0)))
	(if (fneq val .4) (snd-display #__line__ ";a0->out 2pole: ~A" val))
	(set! val (gen 0.5))
	(if (fneq val -.08) (snd-display #__line__ ";a0->out 2pole (-0.08): ~A" val))
	(set! val (gen 1.0))
	(if (fneq val 0.336) (snd-display #__line__ ";a0->out 2pole (0.336): ~A" val))))
    
    (let ((var (catch #t (lambda () (make-two-pole :b1 3.0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-two-pole bad b1: ~A" var)))
    (let ((var (catch #t (lambda () (make-two-pole :b2 2.0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-two-pole bad b2: ~A" var)))
    (let ((var (catch #t (lambda () (make-two-pole :b2 2.0 :b1)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-two-pole bad keys: ~A" var)))
    (let ((var (catch #t (lambda () (make-two-pole :b2 2.0 3.0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-two-pole bad args: ~A" var)))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (gen2 (make-oscil 440.0))
	  (v0 (make-vct 10))
	  (v1 (make-vct 10))
	  (v2 (make-vct 10)))
      (print-and-check gen 
		       "oscil"
		       "oscil freq: 440.000Hz, phase: 0.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (oscil gen 0.0))
	(vct-set! v1 i (mus-apply gen1 0.0 0.0)))
      (vct-map! v2 (lambda () (if (oscil? gen2) (oscil gen2 0.0) -1.0)))
      (if (not (vequal v0 v2)) (snd-display #__line__ ";map oscil: ~A ~A" v0 v2))
      (if (not (oscil? gen)) (snd-display #__line__ ";~A not oscil?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";oscil phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";oscil frequency: ~F?" (mus-frequency gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";oscil cosines: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 8) 0.843)) (snd-display #__line__ ";oscil output: ~A" v0))
      (set! (mus-phase gen) 0.0)
      (if (fneq (mus-phase gen) 0.0) (snd-display #__line__ ";oscil set-phase: ~F?" (mus-phase gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";oscil set-frequency: ~F?" (mus-frequency gen)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(if (fneq (vct-ref v0 i) (vct-ref v1 i))
	    (snd-display #__line__ ";mus-apply oscil at ~D: ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i))))
      (if (fneq (mus-apply) 0.0)
	  (snd-display #__line__ ";(mus-apply): ~A" (mus-apply))))
    
    (let ((gen1 (make-oscil 100.0))
	  (gen2 (make-oscil -100.0))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";oscil +-: ~A" mx)))
    
    (let ((gen1 (make-oscil 100.0 (* pi 0.5)))
	  (gen2 (make-oscil -100.0 (* pi 0.5)))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (- (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";cosil +-: ~A" mx)))
    
    (fm-test (make-oscil))
    (fm-test (make-nrxysin))
    (fm-test (make-nrxycos))
    (fm-test (make-square-wave))
    (fm-test (make-triangle-wave))
    (fm-test (make-ncos))
    (fm-test (make-nsin))
    (fm-test (make-sawtooth-wave))
    (fm-test (make-rand))
    (fm-test (make-rand-interp))
    (fm-test (make-pulse-train))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let ((oval (oscil gen .1))
	      (mval (mus-run gen1 .1)))
	  (if (fneq oval mval)
	      (snd-display #__line__ ";mus-run ~A but oscil ~A?" mval oval)))))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (gen2 (make-oscil 440.0))
	  (gen3 (make-oscil 440.0))
	  (fm-index (hz->radians 440.0))
	  (v0 (make-vct 10))
	  (v1 (make-vct 10)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (oscil gen (* fm-index (oscil gen1 0.0))))
	(vct-set! v1 i (mus-apply gen2 (* fm-index (mus-apply gen3 0.0 0.0)) 0.0)))
      (if (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 6) 0.830) (fneq (vct-ref v0 8) 0.987))
	  (snd-display #__line__ ";oscil fm output: ~A" v0))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(if (fneq (vct-ref v0 i) (vct-ref v1 i))
	    (snd-display #__line__ ";mus-apply fm oscil at ~D: ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i)))))
    
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 100.0))
    (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 440.0 1.0))
    
    (let ((gen (make-oscil 440.0))
	  (gen1 (make-oscil 440.0))
	  (pm-index 2.0)
	  (v0 (make-vct 10)))
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (gen 0.0 (* pm-index (gen1 0.0)))))
      (if (or (fneq (vct-ref v0 1) 0.367) (fneq (vct-ref v0 6) 0.854) (fneq (vct-ref v0 8) 0.437))
	  (snd-display #__line__ ";oscil pm output: ~A" v0)))
    
    (let ((gen (make-oscil 440.0)))
      (do ((i 0 (+ 1 i)))
	  ((= i 1100))
	(let* ((val1 (sin (mus-phase gen)))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 440.0 :initial-phase (* pi 0.5))))
      (do ((i 0 (+ 1 i))
	   (a 0.0 (+ a (/ (* 2 pi 440.0) 22050.0))))
	  ((= i 900))
	(let* ((val1 (cos a))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil (cos): ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 0.0))
	  (gen1 (make-oscil 40.0)))
      (do ((i 0 (+ 1 i))
	   (a 0.0 (+ a (/ (* 2 pi 40.0) 22050.0))))
	  ((= i 1100))
	(let* ((val1 (sin (sin a)))
	       (val2 (oscil gen 0.0 (oscil gen1 0.0))))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil pm: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen (make-oscil 0.0))
	  (gen1 (make-oscil 40.0))
	  (a1 0.0))
      (do ((i 0 (+ 1 i))
	   (a 0.0 (+ a (/ (* 2 pi 40.0) 22050.0))))
	  ((= i 100))
	(let* ((fm (sin a))
	       (val1 (sin a1))
	       (val2 (oscil gen (oscil gen1 0.0))))
	  (set! a1 (+ a1 fm))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";oscil fm: ~A: ~A ~A" i val1 val2)))))
    
    (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-location (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-location bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-scaler (make-oscil)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-scaler bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (mus-frequency (make-one-pole))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (set! (mus-frequency (make-one-pole)) 0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";set mus-frequency bad gen: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay (* 1024 1024 40))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-delay huge line: ~A" var)))
    (let ((var (catch #t (lambda () (make-delay 32 :max-size (* 1024 1024 40))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-delay huge line: ~A" var)))
    
    (let ((size 1000))
      
      (define (test-pm beg end freq amp mc-ratio index)
	(let ((pm (make-oscil (* freq mc-ratio)))
	      (carrier (make-oscil freq)))
	  (do ((i beg (+ 1 i)))
	      ((= i end))
	    (outa i (* amp (oscil carrier 0.0 (* index (oscil pm))))))))
      
      (define (test-fm beg end freq amp mc-ratio index)
	(let ((fm (make-oscil (* freq mc-ratio) :initial-phase (/ pi 2.0)))
	      (carrier (make-oscil freq))
	      (fm-index (* (hz->radians freq) mc-ratio index)))
	  (do ((i beg (+ 1 i)))
	      ((= i end))
	    (outa i (* amp (oscil carrier (* fm-index (oscil fm))))))))
      
      ;; there's an initial-phase confusion here, so by making the srate high and freq low, we minimize uninteresting off-by-1 troubles
      
      (let ((v1 (with-sound (:output (make-vct size) :srate 441000) (test-pm 0 size 20 1 1 1)))
	    (v2 (with-sound (:output (make-vct size) :srate 441000) (test-fm 0 size 20 1 1 1))))
	(if (not (vequal v1 v2))
	    (snd-display #__line__ ";fm/pm peak diff (1 1): ~A" (vct-peak (vct-subtract! v1 v2)))))
      
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(let ((ratio (+ 1 (random 4)))
	      (index (random 2.0)))
	  (let ((v1 (with-sound (:output (make-vct size) :srate 441000) (test-pm 0 size 20 1 ratio index)))
		(v2 (with-sound (:output (make-vct size) :srate 441000) (test-fm 0 size 20 1 ratio index))))
	    (if (not (vequal v1 v2))
		(snd-display #__line__ ";fm/pm peak diff ~A ~A: ~A" ratio index (vct-peak (vct-subtract! v1 v2))))))))
    
    (let ((gen (make-ncos 440.0 10))
	  (v0 (make-vct 10))
	  (gen1 (make-ncos 440.0 10))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "ncos"
		       "ncos freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (ncos gen 0.0)))
      (vct-map! v1 (lambda () (if (ncos? gen1) (ncos gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map ncos: ~A ~A" v0 v1))
      (if (not (ncos? gen)) (snd-display #__line__ ";~A not ncos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";ncos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";ncos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1) (snd-display #__line__ ";ncos scaler: ~F?" (mus-scaler gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";ncos n: ~D?" (mus-length gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";ncos length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.722) (fneq (vct-ref v0 8) -0.143)) (snd-display #__line__ ";ncos output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";ncos set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";set ncos n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2) (snd-display #__line__ ";set n->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 440.0 5))
    (test-gen-equal (make-ncos 440.0 3) (make-ncos 440.0 3) (make-ncos 400.0 3))
    
    (let ((gen (make-ncos 440 10)))
      (do ((i 0 (+ 1 i)))
	  ((= i 1100))
	(let* ((den (sin (* (mus-phase gen) 0.5)))
	       (val1 (if (= 0.0 den)
			 1.0
			 (min 1.0 (* (mus-scaler gen)
				     (- (/ (sin (* (mus-phase gen)
						   (+ (mus-length gen) 0.5)))
					   (* 2.0 den))
					0.5)))))
	       (val2 (gen 0.0)))
	  (if (> (abs (- val1 val2)) .002)
	      (snd-display #__line__ ";ncos: ~A: ~A ~A" i val1 val2)))))
    
    (let ((gen1 (make-ncos 100.0 10))
	  (gen2 (make-ncos -100.0 10))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (- (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";ncos +-: ~A" mx)))
    
    (let ((gen (make-nsin 440.0 10))
	  (v0 (make-vct 10))
	  (gen1 (make-nsin 440.0 10))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "nsin"
		       "nsin freq: 440.000Hz, phase: 0.000, n: 10")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (nsin gen 0.0)))
      (vct-map! v1 (lambda () (if (nsin? gen1) (nsin gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nsin: ~A ~A" v0 v1))
      (if (not (nsin? gen)) (snd-display #__line__ ";~A not nsin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nsin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nsin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) .1315) (snd-display #__line__ ";nsin scaler: ~F?" (mus-scaler gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";nsin n: ~D?" (mus-length gen)))
      (if (not (= (mus-length gen) 10)) (snd-display #__line__ ";nsin length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.784) (fneq (vct-ref v0 8) 0.181)) (snd-display #__line__ ";nsin output: ~A" v0))
      (set! (mus-scaler gen) .5) (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";nsin set-scaler: ~F?" (mus-scaler gen)))
      (set! (mus-length gen) 5) (if (not (= (mus-length gen) 5)) (snd-display #__line__ ";set nsin n: ~D?" (mus-length gen)))
      (if (fneq (mus-scaler gen) .2525) (snd-display #__line__ ";set sines->scaler: ~A" (mus-scaler gen))))
    
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 440.0 5))
    (test-gen-equal (make-nsin 440.0 3) (make-nsin 440.0 3) (make-nsin 400.0 3))
    
    (let ((gen (make-nsin 440 5)))
      (do ((i 0 (+ 1 i)))
	  ((= i 1100))
	(let* ((val1 (* (sum-of-n-sines (mus-phase gen) 5) (mus-scaler gen)))
	       (val2 (gen 0.0)))
	  (if (fneq val1 val2)
	      (snd-display #__line__ ";nsin: ~A ~A" val1 val2)))))
    
    (let ((gen1 (make-nsin 100.0 10))
	  (gen2 (make-nsin -100.0 10))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";nsin +-: ~A" mx)))
    
    
    (let ((gen (make-nrxysin 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-nrxysin 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "nrxysin"
                       "nrxysin frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (nrxysin gen 0.0)))
      (vct-map! v1 (lambda () (if (nrxysin? gen1) (nrxysin gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nrxysin: ~A ~A" v0 v1))
      (if (not (nrxysin? gen)) (snd-display #__line__ ";~A not nrxysin?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nrxysin phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nrxysin frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (a) nrxysin: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display #__line__ ";mus-scaler (set a) nrxysin: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";mus-length nrxysin: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset nrxysin: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 100.0))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 1.5))
    (test-gen-equal (make-nrxysin 440.0) (make-nrxysin 440.0) (make-nrxysin 440.0 :n 3))
    
    (let ((v1 (make-vct 10)))
      (with-sound (:output v1 :srate 44100)
		  (let ((gen (make-nrxysin 1000 :n 10 :r .99)))
		    (do ((i 0 (+ 1 i)))
			((= i 10))
		      (outa i (nrxysin gen)))))
      (if (not (vequal v1 (vct 0.000 0.671 0.637 0.186 0.017 0.169 0.202 0.048 0.007 0.105)))
	  (snd-display #__line__ ";ws nrxysin output: ~A" v1)))
    
    
    (let ((gen (make-nrxycos 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-nrxycos 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "nrxycos"
                       "nrxycos frequency: 440.000, ratio: 1.000, phase: 0.000, n: 1, r: 0.500")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (nrxycos gen 0.0)))
      (vct-map! v1 (lambda () (if (nrxycos? gen1) (nrxycos gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map nrxycos: ~A ~A" v0 v1))
      (if (not (nrxycos? gen)) (snd-display #__line__ ";~A not nrxycos?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";nrxycos phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";nrxycos frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (a) nrxycos: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.75)
      (if (fneq (mus-scaler gen) 0.75) (snd-display #__line__ ";mus-scaler (set a) nrxycos: ~A" (mus-scaler gen)))
      (if (not (= (mus-length gen) 1)) (snd-display #__line__ ";mus-length nrxycos: ~A" (mus-length gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset nrxycos: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 100.0))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 1.5))
    (test-gen-equal (make-nrxycos 440.0) (make-nrxycos 440.0) (make-nrxycos 440.0 :n 3))
    
    (let ((v1 (with-sound (:output (make-vct 10) :srate 44100)
			  (let ((gen (make-nrxycos 1000 :n 10 :r .99)))
			    (do ((i 0 (+ 1 i)))
				((= i 10))
			      (outa i (nrxycos gen)))))))
      (if (not (vequal v1 (vct 1.000 0.602 -0.067 -0.242 -0.007 0.071 -0.087 -0.128 -0.007 0.012)))
	  (snd-display #__line__ ";ws nrxycos output: ~A" v1)))
    
    
    (let ((ind (new-sound "test.snd" mus-next mus-bfloat)))
      (pad-channel 0 1000)
      (let ((gen (make-cosine-summation 100.0)))
	(map-channel (lambda (y) (* .2 (cosine-summation gen 0.5))))
	(let ((vals (channel->vct 280 10)))
	  (if (not (vequal vals (vct 0.191 0.187 0.181 0.176 0.169 0.163 0.156 0.148 0.141 0.133)))
	      (snd-display #__line__ ";cosine-summation: ~A" vals)))
	(undo))
      
      (let ((gen (make-kosine-summation 100.0)))
	(map-channel (lambda (y) (* .2 (kosine-summation gen 0.5 1.0))))
	(let ((vals (channel->vct 280 10)))
	  (if (not (vequal vals (vct 0.194 0.191 0.188 0.184 0.180 0.175 0.170 0.166 0.160 0.155)))
	      (snd-display #__line__ ";kosine-summation 1: ~A" vals)))
	(undo))
      (let ((gen (make-kosine-summation 100.0)))
	(map-channel (lambda (y) (* .2 (kosine-summation gen 0.5 3.0))))
	(let ((vals (channel->vct 280 10)))
	  (if (not (vequal vals (vct 0.182 0.174 0.165 0.155 0.145 0.134 0.124 0.113 0.103 0.094)))
	      (snd-display #__line__ ";kosine-summation 3: ~A" vals)))
	(undo))
      
      (let ((angle 0.0)
	    (v (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v i (fejer-sum angle 3))
	  (set! angle (+ angle .1)))
	(if (not (vequal v (vct 1.000 0.988 0.951 0.892 0.815 0.723 0.622 0.516 0.412 0.313 0.225 0.150 0.089 0.045 0.017 0.003 0.000 0.007 0.020 0.035)))
	    (snd-display #__line__ ";fejer-sum: ~A" v)))
      
      (for-each
       (lambda (n)
	 (let ((mx 0.0)
	       (angle 0.0))
	   (do ((i 0 (+ 1 i)))
	       ((= i 300))
	     (set! mx (max mx (fejer-sum angle n)))
	     (set! angle (+ angle .01)))
	   (if (fneq mx 1.0) (snd-display #__line__ ";fejer-sum maxamp ~D: ~A" n mx))))
       (list 1 4 9 16 32 100))
      
      (let ((angle 0.0)
	    (v (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v i (poussin-sum angle 3))
	  (set! angle (+ angle .1)))
	(if (not (vequal v (vct 1.000 0.910 0.663 0.323 -0.024 -0.301 -0.458 -0.486 -0.411 -0.281 -0.147 -0.046 0.008 0.021 0.013 0.003 0.000 0.006 0.012 0.009)))
	    (snd-display #__line__ ";poussin-sum: ~A" v)))
      
      (for-each
       (lambda (n)
	 (let ((mx 0.0)
	       (angle 0.0))
	   (do ((i 0 (+ 1 i)))
	       ((= i 300))
	     (set! mx (max mx (poussin-sum angle n)))
	     (set! angle (+ angle .01)))
	   (if (fneq mx 1.0) (snd-display #__line__ ";poussin-sum maxamp ~D: ~A" n mx))))
       (list 1 4 9 16 32 100))
      
      (let ((angle 0.0)
	    (v (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v i (jackson-sum angle 3))
	  (set! angle (+ angle .1)))
	(if (not (vequal v (vct 1.000 0.975 0.904 0.796 0.664 0.523 0.386 0.266 0.170 0.098 0.051 0.022 0.008 0.002 0.000 0.000 0.000 0.000 0.000 0.001)))
	    (snd-display #__line__ ";jackson-sum: ~A" v)))
      
      (for-each
       (lambda (n)
	 (let ((mx 0.0)
	       (angle 0.0))
	   (do ((i 0 (+ 1 i)))
	       ((= i 300))
	     (set! mx (max mx (jackson-sum angle n)))
	     (set! angle (+ angle .01)))
	   (if (fneq mx 1.0) (snd-display #__line__ ";jackson-sum maxamp ~D: ~A" n mx))))
       (list 1 4 9 16 32 100))
      
      (let ((angle 0.0)
	    (v (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v i (legendre-sum angle 3))
	  (set! angle (+ angle .1)))
	(if (not (vequal v (vct 1.000 0.961 0.850 0.688 0.502 0.323 0.174 0.071 0.015 0.000 0.011 0.032 0.049 0.054 0.047 0.032 0.016 0.004 0.000 0.004)))
	    (snd-display #__line__ ";legendre-sum: ~A" v)))
      
      (for-each
       (lambda (n)
	 (let ((mx 0.0)
	       (angle 0.0))
	   (do ((i 0 (+ 1 i)))
	       ((= i 300))
	     (set! mx (max mx (legendre-sum angle n)))
	     (set! angle (+ angle .01)))
	   (if (fneq mx 1.0) (snd-display #__line__ ";legendre-sum maxamp ~D: ~A" n mx))))
       (list 1 4 9 16 32 100))
      
      
      (let ((angle 0.0)) 
	(map-channel (lambda (y) 
		       (let ((val (band-limited-sawtooth angle 0.5 8 .2))) 
			 (set! angle (+ angle .2)) 
			 val))))
      (let ((vals (channel->vct 10 10)))
	(if (not (vequal vals (vct -0.118 -0.073 -0.035 0.012 0.062 0.106 0.142 0.185 0.237 0.288)))
	    (snd-display #__line__ ";band-limited-sawtooth: ~A" vals)))
      (undo)
      
      (let ((angle 0.0)) 
	(map-channel (lambda (y) 
		       (let ((val (band-limited-square-wave angle 10))) 
			 (set! angle (+ angle .2)) 
			 val))))
      (let ((vals (channel->vct 10 10)))
	(if (not (vequal vals (vct 1.000 1.000 1.000 1.000 0.998 0.888 -0.525 -0.988 -1.000 -1.000)))
	    (snd-display #__line__ ";band-limited-square-wave: ~A" vals)))
      (undo)
      
      (let ((angle 0.0)) 
	(map-channel (lambda (y) (let ((val (sum-of-n-sines angle 3))) (set! angle (+ angle .1)) (* .1 val))))
	(let ((vals (channel->vct 260 10)))
	  (if (not (vequal vals (vct 0.226 0.200 0.166 0.129 0.091 0.056 0.025 0.001 -0.015 -0.023)))
	      (snd-display #__line__ ";sum-of-n-sines: ~A" vals)))
	(undo))
      (let ((angle 0.0)) 
	(map-channel (lambda (y) (let ((val (sum-of-n-odd-sines angle 3))) (set! angle (+ angle .1)) (* .1 val))))
	(let ((vals (channel->vct 260 10)))
	  (if (not (vequal vals (vct 0.035 0.007 0.000 0.014 0.039 0.069 0.091 0.100 0.092 0.070)))
	      (snd-display #__line__ ";sum-of-n-odd-sines: ~A" vals)))
	(undo))
      (let ((angle 0.0)) 
	(map-channel (lambda (y) (let ((val (sum-of-n-odd-cosines angle 3))) (set! angle (+ angle .1)) (* .1 val))))
	(let ((vals (channel->vct 250 10)))
	  (if (not (vequal vals (vct 0.270 0.298 0.292 0.253 0.189 0.112 0.037 -0.024 -0.061 -0.072)))
	      (snd-display #__line__ ";sum-of-n-odd-cosines: ~A" vals)))
	(undo))
      (close-sound ind))
    
    (let ((gen (make-asymmetric-fm 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-asymmetric-fm 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "asymmetric-fm"
		       "asymmetric-fm freq: 440.000Hz, phase: 0.000, ratio: 1.000, r: 1.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (asymmetric-fm gen 0.0)))
      (vct-map! v1 (lambda () (if (asymmetric-fm? gen1) (asymmetric-fm gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map asymmetric-fm: ~A ~A" v0 v1))
      (if (not (asymmetric-fm? gen)) (snd-display #__line__ ";~A not asymmetric-fm?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";asymmetric-fm phase: ~F?" (mus-phase gen)))
      (set! (mus-phase gen) 1.0)
      (if (fneq (mus-phase gen) 1.0) (snd-display #__line__ ";set! asymmetric-fm phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set! asymmetric-fm frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (vct-ref v0 2) 0.969) (fneq (vct-ref v0 8) .538)) (snd-display #__line__ ";asymmetric-fm output: ~A" v0))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";mus-scaler (r) asymmetric-fm: ~A" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";mus-scaler (set r) asymmetric-fm: ~A" (mus-scaler gen)))
      (if (fneq (mus-offset gen) 1.0) (snd-display #__line__ ";mus-offset asymmetric-fm: ~A" (mus-offset gen))))
    
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 100.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 1.0))
    (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 0.0 3))
    
    (let ((gen1 (make-asymmetric-fm 1000 0 1.0 0.1))
	  (gen2 (make-oscil 1000 :initial-phase (* 0.5 pi)))
	  (happy #t))
      (do ((i 0 (+ 1 i)))
	  ((or (not happy) (= i 100)))
	(let ((ss (asymmetric-fm gen1 0.0 0.0))
	      (os (oscil gen2 0.0)))
	  (if (fneq ss os)
	      (begin
		(snd-display #__line__ ";asymmetric-fm 1: ~A: os: ~A ss: ~A" i os ss)
		(set! happy #f))))))
    
    (for-each
     (lambda (index)
       (for-each
	(lambda (r)
	  (let ((peak (vct-peak (with-sound (:clipped #f :output (make-vct 1000))
					    (let ((gen (make-asymmetric-fm 2000.0 :ratio .1 :r r)))
					      (run 
					       (do ((i 0 (+ 1 i)))
						   ((= i 1000))
						 (outa i (asymmetric-fm gen index)))))))))
	    (if (> (abs (- peak 1.0)) .1)
		(snd-display #__line__ ";asymmetric-fm peak: ~A, index: ~A, r: ~A" peak index r))))
	(list -10.0 -1.5 -0.5 0.5 1.0 1.5 10.0)))
     (list 1.0 3.0 10.0))
    
    (let ((vct0 (make-vct 2048))
	  (vct1 (make-vct 2048))
	  (gen3 (make-asymmetric-fm 1000 0 1.0 0.2))
	  (gen4 (make-oscil 1000 (* 0.5 pi)))
	  (gen5 (make-oscil 200))
	  (fm1 (hz->radians (* 1.0 .2 1000)))) ; make notions of "index" match
      (do ((i 0 (+ 1 i)))
	  ((= i 2048))
	(vct-set! vct0 i (asymmetric-fm gen3 1.0 0.0))
	(vct-set! vct1 i (oscil gen4 (* fm1 (oscil gen5)))))
      (let* ((spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	     (spectr2 (snd-spectrum vct1 rectangular-window 2048 #t))
	     (happy #t))
	(do ((i 1 (+ 1 i)))
	    ((or (not happy)
		 (= i 512)))
	  (if (> (abs (- (vct-ref spectr1 i) (vct-ref spectr2 i))) .02)
	      (begin
		(snd-display #__line__ ";asymmetric-fm 2: ~A: ~A ~A" i (vct-ref spectr1 i) (vct-ref spectr2 i))
		(set! happy #f))))))
    
    (let ((gen (make-asymmetric-fm 40.0 0.0 1.0 0.1))
	  (gen1 (make-asyfm :frequency 40.0 :ratio .1 :index 2.0)))
      (do ((i 0 (+ 1 i))
	   (a 0.0 (+ a (/ (* 2 pi 40.0) (mus-srate))))) ;22050.0))))
	  ((= i 1100))
	(let* ((val1 (asymmetric-fm gen 2.0)) ; 1.0=index
	       (val3 (asyfm-J gen1 0.0))
	       (r 1.0)
	       (ratio 0.1)
	       (index 2.0)
	       ;; (freq (hz->radians 40.0))
	       ;; (phase a)
	       (cr (* 0.5 (- r (/ 1.0 r))))
	       (sr (* 0.5 (+ r (/ 1.0 r))))
	       (th a)
	       (mth (* ratio th))
	       (val2 (* (exp (* index cr (+ 1.0 (cos mth))))
			(cos (+ th (* index sr (sin mth)))))))
	  (if (or (fneq val1 val2)
		  (fneq val1 val3))
	      (snd-display #__line__ ";asyfm by hand: ~A: ~A ~A ~A" i val1 val2 val3)))))
    
    (let ((vct0 (make-vct 2048))
	  (vct1 (make-vct 2048))
	  (gen3 (make-asymmetric-fm 1000 0 2.0 0.1))
	  (gen4 (make-asymmetric-fm 1000 0 0.5 0.1)))
      (do ((i 0 (+ 1 i)))
	  ((= i 2048))
	(vct-set! vct0 i (asymmetric-fm gen3 2.0 0.0))
	(vct-set! vct1 i (asymmetric-fm gen4 2.0 0.0)))
      (let* ((spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	     (spectr2 (snd-spectrum vct1 rectangular-window 2048 #t))
	     (s1-loc 0)
	     (s2-loc 0))
	(do ((i 1 (+ 1 i)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (vct-ref spectr1 i))) .01) (set! s1-loc i))
	  (if (< (abs (- 1.0 (vct-ref spectr2 i))) .01) (set! s2-loc i)))
	(if (> s2-loc s1-loc) (snd-display #__line__ ";asymmetric-fm peaks: ~A ~A" s1-loc s2-loc))
	(let ((center (* (/ 22050 2048) (* .5 (+ s1-loc s2-loc)))))
	  (if (> (abs (- 1000 center)) 60) (snd-display #__line__ ";asymmetric-fm center: ~A" center)))
	(set! (mus-scaler gen3) 0.5)
	(do ((i 0 (+ 1 i)))
	    ((= i 2048))
	  (vct-set! vct0 i (asymmetric-fm gen3 2.0 0.0)))
	(set! spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	(do ((i 1 (+ 1 i)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (vct-ref spectr1 i))) .01) (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-print (format #f "asymmetric-fm set r peaks: ~A ~A" s1-loc s2-loc)))
	(do ((i 0 (+ 1 i)))
	    ((= i 2048))
	  (vct-set! vct0 i (asymmetric-fm gen3 2.0 0.0)))
	(snd-spectrum vct0 rectangular-window 2048 #t 0.0 #t)
	(do ((i 1 (+ 1 i)))
	    ((= i 256))
	  (if (< (abs (- 1.0 (vct-ref vct0 i))) .01) (set! s1-loc i)))
	(if (not (= s2-loc s1-loc)) (snd-print (format #f "asymmetric-fm set r in place peaks: ~A ~A" s1-loc s2-loc)))))
    
    (let ((gen (make-asyfm :frequency 2000 :ratio .1))) 
      (asyfm-I gen 0.0))
    
    (let ((gen (make-fir-filter 3 (list->vct '(.5 .25 .125))))
	  (v0 (make-vct 10))
	  (gen1 (make-fir-filter 3 (list->vct '(.5 .25 .125))))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "fir-filter"
		       "fir-filter order: 3, xs: [0.500 0.250 0.125]"
		       )
      (vct-set! v0 0 (fir-filter gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (fir-filter gen 0.0)))
      (vct-map! v1 (let ((inp 1.0))
		     (lambda () 
		       (let ((val (if (fir-filter? gen1) (fir-filter gen1 inp) -1.0)))
			 (set! inp 0.0)
			 val))))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map fir-filter: ~A ~A" v0 v1))
      (if (not (fir-filter? gen)) (snd-display #__line__ ";~A not fir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";fir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.25) (fneq (vct-ref v0 2) .125)) (snd-display #__line__ ";fir-filter output: ~A" v0))
      (let ((data (mus-xcoeffs gen)))
	(if (fneq (vct-ref data 1) .25) (snd-display #__line__ ";fir-filter xcoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";xcoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";fir ycoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 3 (list->vct '(.75 .25 .125))))) (fir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f1 1.0) f1)
		    (let ((f2 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f2 1.0) f2)
		    (let ((f3 (make-fir-filter 2 (list->vct '(.5 .25))))) (fir-filter f3 1.0) f3))
    
    (let* ((coeffs (list .1 .2 .3 .4 .4 .3 .2 .1))
	   (flt (make-fir-filter 8 (list->vct coeffs)))
	   (es (make-vector 8)))
      (do ((i 0 (+ 1 i)))
	  ((= i 8))
	(vector-set! es i (make-env (list 0 (list-ref coeffs i) 1 0) :length 102)))
      (vector-set! es 5 (make-env '(0 .4 1 1) :length 102))
      (let ((data (make-vct 100)))
	(do ((k 0 (+ 1 k)))
	    ((= k 100))
	  (let ((val (fir-filter flt (if (= (modulo k 12) 0) 1.0 0.0)))
		(xcof (mus-xcoeffs flt)))
	    (do ((i 0 (+ 1 i)))
		((= i 8))
	      (vct-set! xcof i (env (vector-ref es i))))
	    (vct-set! data k val)))
	(if (or (fneq (vct-ref data 1) .2)
		(fneq (vct-ref data 10) 0.0)
		(fneq (vct-ref data 18) 0.166)
		(fneq (vct-ref data 89) 0.923))
	    (snd-display #__line__ ";filter xcoeffs: ~A?" data))))
    
    (letrec ((make-f-filter (lambda (coeffs)
			      (list coeffs (make-vct (vct-length coeffs)))))
	     (f-filter (lambda (flt x)
			 (let* ((coeffs (car flt))
				(xs (cadr flt))
				(xlen (vct-length xs)))
			   (vct-move! xs (- xlen 1) (- xlen 2) #t)
			   (vct-set! xs 0 x)
			   (dot-product coeffs xs xlen)))))
      (let ((fir1 (make-fir-filter 3 (vct 1.0 0.4 0.1)))
	    (fir2 (make-f-filter (vct 1.0 0.4 0.1)))
	    (x 1.0)
	    (happy #t))
	(do ((i 0 (+ 1 i)))
	    ((or (not happy) (= i 10)))
	  (let ((val1 (fir-filter fir1 x))
		(val2 (f-filter fir2 x)))
	    (set! x 0.0)
	    (if (fneq val1 val2)
		(begin
		  (snd-display #__line__ ";f-filter ~A -> ~A ~A" i val1 val2)
		  (set! happy #f)))))))
    
    (let ((gen (make-spencer-filter)))
      (if (not (fir-filter? gen)) 
	  (snd-display #__line__ ";make-spencer-filter returns ~A?" gen)
	  (begin
	    (if (not (= (mus-order gen) 15)) (snd-display #__line__ ";make-spencer-filter order ~A?" (mus-order gen)))
	    (if (not (vequal (mus-xcoeffs gen) (vct -0.009 -0.019 -0.016 0.009 0.066 0.144 0.209 0.231 0.209 0.144 0.066 0.009 -0.016 -0.019 -0.009)))
		(snd-display #__line__ ";make-spencer-filter coeffs: ~A" (mus-xcoeffs gen))))))
    
    (let ((flt (make-savitzky-golay-filter 5 2)))
      (if (not (vequal (mus-xcoeffs flt) (vct -0.086 0.343 0.486 0.343 -0.086)))
	  (snd-display #__line__ ";sg 5 2: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 11 2)))
      (if (not (vequal (mus-xcoeffs flt) (vct -0.084 0.021 0.103 0.161 0.196 0.207 0.196 0.161 0.103 0.021 -0.084)))
	  (snd-display #__line__ ";sg 11 2: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 11 4)))
      (if (not (vequal (mus-xcoeffs flt) (vct 0.042 -0.105 -0.023 0.140 0.280 0.333 0.280 0.140 -0.023 -0.105 0.042)))
	  (snd-display #__line__ ";sg 11 4: ~A" (mus-xcoeffs flt))))
    (let ((flt (make-savitzky-golay-filter 25 2)))
      (if (not (vequal (mus-xcoeffs flt) (vct -0.049 -0.027 -0.006 0.012 0.028 0.043 0.055 0.066 0.075 0.082 0.086 
					      0.089 0.090 0.089 0.086 0.082 0.075 0.066 0.055 0.043 
					      0.028 0.012 -0.006 -0.027 -0.049)))
	  (snd-display #__line__ ";sg 25 2: ~A" (mus-xcoeffs flt))))
    
    (let ((gen (make-iir-filter 3 (list->vct '(.5 .25 .125))))
	  (v0 (make-vct 10))
	  (gen1 (make-iir-filter 3 (list->vct '(.5 .25 .125))))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "iir-filter"
		       "iir-filter order: 3, ys: [0.500 0.250 0.125]"
		       )
      (vct-set! v0 0 (iir-filter gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (iir-filter gen 0.0)))
      (vct-map! v1 (let ((inp 1.0))
		     (lambda ()
		       (let ((val (if (iir-filter? gen1) (iir-filter gen1 inp) -1.0)))
			 (set! inp 0.0)
			 val))))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map iir-filter: ~A ~A" v0 v1))
      (if (not (iir-filter? gen)) (snd-display #__line__ ";~A not iir-filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";iir-filter length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) -0.25) (fneq (vct-ref v0 2) -.062)) (snd-display #__line__ ";iir-filter output: ~A" v0))
      (let ((data (mus-ycoeffs gen)))
	(if (fneq (vct-ref data 1) .25) (snd-display #__line__ ";iir-filter ycoeffs: ~A?" data)))
      (let ((tag (catch #t (lambda () (mus-ycoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";ycoeff 123: ~A" tag)))
      (let ((tag (catch #t (lambda () (mus-xcoeff gen 123)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error))
	    (snd-display #__line__ ";iir xcoeff 123: ~A" tag))))
    
    (test-gen-equal (let ((f1 (make-iir-filter 3 (list->vct '(.5 .25 .125))))) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 3 (list->vct '(.75 .25 .125))))) (iir-filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f1 1.0) f1)
		    (let ((f2 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f2 1.0) f2)
		    (let ((f3 (make-iir-filter 2 (list->vct '(.5 .25))))) (iir-filter f3 1.0) f3))
    
    (let ((gen (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))
	  (v0 (make-vct 10))
	  (gen1 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))
	  (v1 (make-vct 10))
	  (gen2 (make-biquad .1 .2 .3 .4 .5)))
      (print-and-check gen 
		       "filter"
		       "filter order: 3, xs: [0.500 0.250 0.125], ys: [0.500 0.250 0.125]"
		       )
      (vct-set! v0 0 (filter gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (filter gen 0.0)))
      (vct-map! v1 (let ((inp 1.0))
		     (lambda () 
		       (let ((val (if (filter? gen1) (filter gen1 inp) -1.0)))
			 (set! inp 0.0)
			 val))))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map filter: ~A ~A" v0 v1))
      (if (not (filter? gen)) (snd-display #__line__ ";~A not filter?" gen))
      (if (not (= (mus-length gen) 3)) (snd-display #__line__ ";filter length: ~D?" (mus-length gen)))
      (if (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 2) .031)) (snd-display #__line__ ";filter output: ~A" v0))
      (if (not (filter? gen2)) (snd-display #__line__ ";make-biquad: ~A" gen2))
      (let ((xs (mus-xcoeffs gen))
	    (ys (mus-ycoeffs gen)))
	(if (or (not (equal? xs (list->vct '(.5 .25 .125))))
		(not (equal? xs ys)))
	    (snd-display #__line__ ";mus-xcoeffs: ~A ~A?" xs ys))))
    
    (let ((var (catch #t (lambda () (make-filter :order 2 :xcoeffs (vct 1.0 0.5) :ycoeffs (vct 2.0 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-filter :order 0 :xcoeffs (vct 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-filter bad order: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter :order 22 :xcoeffs (vct 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-fir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-iir-filter :order 22 :ycoeffs (vct 1.0 0.5))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-iir-filter bad coeffs: ~A" var)))
    (let ((var (catch #t (lambda () (make-fir-filter -1)) (lambda args args))))
      (if (not (eq? (car var) 'out-of-range))
	  (snd-display #__line__ ";make-fir-filter bad order: ~A" var)))
    (let ((var (make-filter :order 2 :ycoeffs (vct 1.0 0.5))))
      (if (not (iir-filter? var))
	  (snd-display #__line__ ";make-filter with only y: ~A" var)))
    
    (test-gen-equal (let ((f1 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .5 .5))))) (filter f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f1 1.0) f1)
		    (let ((f2 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f2 1.0) f2)
		    (let ((f3 (make-filter 3 (list->vct '(.5 .5 .125)) (list->vct '(.5 .25 .0625))))) (filter f3 1.0) f3))
    
    (let ((fr (make-fir-filter 6 (vct 0 1 2 3 4 5))))
      (if (not (= (mus-length fr) 6)) (snd-display #__line__ ";filter-length: ~A" (mus-length fr))))
    
    (let ((val (cascade->canonical (list (vct 1.0 0.0 0.0) (vct 1.0 0.5 0.25)))))
      (if (not (vequal val (vct 1.000 0.500 0.250 0.000 0.000)))
	  (snd-display #__line__ ";cas2can 0: ~A" val)))
    (let ((val (cascade->canonical (list (vct 1.0 1.0 0.0) (vct 1.0 0.5 0.25)))))
      (if (not (vequal val (vct 1.000 1.500 0.750 0.250 0.000)))
	  (snd-display #__line__ ";cas2can 1: ~A" val)))
    
    (let ((val (cascade->canonical (list (vct 1 0.8 0) (vct 1 1.4 0.65) (vct 1 0 0)))))
      (if (not (vequal val (vct 1.000 2.200 1.770 0.520 0.000 0.000 0.000)))
	  (snd-display #__line__ ";cascade->canonical: ~A" val)))
    (let ((val (cascade->canonical (list (vct 1 -0.9 0) (vct 1 1 0.74) (vct 1 -1.6 0.8)))))
      (if (not (vequal val (vct 1.000 -1.500 0.480 -0.330 0.938 -0.533 0.000)))
	  (snd-display #__line__ ";cascade->canonical 1: ~A" val)))
    
    (let ((ind (new-sound "test.snd" mus-next mus-bfloat 22050)))
      (pad-channel 0 10000)
      (freq-sweep .45)
      (let ((sp (rough-spectrum ind)))
	(if (and (not (vequal sp (vct 0.962 0.998 0.998 0.998 0.998 0.999 0.999 0.998 0.997 1.000)))
		 (not (vequal sp (vct 0.963 0.999 0.999 0.999 0.999 0.999 1.000 1.000 0.998 0.997))))
	    (snd-display #__line__ ";initial rough spectrum: ~A" sp)))
      
      (let ((b (make-butter-high-pass 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	    (snd-display #__line__ ";butter high: ~A" v))
	(set! b (make-butter-high-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000)))
		   (not (vequal sp (vct 0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display #__line__ ";hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-low-pass 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	    (snd-display #__line__ ";butter low: ~A" v))
	(set! b (make-butter-low-pass 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-pass 440.0 50.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.007 0.014 0.013 0.013 0.012 0.011 0.009 0.008 0.007 0.005)))
	    (snd-display #__line__ ";butter bandpass: ~A" v))
	(set! b (make-butter-band-pass 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 0.888 1.000 0.144 0.056 0.027 0.014 0.008 0.004 0.002 0.000)))
	      (snd-display #__line__ ";bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-band-reject 440.0 50.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.993 -0.014 -0.013 -0.013 -0.012 -0.011 -0.009 -0.008 -0.007 -0.005)))
	    (snd-display #__line__ ";butter bandstop: ~A" v))
	(set! b (make-butter-band-reject 1000.0 500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.662 0.687 0.953 0.980 0.989 0.994 0.997 0.997 0.997 1.000)))
		   (not (vequal sp (vct 0.664 0.689 0.955 0.982 0.992 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display #__line__ ";bs rough spectrum: ~A" sp)))
	(undo))
      
      (if (defined? 'gsl-roots) (analog-filter-tests))
      (test-lpc)
      (test-unclip-channel)
      
      (let ((v (spectrum->coeffs 10 (vct 0 1.0 0 0 0 0 0 0 1.0 0)))
	    (v1 (make-fir-coeffs 10 (vct 0 1.0 0 0 0 0 0 0 1.0 0))))
	(if (not (vequal v (vct -0.190 -0.118 0.000 0.118 0.190 0.190 0.118 0.000 -0.118 -0.190)))
	    (snd-display #__line__ ";spectrum->coeffs: ~A" v))
	(if (not (vequal v v1))
	    (snd-display #__line__ ";spectrum->coeffs v make-fir-coeffs: ~A ~A" v v1)))
      
      (let ((notched-spectr (make-vct 20)))
	(vct-set! notched-spectr 2 1.0) 
	(let ((v (spectrum->coeffs 20 notched-spectr))
	      (v1 (make-fir-coeffs 20 notched-spectr)))
	  (if (not (vequal v (vct 0.095 0.059 -0.000 -0.059 -0.095 -0.095 -0.059 0.000 0.059 0.095 
				  0.095 0.059 0.000 -0.059 -0.095 -0.095 -0.059 -0.000 0.059 0.095)))
	      (snd-display #__line__ ";spectrum->coeffs (notch): ~A" v))
	  (if (not (vequal v v1))
	      (snd-display #__line__ ";spectrum->coeffs v(2) make-fir-coeffs: ~A ~A" v v1))
	  (let ((flt (make-fir-filter 20 v)))
	    (map-channel (lambda (y) (fir-filter flt y)))))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 0.007 0.493 1.000 0.068 0.030 0.019 0.014 0.011 0.009 0.009)))
	      (snd-display #__line__ ";sp->coeff rough spectrum: ~A" sp)))
	(undo))
      
      (let ((rspect (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! rspect i (random 1.0)))
	(let ((v (spectrum->coeffs 20 rspect))
	      (v1 (make-fir-coeffs 20 rspect)))
	  (if (not (vequal v v1))
	      (snd-display #__line__ ";spectrum->coeffs v(3) make-fir-coeffs: ~A ~A" v v1))))
      
      (let ((b (make-highpass (hz->radians 1000.0) 10))
	    (v (make-vct 20))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (fir-filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct -0.001 -0.002 -0.005 -0.011 -0.021 -0.034 -0.049 -0.065 -0.078 -0.087 
				0.909 -0.087 -0.078 -0.065 -0.049 -0.034 -0.021 -0.011 -0.005 -0.002)))
	    (snd-display #__line__ ";dsp.scm high: ~A" v))
	(set! b (make-highpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.053 0.774 0.998 0.997 0.997 0.996 0.996 0.996 0.997 1.000)))
		   (not (vequal sp (vct 0.053 0.776 1.000 0.998 0.998 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display #__line__ ";dsp hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-lowpass (hz->radians 1000.0) 10))
	    (v (make-vct 20))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (fir-filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.001 0.002 0.005 0.011 0.021 0.034 0.049 0.065 0.078 0.087 0.091 0.087 0.078 0.065
				0.049 0.034 0.021 0.011 0.005 0.002)))
	    (snd-display #__line__ ";dsp.scm low: ~A" v))
	(set! b (make-lowpass (hz->radians 1000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 1.000 0.054 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";dsp lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 10))
	    (v (make-vct 20))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (fir-filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.001 -0.001 -0.005 -0.011 -0.017 -0.019 -0.013 0.003 0.022 0.039 0.045
				0.039 0.022 0.003 -0.013 -0.019 -0.017 -0.011 -0.005 -0.001)))
	    (snd-display #__line__ ";dsp.scm bp: ~A" v))
	(set! b (make-bandpass (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 0.010 1.000 0.154 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";dsp bp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 10))
	    (v (make-vct 20))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (fir-filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct -0.001 0.001 0.005 0.011 0.017 0.019 0.013 -0.003 -0.022 -0.039 0.955
				-0.039 -0.022 -0.003 0.013 0.019 0.017 0.011 0.005 0.001)))
	    (snd-display #__line__ ";dsp.scm bs: ~A" v))
	(set! b (make-bandstop (hz->radians 1500.0) (hz->radians 2000.0) 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.904 0.425 0.821 0.998 0.997 0.996 0.996 0.996 0.997 1.000)))
		   (not (vequal sp (vct 0.906 0.425 0.822 1.000 0.999 0.998 0.998 0.998 0.998 1.000))))
	      (snd-display #__line__ ";dsp bs rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-differentiator 10))
	    (v (make-vct 20))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (fir-filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct -0.008 0.011 -0.021 0.039 -0.066 0.108 -0.171 0.270 -0.456 0.977
				0.000 -0.977 0.456 -0.270 0.171 -0.108 0.066 -0.039 0.021 -0.011)))
	    (snd-display #__line__ ";dsp.scm df: ~A" v))
	(set! b (make-differentiator 20))
	(map-channel (lambda (y) (fir-filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 0.004 0.027 0.075 0.147 0.242 0.362 0.506 0.674 0.864 1.000)))
	      (snd-display #__line__ ";dsp df rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-high-pass-2 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.915 -0.162 -0.146 -0.131 -0.117 -0.103 -0.090 -0.078 -0.066 -0.056)))
	    (snd-display #__line__ ";iir-2 high: ~A" v))
	(set! b (make-iir-high-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.150 0.833 0.980 0.994 0.997 0.998 0.999 0.998 0.997 1.000)))
		   (not (vequal sp (vct 0.150 0.833 0.981 0.995 0.998 0.999 1.000 1.000 0.998 0.997))))
	      (snd-display #__line__ ";iir-2 hp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-low-pass-2 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (butter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.004 0.014 0.026 0.035 0.043 0.049 0.053 0.055 0.057 0.057)))
	    (snd-display #__line__ ";iir-2 low: ~A" v))
	(set! b (make-iir-low-pass-2 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 1.000 0.212 0.024 0.005 0.001 0.000 0.000 0.000 0.000 0.000)))
	      (snd-display #__line__ ";iir-2 lp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-pass-2 440.0 490.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.007 0.014 0.013 0.013 0.012 0.010 0.009 0.008 0.006 0.004)))
	    (snd-display #__line__ ";iir bp-2 bandpass: ~A" v))
	(set! b (make-iir-band-pass-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (not (vequal sp (vct 0.239 1.000 0.117 0.041 0.019 0.010 0.005 0.003 0.001 0.000)))
	      (snd-display #__line__ ";iir bp-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-iir-band-stop-2 440.0 500.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.992 -0.017 -0.016 -0.015 -0.014 -0.012 -0.011 -0.009 -0.007 -0.005)))
	    (snd-display #__line__ ";iir-2 bandstop: ~A" v))
	(set! b (make-iir-band-stop-2 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.836 0.525 0.943 0.979 0.989 0.994 0.997 0.997 0.997 1.000)))
		   (not (vequal sp (vct 0.838 0.527 0.945 0.981 0.991 0.996 0.999 1.000 0.999 0.998))))
	      (snd-display #__line__ ";iir bs-2 rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-hp 4 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (and (not (vequal v (vct 0.725 -0.466 -0.315 -0.196 -0.104 -0.036 0.014 0.047 0.0685 0.0775)))
		 (not (vequal v (vct 0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.015 0.049 0.070 0.081)))
		 (not (vequal v (vct 0.725 -0.466 -0.315 -0.196 -0.104 -0.035 0.014 0.049 0.069 0.079))))
	    (snd-display #__line__ ";butter hp: ~A" v))
	(set! b (make-butter-hp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 0.0505 0.982 1.000 1.000 0.998 0.998 0.999 0.998 0.996 0.999)))
		   (not (vequal sp (vct 0.051 0.982 1.000 1.000 0.998 0.998 0.998 0.999 0.997 0.995)))
		   (not (vequal sp (vct 0.051 0.991 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995)))
		   (not (vequal sp (vct 0.045 0.970 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995)))
		   (not (vequal sp (vct 0.052 0.971 1.000 1.000 0.998 0.998 0.999 0.999 0.997 0.995))))
	      (snd-display #__line__ ";bhp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-lp 4 440.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))) ;; ???
	    (snd-display #__line__ ";butter lp: ~A" v))
	(set! b (make-butter-lp 4 1000.0))
	(map-channel (lambda (y) (filter b y)))
	(let ((sp (rough-spectrum ind)))
	  (if (and (not (vequal sp (vct 1.000 0.035 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
		   (not (vequal sp (vct 1.000 0.038 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	      (snd-display #__line__ ";blp rough spectrum: ~A" sp)))
	(undo))
      
      (let ((b (make-butter-bp 4 440.0 500.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (not (vequal v (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	    (snd-display #__line__ ";butter bp: ~A" v))
	(set! b (make-butter-bp 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (let ((b (make-butter-bs 4 440.0 500.0))
	    (v (make-vct 10))
	    (inv 1.0))
	(vct-map! v (lambda () (let ((val (filter b inv))) (set! inv 0.0) val)))
	(if (and (not (vequal v (vct 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.026 -0.0225 -0.015 -0.0085)))
		 (not (vequal v (vct 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.022 -0.017 -0.011)))
		 (not (vequal v (vct 0.978 -0.043 -0.041 -0.038 -0.035 -0.031 -0.027 -0.021 -0.014 -0.011))))
	    (snd-display #__line__ ";butter bs: ~A" v))
	(set! b (make-butter-bs 4 1000.0 1500.0))
	(map-channel (lambda (y) (filter b y)))
	(undo))
      
      (revert-sound)
      (test-scanned-synthesis .1 10000 1.0 0.1 0.0)
      
      (close-sound ind))
    
    (let ((gen (make-sawtooth-wave 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-sawtooth-wave 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "sawtooth-wave"
		       "sawtooth-wave freq: 440.000Hz, phase: 3.142, amp: 1.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (sawtooth-wave gen 0.0)))
      (vct-map! v1 (lambda () (if (sawtooth-wave? gen1) (sawtooth-wave gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map sawtooth: ~A ~A" v0 v1))
      (if (not (sawtooth-wave? gen)) (snd-display #__line__ ";~A not sawtooth-wave?" gen))
      (if (fneq (mus-phase gen) 4.39538) (snd-display #__line__ ";sawtooth-wave phase: ~F?" (mus-phase gen))) ;starts at pi
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";sawtooth-wave frequency: ~F?" (mus-frequency gen)))
      (set! (mus-frequency gen) 100.0)
      (if (fneq (mus-frequency gen) 100.0) (snd-display #__line__ ";set! sawtooth-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";sawtooth-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! sawtooth-wave scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (vct-ref v0 1) 0.04) (fneq (vct-ref v0 8) .319)) (snd-display #__line__ ";sawtooth-wave output: ~A" v0)))
    
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 120.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 1.0 1.0))
    (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 0.5))
    
    (let ((gen1 (make-sawtooth-wave 100.0))
	  (gen2 (make-sawtooth-wave -100.0))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";sawtooth +-: ~A" mx)))
    
    (let ((gen (make-square-wave 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-square-wave 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "square-wave"
		       "square-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (square-wave gen 0.0)))
      (let ((w 1.0))
	(vct-map! v1 (lambda () 
		       (set! w (mus-width gen1))
		       (if (square-wave? gen1) (square-wave gen1 0.0) -1.0)))
	(if (fneq w 0.5) (snd-display #__line__ ";mus-width opt: ~A" w)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map square-wave: ~A ~A" v0 v1))
      (if (not (square-wave? gen)) (snd-display #__line__ ";~A not square-wave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";square-wave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";square-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";square-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! square-wave scaler: ~F?" (mus-scaler gen)))
      (if (fneq (mus-width gen) 0.5) (snd-display #__line__ ";square-wave width: ~A" (mus-width gen)))
      (set! (mus-width gen) 0.75)
      (if (fneq (mus-width gen) 0.75) (snd-display #__line__ ";set! square-wave width: ~A" (mus-width gen)))
      (if (or (fneq (vct-ref v0 1) 1.0) (fneq (vct-ref v0 8) 1.0)) (snd-display #__line__ ";square-wave output: ~A" v0)))
    
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 120.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 1.0 1.0))
    (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 0.5))
    
    (let ((old-srate (mus-srate)))
      (set! (mus-srate) 500.0)
      (let ((gen (make-square-wave 100.0 -0.5 (* pi 0.5)))
	    (v0 (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v0 i (gen)))
	(if (not (vequal v0 (vct -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5 -0.5 -0.5 0.0 0.0 -0.5)))
	    (snd-display #__line__ ";square-wave -.5: ~A " v0)))
      (set! (mus-srate) old-srate))
    
    (let ((gen (make-triangle-wave 440.0))
	  (gen1 (make-triangle-wave 440.0 1.0 pi))
	  (v0 (make-vct 10))
	  (gen2 (make-triangle-wave 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "triangle-wave"
		       "triangle-wave freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (triangle-wave gen 0.0)))
      (vct-map! v1 (lambda () (if (triangle-wave? gen2) (triangle-wave gen2 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map triangle-wave: ~A ~A" v0 v1))
      (if (not (triangle-wave? gen)) (snd-display #__line__ ";~A not triangle-wave?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";triangle-wave phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-phase gen1) pi) (snd-display #__line__ ";init triangle-wave phase: ~F?" (mus-phase gen1)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";triangle-wave frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";triangle-wave scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! triangle-wave scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (vct-ref v0 1) 0.080) (fneq (vct-ref v0 8) 0.639)) (snd-display #__line__ ";triangle-wave output: ~A" v0)))
    
    (let ((gen1 (make-triangle-wave 100.0))
	  (gen2 (make-triangle-wave -100.0))
	  (mx 0.0))
      (do ((i 0 (+ 1 i)))
	  ((= i 100))
	(set! mx (max mx (abs (+ (gen1) (gen2))))))
      (if (fneq mx 0.0)
	  (snd-display #__line__ ";triangle +-: ~A" mx)))
    
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 120.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 1.0 1.0))
    (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 0.5))
    
    (let ((gen (make-pulse-train 440.0))
	  (v0 (make-vct 10))
	  (gen1 (make-pulse-train 440.0))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "pulse-train"
		       "pulse-train freq: 440.000Hz, phase: 0.000, amp: 1.000")
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (pulse-train gen 0.0)))
      (vct-map! v1 (lambda () (if (pulse-train? gen1) (pulse-train gen1 0.0) -1.0)))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map pulse-train: ~A ~A" v0 v1))
      (if (not (pulse-train? gen)) (snd-display #__line__ ";~A not pulse-train?" gen))
      (if (fneq (mus-phase gen) 1.253787) (snd-display #__line__ ";pulse-train phase: ~F?" (mus-phase gen)))
      (if (fneq (mus-frequency gen) 440.0) (snd-display #__line__ ";pulse-train frequency: ~F?" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 1.0) (snd-display #__line__ ";pulse-train scaler: ~F?" (mus-scaler gen)))
      (set! (mus-scaler gen) 0.5)
      (if (fneq (mus-scaler gen) 0.5) (snd-display #__line__ ";set! pulse-train scaler: ~F?" (mus-scaler gen)))
      (if (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 8) 0.0)) (snd-display #__line__ ";pulse-train output: ~A" v0)))
    
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 120.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 1.0 1.0))
    (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 0.5))
    
    (let ((old-srate (mus-srate)))
      (set! (mus-srate) 500.0)
      (let ((gen (make-pulse-train 100.0 -0.5 (* pi 0.5)))
	    (v0 (make-vct 20)))
	(do ((i 0 (+ 1 i)))
	    ((= i 20))
	  (vct-set! v0 i (gen)))
	(if (not (vequal v0 (vct  0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5 0.0 0.0 0.0 0.0 -0.5)))
	    (snd-display #__line__ ";pulse-train -.5: ~A " v0)))
      (set! (mus-srate) old-srate))
    
    
    (let ((gen (make-ppolar .1 1200.0))
	  (v0 (make-vct 10)))
      (vct-set! v0 0 (two-pole gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (two-pole gen 0.0)))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not ppolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";ppolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";ppolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-b1 gen) -.188) (snd-display #__line__ ";ppolar b1: ~F?" (mus-b1 gen)))
      (if (fneq (mus-b2 gen) .01) (snd-display #__line__ ";ppolar b2: ~F?" (mus-b2 gen)))
      (if (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) .188)) (snd-display #__line__ ";ppolar output: ~A" v0))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq ppolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler ppolar: ~A" (mus-scaler gen))))
    
    (test-gen-equal (let ((z1 (make-ppolar .1 600.0))) (two-pole z1 1.0) z1)
		    (let ((z2 (make-ppolar .1 600.0))) (two-pole z2 1.0) z2)
		    (let ((z3 (make-ppolar .1 1200.0))) (two-pole z3 1.0) z3))
    (test-gen-equal (let ((z1 (make-ppolar :radius .1 :frequency 600.0))) (two-pole z1 1.0) z1)
		    (let ((z2 (make-ppolar :radius .1 :frequency 600.0))) (two-pole z2 1.0) z2)
		    (let ((z3 (make-ppolar :radius .2 :frequency 1200.0))) (two-pole z3 1.0) z3))
    (test-gen-equal (let ((z1 (make-ppolar .1 600.0))) (two-pole z1 1.0) z1)
		    (let ((z2 (make-ppolar .1 600.0))) (two-pole z2 1.0) z2)
		    (let ((z3 (make-ppolar .1 600.0))) (two-pole z3 0.5) z3))
    
    (let ((gen (make-two-pole 1200.0 .1)))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not 2ppolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";2ppolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";2ppolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-b1 gen) -.188) (snd-display #__line__ ";2ppolar b1: ~F?" (mus-b1 gen)))
      (if (fneq (mus-b2 gen) .01) (snd-display #__line__ ";2ppolar b2: ~F?" (mus-b2 gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq 2ppolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler 2ppolar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-pole :frequency 1200.0 :radius .1)))
      (if (not (two-pole? gen)) (snd-display #__line__ ";~A not f2ppolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";f2ppolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";f2ppolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-b1 gen) -.188) (snd-display #__line__ ";f2ppolar b1: ~F?" (mus-b1 gen)))
      (if (fneq (mus-b2 gen) .01) (snd-display #__line__ ";f2ppolar b2: ~F?" (mus-b2 gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq f2ppolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler f2ppolar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-zpolar :radius .1 :frequency 1200.0))
	  (v0 (make-vct 10)))
      (vct-set! v0 0 (two-zero gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (two-zero gen 0.0)))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not zpolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";zpolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";zpolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-a1 gen) -.188) (snd-display #__line__ ";zpolar a1: ~F?" (mus-a1 gen)))
      (if (fneq (mus-a2 gen) .01) (snd-display #__line__ ";zpolar a2: ~F?" (mus-a2 gen)))
      (if (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) -.188)) (snd-display #__line__ ";zpolar output: ~A" v0))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq zpolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler zpolar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero :radius .1 :frequency 1200.0)))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not 2zpolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";2zpolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";2zpolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-a1 gen) -.188) (snd-display #__line__ ";2zpolar a1: ~F?" (mus-a1 gen)))
      (if (fneq (mus-a2 gen) .01) (snd-display #__line__ ";2zpolar a2: ~F?" (mus-a2 gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq 2zpolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler 2zpolar: ~A" (mus-scaler gen))))
    
    (let ((gen (make-two-zero 1200.0 .1)))
      (if (not (two-zero? gen)) (snd-display #__line__ ";~A not f2zpolar?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";f2zpolar order: ~D?" (mus-order gen)))
      (if (fneq (mus-a0 gen) 1.0) (snd-display #__line__ ";f2zpolar a0: ~F?" (mus-a0 gen)))
      (if (fneq (mus-a1 gen) -.188) (snd-display #__line__ ";f2zpolar a1: ~F?" (mus-a1 gen)))
      (if (fneq (mus-a2 gen) .01) (snd-display #__line__ ";f2zpolar a2: ~F?" (mus-a2 gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";freq f2zpolar: ~A" (mus-frequency gen)))
      (if (fneq (mus-scaler gen) 0.1) (snd-display #__line__ ";scaler f2zpolar: ~A" (mus-scaler gen))))
    
    (test-gen-equal (let ((z1 (make-zpolar .1 600.0))) (two-zero z1 1.0) z1)
		    (let ((z2 (make-zpolar .1 600.0))) (two-zero z2 1.0) z2)
		    (let ((z3 (make-zpolar .1 1200.0))) (two-zero z3 1.0) z3))
    (test-gen-equal (let ((z1 (make-zpolar :radius .1 :frequency 600.0))) (two-zero z1 1.0) z1)
		    (let ((z2 (make-zpolar :radius .1 :frequency 600.0))) (two-zero z2 1.0) z2)
		    (let ((z3 (make-zpolar :radius .2 :frequency 1200.0))) (two-zero z3 1.0) z3))
    (test-gen-equal (let ((z1 (make-zpolar .1 600.0))) (two-zero z1 1.0) z1)
		    (let ((z2 (make-zpolar .1 600.0))) (two-zero z2 1.0) z2)
		    (let ((z3 (make-zpolar .1 600.0))) (two-zero z3 0.5) z3))
    
    (let ((gen (make-formant 1200.0 0.9))
	  (v0 (make-vct 10))
	  (gen1 (make-formant 1200.0 0.9))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "formant"
		       "formant frequency: 1200.000, radius: 0.900")
      (vct-set! v0 0 (formant gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (formant gen 0.0)))
      (vct-map! v1 (let ((inp 1.0))
		     (lambda () 
		       (let ((val (if (formant? gen1) (formant gen1 inp) -1.0)))
			 (set! inp 0.0)
			 val))))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map formant: ~A ~A" v0 v1))
      (if (not (formant? gen)) (snd-display #__line__ ";~A not formant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";formant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";formant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (vct-ref v0 0) .095) (fneq (vct-ref v0 1) .161)) (snd-display #__line__ ";formant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display #__line__ ";formant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) 2.0)
      (if (fneq (mus-scaler gen) 2.0) (snd-display #__line__ ";formant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 600.0 0.9))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.99))) (formant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-formant 1200.0 0.9))) (formant f1 1.0) f1)
		    (let ((f2 (make-formant 1200.0 0.9))) (formant f2 1.0) f2)
		    (let ((f3 (make-formant 1200.0 0.5))) (formant f3 1.0) f3))
    
    (let ((fs (make-vector 2))
	  (f0 (make-formant 1000.0 .1))
	  (f1 (make-formant 100.0 .2))
	  (amps (make-vct 2 1.0))
	  (val 1.0)
	  (v0 (make-vct 10))
	  (v1 (make-vct 10)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (do ((i 0 (+ 1 i)))
	  ((= i 10))
	(set! (v0 i) (+ (* 0.5 (formant f0 val)) (* 0.25 (formant f1 val))))
	(set! (v1 i) (formant-bank amps fs val))
	(set! val 0.0))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";formant bank 1: ~A ~A" v0 v1)))
    
    (let ((fs (make-vector 2))
	  (amps (make-vct 2 1.0))
	  (val 1.0)
	  (v (make-vct 5)))
      (set! (fs 0) (make-formant 1000.0 .1))
      (set! (fs 1) (make-formant 100.0 .2))
      (set! (amps 0) 0.5)
      (set! (amps 1) 0.25)
      (vct-map! v (lambda () (let ((res (formant-bank amps fs val))) (set! val 0.0) res)))
      (if (not (vequal v (vct 0.368 0.095 -0.346 -0.091 -0.020))) (snd-display #__line__ ";run formant-bank: ~A" v)))
    
    (let ((fs (make-vector 1))
	  (amps (make-vct 1 1.0)))
      (vector-set! fs 0 (make-oscil 440.0))
      (let ((tag (catch #t
			(lambda () (formant-bank amps fs 1.0))
			(lambda args (car args)))))
	(if (not (equal? tag 'wrong-type-arg)) (snd-display #__line__ ";formant-bank gets oscil: ~A" tag))))
    
    (let ((ob (open-sound "oboe.snd")))
      (define (poltergeist frek amp R gain frek-env R-env)
	;; test courtesy of Anders Vinjar
	(let ((filt (make-formant frek R))
	      (fe (make-env :envelope frek-env :length (frames) :offset frek))
	      (re (make-env :envelope R-env :length (frames) :offset R)))
	  (lambda (y)
	    (let ((outval (* gain (formant filt (* amp y)))))
	      (mus-set-formant-radius-and-frequency filt (env re) (env fe))
	      outval))))
      (map-chan (poltergeist 300 0.1 0.0 30.0 '(0 100 1 4000.0) '(0 0.99 1 .9)))  ;; should sound like "whyieee?"
      (play ob :wait #t)
      (close-sound ob))
    
    (let ((gen (make-firmant 1200.0 0.9))
	  (v0 (make-vct 10))
	  (gen1 (make-firmant 1200.0 0.9))
	  (v1 (make-vct 10)))
      (print-and-check gen 
		       "firmant"
		       "firmant frequency: 1200.000, radius: 0.900")
      (vct-set! v0 0 (firmant gen 1.0))
      (do ((i 1 (+ 1 i)))
	  ((= i 10))
	(vct-set! v0 i (firmant gen 0.0)))
      (vct-map! v1 (let ((inp 1.0))
		     (lambda () 
		       (let ((val (if (firmant? gen1) (firmant gen1 inp) -1.0)))
			 (set! inp 0.0)
			 val))))
      (if (not (vequal v0 v1)) (snd-display #__line__ ";map firmant: ~A ~A" v0 v1))
      (if (not (firmant? gen)) (snd-display #__line__ ";~A not firmant?" gen))
      (if (not (= (mus-order gen) 2)) (snd-display #__line__ ";firmant order: ~D?" (mus-order gen)))
      (if (fneq (mus-frequency gen) 1200.0) (snd-display #__line__ ";firmant frequency: ~F?" (mus-frequency gen)))
      (if (or (fneq (vct-ref v0 0) .058) (fneq (vct-ref v0 1) .099)) (snd-display #__line__ ";firmant output: ~A" v0))
      (if (fneq (mus-scaler gen) 0.9) (snd-display #__line__ ";firmant gain: ~F?" (mus-scaler gen)))
      
      (set! (mus-scaler gen) .20)
      (if (fneq (mus-scaler gen) .20) (snd-display #__line__ ";firmant set gain: ~F?" (mus-scaler gen))))
    
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 600.0 0.9))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.99))) (firmant f3 1.0) f3))
    (test-gen-equal (let ((f1 (make-firmant 1200.0 0.9))) (firmant f1 1.0) f1)
		    (let ((f2 (make-firmant 1200.0 0.9))) (firmant f2 1.0) f2)
		    (let ((f3 (make-firmant 1200.0 0.5))) (firmant f3 1.0) f3))
    
    
    (let ((gen (make-mixer 2 .5 .25 .125 1.0))
	  (fr0 (make-frame 2 1.0 1.0))
	  (fr1 (make-frame 2 0.0 0.0)))
      (print-and-check gen 
		       "mixer"
		       "mixer chans: 2, [
 0.500 0.250
 0.125 1.000
]")
      
      (let ((ap (mus-array-print-length))
	    (mx (make-mixer 8)))
	(set! (mus-array-print-length) 4)
	(do ((i 0 (+ 1 i)))
	    ((= i 8))
	  (do ((j 0 (+ 1 j)))
	      ((= j 8))
	    (mixer-set! mx i j (+ j (* i 8)))))
	(print-and-check mx
			 "mixer"
			 "mixer chans: 8, [
 0.000 1.000 2.000 3.000...
 8.000 9.000 10.000 11.000...
 16.000 17.000 18.000 19.000...
 24.000 25.000 26.000 27.000...
]")
	(set! (mus-array-print-length) 12)
	(print-and-check mx
			 "mixer"
			 "mixer chans: 8, [
 0.000 1.000 2.000 3.000 4.000 5.000 6.000 7.000
 8.000 9.000 10.000 11.000 12.000 13.000 14.000 15.000
 16.000 17.000 18.000 19.000 20.000 21.000 22.000 23.000
 24.000 25.000 26.000 27.000 28.000 29.000 30.000 31.000
 32.000 33.000 34.000 35.000 36.000 37.000 38.000 39.000
 40.000 41.000 42.000 43.000 44.000 45.000 46.000 47.000
 48.000 49.000 50.000 51.000 52.000 53.000 54.000 55.000
 56.000 57.000 58.000 59.000 60.000 61.000 62.000 63.000
]")
	(set! (mus-array-print-length) ap))
      (print-and-check fr0 
		       "frame"
		       "frame[2]: [1.000 1.000]")
      (if (not (frame? fr0)) (snd-display #__line__ ";~A not a frame?" fr0))
      (if (not (mixer? gen)) (snd-display #__line__ ";~A not a mixer?" gen))
      (if (equal? fr0 fr1) (snd-display #__line__ ";frame=? ~A ~A?" fr0 fr1))
      (if (not (= (mus-channels fr0) 2)) (snd-display #__line__ ";frame channels: ~D?" (mus-channels fr0)))
      (if (not (= (mus-length fr1) 2)) (snd-display #__line__ ";frame length: ~D?" (mus-length fr0)))
      (if (not (= (mus-channels gen) 2)) (snd-display #__line__ ";mixer channels: ~D?" (mus-channels gen)))
      (frame->frame fr0 gen fr1)
      (if (or (fneq (frame-ref fr0 0) 1.0)
	      (fneq (frame-ref fr1 1) 1.25)
	      (fneq (mixer-ref gen 0 0) .5))
	  (snd-display #__line__ ";fr0: ~A" fr0))
      (frame-set! fr1 0 1.0)
      (let ((fr3 (frame+ fr0 fr1))
	    (fr4 (frame* fr0 fr1))
	    (fr5 (sample->frame fr1 .5)))
	(if (or (fneq (frame-ref fr3 0) 2.0)
		(fneq (frame-ref fr4 0) 1.0))
	    (snd-display #__line__ ";fr+*: ~A ~A" fr3 fr4))
	(if (fneq (frame-ref fr5 0) .5) 
	    (snd-display #__line__ ";sample->frame: ~A?" (frame-ref fr5 0)))
	(sample->frame fr1 .5 fr5)
	(if (fneq (frame-ref fr5 0) .5) 
	    (snd-display #__line__ ";repeat sample->frame: ~A?" (frame-ref fr5 0))))
      (let ((fr3 (make-frame 2))
	    (fr4 (make-frame 4)))
	(frame-set! fr3 0 1.0)
	(set! (frame-ref fr4 0) 0.5)
	(frame-set! fr4 2 1.0)
	(if (not (feql (frame->list (frame+ fr3 fr4)) (list 1.5 0.0)))
	    (snd-display #__line__ ";frame+ unequal chans: ~A?" (frame+ fr3 fr4)))
	(mus-reset fr3)
	(if (fneq (frame-ref fr3 0) 0.0) (snd-display #__line__ ";reset frame: ~A" fr3)))
      (let ((fr3 (make-frame 2))
	    (fr4 (make-frame 4)))
	(frame-set! fr3 0 1.0)
	(frame-set! fr4 0 0.5)
	(frame-set! fr4 2 1.0)
	(if (not (feql (frame->list (frame* fr3 fr4)) (list 0.5 0.0)))
	    (snd-display #__line__ ";frame* unequal chans: ~A?" (frame* fr3 fr4))))
      (let* ((mx1 (make-mixer 2 1.0 0.0 0.0 1.0))
	     (mx2 (mixer* gen mx1))
	     (fr4 (make-frame 2 1.0 1.0))
	     (fr5 (make-frame 2 1.0 1.0))
	     (val (frame->sample mx1 fr1)))
	(if (fneq val 1.0) (snd-display #__line__ ";frame->sample: ~A?" val))
	(if (fneq (frame->sample fr5 fr4) 2.0) (snd-display #__line__ ";frame->sample ~A" (frame->sample fr5 fr4)))
	(if (not (equal? (frame->list fr1) (list 1.0 1.25))) (snd-display #__line__ ";frame->list: ~A?" (frame->list fr1)))
	(if (or (fneq (mixer-ref mx2 0 1) .25) (fneq (mixer-ref mx2 1 0) .125)) (snd-display #__line__ ";mixer*: ~A?" mx2))
	(if (not (equal? mx2 gen)) (snd-display #__line__ ";mixer=? ~A ~A?" gen mx2))
	(if (equal? mx2 mx1) (snd-display #__line__ ";mixer/=? ~A ~A?" mx1 mx2))
	;; mus-data doesn't apply from scheme level here
					;(if (not (vct? (mus-data fr4))) (snd-display #__line__ ";mus-data frame: ~A" (mus-data fr4)))
					;(if (not (vct? (mus-data mx1))) (snd-display #__line__ ";mus-data mixer: ~A" (mus-data mx1)))
	(mixer-set! mx2 0 0 2.0)
	(if (fneq (mixer-ref mx2 0 0) 2.0) (snd-display #__line__ ";mixer-set: ~A?" mx2))
	(set! fr0 (sample->frame mx2 1.0))
	(if (or (fneq (frame-ref fr0 0) 2.0) (fneq (frame-ref fr0 1) .25)) (snd-display #__line__ ";sample->frame: ~A?" fr0))
	(let ((tag (catch #t (lambda () (mixer* fr4 fr5)) (lambda args (car args)))))
	  (if (not (eq? tag 'wrong-type-arg)) (snd-display #__line__ ";mixer* of 2 frames: ~A" tag)))
	(let ((frout (make-frame 2)))
	  (sample->frame mx2 1.0 frout)
	  (if (not (equal? frout fr0)) (snd-display #__line__ ";sample->frame via frout: ~A ~A?" frout fr0)))))
    
    (let ((fr1 (make-frame 2 .1 .2)))
      (let ((val (frame+ fr1 1.0)))
	(if (or (fneq (frame-ref val 0) 1.1)
		(fneq (frame-ref val 1) 1.2))
	    (snd-display #__line__ ";8 frame-offset: ~A" val)))
      (let ((val (frame+ 1.0 fr1)))
	(if (or (fneq (frame-ref val 0) 1.1)
		(fneq (frame-ref val 1) 1.2))
	    (snd-display #__line__ ";8 frame-offset a: ~A" val)))
      (let ((val (frame* fr1 2.0)))
	(if (or (fneq (frame-ref val 0) 0.2)
		(fneq (frame-ref val 1) 0.4))
	    (snd-display #__line__ ";8 frame-scale: ~A" val)))
      (let ((val (frame* 2.0 fr1)))
	(if (or (fneq (frame-ref val 0) 0.2)
		(fneq (frame-ref val 1) 0.4))
	    (snd-display #__line__ ";8 frame-scale a: ~A" val)))
      (let ((val (frame-copy fr1)))
	(if (or (fneq (frame-ref val 0) 0.1)
		(fneq (frame-ref val 1) 0.2))
	    (snd-display #__line__ ";8 frame-copy a: ~A" val))))
    
    (let ((fr (make-frame! 3))
	  (fr1 (make-frame 3)))
      (if (not (equal? fr fr1)) (snd-display #__line__ ";make-frame!: ~A ~A" fr fr1)))
    (let ((fr (make-frame! 3 .1 .2 .3))
	  (fr1 (make-frame 3 .1 .2 .3)))
      (if (not (equal? fr fr1)) (snd-display #__line__ ";make-frame! (args): ~A ~A" fr fr1)))
    
    (let ((fr (frame .1 .2 .3)))
      (let ((fr1 (copy fr)))
	(if (not (equal? fr fr1)) (snd-display #__line__ ";copy frame: ~A ~A" fr fr1)))
      (fill! fr 0.0)
      (if (not (equal? fr (frame 0.0 0.0 0.0)))
	  (snd-display #__line__ ";fill! frame 0.0: ~A" fr)))
    
    
    (let* ((mx1 (make-mixer 2 1 2 3 4))
	   (mx2 (mixer* mx1 2.0)))
      (if (not (equal? mx2 (make-mixer 2 2 4 6 8)))
	  (snd-display #__line__ ";8 mixer* 2: ~A" mx2))
      (set! mx2 (mixer* 2.0 mx1))
      (if (not (equal? mx2 (make-mixer 2 2 4 6 8)))
	  (snd-display #__line__ ";8 mixer* 2a: ~A" mx2))
      (set! mx2 (mixer+ 2.0 mx1))
      (if (not (equal? mx2 (make-mixer 2 3 4 5 6)))
	  (snd-display #__line__ ";8 mixer-offset 2: ~A" mx2))
      (set! mx2 (mixer+ mx1 2.0))
      (if (not (equal? mx2 (make-mixer 2 3 4 5 6)))
	  (snd-display #__line__ ";8 mixer-offset 2a: ~A" mx2)))
    
    (let ((mx1 (make-scalar-mixer 2 2.0))
	  (mx2 (make-mixer 2 .1 .2 .3 .4)))
      (let ((nmx (mixer+ mx1 mx2)))
	(if (or (fneq (mixer-ref mx1 0 0) 2.0)
		(fneq (mixer-ref mx1 0 1) 0.0)
		(fneq (mixer-ref mx1 1 0) 0.0)
		(fneq (mixer-ref mx1 1 1) 2.0))
	    (snd-display #__line__ ";make-scalar-mixer 2: ~A" mx1))
	(if (or (fneq (mixer-ref mx2 0 0) .1)
		(fneq (mixer-ref mx2 0 1) .2)
		(fneq (mixer-ref mx2 1 0) .3)
		(fneq (mixer-ref mx2 1 1) .4))
	    (snd-display #__line__ ";make-mixer .1 .2 .3 .4: ~A" mx2))
	(if (or (fneq (mixer-ref nmx 0 0) 2.1)
		(fneq (mixer-ref nmx 0 1) 0.2)
		(fneq (mixer-ref nmx 1 0) 0.3)
		(fneq (mixer-ref nmx 1 1) 2.4))
	    (snd-display #__line__ ";mixer add ~A ~A: ~A" mx1 mx2 nmx))
	(set! mx1 (mixer* mx1 .5))
	(if (or (fneq (mixer-ref mx1 0 0) 1.0)
		(fneq (mixer-ref mx1 0 1) 0.0)
		(fneq (mixer-ref mx1 1 0) 0.0)
		(fneq (mixer-ref mx1 1 1) 1.0))
	    (snd-display #__line__ ";make-scale (identity): ~A" mx1)))
      (mus-reset mx1)
      (if (fneq (mixer-ref mx1 0 0) 0.0) (snd-display #__line__ ";reset mixer: ~A" mx1)))
    
    (let ((mx (mixer .1 .2 .3 .4)))
      (let ((mx1 (copy mx)))
	(if (not (equal? mx mx1)) (snd-display #__line__ ";mixer copy not equal? ~A ~A" mx mx1)))
      (fill! mx 0.1)
      (if (not (equal? mx (mixer .1 .1 .1 .1))) 
	  (snd-display #__line__ ";fill! mixer: ~A" mx)))
    
    (let ((var (catch #t (lambda () (make-mixer 2 0.0 0.0 0.0 0.0 0.0)) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";make-mixer extra args: ~A" var)))
    (let ((var (catch #t (lambda () (let ((fr1 (make-frame 2 1.0 0.0))) (frame->sample (make-oscil) fr1))) (lambda args args))))
      (if (not (eq? (car var) 'mus-error))
	  (snd-display #__line__ ";frame->sample bad arg: ~A" var)))
    (let* ((hi (make-mixer 1 1))
	   (tag (catch #t (lambda () (mixer-set! hi 1 1 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";mixer-set! 1 1 of 0: ~A (~A)" tag hi)))
    (let* ((hi (make-mixer 1 1))
	   (tag (catch #t (lambda () (set! (mixer-ref hi 1 1) 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";set! mixer-ref 1 1 of 0: ~A (~A)" tag hi)))
    (let* ((hi (make-mixer 1))
	   (tag (catch #t (lambda () (mixer-set! hi 1 0 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";mixer-set! 1 0 of 0: ~A (~A)" tag hi)))
    (let* ((hi (make-mixer 1))
	   (tag (catch #t (lambda () (mixer-set! hi 0 1 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";mixer-set! 0 1 of 0: ~A (~A)" tag hi)))
    (let* ((hi (make-frame 1))
	   (tag (catch #t (lambda () (frame-set! hi 1 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";frame-set! 1 of 0: ~A (~A)" tag hi)))
    (let* ((hi (make-frame 1))
	   (tag (catch #t (lambda () (set! (frame-ref hi 1) 1.0)) (lambda args (car args)))))
      (if (not (eq? tag 'mus-error)) (snd-display #__line__ ";set! frame-ref 1 of 0: ~A (~A)" tag hi)))
    (let* ((tag (catch #t (lambda () (make-frame 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";make-frame 0: ~A" tag)))
    (let* ((tag (catch #t (lambda () (make-mixer 0)) (lambda args (car args)))))
      (if (not (eq? tag 'out-of-range)) (snd-display #__line__ ";make-mixer 0: ~A" tag)))
    
    (let ((fr1 (make-frame 1 1))
	  (fr2 (make-frame 2 1 2))
	  (fr4 (make-frame 4 1 2 3 4)) 
	  (fr8 (make-frame 8 1 2 3 4 5 6 7 8))
	  (mx1 (make-mixer 1 5))
	  (mx1id (make-mixer 1 1))
	  (mx2 (make-mixer 2 1 2 3 4))
	  (mx2id (make-mixer 2 1 0 0 1))
	  (mx4 (make-mixer 4))
	  (mx4id (make-mixer 4))
	  (mx8 (make-mixer 8))
	  (mx8id (make-mixer 8)))
      (do ((i 0 (+ 1 i)))
	  ((= i 4))
	(mixer-set! mx4id i i 1)
	(set! (mixer-ref mx4 0 i) 1))
      (do ((i 0 (+ 1 i)))
	  ((= i 8))
	(mixer-set! mx8id i i 1)
	(mixer-set! mx8 i 0 1))
      (if (not (equal? (frame->frame fr1 mx1id) (make-frame 1 1))) (snd-display #__line__ ";frame->frame 1 id: ~A?"            (frame->frame fr1 mx1id)))
      (if (not (equal? (frame->frame fr1 mx1) (make-frame 1 5))) (snd-display #__line__ ";frame->frame 1: ~A?"                 (frame->frame fr1 mx1)))  
      (if (not (equal? (frame->frame fr1 mx2id) (make-frame 2 1 0))) (snd-display #__line__ ";frame->frame 2 1 id: ~A?"        (frame->frame fr1 mx2id)))  
      (if (not (equal? (frame->frame fr1 mx2) (make-frame 2 1 2))) (snd-display #__line__ ";frame->frame 2 1: ~A?"             (frame->frame fr1 mx2)))  
      (if (not (equal? (frame->frame fr1 mx4) (make-frame 4 1 1 1 1))) (snd-display #__line__ ";frame->frame 4 1: ~A?"         (frame->frame fr1 mx4)))  
      (if (not (equal? (frame->frame fr1 mx8) (make-frame 8 1 0 0 0 0 0 0 0))) (snd-display #__line__ ";frame->frame 8 1: ~A?" (frame->frame fr1 mx8))) 
      (if (not (equal? (frame->frame fr2 mx1) (make-frame 1 5))) (snd-display #__line__ ";frame->frame 1 2: ~A?"               (frame->frame fr2 mx1)))   
      (if (not (equal? (frame->frame fr2 mx2id) (make-frame 2 1 2))) (snd-display #__line__ ";frame->frame 2id 2: ~A?"         (frame->frame fr2 mx2id)))  
      (if (not (equal? (frame->frame fr2 mx2) (make-frame 2 7 10))) (snd-display #__line__ ";frame->frame 2 2: ~A?"            (frame->frame fr2 mx2)))  
      (if (not (equal? (frame->frame fr2 mx4id) (make-frame 4 1 2 0 0))) (snd-display #__line__ ";frame->frame 4id 2: ~A?"     (frame->frame fr2 mx4id)))  
      (if (not (equal? (frame->frame fr2 mx8id) (make-frame 8 1 2 0 0 0 0 0 0))) (snd-display #__line__ ";frame->frame 8id 2: ~A?" (frame->frame fr2 mx8id)))  
      (if (not (equal? (frame->frame fr2 mx4) (make-frame 4 1 1 1 1))) (snd-display #__line__ ";frame->frame 4 2: ~A?"         (frame->frame fr2 mx4)))  
      (if (not (equal? (frame->frame fr2 mx8) (make-frame 8 3 0 0 0 0 0 0 0))) (snd-display #__line__ ";frame->frame 8 2: ~A?" (frame->frame fr2 mx8))) 
      (if (not (equal? (frame->frame fr4 mx1) (make-frame 1 5))) (snd-display #__line__ ";frame->frame 1 4: ~A?"               (frame->frame fr4 mx1))) 
      (if (not (equal? (frame->frame fr8 mx1) (make-frame 1 5))) (snd-display #__line__ ";frame->frame 1 8: ~A?"               (frame->frame fr8 mx1))) 
      (if (not (equal? (frame->frame fr2 mx8id) (make-frame 8 1 2 0 0 0 0 0 0))) (snd-display #__line__ ";frame->frame 8id 2: ~A?" (frame->frame fr2 mx8id)))
      (if (not (equal? (frame->frame fr2 mx4id) (make-frame 4 1 2 0 0))) (snd-display #__line__ ";frame->frame 4id 2: ~A?"     (frame->frame fr2 mx4id)))  
      (if (not (equal? (frame->frame fr4 mx8) (make-frame 8 10 0 0 0 0 0 0 0))) (snd-display #__line__ ";frame->frame 8 4: ~A?" (frame->frame fr4 mx8))) 
      (if (not (equal? (frame->frame fr4 mx4) (make-frame 4 1 1 1 1))) (snd-display #__line__ ";frame->frame 4 4: ~A?"         (frame->frame fr4 mx4))))
    
    (let ((fr1 (make-frame 2))
	  (fr2 (make-frame 2))
	  (mx1 (make-mixer 2))
	  (mx2 (make-mixer 2)))
      (frame-set! fr1 0 .1)
      (let ((fradd (frame+ fr1 fr1 fr2)))
	(if (not (equal? fr2 fradd)) (snd-display #__line__ ";frame+ with res frame: ~A ~A" fr2 fradd))
	(if (not (equal? fr2 (make-frame 2 0.2 0.0))) (snd-display #__line__ ";frame+ res: ~A" fr2))
	(set! fradd (frame* fr1 fr1 fr2))
	(if (not (equal? fr2 fradd)) (snd-display #__line__ ";frame* with res frame: ~A ~A" fr2 fradd))
	(if (or (fneq (frame-ref fr2 0) .01) (fneq (frame-ref fr2 1) 0.0)) (snd-display #__line__ ";frame* res: ~A" fr2)))
      (set! (mixer-ref mx1 0 0) .1)
      (let ((mxadd (mixer* mx1 mx1 mx2)))
	(if (not (equal? mx2 mxadd)) (snd-display #__line__ ";mixer* with res frame: ~A ~A" mx2 mxadd))
	(if (fneq (mixer-ref mx2 0 0) .01) (snd-display #__line__ ";mixer* res: ~A" mx2))))
    
    
    (let ((fr1 (frame .1 .2))
	  (fr2 (make-frame 2 .1 .2)))
      (if (not (equal? fr1 fr2))
	  (snd-display #__line__ ";frame...: ~A ~A" fr1 fr2)))
    
    (let ((fr1 (frame .1)))
      (if (fneq (fr1 0) .1) (snd-display #__line__ ";frame gen ref (.1): ~A" (fr1 0)))
      (set! (fr1 0) .2)
      (if (fneq (fr1 0) .2) (snd-display #__line__ ";frame gen ref (.2): ~A" (fr1 0)))
      (if (not (equal? fr1 (frame .2)))
	  (snd-display #__line__ ";frame gen set! (.2): ~A" fr1)))
    
    (let ((fr1 (frame .1 .2 .3 .4)))
      (set! (fr1 2) (+ (fr1 1) (fr1 2)))
      (if (fneq (fr1 2) .5) (snd-display #__line__ ";frame gen ref/set (.5): ~A" (fr1 2))))
    
    (let ((fr1 (frame)))
      (if (or (not (frame? fr1))
	      (not (equal? fr1 (make-frame 1 0.0))))
	  (snd-display #__line__ ";frame no args: ~A" fr1))
      (set! (fr1 0) .5)
      (if (fneq (fr1 0) .5) (snd-display #__line__ ";frame ref/set no args: ~A" (fr1 0))))
    
    (let ((fr1 (make-frame 2 .1)))
      (if (not (equal? fr1 (frame .1 0.0)))
	  (snd-display #__line__ ";make-frame missing arg: ~A" fr1)))
    
    
    (let ((mx (mixer .1 .2 .3 .4)))
      (if (fneq (mx 0 0) .1) (snd-display #__line__ ";mixer gen ref (.1): ~A" (mx 0 0)))
      (if (not (equal? mx (make-mixer 2 .1 .2 .3 .4))) (snd-display #__line__ ";mixer...: ~A" mx))
      (set! (mx 0 0) .5)
      (if (fneq (mx 0 0) .5) (snd-display #__line__ ";mixer gen set (.5): ~A" (mx 0 0)))
      (if (not (equal? mx (make-mixer 2 .5 .2 .3 .4))) (snd-display #__line__ ";mixer... (after set): ~A" mx))
      (if (fneq (mx 1 0) .3) (snd-display #__line__ ";mixer gen ref (.3): ~A" (mx 1 0)))
      (set! (mx 0 1) .5)
      (if (fneq (mx 0 1) .5) (snd-display #__line__ ";mixer (0 1) gen set (.5): ~A" (mx 0 1)))
      (if (not (equal? mx (make-mixer 2 .5 .5 .3 .4))) (snd-display #__line__ ";mixer... (after set 1): ~A" mx)))
    
    (let ((mx (mixer .1)))
      (if (not (equal? mx (make-mixer 1 .1))) (snd-display #__line__ ";mixer .1: ~A" mx))
      (if (fneq (mx 0 0) .1) (snd-display #__line__ ";mixer (1) gen ref (.1): ~A" (mx 0 0)))  
      (set! (mx 0 0) .5)
      (if (fneq (mx 0 0) .5) (snd-display #__line__ ";mixer (1) gen set (.5): ~A" (mx 0 0))))
    
    (let ((mx (mixer .1 .2 .3)))
      (if (not (equal? mx (make-mixer 2 .1 .2 .3 0.0))) (snd-display #__line__ ";mixer .1 .2 .3: ~A" mx))
      (set! (mx 1 1) .5)
      (if (fneq (mx 1 1) .5) (snd-display #__line__ ";mixer (1 1) gen set (.5): ~A" (mx 1 1))))
    
    (let ((mx (mixer)))
      (if (not (equal? mx (make-mixer 1 0.0))) (snd-display #__line__ ";(mixer): ~A" mx)))
    
    
    (for-each 
     (lambda (chans)
       (let ((m1 (make-mixer chans)))
	 (if (or (not (= (mus-channels m1) chans))
		 (not (= (mus-length m1) chans)))
	     (snd-display #__line__ ";mixer ~A chans but: ~A ~A" chans (mus-channels m1) (mus-length m1)))
	 (do ((i 0 (+ 1 i)))
	     ((= i chans))
	   (do ((j 0 (+ 1 j)))
	       ((= j chans))
	     (mixer-set! m1 i j (+ (* i .01) (* j .1)))))
	 (do ((i 0 (+ 1 i)))
	     ((= i chans))
	   (do ((j 0 (+ 1 j)))
	       ((= j chans))
	     (if (fneq (mixer-ref m1 i j) (+ (* i .01) (* j .1)))
		 (snd-display #__line__ ";mixer[~A ~A] = ~A (~A)?" i j (mixer-ref m1 i j) (+ (* i .01) (* j .1))))))
	 (let ((mempty (make-mixer chans))
	       (midentity (make-mixer chans))
	       (mpick (make-mixer chans)))
	   (do ((i 0 (+ 1 i)))
	       ((= i chans))
	     (mixer-set! midentity i i 1.0))
	   (mixer-set! mpick (- chans 1) (- chans 1) 1.0)
	   (let ((mzero (mixer* m1 mempty))
		 (msame (mixer* m1 midentity))
		 (mone (mixer* m1 mpick)))
	     (do ((i 0 (+ 1 i)))
		 ((= i chans))
	       (do ((j 0 (+ 1 j)))
		   ((= j chans))
		 (if (fneq (mixer-ref mzero i j) 0.0) (snd-display #__line__ ";mzero ~A ~A = ~A?" i j (mixer-ref mzero i j)))
		 (if (fneq (mixer-ref m1 i j) (mixer-ref msame i j)) (snd-display #__line__ ";msame ~A ~A?" (mixer-ref msame i j) (mixer-ref m1 i j)))
		 (if (and (fneq (mixer-ref mone i j) 0.0)
			  (not (= i (- chans 1)))
			  (not (= j (- chans 1))))
		     (snd-display #__line__ ";mone ~A ~A = ~A?" i j (mixer-ref mone i j)))))))))
     (list 1 2 4 8))
    
    (let ((mx (make-mixer 4 4)))
      (let ((tag (catch #t (lambda () (set! (mus-length mx) 2)) (lambda args (car args)))))
	(if (not (eq? tag 'mus-error)) (snd-display #__line__ ";set mixer-length: ~A ~A" tag (mus-length mx)))))
    
    (letrec ((mixer-equal? (lambda (m1 m2) 
			     ;; this is less demanding than the built-in function
			     (let ((len (mus-length m1))
				   (happy #t))
			       (and (= len (mus-length m2))
				    (do ((i 0 (+ 1 i)))
					((or (not happy) (= i len)) 
					 happy)
				      (do ((j 0 (+ 1 j)))
					  ((or (not happy) (= j len)))
					(if (> (abs (- (mat m1 i j) (mat m2 i j))) .001)
					    (set! happy #f))))))))
	     (mixer-normal? (lambda (mx)
			      (mixer-equal? (mixer* mx (mixer-transpose mx)) ; conjugate transpose (hermitian) if complex
					    (mixer* (mixer-transpose mx) mx))))
	     (mixer-orthogonal? (lambda (mx)
				  (mixer-equal? (mixer-transpose mx) 
						(mixer-inverse mx))))
	     (mixer-unitary? (lambda (mx) (mixer-orthogonal? mx))) ; reals
	     (mixer-symmetric? (lambda (m1) (mixer-equal? m1 (mixer-transpose m1))))
	     (mixer-hermitian? (lambda (mx) (mixer-symmetric? mx))) ; assuming reals	   
	     (frame-equal? (lambda (f1 f2)
			     (let ((len (mus-length f1))
				   (happy #t))
			       (and (= len (mus-length f2))
				    (do ((i 0 (+ 1 i)))
					((or (not happy) (= i len))
					 happy)
				      (if (> (abs (- (frame-ref f1 i) (frame-ref f2 i))) .001)
					  (set! happy #f)))))))
	     (slow-mixer-inverse (lambda (mx)
				   (let ((n (mus-length mx))
					 (det (mixer-determinant mx)))
				     (if (not (= det 0.0))
					 (let ((nmx (make-zero-mixer n)))
					   (do ((i 0 (+ 1 i)))
					       ((= i n))
					     (do ((j 0 (+ 1 j)))
						 ((= j n))
					       (mixer-set! nmx j i (* (if (odd? (+ i j)) -1 1) 
								      (/ (mixer-determinant (sub-matrix mx i j)) 
									 det)))))
					   nmx)
					 #f))))
	     (slow-mixer-solve (lambda (A b) ; Ax=b where A is mixer and b is frame, returns frame
				 (if (= (mus-length A) 1)
				     (if (not (= (mixer-ref A 0 0) 0.0))
					 (make-frame 1 (/ (frame-ref b 0) (mixer-ref A 0 0)))
					 #f)
				     (let ((imx (slow-mixer-inverse A)))
				       (if (mixer? imx) ; else determinant = 0
					   (frame->frame imx b)
					   #f)))))
	     (make-random-frame (lambda (size)
				  (let ((fr (make-frame size)))
				    (do ((i 0 (+ 1 i)))
					((= i size))
				      (frame-set! fr i (- 1.0 (random 2.0))))
				    fr)))
	     (make-random-mixer (lambda (size)
				  (let ((mx (make-mixer size)))
				    (do ((i 0 (+ 1 i)))
					((= i size))
				      (do ((j 0 (+ 1 j)))
					  ((= j size))
					(mixer-set! mx i j (- 1.0 (random 2.0)))))
				    mx)))
	     )
      (if (fneq (mixer-determinant (make-mixer 2 1 2 3 4)) -2.0)
	  (snd-display #__line__ ";mixer-determinant -2: ~A" (mixer-determinant (make-mixer 2 1 2 3 4))))
      (if (fneq (mixer-determinant (make-mixer 3 1 2 3 4 5 6 7 8 9)) 0.0)
	  (snd-display #__line__ ";mixer-determinant 0: ~A" (mixer-determinant (make-mixer 3 1 2 3 4 5 6 7 8 9))))
      (if (fneq (mixer-determinant (make-mixer 4 1 2 3 4 8 7 6 5 1 8 2 7 3 6 4 5)) -144.0) ; Eves Elementary Matrix Theory
	  (snd-display #__line__ ";mixer-determinant -144: ~A" (mixer-determinant (make-mixer 4 1 2 3 4 8 7 6 5 1 8 2 7 3 6 4 5))))
      (if (fneq (mixer-determinant (make-mixer 5  2 3 5 7 11  13 17 19 23 29  31 37 41 43 47  53 59 61 67 71  73 79 83 89 97)) -4656.0)
	  (snd-display #__line__ ";mixer-determinant -4656: ~A" (mixer-determinant (make-mixer 5  2 3 5 7 11  13 17 19 23 29  31 37 41 43 47  
											       53 59 61 67 71  73 79 83 89 97))))
      (if (fneq (mixer-determinant (make-mixer 6  2 3 5 7 11 13   17 19 23 29 31 37  41 43 47 53 59 61  67 71 73 79 83 89  
					       97 101 103 107 109 113  127 131 137 139 149 151)) -14304.0)
	  (snd-display #__line__ ";mixer-determinant -14304: ~A" 
		       (mixer-determinant (make-mixer 6  2 3 5 7 11 13   17 19 23 29 31 37  41 43 47 53 59 61  67 71 73 79 83 89  
						      97 101 103 107 109 113  127 131 137 139 149 151))))
      (if (not (mixer-equal? (mixer-transpose (make-mixer 2 1 2 3 4)) 
			     (make-mixer 2 1.000 3.000 2.000 4.000)))
	  (snd-display #__line__ ";mixer-transpose 1: ~A" (mixer-transpose (make-mixer 2 1 2 3 4))))
      (if (not (mixer-equal? (mixer-transpose (make-mixer 3 1 2 3 4 5 6 7 8 9)) 
			     (make-mixer 3 1.000 4.000 7.000 2.000 5.000 8.000 3.000 6.000 9.000)))
	  (snd-display #__line__ ";mixer-transpose 2: ~A" (mixer-transpose (make-mixer 3 1 2 3 4 5 6 7 8 9))))
      (if (not (mixer-equal? (mixer* (make-mixer 2 1 0 0 1) (make-mixer 2 2 0 0 2)) 
			     (make-mixer 2 2.000 0.000 0.000 2.000)))
	  (snd-display #__line__ ";mixer* 1: ~A" (mixer* (make-mixer 2 1 0 0 1) (make-mixer 2 2 0 0 2))))
      (if (not (mixer-equal? (mixer* (make-mixer 3 2 3 5 7 11 13 19 23 29) (make-mixer 3 41 43 47 53 59 61 67 71 73))
			     (make-mixer 3 576.000 618.000 642.000 1741.000 1873.000 1949.000 3941.000 4233.000 4413.000)))
	  (snd-display #__line__ ";mixer* 2: ~A" (mixer* (make-mixer 3 2 3 5 7 11 13 19 23 29) (make-mixer 3 41 43 47 53 59 61 67 71 73))))
      (if (not (mixer-equal? (slow-mixer-inverse (make-mixer 2 1 0 0 1)) 
			     (make-mixer 2 1.000 0.000 0.000 1.000)))
	  (snd-display #__line__ ";slow-mixer-inverse 1: ~A" (slow-mixer-inverse (make-mixer 2 1 0 0 1))))
      (if (not (mixer-equal? (slow-mixer-inverse (make-mixer 2 2 3 5 8))
			     (make-mixer 2 8.000 -3.000 -5.000 2.000)))
	  (snd-display #__line__ ";slow-mixer-inverse 2: ~A" (slow-mixer-inverse (make-mixer 2 2 3 5 8))))
      (if (not (mixer-equal? (slow-mixer-inverse (make-mixer 3  2 3 5  7 11 13  17 19 23))
			     (make-mixer 3 -0.077 -0.333 0.205 -0.769 0.500 -0.115 0.692 -0.167 -0.013)))
	  (snd-display #__line__ ";slow-mixer-inverse 3: ~A" (slow-mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23))))
      (if (not (mixer-equal? (slow-mixer-inverse (make-mixer 4 2 3 5 7  17 19 23 29 41 43 47 53 67 71 73 97))
			     (make-mixer 4 -7.000 4.708 -1.042 -0.333 9.000 -6.396 1.396 0.500 
					 -1.000 0.875 -0.042 -0.167 -1.000 0.771 -0.271 0.000)))
	  (snd-display #__line__ ";slow-mixer-inverse 4: ~A" (slow-mixer-inverse (make-mixer 4 2 3 5 7  17 19 23 29 41 43 47 53 67 71 73 97))))
      (if (not (mixer-equal? (slow-mixer-inverse (make-mixer 6  2 3 5 7 11 13   17 -19 23 29 31 37  41 43 47 53 59 61  
							     67 71 73 79 83 89  97 101 103 107 109 113  127 131 137 139 149 151))
			     (make-mixer 6 -1.355 0.020 -0.000 1.090 -1.153 0.333 0.092 -0.025 0.000 -0.042 0.070 -0.029 
					 1.612 0.006 -0.250 -1.205 1.249 -0.264 0.079 0.002 0.250 -0.314 0.425 -0.241 
					 -0.551 -0.011 0.250 0.200 -0.476 0.188 0.068 0.009 -0.250 0.306 -0.145 0.028)))
	  (snd-display #__line__ ";slow-mixer-inverse 5: ~A" (slow-mixer-inverse (make-mixer 6  2 3 5 7 11 13   17 -19 23 29 31 37  41 43 47 53 59 61  
											     67 71 73 79 83 89  97 101 103 107 109 113  127 131 137 139 149 151))))
      (if (not (mixer-equal? (mixer* (make-mixer 2 2 3 5 8) (slow-mixer-inverse (make-mixer 2 2 3 5 8)))
			     (make-scalar-mixer 2 1.0)))
	  (snd-display #__line__ ";slow-mixer-inverse 6: ~A" (mixer* (make-mixer 2 2 3 5 8) (slow-mixer-inverse (make-mixer 2 2 3 5 8)))))
      (if (not (mixer-equal? (mixer* (make-mixer 3 2 3 5 7 11 13 17 19 23) (slow-mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23)))
			     (make-scalar-mixer 3 1.0)))
	  (snd-display #__line__ ";slow-mixer-inverse 7: ~A" 
		       (mixer* (make-mixer 3 2 3 5 7 11 13 17 19 23) (slow-mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23)))))
      
      (if (not (mixer-equal? (mixer-inverse (make-mixer 2 1 0 0 1)) 
			     (make-mixer 2 1.000 0.000 0.000 1.000)))
	  (snd-display #__line__ ";mixer-inverse 1: ~A" (mixer-inverse (make-mixer 2 1 0 0 1))))
      (if (not (mixer-equal? (mixer-inverse (make-mixer 2 2 3 5 8))
			     (make-mixer 2 8.000 -3.000 -5.000 2.000)))
	  (snd-display #__line__ ";mixer-inverse 2: ~A" (mixer-inverse (make-mixer 2 2 3 5 8))))
      (if (not (mixer-equal? (mixer-inverse (make-mixer 3  2 3 5  7 11 13  17 19 23))
			     (make-mixer 3 -0.077 -0.333 0.205 -0.769 0.500 -0.115 0.692 -0.167 -0.013)))
	  (snd-display #__line__ ";mixer-inverse 3: ~A" (mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23))))
      (if (not (mixer-equal? (mixer-inverse (make-mixer 4 2 3 5 7  17 19 23 29 41 43 47 53 67 71 73 97))
			     (make-mixer 4 -7.000 4.708 -1.042 -0.333 9.000 -6.396 1.396 0.500 
					 -1.000 0.875 -0.042 -0.167 -1.000 0.771 -0.271 0.000)))
	  (snd-display #__line__ ";mixer-inverse 4: ~A" (mixer-inverse (make-mixer 4 2 3 5 7  17 19 23 29 41 43 47 53 67 71 73 97))))
      (if (not (mixer-equal? (mixer-inverse (make-mixer 6  2 3 5 7 11 13   17 -19 23 29 31 37  41 43 47 53 59 61  
							67 71 73 79 83 89  97 101 103 107 109 113  127 131 137 139 149 151))
			     (make-mixer 6 -1.355 0.020 -0.000 1.090 -1.153 0.333 0.092 -0.025 0.000 -0.042 0.070 -0.029 
					 1.612 0.006 -0.250 -1.205 1.249 -0.264 0.079 0.002 0.250 -0.314 0.425 -0.241 
					 -0.551 -0.011 0.250 0.200 -0.476 0.188 0.068 0.009 -0.250 0.306 -0.145 0.028)))
	  (snd-display #__line__ ";mixer-inverse 5: ~A" (mixer-inverse (make-mixer 6  2 3 5 7 11 13   17 -19 23 29 31 37  41 43 47 53 59 61  
										   67 71 73 79 83 89  97 101 103 107 109 113  127 131 137 139 149 151))))
      (if (not (mixer-equal? (mixer* (make-mixer 2 2 3 5 8) (mixer-inverse (make-mixer 2 2 3 5 8)))
			     (make-scalar-mixer 2 1.0)))
	  (snd-display #__line__ ";mixer-inverse 6: ~A" (mixer* (make-mixer 2 2 3 5 8) (mixer-inverse (make-mixer 2 2 3 5 8)))))
      (if (not (mixer-equal? (mixer* (make-mixer 3 2 3 5 7 11 13 17 19 23) (mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23)))
			     (make-scalar-mixer 3 1.0)))
	  (snd-display #__line__ ";mixer-inverse 7: ~A" 
		       (mixer* (make-mixer 3 2 3 5 7 11 13 17 19 23) (mixer-inverse (make-mixer 3 2 3 5 7 11 13 17 19 23)))))
      (if (invert-matrix (make-mixer 3 1 2 3 4 5 6 7 8 9))
	  (snd-display #__line__ ";invert-matrix missed singular case? ~A" (invert-matrix (make-mixer 3 1 2 3 4 5 6 7 8 9))))
      (if (fneq (mixer-trace (make-mixer 3 1 0 0 0 2 0 0 0 3)) 6.0)
	  (snd-display #__line__ ";mixer-trace (6): ~A" (mixer-trace (make-mixer 3 1 0 0 0 2 0 0 0 3))))
      
      (if (not (mixer-diagonal? (make-scalar-mixer 2 2.0))) (snd-display #__line__ ";mixer-diagonal 1"))
      (if (not (mixer-diagonal? (make-mixer 3 1 0 0 0 1 0 0 0 1))) (snd-display #__line__ ";mixer-diagonal 2"))
      (if (mixer-diagonal? (make-mixer 3 1 0 0 0 1 1 0 0 1)) (snd-display #__line__ ";mixer-diagonal 3"))
      (if (not (mixer-diagonal? (make-mixer 3 0 0 0 0 1 0 0 0 1))) (snd-display #__line__ ";mixer-diagonal 4"))
      (if (not (mixer-symmetric? (make-mixer 3 0 0 0 0 1 0 0 0 1))) (snd-display #__line__ ";mixer-symmetric 1"))
      (if (not (mixer-symmetric? (make-mixer 3 1 2 0 2 1 0 0 0 1))) (snd-display #__line__ ";mixer-symmetric 2"))
      (if (mixer-symmetric? (make-mixer 3 1 2 0 2 1 0 0 2 1)) (snd-display #__line__ ";mixer-symmetric 3"))
      (if (not (mixer-equal? (make-scalar-mixer 2 2.0) (make-mixer 2 2.0 0 0 2.0))) (snd-display #__line__ ";mixer-equal 1"))
      (if (mixer-equal? (make-mixer 2 1 2 3 4) (make-mixer 3 1 2 3 4 5 6 7 8 9)) (snd-display #__line__ ";mixer-equal 2"))
      (if (mixer-equal? (make-mixer 2 1 2 3 4) (make-mixer 2 1 2 3 5)) (snd-display #__line__ ";mixer-equal 3"))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 0 0 1) 1.0 1.0) (make-mixer 2 2.0 0.0 0.0 2.0)))
	  (snd-display #__line__ ";mixer-poly 1: ~A" (mixer-poly (make-mixer 2 1 0 0 1) 1.0 1.0)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 1 1) 1) (make-mixer 1 1.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 1 1) 1)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 0 0 1) 1 0 0) (make-mixer 2 1.0 0.0 0.0 1.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 0 0 1) 1 0 0)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 2 4 3) 1 0 0) (make-mixer 2 9.0 8.0 16.0 17.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 2 4 3) 1 0 0)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 2 4 3) 1 1 0) (make-mixer 2 10.0 10.0 20.0 20.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 2 4 3) 1 1 0)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 2 4 3) 1 1 2) (make-mixer 2 12.0 10.0 20.0 22.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 2 4 3) 1 1 2)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 2 4 3) 1 0 0 0) (make-mixer 2 41.0 42.0 84.0 83.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 2 4 3) 1 0 0 0)))
      (if (not (mixer-equal? (mixer-poly (make-mixer 2 1 2 4 3) 1 0 1 0) (make-mixer 2 42.0 44.0 88.0 86.0)))
	  (snd-display #__line__ ";mixer-poly 2: ~A" (mixer-poly (make-mixer 2 1 2 4 3) 1 0 1 0)))
      
      (let ((fr (slow-mixer-solve (make-mixer 2 1 0 0 2) (make-frame 2 2 3))))
	(if (not (frame-equal? fr (make-frame 2 2.000 1.500))) (snd-display #__line__ ";slow-mixer-solve 1: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 2 1 1 0 1) (make-frame 2 2 3))))
	(if (not (frame-equal? fr (make-frame 2 -1.000 3.000))) (snd-display #__line__ ";slow-mixer-solve 2: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 3 2 1 3 1 -1 0 1 1 2) (make-frame 3 1 1 1))))
	(if fr (snd-display #__line__ ";slow-mixer-solve 3 (#f): ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 3 2 1 3 1 -1 0 1 1 2) (make-frame 3 1 1 .333))))
	(if fr (snd-display #__line__ ";slow-mixer-solve 4 (#f): ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 3 2 1 3 1 -1 1 1 1 2) (make-frame 3 1 1 1))))
	(if (not (frame-equal? fr (make-frame 3 -2.000 -1.000 2.000))) (snd-display #__line__ ";slow-mixer-solve 5: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 3 1 -1 -1 3 -3 2 2 -1 1) (make-frame 3 2 16 9))))
	(if (not (frame-equal? fr (make-frame 3 3.000 -1.000 2.000))) (snd-display #__line__ ";slow-mixer-solve 6: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 3 1 1 1 2 3 1 1 -1 -2) (make-frame 3 3 5 -5))))
	(if (not (frame-equal? fr (make-frame 3 0.000 1.000 2.000))) (snd-display #__line__ ";slow-mixer-solve 7: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 1 .5) (make-frame 1 2))))
	(if (not (frame-equal? fr (make-frame 1 4.000))) (snd-display #__line__ ";slow-mixer-solve 8: ~A" fr)))
      (let ((fr (slow-mixer-solve (make-mixer 4 2 0 0 0 0 3 0 0 0 0 4 0 0 0 0 5) (make-frame 4 1 1 1 1))))
	(if (not (frame-equal? fr (make-frame 4 0.500 0.333 0.250 0.200))) (snd-display #__line__ ";slow-mixer-solve 9: ~A" fr)))
      
      (let ((fr (mixer-solve (make-mixer 2 1 0 0 2) (make-frame 2 2 3))))
	(if (not (frame-equal? fr (make-frame 2 2.000 1.500))) (snd-display #__line__ ";mixer-solve 1: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 2 1 1 0 1) (make-frame 2 2 3))))
	(if (not (frame-equal? fr (make-frame 2 -1.000 3.000))) (snd-display #__line__ ";mixer-solve 2: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 3 2 1 3 1 -1 0 1 1 2) (make-frame 3 1 1 1))))
	(if fr (snd-display #__line__ ";mixer-solve 3 (#f): ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 3 2 1 3 1 -1 0 1 1 2) (make-frame 3 1 1 .333))))
	(if fr (snd-display #__line__ ";mixer-solve 4 (#f): ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 3 2 1 3 1 -1 1 1 1 2) (make-frame 3 1 1 1))))
	(if (not (frame-equal? fr (make-frame 3 -2.000 -1.000 2.000))) (snd-display #__line__ ";mixer-solve 5: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 3 1 -1 -1 3 -3 2 2 -1 1) (make-frame 3 2 16 9))))
	(if (not (frame-equal? fr (make-frame 3 3.000 -1.000 2.000))) (snd-display #__line__ ";mixer-solve 6: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 3 1 1 1 2 3 1 1 -1 -2) (make-frame 3 3 5 -5))))
	(if (not (frame-equal? fr (make-frame 3 0.000 1.000 2.000))) (snd-display #__line__ ";mixer-solve 7: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 1 .5) (make-frame 1 2))))
	(if (not (frame-equal? fr (make-frame 1 4.000))) (snd-display #__line__ ";mixer-solve 8: ~A" fr)))
      (let ((fr (mixer-solve (make-mixer 4 2 0 0 0 0 3 0 0 0 0 4 0 0 0 0 5) (make-frame 4 1 1 1 1))))
	(if (not (frame-equal? fr (make-frame 4 0.500 0.333 0.250 0.200))) (snd-display #__line__ ";mixer-solve 9: ~A" fr)))
      
      ;; try random input to mixer-inverse
      (do ((k 2 (+ 1 k)))
	  ((= k 20))
	(let* ((mx (make-random-mixer k))
	       (imx (mixer-inverse (mixer-copy mx)))
	       (mmx (mixer* mx imx)))
	  (if (not (mixer-equal? mmx (make-scalar-mixer k 1.0)))
	      (snd-display #__line__ ";mixer-inverse r~D: ~A * ~A -> ~A" k mx imx mmx))))
      
      (let ((fr (frame-reverse! (make-frame 2 .5 2.0))))
	(if (not (frame-equal? fr (make-frame 2 2.0 0.5)))
	    (snd-display #__line__ ";frame-reverse! 2: ~A" fr)))
      (let ((fr (frame-reverse! (make-frame 3 .5 1.0 2.0))))
	(if (not (frame-equal? fr (make-frame 3 2.0 1.0 0.5)))
	    (snd-display #__line__ ";frame-reverse! 3: ~A" fr)))
      
      (let ((hi (make-mixer 3 10 5 1 1 20 5 1 3 7))
	    (ho (make-mixer 3 10 5 2 1 3 2 1 3 2)))
	;; these adapted from gsl linalg tests
	(let ((val (mixer* hi ho)))
	  (if (not (mixer-equal? val (make-mixer 3 106.000 68.000 32.000  35.000 80.000 52.000  20.000 35.000 22.000)))
	      (snd-display #__line__ ";mixer* 3x3 1: ~A" val)))
	
	(let ((val (mixer* hi (mixer-transpose ho))))
	  (if (not (mixer-equal? val (make-mixer 3  127.000 27.000 27.000  120.000 71.000 71.000  39.000 24.000 24.000)))
	      (snd-display #__line__ ";mixer* 3x3 2: ~A" val)))
	
	(let ((val (mixer* (mixer-transpose hi) (mixer-transpose ho))))
	  (if (not (mixer-equal? val (make-mixer 3 107.000 15.000 15.000  156.000 71.000 71.000  49.000 30.000 30.000)))
	      (snd-display #__line__ ";mixer* 3x3 2: ~A" val))))
      
      ;; from Golub and van Loan:
      (let ((val (mixer-solve (make-mixer 2 .001 1.0 1.0 2.0) (make-frame 2 1.0 3.0))))
	(if (not (frame-equal? val (make-frame 2 1.002 0.999)))
	    (snd-display #__line__ ";mixer-solve G1: ~A" val)))
      (let ((val (mixer-solve (make-mixer 2 .0001 1.0 1.0 1.0) (make-frame 2 1.0 3.0))))
	(if (not (frame-equal? val (make-frame 2 2.000 1.000)))
	    (snd-display #__line__ ";mixer-solve G2: ~A" val)))
      (let ((val (mixer-solve (make-mixer 2 .986 .579 .409 .237) (make-frame 2 .235 .107))))
	(if (not (frame-equal? val (make-frame 2 2.000 -3.000)))
	    (snd-display #__line__ ";mixer-solve G3: ~A" val)))
      (let ((val (invert-matrix (make-mixer 3 2 -1 1  -1 1.0e-6 1.0e-6  1 1.0e-6 1.0e-6) (make-frame 3 (* 2 (+ 1 1.0e-6)) -1.0e-6 1.0e-6))))
	(if (or (not val)
		(not (frame-equal? (cadr val) (make-frame 3 0.000 -1.000 1.000))))
	    (snd-display #__line__ ";mixer-solve G4: ~A" val)))
      (let ((val (invert-matrix (make-mixer 3 2 -1 1  -1 1.0e-7 1.0e-7  1 1.0e-7 1.0e-7) (make-frame 3 (* 2 (+ 1 1.0e-7)) -1.0e-7 1.0e-7))))
	(if (or (not val)
		(not (frame-equal? (cadr val) (make-frame 3 0.000 -1.000 1.000))))
	    (snd-display #__line__ ";mixer-solve G5: ~A" val)))
      (let ((val (mixer-solve (make-mixer 3 1 4 7 2 5 8 3 6 10) (make-frame 3 1 1 1))))
	(if (not (frame-equal? val (make-frame 3 -0.333 0.333 -0.000)))
	    (snd-display #__line__ ";mixer-solve G6: ~A" val)))
      (let ((val (mixer-solve (make-mixer 2 1 0 0 1.0e-6) (make-frame 2 1 1.0e-6))))
	(if (not (frame-equal? val (make-frame 2 1.000 1.000)))
	    (snd-display #__line__ ";mixer-solve G7: ~A" val)))
      (let ((val (invert-matrix (make-mixer 2 1 0 0 1.0e-8) (make-frame 2 1 1.0e-8) 1.0e-10)))
	(if (or (not val)
		(not (frame-equal? (cadr val) (make-frame 2 1.000 1.000))))
	    (snd-display #__line__ ";mixer-solve G8: ~A" val)))
      (let ((val (invert-matrix (make-mixer 2 1 0 0 1.0e-12) (make-frame 2 1 1.0e-12) 1.0e-14)))
	(if (or (not val) 
		(not (frame-equal? (cadr val) (make-frame 2 1.000 1.000))))
	    (snd-display #__line__ ";mixer-solve G9: ~A" val)))
      (let ((val (mixer-solve (make-mixer 2 10 100000 1 1) (make-frame 2 100000 2))))
	(if (not (frame-equal? val (make-frame 2 1.000 1.000)))
	    (snd-display #__line__ ";mixer-solve G10: ~A" val)))
      
      (let ((val (frame-cross (make-frame 3 0 0 1) (make-frame 3 0 -1 0))))
	(if (not (frame-equal? val (make-frame 3 1.000 0.000 0.000)))
	    (snd-display #__line__ ";frame-cross: ~A" val)))
      
      (let ((val (frame-normalize (make-frame 3 4 3 0))))
	(if (not (frame-equal? val (make-frame 3 0.800 0.600 0.000)))
	    (snd-display #__line__ ";frame-normalize: ~A" val)))
      )
    
    (let ((gen (make-fft-window hamming-window 16)))
      (if (not (vequal gen (vct 0.080 0.115 0.215 0.364 0.540 0.716 0.865 1.000 1.000 0.865 0.716 0.540 0.364 0.215 0.115 0.080)))
	  (snd-display #__line__ ";hamming window: ~A" gen)))
    (let ((gen (make-fft-window rectangular-window 16)))
      (if (not (vequal gen (vct 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	  (snd-display #__line__ ";rectangular window: ~A" gen)))
    (let ((gen (make-fft-window hann-window 16)))
      (if (not (vequal gen (vct 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	  (snd-display #__line__ ";hann window: ~A" gen)))
    (let ((gen (make-fft-window welch-window 16)))
      (if (not (vequal gen (vct 0.000 0.234 0.438 0.609 0.750 0.859 0.938 1.000 1.000 0.938 0.859 0.750 0.609 0.438 0.234 0.000)))
	  (snd-display #__line__ ";welch window: ~A" gen)))
    (let ((gen (make-fft-window connes-window 16)))
      (if (not (vequal gen (vct 0.000 0.055 0.191 0.371 0.562 0.739 0.879 1.000 1.000 0.879 0.739 0.562 0.371 0.191 0.055 0.000)))
	  (snd-display #__line__ ";connes window: ~A" gen)))
    (let ((gen (make-fft-window parzen-window 16)))
      (if (not (vequal gen (vct 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display #__line__ ";parzen window: ~A" gen)))
    (let ((gen (make-fft-window bartlett-window 16)))
      (if (not (vequal gen (vct 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	  (snd-display #__line__ ";bartlett window: ~A" gen)))
    (let ((gen (make-fft-window blackman2-window 16)))
      (if (not (vequal gen (vct 0.005 0.020 0.071 0.177 0.344 0.558 0.775 1.000 1.000 0.775 0.558 0.344 0.177 0.071 0.020 0.005)))
	  (snd-display #__line__ ";blackman2 window: ~A" gen)))
    (let ((gen (make-fft-window blackman3-window 16)))
      (if (not (vequal gen (vct 0.000 0.003 0.022 0.083 0.217 0.435 0.696 1.000 1.000 0.696 0.435 0.217 0.083 0.022 0.003 0.000)))
	  (snd-display #__line__ ";blackman3 window: ~A" gen)))
    (let ((gen (make-fft-window blackman4-window 16)))
      (if (not (vequal gen (vct 0.002 0.002 0.003 0.017 0.084 0.263 0.562 1.000 1.000 0.562 0.263 0.084 0.017 0.003 0.002 0.002)))
	  (snd-display #__line__ ";blackman4 window: ~A" gen)))
    
    (let ((gen (make-fft-window blackman5-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.003 0.022 0.097 0.280 0.574 1.000 1.000 0.574 0.280 0.097 0.022 0.003 0.000 0.000)))
	  (snd-display #__line__ ";blackman5 window: ~A" gen)))
    (let ((gen (make-fft-window blackman6-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.001 0.011 0.064 0.223 0.520 1.000 1.000 0.520 0.223 0.064 0.011 0.001 0.000 0.000)))
	  (snd-display #__line__ ";blackman6 window: ~A" gen)))
    (let ((gen (make-fft-window blackman7-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.000 0.006 0.042 0.177 0.471 1.000 1.000 0.471 0.177 0.042 0.006 0.000 0.000 0.000)))
	  (snd-display #__line__ ";blackman7 window: ~A" gen)))
    (let ((gen (make-fft-window blackman8-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.000 0.003 0.028 0.141 0.426 1.000 1.000 0.426 0.141 0.028 0.003 0.000 0.000 0.000)))
	  (snd-display #__line__ ";blackman8 window: ~A" gen)))
    (let ((gen (make-fft-window blackman9-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.000 0.001 0.018 0.112 0.385 1.000 1.000 0.385 0.112 0.018 0.001 0.000 0.000 -0.000)))
	  (snd-display #__line__ ";blackman9 window: ~A" gen)))
    (let ((gen (make-fft-window blackman10-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.000 0.001 0.012 0.089 0.349 1.000 1.000 0.349 0.089 0.012 0.001 0.000 0.000 -0.000)))
	  (snd-display #__line__ ";blackman10 window: ~A" gen)))
    (let ((gen (make-fft-window rv2-window 16)))
      (if (not (vequal gen (vct 0.000 0.001 0.021 0.095 0.250 0.478 0.729 1.000 1.000 0.729 0.478 0.250 0.095 0.021 0.001 0.000)))
	  (snd-display #__line__ ";rv2 window: ~A" gen)))
    (let ((gen (make-fft-window rv3-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.003 0.029 0.125 0.330 0.622 1.000 1.000 0.622 0.330 0.125 0.029 0.003 0.000 0.000)))
	  (snd-display #__line__ ";rv3 window: ~A" gen)))
    (let ((gen (make-fft-window rv4-window 16)))
      (if (not (vequal gen (vct 0.000 0.000 0.000 0.009 0.062 0.228 0.531 1.000 1.000 0.531 0.228 0.062 0.009 0.000 0.000 0.000)))
	  (snd-display #__line__ ";rv4 window: ~A" gen)))
    
    (let ((gen (make-fft-window exponential-window 16)))
      (if (not (vequal gen (vct 0.000 0.087 0.181 0.283 0.394 0.515 0.646 0.944 0.944 0.646 0.515 0.394 0.283 0.181 0.087 0.000)))
	  (snd-display #__line__ ";exponential window: ~A" gen)))
    (let ((gen (make-fft-window riemann-window 16)))
      (if (not (vequal gen (vct 0.000 0.139 0.300 0.471 0.637 0.784 0.900 1.000 1.000 0.900 0.784 0.637 0.471 0.300 0.139 0.000)))
	  (snd-display #__line__ ";riemann window: ~A" gen)))
    (let ((gen (make-fft-window kaiser-window 16 2.5)))
      (if (not (vequal gen (vct 0.304 0.426 0.550 0.670 0.779 0.871 0.941 1.000 1.000 0.941 0.871 0.779 0.670 0.550 0.426 0.304)))
	  (snd-display #__line__ ";kaiser window: ~A" gen)))
    (let ((gen (make-fft-window cauchy-window 16 2.5)))
      (if (not (vequal gen (vct 0.138 0.173 0.221 0.291 0.390 0.532 0.719 1.000 1.000 0.719 0.532 0.390 0.291 0.221 0.173 0.138)))
	  (snd-display #__line__ ";cauchy window: ~A" gen)))
    (let ((gen (make-fft-window poisson-window 16 2.5)))
      (if (not (vequal gen (vct 0.082 0.112 0.153 0.210 0.287 0.392 0.535 1.00