/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick, Jan Struyf          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include "ag_defs.h"

#include "stockbutton.h"
#include "keytable.h"
#include "preferences.h"
#include "modes_menu.h"
#include "handlers.h"
#include "hstack.h"
#include "ag_status.h"




static gchar *angle_item_list[] = {
	"Deg ", "Rad ", "Grad", 0
};

// Hex, Bin & Oct added by Jan Struyf
static gchar *format_item_list[] = {
	"Std", "Fix", "Sci", "Eng", "Hex", "Bin", "Oct", 0
};

static gchar *formatSize_item_list[] = {
	"12", "11", "10", "09", "08", "07", 
	"06", "05", "04", "03", "02", "01",
	"00", 0
};


/******************************/
/* The arrys for the keyboard */
/******************************/

/* The numeric keytable */
gchar *nums_label[] = { 
	"7" , "4" , "1" , "0",
	"8" , "5" , "2" , ".",
	"9" , "6" , "3" , " EE " };

gchar *nums_data[] = { 
	"7" , "4" , "1" , "0" ,
	"8" , "5" , "2" , "." ,
	"9" , "6" , "3" , "e" };
	
gint nums_map[] = {
	AG_KEY_7, AG_KEY_4, AG_KEY_1, AG_KEY_0,
	AG_KEY_8, AG_KEY_5, AG_KEY_2, AG_KEY_DOT,
	AG_KEY_9, AG_KEY_6, AG_KEY_3, AG_KEY_NONE };

/* Senoidal functions keytable */
gchar *sins_label[] = { 
	"sin" , "asin" , "sinh" ,
	"cos" , "acos" , "cosh" ,
	"tan" , "atan" , "tanh" };

gchar *sins_data[] = { 
	"sin(" , "asin(" , "sinh(" ,
	"cos(" , "acos(" , "cosh(" ,
	"tan(" , "atan(" , "tanh(" };

/* Operators keytable */
gchar *opers_label[] = { 
	"Del" , "*", 
	"-"   , "+", 
	"AC"  , "^", 
	"/"   , "Exe"};
	
gint opers_map[] = {
	AG_KEY_DEL, AG_KEY_MUL,
	AG_KEY_MINUS, AG_KEY_PLUS,
	AG_KEY_AC, AG_KEY_POW,
	AG_KEY_DIV, AG_KEY_EXE };

/* Parentesis keytable */
gchar *parens_label[] = { 
	"(" , ")" };

gint parens_map[] = {
	AG_KEY_P_OPEN, AG_KEY_P_CLOSE };


/* Constants keytable */
gchar *csts_label[] = { 
	"pi" , "e"};

gchar *csts_data[] = { 
	"3.14159265359" , "2.71828182846"};

/* Square and square root */
gchar *sqrs_label[] = { 
	"sq" , "sqrt"};

gchar *sqrs_data[] = { 
	"sq(" , "sqrt(" };

/* Some other functions */
gchar *funs_label[] = { 
	"abs" , "neg", "inv" ,"!" };

gchar *funs_data[] = { 
	"abs(" , "neg(", "inv(" ,"!" };

/* Exponencial functions */
gchar *exps_label[] = { 
	"exp", 
        "ln", 
        "log" };
	
gchar *exps_data[] = { 
     "exp(", 
     "ln(", 
     "log(" };	
	
/* Boolean functions - By Jan Struyf */
gchar *bool_label[] = { 
	"or", "and", "xor",
	"h", "b", "o" };
	
gchar *bool_data[] = { 
	" or ", " and ", " xor ",
	"h","b","o" };

/********************************/
/*  Global variables & Widgets  */
/********************************/

extern GtkWidget    *input_text;
extern GtkWidget    *output_text;
extern AgModePref    mode_prefs;

extern gint exe_state;

/*
 * Copy result to clipboard
 */	     
void 
ag_edit_copy(GtkWidget        *widget, 
	     gpointer          data) 
{
	gint len = gtk_text_get_length(GTK_TEXT(output_text));
	if (len != 0) {
		gtk_editable_select_region(GTK_EDITABLE(output_text), 0, len);
		gtk_editable_copy_clipboard(GTK_EDITABLE(output_text));
	}
}

/*
 * Paste clipboard contents
 */	     
void 
ag_edit_paste(GtkWidget        *widget, 
	      gpointer          data)
{
	gtk_editable_paste_clipboard(GTK_EDITABLE(input_text));
}

/*    
 * ag_create_display
 * Create the display, that consists in a box containing
 * the input and ouput text, and a scrollbar adjusting 
 * the input text.
 */
GtkWidget *
ag_create_display(void)
{
	GtkWidget    *display;
	GtkWidget    *vscrollbar;
       	GtkWidget    *vpaned;
	
	display = gtk_hbox_new(FALSE, 0);
	
	vpaned = gtk_vpaned_new();
	gtk_box_pack_start(GTK_BOX(display),vpaned,TRUE,TRUE,0); 
	
	input_text = gtk_text_new (NULL,NULL);
	gtk_paned_pack1(GTK_PANED(vpaned),input_text,TRUE,TRUE);
	gtk_widget_set_usize(input_text,279,100);  
	
	output_text = gtk_text_new (NULL,NULL);
	gtk_paned_pack2(GTK_PANED(vpaned),output_text,FALSE,FALSE);
	gtk_widget_set_usize(output_text,279,20);
	
	vscrollbar = gtk_vscrollbar_new(GTK_TEXT(input_text)->vadj);
	gtk_box_pack_start(GTK_BOX(display),vscrollbar,FALSE,FALSE,0);   
	
	gtk_widget_show(vscrollbar);
	gtk_widget_show(input_text);
	gtk_widget_show(output_text);
	gtk_widget_show(vpaned);
	
	return display;
}


/*
 * ag_create_mode_menus
 * Create the option menus, that have control 
 * over the calculator modes.
 */
GtkWidget *
ag_create_mode_menus(void)
{
	
	GtkWidget   *box;
	GtkWidget   *angle_label;
	GtkWidget   *angle_menu;
	GtkWidget   *format_label;
	GtkWidget   *format_menu;
	GtkWidget   *size_menu;
	
	
	box = gtk_hbox_new(FALSE, 0);
	
	angle_label = gtk_label_new("Angle:");
	gtk_box_pack_start_defaults(GTK_BOX(box),angle_label);
	
	angle_menu = ag_create_option_menu(angle_item_list,
					   mode_prefs.angle,
					   AG_OPTION_MENU_FUNC(ag_mode_angle_choosen));  
	gtk_box_pack_start_defaults(GTK_BOX(box),angle_menu);

	format_label = gtk_label_new(" Format:");
	gtk_box_pack_start_defaults(GTK_BOX(box),format_label);
	
	format_menu = ag_create_option_menu(format_item_list,
					    mode_prefs.format,
					    AG_OPTION_MENU_FUNC(ag_mode_format_choosen));
	gtk_box_pack_start_defaults(GTK_BOX(box),format_menu);	
	
	size_menu = ag_create_option_menu(formatSize_item_list,
					  mode_prefs.size,
					  AG_OPTION_MENU_FUNC(ag_mode_size_choosen));
	gtk_box_pack_start_defaults(GTK_BOX(box),size_menu);
	
	
	gtk_widget_show(angle_label);
	gtk_widget_show(angle_menu);
	gtk_widget_show(format_label);
	gtk_widget_show(format_menu);
	gtk_widget_show(size_menu);
	
	return  box;
}



/*
 * ag_create_command_keypath
 * Create and pack in a box, the keys corresponding
 * to various different commands, such as history and
 * cursor keys.
 */
GtkWidget *
ag_create_command_keypath(void)
{

	GtkWidget   *keypath;
	GtkWidget   *cursor_box;
	GtkWidget   *back_button; 
	GtkWidget   *for_button;
	GtkWidget   *history_box;
	GtkWidget   *hup_button; 
	GtkWidget   *hdown_button;
	GtkWidget   *ans_button;
	

	
	keypath = gtk_hbox_new(FALSE, 3);
	
	cursor_box = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(keypath),cursor_box,FALSE,FALSE,0);   
	
	back_button = ag_button_with_stock_n_label(GNOME_STOCK_MENU_BACK,"Back");
	gtk_box_pack_start(GTK_BOX(cursor_box),back_button,TRUE,TRUE,0 ); 
	gtk_signal_connect_object(GTK_OBJECT(back_button),"clicked",
				  ag_handler_cursor_backward,NULL);
	ag_set_button_map(AG_KEY_BACKWARD, back_button);

	for_button = ag_button_with_label_n_stock(GNOME_STOCK_MENU_FORWARD,"For");
	gtk_box_pack_start(GTK_BOX(cursor_box),for_button,TRUE,TRUE,0 );
	gtk_signal_connect_object(GTK_OBJECT(for_button),"clicked",
				  ag_handler_cursor_forward,NULL);
	ag_set_button_map(AG_KEY_FORWARD, for_button);
	
	history_box = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(keypath),history_box,FALSE,FALSE,0);
	
	hup_button = ag_button_with_label_n_stock(GNOME_STOCK_MENU_UP,"History");
	gtk_box_pack_start(GTK_BOX(history_box),hup_button,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(hup_button),"clicked",
			   ag_handler_hstack_up,NULL);
	ag_set_button_map(AG_KEY_H_UP, hup_button);

	hdown_button = ag_button_with_label_n_stock(GNOME_STOCK_MENU_DOWN,"History");
	gtk_box_pack_start(GTK_BOX(history_box),hdown_button,TRUE,TRUE,0); 
	gtk_signal_connect(GTK_OBJECT(hdown_button),"clicked",
			   ag_handler_hstack_down,NULL);
	ag_set_button_map(AG_KEY_H_DOWN, hdown_button);
	
	ans_button = gtk_button_new_with_label("Ans");
	gtk_box_pack_start(GTK_BOX(keypath),ans_button,TRUE,TRUE,0); 
	gtk_signal_connect_object(GTK_OBJECT(ans_button),"clicked",
				  GTK_SIGNAL_FUNC(ag_handler_ans),NULL);
	
	gtk_widget_show(cursor_box);
	gtk_widget_show(back_button); 
	gtk_widget_show(for_button);
	gtk_widget_show(history_box);
	gtk_widget_show(hup_button); 
	gtk_widget_show(hdown_button);
	gtk_widget_show(ans_button);
	
	return  keypath;
}



/*
 * ag_create_misc_keypath
 * Create and pack in a box, the keys corresponding
 * to miscelaneous stuff, such as parens and the
 * "PI" an "e" constants.
 */
GtkWidget *
ag_create_misc_keypath(void)
{
	
	GtkWidget   *keypath;
	GtkWidget   *csts;
	GtkWidget   *parens;
	GtkWidget   *sqrs;
	GtkWidget   *funs;
		
	keypath = gtk_hbox_new(FALSE, 3); 
	
	csts = ag_make_keytable(1, 2, csts_label, csts_data, NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),csts,TRUE,TRUE,0 ); 
	
	parens = ag_make_keytable(1, 2, parens_label, parens_label, parens_map,
				  AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),parens,TRUE,TRUE,0); 
	
	sqrs = ag_make_keytable(1, 2, sqrs_label, sqrs_data, NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),sqrs,TRUE,TRUE,0 ); 
	
	funs = ag_make_keytable(1,4,funs_label,funs_data, NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),funs,TRUE,TRUE,0 ); 

	
	gtk_widget_show(csts);
	gtk_widget_show(parens);
	gtk_widget_show(sqrs);
	gtk_widget_show(funs);


	return keypath;
}


/* 
 * ag_create_std_keypath
 * Create and pack in a box, the keys corresponding
 * to the functions, numeric keypath and opers.
 */
GtkWidget *
ag_create_std_keypath(void)
{

	GtkWidget   *keypath;
	GtkWidget   *nums;
	GtkWidget   *opers;
	GtkWidget   *exps;
	GtkWidget   *bools;
	GtkWidget   *sins;

	
	keypath = gtk_hbox_new(FALSE, 3); 
	
	nums = ag_make_keytable(4,3,nums_label,nums_data,nums_map,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),nums,TRUE,TRUE,0); 
	
	opers = ag_make_keytable(4,2,opers_label,opers_label,opers_map,
				 AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),opers,TRUE,TRUE,0); 
	
	exps = ag_make_keytable(3,1,exps_label,exps_data,NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),exps,TRUE,TRUE,0); 
	
	sins = ag_make_keytable(3,3,sins_label,sins_data,NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),sins,TRUE,TRUE,0); 
	
	bools = ag_make_keytable(3,2,bool_label,bool_data,NULL,
				AG_KPATH_HANDLER_FUNC(ag_keypath_handler));
	gtk_box_pack_start(GTK_BOX(keypath),bools,TRUE,TRUE,0); 
		
       	gtk_widget_show(nums);
	gtk_widget_show(opers);
	gtk_widget_show(exps);
	gtk_widget_show(sins);
	gtk_widget_show(bools);		
		
	return keypath;
}


/*
 * ag_create_keyboard
 * Pack in a box all the diferent keypaths
 */
GtkWidget *
ag_create_keyboard(void)
{
	
	GtkWidget   *keyboard;
	GtkWidget   *command;
	GtkWidget   *misc;
	GtkWidget   *std;


	keyboard = gtk_vbox_new(FALSE, 3); 
	
	command = ag_create_command_keypath();
	gtk_box_pack_start(GTK_BOX(keyboard),command,FALSE,FALSE,0);

	misc = ag_create_misc_keypath();
	gtk_box_pack_start(GTK_BOX(keyboard),misc,FALSE,FALSE,0);
	
	std = ag_create_std_keypath();
	gtk_box_pack_start(GTK_BOX(keyboard),std,FALSE,FALSE,0);


	gtk_widget_show(command);
	gtk_widget_show(misc);
	gtk_widget_show(std);
	

	return keyboard;
}


/*
 * ag_create_calc
 * Putit all together, the mode menus, the dispay and the keyboard. 
 * Now we have the calculator!!.
 */
GtkWidget *
ag_create_calc(void)
{

	GtkWidget   *calc;
	GtkWidget   *modes;
	GtkWidget   *display;
	GtkWidget   *keyboard;

	
	calc = gtk_vbox_new(FALSE,3);
	gtk_container_set_border_width(GTK_CONTAINER(calc),3);
	
	modes = ag_create_mode_menus();
	gtk_box_pack_start(GTK_BOX(calc),modes,FALSE,FALSE,0);	

	display = ag_create_display();
	gtk_box_pack_start(GTK_BOX(calc),display,TRUE,TRUE,0);	
	
	keyboard = ag_create_keyboard();
	gtk_box_pack_start(GTK_BOX(calc),keyboard,FALSE,FALSE,0);	
	
	
	gtk_widget_show(modes);
	gtk_widget_show(display);
	gtk_widget_show(keyboard);
	
	
	return calc;
}


/*
 * ag_create_algnomegebraic
 * Get the preferences from the config file,
 * create the calc, and init the stack
 */
GtkWidget *
ag_create_algnomegebraic(void)
{
	GtkWidget *ag;
	
	ag_get_preferences();
	ag = ag_create_calc();
	ag_set_text_style();
	ag_status_prepare_display();
	ag_history_stack_init();
	
	return ag;
}
