/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gnome.h>
#include "ag_defs.h"
#include "ag_text.h"
#include "errorstring.h"



extern GtkWidget   *input_text;
extern GtkWidget   *output_text;
extern AgError      errState;
extern gint         exe_state;



/*
 * ag_update_display
 * clears the output and input texts when needed,
 * it's called every time a button or key is pressed
 */
void
ag_status_prepare_display()
{
	if(exe_state){ 
		ag_text_ac_input(GTK_TEXT(input_text));
		ag_text_delete_all(GTK_TEXT(output_text));
		
	} else if (errState.state) 
		ag_text_delete_all(GTK_TEXT(output_text));
}


/*
 * ag_expr_modified
 * clears exe_sate and errState
 * redraws the text with no special attributes when needed
 * called every time the expression is modified
 */
void
ag_status_expr_modified()
{
	if(exe_state){
		exe_state = 0;
		return;
	}
	
	if(errState.state){
		
		gchar    *str;
		gint      pos;
		
		
		/* Clear the error */
		errState.state = 0;
		errState.start = 0;
		errState.end = 0;
		
		pos = gtk_text_get_point(GTK_TEXT(input_text));
		str = gtk_editable_get_chars(GTK_EDITABLE(input_text),0,-1);
		
		gtk_text_set_point(GTK_TEXT(input_text),0);
		gtk_text_forward_delete(GTK_TEXT(input_text),
					gtk_text_get_length(GTK_TEXT(input_text)));
		
		/* Now, rewrite the whole thext with no special attributes,
		 * dont forget the cursor */
		ag_text_insert(GTK_TEXT(input_text),str,pos); 
		ag_text_insert_cursor(GTK_TEXT(input_text),&str[pos]); 
		ag_text_insert(GTK_TEXT(input_text),&str[pos+1],-1); 
		
		g_free(str);
		
		/* Put the insertion point back to what it was */
		gtk_text_set_point(GTK_TEXT(input_text),pos);
	}
}


