/*==================================================================
 * pcm.h - Driver independent PCM audio routines header
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __PCM_H__
#define __PCM_H__

#include <glib.h>

#include "config.h"

enum
{ PCM_NONE,

/* disabled */
#if 0
#ifdef ALSA_SUPPORT
  PCM_ALSA,
#endif
#ifdef OSS_SUPPORT
  PCM_OSS,
#endif
#endif

  PCM_COUNT
} PCMType;


typedef gint (PCMPlayBackFunc)(gint count, void *buf);

typedef struct _PCMDriverInfo
{
  gchar *name;			/* textual name of driver */
  void (*config) (void);	/* Load smurfcfg vars for driver */
  gint (*play) (gint width, gboolean signd, gint chans, gint rate,
		PCMPlayBackFunc *play_func); /* Play audio */
  void (*stop) (void);		/* stop play in progress */
} PCMDriverInfo;

/* data */

extern PCMDriverInfo pcm_drivers[];

gint pcm_driver;
gboolean pcm_active;
gboolean pcm_playing;

/* function prototypes */

gint pcm_select_from_config (void);
gint pcm_auto_select (void);
gint pcm_locate_byname (gchar * name);
void pcm_set_driver (gint driver);
gint pcm_play (gint width, gboolean signd, gint chans, gint rate,
	       PCMPlayBackFunc *play_func);
void pcm_stop (void);

#endif /* __PCM_H__ */
