/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: smtpguard.h,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _SMTPGUARD_H
#define _SMTPGUARD_H

#include <smtpguard/fg-smtp-info.h>
#include <smtpguard/fg-protocol-xml.h>

#define SELECT_TRY_MAX 1

char	spam_errmsg[1024];
int smtpguard_debug_level;
extern unsigned int sg_log_pri;

#ifndef FG_DISABLE_DEPRECATED
typedef struct _smtp_info_data SmtpInfoData;
typedef SmtpInfoData smtp_info_data_t;

struct _smtp_info_data {
	char *ip;
	unsigned char ip_len;
	unsigned long pid;
	unsigned char s_flag;
	char *mailfrom;
	unsigned char mailfrom_len;
	char *rcptto;
	unsigned char rcptto_len;
	unsigned char c_flag;
	unsigned char h_flag;
	unsigned long waittime;
	char *message;
	unsigned char message_len;
};

int spam_update_db (SmtpInfoData *sid);
void free_smtp_info_data (SmtpInfoData *sid);
#endif /* FG_DISABLE_DEPRECATED */

int fg_spam_update_db (FGSmtpInfo *fsi, GError **error);

#endif
