#!/bin/sh
#Do not run directly. This is a helper script for make.

copy()
{
  if [ -f $2 ]; then
    echo "  skipped $2, file already exists"
  else  
    echo "  $2"
    cp $1 $2
  fi        
}

forcecopy()
{
  if [ -f $2 ]; then
    echo "  Overwriting $2"
    cp $1 $2
  else
    echo "  $2"
    cp $1 $2
  fi
}

echo ""
if [ ! -f bin/smsd ]; then 
  echo 'Please run "make compile" first.'
  exit 1
fi

echo "Installing binary program files"
[ -d /usr/local ] || mkdir /usr/local
[ -d /usr/local/bin ] || mkdir /usr/local/bin
forcecopy bin/smsd /usr/local/bin/smsd
forcecopy bin/getsms /usr/local/bin/getsms
forcecopy bin/putsms /usr/local/bin/putsms

echo "Installing some scripts"
if which pkill >/dev/null; then
  echo "  skipped pkill, system als already a pkill command"
else
  copy scripts/pkill /usr/local/bin/pkill
fi
copy scripts/sendsms /usr/local/bin/sendsms
copy scripts/sms2html /usr/local/bin/sms2html
copy scripts/sms2unicode /usr/local/bin/sms2unicode
copy scripts/unicode2sms /usr/local/bin/unicode2sms

echo "Installing config file"
copy examples/smsd.conf.easy /etc/smsd.conf

echo "Installing start-script"
[ -d /etc/init.d ] && copy scripts/sms /etc/init.d/sms 
[ -d /sbin/init.d ] && copy scripts/sms /sbin/init.d/sms

echo "Creating minimum spool directories"
[ -d /var/spool ] || mkdir /var/spool
[ -d /var/spool/sms ] || mkdir /var/spool/sms
[ -d /var/spool/sms/incoming ] || mkdir /var/spool/sms/incoming
[ -d /var/spool/sms/outgoing ] || mkdir /var/spool/sms/outgoing
[ -d /var/spool/sms/checked ]  || mkdir /var/spool/sms/checked

echo ""
echo "Example script files are not installed automatically."
echo 'Please dont forget to edit /etc/smsd.conf.'
