#include <stdio.h>
#include "o2uk.h"

using namespace std;

O2ukSMS::O2ukSMS(Config &config) : GenericSMS(config)
{
	sendmail_path = config["sendmail_path"];
	email = config["mailaddr"];
}

bool O2ukSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	string cmd, buffer;
	FILE *pf;

	cmd = sendmail_path + " -f \"" + email + "\" -t";
	if ((pf = popen(cmd.c_str(), "w"))) {
		buffer = "From: " + email + "\nTo: " + phone_no + "@o2.co.uk\n" +
			"Subject: " + message + "\n\n" + message + "\n.\n";
		ok = fprintf(pf, "%s", buffer.c_str()) == (int)buffer.length();
		pclose(pf);
		if (!ok) throw Exception("[1] - popen()");
	}
	
	return ok;
}

