#include "mr_pcre/mr_pcre.h"
#include "era.h"

using namespace std;

EraSMS::EraSMS(Config &config) : GenericSMS(config)
{
	omnix_user = config["omnix_user"];
	omnix_pass = config["omnix_pass"];
}


bool EraSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok;
	CURLcode status;
	Curl_Form form;
	string token;
	long int remaining, remainingAfterSend;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.UserAgent("Mozilla/5.0 Galeon/1.2.7 (X11; Linux i686; U;) Gecko/20021216");
	curl.SetOpt(CURLOPT_COOKIEFILE, "");

	status = curl.PerformGet("http://www.eraomnix.pl/sso2/r_login.do?turl="
		"http://www.eraomnix.pl/msg/user/sponsored/welcome.do?sn=Mojprofil"
		"&mg_id=4095&mg_ch=WWW&partnerlogin=test");
	if (status) 
		throw Exception("[1] - get http://www.eraomnix.pl/sso2/r_login.do?"
				"turl=http://www.eraomnix.pl/msg/user/sponsored/welcome.do?"
				"sn=Mojprofil&mg_id=4095&mg_ch=WWW&partnerlogin=test");

	status = curl.PerformGet("http://www.eraomnix.pl/sso2/omnix_iframe/login.jsp");
	if (status)
		throw Exception("[1] - get http://www.eraomnix.pl/sso2/omnix_iframe/login.jsp");

	PcreWrap::Array match;

	if (PcreWrap::pcre_match_all("TOKEN\" value=\"(.*)\"", curl.Body(), "", match)) 
		token = match[0][0];
	else
		throw Exception("[2] - nie widz tokena?!");

	form.AddField("login", omnix_user);
	form.AddField("password", omnix_pass);
	form.AddField("org.apache.struts.taglib.html.TOKEN", token);
	
	status = curl.PerformPost("http://www.eraomnix.pl/sso2/authenticate.do", 
		form.PostFields());
	if (status)
		throw Exception("[2] - post http://www.eraomnix.pl/sso2/authenticate.do");

	if (PcreWrap::pcre_match_all("Pozosta.o SMS.w: <b>([0-9]+)</b>", 
		curl.Body(), "mi", match)) {
		remaining = strtol(match[0][0].c_str(), NULL, 10);
	} else
		throw Exception("[2] - Bd przy logowaniu");
	
	if (remaining < 0)
		throw Exception("[2] - nie mona odczyta limitu wiadomoci");
	if (remaining == 0)
		throw Exception("[2] - Limit wiadomoci na ten miesic przekroczony");
	
	if (PcreWrap::pcre_match_all("TOKEN\" value=\"(.*)\"", curl.Body(), "mi",
		match))
		token = match[0][0].c_str();
	else
		throw Exception("[2] - nie widz tokena?!");
	
	form.Reset();
	form.AddField("top.phoneReceiver", phone_no.substr(3));
	form.AddField("top.text", message);
	form.AddField("org.apache.struts.taglib.html.TOKEN", token);
	form.AddField("top.signature", "");
	form.AddField("top.characterLimit", "99");
	form.AddField("send", "0");
	form.AddField("mmsTab", "mmsTab");
	form.AddField("send_x", "15");
	form.AddField("send_y", "13");

	status = curl.PerformPost("http://www.eraomnix.pl/msg/user/sponsored/sms.do", 
		form.PostFields());
	if (status)
		throw Exception("[3] - http://www.eraomnix.pl/msg/user/sponsored/sms.do");
	
	if (PcreWrap::pcre_match_all("Pozosta.o SMS.w: <b>([0-9]+)</b>", curl.Body(),
		"mi", match))
		remainingAfterSend = strtol(match[0][0].c_str(), NULL, 10);
	else
		throw Exception("[3] - nie mona odczyta limitu wiadomoci");

	if (remainingAfterSend < 0)
		throw Exception("[3] - nie mona odczyta limitu wiadomoci");
	if (remaining <= remainingAfterSend)
		throw Exception("[3] - STATUS NIEZNANY, nie wiadomo czy wiadomo zostaa wysana");
	
	status = curl.PerformGet("http://www.eraomnix.pl/login/logout.do");
	if (status)
		throw Exception("4 - SMS wysany, ale bd podczas wylogowywania");

	return ok;
}

bool EraSMS::ShowStats()
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	string token;
	long int remaining;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.UserAgent("Mozilla/5.0 Galeon/1.2.7 (X11; Linux i686; U;) Gecko/20021216");
	curl.SetOpt(CURLOPT_COOKIEFILE, "");

	status = curl.PerformGet("http://www.eraomnix.pl/sso2/r_login.do?turl="
		"http://www.eraomnix.pl/msg/user/sponsored/welcome.do?sn=Mojprofil"
		"&mg_id=4095&mg_ch=WWW&partnerlogin=test");
	if (status) 
		throw Exception("[1] - get http://www.eraomnix.pl/sso2/r_login.do?"
				"turl=http://www.eraomnix.pl/msg/user/sponsored/welcome.do?"
				"sn=Mojprofil&mg_id=4095&mg_ch=WWW&partnerlogin=test");

	status = curl.PerformGet("http://www.eraomnix.pl/sso2/omnix_iframe/login.jsp");
	if (status)
		throw Exception("[1] - get http://www.eraomnix.pl/sso2/omnix_iframe/login.jsp");

	PcreWrap::Array match;

	if (PcreWrap::pcre_match_all("TOKEN\" value=\"(.*)\"", curl.Body(), "", match)) 
		token = match[0][0];
	else
		throw Exception("[2] - nie widz tokena?!");

	form.AddField("login", omnix_user);
	form.AddField("password", omnix_pass);
	form.AddField("org.apache.struts.taglib.html.TOKEN", token);
	
	status = curl.PerformPost("http://www.eraomnix.pl/sso2/authenticate.do", 
		form.PostFields());
	if (status)
		throw Exception("[2] - post http://www.eraomnix.pl/sso2/authenticate.do");

	if (PcreWrap::pcre_match_all("Pozosta.o SMS.w: <b>([0-9]+)</b>", 
		curl.Body(), "mi", match)) {
		remaining = strtol(match[0][0].c_str(), NULL, 10);
		ok = true;
	} else
		throw Exception("[2] - Bd przy logowaniu");
	
	cout << "Pozostao SMSw: " << remaining << endl;

    status = curl.PerformGet("http://www.eraomnix.pl/login/logout.do");
	
	return ok;
}
