#ifndef __sms_h
#define __sms_h

#include "debug.h"

using namespace std;

#define VER "1.9.2d"

// czas (sek) po ktorym proces zostanie i tak zabity. jest to chamski
// ale skuteczny sposob na ubijanie wiszacych procesow :-)
#define ALARM 120

// rozmiar wiadomosci na ktore jest dzielony wiekszy SMS
#define MAX_SPLIT_BUFF 160
// max ilosc na ktora mozna podzielic sms'a
#define MAX_NSPLIT 1

// do stalych ponizej mozna wpisac swoj numer ICQ oraz haslo.
// dane te mozna tez wpisac do pliku konfiguracyjnego ~/.smsrc
#define ICQ_UIN	""
#define ICQ_PASS ""

// do stalych ponizej mozna wpisac swoj login w Idea.czat oraz haslo
// dane te mozna tez wpisac do pliku konfiguracyjnego ~/.smsrc
#define CZAT_LOGIN ""
#define CZAT_PASS ""

// parametry logowania do serwisu Era Omnix (bramka bezplatna) - wpisuje
// sie je takze do pliku ~/.smsrc
// OMNIX_LOGIN - numer telefonu w sieci ERA (z 48 na poczatku)
#define OMNIX_LOGIN ""
#define OMNIX_PASS ""

// do stalych ponizej mozna wpisac swoj login w 1rstwap oraz haslo
// dane te mozna tez wpisac do pliku konfiguracyjnego ~/.smsrc
#define WAP_LOGIN ""
#define WAP_PASS ""

#define SMS_RC "/etc/smsrc"

#if defined(__NetBSD__) || defined(__OpenBSD__) || defined(__FreeBSD__)
#define SENDMAIL_PATH "/usr/sbin/sendmail"
#else
#define SENDMAIL_PATH "/usr/lib/sendmail"
#endif

#undef MR_DEBUG

extern Debug *debug_stream;

typedef struct {
	char w3cache_host[80];
	int  w3cache_port;
	char icq_uin[30],
	     icq_pass[30],
	     mailaddr[40],
	     notifyaddr[40];
	int plus_mail;
	char srcip[16],
             sign[11],
	     czat_login[40],
             dlogin[40],
	     czat_pass[40],
	     omnix_login[40],
	     omnix_pass[40],
	     wap_login[40],
	     wap_pass[40];

} TKonfig;

typedef struct {
	char *telefon;
	char *wiadomosc;
	char *potwierdzenie;
	int nsplit;
	int max_len;
} SMS_packet;

typedef int (*sms_func)(SMS_packet *sms);

extern TKonfig konfig;


void pobierz_adres_email(char *buf, int size, const char *def);
void pobierz_adres_notify(char *buf, int sizebuf, char *flag, char *def);

// wysyla wiadomosc dzielac ja w razie potrzeby na porcie po max_len
// znakow. wysyla za pomoca funkcji podanej w trzecim parametrze (WyslijSMS_*). 
// wiadomosc jest dzielona jesli przekorczy max_len znakow dlugosci - chodzi
// o to, zeby nie dzielic wiadomosci do tych operatorow, ktorych bramki
// same to potrafia zrobic
int WyslijSMS(sms_func gsm, SMS_packet *sms);
int poprawna_odpowiedz(const char *ok, const char *numer, const char *body);
 
#endif
