/*
 * autor modulu wysylajacego przez bramke ICQ:
 * 	Jaroslaw Wrzesien <wrzesien@poland.com>
 *
"--icq      : sms jest wysylany przez bramke ICQ; do pliku konfiguracyjnego\n"\
"             nalezy wtedy wpisac swoj numer ICQ oraz haslo\n"\

 */
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include "sms.h"

#define FAILURE   1
#define NETERR    2
#define SUCCESS   0
#define NOTUB     3
#define CIAGPUSTY 4


int netsend(char *host, int port, char *getline, char *outbuf, unsigned maxolen){  
  int sd, i, j, rem_port;
  struct sockaddr local, remote;
  struct hostent *hostinfo;
  int length,k;
  char response[1024];
  
  sd=i=j=0;
  rem_port=port;
  
  memset(&local, 0, sizeof(local));
  memset(&remote, 0, sizeof(remote));
  memset(&hostinfo, 0, sizeof(hostinfo));


  if((sd=socket(AF_INET, SOCK_STREAM, 0))==-1){
    perror("socket");
    return(NETERR);
  }
  
  local.sa_family = AF_INET;
  memset(local.sa_data, 0, sizeof(local.sa_data));
  
  if (bind (sd, &local, sizeof (local))<0){
    perror("bind");
    close(sd);
    return(NETERR);
  }

  hostinfo = gethostbyname (host);

  if (!hostinfo){
    perror(host);
    close(sd);
    return NETERR;
  }
 
  remote.sa_family = hostinfo->h_addrtype;
 
  for ( j = 0; j < hostinfo->h_length; j++ ){
    remote.sa_data[j+2] = hostinfo->h_addr_list[0][j];
  }
  
  remote.sa_data[0] = rem_port >> 8;
  remote.sa_data[1] = (rem_port&255);

  if (connect (sd, &remote, sizeof(remote))!=0){
    perror(host);
    close(sd);
    return(NETERR);
  }

  if (send (sd, getline, strlen(getline), 0)<0){
    perror("send");
    close(sd);
    return(NETERR);
  }

  memset(outbuf, 0,  maxolen);
  i=0;
  
  while ((length=recv(sd, response, sizeof(response)-2,0)) > 0){
    response[length] = '\0';
    if(outbuf!=NULL){
        strncpy(outbuf+i, response, maxolen);
        maxolen -= length;
        i += length;
     }
     if (strstr(outbuf,"</html>")!=NULL || strstr(outbuf,"</HTML>")!=NULL) break;
  }

  close (sd);

  return SUCCESS;
}


void urlencodemessage(char *obuf, const char *ibuf){

  int i,j;
  unsigned c1, c2;
  char pom;

  i=j=0;

  while (ibuf[i] != '\0'){
    pom=ibuf[i++];
    if (isalpha(pom) || isdigit(pom)){
      obuf[j++] = pom;
      continue;
    }
    if (pom == ' '){
      obuf[j++] = '+';
      continue;
    }
    obuf[j++] = '%';
    c1=((pom & 0xf0) >> 4);
    c2=(pom & 0x0f);
    if (c1<10)
      obuf[j++] = c1+'0';
    else
      obuf[j++] = c1+'A'-10;
    if (c2<10)
      obuf[j++] = c2+'0';
    else
      obuf[j++] = c2+'A'-10;
  }
  obuf[j] = '\0';
}

void splitphone(char *number, char *prefix, const char *phone){
  if (*phone == '+') phone++;
  if (*phone == '4') phone+=2;
  strncpy(prefix,phone,3);
  phone+=3;
  strcpy(number,phone);
}


int sendsms (const char *sms, const char *phone){

  char getline[10000];
  char message_buf[10000];
  char recv_buf[100000];
  char cookie1[300];
  char cookie2[300];
  char cookie3[300];
  char *result;
  char prefix[5];
  char number[20];
  int i,j;
  
  // do prefix idzie 3 cyfrowy kod operatora, do number reszta numeru
  splitphone(number,prefix,phone);
 
  sprintf(message_buf,"uService=1&uLogin=%s&uPassword=%s",konfig.icq_uin,konfig.icq_pass);
  sprintf(getline, "POST /karma/dologin/1,,,00.html HTTP/1.0\r\nConnection: close\r\nHost: web.icq.com\r\nContent-type: application/x-www-form-urlencoded\r\nContent-length: %d\r\n\r\n%s",strlen(message_buf), message_buf);
  if (netsend("mobile.icq.com",80,getline, recv_buf, 100000))
    return NETERR;

  if ((result=strstr(recv_buf, "KarmaLogin="))!=NULL){
    for (j=0;result[j]!='\n' && j<300;j++)
      cookie1[j]=result[j];
    cookie1[j]='\0';
  }
  else
    exit(FAILURE);

  if ((result=strstr(recv_buf, "KarmaService1="))!=NULL){
    for (j=0;result[j]!='\n' && j<300;j++)
      cookie2[j]=result[j];
    cookie2[j]='\0';
  }
  else
    exit(FAILURE);

  if ((result=strstr(recv_buf, "uin="))!=NULL){
    for (j=0;result[j]!='\n' && j<300;j++)
      cookie3[j]=result[j];
    cookie3[j]='\0';
  }
  else
    exit(FAILURE);

  urlencodemessage(getline, sms);
  sprintf(message_buf, "carrier=%s&country=48&tophone=%s&prefix=%2B48&msg=%s",prefix,number,getline);
  sprintf(getline, "POST /sms/send_history/1,,,00.html HTTP/1.0\r\nConnection: close\r\nHost: web.icq.com\r\nContent-type: application/x-www-form-urlencoded\r\nCookie: %s\r\nCookie: %s\r\nCookie: %s\r\nContent-length: %d\r\n\r\n%s", cookie1, cookie2, cookie3, strlen(message_buf), message_buf);
  if (netsend("mobile.icq.com", 80, getline, recv_buf,100000))
     return NETERR;


/******************************************************************************************************************************************/
 // usuwanie wyslanej wiadomosci
  sprintf(message_buf, "uDelete=0&All=1&uPrePath=/sms/inbox&type=1");
  sprintf(getline, "POST /sms/delete/1,,,00.html HTTP/1.0\r\nConnection: close\r\nUser-Agent: Mozilla/4.6 [en] (X11; I; Linux 2.2.7 i586)\r\nHost: web.icq.com\r\nAccept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*\r\nAccept-Encoding: gzip\r\nAccept-Language: en\r\nAccept-Charset: iso-8859-1,*,utf-8\r\nContent-type: application/x-www-form-urlencoded\r\nCookie: %s\r\nCookie: %s\r\nCookie: %s\r\nContent-length: %d\r\n\r\n%s", cookie1, cookie2, cookie3, strlen(message_buf), message_buf);

  if(netsend("mobile.icq.com", 80, getline, recv_buf,100000))
    return NETERR;

  sprintf(message_buf, "uDelete=0&All=0&uPrePath=/sms/sent_msg");
  sprintf(getline, "POST /sms/delete/1,,,00.html HTTP/1.0\r\nConnection: close\r\nUser-Agent: Mozilla/4.6 [en] (X11; I; Linux 2.2.7 i586)\r\nHost: web.icq.com\r\nAccept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*\r\nAccept-Encoding: gzip\r\nAccept-Language: en\r\nAccept-Charset: iso-8859-1,*,utf-8\r\nContent-type: application/x-www-form-urlencoded\r\nCookie: %s\r\nCookie: %s\r\nCookie: %s\r\nContent-length: %d\r\n\r\n%s", cookie1, cookie2, cookie3, strlen(message_buf), message_buf);
  if(netsend("mobile.icq.com", 80, getline, recv_buf,100000))
    return NETERR;

  sprintf(message_buf, "uDelete=1&All=1&uPrePath=/sms/deleted");
  sprintf(getline, "POST /sms/delete/1,,,00.html HTTP/1.0\r\nConnection: close\r\nUser-Agent: Mozilla/4.6 [en] (X11; I; Linux 2.2.7 i586)\r\nHost: web.icq.com\r\nAccept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*\r\nAccept-Encoding: gzip\r\nAccept-Language: en\r\nAccept-Charset: iso-8859-1,*,utf-8\r\nContent-type: application/x-www-form-urlencoded\r\nCookie: %s\r\nCookie: %s\r\nCookie: %s\r\nContent-length: %d\r\n\r\n%s", cookie1, cookie2, cookie3, strlen(message_buf), message_buf);
  if(netsend("mobile.icq.com", 80, getline, recv_buf,100000))
    return NETERR;
    /******************************************************************************************************************************************/
  return 0;
}

int WyslijSMS_ICQ(SMS_packet *sms)
{
	char *telefon = sms->telefon;
	char *wiadomosc = sms->wiadomosc;
	return sendsms(wiadomosc, telefon) == SUCCESS;
}

