structure Mlex=
   struct
    structure UserDeclarations =
      struct
(* lexer
 *
 * COPYRIGHT (c) 1989,1992 by AT&T Bell Laboratories
 *
 * A scanner for mapping mapping ML code to pretty print form.
 *
 * TODO: spaces at the beginning of multi-line comments.
 *)

structure VB = ViewBuffer
structure KW = Keywords

datatype lexresult
  = EOF
  | NL
  | TOK of {space : int, kind : VB.token_kind, text : string}
  | COM of lexresult list
  | STR of lexresult list

val comLevel = ref 0

val resultStk = ref ([] : lexresult list)

val charList = ref ([] : string list)
fun makeString () = (implode(rev(!charList)) before charList := [])

val col = ref 0
val space = ref 0
fun tab () = let
      val n = !col
      val skip = 8 - Bits.andb(n, 0x7)
      in
	space := !space + skip;
	col := n + skip
      end
fun expandTab () = let
      val n = !col
      val skip = 8 - Bits.andb(n, 0x7)
      in
	charList := Makestring.padLeft("", skip) :: (!charList);
	col := n + skip
      end
fun addString s = (charList := s :: (!charList); col := !col + size s)
fun token tok = (
      space := 0;
      col := !col + size (#text tok);
      TOK tok)
fun newline () = (space := 0; col := 0; NL)
fun pushLine kind = let
      val tok = TOK{space = !space, kind = kind, text = makeString()}
      in
	space := 0;
	newline(); resultStk := NL :: tok :: !resultStk
      end
fun dumpStk kind = let
      val tok = TOK{space = !space, kind = kind, text = makeString()}
      in
	space := 0;
	(rev (tok :: !resultStk)) before resultStk := []
      end
fun mkId s = token(KW.mkToken{space = !space, text = s})
fun mkSym s = token({space = !space, kind = VB.Symbol, text = s})
fun mkTyvar s = token({space = !space, kind = VB.Ident, text = s})
fun mkCon s = token({space = !space, kind = VB.Symbol, text = s})

fun eof () = (
      charList := []; resultStk := [];
      space := 0; col := 0;
      comLevel := 0;
      EOF)
fun error s = raise Fail s

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\010\010\010\010\010\010\010\010\010\053\052\010\010\010\010\010\
\\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\
\\051\026\050\026\026\026\026\048\046\045\043\026\042\026\039\026\
\\036\034\034\034\034\034\034\034\034\034\026\033\026\026\026\026\
\\026\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\032\026\031\026\030\
\\026\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\027\026\025\011\010\
\\009"
val s3 =
"\054\054\054\054\054\054\054\054\054\060\059\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\057\054\055\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054"
val s5 =
"\061\061\061\061\061\061\061\061\061\067\066\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\065\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\062\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061"
val s7 =
"\068\068\068\068\068\068\068\068\068\072\071\068\068\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\070\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\069\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\068\
\\068"
val s11 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\000\012\012\000\012\000\012\
\\022\013\013\013\013\013\013\013\013\013\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\000\012\012\000\012\000\012\
\\000\000\000\000\000\000\000\000\000\000\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\017\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\016\016\016\016\016\016\016\016\016\016\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\016\016\016\016\016\016\016\016\016\016\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\017\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\023\000\000\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\024\024\024\024\024\024\024\024\024\024\000\000\000\000\000\000\
\\000\024\024\024\024\024\024\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\024\024\024\024\024\024\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s28 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\029\000\000\000\000\000\000\000\000\
\\029\029\029\029\029\029\029\029\029\029\000\000\000\000\000\000\
\\000\029\029\029\029\029\029\029\029\029\029\029\029\029\029\029\
\\029\029\029\029\029\029\029\029\029\029\029\000\000\000\000\029\
\\000\029\029\029\029\029\029\029\029\029\029\029\029\029\029\029\
\\029\029\029\029\029\029\029\029\029\029\029\000\000\000\000\000\
\\000"
val s34 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\017\000\
\\035\035\035\035\035\035\035\035\035\035\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\017\000\
\\035\035\035\035\035\035\035\035\035\035\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\037\000\000\000\000\000\000\000\
\\000"
val s37 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\000\
\\000\038\038\038\038\038\038\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\038\038\038\038\038\038\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\040\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\041\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\012\000\012\012\012\012\000\000\044\012\012\000\012\000\012\
\\000\000\000\000\000\000\000\000\000\000\012\000\012\012\012\012\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\012\000\012\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\047\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\049\000\000\000\000\000\000\000\000\
\\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\000\
\\000\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\000\000\000\049\
\\000\049\049\049\049\049\049\049\049\049\049\049\049\049\049\049\
\\049\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\058\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s61 =
"\061\061\061\061\061\061\061\061\061\000\000\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\000\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\000\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\064\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 117)], trans = s5},
{fin = [(N 117)], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [(N 125),(N 127)], trans = s0},
{fin = [(N 127)], trans = s0},
{fin = [(N 43),(N 127)], trans = s11},
{fin = [(N 43)], trans = s12},
{fin = [(N 70)], trans = s13},
{fin = [], trans = s14},
{fin = [], trans = s15},
{fin = [(N 63)], trans = s15},
{fin = [], trans = s17},
{fin = [(N 63)], trans = s18},
{fin = [], trans = s19},
{fin = [], trans = s20},
{fin = [(N 63)], trans = s20},
{fin = [(N 70)], trans = s22},
{fin = [], trans = s23},
{fin = [(N 81)], trans = s23},
{fin = [(N 13),(N 127)], trans = s0},
{fin = [(N 43),(N 127)], trans = s12},
{fin = [(N 11),(N 127)], trans = s0},
{fin = [(N 43),(N 127)], trans = s28},
{fin = [(N 43)], trans = s28},
{fin = [(N 7),(N 127)], trans = s0},
{fin = [(N 17),(N 127)], trans = s0},
{fin = [(N 15),(N 127)], trans = s0},
{fin = [(N 19),(N 127)], trans = s0},
{fin = [(N 66),(N 127)], trans = s34},
{fin = [(N 66)], trans = s34},
{fin = [(N 66),(N 127)], trans = s36},
{fin = [], trans = s37},
{fin = [(N 75)], trans = s37},
{fin = [(N 25),(N 127)], trans = s39},
{fin = [], trans = s40},
{fin = [(N 29)], trans = s0},
{fin = [(N 9),(N 127)], trans = s0},
{fin = [(N 43),(N 127)], trans = s43},
{fin = [(N 87)], trans = s0},
{fin = [(N 23),(N 127)], trans = s0},
{fin = [(N 21),(N 127)], trans = s46},
{fin = [(N 84)], trans = s0},
{fin = [(N 32),(N 127)], trans = s48},
{fin = [(N 32)], trans = s48},
{fin = [(N 101),(N 127)], trans = s0},
{fin = [(N 3),(N 127)], trans = s0},
{fin = [(N 5)], trans = s0},
{fin = [(N 1),(N 127)], trans = s0},
{fin = [(N 99)], trans = s0},
{fin = [(N 99)], trans = s55},
{fin = [(N 95)], trans = s0},
{fin = [(N 99)], trans = s57},
{fin = [(N 90)], trans = s0},
{fin = [(N 92)], trans = s0},
{fin = [(N 97),(N 99)], trans = s0},
{fin = [(N 117)], trans = s61},
{fin = [(N 115)], trans = s62},
{fin = [(N 113)], trans = s0},
{fin = [(N 108)], trans = s0},
{fin = [(N 103)], trans = s0},
{fin = [(N 105)], trans = s0},
{fin = [(N 110)], trans = s0},
{fin = [(N 123)], trans = s0},
{fin = [(N 121),(N 123)], trans = s0},
{fin = [(N 3),(N 123)], trans = s0},
{fin = [(N 119)], trans = s0},
{fin = [(N 1),(N 123)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val C = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (tab(); continue())
| 101 => (YYBEGIN S; addString yytext; continue())
| 103 => (YYBEGIN INITIAL; addString yytext; STR(dumpStk VB.Symbol))
| 105 => (error "unexpected newline in unclosed string")
| 108 => (YYBEGIN F; pushLine VB.Symbol; continue())
| 11 => (mkSym yytext)
| 110 => (expandTab(); continue())
| 113 => (addString yytext; continue())
| 115 => (addString yytext; continue())
| 117 => (addString yytext; continue())
| 119 => (resultStk := (newline ()) :: !resultStk; continue())
| 121 => (YYBEGIN S; addString yytext; continue())
| 123 => (error "unclosed string")
| 125 => (error "non-Ascii character")
| 127 => (error "illegal character")
| 13 => (mkSym yytext)
| 15 => (mkSym yytext)
| 17 => (mkSym yytext)
| 19 => (mkSym yytext)
| 21 => (mkSym yytext)
| 23 => (mkSym yytext)
| 25 => (mkSym yytext)
| 29 => (mkSym yytext)
| 3 => (inc space; inc col; continue())
| 32 => (mkTyvar yytext)
| 43 => (mkId yytext)
| 5 => (newline())
| 63 => (mkCon yytext)
| 66 => (mkCon yytext)
| 7 => (mkSym yytext)
| 70 => (mkCon yytext)
| 75 => (mkCon yytext)
| 81 => (mkCon yytext)
| 84 => (YYBEGIN C; addString yytext; comLevel := 1; continue())
| 87 => (error "unmatched close comment")
| 9 => (mkSym yytext)
| 90 => (addString yytext; inc comLevel; continue())
| 92 => (pushLine VB.Comment; continue())
| 95 => (addString yytext;
		    dec comLevel;
		    if (!comLevel = 0)
		      then (YYBEGIN INITIAL; COM(dumpStk VB.Comment))
		      else continue())
| 97 => (expandTab(); continue())
| 99 => (addString yytext; continue())
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
