(* images.sml
 *
 * COPYRIGHT (c) 1996 AT&T Research.
 *)

structure Images =
  struct
    local open Geometry EXeneBase Drawing in

    type image = {
      origin : point,
      data : tile
    }
  
    fun mkImage scr (pt,image) = 
      ({origin=pt,data=createTileFromImage scr image} : image)

    fun setImage (draww,pen) ({origin,data},pt) = let
      val sz as SIZE{wid,ht} = sizeOfTile data
      val dst_pos = subPt(pt,origin)
      in
        textureBlt draww pen {src=data,dst_pos=dst_pos}
      end

    fun clearImage draww ({origin,data},pt) = let
      val sz = sizeOfTile data
      val dst_pos = subPt(pt,origin)
      in
        clearArea draww (mkRect(dst_pos,sz))
      end

    val diveIndex = 0
    val standIndex = 1
    val climbIndex = 2
    val topIndex = 6

    fun mkImage {x, y, wid, ht, data} = let
	  val data = List.map (List.map Byte.stringToBytes) data
	  in (
	    PT{x=x, y=y},
	    EXeneBase.IMAGE{sz = SIZE{wid=wid, ht=ht}, data = data}
	  ) end

    val dive = mkImage {
	    x=15,y=31, wid=16, ht=32,
            data = [[
                "\000\000",
                "\001\224",
                "\001\224",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\001\192",
                "\003\192",
                "\007\192",
                "\007\192",
                "\004\064",
                "\004\064",
                "\052\064",
                "\052\064",
                "\052\064",
                "\053\224",
                "\052\016",
                "\060\016",
                "\063\144",
                "\028\072",
                "\028\072",
                "\014\072",
                "\007\168",
                "\003\168",
                "\000\040",
                "\000\016"
              ]]
          }
    val stand = mkImage {
	    x=0,y=31, wid=16, ht=32,
            data = [[
                "\000\000",
                "\000\000",
                "\000\000",
                "\129\192",
                "\193\224",
                "\162\112",
                "\082\056",
                "\042\056",
                "\021\252",
                "\010\060",
                "\004\044",
                "\003\172",
                "\002\044",
                "\002\044",
                "\002\044",
                "\002\032",
                "\002\032",
                "\003\224",
                "\003\224",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\003\192",
                "\007\192",
                "\007\192"
              ]]
          }
    val climb1 = mkImage {
	    x=0,y=25, wid=16, ht=26,
            data = [[
                "\129\192",
                "\193\224",
                "\162\112",
                "\082\056",
                "\042\056",
                "\021\252",
                "\010\060",
                "\004\044",
                "\003\172",
                "\002\044",
                "\002\044",
                "\002\044",
                "\002\032",
                "\002\032",
                "\007\224",
                "\015\224",
                "\031\192",
                "\031\128",
                "\060\000",
                "\120\000",
                "\120\000",
                "\240\000",
                "\240\000",
                "\224\000",
                "\224\000",
                "\224\000"
              ]]
          }
    val climb2 = mkImage {
	    x=0,y=25, wid=16, ht=26,
            data = [[
                "\129\192",
                "\193\224",
                "\162\112",
                "\082\056",
                "\042\056",
                "\021\252",
                "\010\060",
                "\004\044",
                "\003\172",
                "\002\044",
                "\002\044",
                "\002\044",
                "\050\032",
                "\122\032",
                "\255\224",
                "\239\224",
                "\223\192",
                "\223\128",
                "\060\000",
                "\120\000",
                "\120\000",
                "\240\000",
                "\240\000",
                "\224\000",
                "\224\000",
                "\224\000"
              ]]
          }
    val climb3 = mkImage {
	    x=0,y=25, wid=16, ht=26,
            data = [[
                "\001\192",
                "\001\224",
                "\002\112",
                "\002\056",
                "\002\056",
                "\001\252",
                "\030\060",
                "\240\044",
                "\007\172",
                "\250\044",
                "\002\044",
                "\002\044",
                "\002\032",
                "\002\032",
                "\007\224",
                "\015\224",
                "\031\192",
                "\031\128",
                "\060\000",
                "\120\000",
                "\120\000",
                "\240\000",
                "\240\000",
                "\224\000",
                "\224\000",
                "\224\000"
              ]]
          }
    val climb4 = mkImage {
	    x=0,y=25, wid=16, ht=26,
            data = [[
                "\129\192",
                "\065\224",
                "\178\112",
                "\074\056",
                "\054\056",
                "\009\252",
                "\006\060",
                "\248\044",
                "\007\172",
                "\250\044",
                "\002\044",
                "\002\044",
                "\002\032",
                "\002\032",
                "\007\224",
                "\015\224",
                "\031\192",
                "\031\128",
                "\060\000",
                "\120\000",
                "\120\000",
                "\240\000",
                "\240\000",
                "\224\000",
                "\224\000",
                "\224\000"
              ]]
          }
    val top1 = mkImage {
	    x=8,y=41, wid=16, ht=42,
            data = [[
                "\000\028",
                "\000\100",
                "\000\132",
                "\001\004",
                "\000\228",
                "\000\028",
                "\000\004",
                "\000\004",
                "\000\004",
                "\016\004",
                "\040\010",
                "\040\010",
                "\040\010",
                "\041\202",
                "\043\234",
                "\038\050",
                "\018\164",
                "\010\040",
                "\005\208",
                "\004\016",
                "\002\032",
                "\002\032",
                "\002\032",
                "\002\032",
                "\002\032",
                "\002\032",
                "\002\032",
                "\003\224",
                "\003\224",
                "\003\224",
                "\003\224",
                "\003\224",
                "\003\096",
                "\003\096",
                "\003\096",
                "\003\096",
                "\003\096",
                "\003\096",
                "\003\096",
                "\003\096",
                "\007\112",
                "\007\112"
              ]]
          }

    val top2 = mkImage {
	    x=10,y=35, wid=32, ht=36,
            data = [[
                "\000\000\000\016",
                "\000\000\000\040",
                "\000\000\000\068",
                "\000\000\000\132",
                "\000\000\001\194",
                "\000\000\002\057",
                "\000\000\002\007",
                "\000\112\004\000",
                "\224\248\056\000",
                "\144\136\072\000",
                "\204\169\152\000",
                "\035\142\032\000",
                "\024\112\192\000",
                "\006\003\000\000",
                "\003\142\000\000",
                "\000\136\000\000",
                "\000\136\000\000",
                "\000\136\000\000",
                "\000\136\000\000",
                "\000\136\000\000",
                "\000\136\000\000",
                "\000\248\000\000",
                "\000\248\000\000",
                "\000\248\000\000",
                "\000\248\000\000",
                "\000\248\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\001\220\000\000",
                "\001\220\000\000"
              ]]
          }
    val top3 = mkImage {
	    x=10,y=31, wid=32, ht=32,
            data = [[
                "\000\000\000\000",
                "\000\000\000\000",
                "\000\000\000\000",
                "\000\112\000\000",
                "\000\248\000\000",
                "\000\136\000\000",
                "\000\168\000\000",
                "\000\136\000\000",
                "\001\116\000\000",
                "\003\006\000\000",
                "\006\139\000\000",
                "\024\136\192\000",
                "\035\142\032\000",
                "\204\137\152\000",
                "\144\136\072\000",
                "\224\136\062\000",
                "\000\136\001\128",
                "\000\248\000\096",
                "\000\248\000\088",
                "\000\248\000\068",
                "\000\248\000\068",
                "\000\248\000\036",
                "\000\216\000\036",
                "\000\216\000\036",
                "\000\216\000\024",
                "\000\216\000\016",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\000\216\000\000",
                "\001\220\000\000",
                "\001\220\000\000"
              ]]
          }
    val top4 = mkImage {
	    x=8,y=31, wid=20, ht=32,
            data = [[
                "\000\000\000",
                "\000\000\000",
                "\000\000\000",
                "\001\192\000",
                "\003\224\000",
                "\002\032\000",
                "\002\160\000",
                "\002\032\000",
                "\005\208\000",
                "\004\016\000",
                "\010\040\000",
                "\018\036\000",
                "\038\050\000",
                "\042\042\000",
                "\042\042\000",
                "\042\042\000",
                "\042\042\000",
                "\043\234\000",
                "\019\228\000",
                "\003\228\000",
                "\003\228\000",
                "\003\228\000",
                "\003\102\000",
                "\003\101\000",
                "\003\100\128",
                "\003\100\128",
                "\003\100\064",
                "\003\103\064",
                "\003\097\064",
                "\003\097\064",
                "\007\112\128",
                "\007\112\000"
              ]]
          }

    val images = [
      dive, stand, climb1, climb2, climb3, climb4, top1, top2, top3, top4
    ]

  end (* local *)
  end
