/***************************************************************************
			world_editor.h  -  header for the corresponding cpp file
                             -------------------
    copyright            : (C) 2007 by Florian Richter
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __WORLD_EDITOR_H__
#define __WORLD_EDITOR_H__

#include "../core/editor.h"

/* *** *** *** *** *** *** *** cEditor_World *** *** *** *** *** *** *** *** *** *** */

class cEditor_World : public cEditor
{
public:
	cEditor_World( void );
	~cEditor_World( void );

	// Initialize
	virtual void Init( void );

	// Enable
	virtual void Enable( void );
	// Disable
	virtual void Disable( void );

	/* handle key down event
	 * returns true if the key was processed
	*/
	virtual bool Key_Down( SDLKey key );

	// Add object to World
	virtual void Add_Object( cSprite *object );

	// Set Active Menu Entry
	virtual void Activate_Menu( cEditor_Menu_Object *entry );

	// Menu functions
	//virtual void Function_New( void );
	virtual void Function_Load( void );
	virtual void Function_Save( void );
	//virtual void Function_Save_as( void );
	virtual void Function_Reload( void );
	virtual void Function_Clear( void );
	//void Function_Settings( void );
};

/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */

// The World Editor
extern cEditor_World *pWorld_Editor;

/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */

#endif
