#ifndef __BUFFER_H__
#define __BUFFER_H__

#include <pthread.h>
#include "list.h"

typedef struct{
    char		name[12];
    int			count_max;
    int			count;
    size_t		data_size;
    LIST		list;
    pthread_mutex_t	mutex;
} BUFFERMANAGER;

typedef struct{
    char		reserved[sizeof(LIST)];
    BUFFERMANAGER	*man;
    char		data[0];
} BUFFER;


void	InitBufferManager(BUFFERMANAGER *man, char *name, size_t data_size);
void	DestroyBufferManager(BUFFERMANAGER *man);
int	SetMaxBufferCount(BUFFERMANAGER *man, int count);
void	AllocateBuffers(BUFFERMANAGER *man);
void	DestroyBufferList(BUFFERMANAGER *man);

BUFFER* GetBuffer(BUFFERMANAGER *man);
void	ReleaseBuffer(BUFFER *buf);
size_t	BufferSize(BUFFER *buf);

#endif	/* __BUFFER_H__ */
