/***************************************************************************
    smb4ksharesiconview  -  This is the shares icon view of Smb4K.
                             -------------------
    begin                : Mo Dez 4 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESICONVIEW_H
#define SMB4KSHARESICONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qvaluelist.h>

// KDE includes
#include <kiconview.h>
#include <kurldrag.h>

// forward declarations
class Smb4KSharesIconViewItem;
class Smb4KSharesIconViewToolTip;


/**
 * This widget class provides the shares icon view of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesIconView : public KIconView
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent          The parent widget
     *
     * @param name            The name of the widget
     */
    Smb4KSharesIconView( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSharesIconView();

    /**
     * Update the tool tip if it exists. This function just executes
     * Smb4KSharesListViewToolTip::update().
     */
    void updateToolTip();

  protected:
    /**
     * Reimplemented (sort of) from QIconView to enable dragging. As QDragObject
     * a KURLDrag will be returned.
     *
     * @returns a KURLDrag object.
     */
    KURLDrag *dragObject();

    /**
     * Reimplemented from QIconView to allow some actions to be carried
     * out before the drag begins.
     */
    void startDrag();

    /**
     * Reimplemented from QIconView.
     */
    void contentsDragEnterEvent( QDragEnterEvent * );

    /**
     * Reimplemented from QIconView.
     */
    void contentsDragMoveEvent( QDragMoveEvent *e );

    /**
     * Reimplemented from QIconView.
     */
    void contentsDropEvent( QDropEvent *e );

    /**
     * Reimplemented from QIconView. This function is used to
     * show the tooltips.
     */
    void contentsMouseMoveEvent( QMouseEvent *e );

  protected slots:
    /**
     * This slot is connected to KIconView::pressed() and clears the selection
     * if the user clicked on the viewport.
     *
     * @param item            The QIconViewItem that the user clicked or NULL
     *                        if he/she pressed a mouse button on the viewport.
     */
    void slotPressed( QIconViewItem *item );

    /**
     * This slot shows the tool tip for an icon view item.
     */
    void slotShowToolTip();

  private:
    /**
     * The current global mouse position
     */
    QPoint m_pos;

    /**
     * The tool tip
     */
    Smb4KSharesIconViewToolTip *m_tooltip;
};

#endif
