/***************************************************************************
                          smb4ksuperuseroptions  -  description
                             -------------------
    begin                : Sa Okt 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSUPERUSEROPTIONS_H
#define SMB4KSUPERUSEROPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// KDE includes
#include <kpushbutton.h>

class Smb4KSuperUserOptions : public QWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /**
     * The constructor
     *
     * @param parent      The parent widget
     *
     * @param name        The name of this widget
     */
    Smb4KSuperUserOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KSuperUserOptions();

  private:
    /**
     * The radio button that deterimes whether the suid program
     * 'super' is used.
     */
    QRadioButton *m_super;
    /**
     * The radio button that deterimes whether the suid program
     * 'sudo' is used.
     */
    QRadioButton *m_sudo;
#ifdef __linux__
    /**
     * The check box that determines whether dead shares should forcibly
     * be unmounted.
     */
    QCheckBox *m_unmount_dead;
#endif
    /**
     * The check box that determines whether super or sudo should be used
     * with mounting and unmouting.
     */
    QCheckBox *m_use_suid;
    /**
     * The button to remove the super user entries from the config files.
     */
    KPushButton *m_remove;
};

#endif
