/***************************************************************************
                          smb4kprintdialog  -  description
                             -------------------
    begin                : So Apr 11 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINTDIALOG_H
#define SMB4KPRINTDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qstring.h>

// KDE includes
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <knuminput.h>

// application includes
#include "../core/smb4knetworkitems.h"


/**
 * This class provides the print dialog.
 */

class Smb4KPrintDialog : public KDialogBase
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param item        The Smb4KShareItem of the printer.
     *
     * @param parent      The parent widget of this dialog.
     *
     * @param name        The name of this dialog.
     */
    Smb4KPrintDialog( Smb4KShareItem *item, QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KPrintDialog();

  protected slots:
    /**
     * Reimplemented from KDialogBase.
     */
    void slotOk();

  private:
    /**
     * The Smb4KShareItem object.
     */
    Smb4KShareItem *m_item;
    /**
     * Holds the IP address.
     */
    QString m_ip;
    /**
     * The URL requester object, that is needed to specify the
     * the file to print.
     */
    KURLRequester *m_input;
    /**
     * Sets the number of copies the user wants to have.
     */
    KIntNumInput *m_copies;
};

#endif
