/***************************************************************************
    smb4knetworkoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KNETWORKOPTIONS_H
#define SMB4KNETWORKOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlabel.h>

// KDE includes
#include <klineedit.h>

class Smb4KNetworkOptions : public QWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /**
     * The constructor
     *
     * @param parent        The parent widget
     *
     * @param name          The widget's name
     */
    Smb4KNetworkOptions( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KNetworkOptions();

  private:
    /**
     * Choose this radio button to scan the whole local
     * network for master browsers to get the browse list.
     * This is the default.
     */
    QRadioButton *m_useNMB;

    /**
     * Choose this radio button to query the current
     * master browser of your workgroup.
     */
    QRadioButton *m_useMaster;

    /**
     * Choose this radio button to query a user-supplied
     * host to get the browse list.
     */
    QRadioButton *m_useHost;

    /**
     * This line edit carries the name of the fixed master
     * browser the user wants to have queried to retrieve the
     * browse list.
     */
    KLineEdit *m_hostName;

    /**
     * The radio button for the search method 'nmblookup'.
     */
    QRadioButton *m_nmbSearch;

    /**
     * The radio button for the search method 'smbclient'.
     */
    QRadioButton *m_clientSearch;

    /**
     * This line edit carries the IP ranges that should be scanned.
     */
    KLineEdit *m_ipBroadcastAddresses;

    /**
     * The radio button for the lookup method 'IP scan'.
     */
    QRadioButton *m_useIPScan;
};
#endif
