/***************************************************************************
    smb4kshareactionmenu  -  description
                             -------------------
    begin                : Fr Dez 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHAREACTIONMENU_H
#define SMB4KSHAREACTIONMENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>

// KDE includes
#include <kactionclasses.h>
#include <kactioncollection.h>

/**
 * This class provides the action menu for use with the shares view and other
 * widgets.
 *
 * NOTE: The actions are not connected to any slots nor are they added to a group.
 * They are also not disabled. You have to implement all of that in the widget were
 * you incorporate this menu!
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KShareActionMenu : public KActionMenu
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param design          The design of the menu. It is determined by the Design enumeration.
     *
     * @param collection      The action collection that the actions of the action menu
     *                        should belong to.
     *
     * @param text            The text for this action menu.
     *
     * @param icon            The icon set for this menu.
     *
     * @param parent          The parent widget of this menu.
     *
     * @param name            The name of this menu.
     */
    Smb4KShareActionMenu( int design, KActionCollection *collection, const QString &text = QString::null, const QIconSet &icon = QIconSet(), QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     *
     * ATTENTION: The actions in the menu will *NOT* be deleted here. You *MUST* delete them
     * in the widget where you implemented the menu!
     */
    ~Smb4KShareActionMenu();

    /**
     * This function returns a pointer to the unmount action.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     * @returns               Returns a pointer to the 'Unmount' action.
     */
    KAction *unmountAction() { return m_unmount_action; }

    /**
     * This function returns a pointer to the action that forces the unmounting.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     * @returns               Returns a pointer to the 'Force Unmounting' action.
     */
    KAction *forcedUnmountAction() { return m_force_action; }

    /**
     * This function returns a pointer to the action that unmounts all shares at once.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     * @returns               Returns a pointer to the 'Unmount All' action in the 'Full'
     * design and NULL in the case of the 'SystemTray' design.
     */
    KAction *unmountAllAction() { return m_unmount_all_action; }

    /**
     * This function returns a pointer to the action that opens the filemanager.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     * @returns               Returns a pointer to the 'Konqueror' action.
     */
    KAction *filemanagerAction() { return m_filemanager_action; }

    /**
     * This function returns a pointer to the action that starts the synchronization.
     *
     * Remember that you have to connect it to a slot to make it work!
     *
     * @returns               Returns a pointer to the 'Synchronize' action.
     */
    KAction *syncAction() { return m_sync_action; }

    /**
     * Enumeration to determine how the menu should be designed.
     *
     * 'Full' means, all actions and separators are shown. This is for use with the
     * shares view, where you need all actions.
     *
     * 'SystemTray' shows a reduced action menu.
     */
    enum Design{ Full, SystemTray };


  private:
    /**
     * The action collection.
     */
    KActionCollection *m_collection;

    /**
     * The unmount action.
     */
    KAction *m_unmount_action;

    /**
     * The action for the forced unmounting
     */
    KAction *m_force_action;

    /**
     * The action that unmounts all shares at once.
     */
    KAction *m_unmount_all_action;

    /**
     * This action opens the filemanager.
     */
    KAction *m_filemanager_action;

    /**
     * This action starts the synchronization.
     */
    KAction *m_sync_action;

    /**
     * This function sets up the actions.
     *
     * @param design            The design the menu should have.
     */
    void setupActions( int design );
};

#endif
