/***************************************************************************
    smb4kshareactionmenu  -  description
                             -------------------
    begin                : Fr Dez 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <klocale.h>
#include <kpopupmenu.h>

// application specific includes
#include "smb4kshareactionmenu.h"
#include "../core/smb4kglobal.h"

using namespace Smb4KGlobal;


Smb4KShareActionMenu::Smb4KShareActionMenu( int design, KActionCollection *collection, const QString &text, const QIconSet &icon, QWidget *parent, const char *name )
: KActionMenu( text, icon, parent, name ), m_collection( collection )
{
  setupActions( design );
}


Smb4KShareActionMenu::~Smb4KShareActionMenu()
{
  // We will not delete the actions here. You *MUST*
  // delete them in the widget where you implemented
  // the menu!
}


void Smb4KShareActionMenu::setupActions( int design )
{
  if ( design == Full )
  {
    m_unmount_action = new KAction( i18n( "&Unmount" ), "hdd_unmount", CTRL+Key_U, 0, 0, m_collection, "unmount_action" );
    m_force_action = new KAction( i18n( "&Force Unmounting" ), "hdd_unmount", CTRL+Key_F, 0, 0, m_collection, "force_unmount_action" );
    m_unmount_all_action = new KAction( i18n( "U&nmount All" ), "gear", CTRL+Key_N, 0, 0, m_collection, "unmount_all_action" );
    m_filemanager_action = new KAction( i18n( "&Konqueror" ), "kfm_home", CTRL+Key_K, 0, 0, m_collection, "filemanager_action" );
    m_sync_action = new KAction( i18n( "S&ynchronize" ), "bottom", CTRL+Key_Y, 0, 0, m_collection, "synchronize_action" );

    insert( m_unmount_action, -1 );
    insert( m_force_action, -1 );
    insert( m_unmount_all_action, -1 );
    popupMenu()->insertSeparator( -1 );
    insert( m_sync_action, -1 );
    insert( m_filemanager_action, -1 );
  }
  else if ( design == SystemTray )
  {
    m_unmount_action = new KAction( i18n( "&Unmount" ), "hdd_unmount", 0, 0, 0, m_collection, 0 );
    m_force_action = new KAction( i18n( "&Force Unmounting" ), "hdd_unmount", 0, 0, 0, m_collection, 0 );
    m_filemanager_action = new KAction( i18n( "&Konqueror" ), "kfm_home", 0, 0, 0, m_collection, 0 );
    m_sync_action = new KAction( i18n( "S&ynchronize" ), "bottom", 0, 0, 0, m_collection, 0 );
    m_unmount_all_action = NULL;

    insert( m_unmount_action, -1 );
    insert( m_force_action, -1 );
    popupMenu()->insertSeparator( -1 );
    insert( m_sync_action, -1 );
    insert( m_filemanager_action, -1 );
  }
}


#include "smb4kshareactionmenu.moc"
