/***************************************************************************
                          smb4ksearchdialog  -  description
                             -------------------
    begin                : Do Dez 8 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qtooltip.h>
#include <qimage.h>

// KDE includes
#include <klocale.h>
#include <kiconloader.h>
#include <kiconeffect.h>
#include <kmessagebox.h>
#include <kapplication.h>

// application specific includes
#include "smb4ksearchdialog.h"
#include "../core/smb4knetworkitems.h"
#include "../core/smb4kcore.h"


Smb4KSearchDialog::Smb4KSearchDialog( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );

  m_toolbar = new KToolBar( this, "SearchToolBar", true, false );

  m_input = new KComboBox( true, m_toolbar );
  m_input->setFocus();
  m_input->setDuplicatesEnabled( false );
  m_toolbar->insertWidget( 0, 10, m_input );
  m_toolbar->setItemAutoSized( 0, true );

  m_toolbar->insertSeparator();

  m_toolbar->insertButton( "find", Search, false, i18n( "Search" ) );
  m_toolbar->insertButton( "editdelete", Clear, false, i18n( "Clear" ) );
  m_toolbar->insertButton( "button_ok", Add, false, i18n( "Add" ) );

  m_window = new KListBox( this );

  grid->addWidget( m_toolbar, 0, 0, 0 );
  grid->addWidget( m_window, 1, 0, 0 );


  // Internal connections
  connect( m_toolbar, SIGNAL( clicked( int ) ),
           this,      SLOT( slotButtonClicked( int ) ) );
  connect( m_input,   SIGNAL( returnPressed() ),
           this,      SLOT( slotReturnPressed() ) );
  connect( m_input,   SIGNAL( textChanged( const QString & ) ),
           this,      SLOT( slotTextChanged( const QString & ) ) );
  connect( m_window,  SIGNAL( clicked( QListBoxItem * )  ),
           this,      SLOT( slotItemClicked( QListBoxItem * ) ) );
  connect( m_window,  SIGNAL( doubleClicked( QListBoxItem * ) ),
           this,      SLOT( slotItemDoubleClicked( QListBoxItem * ) ) );

  // External connections
  connect( smb4k_core->scanner(), SIGNAL( searchResult( Smb4KHostItem * ) ),
           this,                  SLOT( slotReceivedSearchResult( Smb4KHostItem * ) ) );
  connect( smb4k_core->scanner(), SIGNAL( hostListChanged() ),
           this,                  SLOT( slotCheckItemInBrowser() ) );

  QToolTip::add( m_window, i18n( "Search results" ) );
  QToolTip::add( m_input, i18n( "Enter host here" ) );
}


Smb4KSearchDialog::~Smb4KSearchDialog()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSearchDialog::slotButtonClicked( int id )
{
  if ( id == Search )
  {
    if ( !m_input->currentText().stripWhiteSpace().isEmpty() )
    {
      smb4k_core->scanner()->makeSearch( m_input->currentText().stripWhiteSpace() );
      m_host = m_input->currentText().upper();
      m_input->clearEdit();
    }
  }
  else if ( id == Add )
  {
    slotItemDoubleClicked( m_window->item( m_window->currentItem() ) );
  }
  else if ( id == Clear )
  {
    m_input->clear();
    m_window->clear();
    m_toolbar->setItemEnabled( Add, false );
    m_toolbar->setItemEnabled( Clear, false );
  }
}


void Smb4KSearchDialog::slotReturnPressed()
{
  slotButtonClicked( Search );
}


void Smb4KSearchDialog::slotReceivedSearchResult( Smb4KHostItem *item )
{
  if ( item->workgroup().isEmpty() && item->name().isEmpty() && item->ip().isEmpty() )
  {
    QString entry = i18n( "The search for %1 failed." ).arg( m_host );
    m_window->insertItem( SmallIcon( "no" ), entry, 0 );
  }
  else
  {
    QString entry( item->name() );

    if ( !item->ip().stripWhiteSpace().isEmpty() )
    {
      entry.append( " (" ).append( item->ip() ).append( ")" );
    }

    if ( !item->workgroup().stripWhiteSpace().isEmpty() )
    {
      entry.append( " [" ).append( item->workgroup() ).append( "]" );
    }

    m_window->insertItem( SmallIcon( "server" ), entry, 0 );
  }

  m_toolbar->setItemEnabled( Clear, true );

  slotCheckItemInBrowser();
}


void Smb4KSearchDialog::slotTextChanged( const QString &text )
{
  m_toolbar->setItemEnabled( Search, !text.isEmpty() );
  m_toolbar->setItemEnabled( Clear, !text.isEmpty() );
}


void Smb4KSearchDialog::slotItemClicked( QListBoxItem *item )
{
  m_toolbar->setItemEnabled( Add, item );
}


void Smb4KSearchDialog::slotItemDoubleClicked( QListBoxItem *item )
{
  if ( item )
  {
    if ( !item->text().isEmpty() &&
         item->text().contains( "(" ) != 0 &&
         item->text().contains( ")" ) != 0 )
    {
      QString host = item->text().section( " ", 0, 0 ).stripWhiteSpace();
      QString ip = item->text().section( "(", 1, 1 ).section( ")", 0, 0 );
      QString workgroup = item->text().section( "[", 1, 1 ).section( "]", 0, 0 );

      if ( !workgroup.isEmpty() )
      {
        emit searchResult( new Smb4KHostItem( workgroup, host, QString::null, ip ) );
      }
    }
  }
}


// This slot is more or less superfluous, because all marking of the
// items will also be done by slotCheckItemInBrowser(), except if someone
// messes up Smb4KBrowserWidget::insertItem(). Nevertheless, we'll keep this
// function.
void Smb4KSearchDialog::slotItemAddedToBrowser( Smb4KHostItem *item )
{
  QListBoxItem *host = m_window->findItem( item->name(), BeginsWith );

  if ( host )
  {
    KIconEffect e;
    QImage over = SmallIcon( "button_ok" ).convertToImage();
    QImage src = SmallIcon( "server" ).convertToImage();
    e.semiTransparent( over );
    e.overlay( src, over );

    QPixmap pix( src );

    m_window->changeItem( pix, host->text(), m_window->index( host ) );
  }
}


void Smb4KSearchDialog::slotCheckItemInBrowser()
{
  if ( m_window->count() != 0 )
  {
    uint index = 0;

    while ( index < m_window->count() )
    {
      if ( m_window->text( index ).contains( "(" ) != 0 &&
           m_window->text( index ).contains( ")" ) != 0 )
      {
        Smb4KHostItem *host = smb4k_core->scanner()->getHost(
                                   m_window->text( index ).section( " ", 0, 0 ).stripWhiteSpace(),
                                   m_window->text( index ).section( "[", 1, 1 ).section( "]", 0, 0 ) );

        if ( host )
        {
          KIconEffect e;
          QImage over = SmallIcon( "button_ok" ).convertToImage();
          QImage src = SmallIcon( "server" ).convertToImage();
          e.semiTransparent( over );
          e.overlay( src, over );

          QPixmap pix( src );

          m_window->changeItem( pix, m_window->text( index ), index );
        }
        else
        {
          m_window->changeItem( SmallIcon( "server" ), m_window->text( index ), index );
        }
      }

      index++;
    }
  }
}

#include "smb4ksearchdialog.moc"
