/***************************************************************************
                          smb4koptionsdlg.h  -  description
                             -------------------
    begin                : Sam Feb 22 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KOPTIONSDLG_H
#define SMB4KOPTIONSDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <kconfig.h>

// application specific includes
#include "smb4kshareoptions.h"
#include "smb4knetworkoptions.h"
#include "smb4kauthoptions.h"
#include "smb4kappearanceoptions.h"
#include "smb4ksambaoptions.h"
#include "smb4ksuperuseroptions.h"
#include "smb4krsyncoptions.h"


class Smb4KOptionsDlg : public KDialogBase
{
  Q_OBJECT

  friend class Smb4KApp;

  public:
    /**
     * The constructor
     */
    Smb4KOptionsDlg( QWidget *parent = 0, const char *name = 0, bool modal = false );
    /**
     * The destructor
     */
    ~Smb4KOptionsDlg();

  signals:
    /**
     * This signal informs the rest of the program, that the options have been
     * saved and should be reread. It is emitted by the Smb4KOptionsDlg::slotOk()
     * and Smb4KOptionsDlg::slotApply().
     */
    void savedOptions();

  protected:
    /**
     * Saves the options.
     */
    bool saveOptions();
    /**
     * Reads the options.
     */
    void readOptions();

  protected slots:
    /**
     * Is called when the OK button has been pressed.
     */
    void slotOk();
    /**
     * Is called when the Apply button has been pressed.
     */
    void slotApply();
    /**
     * This slot is called when the SUID entries were written to the files.
     */
    void slotFinishedSUIDWriting();
    /**
     * This slot is connected to the Smb4KFileIO::error_suid_writing()
     * signal and re-establishes the previous state, if the writing to
     * /etc/super.tab or /etc/sudoers was canceled().
     */
    void slotSUIDWritingFailed();
    /**
     * This slot is invoked, if the user clicked the "Remove Entries"
     * button in the "Super User" tab. It initiates the removal of the
     * entries from the super.tab or sudoers file.
     */
    void slotRemoveSuperUserEntries();

  private:
    /**
     * Set up the browse options page.
     */
    void setupNetworkOptions();
    /**
     * The browse option page object
     */
    Smb4KNetworkOptions *m_networkPage;

    /**
     * Set up the mount options page.
     */
    void setupShareOptions();
    /**
     * The mount options page object
     */
    Smb4KShareOptions *m_sharePage;

    /**
     * Set up the authentication page.
     */
    void setupAuthOptions();
    /**
     * The authentication page object
     */
    Smb4KAuthOptions *m_authPage;

    /**
     * Set up the appearance page.
     */
    void setupAppearanceOptions();
    /**
     * The appearance page object
     */
    Smb4KAppearanceOptions *m_appearancePage;

    /**
     * Sets up the Samba options page.
     */
    void setupSambaOptions();
    /**
     * The Samba page object
     */
    Smb4KSambaOptions *m_sambaPage;

    /**
     * Sets up the super user options page.
     */
    void setupSuperUserOptions();
    /**
     * The super user options page object
     */
    Smb4KSuperUserOptions *m_superPage;

    /**
     * Sets up the synchronize options page
     */
    void setupRsyncOptions();
    /**
     * The synchronize options page object
     */
    Smb4KRsyncOptions *m_syncPage;

    /**
     * This function checks whether all necessary specifications
     * have been provided before applying any changes.
     */
    bool check();
    /**
     * Tells which button has been clicked.
     */
    QString m_button;
    /**
     * The enumeration for the pages.
     */
    enum Pages{ Appearance = 0, Network = 1, Shares = 2, Authentication = 3, Samba = 4, SuperUser = 5, Rsync };
};

#endif
