/***************************************************************************
                          smb4knetworkitemtooltip  -  description
                             -------------------
    begin                : Di Jan 10 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qtooltip.h>
#include <qapplication.h>
#include <qdesktopwidget.h>
#include <qtimer.h>
#include <qframe.h>
#include <kmessagebox.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4knetworkitemtooltip.h"
#include "../core/smb4kcore.h"

Smb4KNetworkItemTooltip::Smb4KNetworkItemTooltip( Smb4KBrowserWidgetItem *item, const QPoint &pos )
: QLabel( 0, "NetworkItemTooltip", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM | WDestructiveClose ), m_item( item ), m_pos( pos )
{
  setPalette( QToolTip::palette() );
  setLineWidth( 1 );
  setMidLineWidth( 1 );
  setFrameShape( Box );
  setFrameShadow( Plain );
  setMouseTracking( true );

  m_layout = new QGridLayout( this );
  m_layout->setMargin( 10 );
  m_layout->setSpacing( 3 );

  setupTooltip( item );
}


Smb4KNetworkItemTooltip::~Smb4KNetworkItemTooltip()
{
}


void Smb4KNetworkItemTooltip::setupTooltip( Smb4KBrowserWidgetItem *item )
{
  if ( !item )
  {
    return;
  }

  int type = item->itemType();

  switch ( type )
  {
    case Smb4KBrowserWidgetItem::Workgroup:
    {
      QLabel *w_label = new QLabel( i18n( "Workgroup:" ), this );
      QLabel *workgroup = new QLabel( item->workgroupItem()->workgroup() , this );

      QString mbl_entry = item->workgroupItem()->pseudo() ? i18n( "Pseudo master browser:" ) : i18n( "Master browser:" );
      QLabel *mb_label = new QLabel( mbl_entry, this );

      QString mb_entry = item->workgroupItem()->ip().isEmpty() ? item->workgroupItem()->master() : item->workgroupItem()->master() + " ("+item->workgroupItem()->ip()+")";
      QLabel *master = new QLabel( mb_entry, this, "MasterBrowser" );

      m_layout->addWidget( w_label, 0, 1, 0 );
      m_layout->addWidget( workgroup, 0, 2, 0 );
      m_layout->addWidget( mb_label, 1, 1, 0 );
      m_layout->addWidget( master, 1, 2, 0 );

      break;
    }
    case Smb4KBrowserWidgetItem::Host:
    {
      QLabel *h_label = new QLabel( i18n( "Host:" ), this );
      QLabel *host = new QLabel( item->hostItem()->name(), this );

      QLabel *c_label = new QLabel( i18n( "Comment:" ), this );
      QLabel *comment = new QLabel( item->hostItem()->comment(), this );

      QLabel *i_label = new QLabel( i18n( "IP address:" ), this );
      QString i_entry = item->hostItem()->ip().isEmpty() ? i18n( "Unknown" ) : item->hostItem()->ip();
      QLabel *ip_address = new QLabel( i_entry, this, "IPAddress" );

      QLabel *os_label = new QLabel( i18n( "Operating system:" ), this );
      QLabel *operating_system = new QLabel( item->hostItem()->osString().isEmpty() ? i18n( "Unknown" ) : item->hostItem()->osString(), this, "OSString" );

      QLabel *serv_label = new QLabel( i18n( "Server string:" ), this );
      QLabel *server_string = new QLabel( item->hostItem()->serverString().isEmpty() ? i18n( "Unknown" ) : item->hostItem()->serverString(), this, "ServerString" );

      QFrame *line = new QFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( QFrame::HLine );
      line->setFrameShadow( QFrame::Plain );

      QLabel *w_label = new QLabel( i18n( "Workgroup:" ), this );
      QLabel *workgroup = new QLabel( item->hostItem()->workgroup(), this );

      Smb4KWorkgroupItem *workgroup_item = smb4k_core->scanner()->getWorkgroup( item->hostItem()->workgroup() );
      QLabel *mb_label = new QLabel( i18n( "Master browser:" ), this );
      QLabel *mb_yes_no = new QLabel( workgroup_item->master(), this );

      m_layout->addWidget( h_label, 0, 1, 0 );
      m_layout->addWidget( host, 0, 2, 0 );
      m_layout->addWidget( c_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( i_label, 2, 1, 0 );
      m_layout->addWidget( ip_address, 2, 2, 0 );
      m_layout->addWidget( os_label, 3, 1, 0 );
      m_layout->addWidget( operating_system, 3, 2, 0 );
      m_layout->addWidget( serv_label, 4, 1, 0 );
      m_layout->addWidget( server_string, 4, 2, 0 );
      m_layout->addMultiCellWidget( line, 5, 5, 1, 2, Qt::AlignCenter );
      m_layout->addWidget( w_label, 6, 1, 0 );
      m_layout->addWidget( workgroup, 6, 2, 0 );
      m_layout->addWidget( mb_label, 7, 1, 0 );
      m_layout->addWidget( mb_yes_no, 7, 2, 0 );

      break;
    }
    case Smb4KBrowserWidgetItem::Share:
    {
      QLabel *s_label = new QLabel( i18n( "Share:" ), this );
      QLabel *share = new QLabel( item->shareItem()->name(), this );

      QLabel *c_label = new QLabel( i18n( "Comment:" ), this );
      QLabel *comment = new QLabel( item->shareItem()->comment(), this );

      QLabel *t_label = new QLabel( i18n( "Type:" ), this );
      QLabel *type = new QLabel( item->shareItem()->translatedType(), this );

      QLabel *m_label = new QLabel( i18n( "Mounted:" ), this );
      QLabel *mounted = new QLabel( item->isMounted() ? i18n( "Yes" ) : i18n( "No" ), this );

      QFrame *line = new QFrame( this );
      line->setLineWidth( 1 );
      line->setMidLineWidth( 0 );
      line->setFixedWidth( 100 );
      line->setFrameShape( QFrame::HLine );
      line->setFrameShadow( QFrame::Plain );

      QLabel *h_label = new QLabel( i18n( "Host:" ), this );
      QLabel *host = new QLabel( item->shareItem()->host(), this );

      QLabel *i_label = new QLabel( i18n( "IP address:" ), this );
      Smb4KHostItem *host_item = smb4k_core->scanner()->getHost( item->shareItem()->host(), item->shareItem()->workgroup() );
      QLabel *ip_address = new QLabel( host_item && !host_item->ip().isEmpty() ? host_item->ip() : i18n( "Unknown" ), this, "IPAddress" );

      m_layout->addWidget( s_label, 0, 1, 0 );
      m_layout->addWidget( share, 0, 2, 0 );
      m_layout->addWidget( c_label, 1, 1, 0 );
      m_layout->addWidget( comment, 1, 2, 0 );
      m_layout->addWidget( t_label, 2, 1, 0 );
      m_layout->addWidget( type, 2, 2, 0 );
      m_layout->addWidget( m_label, 3, 1, 0 );
      m_layout->addWidget( mounted, 3, 2, 0 );
      m_layout->addMultiCellWidget( line, 4, 4, 1, 2, Qt::AlignCenter );
      m_layout->addWidget( h_label, 5, 1, 0 );
      m_layout->addWidget( host, 5, 2, 0 );
      m_layout->addWidget( i_label, 6, 1, 0 );
      m_layout->addWidget( ip_address, 6, 2, 0 );

      break;
    }
    default:
      break;
  };

  QLabel *pix_label = new QLabel( this );
  pix_label->setPixmap( item->desktopIcon() );

  m_layout->addMultiCellWidget( pix_label, 0, m_layout->numRows(), 0, 0, Qt::AlignCenter );
}


void Smb4KNetworkItemTooltip::showTip()
{
  if ( !m_item )
  {
    return;
  }

  update();

  adjustSize();

  QDesktopWidget *d = QApplication::desktop();

  if ( m_pos.x() + width() > d->width() )
  {
    m_pos.setX( m_pos.x() - width() );
  }

  if ( m_pos.y() + height() > d->height() )
  {
    m_pos.setY( m_pos.y() - height() );
  }

  setGeometry( m_pos.x(), m_pos.y(), width(), height() );
  polish();
  show();
  QTimer::singleShot( 10000, this, SLOT( slotHideTooltip() ) );
}


bool Smb4KNetworkItemTooltip::update()
{
  bool updated = false;

  if ( !m_item )
  {
    return updated;
  }

  switch ( m_item->itemType() )
  {
    case Smb4KBrowserWidgetItem::Workgroup:
    {
      QLabel *masterLabel = (QLabel *)child( "MasterBrowser", "Qlabel", true );

      if ( masterLabel )
      {
        QString mb_entry = m_item->workgroupItem()->ip().isEmpty() ? m_item->workgroupItem()->master() : m_item->workgroupItem()->master() + " ("+m_item->workgroupItem()->ip()+")";

        masterLabel->setText( mb_entry );
      }

      break;
    }
    case Smb4KBrowserWidgetItem::Host:
    {
      QLabel *osString = (QLabel *)child( "OSString", "QLabel", true );
      QLabel *serverString = (QLabel *)child( "ServerString", "QLabel", true );
      QLabel *ipString = (QLabel *)child( "IPAddress", "QLabel", true );

      if ( osString )
      {
        QString text = m_item->hostItem()->osString().isEmpty() ? i18n( "Unknown" ) : m_item->hostItem()->osString();
        osString->setText( text );
      }

      if ( serverString )
      {
        QString text = m_item->hostItem()->serverString().isEmpty() ? i18n( "Unknown" ) : m_item->hostItem()->serverString();
        serverString->setText( text );
      }

      if ( ipString )
      {
        QString text = m_item->hostItem()->ip().isEmpty() ? i18n( "Unknown" ) : m_item->hostItem()->ip();
        ipString->setText( text );
      }

      updated = true;

      break;
    }
    case Smb4KBrowserWidgetItem::Share:
    {
      QLabel *ipString = (QLabel *)child( "IPAddress", "QLabel", true );

      if ( ipString )
      {
        QString ip = (smb4k_core->scanner()->getHost( m_item->shareItem()->host(), m_item->shareItem()->workgroup() ))->ip();

        QString text = ip.isEmpty() ? i18n( "Unknown" ) : ip;
        ipString->setText( text );
      }

      updated = true;

      break;
    }
    default:
      break;
  }

  return updated;
}


void Smb4KNetworkItemTooltip::mousePressEvent( QMouseEvent *e )
{
  hide();
  QLabel::mousePressEvent( e );
}


void Smb4KNetworkItemTooltip::leaveEvent( QEvent *e )
{
  hide();
  QLabel::leaveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KNetworkItemTooltip::slotHideTooltip()
{
  if ( isShown() )
  {
    hide();
  }
}

#include "smb4knetworkitemtooltip.moc"
