/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimocallegari@yahoo.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Qt includes
#include <qlabel.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qheader.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qdir.h>

// KDE includes
#include <kinstance.h>
#include <klocale.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <ktoolbarbutton.h>
#include <kaction.h>

// plugin specific includes
// #include "smb4k_konqplugin.moc"
#include "smb4k_konqplugin.h"
#include "widgets/smb4kbrowserwidgetitem.h"
#include "widgets/smb4koptionsdlg.h"
#include "core/smb4kglobal.h"

using namespace  Smb4KGlobal;


KonqSidebar_Smb4K::KonqSidebar_Smb4K(KInstance *inst,QObject *parent,QWidget *widgetParent, QString &desktopName, const char* name):
                   KonqSidebarPlugin(inst,parent,widgetParent,desktopName,name)
{

     main_w = new QWidgetStack( widgetParent, "main_w" );
     //QVBoxLayout* lo = new QVBoxLayout(main_w);
/*

     tbp=new Smb4KToolBarParent(main_w);
     m_toolbar = new Smb4KToolBar(tbp);
     tbp->setToolBar(m_toolbar);
     m_toolbar->setFlat(true);
     m_toolbar->setIconText( KToolBar::IconOnly );
     m_toolbar->setIconSize( 16 );

     m_toolbar->addSeparator();


     QPixmap pix;
     QToolButton *upButton;

     pix = QPixmap( cdtoparent_xpm );
     upButton = new QToolButton( pix, "One directory up", QString::null,
                                this, SLOT( slotSetOpen() ), m_toolbar, "cd up" );

     main_w->addWidget(m_toolbar);

     m_toolbar->show();

*/
     widget = new KListView( main_w, "NetworkView" );
     widget->addColumn( i18n( "Network" ), -1 );
     widget->addColumn( i18n( "Type" ), -1 );
     widget->addColumn( i18n( "IP Address" ), -1 );
     widget->addColumn( i18n( "Comment" ), -1 );
     widget->setRootIsDecorated( true );
     QToolTip::add( widget, i18n( "Network neighborhood" ) );

     main_w->addWidget(widget);
     //main_w->raiseWidget(m_toolbar);

     // The core:
     m_core = new Smb4KCore( widgetParent, "Core" );

     // Action menu stuff
     m_collection = new KActionCollection( this, "KonquerorPlugin_ActionCollection", KGlobal::instance() );
     m_menu = new Smb4KBrowserActionMenu( Smb4KBrowserActionMenu::KonqPlugin, m_collection, QString::null, QIconSet(), widget, "KonquerorPlugin_ActionMenu" );
     m_menu->popupMenu()->insertSeparator( -1 );
     m_menu->insert( new KAction( i18n( "Configuration" ), "configure", CTRL+Key_O, 0, 0, m_collection, "configure_action" ) );

     m_menu->askpassAction()->setEnabled( false );
     m_menu->mountAction()->setEnabled( false );

     slotReadOptions();

     // Action connections
     connect( m_collection->action( "rescan_action" ),    SIGNAL( activated() ), this, SLOT( slotRescan() ) );
     connect( m_collection->action( "askpass_action" ),   SIGNAL( activated() ), this, SLOT( slotAskPass() ) );
     connect( m_collection->action( "mount_action" ),     SIGNAL( activated() ), this, SLOT( slotMountShare() ) );
     connect( m_collection->action( "configure_action" ), SIGNAL( activated() ), this, SLOT( slotSmb4KOptionsDlg() ) );

     // Widget specific connections.
     connect( widget, SIGNAL( executed( QListViewItem * ) ), SLOT( slotItemExecuted( QListViewItem * ) ) );
     connect( widget, SIGNAL( expanded( QListViewItem * ) ), SLOT( slotItemExpandedCollapsed( QListViewItem * ) ) );
     connect( widget, SIGNAL( collapsed( QListViewItem * ) ), SLOT( slotItemExpandedCollapsed( QListViewItem * ) ) );
     connect( widget, SIGNAL( selectionChanged( QListViewItem * ) ), SLOT( slotSelectionChanged( QListViewItem * ) ) );
     connect( widget, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint &, int ) ), SLOT( slotRightButtonPressed( QListViewItem *, const QPoint &, int ) ) );

     // External connections.
     connect( m_core,            SIGNAL( runStateChanged() ), this, SLOT( slotCoreRunStateChanged() ) );
     connect( m_core->scanner(), SIGNAL( workgroups( const QValueList<Smb4KWorkgroupItem *> & ) ), this, SLOT( slotWorkgroups( const QValueList<Smb4KWorkgroupItem *> & ) ) );
     connect( m_core->scanner(), SIGNAL( members( const QValueList<Smb4KHostItem *> & ) ), this, SLOT( slotMembers( const QValueList<Smb4KHostItem *> & ) ) );
     connect( m_core->scanner(), SIGNAL( shares( const QValueList<Smb4KShareItem *> & ) ), this, SLOT( slotShares( const QValueList<Smb4KShareItem *> & ) ) );
     connect( m_core->scanner(), SIGNAL( ipAddress( Smb4KHostItem * ) ), this, SLOT( slotAddIPAddress( Smb4KHostItem * ) ) );
     connect( m_core->mounter(), SIGNAL( updated() ), this, SLOT( slotMarkShares() ) );
     connect( m_core->mounter(), SIGNAL( mountedShare( const QString &) ), this, SLOT( slotMountedShare( const QString & ) ) );
     connect( m_core->mounter(), SIGNAL( alreadyMountedShare( const QString &) ), this, SLOT( slotMountedShare( const QString & ) ) );
}


KonqSidebar_Smb4K::~KonqSidebar_Smb4K()
{
  if ( m_menu )
  {
    delete m_menu;
  }

  uint index = 0;

  while ( index < m_collection->count() )
  {
    delete m_collection->action( index++ );
  }

  m_collection->clear();

  // FIXME: This definitely does not work!
  // Massimo: Is there a possibility to use the KApplication::shutDown() signal
  // or similar?
  m_core->mounter()->unmountAllShares();
}

extern "C"
{
    void* create_konqsidebar_smb4k(KInstance *instance,QObject *par,QWidget *widp,QString &desktopname,const char *name)
    {
     KGlobal::locale()->insertCatalogue( "smb4k" );
     return new KonqSidebar_Smb4K(instance,par,widp,desktopname,name);
    }
};

extern "C"
{
 bool add_konqsidebar_smb4k(QString* fn, QString* /*param*/, QMap<QString,QString> *map)
     {
      map->insert("Type","Link");
      map->insert("Icon","smb4k");
      map->insert("Name",i18n("Samba Browser"));
      map->insert("Open","false");
      map->insert("X-KDE-KonqSidebarModule","konqsidebar_smb4k");
      fn->setLatin1("smb4k%1.desktop");
      return true;
     }
}

void KonqSidebar_Smb4K::handleURL(const KURL &url)
{
 currentKonquerorURL = url.path();
 //kdDebug() << "KonqSidebar_Smb4K::handleURL - "<< currentKonquerorURL << endl;
}

void KonqSidebar_Smb4K::setOpen( QListViewItem *item, bool open, bool use_setOpen )
{
  if ( open )
  {
    switch ( item->depth() )
    {
      case 0:
      {
        Smb4KWorkgroupItem *i = smb4k_core->scanner()->getWorkgroup( item->text( Network ) );
        smb4k_core->scanner()->getWorkgroupMembers( item->text( Network ), i->master(), i->ip() );
        break;
      }
      case 1:
      {
        smb4k_core->scanner()->getShares( item->parent()->text( Network ), item->text( Network ), item->text( IP ) );
        break;
      }
      default:
        break;
    }
  }
  else
  {
    switch ( item->depth() )
    {
      case 1:
      {
        // Remove all children (shares).
        QListViewItem *shareItem = item->firstChild();

        while ( shareItem )
        {
          delete shareItem;
          shareItem = item->firstChild();
        }

        break;
      }
      default:
        break;
    }
  }

  if ( use_setOpen )
  {
    widget->setOpen( item, open );
  }
}

void KonqSidebar_Smb4K::slotCoreRunStateChanged()
{
 return;
}

void KonqSidebar_Smb4K::slotItemExecuted( QListViewItem *item )
{
  if ( item )
  {
    if ( item->depth() == 2 )
    {
      if ( item->text( Type ).contains( "Printer" ) == 0 )
      {
        slotMountShare();
      }
//       else
//       {
//         slotPrint();
//       }
    }
    else
    {
      setOpen( item, !item->isOpen(), true );
    }
  }
}


void KonqSidebar_Smb4K::slotItemExpandedCollapsed( QListViewItem *item )
{
  widget->setSelected( item, true );

  // Since it seems to be not easy to intercept KListView::setOpen(), we
  // handle the opening and closing of an item via the root decoration
  // this way:
  setOpen( item, item->isOpen(), false );
}


void KonqSidebar_Smb4K::slotSelectionChanged( QListViewItem *item )
{
  if ( item && item->depth() == 2 )
  {
    m_collection->action( "askpass_action" )->setEnabled( true );

    if ( item->text( Type ).contains( "Printer" ) == 0 )
    {
      m_collection->action( "mount_action" )->setEnabled( true );
    }
    else
    {
      m_collection->action( "mount_action" )->setEnabled( false );
    }
  }
  else if ( item && item->depth() == 1 )
  {
    m_collection->action( "askpass_action" )->setEnabled( true );
    m_collection->action( "mount_action" )->setEnabled( false );
  }
  else
  {
    m_collection->action( "mount_action" )->setEnabled( false );
    m_collection->action( "askpass_action" )->setEnabled( false );
  }
}


void KonqSidebar_Smb4K::slotRightButtonPressed( QListViewItem *item, const QPoint &point, int )
{
  if ( !item )
  {
    m_menu->popupMenu()->changeTitle( 0, SmallIcon( "network" ), i18n( "Network" ) );
  }
  else
  {
    m_menu->popupMenu()->changeTitle( 0, *(item->pixmap( 0 )), item->text( 0 ) );

    if ( item->depth() == 0 )
    {
      m_collection->action( "rescan_action" )->setText( i18n( "Scan Wo&rkgroup" ) );
    }
    else
    {
      m_collection->action( "rescan_action" )->setText( i18n( "Scan Compute&r" ) );
    }
  }

  slotSelectionChanged( item );

  m_menu->popupMenu()->exec( point, 0 );

  m_collection->action( "rescan_action" )->setText( i18n( "Scan Netwo&rk" ) );
}


void KonqSidebar_Smb4K::slotWorkgroups( const QValueList<Smb4KWorkgroupItem *> &list )
{
  // Clear the network tab completely.
  //sapp->view()->networkTab()->clear( 0 );

  // Clear the list view:
  widget->clear();

  // Adjust the columns.
  for ( int index = 0; index < widget->columns(); index++ )
  {
    if ( widget->columnWidth( index ) != 0 )
      widget->adjustColumn( index );
  }

  // Put the workgroups into the list view.
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KWorkgroupItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( widget->findItem( (*it)->workgroup(), Network, CaseSensitive|ExactMatch ) == 0 )
      {
        Smb4KBrowserWidgetItem *workgroup = new Smb4KBrowserWidgetItem( widget, *it );
        workgroup->setExpandable( true );
      }
      else
      {
        continue;
      }
    }
  }
}



void KonqSidebar_Smb4K::slotMembers( const QValueList<Smb4KHostItem *> &list )
{
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KHostItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      Smb4KBrowserWidgetItem *item = (Smb4KBrowserWidgetItem *)(widget->findItem( (*it)->name(), Network, CaseSensitive|ExactMatch ));

      if ( item )
      {
        item->update( *it );

        continue;
      }
      else
      {
        QListViewItem *workgroup = widget->findItem( (*it)->workgroup(), Network, ExactMatch|CaseSensitive );

        if ( workgroup )
        {
          Smb4KBrowserWidgetItem *host = new Smb4KBrowserWidgetItem( workgroup, *it );
          host->setExpandable( true );
        }
      }
    }
  }
}


void KonqSidebar_Smb4K::slotShares( const QValueList<Smb4KShareItem *> &list )
{
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KShareItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      QListViewItem *host = widget->findItem( (*it)->host(), Network, ExactMatch|CaseSensitive );

      if ( host != 0 )
      {
        if ( !m_hidden && (*it)->name().endsWith( "$" ) )
        {
          continue;
        }
        else
        {
          if ( !m_ipc && (*it)->name().contains( "IPC" ) != 0 )
            continue;

          if ( !m_admin && (*it)->name().contains( "ADMIN" ) != 0 )
            continue;
        }

        if ( !m_printer && QString::compare( (*it)->name(), "Printer" ) == 0 )
        {
          continue;
        }

        Smb4KBrowserWidgetItem *test = (Smb4KBrowserWidgetItem *)(widget->findItem( (*it)->name(), Network, ExactMatch|CaseSensitive ));

        if ( !test || test->parent() != host )
        {
          Smb4KBrowserWidgetItem *share = new Smb4KBrowserWidgetItem( host, *it );
          share->setExpandable( false );

          continue;
        }
        else if ( test && test->parent() == host )
        {
          if ( QString::compare( test->text( Comment ), (*it)->comment() ) != 0 )
          {
            test->update( *it );
          }

          continue;
        }
      }
    }
  }
}

void KonqSidebar_Smb4K::slotMountShare()
{
  if ( widget->currentItem() && widget->currentItem()->depth() == 2 )
  {
    m_core->mounter()->mountShare( widget->currentItem()->parent()->parent()->text( Network ), widget->currentItem()->parent()->text( Network ), widget->currentItem()->parent()->text( IP ), widget->currentItem()->text( Network ) );
  }
}

void KonqSidebar_Smb4K::slotUnmountShare()
{
 Smb4KBrowserWidgetItem *i = (Smb4KBrowserWidgetItem *)widget->currentItem();
 QString tmpPath;
 if ( i && i->depth() == 2 )
   {
    Smb4KShare *share = m_core->mounter()->findShareByName( QString( "//%1/%2" ).arg( i->parent()->text( Network ), i->text( Network ) ) );
    tmpPath = share->path();
    //kdDebug() << "KonqSidebar_Smb4K::slotUnmountShare - "<< tmpPath << endl;
    if ( QString::compare( tmpPath, currentKonquerorURL ) == 0 )
          emit openURLRequest( KURL( QDir::home().canonicalPath() ) );
    m_core->mounter()->unmountShare( share );
   }
}

void KonqSidebar_Smb4K::slotAskPass()
{
  if ( widget->currentItem() && widget->currentItem()->depth() == 1 )
  {
    QString workgroup = widget->currentItem()->parent()->text( Network );
    QString host = widget->currentItem()->text( Network );
    QString share = QString::null;

    m_core->passwordHandler()->askpass( workgroup, host, share, Smb4KPasswordHandler::NewData );
  }
  else if ( widget->currentItem() && widget->currentItem()->depth() == 2 )
  {
    QString workgroup = widget->currentItem()->parent()->parent()->text( Network );
    QString host = widget->currentItem()->parent()->text( Network );
    QString share = widget->currentItem()->text( Network );

    m_core->passwordHandler()->askpass( workgroup, host, share, Smb4KPasswordHandler::NewData );
  }
}

void KonqSidebar_Smb4K::slotAddIPAddress( Smb4KHostItem *item )
{
  if ( item )
  {
    Smb4KBrowserWidgetItem *workgroup = (Smb4KBrowserWidgetItem *)(widget->findItem( item->workgroup(), Network, ExactMatch|CaseSensitive ));

    if ( workgroup && QString::compare( workgroup->text( Network ), item->workgroup() ) == 0 )
    {
      Smb4KWorkgroupItem *wg = smb4k_core->scanner()->getWorkgroup( item->workgroup() );

      if ( wg )
      {
        workgroup->update( wg );
      }
    }

    Smb4KBrowserWidgetItem *hostItem = (Smb4KBrowserWidgetItem *)(widget->findItem( item->name(), Network, ExactMatch|CaseSensitive ));

    if ( hostItem && hostItem->parent() && QString::compare( hostItem->parent()->text( Network ), item->workgroup() ) == 0 )
    {
      hostItem->update( item );

      if ( widget->columnWidth( IP ) != 0 )
      {
        widget->adjustColumn( IP );
      }
    }
  }
}

void KonqSidebar_Smb4K::slotMarkShares()
{
  config()->setGroup( "Appearance" );
  bool show_all = config()->readBoolEntry( "Show All Shares", false );

  QListViewItemIterator it( widget );
  QListViewItem *item;

  while ((item = it.current()) != 0 )
  {
    ++it;

    if ( item->depth() == 2 )
    {
      Smb4KShare *share = m_core->mounter()->findShareByName( QString( "//%1/%2" ).arg( item->parent()->text( Network ), item->text( Network ) ) );

      if ( m_core->mounter()->isMounted( QString( "//%1/%2" ).arg( item->parent()->text( Network ), item->text( Network ) ) )
           && ( !share->isForeign() || show_all ) )
      {
        if ( !((Smb4KBrowserWidgetItem *)item)->isMounted() )
        {
          ((Smb4KBrowserWidgetItem *)item)->setMounted( true );
        }

        continue;
      }
      else
      {
        ((Smb4KBrowserWidgetItem *)item)->setMounted( false );
        continue;
      }
    }
    else
      continue;
  }
}

void KonqSidebar_Smb4K::slotMountedShare( const QString &mountedShare )
{
 emit openURLRequest( KURL(mountedShare) );
}

void KonqSidebar_Smb4K::slotSmb4KOptionsDlg()
{

  if ( child( "ConfigDialog", "KDialogBase", true ) == 0 )
  {
    Smb4KOptionsDlg *configDlg = new Smb4KOptionsDlg( widget, "ConfigDialog", false );
    connect( configDlg, SIGNAL( savedOptions() ), this, SLOT( slotReadOptions() ) );
    configDlg->show();
  }

}


void KonqSidebar_Smb4K::slotRescan()
{
  smb4k_core->scanner()->rescan();
}


void KonqSidebar_Smb4K::slotReadOptions()
{
  // Read the configuration.
  config()->setGroup( "Appearance" );
  bool showType = config()->readBoolEntry( "Show Type", true );
  bool showComment = config()->readBoolEntry( "Show Comment", true );
  bool showIP = config()->readBoolEntry( "Show IP", true );

  // Now put everything back in according to the wishes of the user.
  if ( showIP )
  {
    widget->setColumnWidth( IP, 10 );
    widget->setColumnWidthMode( IP, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( IP, 0 );
    widget->setColumnWidthMode( IP, QListView::Manual );
  }

  if ( showType )
  {
    widget->setColumnWidth( Type, 10 );
    widget->setColumnWidthMode( Type, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( Type, 0 );
    widget->setColumnWidthMode( Type, QListView::Manual );
  }

  if ( showComment )
  {
    widget->setColumnWidth( Comment, 10 );
    widget->setColumnWidthMode( Comment, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( Comment, 0 );
    widget->setColumnWidthMode( Comment, QListView::Manual );
  }

  // Adjust the columns. Avoid those that have a width of 0.
  int index = 0;
  while ( index < widget->columns() )
  {
    if ( widget->columnWidth( index ) != 0 )
      widget->adjustColumn( index );

    index++;
  }

  // Initialize the rest.
  m_hidden = config()->readBoolEntry( "Show Hidden", true );
  m_ipc = config()->readBoolEntry( "Show IPC", false );
  m_admin = config()->readBoolEntry( "Show ADMIN", false );
  m_printer = config()->readBoolEntry( "Show Printer", true );
}

//
// STUFF FOR THE TOOLBAR
//

Smb4KToolBar::Smb4KToolBar(QWidget *parent):KToolBar( parent, "SMB4K_Toolbar", true )
{
 setMinimumWidth(10);
}

Smb4KToolBar::~Smb4KToolBar(){}

void Smb4KToolBar::setMovingEnabled( bool)
{
 KToolBar::setMovingEnabled(false);
}

Smb4KToolBarParent::Smb4KToolBarParent(QWidget *parent)
     :QFrame(parent),m_tb(0){}
Smb4KToolBarParent::~Smb4KToolBarParent(){}
void Smb4KToolBarParent::setToolBar(Smb4KToolBar *tb)
{
 m_tb=tb;
}

void Smb4KToolBarParent::resizeEvent ( QResizeEvent * )
{
 if (m_tb)
   {
    setMinimumHeight(m_tb->sizeHint().height());
    //m_tb->resize(width(),height());
   }
}

#include "smb4k_konqplugin.moc"





