/***************************************************************************
                          smb4ksharesmenuwidget  -  description
                             -------------------
    begin                : Mi Mr 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSHARESMENUWIDET_H
#define SMB4KSHARESMENUWIDET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kactionclasses.h>
#include <kactioncollection.h>

/**
 * This class provides a KActionMenu filled with all mounted shares.
 * Each share is layed out as KAction. Clicking one of them will open
 * the mount point in Konqueror.
 *
 * @author  Alexander Reinholdt
 */

class Smb4KSharesMenuWidget : public KActionMenu
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent      the parent widget
     *
     * @param name        the name of the class
     */
    Smb4KSharesMenuWidget( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KSharesMenuWidget();
    /**
     * This function returns a pointer to the action collection of this class.
     * You should use it to include the action into the action collection of the
     * main action collection (e.g. KMainWindow::actionCollection()).
     *
     * The actions in this collection are members of the group "MountedShares".
     *
     * @returns       a pointer to the action collection of this class
     */
    KActionCollection *action_collection() { return m_collection; }

  protected slots:
    /**
     * This slot should be called when the list of mounted shares changed.
     */
    void slotUpdatedShareList();
    /**
     * This slot is activated, if a share is clicked in the popup menu
     * of the mounted shares.
     */
    void slotActivated();
    /**
     * This slot is activated whenever an action is highlighted.
     *
     * @param action        the action that is highlighted
     */
    void slotActionHighlighted( KAction *action );

  private:
    /**
     * The action collection of this class.
     */
    KActionCollection *m_collection;
    /**
     * The currently highlighted KAction.
     */
    KAction *m_action;
};

#endif
