/***************************************************************************
                          smb4kbrowserwidgetitem  -  description
                             -------------------
    begin                : So Jan 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KBROWSERWIDGETITEM_H
#define SMB4KBROWSERWIDGETITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <klistview.h>

// application specific includes
#include "../core/smb4knetworkitems.h"


/**
 * This class cares about the items that are inserted into the browser widget.
 */

class Smb4KBrowserWidget;
class Smb4KBrowserWidgetItem : public QListViewItem
{
  public:
    /**
     * The constructor for toplevel (workgroup) items.
     *
     * @param parent        The parent list view.
     *
     * @param item          The Smb4KWorkgroupItem that carries all the data
     *                      needed to set up a "workgroup item".
     */
    Smb4KBrowserWidgetItem( QListView *parent, Smb4KWorkgroupItem *item );
    /**
     * The constructor for the workgroup member items.
     */
    Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KHostItem *item );
    /**
     * The constructor for the share items.
     */
    Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KShareItem *item );
    /**
     * The destructor.
     */
    virtual ~Smb4KBrowserWidgetItem();
    /**
     * Returns a pointer to the Smb4KWorkgoupItem object.
     */
    Smb4KWorkgroupItem *getWorkgroupItem() const { return m_workgroup; }
    /**
     * Returns a pointer to the Smb4KHostItem object.
     */
    Smb4KHostItem *getHostItem() const { return m_host; }
    /**
     * Returns a pointer to the Smb4KShareItem.
     */
    Smb4KShareItem *getShareItem() const { return m_share; }
    /**
     * Tells the Smb4KBrowserWidgetItem if the share is already mounted or not and sets the
     * folder icon accordingly (open folder == mounted, closed folder == not mounted).
     * @param mounted Has to be TRUE if the share is mounted and FALSE otherwise.
     * This function will only work with shares. Workgroup and host items are ignored.
     */
    void setMounted( bool mounted );
    /**
     * Returns TRUE if the share is mounted and FALSE otherwise.
     */
    bool isMounted() { return m_mounted; }

  protected:
    /**
     * Reimplemented from QListViewItem.
     */
    void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

  private:
    /**
     * The Smb4KWorkgroupItem object.
     */
    Smb4KWorkgroupItem *m_workgroup;
    /**
     * The Smb4KHostItem object.
     */
    Smb4KHostItem *m_host;
    /**
     * The Smb4KShareItem object.
     */
    Smb4KShareItem *m_share;
    /**
     * Is TRUE if the share is mounted and FALSE otherwise.
     * It will only be set, if Smb4KBrowserWidgetItem::depth() == 2,
     * i. e. it is a share.
     */
    bool m_mounted;
};

#endif
