/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimocallegari@yahoo.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// Qt includes
#include <qlabel.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qheader.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qdir.h>

// KDE includes
#include <kinstance.h>
#include <klocale.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <ktoolbarbutton.h>

// plugin specific includes
// #include "smb4k_konqplugin.moc"
#include "smb4k_konqplugin.h"
#include "widgets/smb4kbrowserwidgetitem.h"
#include "widgets/smb4koptionsdlg.h"
#include "core/smb4kglobal.h"

using namespace  Smb4K_Global;


KonqSidebar_Smb4K::KonqSidebar_Smb4K(KInstance *inst,QObject *parent,QWidget *widgetParent, QString &desktopName, const char* name):
                   KonqSidebarPlugin(inst,parent,widgetParent,desktopName,name)
{

     main_w = new QWidgetStack( widgetParent, "main_w" );
     //QVBoxLayout* lo = new QVBoxLayout(main_w);
/*

     tbp=new Smb4KToolBarParent(main_w);
     m_toolbar = new Smb4KToolBar(tbp);
     tbp->setToolBar(m_toolbar);
     m_toolbar->setFlat(true);
     m_toolbar->setIconText( KToolBar::IconOnly );
     m_toolbar->setIconSize( 16 );

     m_toolbar->addSeparator();


     QPixmap pix;
     QToolButton *upButton;

     pix = QPixmap( cdtoparent_xpm );
     upButton = new QToolButton( pix, "One directory up", QString::null,
                                this, SLOT( slotSetOpen() ), m_toolbar, "cd up" );

     main_w->addWidget(m_toolbar);

     m_toolbar->show();

*/
     widget = new KListView( main_w, "NetworkView" );
     widget->addColumn( i18n( "Network" ), -1 );
     widget->addColumn( i18n( "Type" ), -1 );
     widget->addColumn( i18n( "IP Address" ), -1 );
     widget->addColumn( i18n( "Comment" ), -1 );
     widget->setRootIsDecorated( true );
     QToolTip::add( widget, i18n( "Network neighborhood" ) );

     main_w->addWidget(widget);
     //main_w->raiseWidget(m_toolbar);

     // The core:
     m_core = new Smb4KCore( widgetParent, "Core" );
     m_menu = new KPopupMenu( widgetParent );

     slotReadOptions();

     // Connections
     connect( m_core, SIGNAL( runStateChanged() ), this, SLOT( slotCoreRunStateChanged() ) );

     // Widget specific connections.
     connect( widget, SIGNAL( executed( QListViewItem * ) ), SLOT( slotItemExecuted( QListViewItem * ) ) );
     connect( widget, SIGNAL( expanded( QListViewItem * ) ), SLOT( slotItemExpandedCollapsed( QListViewItem * ) ) );
     connect( widget, SIGNAL( collapsed( QListViewItem * ) ), SLOT( slotItemExpandedCollapsed( QListViewItem * ) ) );
     connect( widget, SIGNAL( selectionChanged( QListViewItem * ) ), SLOT( slotSelectionChanged( QListViewItem * ) ) );
     connect( widget, SIGNAL( clicked( QListViewItem * ) ), SLOT( slotItemClicked( QListViewItem * ) ) );
     connect( widget, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint &, int ) ), SLOT( slotRightButtonPressed( QListViewItem *, const QPoint &, int ) ) );
     connect( widget, SIGNAL( setOpen( QListViewItem *, bool ) ), SLOT( slotSetOpen( QListViewItem *, bool ) ) );

     // External connections.

     connect( m_core->scanner(), SIGNAL( workgroups( const QValueList<Smb4KWorkgroupItem *> & ) ), this, SLOT( slotWorkgroups( const QValueList<Smb4KWorkgroupItem *> & ) ) );
     connect( m_core->scanner(), SIGNAL( members( const QValueList<Smb4KHostItem *> & ) ), this, SLOT( slotMembers( const QValueList<Smb4KHostItem *> & ) ) );
     connect( m_core->scanner(), SIGNAL( shares( const QValueList<Smb4KShareItem *> & ) ), this, SLOT( slotShares( const QValueList<Smb4KShareItem *> & ) ) );
     connect( m_core->ipFinder(), SIGNAL( ip_address( Smb4KHostItem * ) ), this, SLOT( slotAddIPAddress( Smb4KHostItem * ) ) );
     connect( m_core->mounter(),   SIGNAL( updated() ), this, SLOT( slotMarkShares() ) );
     connect( m_core->mounter(), SIGNAL( mountedShare( const QString &) ), this, SLOT( slotMountedShare( const QString & ) ) );
}


KonqSidebar_Smb4K::~KonqSidebar_Smb4K()
{
 m_core->mounter()->unmountAllShares();
}

extern "C"
{
    void* create_konqsidebar_smb4k(KInstance *instance,QObject *par,QWidget *widp,QString &desktopname,const char *name)
    {
     KGlobal::locale()->insertCatalogue("konqsidebar_smb4k");
     return new KonqSidebar_Smb4K(instance,par,widp,desktopname,name);
    }
};

extern "C"
{
 bool add_konqsidebar_smb4k(QString* fn, QString* /*param*/, QMap<QString,QString> *map)
     {
      map->insert("Type","Link");
      map->insert("Icon","smb4k");
      map->insert("Name",i18n("Samba Browser"));
      map->insert("Open","false");
      map->insert("X-KDE-KonqSidebarModule","konqsidebar_smb4k");
      fn->setLatin1("smb4k%1.desktop");
      return true;
     }
}

void KonqSidebar_Smb4K::handleURL(const KURL &url)
{
 currentKonquerorURL = url.path();
 //kdDebug() << "KonqSidebar_Smb4K::handleURL - "<< currentKonquerorURL << endl;
}

void KonqSidebar_Smb4K::slotSetOpen( QListViewItem *item, bool open )
{
  if ( open && item->depth() == 0 )
  {
    Smb4KWorkgroupItem *i = m_core->scanner()->getWorkgroup( item->text( Network ) );

    m_core->scanner()->getWorkgroupMembers( item->text( Network ), i->master(), i->ip() );
  }
  else if ( open && item->depth() == 1 && item->childCount() == 0 )
  {
    m_core->scanner()->getShares( item->parent()->text( Network ), item->text( Network ), item->text( IP ) );
  }
  widget->setOpen( item, open );
}

void KonqSidebar_Smb4K::slotCoreRunStateChanged()
{
 return;
}

void KonqSidebar_Smb4K::slotItemExecuted( QListViewItem *item )
{
  if ( item && item->depth() == 2 )
  {
    if ( item->text( Type ).contains( "Printer" ) == 0 )
    {
      slotMountShare();
    }
/*
    else
    {
      slotPrint();
    }
*/
  }
}


void KonqSidebar_Smb4K::slotItemExpandedCollapsed( QListViewItem *item )
{
  widget->setSelected( item, true );
}


void KonqSidebar_Smb4K::slotSelectionChanged( QListViewItem *item )
{
 bool open = true;

 if ( open && item->depth() == 0 )
  {
    Smb4KWorkgroupItem *i = m_core->scanner()->getWorkgroup( item->text( Network ) );

    m_core->scanner()->getWorkgroupMembers( item->text( Network ), i->master(), i->ip() );
  }
  else if ( open && item->depth() == 1 && item->childCount() == 0 )
  {
    m_core->scanner()->getShares( item->parent()->text( Network ), item->text( Network ), item->text( IP ) );
  }
  widget->setOpen( item, open );
 return;
}


void KonqSidebar_Smb4K::slotRightButtonPressed( QListViewItem *item, const QPoint &point, int col )
{
  m_menu->clear();

  // The icon sets:
  QIconSet reloadSet( SmallIcon( "reload" ), QIconSet::Automatic );
  QIconSet abortSet( SmallIcon( "stop" ), QIconSet::Automatic );
  QIconSet searchSet( SmallIcon( "find" ), QIconSet::Automatic );
  QIconSet authSet( SmallIcon( "personal" ), QIconSet::Automatic );
  //QIconSet previewSet( SmallIcon( "view_icon" ), QIconSet::Automatic );
  //QIconSet printSet( SmallIcon( "printer1" ), QIconSet::Automatic );
  QIconSet mountSet( SmallIcon( "hdd_mount" ), QIconSet::Automatic );
  QIconSet unmountSet( SmallIcon( "hdd_unmount" ), QIconSet::Automatic );
  QIconSet prefSet( SmallIcon( "configure" ), QIconSet::Automatic );

  // Menu items
  m_menu->insertTitle( SmallIcon( "network" ), i18n( "Network" ), Title, 0 );
  m_menu->insertItem( reloadSet, i18n( "Rescan" ), m_core->scanner(), SLOT( slotInit() ), CTRL+Key_R, Rescan, 1 );
  m_menu->insertSeparator( 2 );
  m_menu->insertItem( authSet, i18n( "Authentication" ), this, SLOT( slotAskPass() ), CTRL+Key_T, Password, 7 );
  //m_menu->insertItem( previewSet, i18n( "Preview" ), this, SLOT( slotPreview() ), CTRL+Key_V, Preview, 8 );
  //m_menu->insertItem( printSet, i18n( "Print File" ), this, SLOT( slotPrint() ), CTRL+Key_P, Print, 9 );

  if ( item )
  {
    if(((Smb4KBrowserWidgetItem *)item)->isMounted())
      m_menu->insertItem( unmountSet, i18n( "Unmount" ), this, SLOT( slotUnmountShare() ), CTRL+Key_U, Mount, 10 );
    else
      m_menu->insertItem( mountSet, i18n( "Mount" ), this, SLOT( slotMountShare() ), CTRL+Key_M, Mount, 10 );
  }
  // Maybe you want to remove the following since it is not necessary to put this item
  // into the menu.
  else
  {
    m_menu->insertItem( mountSet, i18n( "Mount" ), this, SLOT( slotMountShare() ), CTRL+Key_M, Mount, 10 );
  }

  m_menu->insertSeparator( 5 );
  m_menu->insertItem( prefSet, i18n( "Configuration" ), this, SLOT( slotSmb4KOptionsDlg() ), CTRL+Key_O, Preferences, 10 );

  // Enable and disable menu items.
  if ( m_core->scannerIsRunning() || m_core->mounterIsRunning() )
  {
    m_menu->setItemEnabled( Abort, true );

    if ( m_core->scannerIsRunning() && m_core->scannerState() != SCANNER_STOP )
    {
      m_menu->setItemEnabled( Rescan, false );
    }
    else
      m_menu->setItemEnabled( Rescan, true );
  }
  else
  {
    m_menu->setItemEnabled( Rescan, true );
    m_menu->setItemEnabled( Abort, false );
  }

  if ( item && item->depth() == 2 && col < widget->columns() )
  {
    m_menu->setItemEnabled( Password, true );

    if ( item->text( Type ).contains( "Printer" ) == 0 )
    {
      //m_menu->setItemEnabled( Preview, true );
      //m_menu->setItemEnabled( Print, false );
      m_menu->setItemEnabled( Mount, true );
    }
    else
    {
      //m_menu->setItemEnabled( Preview, false );
      //m_menu->setItemEnabled( Print, true );
      m_menu->setItemEnabled( Mount, false );
    }
  }
  else if ( item && item->depth() == 1 && col < widget->columns() )
  {
    m_menu->setItemEnabled( Password, true );
    //m_menu->setItemEnabled( Preview, false );
    //m_menu->setItemEnabled( Print, false );
    m_menu->setItemEnabled( Mount, false );
  }
  else
  {
    //m_menu->setItemEnabled( Preview, false );
    //m_menu->setItemEnabled( Print, false );
    m_menu->setItemEnabled( Mount, false );
    m_menu->setItemEnabled( Password, false );
  }

  m_menu->exec( point, 0 );
}


void KonqSidebar_Smb4K::slotWorkgroups( const QValueList<Smb4KWorkgroupItem *> &list )
{
  // Clear the network tab completely.
  //sapp->view()->networkTab()->clear( 0 );

  // Clear the list view:
  widget->clear();

  // Adjust the columns.
  for ( int index = 0; index < widget->columns(); index++ )
  {
    if ( widget->columnWidth( index ) != 0 )
      widget->adjustColumn( index );
  }

  // Put the workgroups into the list view.
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KWorkgroupItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( widget->findItem( (*it)->workgroup(), Network, CaseSensitive|ExactMatch ) == 0 )
      {
        Smb4KBrowserWidgetItem *workgroup = new Smb4KBrowserWidgetItem( widget, *it );
        workgroup->setExpandable( true );
      }
      else
      {
        continue;
      }
    }
  }
}



void KonqSidebar_Smb4K::slotMembers( const QValueList<Smb4KHostItem *> &list )
{
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KHostItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      QListViewItem *item = widget->findItem( (*it)->name(), Network, CaseSensitive|ExactMatch );

      if ( item != 0 )
      {
        if ( !((*it)->ip()).isEmpty() && QString::compare( item->text( IP ), (*it)->ip() ) != 0 )
        {
          item->setText( IP, (*it)->ip() );
        }

        if ( !((*it)->comment()).isEmpty() && QString::compare( item->text( Comment ), (*it)->comment() ) != 0 )
        {
          item->setText( Comment, (*it)->comment() );
        }

        continue;
      }
      else
      {
        Smb4KBrowserWidgetItem *host = new Smb4KBrowserWidgetItem( widget->findItem( (*it)->workgroup(), Network, ExactMatch|CaseSensitive ), *it );
        host->setExpandable( true );
      }
    }
  }
}


void KonqSidebar_Smb4K::slotShares( const QValueList<Smb4KShareItem *> &list )
{
  if ( !list.isEmpty() )
  {
    for ( QValueList<Smb4KShareItem *>::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      QListViewItem *host = widget->findItem( (*it)->host(), Network, ExactMatch|CaseSensitive );

      if ( host != 0 )
      {
        if ( !m_hidden && (*it)->name().endsWith( "$" ) )
        {
          continue;
        }
        else
        {
          if ( !m_ipc && (*it)->name().contains( "IPC" ) != 0 )
            continue;

          if ( !m_admin && (*it)->name().contains( "ADMIN" ) != 0 )
            continue;
        }

        if ( !m_printer && QString::compare( (*it)->name(), "Printer" ) == 0 )
        {
          continue;
        }

        QListViewItem *test = widget->findItem( (*it)->name(), Network, ExactMatch|CaseSensitive );

        if ( test == 0 || test->parent() != host )
        {
          Smb4KBrowserWidgetItem *share = new Smb4KBrowserWidgetItem( host, *it );
          share->setExpandable( false );

          continue;
        }
        else if ( test != 0 && test->parent() == host )
        {
          if ( !((*it)->comment()).isEmpty() && QString::compare( test->text( Comment ), (*it)->comment() ) != 0 )
          {
            test->setText( Comment, (*it)->comment() );
          }

          continue;
        }
      }
    }
  }
}

void KonqSidebar_Smb4K::slotMountShare()
{
  if ( widget->currentItem() && widget->currentItem()->depth() == 2 )
  {
    if ( QString::compare( widget->currentItem()->text( Network ).stripWhiteSpace(), "homes" ) == 0 )
    {
      QString name = specifyUser( widget->currentItem()->parent()->text( Network ) );
      if ( !name.isEmpty() )
        m_core->mounter()->mountShare( widget->currentItem()->parent()->parent()->text( Network ), widget->currentItem()->parent()->text( Network ), widget->currentItem()->parent()->text( IP ), name );
    }
    else
      m_core->mounter()->mountShare( widget->currentItem()->parent()->parent()->text( Network ), widget->currentItem()->parent()->text( Network ), widget->currentItem()->parent()->text( IP ), widget->currentItem()->text( Network ) );
  }
}

void KonqSidebar_Smb4K::slotUnmountShare()
{
 Smb4KBrowserWidgetItem *i = (Smb4KBrowserWidgetItem *)widget->currentItem();
 QString tmpPath;
 if ( i && i->depth() == 2 )
   {
    Smb4KShare *share = m_core->mounter()->findShareByName( QString( "//%1/%2" ).arg( i->parent()->text( Network ), i->text( Network ) ) );
    tmpPath = share->getPath();
    //kdDebug() << "KonqSidebar_Smb4K::slotUnmountShare - "<< tmpPath << endl;
    if ( QString::compare( tmpPath, currentKonquerorURL ) == 0 )
          emit openURLRequest( KURL( QDir::home().canonicalPath() ) );
    m_core->mounter()->unmountShare( share->getPath(),
                                           QString( "%1" ).arg( share->getUID() ),
                                           QString( "%1" ).arg( share->getGID() ) );
   }
}

void KonqSidebar_Smb4K::slotAskPass()
{
  if ( widget->currentItem() && widget->currentItem()->depth() == 1 )
  {
    QString workgroup = widget->currentItem()->parent()->text( Network );
    QString host = widget->currentItem()->text( Network );
    QString share = QString::null;

    m_core->passwordHandler()->askpass( workgroup, host, share, Smb4KPasswordHandler::NewData );
  }
  else if ( widget->currentItem() && widget->currentItem()->depth() == 2 )
  {
    QString workgroup = widget->currentItem()->parent()->parent()->text( Network );
    QString host = widget->currentItem()->parent()->text( Network );
    QString share = widget->currentItem()->text( Network );

    m_core->passwordHandler()->askpass( workgroup, host, share, Smb4KPasswordHandler::NewData );
  }
}

void KonqSidebar_Smb4K::slotAddIPAddress( Smb4KHostItem *item )
{
  // First find the host and check wether it is the right one.
  QListViewItem *hostItem = widget->findItem( item->name(), Network, ExactMatch|CaseSensitive );

  if ( QString::compare( hostItem->parent()->text( Network ), item->workgroup() ) == 0 )
  {
    hostItem->setText( IP, item->ip() );

    if ( widget->columnWidth( IP ) != 0 )
    {
      widget->adjustColumn( IP );
    }
  }
}

void KonqSidebar_Smb4K::slotMarkShares()
{
  config()->setGroup( "Appearance" );
  bool show_all = config()->readBoolEntry( "Show All Shares", false );

  QListViewItemIterator it( widget );
  QListViewItem *item;

  while ((item = it.current()) != 0 )
  {
    ++it;

    if ( item->depth() == 2 )
    {
      Smb4KShare *share = m_core->mounter()->findShareByName( QString( "//%1/%2" ).arg( item->parent()->text( Network ), item->text( Network ) ) );

      if ( m_core->mounter()->isMounted( QString( "//%1/%2" ).arg( item->parent()->text( Network ), item->text( Network ) ) )
           && ( !share->isForeign() || show_all ) )
      {
        if ( !((Smb4KBrowserWidgetItem *)item)->isMounted() )
        {
          ((Smb4KBrowserWidgetItem *)item)->setMounted( true );
        }

        continue;
      }
      else
      {
        ((Smb4KBrowserWidgetItem *)item)->setMounted( false );
        continue;
      }
    }
    else
      continue;
  }
}

void KonqSidebar_Smb4K::slotMountedShare( const QString &mountedShare )
{
 emit openURLRequest( KURL(mountedShare) );
}

void KonqSidebar_Smb4K::slotSmb4KOptionsDlg()
{

  if ( child( "ConfigDialog", "KDialogBase", true ) == 0 )
  {
    Smb4KOptionsDlg *configDlg = new Smb4KOptionsDlg( widget, "ConfigDialog", false );
    connect( configDlg, SIGNAL( read() ), this, SLOT( slotReadOptions() ) );
    configDlg->show();
  }

}

const QString KonqSidebar_Smb4K::specifyUser( const QString &host )
{
  KDialogBase *dialog = new KDialogBase( KDialogBase::Plain, i18n( "Specify User" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, widget, 0, false, true );

  // Set up the ask pass dialog.
  QFrame *frame = dialog->plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 5 );

  QLabel *pic = new QLabel( frame );
  pic->setPixmap( DesktopIcon( "personal" ) );
  pic->setMargin( 10 );

  QLabel *text = new QLabel( i18n( "Please specify a user name." ), frame );

  QLabel *user = new QLabel( i18n( "User:" ), frame );
  KComboBox *username = new KComboBox( true, frame, 0 );
  username->setDuplicatesEnabled( false );

  QSpacerItem *spacer1 = new QSpacerItem( 10, 10, QSizePolicy::Expanding, QSizePolicy::Preferred );

  layout->addWidget( pic, 0, 0, 0 );
  layout->addMultiCellWidget( text, 0, 0, 1, 3, 0 );
  layout->addWidget( user, 1, 0, 0 );
  layout->addMultiCellWidget( username, 1, 1, 1, 4, 0 );
  layout->addItem( spacer1, 0, 2 );

  // Read the list of logins, that were already defined
  // for this 'homes' share.
  QStringList list;

  if ( config()->hasGroup( "Homes Shares" ) )
  {
    config()->setGroup( "Homes Shares" );
    if ( config()->hasKey( host ) )
      list = config()->readListEntry( host, ',' );
  }

  if ( !list.isEmpty() )
    username->insertStringList( list, -1 );

  username->setCurrentText( QString::null );

  // Do the last things before showing.
  username->setFocus();
  dialog->setFixedSize( dialog->sizeHint() );

  if ( dialog->exec() == KDialogBase::Accepted )
  {
    // Write the new list of logins to the config file.
    if ( list.contains( username->currentText() ) == 0 )
      list.append( username->currentText() );

    int index = 0;
    while ( index < username->count() )
    {
      if ( list.contains( username->text( index ) ) == 0 )
        list.append( username->text( index ) );

      index++;
    }

    list.sort();

    config()->setGroup( "Homes Shares" );
    config()->writeEntry( host, list, ',' );

    return username->currentText();
  }
  else
    return QString::null;
}

void KonqSidebar_Smb4K::slotReadOptions()
{
  // Read the configuration.
  config()->setGroup( "Appearance" );
  bool showType = config()->readBoolEntry( "Show Type", true );
  bool showComment = config()->readBoolEntry( "Show Comment", true );
  bool showIP = config()->readBoolEntry( "Show IP", true );

  // Now put everything back in according to the wishes of the user.
  if ( showIP )
  {
    widget->setColumnWidth( IP, 10 );
    widget->setColumnWidthMode( IP, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( IP, 0 );
    widget->setColumnWidthMode( IP, QListView::Manual );
  }

  if ( showType )
  {
    widget->setColumnWidth( Type, 10 );
    widget->setColumnWidthMode( Type, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( Type, 0 );
    widget->setColumnWidthMode( Type, QListView::Manual );
  }

  if ( showComment )
  {
    widget->setColumnWidth( Comment, 10 );
    widget->setColumnWidthMode( Comment, QListView::Maximum );
  }
  else
  {
    widget->setColumnWidth( Comment, 0 );
    widget->setColumnWidthMode( Comment, QListView::Manual );
  }

  // Adjust the columns. Avoid those that have a width of 0.
  int index = 0;
  while ( index < widget->columns() )
  {
    if ( widget->columnWidth( index ) != 0 )
      widget->adjustColumn( index );

    index++;
  }

  // Initialize the rest.
  m_hidden = config()->readBoolEntry( "Show Hidden", true );
  m_ipc = config()->readBoolEntry( "Show IPC", false );
  m_admin = config()->readBoolEntry( "Show ADMIN", false );
  m_printer = config()->readBoolEntry( "Show Printer", true );
}

//
// STUFF FOR THE TOOLBAR
//

Smb4KToolBar::Smb4KToolBar(QWidget *parent):KToolBar( parent, "SMB4K_Toolbar", true )
{
 setMinimumWidth(10);
}

Smb4KToolBar::~Smb4KToolBar(){}

void Smb4KToolBar::setMovingEnabled( bool)
{
 KToolBar::setMovingEnabled(false);
}

Smb4KToolBarParent::Smb4KToolBarParent(QWidget *parent)
     :QFrame(parent),m_tb(0){}
Smb4KToolBarParent::~Smb4KToolBarParent(){}
void Smb4KToolBarParent::setToolBar(Smb4KToolBar *tb)
{
 m_tb=tb;
}

void Smb4KToolBarParent::resizeEvent ( QResizeEvent * )
{
 if (m_tb)
   {
    setMinimumHeight(m_tb->sizeHint().height());
    //m_tb->resize(width(),height());
   }
}

#include "smb4k_konqplugin.moc"





