/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KSAMBAOPTIONS_H
#define SMB4KSAMBAOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// KDE includes
#include <klineedit.h>
#include <knuminput.h>
#include <kcombobox.h>


/*
 * This class manages the configuration dialog of the options
 * that can be passed to smbmount and other programs of the
 * Samba software suite.
 */


class Smb4KSambaOptions : public QTabWidget
{
  Q_OBJECT

  friend class Smb4KOptionsDlg;

  public:
    /*
     * The constructor.
     */
    Smb4KSambaOptions( QWidget *parent = 0, const char *name = 0 );
    /*
     * The destructor.
     */
    ~Smb4KSambaOptions();

  private:
    /** 
     * This line edit is for the NetBIOS name.
     */
    KLineEdit *m_netbios;
    /**
     * All UIDs that are present on the system and that
     * are no system UIDs are shown here.
     */
    KComboBox *m_uid;
    /**
     * All GIDs that are connected with the non-system
     * UIDs are shown here.
     */
    KComboBox *m_gid;
    /**
     * This input holds the SMB port that's used by smbmount
     * and friends.
     */
    KIntNumInput *m_port;
    /**
     * Holds the file mask for the remote files.
     */
    KLineEdit *m_fmask;
    /**
     * Holds the directory mask.
     */
    KLineEdit *m_dmask;
    QRadioButton *m_ro;
    QRadioButton *m_rw;
    KComboBox *m_charset;
    KComboBox *m_codepage;
    KLineEdit *m_sockopt;
    KLineEdit *m_scope;
    KIntNumInput *m_ttl;
    QCheckBox *m_krb;
    QCheckBox *m_unicode;
    QCheckBox *m_lfs;
    KLineEdit *m_resolve;
    KIntNumInput *m_buffer;
    QCheckBox *m_udp;
    KLineEdit *m_domain;
    KLineEdit *m_broadcast;
};

#endif
