/***************************************************************************
                          smb4koptionsdlg.h  -  description
                             -------------------
    begin                : Sam Feb 22 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KOPTIONSDLG_H
#define SMB4KOPTIONSDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <kconfig.h>

// application specific includes
#include "smb4kshareoptions.h"
#include "smb4knetworkoptions.h"
#include "smb4kauthoptions.h"
#include "smb4kappearanceoptions.h"
#include "smb4ksambaoptions.h"


class Smb4KOptionsDlg : public KDialogBase
{
  Q_OBJECT

  friend class Smb4KApp;
  
  public:
    /**
     * The constructor
     */
    Smb4KOptionsDlg( QWidget *parent = 0, const char *name = 0, bool modal = false );
    /**
     * The destructor
     */
    ~Smb4KOptionsDlg();

  protected:
    /**
     * Saves the options.
     */
    bool saveOptions();
    /**
     * Reads the options.
     */
    void readOptions();

  protected slots:
    /**
     * Is called when the OK button has been pressed.
     */
    void slotOk();
    /**
     * Is called when the Apply button has been pressed.
     */
    void slotApply();
    /**
      * Is called when the super user privileges were written/deleted to/from
      * the super.tab file.
      */
    void slotDoneSUPWriting();
    /**
     * This slot is called, if something went wrong with the super
     * stuff and the checkboxes have to be unchecked.
     */
    void slotNoSuper();

  private:
    /**
     * The KConfig object.
     */
    KConfig *m_config;
    /**
     * Set up the browse options page.
     */
    void setupNetworkOptions();
    /**
     * The browse option page object
     */
    Smb4KNetworkOptions *m_networkPage;

    /**
     * Set up the mount options page.
     */
    void setupShareOptions();
    /**
     * The mount options page object
     */
    Smb4KShareOptions *m_sharePage;

    /**
     * Set up the authentication page.
     */
    void setupAuthOptions();
    /**
     * The authentication page object
     */
    Smb4KAuthOptions *m_authPage;

    /**
     * Set up the appearance page.
     */
    void setupAppearanceOptions();
    /**
     * The appearance page object
     */
    Smb4KAppearanceOptions *m_appearancePage;

    /**
     * Sets up the Samba options page.
     */
    void setupSambaOptions();
    /**
     * The Samba page object
     */
    Smb4KSambaOptions *m_sambaPage;
    
    /**
     * This function checks whether all necessary specifications
     * have been provided before applying any changes.
     */
    bool check();
    /**
     * Tells which button has been clicked.
     */
    QString m_button;
    /**
     * The enumeration for the pages.
     */
    enum Pages{ Appearance = 0, Network = 1, Shares = 2, Authentication = 3, Samba = 4 };
};

#endif
