/***************************************************************************
    smb4kbookmarkmenuwidget.cpp  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qstringlist.h>
#include <qptrlist.h>

// KDE includes
#include <kapplication.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>
#include <kmenubar.h>
#include <kstdaction.h>

// Application includes
#include "smb4kbookmarkmenuwidget.h"
#include "../core/smb4kbookmark.h"

Smb4KBookmarkMenuWidget::Smb4KBookmarkMenuWidget(int display_mode, QWidget *parent, const char *name)
 : KPopupMenu(parent, name), m_display_mode(display_mode)
{
  m_app = (Smb4KApp *)parent;

  initActions();
  initMenu();
}

Smb4KBookmarkMenuWidget::~Smb4KBookmarkMenuWidget()
{
}

void Smb4KBookmarkMenuWidget::initMenu()
{
  slotBookmarksUpdated();
}

void Smb4KBookmarkMenuWidget::initActions()
{
  connect( m_app->core()->bookmarkHandler(), SIGNAL( bookmarksUpdated() ), this, SLOT( slotBookmarksUpdated() ) );
  connect( this, SIGNAL( activated( int ) ), SLOT( slotActivated( int ) ) );

  connect( m_app->core()->mounter(), SIGNAL( importedShares() ), this,                  SLOT( slotMountedShares() ) );
  connect( m_app->core()->mounter(), SIGNAL( mountedShare(Smb4KShare *) ), this,        SLOT( slotMountedShare(Smb4KShare *) ) );
  connect( m_app->core()->mounter(), SIGNAL( unmountedShare(QString, QString) ), this,  SLOT( slotUnmountedShare(QString) ) );
  connect( m_app->core()->mounter(), SIGNAL( unmountedAllShares() ), this,              SLOT( slotUnmountedAllShares() ) );
}

void Smb4KBookmarkMenuWidget::slotBookmarksUpdated()
{
  this->clear();
  uint index = 0;

  //Init full mode menus
  if( m_display_mode == FULL )
  {
    m_app->bookmarksAddBookmark->setEnabled( false );

    m_app->bookmarksAddBookmark->plug( this, index++ );
    m_app->bookmarksEditBookmarks->plug( this, index++ );

    this->insertSeparator( index++ );
  }

  QValueList<Smb4KBookmark *> bookmarks = m_app->core()->bookmarkHandler()->getBookmarks();
  if( bookmarks.count() != 0 )
  {
    for ( QValueList<Smb4KBookmark *>::ConstIterator it = bookmarks.begin(); it != bookmarks.end(); ++it )
    {
      this->insertItem( QIconSet(SmallIcon("folder_green")), (*it)->getShare(), index, index );
      if( m_app->core()->mounter()->isMounted( (*it)->getShare() ) )
      {
        enableBookmark( (*it)->getShare(), FALSE );
      }
      else
      {
        enableBookmark( (*it)->getShare(), TRUE );
      }
      index++;
    }
  }
}

void Smb4KBookmarkMenuWidget::enableBookmark(const QString name, bool enabled)
{
  uint index = 0;
  if( m_display_mode == FULL )
  {
    index = 3;
  }

  if(!enabled)
  {
    Smb4KShare* share = m_app->core()->mounter()->findShareByName(name);
    if(share)
    {
      if( share->getGID() != m_app->core()->mounter()->getGID() ||
          share->getUID() != m_app->core()->mounter()->getUID() )
      {
        enabled = TRUE;
      }
    }
  }

  for( uint i = index; i < this->count(); ++i )
  {
    int id = this->idAt(i);
    if( name == "ALL" )
    {
      this->setItemEnabled(id, enabled);
    }
    else
    {
      QString bookmark = this->text(id);
      if( name == bookmark )
      {
        this->setItemEnabled(id, enabled);
        return;
      }
    }
  }
}

void Smb4KBookmarkMenuWidget::slotActivated(int id)
{
  QString bookmark = this->text(id);
  if ( bookmark.startsWith( "//" ) )
  {
    QString host = bookmark.section( "/", 2, 2 );
    QString share = bookmark.section( "/", 3, 3 );

    m_app->core()->mounter()->mountShare( QString::null, host, QString::null, share );
  }
}

void Smb4KBookmarkMenuWidget::slotMountedShares()
{
  QValueList<Smb4KShare *> shares = m_app->core()->mounter()->getShares();
  
  for ( QValueListIterator<Smb4KShare *> it = shares.begin(); it != shares.end(); ++it )
  {
     enableBookmark((*it)->getName(), FALSE);
  }
}

void Smb4KBookmarkMenuWidget::slotMountedShare(Smb4KShare *share)
{
  enableBookmark(share->getName(), FALSE);
}

void Smb4KBookmarkMenuWidget::slotUnmountedShare(QString share)
{
  enableBookmark(share, TRUE);
}

void Smb4KBookmarkMenuWidget::slotUnmountedAllShares()
{
  enableBookmark("ALL", TRUE);
}

#include "smb4kbookmarkmenuwidget.moc"
