/***************************************************************************
    smb4kfileio  -  Does file IO operations for Smb4K
                             -------------------
    begin                : Do Jan 1 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KFILEIO_H
#define SMB4KFILEIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qmap.h>
#include <qvaluelist.h>

// KDE includes
#include <kprocess.h>
#include <kconfig.h>

// application specific includes
#include "smb4kuser.h"


/**
 * This class handles all IO operation on system files, that
 * are needed by Smb4K.
 */

class Smb4KFileIO : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KFileIO( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KFileIO();
    /**
     * Writes entries to the super.tab file.
     */
    bool writeSuperUserEntries( bool force, bool useSuper, bool overwrite = false );
    /**
     * Removes the entries of a user from the file /etc/super.tab. Returns true in case
     * of success and false otherwise.
     */
    bool removeSuperUserEntries();
    /**
     * Returns the map of global smb.conf options. You can reach the value
     * of each option by providing the lowercase option name as key, if it 
     * was defined in the global section of the smb.conf.
     */
    const QMap<QString, QString> getSMBOptions();
    /**
     * Returns the list of non-system users present on the system.
     */
    const QValueList<Smb4KUser *> getUsers();
    /**
     * Returns the papersize defined on the system. Therefore the 
     * /etc/papersize file is read. If this files does not exist, 
     * this function will return 'a4' as value, the default value 
     * of enscript.
     */
    const QString getPaperSize();

  signals:
    /**
     * Is emitted, when the super user privileges were written to /etc/super.tab
     */
    void doneSUPWriting();
    /**
     * This signal emits the error code and an error message if 
     * an error occurred.
     */
    void error( int error_code, const QString &error_message );
    /**
     * This signal is emitted if something went wrong with the 
     * super stuff.
     */
    void noSuper();
    

  protected slots:
    /**
     * This slot receives shell program output at Stderr.
     */
    void slotReceivedStderr( KProcess *, char *buf, int len );
    /**
     * This slot is called, when the process exited.
     */
    void slotProcessExited( KProcess * );

  private:
    /**
     * KConfig object.
     */
    KConfig *m_config;
    /**
     * Enumeration to specify what is done.
     */
    enum State{ writeSU, removeSU, Idle };
    /**
     * Holds the state value.
     */
    int m_state;
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * Holds the UID of the user.
     */
    int m_uid;
    /**
     * Holds the GID of the user.
     */
    int m_gid;
};

#endif
