/***************************************************************************
                          smb4kbookmarkhandler  -  description
                             -------------------
    begin                : Fr Jan 9 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KBOOKMARKHANDLER_H
#define SMB4KBOOKMARKHANDLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qpopupmenu.h>
#include <qptrlist.h>

// KDE includes
#include <kconfig.h>
#include <klistview.h>

// Application includes
#include "smb4kbookmark.h"

/** This class belongs the to core classes of Smb4K and manages the
    bookmarks. */

class Smb4KBookmarkHandler : public QObject
{
  Q_OBJECT

  public:
    /** The constructor. */
    Smb4KBookmarkHandler( QObject *parent = 0, const char *name = 0 );
    /** The destructor. */
    ~Smb4KBookmarkHandler();

    /** Writes a bookmark to the bookmark file. */
    void writeBookmark( const QString &host, const QString &share );
    /** Load the bookmarks. */
    void loadBookmarks();
    /** Get the list of bookmarks, */
    const QValueList<Smb4KBookmark *> &getBookmarks() { return m_bookmarks; }
    /** Invokes the bookmark editor. */
    void editBookmarks( QWidget *parent = 0, const char *name = 0 );

  signals:
    /** Signal emitted when the list of bookmarks has been updated. */
    void bookmarksUpdated();

  protected slots:
    /** Is invoked, when the OK button on the editor is clicked. */
    void slotOKClicked();
    /** Is invoked if the right mouse button has been pressed in the editor. */
    void slotRightButtonPressed( QListViewItem *item, const QPoint &pos, int col );
    /** Removes an item from the bookmark editor. */
    void slotRemoveClicked();
    /** Removes all items from the bookmark editor. */
    void slotRemoveAllClicked();

  private:
    /** The KConfig object, that handles the bookmark file. */
    KConfig *m_config;
    /** Holds the number of bookmarks in the file. */
    int m_num;
    /** The edit dialog. */
    KDialogBase *m_editDlg;
    /** The list view object. */
    KListView *m_bmView;
    /** The list of bookmarks. */
    QValueList<Smb4KBookmark *> m_bookmarks;
};

#endif
