#
#This file is part of smart-notifier, a graphical disk health notifier
#
#Copyright (C) 2005  Brian Sutherland <jinty@web.de>
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import os
import sys

import dbus
import dbus.exceptions
import dbus.service
import gtk
import gtk.glade

import dbus.glib # This **HIGHLY** unintuitive piece of code is to
                 # monkey patch some stuff and make other stuff work.
                 # Fun with capital F

here = os.path.dirname(__file__)
# Paths to glade files
warning_window = os.path.join(here, 'smart-notifier.glade')

# Globals
BUS = dbus.SystemBus()
SERVICE = "/smart_notifier/DbusService"
SERVICE_NAME = SERVICE.replace('/', '.')[1:]

UD_SERVICE = SERVICE + "/WarnUser"
UD_INTERFACE = SERVICE_NAME + ".WarnUser"

class DbusService(dbus.service.Object):

    @dbus.service.method(UD_INTERFACE)
    def WarnUser(self, msg):
        #Make the window
        self.ui = gtk.glade.XML(warning_window)
        #self.ui.signal_connect('end', gtk.main_quit)
        #Customize message
        textbuffer = gtk.TextBuffer()
        textbuffer.set_text(msg)
        textbox = self.ui.get_widget('textview1')
        textbox.set_buffer(textbuffer)
        # Fix the icon size XXX -- this is temporary intil gazpacho works
        icon = self.ui.get_widget('image1')
        icon.set_from_stock(gtk.STOCK_DIALOG_WARNING, gtk.ICON_SIZE_DIALOG)
        # Showit
        self.window = self.ui.get_widget('window1')
        self.window.show_all()


def notify(msg):
    userdaemon = BUS.get_object(SERVICE_NAME, UD_SERVICE)
    iface = dbus.Interface(userdaemon, UD_INTERFACE)
    try:
        iface.WarnUser(msg)
    except dbus.exceptions.DBusException:
        # Dont bother if there is no-one listening
        pass

def service():
    bus_name = dbus.service.BusName(SERVICE_NAME, bus=BUS)
    service = DbusService(bus_name, UD_SERVICE)
    gtk.main()
