/*
 * Determine topology information by running an INVENTORY request
 */
#include "basil_alps.h"
#include "basil_torus.h"

extern struct torus_info *torus_from_inventory(const struct basil_inventory *);

int main(int ac, char **av)
{
	enum basil_version version = get_basil_version();
	struct basil_inventory *inv;
	struct torus_info *ti;

	inv = get_full_inventory(version);
	if (inv == NULL)
		err(1, "allocation of inventory data failed");

	ti = torus_from_inventory(inv);
	if (ti == NULL)
		errx(1, "can not determine Torus information");

	printf("WARNING: This program does GUESSWORK\n"
	       "It can NOT determine whether the torus is 2D or 3D\n\n");

	printf("Class %d %s cabling: ", ti->cabling,
		ti->network == ASIC_XT_SEASTAR ? "SeaStar" : "Gemini");
	if (ti->rows == 1 && ti->cabs == 1 && ti->chassis == 1)
		printf("single-chassis system.\n");
	else if (ti->rows == 1 && ti->cabs == 1)
		printf("single cabinet of %d chassis.\n", ti->chassis);
	else if (ti->rows == 1)
		printf("single row of %d cabinets.\n", ti->cabs);
	else
		printf("%u row%s of %u cabinet%s%s.\n",
			ti->rows, ti->rows == 1 ? "" : "s",
			ti->cabs, ti->cabs == 1 ? "" : "s",
			ti->rows == 1 ? "" : " each");

	if (ti->rows == 1 && ti->cabs == 1 && ti->chassis == 1) {
		printf("Torus:  %u x %u x %u\n",
			ti->x_max, ti->y_max, ti->z_max);
	} else if (ti->network == ASIC_XT_SEASTAR) {
		printf(	" * Torus in 3D configuration:  %u x %u x %u\n"
			" * Torus in 2D configuration:  %u x %u x %u\n",
			ti->x_max, ti->y_max, ti->z_max,
			1, ti->y_max, ti->z_max);
	} else {
		printf(	" * Torus in 2D configuration:  %u x %u x %u\n"
			" * Torus in 3D configuration:  NOT KNOWN (Gemini)\n",
			ti->x_max, ti->y_max, ti->z_max);
	}
	free(ti);
	free_inv(inv);

	return EXIT_SUCCESS;
}
