# Slune
# Copyright (C) 2002-2003 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from __future__ import generators

import os.path, time, random, cPickle as pickle
import py2play.level as level
import py2play.idler as idler
import soya, soya.soya3d as soya3d, soya.model as model, soya.game.level as game_level, soya.game.camera as game_camera, soya.widget as widget
import slune.globdef as globdef, slune.character, slune.sound as sound
from soya.math3d import Point, Vector

class Idler(game_level.Idler):
  
  #def __del__(self):
  #  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! del Idler"
  
  def __init__(self, camera = None):
    game_level.Idler.__init__(self, camera)
    
    if globdef.SOUND or globdef.MUSIC:
      import pyopenal.openal4soya as openal4soya
      openal4soya.init(self.camera)
      
    self.blackbands_group    = widget.Group() 
    self.no_blackbands_group = widget.Group()
    soya.root_widget.add(self.no_blackbands_group)
    
    self.lifebar = slune.character.LifeBar()
    self.no_blackbands_group.add(self.lifebar)
    
    self.blackbands_group.add(game_camera.BlackBands())
    
    self.blackbands_visible = 0
    
    self.players_info = []
    self.waiting_until_ready = 0
    self.paused = None
    
    text = soya.widget.Label(None, "", 1)
    
    def text_resize(parent_left, parent_top, parent_width, parent_height):
      text.width  = parent_width - 50 # The lifebar takes about 50 pixels !
      text.height = int(parent_height * 0.5)
      text.left   = parent_left
      text.top    = parent_top
      
    text.resize = text_resize
    soya.root_widget.add(text)
    self.messageboard = text
    self.messages = []
    
    if globdef.VERIFICATION_SERVER: self.logon_verif()
    
  def show_blackbands(self):
    if not self.blackbands_visible:
      self.blackbands_visible = 1
      h = soya.get_screen_height()
      h2 = h / 10
      soya.root_widget.remove(self.no_blackbands_group)
      soya.root_widget.resize(0, h2, soya.get_screen_width(), h - 2 * h2)
      soya.root_widget.insert(1, self.blackbands_group)
      
  def hide_blackbands(self):
    if self.blackbands_visible:
      self.blackbands_visible = 0
      soya.root_widget.remove(self.blackbands_group)
      soya.root_widget.resize(0, 0, soya.get_screen_width(), soya.get_screen_height())
      soya.root_widget.add   (self.no_blackbands_group)
    
    
  def logon_verif(self):
    """Log on the verif server."""
    import socket
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.connect((globdef.VERIFICATION_SERVER, 36081))
    self.verif = s.makefile("w", 0)
    self.verif.write("R") # Check rounds value
    
  def idle(self):
    self.message(_("__ready__"))
    
    from slune.controler import KeyboardMouseControler
    
    self.waiting_until_ready = 1
    wait = WaitUntilReady(self)
    
    for level in self:
      if isinstance(level, Level):
        for character in level.characters:
          if character.controler:
            character.controler.animate(wait)
            if isinstance(character.controler, KeyboardMouseControler):
              character.controler.enabled = 0
              
    return game_level.Idler.idle(self)
    
  def pause(self, max_duration = -1): self.next_round_tasks.append(lambda : self._pause(max_duration))
  
  def _pause(self, max_duration = -1):
    if not self.paused:
      from slune.controler import KeyboardMouseControler

      self.paused = wait = WaitClick(self, max_duration)

      for level in self:
        if isinstance(level, Level):
          for character in level.characters:
            if character.controler:
              character.controler.animate(wait)
              if isinstance(character.controler, KeyboardMouseControler):
                character.controler.enabled = 0
              
  def unpause(self): self.next_round_tasks.append(self._unpause)
  
  def _unpause(self):
    if self.paused:
      from slune.controler import KeyboardMouseControler
      
      for level in self:
        if isinstance(level, Level):
          for character in level.characters:
            if isinstance(character.controler, KeyboardMouseControler):
              character.controler.enabled = 1
              
      self.paused.stop() # Stop the WaitClick instance !
      self.paused = None
      
  def begin_round(self):
    game_level.Idler.begin_round(self)
    
    if globdef.VERIFICATION_SERVER:
      import py2play.player, cPickle as pickle
      
      players_rounds = {}
      for level in self:
        if isinstance(level, Level):
          for character in level.characters:
            if hasattr(character, "player"):
              players_rounds[character.player.name] = character.round
              
      pickle.dump((players_rounds, py2play.player.CURRENT_PLAYER.name), self.verif)
      
      
  def init_game(self):
    self.camera.zap()
    
  def start_game(self):
    for o in self.recursive():
      if isinstance(o, soya3d.World) and o.atmosphere:
        if o.atmosphere.fog:
          self.camera.back = o.atmosphere.fog_end = o.atmosphere.fog_end * globdef.MAX_VISION
          break
        
    
    if self.waiting_until_ready:
      self.waiting_until_ready = 0
      self.clear_message()
      
      from slune.controler import KeyboardMouseControler
      
      for level in self:
        if isinstance(level, Level):
          for character in level.characters:
            if isinstance(character.controler, KeyboardMouseControler):
              character.controler.controlers[-1].stop() # Stop the WaitUntilReady instance !
              character.controler.enabled = 1
              
      from py2play.player import CURRENT_PLAYER
      CURRENT_PLAYER.level.start_game()
      
  def level_completed(self, character, winner = None, message = None):
    import videosequence
    
    videosequence.MissionCompleted(winner, message).start(tux = character)
    
  def advance_time(self, proportion):
    game_level.Idler.advance_time(self, proportion)
    
  def end_round(self):
    current = time.time()
    if self.messages and (self.messages[0][1] <= current):
      del self.messages[0]
      self.messageboard.text = "\n".join(map(lambda (text, duration): text, self.messages))
      
    game_level.Idler.end_round(self)
    
  def clear_message(self):
    self.messages *= 0
    self.messageboard.text = ""
    
  def message(self, text, duration = 7.0):
    if isinstance(text, unicode): text = text.encode("latin")
    self.messages.append((text, duration + time.time()))
    
    if len(self.messages) > 3: del self.messages[0]
    
    self.messageboard.text = "\n".join(map(lambda (text, duration): text, self.messages))
    
  def message_append(self, text, duration = 7):
    if isinstance(text, unicode): text = text.encode("latin")
    self.messages[-1] = (self.messages[-1][0] + text, duration + time.time())
    
    self.messageboard.text = "\n".join(map(lambda (text, duration): text, self.messages))
    
class WaitUntilReady:
  def __init__(self, idler):
    self._stop = 0
    self.idler = idler
    
    self.players_info = ()
    
  def stop(self): self._stop = 1
  
  def next(self):
    if self._stop: raise StopIteration
    
    from py2play.player import CURRENT_PLAYER
    
    if self.players_info != CURRENT_PLAYER.players_info:
      for player_info in CURRENT_PLAYER.players_info:
        if not player_info in self.players_info:
          self.idler.message(_("__connection__") % (player_info[0], player_info[1]))
      self.players_info = CURRENT_PLAYER.players_info[:]
        
    return slune.character.Action()
  
class WaitClick:
  def __init__(self, idler, duration = -1):
    self._stop = 0
    self.idler = idler
    self.duration = duration
  def stop(self): self._stop = 1
  
  def next(self):
    if self._stop: raise StopIteration
    if not self.duration:
      from py2play.idler import IDLER
      IDLER.unpause()
    self.duration -= 1
    return slune.character.Action()



class MessageBoard(soya.widget.Label):
  def __init__(self, master = None):
    soya.widget.Label.__init__(self, master, "", 1)
    self.messages = []
    self.left   = 0
    self.top    = 0
    self.width  = 200
    self.height = 200
  def add_message(self, text, color = soya.model.WHITE, time = 300):
    self.messages.append(text)
    
    if len(self.messages) > 3:
      del self.messages[0]
      
    self.text = "\n".join(self.messages)
    
  def resize(self, parent_left, parent_top, parent_width, parent_height):
    self.left   = 0
    self.top    = 0
    self.width  = parent_width
    self.height = int(parent_height * 0.5)
    
    
class Level(game_level.Level):
  pushables = () # HACK ! No push before the game really starts !
  bonuss    = () # HACK !
  
  #def __del__(self):
  #  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! del Level", self.name
  
  def __init__(self, parent = None):
    game_level.Level .__init__(self, parent)
    
    self.init_script = self.init_character_script = self.start_script = self.end_script = ""
    
  def init_character(self, character):
    if isinstance(character, slune.character.Competitor) and character.controler:
      character.rank = len(filter(lambda character: isinstance(character, slune.character.Competitor), self.characters)) - 1
      
      exec self.init_character_script in globals(), locals()
      
      character.y += character.floating
      
    character.init()
    
  def __setstate__(self, state):
    game_level.Level.__setstate__(self, state)
    
    from py2play.player import CURRENT_PLAYER
    if CURRENT_PLAYER:
      if not hasattr(self, "inited"): # Else already inited, e.g. by another player (in network game)
        self.inited     = 1
        self.random     = random.Random()
        self.difficulty = globdef.DIFFICULTY # Store difficulty in level, because, in network gaming, all players plays at the same difficulty !
        
        exec self.init_script
        
      if hasattr(self, "music_name"):
        if self.music_name: sound.play_music(self.music_name)
        else: sound.preload_sound(self.preloaded_music_name, globdef.ASYNC_LOAD_MUSIC)
      else:
        sound.play_music("summum_of_the_light.ogg") # Default music
        
  def start_game(self):
    exec self.start_script in globals(), locals()
    
    self.pushables = filter(lambda x: isinstance(x, slune.character.Pusher), self)
    self.bonuss    = filter(lambda x: isinstance(x, Bonus                 ), self)

    for pushable in filter(lambda x: isinstance(x, slune.character.Pushable), self):
      h = self.random.random()
      if   h < pushable.bonus_chance:
        pushable.bonus_type = 1
      elif h < 2 * pushable.bonus_chance:
        pushable.bonus_type = 2
        
  def end_game(self):
    exec self.end_script in globals(), locals()
    
    sound.end_music()
    
  def remove_character(self, character):
    if self.pushables and isinstance(character, slune.character.Pusher):
      try: self.pushables.remove(character)
      except: pass
    game_level.Level.remove_character(self, character)
    
    
def CREATE(level_name):
  lev = pickle.load(open(os.path.join(soya3d.World.PATH, level_name + ".data"), "rb"))
  lev.name = level_name
  level.store(lev)
  
  return lev
level.CREATE = CREATE


def Level_0(parent = None):
  #self =  level.CREATE("at_the_mountain")
  #self =  level.CREATE("crashfunkel-fight-1")
  self =  level.CREATE("crashfunkel-race-1")
  
  import slune.fight
  def add_perso():
    op = slune.fight.Fighter()
    op.set_level(self, 1)
    op.set_xyz(5.0, 5.0, 5.0)
    
  for i in range(0): add_perso()
  
  return self


def gone(parent = None):
  self = soya3d.World(parent)
  material = model.Material()
  material.diffuse = (1.0, 0.0, 0.0, 1.0)
  material.filename = "red"
  material.save()
  model.Face(self, [
    model.Vertex(self, -50.0, -0.05, -10.0, 0.0, 0.0),
    model.Vertex(self, -50.0, -0.05,  10.0, 1.0, 0.0),
    model.Vertex(self,  50.0, -0.05,  10.0, 1.0, 1.0),
    model.Vertex(self,  50.0, -0.05, -10.0, 0.0, 1.0),
    ], material).double_sided = 1
  #return self

  model.Face(self, [
    model.Vertex(self,  75.0,  15.05, -10.0, 0.0, 0.0),
    model.Vertex(self,  75.0,  15.05,  10.0, 1.0, 0.0),
    model.Vertex(self,  50.0, -0.05,  10.0, 1.0, 1.0),
    model.Vertex(self,  50.0, -0.05, -10.0, 0.0, 1.0),
    ], material).double_sided = 1
  model.Face(self, [
    model.Vertex(self, -50.0,  -0.05,  -10.0, 0.0, 0.0),
    model.Vertex(self,  50.0,  -0.05,  -10.0, 1.0, 0.0),
    model.Vertex(self,  50.0,  15.05,  -6.0, 1.0, 1.0),
    model.Vertex(self, -50.0,  15.05,  -6.0, 0.0, 1.0),
    ], material).double_sided = 1
  model.Face(self, [
    model.Vertex(self,  20.0,  -0.05,  10.0, 0.0, 0.0),
    model.Vertex(self,  10.0,  -0.05,  10.0, 1.0, 0.0),
    model.Vertex(self,  10.0,  15.05,  10.0, 1.0, 1.0),
    model.Vertex(self,  20.0,  15.05,  10.0, 0.0, 1.0),
    ], material).double_sided = 1
  model.Face(self, [
    model.Vertex(self,  -40.0,  -0.05,  10.0, 0.0, 0.0),
    model.Vertex(self,  -50.0,  -0.05,  00.0, 1.0, 0.0),
    model.Vertex(self,  -50.0,  15.05,  00.0, 1.0, 1.0),
    model.Vertex(self,  -40.0,  15.05,  10.0, 0.0, 1.0),
    ], material).double_sided = 1
  
  material = model.Material()
  material.diffuse = (0.0, 1.0, 0.0, 1.0)
  material.filename = "green"
  material.save()
  model.Face(self, [
    model.Vertex(self, -20.0, 3.5, -5.0, 0.0, 0.0),
    model.Vertex(self, -20.0, 3.5,  5.0, 1.0, 0.0),
    model.Vertex(self,   0.0, 1.5,  5.0, 1.0, 1.0),
    model.Vertex(self,   0.0, 1.5, -5.0, 0.0, 1.0),
    ], material).double_sided = 1
  model.Face(self, [
    model.Vertex(self,  20.0, 17.5, -5.0, 0.0, 0.0),
    model.Vertex(self,  20.0, 17.5,  0.0, 1.0, 0.0),
    model.Vertex(self,   0.0, 1.5,  0.0, 1.0, 1.0),
    model.Vertex(self,   0.0, 1.5, -5.0, 0.0, 1.0),
    ], material).double_sided = 1
  
  
  #boucle = soya3d.Volume(self, model.Shape.get("boucle"))
  #boucle.set_xyz(40.0, 0.0, 5.0)
  #boucle.rotate_incline(15.0)
  
  return self




class SphericalScript(soya3d.Volume):
  def __init__(self, parent = None, script = ""):
    soya3d.Volume.__init__(self, parent, model.Shape.get("sphericalscript"))
    self.script   = script
    self.radius   = 1.0
    self.disabled = 0
    
  def set_radius(self, radius):
    r = radius / self.radius
    self.scale(r, r, r)
    self.radius = radius
    
  def disable(self, nb_round = None):
    if nb_round is None: self.parent.remove(self)
    else: self.disabled += nb_round
    
  def __setstate__(self, state):
    soya3d.Volume.__setstate__(self, state)
    
    from py2play.player import CURRENT_PLAYER
    if CURRENT_PLAYER: self.set_shape(None)
    
  def begin_round(self):
    #from py2play.player import CURRENT_PLAYER
    
    if not self.shape:
      if self.disabled: self.disabled -= 1
      else:
        self.set_shape(None)
        for character in self.parent.characters:
          if character.distance_to(self) <= self.radius:
            exec self.script in globals(), locals()


class Bonus:
  come_back = 1

class LifeBonus(Bonus, soya3d.Volume):
  radius = 3.0
  
  def __init__(self, parent = None):
    soya3d.Volume.__init__(self, parent, model.Shape.get("bonus_life"))
    
    self.disabled = 0
    
  def begin_round(self):
    if self.disabled:
      self.disabled -= 1
      if not self.disabled: self.visible = 1
      
    else:
      for character in self.parent.characters:
        if self.distance_to(character) < self.radius:
          character.life = 1.0
          sound.play("bonus-1.wav", character)
          
          LifeBonusParticle(character.parent).set_xyz(self.x, self.y + 0.3, self.z)
          
          if self.come_back:
            self.disabled  = 150
            self.visible   = 0
          else:
            self.parent.bonuss.remove(self)
            self.parent.remove(self)
          break
        
class FlameThrowerBonus(Bonus, soya3d.Volume):
  radius = 3.0
  
  def __init__(self, parent = None):
    soya3d.Volume.__init__(self, parent, model.Shape.get("bonus_green"))
    
    self.disabled = 0
    
  def begin_round(self):
    if self.disabled:
      self.disabled -= 1
      if not self.disabled: self.visible = 1
      
    else:
      for character in self.parent.characters:
        if self.distance_to(character) < self.radius:
          character.flame_thrower += 2
          sound.play("bonus-1.wav", character)
          
          LifeBonusParticle(character.parent).set_xyz(self.x, self.y + 0.3, self.z)
          
          if self.come_back:
            self.disabled  = 150
            self.visible   = 0
          else:
            self.parent.bonuss.remove(self)
            self.parent.remove(self)
          break
        
import math, soya.particle as particle

class LifeBonusParticle(particle.Particles):
  def __init__(self, parent = None, material = None, nb_particles = 30):
    particle.Particles.__init__(self, parent, material or particle._default(), nb_particles)
    self.auto_generate_particle = 1
    self.removable = 1
    self.set_colors((1.0, 0.2, 0.3, 0.2), (1.0, 0.2, 0.6, 0.9), (0.8, 0.2, 1.0, 0.2))
    self.set_sizes((1.0, 1.0))
    self.life = 10
    
  def generate(self, index):
    angle = random.random() * 3.1417
    sx = math.cos(angle)
    sy = -math.sqrt(random.random() * 3.0)
    sz = math.sin(angle)
    l = (0.06 * (1.5 + random.random())) / math.sqrt(sx * sx + sy * sy + sz * sz)
    self.set_particle(index, 0.5 + random.random(), (sx * l, sy * l, sz * l), (0.0, 0.03, 0.0))
    
  def begin_round(self):
    particle.Particles.begin_round(self)
    if   self.life >  0: self.life -= 1
    elif self.life == 0:
      self.auto_generate_particle = 0
      self.removable = 1
      self.life = -1

