/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef _SLPIM_DEFS_H
#define _SLPIM_DEFS_H

/* currently 17 fields, but there could be up to 256 */
#define ABOOK_FIELDS_NO 17
#define FIELD_FNAME 0
#define FIELD_LNAME 1
#define FIELD_MNAME 2
#define FIELD_NICK 3
#define FIELD_ORG 4
#define FIELD_ADDR 5
#define FIELD_CITY 6
#define FIELD_PCODE 7
#define FIELD_STATE 8
#define FIELD_COUNTR 9
#define FIELD_PHHOME 10
#define FIELD_PHWORK 11
#define FIELD_PHFAX 12
#define FIELD_PHMOB 13
#define FIELD_URL 14
#define FIELD_EMAIL 15
#define FIELD_NOTES 16

/* virtual fields (field index above 255) */
#define ABOOK_VIRT_FIELDS_NO 1
#define FIELD_NAME 256

/* message types */
#define INFO_MESSAGE 0
#define WARN_MESSAGE 1
#define ERROR_MESSAGE 2

/* current version number */
/* define SLPIM_VERSION "pre0.0.7" */

/* define slpim_ABASE_filename "slpim.database" */
extern char *slpim_ABASE_filename;

#define MAILER "/usr/bin/mutt"
#define FC_WIDTH 30 /* fist column width */
#define SC_WIDTH 30 /* second column width */
/* note: FC_WIDTH/SC_WIDTH *shouldn't* exceed 99 */


typedef struct {
	char *name;
	void *next;
} listitem;

typedef struct {
	char **ent;
	int i;
} dyntab;

typedef struct {
	char *key;
	char *cont;
} doubletab;

extern dyntab *ABOOK_FIELD_NAMES;

#endif
