%{

/* pascal_count.l by David A. Wheeler (http://www.dwheeler.com).
   Licensed under the GNU GPL, version 2.

*/

#include "driver.h"

#define YY_NO_UNPUT

/* 1 if we saw a non-comment, non-whitespace char on this line */
int saw_char = 0;

%}

%option noyywrap

SPACE		[ \t\n\r\f]

%x comment
%x bcomment
%x string

%%
	line_number = 1;
	saw_char = 0;
	BEGIN(INITIAL);

[ \t\r\f]	/* Do nothing */
"(*"	{BEGIN(comment);}
\n	{if (saw_char) {sloc++; saw_char=0;}; line_number++;}
"{"	{BEGIN(bcomment);}
"'"	{saw_char = 1; BEGIN(string);}
[^ \t\r\f(\n{'][^(\n{']*	{saw_char = 1;}
.	{saw_char = 1;}

<comment>[^*\n]+	/* Do nothing */
<comment>[^*\n]*\n	{if (saw_char) {sloc++; saw_char=0;}; line_number++;}
<comment>"*"+[^*)\n]*	/* Do nothing */
<comment>"*"+[^*)\n]*\n {if (saw_char) {sloc++; saw_char=0;}; line_number++;}
<comment>"*"+")"	{BEGIN(INITIAL);}

<bcomment>[^}\n]+	/* Do nothing */
<bcomment>[^}\n]*\n	{if (saw_char) {sloc++; saw_char=0;}; line_number++;}
<bcomment>"}"		{BEGIN(INITIAL);}

<string>[^'\n]+		{saw_char = 1;}
<string>\n		{
	fprintf(stderr, "Warning: newline in string - file %s, line %ld\n",
	                 filename, line_number);
	if (saw_char) {sloc++; saw_char=0;};
	BEGIN(INITIAL); /* Switch back; this at least limits damage */
	line_number++;
	}
<string>''		{saw_char = 1;}
<string>'		{saw_char = 1; BEGIN(INITIAL);}

%%

#include "driver.c"


