
set_import_module_path("../:" + get_import_module_path());
set_slang_load_path("../:" + get_slang_load_path());

define compare(orig, copy) % {{{
{
   if ("$orig"$ != "$copy"$)
	error("ERROR: original & copy do not have same shape"$);

   variable diffs = where(orig != copy);
   if (any(diffs))
	error("ERROR: $diffs elements differed between copy & original"$);
} % }}}

define Fail() % {{{
{
   variable expected_err = qualifier("err", NULL);
   variable args = __pop_list(_NARGS - 1);
   variable func = ();
   variable err = NULL;
   variable depth = _stkdepth();

   try (err)
	(@func) ( __push_list(args) );

   catch AnyError:
	if (expected_err != NULL && err.error != expected_err)
	   verror("$func() should've thrown error $expected_err, not %S"$,
	   							   err.descr);

   finally {

	_pop_n( max([_stkdepth() - depth, 0]) );

	if (err == NULL) {

	   list_reverse(args);
	   func = "$func"$[[1:]];
	   variable arg, s = String_Type[0];

	   foreach arg ( args )
		s = [ sprintf("%S", arg), s];

	   s = strjoin(s, ",");
	   error("$func($s) should have thrown an error, but didn't"$);
	}
   }
} % }}}

define setup()
{
   require("gif");
   _traceback = 1;
   _auto_declare = 1;
}

provide("setup");

