
#define NAME reflect_8
#define TYPE uint8_t
#include "reflect2.c"

#define NAME reflect_16
#define TYPE uint16_t
#include "reflect2.c"


#define NAME reflect_24
#define STRIDE 3
#define TYPE uint8_t
static uint8_t buf[3];
#include "reflect2.c"

#define NAME reflect_32
#define TYPE uint32_t
#include "reflect2.c"

#define NAME reflect_64
#define TYPE uint64_t
#include "reflect2.c"

void gif_reflect(void *image, int bpp, int w, int h, int which_axes) /*{{{*/
{
  switch (bpp) {	/* reflect along X,Y, or both axes, in place */
	case 8 :  reflect_8 ( (uint8_t*) image, w, h, which_axes); break;
	case 16:  reflect_16( (uint16_t*)image, w, h, which_axes); break;
	case 24:  reflect_24( (uint8_t*) image, w, h, which_axes); break;
	case 32:  reflect_32( (uint32_t*)image, w, h, which_axes); break;
	case 64:  reflect_64( (uint64_t*)image, w, h, which_axes); break;
	default:  /* do nothing */;
  }
} /*}}}*/
