#define HAVE_LONG_LONG 1
/* * This file was generated by SLIRP, the (Sl)ang (I)nte(r)face (P)ackage,
 * a S-Lang module code generator for C, C++, and FORTRAN.
 *
 * Copyright (C) 2003-2009 Massachusetts Institute of Technology 
 * Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
 *
 * SLIRP is free software, and may be used under the conditions stipulated
 * in the COPYRIGHT agreement bundled within the SLIRP distribution.
 */
#include <stdlib.h>		/* SLIRP common {{{ */
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <slang.h>

#define V				SLANG_VOID_TYPE
#define SLEU				SL_USAGE_ERROR
#define SLEI				SL_INTRINSIC_ERROR
#define SAFE_DEREF_OPAQUE(po)		(po == NULL ? NULL : po->instance)
#define SAFE_DEREF_ARRAY(pa)		(pa == NULL ? NULL : pa->data)
#define SLang_pop_array(x)		SLang_pop_array(x, 1)
#define SLang_pop_string(x)             ( (SLang_peek_at_stack() == SLANG_NULL_TYPE && (SLdo_pop() || 1)) ? ((*x = NULL) || 1): SLang_pop_slstring(x))
#define SLang_push_size_t		SLang_push_uint
#define SLang_push_ptrdiff_t		SLang_push_int

#define pop_defaultable(argno, kind, type, obj, value) \
   (SLang_Num_Function_Args >= argno ? SLang_pop_##kind ( (type*)&obj) : ((obj = value) || ( (void*)&obj > (void*)0) ) )

#ifdef __cplusplus
#define LINKAGE "C"
#else
#define LINKAGE
#endif

#define USAGE(msg) \
    {SLang_verror(SL_USAGE_ERROR, (char*)"Usage: %s", msg); return;}

static void Slirp_usage(int i, int j, int flags);

static int slang_abi_mismatch(void)
{
   long module_abi = SLANG_VERSION / 10000;
   long app_abi    = SLang_Version / 10000;

   if (module_abi != app_abi) {
	SLang_verror(SL_APPLICATION_ERROR, (char*)
		"S-Lang library abi mismatch\nmodule: %s, application: %s",
		SLANG_VERSION_STRING, SLang_Version_String);
	return 1;
   }
			        
   return 0;
} /* }}} */

static char *slns;  /* slang namespace active at time of module load */
#include "config.h"
#include "gif.h"
#include "gifxtns.h"
#define BEGIN_DECLS
#define END_DECLS
#define SLIRP_EXTERN
BEGIN_DECLS				/* Opaque handling code {{{ */

#define SLIRP_ABI_VERSION			10500

typedef void            (*FINALIZER)            (void*);
typedef void            (*INITIALIZER)          (void*);

typedef struct _Slirp_Type {
   SLang_Class_Type	*slclass;	/* SLang type class for this type */
   struct _Slirp_Type	*parent;	/* NULL if type has no ancestors  */
   FINALIZER		finalizer;
   INITIALIZER		initializer;
} Slirp_Type;

typedef struct _Slirp_Opaque {
   Slirp_Type *type;
   SLang_MMT_Type *mmt;
   void* instance;
   unsigned int owns_ref;
} Slirp_Opaque;
#define SLang_free_opaque(o)	if (o != NULL) SLang_free_mmt(o->mmt)

static int opaque_typecast (SLtype from_type, VOID_STAR from_p,
			unsigned int num, SLtype to_type, VOID_STAR to_p)
{
   unsigned int i;
   SLang_MMT_Type **from = (SLang_MMT_Type**)from_p;
   SLang_MMT_Type **to   = (SLang_MMT_Type**)to_p;

   (void) from_type; (void) to_type; 

   for (i=0; i < num; i++) {
	to[i] = from[i];	/* FIXME: typeof() still reports prev type */
	if (from[i] != NULL)
	   SLang_inc_mmt(from[i]);
   }

   return 1;
}

static int opaque_search(const void* key, const void *elem)
{
   return *(SLtype*)key - SLclass_get_class_id((*(Slirp_Type**)elem)->slclass);
}

static void destroy_opaque(SLtype type, VOID_STAR w)
{
   Slirp_Opaque *ot = (Slirp_Opaque*)w;

   (void) type;

   if (ot->type->finalizer != NULL)
      (*ot->type->finalizer) (ot->instance);

   SLfree( (char*)w );
}
END_DECLS

SLIRP_EXTERN SLtype void_ptr_Type;	/* These opaque pointer types must */
SLIRP_EXTERN SLtype string_ptr_Type;	/* be kept in sync with opaques.c  */
SLIRP_EXTERN SLtype uchar_ptr_Type;
SLIRP_EXTERN SLtype short_ptr_Type;
SLIRP_EXTERN SLtype ushort_ptr_Type;
SLIRP_EXTERN SLtype int_ptr_Type;
SLIRP_EXTERN SLtype uint_ptr_Type;
SLIRP_EXTERN SLtype long_ptr_Type;
SLIRP_EXTERN SLtype ulong_ptr_Type;
SLIRP_EXTERN SLtype float_ptr_Type;
SLIRP_EXTERN SLtype double_ptr_Type;
SLIRP_EXTERN SLtype opaque_ptr_Type;
SLIRP_EXTERN SLtype file_ptr_Type;

typedef struct _Reserved_Opaque_Type {
   char	  *name;
   SLtype *type;		/* SLtype of opaque pointer defined by this */
   SLtype masked_type;		/* SLtype of datum to which this points */
} Reserved_Opaque_Type;

SLIRP_EXTERN Slirp_Type	**Slirp_Opaque_Types;
SLIRP_EXTERN SLtype 	Slirp_Num_Opaque_Types;
SLIRP_EXTERN SLtype	First_Opaque_Type;
SLIRP_EXTERN SLtype	Last_Reserved_Opaque_Type;

static Reserved_Opaque_Type Reserved_Opaque_Types[] = {

   { (char*)"void_ptr",		&void_ptr_Type,		SLANG_ANY_TYPE,    },
   { (char*)"int_ptr",		&int_ptr_Type,		SLANG_INT_TYPE,    },
   { (char*)"double_ptr",	&double_ptr_Type,	SLANG_DOUBLE_TYPE, },
   { (char*)"opaque_ptr",	&opaque_ptr_Type,	SLANG_ANY_TYPE,	   },
   { (char*)"file_ptr",		&file_ptr_Type,		SLANG_FILE_PTR_TYPE,},
   { (char*)"float_ptr",	&float_ptr_Type,	SLANG_FLOAT_TYPE,  },
   { (char*)"long_ptr",		&long_ptr_Type,		SLANG_LONG_TYPE,   },
   { (char*)"string_ptr",	&string_ptr_Type,	SLANG_STRING_TYPE, },
   { (char*)"uint_ptr",		&uint_ptr_Type,		SLANG_UINT_TYPE,   },
   { (char*)"short_ptr",	&short_ptr_Type,	SLANG_SHORT_TYPE,  },
   { (char*)"ulong_ptr",	&ulong_ptr_Type,	SLANG_ULONG_TYPE,  },
   { (char*)"ushort_ptr",	&ushort_ptr_Type,	SLANG_USHORT_TYPE, },
   { (char*)"uchar_ptr",	&uchar_ptr_Type,	SLANG_UCHAR_TYPE,  },
   { NULL, NULL, 0, }
};

#define NUM_RESERVED_OPAQUES \
	sizeof(Reserved_Opaque_Types) / sizeof(Reserved_Opaque_Type) - 1

static Slirp_Type* sltype_to_slirp_type(SLtype sltype)
{
   Slirp_Type **ot = (Slirp_Type**) bsearch( (const void*) &sltype,
	 		(const void*) Slirp_Opaque_Types,
			(size_t) Slirp_Num_Opaque_Types,
			sizeof(Slirp_Type*), opaque_search);

   if (ot != NULL) return *ot;
   return NULL;
}

static SLang_MMT_Type*
create_opaque_mmt(SLtype type, void *instance, unsigned int owns_ref)
{
   SLang_MMT_Type *mmt = NULL;
   Slirp_Opaque *ot = (Slirp_Opaque*) SLmalloc(sizeof(Slirp_Opaque));

   if (ot != NULL) {

	ot->instance = instance;
	ot->owns_ref = owns_ref;
	ot->mmt      = NULL;

	if ( (ot->type = sltype_to_slirp_type(type)) != NULL) {

	   if (ot->type->initializer != NULL)
		(*ot->type->initializer) (ot->instance);

	   mmt = SLang_create_mmt (type, (VOID_STAR) ot);
	}

	if (mmt == NULL)
	   SLfree((char*)ot);
   }

   return mmt;
}

static int SLang_push_opaque(SLtype type, void *instance, unsigned int owns_ref)
{
   SLang_MMT_Type *mmt;

   if (instance == NULL)
      return SLang_push_null();

   mmt = create_opaque_mmt(type, instance, owns_ref);
   if (NULL == mmt)
      return -1;

   return SLang_push_mmt(mmt);
}

static int SLang_pop_opaque(SLtype type, void **instance, Slirp_Opaque **o)
{
   Slirp_Opaque *ot;
   SLang_MMT_Type *mmt = NULL;

   if (type == file_ptr_Type && SLang_peek_at_stack() == SLANG_FILE_PTR_TYPE) {
	FILE *fp;
	if (SLang_pop_fileptr(&mmt, &fp) == 0) {
	   ot = (Slirp_Opaque*) SLmalloc(sizeof(Slirp_Opaque));
	   if (ot == NULL) { SLang_free_mmt(mmt); return -1; }
	   ot->mmt = mmt; *instance = (void*)fp; *o = ot; return 0;
	}
   }
   else if (	(mmt = SLang_pop_mmt(type)) != NULL &&
		(ot = (Slirp_Opaque*) SLang_object_from_mmt (mmt)) != NULL &&
		ot->instance != NULL) {

	ot->mmt = mmt;
	if (instance != NULL)
	   *instance = ot->instance;
	*o = ot;
	return 0;
   }

   if (instance != NULL) *instance = NULL;
   SLang_free_mmt (mmt);
   return -1;
}


static unsigned int
allocate_opaque(char *name, FINALIZER fzer, INITIALIZER izer, SLtype parent_id,
		int (*sget)(SLtype, char *), int (*sput)(SLtype, char *))
{
   /* Returning from here with anything but a positive id is fatal */
   SLtype new_type, ancestor_type;
   Slirp_Type *type , *parent = NULL;
   SLang_Class_Type *new_class = SLclass_allocate_class (name);

   if (new_class == NULL) return SLANG_UNDEFINED_TYPE;

   (void) SLclass_set_destroy_function (new_class, destroy_opaque);
   if (-1 == SLclass_register_class (new_class, SLANG_VOID_TYPE,
				     sizeof(Slirp_Opaque),
				     SLANG_CLASS_TYPE_MMT))
	return SLANG_UNDEFINED_TYPE;

   new_type = SLclass_get_class_id(new_class);
   if (parent_id) {

	type = parent = sltype_to_slirp_type(parent_id);

	while (type) {

	   ancestor_type = SLclass_get_class_id(type->slclass);

	   /* Support downcasting ancestor types to this type */
	   if (-1 == SLclass_add_typecast (ancestor_type, new_type,
		    					opaque_typecast, 1))
		return SLANG_UNDEFINED_TYPE;

	   /* Support upcasting this type to each ancestor type */
	   if (-1 == SLclass_add_typecast (new_type, ancestor_type,
							opaque_typecast, 1))
		return SLANG_UNDEFINED_TYPE;

	   type = type->parent;
	}
   }

   if ( (sget != NULL && SLclass_set_sget_function(new_class, sget) == -1) ||
	(sput != NULL && SLclass_set_sput_function(new_class, sput) == -1))
	return SLANG_UNDEFINED_TYPE;
	
   if ( (type = (Slirp_Type*) SLmalloc(sizeof(Slirp_Type))) == NULL)
	return SLANG_UNDEFINED_TYPE;

   type->slclass = new_class;
   type->parent = parent;
   type->finalizer = fzer;
   type->initializer = izer;
   Slirp_Opaque_Types[ Slirp_Num_Opaque_Types++ ] = type;

   return new_type;
}

static int allocate_reserved_opaque_types(void)
{
   Reserved_Opaque_Type *pt;
   long abi_version = -1;

   if ( SLang_is_defined((char*)"_slirp_initialized")) {

	if ( SLang_is_defined((char*)"_slirp_abi_version") == 0  ||
		SLang_load_string((char*)"_slirp_abi_version;") == -1 ||
		SLang_pop_long(&abi_version) == -1 ||
		abi_version != SLIRP_ABI_VERSION)
	{
	   SLang_verror(SLEU,
		(char*) "SLIRP abi mismatch: want version %ld, have %ld\n",
		(long)SLIRP_ABI_VERSION, abi_version);
	   return -1;
	}

	return 0;
   }

   (void)SLang_load_string((char*)"public variable _slirp_initialized=1;");
   (void)SLang_push_int(SLIRP_ABI_VERSION);
   (void)SLang_load_string((char*)"public variable _slirp_abi_version=();");

   Slirp_Num_Opaque_Types = 0;

   if ( NULL == (Slirp_Opaque_Types = (Slirp_Type**) SLmalloc
			( sizeof(Slirp_Type*) * (NUM_RESERVED_OPAQUES + 1))))
      return -1;

   Slirp_Opaque_Types[0] = NULL;

   pt = Reserved_Opaque_Types;
   while (pt->name != NULL) {
	if ((*pt->type = allocate_opaque(pt->name, NULL,NULL,0,NULL,NULL)) ==
	      						SLANG_UNDEFINED_TYPE)
		return -1;
	   pt++;
	}

   /* Loop again, to enable casts to/from generic pointer type */
   pt = Reserved_Opaque_Types + 1;
   while (pt->name != NULL) {

	if (-1 == SLclass_add_typecast (*pt->type, void_ptr_Type,
							opaque_typecast, 1))
	   return SLANG_UNDEFINED_TYPE;

	if (-1 == SLclass_add_typecast (void_ptr_Type, *pt->type,
							opaque_typecast, 1))
	   return SLANG_UNDEFINED_TYPE;

	pt++;
   }

   First_Opaque_Type = *Reserved_Opaque_Types[0].type;
   Last_Reserved_Opaque_Type = First_Opaque_Type + NUM_RESERVED_OPAQUES - 1;

   return 0;
} /* }}} */
static int pop_nullable(SLtype type, void **obj, void **meta)
{
   if (SLANG_NULL_TYPE == SLang_peek_at_stack ()) { 
	*obj = NULL;
	if (type && meta != NULL)
	   *meta = NULL;
	return SLang_pop_null ();
   }

   switch(type) {

	case 0:
	   return SLang_pop_cstruct(*obj, (SLang_CStruct_Field_Type *)meta);

	case SLANG_ANY_TYPE:
	   return SLang_pop_anytype((SLang_Any_Type**)obj);

	case SLANG_REF_TYPE:
	   return SLang_pop_ref((SLang_Ref_Type**)obj);

	case SLANG_STRING_TYPE:
	   return SLang_pop_slstring ((char**)obj);

	default:
	   /* This will fail, as intended, for non-opaque types */
	   return SLang_pop_opaque(type, meta, (Slirp_Opaque**)obj);
   }
}
#define pop_string_or_null(s)  pop_nullable(SLANG_STRING_TYPE,(void**)s,NULL)
#define pop_ref_or_null(r)  pop_nullable(SLANG_REF_TYPE,(void**)&r->ref,r->data)
#define pop_anytype_or_null(a) pop_nullable(SLANG_ANY_TYPE,(void**)a,NULL)

SLtype Gif_Image_Type = 0;
SLtype Gif_Colormap_Type = 0;
SLtype Gif_RGBA_Type = 0;
SLtype Gif_Stream_Type = 0;
SLtype Gif_Comment_Type = 0;
SLtype Gif_Extension_Type = 0;
SLtype Gif_Record_Type = 0;
SLtype Gif_Color_Type = 0;

static int allocate_gif_opaque_types(void) /* {{{ */
{
   if (Gif_Image_Type) return 0;

   Slirp_Opaque_Types = (Slirp_Type**) SLrealloc((char*)Slirp_Opaque_Types,
		(1 + Slirp_Num_Opaque_Types + 8) * sizeof(Slirp_Type*));

   if (Slirp_Opaque_Types == NULL) return -1;

   Gif_Image_Type = allocate_opaque((char*)"Gif_Image_Type",
		(FINALIZER) Gif_DeleteImage, 
		(INITIALIZER) Gif_ImageRef,
		(SLtype) 0, NULL, NULL);
   if (Gif_Image_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Colormap_Type = allocate_opaque((char*)"Gif_Colormap_Type",
		(FINALIZER) Gif_DeleteColormap, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Colormap_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_RGBA_Type = allocate_opaque((char*)"Gif_RGBA_Type",
		(FINALIZER) Gif_DeleteRGBA, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_RGBA_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Stream_Type = allocate_opaque((char*)"Gif_Stream_Type",
		(FINALIZER) Gif_DeleteStream, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Stream_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Comment_Type = allocate_opaque((char*)"Gif_Comment_Type",
		(FINALIZER) free, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Comment_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Extension_Type = allocate_opaque((char*)"Gif_Extension_Type",
		(FINALIZER) free, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Extension_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Record_Type = allocate_opaque((char*)"Gif_Record_Type",
		(FINALIZER) free, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Record_Type == SLANG_UNDEFINED_TYPE) return -1;

   Gif_Color_Type = allocate_opaque((char*)"Gif_Color_Type",
		(FINALIZER) free, 
		(INITIALIZER) NULL,
		(SLtype) 0, NULL, NULL);
   if (Gif_Color_Type == SLANG_UNDEFINED_TYPE) return -1;

   return 0;
} /* }}} */

#include "slirp/handcoded.c"

/* Wrapper functions */ /* {{{ */
static void sl_Gif_DeleteExtension (void)
{
   Gif_Extension* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Extension_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(0,0,0); return;}

   Gif_DeleteExtension(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_ImageSetDelay (void)
{
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;
   uint16_t arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_ushort((unsigned short*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(1,1,0); return;}

   Gif_ImageSetDelay(arg1,  arg2);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_FindColor (void)
{
   int retval;
   Gif_Colormap* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Color* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(Gif_Color_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Colormap_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(2,2,0); return;}

   retval = Gif_FindColor(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_GetRGBA (void)
{
   Gif_RGBA* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(3,3,0); return;}

   retval = Gif_GetRGBA(arg1,  arg2);
   if (retval == NULL)
	SLang_push_null();
   else
	push_gif_rgba(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_FullReadRecord (void)
{
   Gif_Stream* retval;
   const Gif_Record* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;
   Gif_ReadErrorHandler arg3;
   Slirp_Opaque* arg3_o = NULL;
   void* arg4;
   Slirp_Opaque* arg4_o = NULL;

   if (SLang_Num_Function_Args != 4 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg4, &arg4_o) == -1 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Record_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(4,4,0); return;}

   retval = Gif_FullReadRecord(arg1,  arg2, arg3, arg4);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg3_o);
   SLang_free_opaque(arg4_o);
}

static void sl_Gif_DeleteColormap (void)
{
   Gif_Colormap* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Colormap_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(5,5,0); return;}

   Gif_DeleteColormap(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_AddCommentTake (void)
{
   int retval;
   Gif_Comment* arg1;
   Slirp_Opaque* arg1_o = NULL;
   char* arg2;
   int arg3;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_string((char**)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Comment_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(6,6,0); return;}

   retval = Gif_AddCommentTake(arg1, arg2,  arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_slstring(arg2);
}

static void sl_Gif_ImageToRGBA (void)
{
   Gif_RGBA* retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Colormap* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	pop_nullable(Gif_Colormap_Type, (void**)&arg2_o, (void**)&arg2) == -1 ||
	pop_nullable(Gif_Image_Type, (void**)&arg1_o, (void**)&arg1) == -1 )
	{Slirp_usage(7,7,0); return;}

   retval = Gif_ImageToRGBA(arg1, arg2);
   if (retval == NULL)
	SLang_push_null();
   else
	push_gif_rgba(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_ReadRecord (void)
{
   Gif_Stream* retval;
   const Gif_Record* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Record_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(8,8,0); return;}

   retval = Gif_ReadRecord(arg1);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_CopyString (void)
{
   char* retval;
   char* arg1;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_string((char**)&arg1) == -1 )
	{Slirp_usage(9,9,0); return;}

   retval = Gif_CopyString(arg1);
   SLang_push_malloced_string(retval);
   SLang_free_slstring(arg1);
}

static void sl_Gif_CopyColormap (void)
{
   Gif_Colormap* retval;
   Gif_Colormap* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Colormap_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(10,10,0); return;}

   retval = Gif_CopyColormap(arg1);
   SLang_push_opaque(Gif_Colormap_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_DeleteRGBA (void)
{
   Gif_RGBA* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_RGBA_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(11,11,0); return;}

   Gif_DeleteRGBA(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_NewExtension (void)
{
   Gif_Extension* retval;
   int arg1;
   char* arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_string((char**)&arg2) == -1 ||
	SLang_pop_int((int*)&arg1) == -1 )
	{Slirp_usage(12,12,0); return;}

   retval = Gif_NewExtension( arg1, arg2);
   SLang_push_opaque(Gif_Extension_Type, (void*)retval, 0);
   SLang_free_slstring(arg2);
}

static void sl_Gif_FullCompressImage (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Image* arg2;
   Slirp_Opaque* arg2_o = NULL;
   int arg3;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(13,13,0); return;}

   retval = Gif_FullCompressImage(arg1, arg2,  arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_ScreenHeight (void)
{
   uint16_t retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(14,14,0); return;}

   retval = Gif_ScreenHeight(arg1);
   SLang_push_ushort(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_GetExtension (void)
{
   Gif_Extension* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;
   Gif_Extension* arg3;
   Slirp_Opaque* arg3_o = NULL;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_opaque(Gif_Extension_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(15,15,0); return;}

   retval = Gif_GetExtension(arg1,  arg2, arg3);
   SLang_push_opaque(Gif_Extension_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg3_o);
}

static void sl_Gif_ReadFile (void)
{
   Gif_Stream* retval;
   FILE* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(file_ptr_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(16,16,0); return;}

   retval = Gif_ReadFile(arg1);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o); SLfree((char*) arg1_o);
}

static void sl_Gif_ClipImage (void)
{
   int retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;
   int arg3;
   int arg4;
   int arg5;

   if (SLang_Num_Function_Args != 5 ||
	SLang_pop_int((int*)&arg5) == -1 ||
	SLang_pop_int((int*)&arg4) == -1 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(17,17,0); return;}

   retval = Gif_ClipImage(arg1,  arg2,  arg3,  arg4,  arg5);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_AddDeletionHook (void)
{
   int retval;
   int arg1;
   Gif_DeletionHookFunc arg2;
   Slirp_Opaque* arg2_o = NULL;
   void* arg3;
   Slirp_Opaque* arg3_o = NULL;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_int((int*)&arg1) == -1 )
	{Slirp_usage(18,18,0); return;}

   retval = Gif_AddDeletionHook( arg1, arg2, arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg2_o);
   SLang_free_opaque(arg3_o);
}

static void sl_Gif_CopyStreamSkeleton (void)
{
   Gif_Stream* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(19,19,0); return;}

   retval = Gif_CopyStreamSkeleton(arg1);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_ColorEq (void)
{
   int retval;
   Gif_Color* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Color* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(Gif_Color_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Color_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(20,20,0); return;}

   retval = Gif_ColorEq(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_CalculateScreenSize (void)
{
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(21,21,0); return;}

   Gif_CalculateScreenSize(arg1,  arg2);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_ReleaseUncompressedImage (void)
{
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(22,22,0); return;}

   Gif_ReleaseUncompressedImage(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_AddExtension (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Extension* arg2;
   Slirp_Opaque* arg2_o = NULL;
   int arg3;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_opaque(Gif_Extension_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(23,23,0); return;}

   retval = Gif_AddExtension(arg1, arg2,  arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_NewStream (void)
{
   Gif_Stream* retval;

   if (SLang_Num_Function_Args != 0)
	{Slirp_usage(24,24,0); return;}

   retval = Gif_NewStream();
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
}

static void sl_Gif_AddColor (void)
{
   int retval;
   Gif_Colormap* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Color* arg2;
   Slirp_Opaque* arg2_o = NULL;
   int arg3;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_opaque(Gif_Color_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Colormap_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(25,25,0); return;}

   retval = Gif_AddColor(arg1, arg2,  arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_NewComment (void)
{
   Gif_Comment* retval;

   if (SLang_Num_Function_Args != 0)
	{Slirp_usage(26,26,0); return;}

   retval = Gif_NewComment();
   SLang_push_opaque(Gif_Comment_Type, (void*)retval, 0);
}

static void sl_Gif_ImageFromRGBA (void)
{
   Gif_Image* retval;
   Gif_RGBA* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_RGBA_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(27,27,0); return;}

   retval = Gif_ImageFromRGBA(arg1);
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_GetGlobalColormap (void)
{
   Gif_Colormap* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(28,28,0); return;}

   retval = Gif_GetGlobalColormap(arg1);
   SLang_push_opaque(Gif_Colormap_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_WriteFile (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   FILE* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(file_ptr_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(29,29,0); return;}

   retval = Gif_WriteFile(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o); SLfree((char*) arg2_o);
}

static void sl_Gif_CompressImage (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Image* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(30,30,0); return;}

   retval = Gif_CompressImage(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_NewColormap (void)
{
   Gif_Colormap* retval;

   if (SLang_Num_Function_Args != 0)
	{Slirp_usage(31,31,0); return;}

   retval = Gif_NewColormap();
   SLang_push_opaque(Gif_Colormap_Type, (void*)retval, 0);
}

static void sl_Gif_CopyImage (void)
{
   Gif_Image* retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(32,32,0); return;}

   retval = Gif_CopyImage(arg1);
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_CreateUncompressedImage (void)
{
   int retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(33,33,0); return;}

   retval = Gif_CreateUncompressedImage(arg1);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_DeleteComment (void)
{
   Gif_Comment* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Comment_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(34,34,0); return;}

   Gif_DeleteComment(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_NewFullColormap (void)
{
   Gif_Colormap* retval;
   int arg1;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_int((int*)&arg1) == -1 )
	{Slirp_usage(35,35,0); return;}

   retval = Gif_NewFullColormap( arg1,  arg2);
   SLang_push_opaque(Gif_Colormap_Type, (void*)retval, 0);
}

static void sl_Gif_ImageRef (void)
{
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(36,36,0); return;}

   Gif_ImageRef(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_RemoveDeletionHook (void)
{
   int arg1;
   Gif_DeletionHookFunc arg2;
   Slirp_Opaque* arg2_o = NULL;
   void* arg3;
   Slirp_Opaque* arg3_o = NULL;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_int((int*)&arg1) == -1 )
	{Slirp_usage(37,37,0); return;}

   Gif_RemoveDeletionHook( arg1, arg2, arg3);
   SLang_free_opaque(arg2_o);
   SLang_free_opaque(arg3_o);
}

static void sl_Gif_ReleaseCompressedImage (void)
{
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(38,38,0); return;}

   Gif_ReleaseCompressedImage(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_InterlaceLine (void)
{
   int retval;
   int arg1;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_int((int*)&arg1) == -1 )
	{Slirp_usage(39,39,0); return;}

   retval = Gif_InterlaceLine( arg1,  arg2);
   SLang_push_int(retval);
}

static void sl_Gif_RemoveImage (void)
{
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(40,40,0); return;}

   Gif_RemoveImage(arg1,  arg2);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_AddImage (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Image* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(41,41,0); return;}

   retval = Gif_AddImage(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_NewRGBA (void)
{
   Gif_RGBA* retval;

   if (SLang_Num_Function_Args != 0)
	{Slirp_usage(42,42,0); return;}

   retval = Gif_NewRGBA();
   if (retval == NULL)
	SLang_push_null();
   else
	push_gif_rgba(retval);
}

static void sl_Gif_DeleteStream (void)
{
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(43,43,0); return;}

   Gif_DeleteStream(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_ImageNumber (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_Image* arg2;
   Slirp_Opaque* arg2_o = NULL;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(44,44,0); return;}

   retval = Gif_ImageNumber(arg1, arg2);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
}

static void sl_Gif_ImageGetDelay (void)
{
   uint16_t retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	pop_nullable(Gif_Image_Type, (void**)&arg1_o, (void**)&arg1) == -1 )
	{Slirp_usage(45,45,0); return;}

   retval = Gif_ImageGetDelay(arg1);
   SLang_push_ushort(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_GetImage (void)
{
   Gif_Image* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(46,46,0); return;}

   retval = Gif_GetImage(arg1,  arg2);
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_FullUncompressImage (void)
{
   int retval;
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;
   Gif_ReadErrorHandler arg2;
   Slirp_Opaque* arg2_o = NULL;
   void* arg3;
   Slirp_Opaque* arg3_o = NULL;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg2, &arg2_o) == -1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(47,47,0); return;}

   retval = Gif_FullUncompressImage(arg1, arg2, arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg2_o);
   SLang_free_opaque(arg3_o);
}

static void sl_Gif_ImageCount (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(48,48,0); return;}

   retval = Gif_ImageCount(arg1);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_GetNamedImage (void)
{
   Gif_Image* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   char* arg2;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_string((char**)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(49,49,0); return;}

   retval = Gif_GetNamedImage(arg1, arg2);
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
   SLang_free_slstring(arg2);
}

static void sl_Gif_FullReadFile (void)
{
   Gif_Stream* retval;
   FILE* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;
   Gif_ReadErrorHandler arg3;
   Slirp_Opaque* arg3_o = NULL;
   void* arg4;
   Slirp_Opaque* arg4_o = NULL;

   if (SLang_Num_Function_Args != 4 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg4, &arg4_o) == -1 ||
	SLang_pop_opaque(void_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(file_ptr_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(50,50,0); return;}

   retval = Gif_FullReadFile(arg1,  arg2, arg3, arg4);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o); SLfree((char*) arg1_o);
   SLang_free_opaque(arg3_o);
   SLang_free_opaque(arg4_o);
}

static void sl_Gif_ScreenWidth (void)
{
   uint16_t retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(51,51,0); return;}

   retval = Gif_ScreenWidth(arg1);
   SLang_push_ushort(retval);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_DeleteImage (void)
{
   Gif_Image* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Image_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(52,52,0); return;}

   Gif_DeleteImage(arg1);
   SLang_free_opaque(arg1_o);
}

static void sl_Gif_NewImage (void)
{
   Gif_Image* retval;

   if (SLang_Num_Function_Args != 0)
	{Slirp_usage(53,53,0); return;}

   retval = Gif_NewImage();
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
}

static void sl_Gif_AddComment (void)
{
   int retval;
   Gif_Comment* arg1;
   Slirp_Opaque* arg1_o = NULL;
   char* arg2;
   int arg3;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_int((int*)&arg3) == -1 ||
	SLang_pop_string((char**)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Comment_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(54,54,0); return;}

   retval = Gif_AddComment(arg1, arg2,  arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_slstring(arg2);
}

static void sl_Gif_FullWriteFile (void)
{
   int retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;
   int arg2;
   FILE* arg3;
   Slirp_Opaque* arg3_o = NULL;

   if (SLang_Num_Function_Args != 3 ||
	SLang_pop_opaque(file_ptr_Type, (void**)&arg3, &arg3_o) == -1 ||
	SLang_pop_int((int*)&arg2) == -1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(55,55,0); return;}

   retval = Gif_FullWriteFile(arg1,  arg2, arg3);
   SLang_push_int(retval);
   SLang_free_opaque(arg1_o);
   SLang_free_opaque(arg3_o); SLfree((char*) arg3_o);
}

static void sl_Gif_CopyStreamImages (void)
{
   Gif_Stream* retval;
   Gif_Stream* arg1;
   Slirp_Opaque* arg1_o = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_opaque(Gif_Stream_Type, (void**)&arg1, &arg1_o) == -1 )
	{Slirp_usage(56,56,0); return;}

   retval = Gif_CopyStreamImages(arg1);
   SLang_push_opaque(Gif_Stream_Type, (void*)retval, 0);
   SLang_free_opaque(arg1_o);
}


static SLang_Intrin_Fun_Type gif_Funcs [] =
{
   MAKE_INTRINSIC_0((char*)"Gif_DeleteExtension",sl_Gif_DeleteExtension,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageSetDelay",sl_Gif_ImageSetDelay,V),
   MAKE_INTRINSIC_0((char*)"Gif_FindColor",sl_Gif_FindColor,V),
   MAKE_INTRINSIC_0((char*)"Gif_GetRGBA",sl_Gif_GetRGBA,V),
   MAKE_INTRINSIC_0((char*)"Gif_FullReadRecord",sl_Gif_FullReadRecord,V),
   MAKE_INTRINSIC_0((char*)"Gif_DeleteColormap",sl_Gif_DeleteColormap,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddCommentTake",sl_Gif_AddCommentTake,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageToRGBA",sl_Gif_ImageToRGBA,V),
   MAKE_INTRINSIC_0((char*)"Gif_ReadRecord",sl_Gif_ReadRecord,V),
   MAKE_INTRINSIC_0((char*)"Gif_CopyString",sl_Gif_CopyString,V),
   MAKE_INTRINSIC_0((char*)"Gif_CopyColormap",sl_Gif_CopyColormap,V),
   MAKE_INTRINSIC_0((char*)"Gif_DeleteRGBA",sl_Gif_DeleteRGBA,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewExtension",sl_Gif_NewExtension,V),
   MAKE_INTRINSIC_0((char*)"Gif_FullCompressImage",sl_Gif_FullCompressImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_ScreenHeight",sl_Gif_ScreenHeight,V),
   MAKE_INTRINSIC_0((char*)"Gif_GetExtension",sl_Gif_GetExtension,V),
   MAKE_INTRINSIC_0((char*)"Gif_ReadFile",sl_Gif_ReadFile,V),
   MAKE_INTRINSIC_0((char*)"Gif_ClipImage",sl_Gif_ClipImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddDeletionHook",sl_Gif_AddDeletionHook,V),
   MAKE_INTRINSIC_0((char*)"Gif_CopyStreamSkeleton",sl_Gif_CopyStreamSkeleton,V),
   MAKE_INTRINSIC_0((char*)"Gif_ColorEq",sl_Gif_ColorEq,V),
   MAKE_INTRINSIC_0((char*)"Gif_CalculateScreenSize",sl_Gif_CalculateScreenSize,V),
   MAKE_INTRINSIC_0((char*)"Gif_ReleaseUncompressedImage",sl_Gif_ReleaseUncompressedImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddExtension",sl_Gif_AddExtension,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewStream",sl_Gif_NewStream,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddColor",sl_Gif_AddColor,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewComment",sl_Gif_NewComment,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageFromRGBA",sl_Gif_ImageFromRGBA,V),
   MAKE_INTRINSIC_0((char*)"Gif_GetGlobalColormap",sl_Gif_GetGlobalColormap,V),
   MAKE_INTRINSIC_0((char*)"Gif_WriteFile",sl_Gif_WriteFile,V),
   MAKE_INTRINSIC_0((char*)"Gif_CompressImage",sl_Gif_CompressImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewColormap",sl_Gif_NewColormap,V),
   MAKE_INTRINSIC_0((char*)"Gif_CopyImage",sl_Gif_CopyImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_CreateUncompressedImage",sl_Gif_CreateUncompressedImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_DeleteComment",sl_Gif_DeleteComment,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewFullColormap",sl_Gif_NewFullColormap,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageRef",sl_Gif_ImageRef,V),
   MAKE_INTRINSIC_0((char*)"Gif_RemoveDeletionHook",sl_Gif_RemoveDeletionHook,V),
   MAKE_INTRINSIC_0((char*)"Gif_ReleaseCompressedImage",sl_Gif_ReleaseCompressedImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_InterlaceLine",sl_Gif_InterlaceLine,V),
   MAKE_INTRINSIC_0((char*)"Gif_RemoveImage",sl_Gif_RemoveImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddImage",sl_Gif_AddImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewRGBA",sl_Gif_NewRGBA,V),
   MAKE_INTRINSIC_0((char*)"Gif_DeleteStream",sl_Gif_DeleteStream,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageNumber",sl_Gif_ImageNumber,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageGetDelay",sl_Gif_ImageGetDelay,V),
   MAKE_INTRINSIC_0((char*)"Gif_GetImage",sl_Gif_GetImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_FullUncompressImage",sl_Gif_FullUncompressImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_ImageCount",sl_Gif_ImageCount,V),
   MAKE_INTRINSIC_0((char*)"Gif_GetNamedImage",sl_Gif_GetNamedImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_FullReadFile",sl_Gif_FullReadFile,V),
   MAKE_INTRINSIC_0((char*)"Gif_ScreenWidth",sl_Gif_ScreenWidth,V),
   MAKE_INTRINSIC_0((char*)"Gif_DeleteImage",sl_Gif_DeleteImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_NewImage",sl_Gif_NewImage,V),
   MAKE_INTRINSIC_0((char*)"Gif_AddComment",sl_Gif_AddComment,V),
   MAKE_INTRINSIC_0((char*)"Gif_FullWriteFile",sl_Gif_FullWriteFile,V),
   MAKE_INTRINSIC_0((char*)"Gif_CopyStreamImages",sl_Gif_CopyStreamImages,V),
   SLANG_END_INTRIN_FUN_TABLE
};   /* }}} */

static const char* usage_strings[] = { /* {{{ */
   "Gif_DeleteExtension(Gif_Extension)",
   "Gif_ImageSetDelay(Gif_Image,ushort)",
   "int = Gif_FindColor(Gif_Colormap,Gif_Color)",
   "Gif_RGBA = Gif_GetRGBA(Gif_Stream,int)",
   "Gif_Stream = Gif_FullReadRecord(Gif_Record,int,void_ptr,void_ptr)",
   "Gif_DeleteColormap(Gif_Colormap)",
   "int = Gif_AddCommentTake(Gif_Comment,string,int)",
   "Gif_RGBA = Gif_ImageToRGBA(Gif_Image,Gif_Colormap)",
   "Gif_Stream = Gif_ReadRecord(Gif_Record)",
   "string = Gif_CopyString(string)",
   "Gif_Colormap = Gif_CopyColormap(Gif_Colormap)",
   "Gif_DeleteRGBA(Gif_RGBA)",
   "Gif_Extension = Gif_NewExtension(int,string)",
   "int = Gif_FullCompressImage(Gif_Stream,Gif_Image,int)",
   "ushort = Gif_ScreenHeight(Gif_Stream)",
   "Gif_Extension = Gif_GetExtension(Gif_Stream,int,Gif_Extension)",
   "Gif_Stream = Gif_ReadFile(file_ptr)",
   "int = Gif_ClipImage(Gif_Image,int,int,int,int)",
   "int = Gif_AddDeletionHook(int,void_ptr,void_ptr)",
   "Gif_Stream = Gif_CopyStreamSkeleton(Gif_Stream)",
   "int = Gif_ColorEq(Gif_Color,Gif_Color)",
   "Gif_CalculateScreenSize(Gif_Stream,int)",
   "Gif_ReleaseUncompressedImage(Gif_Image)",
   "int = Gif_AddExtension(Gif_Stream,Gif_Extension,int)",
   "Gif_Stream = Gif_NewStream()",
   "int = Gif_AddColor(Gif_Colormap,Gif_Color,int)",
   "Gif_Comment = Gif_NewComment()",
   "Gif_Image = Gif_ImageFromRGBA(Gif_RGBA)",
   "Gif_Colormap = Gif_GetGlobalColormap(Gif_Stream)",
   "int = Gif_WriteFile(Gif_Stream,file_ptr)",
   "int = Gif_CompressImage(Gif_Stream,Gif_Image)",
   "Gif_Colormap = Gif_NewColormap()",
   "Gif_Image = Gif_CopyImage(Gif_Image)",
   "int = Gif_CreateUncompressedImage(Gif_Image)",
   "Gif_DeleteComment(Gif_Comment)",
   "Gif_Colormap = Gif_NewFullColormap(int,int)",
   "Gif_ImageRef(Gif_Image)",
   "Gif_RemoveDeletionHook(int,void_ptr,void_ptr)",
   "Gif_ReleaseCompressedImage(Gif_Image)",
   "int = Gif_InterlaceLine(int,int)",
   "Gif_RemoveImage(Gif_Stream,int)",
   "int = Gif_AddImage(Gif_Stream,Gif_Image)",
   "Gif_RGBA = Gif_NewRGBA()",
   "Gif_DeleteStream(Gif_Stream)",
   "int = Gif_ImageNumber(Gif_Stream,Gif_Image)",
   "ushort = Gif_ImageGetDelay(Gif_Image)",
   "Gif_Image = Gif_GetImage(Gif_Stream,int)",
   "int = Gif_FullUncompressImage(Gif_Image,void_ptr,void_ptr)",
   "int = Gif_ImageCount(Gif_Stream)",
   "Gif_Image = Gif_GetNamedImage(Gif_Stream,string)",
   "Gif_Stream = Gif_FullReadFile(file_ptr,int,void_ptr,void_ptr)",
   "ushort = Gif_ScreenWidth(Gif_Stream)",
   "Gif_DeleteImage(Gif_Image)",
   "Gif_Image = Gif_NewImage()",
   "int = Gif_AddComment(Gif_Comment,string,int)",
   "int = Gif_FullWriteFile(Gif_Stream,int,file_ptr)",
   "Gif_Stream = Gif_CopyStreamImages(Gif_Stream)",
NULL
}; /* }}} */

static void Slirp_usage(int i, int last, int flags) /* {{{ */
{
   char *indent;
   int npop = SLstack_depth();
   if (npop > SLang_Num_Function_Args) npop = SLang_Num_Function_Args;
   SLdo_pop_n(npop);
   if (last == i)
	indent = (char*)"Usage:  ";
   else {
	indent = (char*)"\t";
	SLang_verror(SLEU, (char*)"Usage: one of");
   }
   do
	SLang_verror(SLEU, (char*)"%s%s", indent, usage_strings[i++]);
   while (i < last);
   if (flags & 0x2)
	SLang_verror(SLEU,
		(char*)"\tThis function has been vectorized and parallelized.");
   else if (flags & 0x1)
	SLang_verror(SLEU, (char*)"\tThis function has been vectorized.");
} /* }}} */

static SLang_IConstant_Type gif_IConsts [] =	/* {{{ */
{
   MAKE_ICONSTANT((char*)"GIF_MAX_BLOCK",255),
   MAKE_ICONSTANT((char*)"GIF_DISPOSAL_ASIS",1),
   MAKE_ICONSTANT((char*)"HAVE_STRTOUL",1),
   MAKE_ICONSTANT((char*)"HAVE_SYS_TYPES_H",1),
   MAKE_ICONSTANT((char*)"GIF_MAJOR_VERSION",1),
   MAKE_ICONSTANT((char*)"GIF_READ_TRAILING_GARBAGE_OK",8),
   MAKE_ICONSTANT((char*)"GIF_T_IMAGE",1),
   MAKE_ICONSTANT((char*)"GIF_MAX_CODE_BITS",12),
   MAKE_ICONSTANT((char*)"HAVE_STDLIB_H",1),
   MAKE_ICONSTANT((char*)"SIZEOF_UNSIGNED_INT",4),
   MAKE_ICONSTANT((char*)"GIF_WRITE_CAREFUL_MIN_CODE_SIZE",1),
   MAKE_ICONSTANT((char*)"GIF_DISPOSAL_NONE",0),
   MAKE_ICONSTANT((char*)"SIZEOF_VOID_P",4),
   MAKE_ICONSTANT((char*)"GIF_DISPOSAL_PREVIOUS",3),
   MAKE_ICONSTANT((char*)"HAVE_UINTPTR_T",1),
   MAKE_ICONSTANT((char*)"GIF_T_STREAM",0),
   MAKE_ICONSTANT((char*)"STDC_HEADERS",1),
   MAKE_ICONSTANT((char*)"HAVE_SYS_SELECT_H",1),
   MAKE_ICONSTANT((char*)"GIF_READ_UNCOMPRESSED",2),
   MAKE_ICONSTANT((char*)"HAVE_UNISTD_H",1),
   MAKE_ICONSTANT((char*)"GIF_READ_CONST_RECORD",4),
   MAKE_ICONSTANT((char*)"PATHNAME_SEPARATOR",47),
   MAKE_ICONSTANT((char*)"HAVE_STRERROR",1),
   MAKE_ICONSTANT((char*)"HAVE_MKSTEMP",1),
   MAKE_ICONSTANT((char*)"HAVE_MEMORY_H",1),
   MAKE_ICONSTANT((char*)"GIF_MINOR_VERSION",5),
   MAKE_ICONSTANT((char*)"GIF_READ_COMPRESSED",1),
   MAKE_ICONSTANT((char*)"HAVE_INTTYPES_H",1),
   MAKE_ICONSTANT((char*)"HAVE_STDINT_H",1),
   MAKE_ICONSTANT((char*)"HAVE_STRINGS_H",1),
   MAKE_ICONSTANT((char*)"GIF_MAX_CODE",0x1000),
   MAKE_ICONSTANT((char*)"GETTIMEOFDAY_PROTO",2),
   MAKE_ICONSTANT((char*)"GIF_UNOPTIMIZE_SIMPLEST_DISPOSAL",1),
   MAKE_ICONSTANT((char*)"HAVE_SYS_STAT_H",1),
   MAKE_ICONSTANT((char*)"HAVE_STRING_H",1),
   MAKE_ICONSTANT((char*)"SIZEOF_UNSIGNED_LONG",4),
   MAKE_ICONSTANT((char*)"GIF_T_COLORMAP",2),
   MAKE_ICONSTANT((char*)"GIF_DISPOSAL_BACKGROUND",2),
   SLANG_END_ICONST_TABLE
};	/* }}} */

static const char *gif_strings[] = {	/* {{{ */
   "gifsicle",
   "1.57",
   "",
   "",
   "1.5",
   "",
   "",
   "",
NULL
};	/* }}} */


static SLang_Intrin_Var_Type gif_IVars [] = /* {{{ */
{
   MAKE_VARIABLE((char*)"PACKAGE",&gif_strings[0], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"VERSION",&gif_strings[1], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"PACKAGE_TARNAME",&gif_strings[2], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"PACKAGE_VERSION",&gif_strings[3], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"GIF_VERSION",&gif_strings[4], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"PACKAGE_BUGREPORT",&gif_strings[5], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"PACKAGE_NAME",&gif_strings[6], SLANG_STRING_TYPE,1),
   MAKE_VARIABLE((char*)"PACKAGE_STRING",&gif_strings[7], SLANG_STRING_TYPE,1),
   SLANG_END_INTRIN_VAR_TABLE
};	/* }}} */

