
/****************************************************************************
 * SLgif: S-Lang bindings for GIF file i/o, based upon gifsicle by E. Kohler.
 *
 * This software was developed at the MIT Kavli Institute for Astrophysics,
 * partially under contract SV1-61010 from the Smithsonian Institution, and
 * with additional NASA funding through the AISRP grant NNG06GE58G.
 * 
 * The Massachusetts Institute of Technology makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 * 
 * THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
 * INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************************************************/

#include "slgifconfig.h"
#include "gif_glue.c"

SLANG_MODULE(gif);

int init_gif_module_ns(char *ns_name)	/* {{{ */
{
   SLang_NameSpace_Type *ns = NULL;

   if (slang_abi_mismatch()) return -1;
   if (ns_name != NULL) {
	ns = SLns_create_namespace (ns_name);
       if (ns == NULL ||
          (slns = SLmalloc(strlen(ns_name)+1)) == NULL)
          return -1;
       strcpy(slns, ns_name);
   }

   if (allocate_reserved_opaque_types() == -1) return -1;
   if (allocate_gif_opaque_types() == -1) return -1;

   if ( -1 == SLns_add_iconstant_table(ns,gif_IConsts,NULL) ||
	-1 == SLns_add_intrin_var_table(ns,gif_IVars,NULL)  ||
	-1 == SLns_add_intrin_fun_table (ns,gif_Funcs,(char*)"__gif__") ||
	-1 == SLns_add_intrin_fun_table (ns,Manual_Funcs,(char*)"__gif__"))
	return -1;

   /*(void) &ref_get_size;
   (void) &establish_dims;*/

   return 0;
} /* }}} */
