
gboolean
gdk_pixbuf_add_module(
	gchar *name,
	GdkPixbufModuleFillInfoFunc fill_info,
        GdkPixbufModuleFillVtableFunc fill_vtable)
{
   /* This function supports installing Gdk pixbuf modules from */
   /* statically-compiled-and-loaded code.  It should be added  */
   /* to gtk/gdk-pixbuf/gdk-pixbuf-io.c.  mnoble@space.mit.edu  */

   GdkPixbufModule *module;

   if (name == NULL || fill_info == NULL || fill_vtable == NULL)
	return FALSE;

   if (file_formats == NULL)
	gdk_pixbuf_io_init ();

   if ( (module = g_try_malloc(sizeof(GdkPixbufModule))) == NULL)
	return FALSE;
    
   memset(module,0,sizeof(GdkPixbufModule));

   module->module_name = name;		/* shallow copy: name must persist */
   module->module = (void *) 1;		/* avoid g_module load attempts */

   (* fill_vtable) (module);
   module->info = g_new0 (GdkPixbufFormat, 1);
   (* fill_info) (module->info);

   file_formats = g_slist_prepend (file_formats, module);

   return TRUE;
}
