% Simple top level window example in SLgtk (mnoble@space.mit.edu)

require("gtk");

define window_example() % {{{
{
   % Instantiate a top level window
   variable win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(win, "Top Level Window Example");

   % Make it big enough to see (and read the complete title)
   gtk_widget_set_size_request(win, 250, 50);

   variable button = gtk_button_new_with_label("Quit");
   gtk_container_add(win,button);

   % Destroy window and terminate event loop when Quit button is pressed ...
   () = g_signal_connect_swapped (button, "clicked", &gtk_widget_destroy, win);

   % ... or when window is closed by the window manager
   () = g_signal_connect (win, "destroy", &gtk_main_quit);

   % Realize the window and enter the main event loop
   gtk_widget_show_all(win);
   gtk_main();
} % }}}

% Defining slsh_main lets GUI be launched immediately when invoked via: {{{
%
%                       slsh window.sl
%
% The guilet may also be launched from S-Lang apps with dynamic linking via
%
%	require("window");
%	window_example;
%
% and variants.

define slsh_main()
{
   window_example;
} % }}}

provide("window");
