static variable window = NULL;


static define rb_clicked(radiob,label)
{
   % Here's another flaw in the radio button implementation (well, actually
   % toggle buttons in general):  The "clicked" signal will be emitted for
   % both the latest button chosen AND the one previously chosen.   This is 
   % a Gtk implementation blemish (discussed in the mail archives), which 
   % for historical reasons has not been corrected yet.  The caller should 
   % be mindful of this, and implement their callbacks accordingly.

   vmessage("clicked: %S",label);
}

static define rb_with_indicator(prevb, label, container)
{
   variable b = gtk_radio_button_new_with_label_from_widget (prevb,label);
   gtk_box_pack_start (container, b , TRUE, TRUE, 0);
   () = g_signal_connect (b,"clicked",&rb_clicked,label);
   return b;
}

static define rb_normal(prevb, label, container)
{
   % The Gtk radio button api design is flawed: each new button added
   % to the group is prepended, not appended, to its internal list.
   % This forces the programmer to explicitly retrieve the radio button
   % group each time it's needed (e.g., for calls which take a rbgroup
   % argument), since it's value (the head element of the list) changes
   % each time a new button is added to the group.  It would be better to
   % be able to get the rbgroup just once and reuse it N times.

   variable button;
   if (prevb == NULL)
	button = gtk_radio_button_new_with_label(NULL ,label);
   else
	button = gtk_radio_button_new_with_label(
	      		gtk_radio_button_get_group(prevb),label);
   gtk_box_pack_start (container, button , TRUE, TRUE, 0);
   gtk_toggle_button_set_mode(button,FALSE);
   return button;
}

define create_radiob (test)
{
  if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);

	gtk_window_set_title (window, "radio buttons");
	gtk_container_set_border_width ( window, 0);

	variable box1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add ( window, box1);

	variable box2 = gtk_vbox_new (FALSE, 10);
	gtk_container_set_border_width ( box2, 10);
	gtk_box_pack_start (box1, box2, TRUE, TRUE, 0);

	variable button = rb_with_indicator(NULL,"button1",box2);
	button = rb_with_indicator(button, "button2",box2);
	gtk_toggle_button_set_active (button, TRUE);
	button = rb_with_indicator(button, "button3",box2);
	button = rb_with_indicator(button, "inconsistent",box2);
	gtk_toggle_button_set_inconsistent (button, TRUE);
      
	variable separator = gtk_hseparator_new ();
	gtk_box_pack_start (box1, separator, FALSE, TRUE, 0);

	box2 = gtk_vbox_new (FALSE, 10);
	gtk_container_set_border_width ( box2, 10);
	gtk_box_pack_start (box1, box2, TRUE, TRUE, 0);

	button = rb_normal(NULL, "button4", box2);
	button = rb_normal(button, "button5", box2);
	gtk_toggle_button_set_active (button, TRUE);
	button = rb_normal(button, "button6",box2);

	test.lower = generic_close_button(box1,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
