
define cmw_destroy_cb(widget)
{
   % This is needed to get out of gtk_main.  Note that this signal callback 
   % is not prototyped to receive a data parameter, simply for convenience.
   % See the main.sl SLgtk examples driver for more discussion of such.
   gtk_main_quit ();
}

define cmw_color (widget, parent)
{
   variable csd = gtk_color_selection_dialog_new (
    			"This is a modal color selection dialog");

   gtk_window_set_modal (csd,TRUE);
   gtk_window_set_transient_for (csd, parent);
   gtk_window_set_position(csd, GTK_WIN_POS_CENTER_ON_PARENT);
   () = gtk_window_parse_geometry (csd,"+150+150");
    
   () = g_signal_connect (csd, "destroy", &cmw_destroy_cb);
   () = g_signal_connect_swapped(
		gtk_color_selection_dialog_get_ok_button(csd),
		"clicked", &gtk_widget_destroy,csd);

   () = g_signal_connect_swapped(
    		gtk_color_selection_dialog_get_cancel_button(csd),
		"clicked", &gtk_widget_destroy, csd);
    
   % wait until destroy calls gtk_main_quit 
   gtk_widget_show (csd);    
   gtk_main ();
}

define cmw_file (widget, parent)
{
   variable fs = gtk_file_selection_new("This is a modal file select dialog");
   gtk_window_set_modal (fs,TRUE);
   gtk_window_set_transient_for (fs, parent);
   () = gtk_window_parse_geometry (fs,"+150+150");

   () = g_signal_connect (fs, "destroy", &cmw_destroy_cb);
   () = g_signal_connect_swapped (gtk_file_selection_get_ok_button(fs),
				"clicked",&gtk_widget_destroy,fs);
   () = g_signal_connect_swapped (gtk_file_selection_get_cancel_button(fs),
				"clicked",&gtk_widget_destroy,fs);
    
   % wait until destroy calls gtk_main_quit 
   gtk_widget_show (fs);
   gtk_main();
}

define create_modalwin (test)
{
   variable window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (window,"This window is modal");
   gtk_window_set_modal (window,TRUE);

   variable box1 = gtk_vbox_new (FALSE,5);
   variable frame = gtk_frame_new ("Standard dialogs in modal form");
   variable box2 = gtk_vbox_new (TRUE,5);

   gtk_container_set_border_width (box1,3);
   gtk_container_set_border_width (box2,3);

   gtk_container_add( window, box1);
   gtk_box_pack_start( box1, frame, TRUE, TRUE, 4);
   gtk_container_add( frame, box2);

   variable button = gtk_button_new_with_label ("Color");
   () = g_signal_connect (button , "clicked", &cmw_color,window);
   gtk_box_pack_start( box2, button, FALSE, FALSE, 4);

   button = gtk_button_new_with_label ("File Selection");
   () = g_signal_connect (button, "clicked", &cmw_file,window);
   gtk_box_pack_start( box2, button, FALSE, FALSE, 4);

   test.lower = generic_close_button(box1,window);
   gtk_widget_show_all (window);
}
