/*
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003 Brian Carrier.  All rights reserved
 *
 * mm_open - wrapper function for specific partition type
 *
 * This file is part of mmtools
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * mmtools is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mactime; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, LOSS OF USE, DATA, OR PROFITS OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "mm_tools.h"


/* 
 * THe main wrapper function for opening an image
 */
MM_INFO *
mm_open(const char *path, const char *type, daddr_t sect_offset)
{
	u_int8_t	mmtype;

	/* Transate the string into the number */
	mmtype = mm_parse_type(type);

	switch (mmtype) {
		case MM_DOS:
		  return dos_open(path, MM_DOS, sect_offset);
		case MM_MAC:
		  return mac_open(path, MM_MAC, sect_offset);
		case MM_BSD:
		  return bsd_open(path, MM_BSD, sect_offset);
		case MM_SUN:
		  return sun_open(path, MM_SUN, sect_offset);
		case MM_GPT:
		  return gpt_open(path, MM_GPT, sect_offset); 
		case MM_UNSUPP:
		default:
			printf ("unknown partition type: %s\n", type);
			printf ("known types:\n");
			mm_print_types();
			exit(1);
	}
}

void
print_version()  
{
    char *str = "The Sleuth Kit";
#ifdef VER
    printf("%s ver %s\n", str, VER);
#else
    printf("%s\n", str);
#endif
    return;   
}
