#!/usr/bin/perl
#
# Library for use with slbackup (Skolelinux Backup)
#
# Content:
#  - deal with configuration files
#  - deal with log files
#
# $Id: SLBackup.pm,v 1.1 2003/11/07 21:52:02 werner-guest Exp $
#
# Most of the code in this module is copied from the
# LRRD project (http://www.linpro.no/project/lrrd/)
#
# Thanks to Linpro AS for well written perl code!
#

package SLBackup;

use Exporter;
@ISA = ('Exporter');
@EXPORT = ('slbackup_overwrite',
	   'slbackup_readconfig',
	   'slbackup_writeconfig',
	   'slbackup_config' );

use strict;
use Config::General;

my $config = undef;
my $configfile = '/etc/slbackup/slbackup.conf';
my $DEBUG = 0;


sub slbackup_readconfig {
    my ($conf, $missingok) = @_;
    $conf ||= $configfile;
    
    if (! -r $conf and ! $missingok) {
	print "slbackup_readconfig: cannot open '$conf'\n";
	return undef;
    }

    my $conffile = new Config::General($conf);
    my $config = { $conffile->getall };
    return ($config);
}


sub slbackup_writeconfig {
    my ($datafilename, $data) = @_;
    
    my $datafile = new Config::General();
    $datafile->save_file($datafilename, $data);
}


1;

__END__
