#include <windows.h>
#include "slatevm.h"
#include "image.h"
#include "file.h"

#ifndef SLATE_USE_ANSI_FILES

static HANDLE files [SLATE_FILES_MAXIMUM];
static LARGE_INTEGER liZero;

void initFileModule ()
{
	memset(files, 0, sizeof(files));
	liZero.QuadPart = 0;
}

int
allocateFile (void)
{
	int file;

	for (file = 0; file < SLATE_FILES_MAXIMUM; ++ file)
	{
		if (files [file] == 0)
			return file;
	}

	return -1;
}

void
closeFile (int file)
{
	if (files [file] != 0)
	{
		CloseHandle(files [file]);

		files [file] = 0;
	}
}

int
openFile (struct ByteArray * name, int flags)
{
	char nameString[SLATE_FILE_NAME_LENGTH];
	int nameLength = extractCString (name, nameString, sizeof(nameString));
	DWORD rwMode = 0;
	DWORD openMode = 0;
	int file;

	if (nameLength <= 0 || nameLength > MAX_PATH)
		return -1;
		
	file = allocateFile ();
	if (file < 0)
		return -1;

	if (flags & SF_WRITE)
		rwMode |= GENERIC_WRITE;
	if (flags & SF_READ)
		rwMode |= GENERIC_READ;

	openMode = ((flags & SF_CREATE) ? OPEN_ALWAYS : OPEN_EXISTING);

	files[file] = CreateFile(nameString, rwMode, FILE_SHARE_READ, 0, openMode, FILE_ATTRIBUTE_NORMAL, 0);

	if (files[file] < 0)
	{
		files[file] = 0;
		return -1;
	}

	if (flags & SF_CLEAR)
	{
		if (!SetFilePointerEx(files[file], liZero, NULL, FILE_BEGIN) || !SetEndOfFile(files[file]))
			goto failReturn;
	}

	return file;

failReturn:
	CloseHandle(files[file]);
	files[file] = 0;
	return -1;
}

int
writeFile (int file, int n, char * bytes)
{
	DWORD bytesWritten = 0;

	if (!WriteFile(files[file], bytes, n, &bytesWritten, NULL))
	{
		// TODO something failed
	}
	
	return bytesWritten;
}

int
readFile (int file, int n, char * bytes)
{
	DWORD bytesRead = 0;

	if (!ReadFile(files[file], bytes, n, &bytesRead, NULL))
	{
		// TODO something failed
	}

	return bytesRead;
}

int
sizeOfFile(int file)
{
	LARGE_INTEGER size;
	size.QuadPart = 0;

	if (GetFileSizeEx(files[file], &size))
		return size.QuadPart;
	else
		return -1;
}

int
seekFile (int file, int _offset)
{
	LARGE_INTEGER pos;
	LARGE_INTEGER offset;

	pos.QuadPart = 0;
	offset.QuadPart = _offset;

	if (!SetFilePointerEx(files[file], offset, &pos, FILE_BEGIN))
		return -1;
	
	return pos.QuadPart;
}

int
tellFile (int file)
{
	LARGE_INTEGER pos;

	pos.QuadPart = 0;

	if (SetFilePointerEx(files[file], liZero, &pos, FILE_CURRENT))
		return pos.QuadPart;
	
	return -1;
}

//TODO: Bool
int
endOfFile (int file)
{
	LARGE_INTEGER size;
	LARGE_INTEGER pos;

	size.QuadPart = 0;
	pos.QuadPart = 0;

	// seek to current position to read current position (I love M$)
	if (!SetFilePointerEx(files[file], liZero, &pos, FILE_CURRENT))
		return -1;

	if (!GetFileSizeEx(files[file], &size))
		return -1;

	return pos.QuadPart >= size.QuadPart;
}

#endif // !SLATE_USE_ANSI_FILES
