#ifndef __SLATE_DIRECTORY_H__
#define __SLATE_DIRECTORY_H__

/**
 * Directory module for Slate.
 *
 * Open issues:
 *  - character encodings for strings such as filename, directory names
 *  - weak pointers so that orphan directories can get collected
 **/

struct ByteArray;

/**
 * Initialises static storage for this module. Make sure this is only
 * called once, at the start of the program.
 **/
extern void initDirectoryModule(void);

/**
 * Takes a ByteArray containing a directory name string, allocates
 * internal resources for managing this directory pointer, and returns
 * an integer handle that can be used with other functions in this
 * module.
 *
 * Returns <0 on error - the exact value will be (-errno) for the
 * condition causing the error.
 *
 * Returns a handle >=0 on success, in which case the handle must
 * later be passed in to closeDirectory to release resources.
 **/
extern int openDirectory(struct ByteArray *dirName);

/**
 * Takes a handle returned by openDirectory and releases any
 * associated allocated resources.
 *
 * Returns 0 for success, or <0 for error (exact value is -errno).
 **/
extern int closeDirectory(int dirHandle);

/**
 * Reads the next entry from the directory handle passed in. Stores
 * the file name in entNameBuffer.
 *
 * Returns >0 for success, in which case the returned value is the
 * number of bytes stored into entNameBuffer; 0 for no more entries
 * available; or <0 for error (exact value is -errno).
 **/
extern int readDirectory(int dirHandle, struct ByteArray *entNameBuffer);

/**
 * Retrieves the current working directory from the system and stores
 * its name into wdBuffer.
 *
 * Returns >=0 for success, in which case the returned value is the
 * number of bytes stored into entNameBuffer; or <0 for error (exact
 * value is -errno).
 **/
extern int getCurrentDirectory(struct ByteArray *wdBuffer);

/**
 * Changes the current working directory of the system.
 *
 * Returns 0 for success, or <0 for error (exact value is -errno).
 **/
extern int setCurrentDirectory(struct ByteArray *newWd);

#endif /* __SLATE_DIRECTORY_H__ */
