/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to manage properties on objects
 *
 * @author Stephane MANKOWSKI
 */
#include "skgpropertiesplugin.h"
#include "skgpropertiesplugindockwidget.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include <QDockWidget>

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGPropertiesPluginFactory, registerPlugin<SKGPropertiesPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGPropertiesPluginFactory("skrooge_properties", "skrooge_properties"))

SKGPropertiesPlugin::SKGPropertiesPlugin(QObject* iParent, const QVariantList& /*iArg*/) :
                SKGInterfacePlugin(iParent), dockWidget(NULL), dockContent(NULL)
{
        SKGTRACEIN(10, "SKGPropertiesPlugin::SKGPropertiesPlugin");
}

SKGPropertiesPlugin::~SKGPropertiesPlugin()
{
        SKGTRACEIN(10, "SKGPropertiesPlugin::~SKGPropertiesPlugin");
        currentBankDocument=NULL;
        dockWidget=NULL;
        dockContent=NULL;
}

void SKGPropertiesPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGPropertiesPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;


        setComponentData( SKGPropertiesPluginFactory::componentData() );
        setXMLFile("skrooge_properties.rc");

        dockContent = new SKGPropertiesPluginDockWidget(currentBankDocument);
        if (dockContent) {
                dockWidget = new QDockWidget(SKGMainPanel::getMainPanel());
                if (dockWidget) {
                        dockWidget->setObjectName(QString::fromUtf8("skrooge_properties_docwidget"));
                        dockWidget->setAllowedAreas(Qt::LeftDockWidgetArea|Qt::RightDockWidgetArea);
                        dockWidget->setWindowTitle(title());
                        dockWidget->setWidget(dockContent);

                        // add action to control hide / display of Bookmarks
                        dockWidget->toggleViewAction()->setShortcut(Qt::SHIFT+Qt::Key_F12);
                        actionCollection()->addAction("view_properties", dockWidget->toggleViewAction());
                }
        }
}

void SKGPropertiesPlugin::refresh()
{
        SKGTRACEIN(10, "SKGPropertiesPlugin::refresh");
        if (dockContent) dockContent->refresh();
}

void SKGPropertiesPlugin::close()
{
        SKGTRACEIN(10, "SKGPropertiesPlugin::close");
}

QDockWidget* SKGPropertiesPlugin::getDockWidget()
{
        return dockWidget;
}

QString SKGPropertiesPlugin::title() const
{
        return i18nc("Noun, an item's properties","Properties");
}

QString SKGPropertiesPlugin::icon() const
{
        return "dialog-information";
}

QString SKGPropertiesPlugin::toolTip () const
{
        return i18nc("A tool tip", "Properties management");
}

int SKGPropertiesPlugin::getOrder() const
{
        return 6;
}

QStringList SKGPropertiesPlugin::tips() const
{
        QStringList output;
        output.push_back(i18nc("Description of a tips", "<p>... you can manage properties on all objects (operations, accounts, etc.)</p>"));
        return output;
}

bool SKGPropertiesPlugin::isInContext() const
{
        return false;
}

#include "skgpropertiesplugin.moc"
